/* Controller.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Controller.vala, do not modify */

/*
* Copyright 2013-2017 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Julien Spautz <spautz.julien@gmail.com>
*/

#include "applications.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <gee.h>

#define STARTUP_CONTROLLER_APPLICATION_DIRS "applications"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	STARTUP_CONTROLLER_0_PROPERTY,
	STARTUP_CONTROLLER_VIEW_PROPERTY,
	STARTUP_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* startup_controller_properties[STARTUP_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR (startup_backend_desktop_file_enumerator_get_type ())
#define STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumerator))
#define STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumeratorClass))
#define STARTUP_BACKEND_IS_DESKTOP_FILE_ENUMERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR))
#define STARTUP_BACKEND_IS_DESKTOP_FILE_ENUMERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR))
#define STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumeratorClass))

typedef struct _StartupBackendDesktopFileEnumerator StartupBackendDesktopFileEnumerator;
typedef struct _StartupBackendDesktopFileEnumeratorClass StartupBackendDesktopFileEnumeratorClass;

struct _StartupControllerPrivate {
	StartupPlug* _view;
};

static gint StartupController_private_offset;
static gpointer startup_controller_parent_class = NULL;

static gchar** startup_controller_get_application_files (StartupController* self,
                                                  gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GType startup_backend_desktop_file_enumerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StartupBackendDesktopFileEnumerator* startup_backend_desktop_file_enumerator_new (gchar** dirs,
                                                                                  gint dirs_length1);
VALA_EXTERN StartupBackendDesktopFileEnumerator* startup_backend_desktop_file_enumerator_construct (GType object_type,
                                                                                        gchar** dirs,
                                                                                        gint dirs_length1);
VALA_EXTERN gchar** startup_backend_desktop_file_enumerator_get_desktop_files (StartupBackendDesktopFileEnumerator* self,
                                                                   gint* result_length1);
static gchar** startup_controller_get_auto_start_files (StartupController* self,
                                                 gint* result_length1);
static GObject * startup_controller_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN StartupBackendKeyFile* startup_backend_key_file_factory_get_or_create (const gchar* path);
static void startup_controller_finalize (GObject * obj);
static GType startup_controller_get_type_once (void);
static void _vala_startup_controller_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_startup_controller_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
startup_controller_get_instance_private (StartupController* self)
{
	return G_STRUCT_MEMBER_P (self, StartupController_private_offset);
}

StartupController*
startup_controller_construct (GType object_type,
                              StartupPlug* view)
{
	StartupController * self = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (StartupController*) g_object_new (object_type, "view", view, NULL);
	return self;
}

StartupController*
startup_controller_new (StartupPlug* view)
{
	return startup_controller_construct (STARTUP_TYPE_CONTROLLER, view);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
startup_controller_get_application_files (StartupController* self,
                                          gint* result_length1)
{
	gchar** app_dirs = NULL;
	gchar** _tmp0_;
	gint app_dirs_length1;
	gint _app_dirs_size_;
	gchar** data_dirs = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	StartupBackendDesktopFileEnumerator* enumerator = NULL;
	gchar** _tmp13_;
	gint _tmp13__length1;
	StartupBackendDesktopFileEnumerator* _tmp14_;
	gint _tmp15_ = 0;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	app_dirs = _tmp0_;
	app_dirs_length1 = 0;
	_app_dirs_size_ = app_dirs_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _vala_array_length (_tmp1_)) : _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	data_dirs = _tmp3_;
	data_dirs_length1 = _tmp3__length1;
	_data_dirs_size_ = data_dirs_length1;
	_tmp4_ = g_get_user_data_dir ();
	_tmp5_ = g_strdup (_tmp4_);
	_vala_array_add1 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp5_);
	_tmp6_ = data_dirs;
	_tmp6__length1 = data_dirs_length1;
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp6_;
		data_dir_collection_length1 = _tmp6__length1;
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				gchar* app_dir = NULL;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = data_dir;
				_tmp8_ = g_build_filename (_tmp7_, STARTUP_CONTROLLER_APPLICATION_DIRS, NULL);
				app_dir = _tmp8_;
				_tmp9_ = app_dir;
				if (g_file_test (_tmp9_, G_FILE_TEST_EXISTS)) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = app_dir;
					_tmp11_ = g_strdup (_tmp10_);
					_vala_array_add2 (&app_dirs, &app_dirs_length1, &_app_dirs_size_, _tmp11_);
				}
				_g_free0 (app_dir);
			}
		}
	}
	_tmp12_ = app_dirs;
	_tmp12__length1 = app_dirs_length1;
	if (_tmp12__length1 == 0) {
		g_warning ("Controller.vala:63: No application directories found");
	}
	_tmp13_ = app_dirs;
	_tmp13__length1 = app_dirs_length1;
	_tmp14_ = startup_backend_desktop_file_enumerator_new (_tmp13_, _tmp13__length1);
	enumerator = _tmp14_;
	_tmp16_ = startup_backend_desktop_file_enumerator_get_desktop_files (enumerator, &_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp15_;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	_g_object_unref0 (enumerator);
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	app_dirs = (_vala_array_free (app_dirs, app_dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar**
startup_controller_get_auto_start_files (StartupController* self,
                                         gint* result_length1)
{
	gchar* startup_dir = NULL;
	gchar* _tmp0_;
	StartupBackendDesktopFileEnumerator* enumerator = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	StartupBackendDesktopFileEnumerator* _tmp4_;
	StartupBackendDesktopFileEnumerator* _tmp5_;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = startup_utils_get_user_startup_dir ();
	startup_dir = _tmp0_;
	_tmp1_ = g_strdup (startup_dir);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = startup_backend_desktop_file_enumerator_new (_tmp3_, 1);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	enumerator = _tmp5_;
	_tmp7_ = startup_backend_desktop_file_enumerator_get_desktop_files (enumerator, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	_g_object_unref0 (enumerator);
	_g_free0 (startup_dir);
	return result;
}

StartupPlug*
startup_controller_get_view (StartupController* self)
{
	StartupPlug* result;
	StartupPlug* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
startup_controller_set_view (StartupController* self,
                             StartupPlug* value)
{
	StartupPlug* old_value;
	g_return_if_fail (self != NULL);
	old_value = startup_controller_get_view (self);
	if (old_value != value) {
		StartupPlug* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, startup_controller_properties[STARTUP_CONTROLLER_VIEW_PROPERTY]);
	}
}

static GObject *
startup_controller_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	StartupController * self;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	GeeArrayList* app_infos = NULL;
	GeeArrayList* _tmp9_;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	StartupPlug* _tmp22_;
	GeeArrayList* _tmp23_;
	parent_class = G_OBJECT_CLASS (startup_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_TYPE_CONTROLLER, StartupController);
	_tmp1_ = startup_controller_get_auto_start_files (self, &_tmp0_);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp1_;
		path_collection_length1 = _tmp0_;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				StartupBackendKeyFile* key_file = NULL;
				const gchar* _tmp2_;
				StartupBackendKeyFile* _tmp3_;
				StartupBackendKeyFile* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				_tmp2_ = path;
				_tmp3_ = startup_backend_key_file_factory_get_or_create (_tmp2_);
				key_file = _tmp3_;
				_tmp4_ = key_file;
				_tmp5_ = startup_backend_key_file_get_show (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					StartupPlug* _tmp7_;
					StartupBackendKeyFile* _tmp8_;
					_tmp7_ = self->priv->_view;
					_tmp8_ = key_file;
					startup_plug_add_app (_tmp7_, _tmp8_);
				}
				_g_object_unref0 (key_file);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp9_ = gee_array_list_new (STARTUP_ENTITY_TYPE_APP_INFO, (GBoxedCopyFunc) startup_entity_app_info_dup, (GDestroyNotify) startup_entity_app_info_free, NULL, NULL, NULL);
	app_infos = _tmp9_;
	_tmp11_ = startup_controller_get_application_files (self, &_tmp10_);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp11_;
		path_collection_length1 = _tmp10_;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				StartupBackendKeyFile* key_file = NULL;
				const gchar* _tmp12_;
				StartupBackendKeyFile* _tmp13_;
				StartupBackendKeyFile* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp12_ = path;
				_tmp13_ = startup_backend_key_file_factory_get_or_create (_tmp12_);
				key_file = _tmp13_;
				_tmp14_ = key_file;
				_tmp15_ = startup_backend_key_file_get_show (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					GeeArrayList* _tmp17_;
					StartupBackendKeyFile* _tmp18_;
					StartupEntityAppInfo _tmp19_ = {0};
					StartupEntityAppInfo _tmp20_;
					StartupEntityAppInfo _tmp21_;
					_tmp17_ = app_infos;
					_tmp18_ = key_file;
					startup_backend_key_file_create_app_info (_tmp18_, &_tmp19_);
					_tmp20_ = _tmp19_;
					_tmp21_ = _tmp20_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, &_tmp21_);
					startup_entity_app_info_destroy (&_tmp20_);
				}
				_g_object_unref0 (key_file);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp22_ = self->priv->_view;
	_tmp23_ = app_infos;
	startup_plug_init_app_chooser (_tmp22_, (GeeCollection*) _tmp23_);
	_g_object_unref0 (app_infos);
	return obj;
}

static void
startup_controller_class_init (StartupControllerClass * klass,
                               gpointer klass_data)
{
	startup_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StartupController_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_startup_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_startup_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = startup_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = startup_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STARTUP_CONTROLLER_VIEW_PROPERTY, startup_controller_properties[STARTUP_CONTROLLER_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", STARTUP_TYPE_PLUG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
startup_controller_instance_init (StartupController * self,
                                  gpointer klass)
{
	self->priv = startup_controller_get_instance_private (self);
}

static void
startup_controller_finalize (GObject * obj)
{
	StartupController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_TYPE_CONTROLLER, StartupController);
	_g_object_unref0 (self->priv->_view);
	G_OBJECT_CLASS (startup_controller_parent_class)->finalize (obj);
}

static GType
startup_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StartupControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) startup_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartupController), 0, (GInstanceInitFunc) startup_controller_instance_init, NULL };
	GType startup_controller_type_id;
	startup_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "StartupController", &g_define_type_info, 0);
	StartupController_private_offset = g_type_add_instance_private (startup_controller_type_id, sizeof (StartupControllerPrivate));
	return startup_controller_type_id;
}

GType
startup_controller_get_type (void)
{
	static volatile gsize startup_controller_type_id__once = 0;
	if (g_once_init_enter (&startup_controller_type_id__once)) {
		GType startup_controller_type_id;
		startup_controller_type_id = startup_controller_get_type_once ();
		g_once_init_leave (&startup_controller_type_id__once, startup_controller_type_id);
	}
	return startup_controller_type_id__once;
}

static void
_vala_startup_controller_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	StartupController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STARTUP_TYPE_CONTROLLER, StartupController);
	switch (property_id) {
		case STARTUP_CONTROLLER_VIEW_PROPERTY:
		g_value_set_object (value, startup_controller_get_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_startup_controller_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	StartupController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STARTUP_TYPE_CONTROLLER, StartupController);
	switch (property_id) {
		case STARTUP_CONTROLLER_VIEW_PROPERTY:
		startup_controller_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

