/* ImageItem.c generated by valac 0.56.18, the Vala compiler
 * generated from ImageItem.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>

#define SPICE_IMAGE_ITEM_IMAGE_STYLE_CSS "\n" \
"        .colored {\n" \
"            background-color: transparent;\n" \
"            background-image: url(\"%s\");\n" \
"            background-position: center;\n" \
"            background-size: contain;\n" \
"            background-repeat: no-repeat;\n" \
"            border: none;\n" \
"        }\n" \
"    "
#define SPICE_IMAGE_ITEM_IMAGE_MISSING_CSS "\n" \
"        .colored {\n" \
"           border: 4px dashed #000000;\n" \
"           border-color: #c92e34;\n" \
"        }"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
typedef struct _SpiceCanvasItemPrivate SpiceCanvasItemPrivate;

#define SPICE_TYPE_IMAGE_ITEM (spice_image_item_get_type ())
#define SPICE_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItem))
#define SPICE_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))
#define SPICE_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))

typedef struct _SpiceImageItem SpiceImageItem;
typedef struct _SpiceImageItemClass SpiceImageItemClass;
typedef struct _SpiceImageItemPrivate SpiceImageItemPrivate;

#define SPICE_TYPE_IMAGE_HANDLER (spice_image_handler_get_type ())
#define SPICE_IMAGE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandler))
#define SPICE_IMAGE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandlerClass))
#define SPICE_IS_IMAGE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_HANDLER))
#define SPICE_IS_IMAGE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_HANDLER))
#define SPICE_IMAGE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandlerClass))

typedef struct _SpiceImageHandler SpiceImageHandler;
typedef struct _SpiceImageHandlerClass SpiceImageHandlerClass;
enum  {
	SPICE_IMAGE_ITEM_0_PROPERTY,
	SPICE_IMAGE_ITEM_IMAGE_PROPERTY,
	SPICE_IMAGE_ITEM_EXTENSION_PROPERTY,
	SPICE_IMAGE_ITEM_URL_PROPERTY,
	SPICE_IMAGE_ITEM_NUM_PROPERTIES
};
static GParamSpec* spice_image_item_properties[SPICE_IMAGE_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SpiceImageHandlerPrivate SpiceImageHandlerPrivate;

struct _SpiceCanvasItem {
	GtkEventBox parent_instance;
	SpiceCanvasItemPrivate * priv;
	gdouble start_x;
	gdouble start_y;
	gint start_w;
	gint start_h;
	gboolean holding;
	gint holding_id;
	gint real_width;
	gint real_height;
	gint real_x;
	gint real_y;
	GtkGrid* grid;
	GtkRevealer* grabber_revealer;
};

struct _SpiceCanvasItemClass {
	GtkEventBoxClass parent_class;
	gchar* (*serialise_item) (SpiceCanvasItem* self);
	void (*load_item_data) (SpiceCanvasItem* self);
	void (*style) (SpiceCanvasItem* self);
};

struct _SpiceImageItem {
	SpiceCanvasItem parent_instance;
	SpiceImageItemPrivate * priv;
};

struct _SpiceImageItemClass {
	SpiceCanvasItemClass parent_class;
};

struct _SpiceImageItemPrivate {
	SpiceImageHandler* _image;
};

struct _SpiceImageHandler {
	GObject parent_instance;
	SpiceImageHandlerPrivate * priv;
	gboolean valid;
};

struct _SpiceImageHandlerClass {
	GObjectClass parent_class;
};

static gint SpiceImageItem_private_offset;
static gpointer spice_image_item_parent_class = NULL;

VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN GType spice_image_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageItem, g_object_unref)
VALA_EXTERN GType spice_image_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageHandler, g_object_unref)
VALA_EXTERN void spice_canvas_item_load_item_data (SpiceCanvasItem* self);
VALA_EXTERN gchar* spice_canvas_item_serialise_item (SpiceCanvasItem* self);
VALA_EXTERN void spice_canvas_item_style (SpiceCanvasItem* self);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN SpiceImageItem* spice_image_item_new (SpiceCanvas* _canvas,
                                      JsonObject* _save_data);
VALA_EXTERN SpiceImageItem* spice_image_item_construct (GType object_type,
                                            SpiceCanvas* _canvas,
                                            JsonObject* _save_data);
VALA_EXTERN void spice_canvas_item_load_data (SpiceCanvasItem* self);
VALA_EXTERN SpiceCanvas* spice_canvas_item_get_canvas (SpiceCanvasItem* self);
VALA_EXTERN SpiceImageItem* spice_image_item_new_from_file (SpiceCanvas* _canvas,
                                                GFile* file);
VALA_EXTERN SpiceImageItem* spice_image_item_construct_from_file (GType object_type,
                                                      SpiceCanvas* _canvas,
                                                      GFile* file);
VALA_EXTERN SpiceImageHandler* spice_image_handler_new_from_file (GFile* file);
VALA_EXTERN SpiceImageHandler* spice_image_handler_construct_from_file (GType object_type,
                                                            GFile* file);
static void spice_image_item_set_image (SpiceImageItem* self,
                                 SpiceImageHandler* value);
static void spice_image_item_connect_image (SpiceImageItem* self);
VALA_EXTERN SpiceImageItem* spice_image_item_new_from_data (SpiceCanvas* _canvas,
                                                const gchar* base64_image,
                                                const gchar* extension);
VALA_EXTERN SpiceImageItem* spice_image_item_construct_from_data (GType object_type,
                                                      SpiceCanvas* _canvas,
                                                      const gchar* base64_image,
                                                      const gchar* extension);
VALA_EXTERN SpiceImageHandler* spice_image_handler_new_from_data (const gchar* _extension,
                                                      const gchar* _base64_data);
VALA_EXTERN SpiceImageHandler* spice_image_handler_construct_from_data (GType object_type,
                                                            const gchar* _extension,
                                                            const gchar* _base64_data);
static void spice_image_item_real_load_item_data (SpiceCanvasItem* base);
VALA_EXTERN JsonObject* spice_canvas_item_get_save_data (SpiceCanvasItem* self);
static gchar* spice_image_item_real_serialise_item (SpiceCanvasItem* base);
VALA_EXTERN SpiceImageHandler* spice_image_item_get_image (SpiceImageItem* self);
VALA_EXTERN gchar* spice_image_handler_serialize (SpiceImageHandler* self);
static void spice_image_item_real_style (SpiceCanvasItem* base);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
VALA_EXTERN const gchar* spice_image_handler_get_url (SpiceImageHandler* self);
static void spice_image_item_unstyle (SpiceImageItem* self);
static void __lambda22_ (SpiceImageItem* self);
static void ___lambda22__spice_image_handler_file_changed (SpiceImageHandler* _sender,
                                                    gpointer self);
VALA_EXTERN const gchar* spice_image_item_get_extension (SpiceImageItem* self);
VALA_EXTERN const gchar* spice_image_handler_get_image_extension (SpiceImageHandler* self);
VALA_EXTERN const gchar* spice_image_item_get_url (SpiceImageItem* self);
static void spice_image_item_finalize (GObject * obj);
static GType spice_image_item_get_type_once (void);
static void _vala_spice_image_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_spice_image_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
spice_image_item_get_instance_private (SpiceImageItem* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceImageItem_private_offset);
}

SpiceImageItem*
spice_image_item_construct (GType object_type,
                            SpiceCanvas* _canvas,
                            JsonObject* _save_data)
{
	SpiceImageItem * self = NULL;
	SpiceCanvas* _tmp0_;
	SpiceCanvas* _tmp1_;
#line 55 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = (SpiceImageItem*) g_object_new (object_type, "canvas", _canvas, "save-data", _save_data, NULL);
#line 57 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_canvas_item_load_data ((SpiceCanvasItem*) self);
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = _tmp0_;
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (_tmp1_ != NULL) {
#line 59 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_canvas_item_style ((SpiceCanvasItem*) self);
#line 253 "ImageItem.c"
	}
#line 54 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return self;
#line 257 "ImageItem.c"
}

SpiceImageItem*
spice_image_item_new (SpiceCanvas* _canvas,
                      JsonObject* _save_data)
{
#line 54 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return spice_image_item_construct (SPICE_TYPE_IMAGE_ITEM, _canvas, _save_data);
#line 266 "ImageItem.c"
}

SpiceImageItem*
spice_image_item_construct_from_file (GType object_type,
                                      SpiceCanvas* _canvas,
                                      GFile* file)
{
	SpiceImageItem * self = NULL;
	SpiceImageHandler* _tmp0_;
	SpiceImageHandler* _tmp1_;
	SpiceCanvas* _tmp2_;
	SpiceCanvas* _tmp3_;
#line 62 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 63 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = (SpiceImageItem*) g_object_new (object_type, "canvas", _canvas, "save-data", NULL, NULL);
#line 65 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = spice_image_handler_new_from_file (file);
#line 65 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = _tmp0_;
#line 65 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_set_image (self, _tmp1_);
#line 65 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_g_object_unref0 (_tmp1_);
#line 66 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_connect_image (self);
#line 68 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp2_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 68 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp3_ = _tmp2_;
#line 68 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (_tmp3_ != NULL) {
#line 68 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_canvas_item_style ((SpiceCanvasItem*) self);
#line 301 "ImageItem.c"
	}
#line 62 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return self;
#line 305 "ImageItem.c"
}

SpiceImageItem*
spice_image_item_new_from_file (SpiceCanvas* _canvas,
                                GFile* file)
{
#line 62 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return spice_image_item_construct_from_file (SPICE_TYPE_IMAGE_ITEM, _canvas, file);
#line 314 "ImageItem.c"
}

SpiceImageItem*
spice_image_item_construct_from_data (GType object_type,
                                      SpiceCanvas* _canvas,
                                      const gchar* base64_image,
                                      const gchar* extension)
{
	SpiceImageItem * self = NULL;
	SpiceImageHandler* _tmp0_;
	SpiceImageHandler* _tmp1_;
	SpiceCanvas* _tmp2_;
	SpiceCanvas* _tmp3_;
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_val_if_fail (base64_image != NULL, NULL);
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 72 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = (SpiceImageItem*) g_object_new (object_type, "canvas", _canvas, "save-data", NULL, NULL);
#line 74 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = spice_image_handler_new_from_data (extension, base64_image);
#line 74 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = _tmp0_;
#line 74 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_set_image (self, _tmp1_);
#line 74 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_g_object_unref0 (_tmp1_);
#line 75 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_connect_image (self);
#line 77 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp2_ = spice_canvas_item_get_canvas ((SpiceCanvasItem*) self);
#line 77 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp3_ = _tmp2_;
#line 77 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (_tmp3_ != NULL) {
#line 77 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_canvas_item_style ((SpiceCanvasItem*) self);
#line 352 "ImageItem.c"
	}
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return self;
#line 356 "ImageItem.c"
}

SpiceImageItem*
spice_image_item_new_from_data (SpiceCanvas* _canvas,
                                const gchar* base64_image,
                                const gchar* extension)
{
#line 71 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return spice_image_item_construct_from_data (SPICE_TYPE_IMAGE_ITEM, _canvas, base64_image, extension);
#line 366 "ImageItem.c"
}

static void
spice_image_item_real_load_item_data (SpiceCanvasItem* base)
{
	SpiceImageItem * self;
	gchar* base64_image = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
#line 80 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = (SpiceImageItem*) base;
#line 81 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	base64_image = NULL;
#line 83 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 83 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = _tmp0_;
#line 83 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (json_object_has_member (_tmp1_, "image-data")) {
#line 388 "ImageItem.c"
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp2_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp3_ = _tmp2_;
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp4_ = json_object_get_string_member (_tmp3_, "image-data");
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_free0 (base64_image);
#line 84 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		base64_image = _tmp5_;
#line 405 "ImageItem.c"
	}
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp7_ = base64_image;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (_tmp7_ != NULL) {
#line 411 "ImageItem.c"
		const gchar* _tmp8_;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp8_ = base64_image;
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
#line 417 "ImageItem.c"
	} else {
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp6_ = FALSE;
#line 421 "ImageItem.c"
	}
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (_tmp6_) {
#line 425 "ImageItem.c"
		gchar* extension = NULL;
		JsonObject* _tmp9_;
		JsonObject* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		SpiceImageHandler* _tmp15_;
		SpiceImageHandler* _tmp16_;
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp9_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp10_ = _tmp9_;
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp11_ = json_object_get_string_member (_tmp10_, "image");
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp12_ = g_strdup (_tmp11_);
#line 88 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		extension = _tmp12_;
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp13_ = extension;
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp14_ = base64_image;
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp15_ = spice_image_handler_new_from_data (_tmp13_, _tmp14_);
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp16_ = _tmp15_;
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_image_item_set_image (self, _tmp16_);
#line 89 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_object_unref0 (_tmp16_);
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_free0 (extension);
#line 459 "ImageItem.c"
	} else {
		gchar* tmp_uri = NULL;
		JsonObject* _tmp17_;
		JsonObject* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		SpiceImageHandler* _tmp24_;
		SpiceImageHandler* _tmp25_;
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp17_ = spice_canvas_item_get_save_data ((SpiceCanvasItem*) self);
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp18_ = _tmp17_;
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp19_ = json_object_get_string_member (_tmp18_, "image");
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 91 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		tmp_uri = _tmp20_;
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp21_ = tmp_uri;
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp22_ = g_file_new_for_uri (_tmp21_);
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp23_ = _tmp22_;
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp24_ = spice_image_handler_new_from_file (_tmp23_);
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp25_ = _tmp24_;
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_image_item_set_image (self, _tmp25_);
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_object_unref0 (_tmp25_);
#line 92 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_object_unref0 (_tmp23_);
#line 87 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_free0 (tmp_uri);
#line 499 "ImageItem.c"
	}
#line 95 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_connect_image (self);
#line 80 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_g_free0 (base64_image);
#line 505 "ImageItem.c"
}

static gchar*
spice_image_item_real_serialise_item (SpiceCanvasItem* base)
{
	SpiceImageItem * self;
	SpiceImageHandler* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 98 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = (SpiceImageItem*) base;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = self->priv->_image;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = spice_image_handler_serialize (_tmp0_);
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp2_ = _tmp1_;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp3_ = g_strdup_printf ("\"type\":\"image\", %s", _tmp2_);
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp4_ = _tmp3_;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_g_free0 (_tmp2_);
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	result = _tmp4_;
#line 99 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return result;
#line 536 "ImageItem.c"
}

static void
spice_image_item_real_style (SpiceCanvasItem* base)
{
	SpiceImageItem * self;
	SpiceImageHandler* _tmp0_;
#line 102 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = (SpiceImageItem*) base;
#line 103 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = self->priv->_image;
#line 103 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (_tmp0_->valid) {
#line 550 "ImageItem.c"
		SpiceImageHandler* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp1_ = self->priv->_image;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp2_ = spice_image_handler_get_url (_tmp1_);
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp3_ = _tmp2_;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp4_ = g_strdup_printf (SPICE_IMAGE_ITEM_IMAGE_STYLE_CSS, _tmp3_);
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp5_ = _tmp4_;
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_utils_set_style ((GtkWidget*) self, _tmp5_);
#line 104 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_free0 (_tmp5_);
#line 570 "ImageItem.c"
	} else {
#line 106 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_image_item_unstyle (self);
#line 574 "ImageItem.c"
	}
}

static void
spice_image_item_unstyle (SpiceImageItem* self)
{
#line 110 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_if_fail (self != NULL);
#line 111 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_utils_set_style ((GtkWidget*) self, SPICE_IMAGE_ITEM_IMAGE_MISSING_CSS);
#line 585 "ImageItem.c"
}

static void
__lambda22_ (SpiceImageItem* self)
{
#line 116 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_unstyle (self);
#line 117 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_canvas_item_style ((SpiceCanvasItem*) self);
#line 595 "ImageItem.c"
}

static void
___lambda22__spice_image_handler_file_changed (SpiceImageHandler* _sender,
                                               gpointer self)
{
#line 115 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	__lambda22_ ((SpiceImageItem*) self);
#line 604 "ImageItem.c"
}

static void
spice_image_item_connect_image (SpiceImageItem* self)
{
	SpiceImageHandler* _tmp0_;
#line 114 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_if_fail (self != NULL);
#line 115 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = self->priv->_image;
#line 115 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_signal_connect_object (_tmp0_, "file-changed", (GCallback) ___lambda22__spice_image_handler_file_changed, self, 0);
#line 617 "ImageItem.c"
}

SpiceImageHandler*
spice_image_item_get_image (SpiceImageItem* self)
{
	SpiceImageHandler* result;
	SpiceImageHandler* _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = self->priv->_image;
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	result = _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return result;
#line 633 "ImageItem.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 641 "ImageItem.c"
}

static void
spice_image_item_set_image (SpiceImageItem* self,
                            SpiceImageHandler* value)
{
	SpiceImageHandler* old_value;
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_if_fail (self != NULL);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	old_value = spice_image_item_get_image (self);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	if (old_value != value) {
#line 655 "ImageItem.c"
		SpiceImageHandler* _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		_g_object_unref0 (self->priv->_image);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		self->priv->_image = _tmp0_;
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_image_item_properties[SPICE_IMAGE_ITEM_IMAGE_PROPERTY]);
#line 665 "ImageItem.c"
	}
}

const gchar*
spice_image_item_get_extension (SpiceImageItem* self)
{
	const gchar* result;
	SpiceImageHandler* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 43 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = self->priv->_image;
#line 44 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = spice_image_handler_get_image_extension (_tmp0_);
#line 44 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp2_ = _tmp1_;
#line 44 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	result = _tmp2_;
#line 44 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return result;
#line 688 "ImageItem.c"
}

const gchar*
spice_image_item_get_url (SpiceImageItem* self)
{
	const gchar* result;
	SpiceImageHandler* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 49 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp0_ = self->priv->_image;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp1_ = spice_image_handler_get_url (_tmp0_);
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_tmp2_ = _tmp1_;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	result = _tmp2_;
#line 50 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	return result;
#line 710 "ImageItem.c"
}

static void
spice_image_item_class_init (SpiceImageItemClass * klass,
                             gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	spice_image_item_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_type_class_adjust_private_offset (klass, &SpiceImageItem_private_offset);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	((SpiceCanvasItemClass *) klass)->load_item_data = (void (*) (SpiceCanvasItem*)) spice_image_item_real_load_item_data;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	((SpiceCanvasItemClass *) klass)->serialise_item = (gchar* (*) (SpiceCanvasItem*)) spice_image_item_real_serialise_item;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	((SpiceCanvasItemClass *) klass)->style = (void (*) (SpiceCanvasItem*)) spice_image_item_real_style;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_image_item_get_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_image_item_set_property;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_image_item_finalize;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_IMAGE_ITEM_IMAGE_PROPERTY, spice_image_item_properties[SPICE_IMAGE_ITEM_IMAGE_PROPERTY] = g_param_spec_object ("image", "image", "image", SPICE_TYPE_IMAGE_HANDLER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_IMAGE_ITEM_EXTENSION_PROPERTY, spice_image_item_properties[SPICE_IMAGE_ITEM_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_IMAGE_ITEM_URL_PROPERTY, spice_image_item_properties[SPICE_IMAGE_ITEM_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 739 "ImageItem.c"
}

static void
spice_image_item_instance_init (SpiceImageItem * self,
                                gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self->priv = spice_image_item_get_instance_private (self);
#line 748 "ImageItem.c"
}

static void
spice_image_item_finalize (GObject * obj)
{
	SpiceImageItem * self;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_IMAGE_ITEM, SpiceImageItem);
#line 23 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	_g_object_unref0 (self->priv->_image);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	G_OBJECT_CLASS (spice_image_item_parent_class)->finalize (obj);
#line 761 "ImageItem.c"
}

static GType
spice_image_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceImageItem), 0, (GInstanceInitFunc) spice_image_item_instance_init, NULL };
	GType spice_image_item_type_id;
	spice_image_item_type_id = g_type_register_static (SPICE_TYPE_CANVAS_ITEM, "SpiceImageItem", &g_define_type_info, 0);
	SpiceImageItem_private_offset = g_type_add_instance_private (spice_image_item_type_id, sizeof (SpiceImageItemPrivate));
	return spice_image_item_type_id;
}

GType
spice_image_item_get_type (void)
{
	static volatile gsize spice_image_item_type_id__once = 0;
	if (g_once_init_enter (&spice_image_item_type_id__once)) {
		GType spice_image_item_type_id;
		spice_image_item_type_id = spice_image_item_get_type_once ();
		g_once_init_leave (&spice_image_item_type_id__once, spice_image_item_type_id);
	}
	return spice_image_item_type_id__once;
}

static void
_vala_spice_image_item_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SpiceImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_IMAGE_ITEM, SpiceImageItem);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		case SPICE_IMAGE_ITEM_IMAGE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		g_value_set_object (value, spice_image_item_get_image (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		case SPICE_IMAGE_ITEM_EXTENSION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		g_value_set_string (value, spice_image_item_get_extension (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		case SPICE_IMAGE_ITEM_URL_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		g_value_set_string (value, spice_image_item_get_url (self));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		break;
#line 814 "ImageItem.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		break;
#line 820 "ImageItem.c"
	}
}

static void
_vala_spice_image_item_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SpiceImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_IMAGE_ITEM, SpiceImageItem);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		case SPICE_IMAGE_ITEM_IMAGE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		spice_image_item_set_image (self, g_value_get_object (value));
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		break;
#line 840 "ImageItem.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Widgets/CanvasItems/ImageItem.vala"
		break;
#line 846 "ImageItem.c"
	}
}

