/* Slide.c generated by valac 0.56.18, the Vala compiler
 * generated from Slide.vala, do not modify */

/*
* Copyright (c) 2016 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <granite.h>

#define SPICE_SLIDE_EMPTY_SLIDE "{\"background-color\":\"#000000\", \"background-pattern\":\"\" , \"ite" \
"ms\": [{\"x\": 0,\"y\": 0,\"w\": 720,\"h\": 510, \"type\": \"color\", " \
"\"background_color\": \"#000000\", \"border-radius\": 0 }], \"notes\":" \
"\"\", \"preview\": \"iVBORw0KGgoAAAANSUhEUgAAAQsAAACWCAYAAADJ2q17AAAAB" \
"mJLR0QA/wD/AP+gvaeTAAACM0lEQVR4nO3UMWpbURQAUd3Hlwpt1qndxztOVOjDcx8ITCc" \
"ZzlnBVDNrrY/jOL5m5n4B+Mfe+3Ge5+fcbrc/z+fzvvd+dRPwhmbmcr1e/66ZMQrgv/bel" \
"5m5r1eHAD+DWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQC" \
"JWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJW" \
"QCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQC" \
"JWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJW" \
"QCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQC" \
"JWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJW" \
"QCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQC" \
"JWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJWQCJW" \
"QCJWQCJWQCJWQCJWQCJWQCJWQDJ2ns/ZubVHcCbmpnL3vsxa61fx3H8npn7q6OA97P3fpz" \
"n+fkNRKooH6vPau0AAAAASUVORK5CYII=\"}"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;
typedef struct _SpiceSlidePrivate SpiceSlidePrivate;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;
enum  {
	SPICE_SLIDE_0_PROPERTY,
	SPICE_SLIDE_PREVIEW_DATA_PROPERTY,
	SPICE_SLIDE_NOTES_PROPERTY,
	SPICE_SLIDE_TRANSITION_PROPERTY,
	SPICE_SLIDE_VISIBLE_PROPERTY,
	SPICE_SLIDE_NUM_PROPERTIES
};
static GParamSpec* spice_slide_properties[SPICE_SLIDE_NUM_PROPERTIES];
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _SpiceCanvasPrivate SpiceCanvasPrivate;

#define SPICE_CANVAS_TYPE_CANVAS_GRID (spice_canvas_canvas_grid_get_type ())
#define SPICE_CANVAS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGrid))
#define SPICE_CANVAS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))
#define SPICE_CANVAS_IS_CANVAS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_IS_CANVAS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_CANVAS_TYPE_CANVAS_GRID))
#define SPICE_CANVAS_CANVAS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_CANVAS_TYPE_CANVAS_GRID, SpiceCanvasCanvasGridClass))

typedef struct _SpiceCanvasCanvasGrid SpiceCanvasCanvasGrid;
typedef struct _SpiceCanvasCanvasGridClass SpiceCanvasCanvasGridClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION (spice_services_history_manager_history_action_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryAction))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_IS_HISTORY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION))
#define SPICE_SERVICES_HISTORY_MANAGER_HISTORY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_HISTORY_MANAGER_TYPE_HISTORY_ACTION, SpiceServicesHistoryManagerHistoryActionClass))

typedef struct _SpiceServicesHistoryManagerHistoryAction SpiceServicesHistoryManagerHistoryAction;
typedef struct _SpiceServicesHistoryManagerHistoryActionClass SpiceServicesHistoryManagerHistoryActionClass;

#define SPICE_SERVICES_TYPE_HISTORY_MANAGER (spice_services_history_manager_get_type ())
#define SPICE_SERVICES_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManager))
#define SPICE_SERVICES_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))
#define SPICE_SERVICES_IS_HISTORY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_IS_HISTORY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_HISTORY_MANAGER))
#define SPICE_SERVICES_HISTORY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_HISTORY_MANAGER, SpiceServicesHistoryManagerClass))

typedef struct _SpiceServicesHistoryManager SpiceServicesHistoryManager;
typedef struct _SpiceServicesHistoryManagerClass SpiceServicesHistoryManagerClass;
enum  {
	SPICE_SLIDE_VISIBLE_CHANGED_SIGNAL,
	SPICE_SLIDE_NUM_SIGNALS
};
static guint spice_slide_signals[SPICE_SLIDE_NUM_SIGNALS] = {0};

struct _SpiceSlide {
	GObject parent_instance;
	SpiceSlidePrivate * priv;
	JsonObject* save_data;
	SpiceCanvas* canvas;
	GtkImage* preview;
};

struct _SpiceSlideClass {
	GObjectClass parent_class;
};

struct _SpiceSlidePrivate {
	gchar* _preview_data;
	gchar* _notes;
	GtkStackTransitionType _transition;
	gboolean visible_;
};

struct _SpiceCanvas {
	GtkOverlay parent_instance;
	SpiceCanvasPrivate * priv;
	SpiceWindow* window;
	gdouble current_allocated_width;
	gdouble current_allocated_height;
	SpiceCanvasCanvasGrid* grid;
	JsonObject* save_data;
	GraniteDrawingBufferSurface* surface;
};

struct _SpiceCanvasClass {
	GtkOverlayClass parent_class;
};

static gint SpiceSlide_private_offset;
static gpointer spice_slide_parent_class = NULL;
VALA_EXTERN gint spice_slide_list_WIDTH;
VALA_EXTERN gint spice_slide_list_HEIGHT;

VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN SpiceSlide* spice_slide_new (SpiceWindow* window,
                             JsonObject* save_data);
VALA_EXTERN SpiceSlide* spice_slide_construct (GType object_type,
                                   SpiceWindow* window,
                                   JsonObject* save_data);
VALA_EXTERN SpiceCanvas* spice_canvas_new (SpiceWindow* window,
                               JsonObject* save_data);
VALA_EXTERN SpiceCanvas* spice_canvas_construct (GType object_type,
                                     SpiceWindow* window,
                                     JsonObject* save_data);
VALA_EXTERN void spice_slide_reload_preview_data (SpiceSlide* self);
static void _spice_slide_reload_preview_data_spice_canvas_request_draw_preview (SpiceCanvas* _sender,
                                                                         gpointer self);
static void spice_slide_load_data (SpiceSlide* self);
VALA_EXTERN SpiceSlide* spice_slide_new_empty (SpiceWindow* window);
VALA_EXTERN SpiceSlide* spice_slide_construct_empty (GType object_type,
                                         SpiceWindow* window);
VALA_EXTERN JsonObject* spice_utils_get_json_object (const gchar* raw_json);
VALA_EXTERN void spice_slide_set_visible (SpiceSlide* self,
                              gboolean value);
VALA_EXTERN SpiceSlide* spice_slide_new_without_canvas (JsonObject* save_data);
VALA_EXTERN SpiceSlide* spice_slide_construct_without_canvas (GType object_type,
                                                  JsonObject* save_data);
VALA_EXTERN void spice_slide_load_slide (SpiceSlide* self);
VALA_EXTERN void spice_canvas_clear_all (SpiceCanvas* self);
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN SpiceCanvasItem* spice_utils_canvas_item_from_data (JsonObject* data,
                                                    SpiceCanvas* canvas);
VALA_EXTERN void spice_slide_add_item (SpiceSlide* self,
                           SpiceCanvasItem* item,
                           gboolean select_item,
                           gboolean save_history);
static void spice_slide_set_preview_data (SpiceSlide* self,
                                   const gchar* value);
VALA_EXTERN const gchar* spice_slide_get_preview_data (SpiceSlide* self);
VALA_EXTERN GdkPixbuf* spice_utils_base64_to_pixbuf (const gchar* base64);
VALA_EXTERN void spice_slide_set_transition (SpiceSlide* self,
                                 GtkStackTransitionType value);
VALA_EXTERN void spice_slide_set_notes (SpiceSlide* self,
                            const gchar* value);
VALA_EXTERN SpiceCanvasItem* spice_canvas_add_item (SpiceCanvas* self,
                                        SpiceCanvasItem* item,
                                        gboolean undoable_action);
static gboolean __lambda16_ (SpiceSlide* self);
VALA_EXTERN GType spice_canvas_canvas_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasCanvasGrid, g_object_unref)
VALA_EXTERN gchar* spice_utils_pixbuf_to_base64 (GdkPixbuf* pixbuf);
static gboolean ___lambda16__gsource_func (gpointer self);
VALA_EXTERN gchar* spice_slide_serialise (SpiceSlide* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN gchar* spice_canvas_item_serialise (SpiceCanvasItem* self);
VALA_EXTERN const gchar* spice_slide_get_notes (SpiceSlide* self);
VALA_EXTERN gchar* spice_canvas_serialise (SpiceCanvas* self);
VALA_EXTERN GtkStackTransitionType spice_slide_get_transition (SpiceSlide* self);
VALA_EXTERN void spice_slide_delete (SpiceSlide* self);
VALA_EXTERN GType spice_services_history_manager_history_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManagerHistoryAction, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_new_slide_changed (GType i_type,
                                                                                                           GBoxedCopyFunc i_dup_func,
                                                                                                           GDestroyNotify i_destroy_func,
                                                                                                           GType t_type,
                                                                                                           GBoxedCopyFunc t_dup_func,
                                                                                                           GDestroyNotify t_destroy_func,
                                                                                                           gconstpointer item,
                                                                                                           const gchar* property);
VALA_EXTERN SpiceServicesHistoryManagerHistoryAction* spice_services_history_manager_history_action_construct_slide_changed (GType object_type,
                                                                                                                 GType i_type,
                                                                                                                 GBoxedCopyFunc i_dup_func,
                                                                                                                 GDestroyNotify i_destroy_func,
                                                                                                                 GType t_type,
                                                                                                                 GBoxedCopyFunc t_dup_func,
                                                                                                                 GDestroyNotify t_destroy_func,
                                                                                                                 gconstpointer item,
                                                                                                                 const gchar* property);
VALA_EXTERN GType spice_services_history_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesHistoryManager, g_object_unref)
VALA_EXTERN SpiceServicesHistoryManager* spice_window_get_history_manager (SpiceWindow* self);
VALA_EXTERN void spice_services_history_manager_add_undoable_action (SpiceServicesHistoryManager* self,
                                                         SpiceServicesHistoryManagerHistoryAction* action,
                                                         gboolean force_add);
VALA_EXTERN void spice_slide_destroy (SpiceSlide* self);
VALA_EXTERN gboolean spice_slide_get_visible (SpiceSlide* self);
static GObject * spice_slide_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void spice_slide_finalize (GObject * obj);
static GType spice_slide_get_type_once (void);
static void _vala_spice_slide_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_spice_slide_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
spice_slide_get_instance_private (SpiceSlide* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceSlide_private_offset);
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 46 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return self ? json_object_ref (self) : NULL;
#line 300 "Slide.c"
}

static void
_spice_slide_reload_preview_data_spice_canvas_request_draw_preview (SpiceCanvas* _sender,
                                                                    gpointer self)
{
#line 49 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_reload_preview_data ((SpiceSlide*) self);
#line 309 "Slide.c"
}

SpiceSlide*
spice_slide_construct (GType object_type,
                       SpiceWindow* window,
                       JsonObject* save_data)
{
	SpiceSlide * self = NULL;
	JsonObject* _tmp0_;
	SpiceCanvas* _tmp1_;
	SpiceCanvas* _tmp2_;
#line 45 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 45 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self = (SpiceSlide*) g_object_new (object_type, NULL);
#line 46 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = _json_object_ref0 (save_data);
#line 46 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_json_object_unref0 (self->save_data);
#line 46 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->save_data = _tmp0_;
#line 47 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = spice_canvas_new (window, save_data);
#line 47 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_ref_sink (_tmp1_);
#line 47 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (self->canvas);
#line 47 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->canvas = _tmp1_;
#line 49 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp2_ = self->canvas;
#line 49 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_signal_connect_object (_tmp2_, "request-draw-preview", (GCallback) _spice_slide_reload_preview_data_spice_canvas_request_draw_preview, self, 0);
#line 50 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_load_data (self);
#line 45 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return self;
#line 347 "Slide.c"
}

SpiceSlide*
spice_slide_new (SpiceWindow* window,
                 JsonObject* save_data)
{
#line 45 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return spice_slide_construct (SPICE_TYPE_SLIDE, window, save_data);
#line 356 "Slide.c"
}

SpiceSlide*
spice_slide_construct_empty (GType object_type,
                             SpiceWindow* window)
{
	SpiceSlide * self = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	SpiceCanvas* _tmp2_;
#line 53 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 53 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self = (SpiceSlide*) g_object_new (object_type, NULL);
#line 54 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = spice_utils_get_json_object (SPICE_SLIDE_EMPTY_SLIDE);
#line 54 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_json_object_unref0 (self->save_data);
#line 54 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->save_data = _tmp0_;
#line 55 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = self->save_data;
#line 55 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp2_ = spice_canvas_new (window, _tmp1_);
#line 55 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_ref_sink (_tmp2_);
#line 55 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (self->canvas);
#line 55 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->canvas = _tmp2_;
#line 57 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_load_data (self);
#line 58 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_set_visible (self, FALSE);
#line 53 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return self;
#line 393 "Slide.c"
}

SpiceSlide*
spice_slide_new_empty (SpiceWindow* window)
{
#line 53 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return spice_slide_construct_empty (SPICE_TYPE_SLIDE, window);
#line 401 "Slide.c"
}

SpiceSlide*
spice_slide_construct_without_canvas (GType object_type,
                                      JsonObject* save_data)
{
	SpiceSlide * self = NULL;
	JsonObject* _tmp0_;
#line 61 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self = (SpiceSlide*) g_object_new (object_type, NULL);
#line 62 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = _json_object_ref0 (save_data);
#line 62 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_json_object_unref0 (self->save_data);
#line 62 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->save_data = _tmp0_;
#line 63 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (self->canvas);
#line 63 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->canvas = NULL;
#line 65 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_load_data (self);
#line 61 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return self;
#line 426 "Slide.c"
}

SpiceSlide*
spice_slide_new_without_canvas (JsonObject* save_data)
{
#line 61 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return spice_slide_construct_without_canvas (SPICE_TYPE_SLIDE, save_data);
#line 434 "Slide.c"
}

static gpointer
_json_array_ref0 (gpointer self)
{
#line 76 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return self ? json_array_ref (self) : NULL;
#line 442 "Slide.c"
}

void
spice_slide_load_slide (SpiceSlide* self)
{
	JsonObject* _tmp0_;
	SpiceCanvas* _tmp1_;
	JsonArray* items = NULL;
	JsonObject* _tmp2_;
	JsonArray* _tmp3_;
	JsonArray* _tmp4_;
	JsonArray* _tmp5_;
	GList* _tmp6_;
#line 72 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 73 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->save_data;
#line 73 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp0_ == NULL) {
#line 73 "../Spice-up-1.9.1/src/Services/Slide.vala"
		return;
#line 464 "Slide.c"
	}
#line 74 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = self->canvas;
#line 74 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_canvas_clear_all (_tmp1_);
#line 76 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp2_ = self->save_data;
#line 76 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp3_ = json_object_get_array_member (_tmp2_, "items");
#line 76 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp4_ = _json_array_ref0 (_tmp3_);
#line 76 "../Spice-up-1.9.1/src/Services/Slide.vala"
	items = _tmp4_;
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp5_ = items;
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp6_ = json_array_get_elements (_tmp5_);
#line 482 "Slide.c"
	{
		GList* raw_collection = NULL;
		GList* raw_it = NULL;
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
		raw_collection = _tmp6_;
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
		for (raw_it = raw_collection; raw_it != NULL; raw_it = raw_it->next) {
#line 490 "Slide.c"
			JsonNode* raw = NULL;
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
			raw = (JsonNode*) raw_it->data;
#line 494 "Slide.c"
			{
				SpiceCanvasItem* item = NULL;
				JsonNode* _tmp7_;
				JsonObject* _tmp8_;
				SpiceCanvas* _tmp9_;
				SpiceCanvasItem* _tmp10_;
				SpiceCanvasItem* _tmp11_;
#line 79 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_tmp7_ = raw;
#line 79 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_tmp8_ = json_node_get_object (_tmp7_);
#line 79 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_tmp9_ = self->canvas;
#line 79 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_tmp10_ = spice_utils_canvas_item_from_data (_tmp8_, _tmp9_);
#line 79 "../Spice-up-1.9.1/src/Services/Slide.vala"
				item = _tmp10_;
#line 80 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_tmp11_ = item;
#line 80 "../Spice-up-1.9.1/src/Services/Slide.vala"
				spice_slide_add_item (self, _tmp11_, FALSE, FALSE);
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_g_object_unref0 (item);
#line 518 "Slide.c"
			}
		}
#line 78 "../Spice-up-1.9.1/src/Services/Slide.vala"
		(raw_collection == NULL) ? NULL : (raw_collection = (g_list_free (raw_collection), NULL));
#line 523 "Slide.c"
	}
#line 83 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_json_object_unref0 (self->save_data);
#line 83 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->save_data = NULL;
#line 72 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_json_array_unref0 (items);
#line 531 "Slide.c"
}

static void
spice_slide_load_data (SpiceSlide* self)
{
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	JsonObject* _tmp12_;
	gchar* raw_notes = NULL;
	JsonObject* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
#line 86 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 87 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->save_data;
#line 87 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp0_ == NULL) {
#line 87 "../Spice-up-1.9.1/src/Services/Slide.vala"
		return;
#line 557 "Slide.c"
	}
#line 89 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = self->save_data;
#line 89 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp2_ = json_object_get_string_member (_tmp1_, "preview");
#line 89 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_set_preview_data (self, _tmp2_);
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp4_ = self->priv->_preview_data;
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp4_ != NULL) {
#line 569 "Slide.c"
		const gchar* _tmp5_;
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp5_ = self->priv->_preview_data;
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 575 "Slide.c"
	} else {
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp3_ = FALSE;
#line 579 "Slide.c"
	}
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp3_) {
#line 583 "Slide.c"
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp6_;
		GdkPixbuf* _tmp7_;
		GtkImage* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
#line 91 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp6_ = self->priv->_preview_data;
#line 91 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp7_ = spice_utils_base64_to_pixbuf (_tmp6_);
#line 91 "../Spice-up-1.9.1/src/Services/Slide.vala"
		pixbuf = _tmp7_;
#line 93 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp8_ = self->preview;
#line 93 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp9_ = pixbuf;
#line 93 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp10_ = gdk_pixbuf_scale_simple (_tmp9_, spice_slide_list_WIDTH, spice_slide_list_HEIGHT, GDK_INTERP_BILINEAR);
#line 93 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp11_ = _tmp10_;
#line 93 "../Spice-up-1.9.1/src/Services/Slide.vala"
		gtk_image_set_from_pixbuf (_tmp8_, _tmp11_);
#line 93 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_object_unref0 (_tmp11_);
#line 90 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_object_unref0 (pixbuf);
#line 611 "Slide.c"
	}
#line 96 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp12_ = self->save_data;
#line 96 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (json_object_has_member (_tmp12_, "transition")) {
#line 617 "Slide.c"
		JsonObject* _tmp13_;
#line 97 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp13_ = self->save_data;
#line 97 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_transition (self, (GtkStackTransitionType) json_object_get_int_member (_tmp13_, "transition"));
#line 623 "Slide.c"
	} else {
#line 99 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_transition (self, GTK_STACK_TRANSITION_TYPE_NONE);
#line 627 "Slide.c"
	}
#line 102 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp14_ = self->save_data;
#line 102 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp15_ = json_object_get_string_member (_tmp14_, "notes");
#line 102 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 102 "../Spice-up-1.9.1/src/Services/Slide.vala"
	raw_notes = _tmp16_;
#line 103 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp18_ = raw_notes;
#line 103 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp18_ != NULL) {
#line 641 "Slide.c"
		const gchar* _tmp19_;
#line 103 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp19_ = raw_notes;
#line 103 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp17_ = g_strcmp0 (_tmp19_, "") != 0;
#line 647 "Slide.c"
	} else {
#line 103 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp17_ = FALSE;
#line 651 "Slide.c"
	}
#line 103 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp17_) {
#line 655 "Slide.c"
		const gchar* _tmp20_;
		gsize _tmp21_ = 0;
		guchar* _tmp22_;
		gchar* _tmp23_;
#line 104 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp20_ = raw_notes;
#line 104 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp22_ = g_base64_decode (_tmp20_, &_tmp21_);
#line 104 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp23_ = (gchar*) _tmp22_;
#line 104 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_notes (self, _tmp23_);
#line 104 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_free0 (_tmp23_);
#line 670 "Slide.c"
	}
#line 86 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_free0 (raw_notes);
#line 674 "Slide.c"
}

void
spice_slide_add_item (SpiceSlide* self,
                      SpiceCanvasItem* item,
                      gboolean select_item,
                      gboolean save_history)
{
	SpiceCanvas* _tmp0_;
	SpiceCanvasItem* _tmp1_;
	SpiceCanvasItem* _tmp2_;
#line 108 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 108 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (item != NULL);
#line 109 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->canvas;
#line 109 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = spice_canvas_add_item (_tmp0_, item, save_history);
#line 109 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp2_ = _tmp1_;
#line 109 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (_tmp2_);
#line 111 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (select_item) {
#line 700 "Slide.c"
		SpiceCanvas* _tmp3_;
#line 112 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp3_ = self->canvas;
#line 112 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_signal_emit_by_name (_tmp3_, "item-clicked", item);
#line 113 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_signal_emit_by_name (item, "clicked");
#line 708 "Slide.c"
	}
}

static gboolean
__lambda16_ (SpiceSlide* self)
{
	SpiceCanvas* _tmp0_;
	GraniteDrawingBufferSurface* _tmp1_;
	gboolean result;
#line 119 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->canvas;
#line 119 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = _tmp0_->surface;
#line 119 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp1_ != NULL) {
#line 724 "Slide.c"
		GdkPixbuf* pixbuf = NULL;
		SpiceCanvas* _tmp2_;
		GraniteDrawingBufferSurface* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		GtkImage* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp2_ = self->canvas;
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp3_ = _tmp2_->surface;
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp4_ = granite_drawing_buffer_surface_load_to_pixbuf (_tmp3_);
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp5_ = _tmp4_;
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp6_ = gdk_pixbuf_scale_simple (_tmp5_, spice_slide_list_WIDTH, spice_slide_list_HEIGHT, GDK_INTERP_BILINEAR);
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp7_ = _tmp6_;
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_object_unref0 (_tmp5_);
#line 120 "../Spice-up-1.9.1/src/Services/Slide.vala"
		pixbuf = _tmp7_;
#line 121 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp8_ = self->preview;
#line 121 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp9_ = pixbuf;
#line 121 "../Spice-up-1.9.1/src/Services/Slide.vala"
		gtk_image_set_from_pixbuf (_tmp8_, _tmp9_);
#line 122 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp10_ = pixbuf;
#line 122 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp11_ = spice_utils_pixbuf_to_base64 (_tmp10_);
#line 122 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp12_ = _tmp11_;
#line 122 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_preview_data (self, _tmp12_);
#line 122 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_free0 (_tmp12_);
#line 119 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_object_unref0 (pixbuf);
#line 771 "Slide.c"
	}
#line 125 "../Spice-up-1.9.1/src/Services/Slide.vala"
	result = FALSE;
#line 125 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 777 "Slide.c"
}

static gboolean
___lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda16_ ((SpiceSlide*) self);
#line 118 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 787 "Slide.c"
}

void
spice_slide_reload_preview_data (SpiceSlide* self)
{
#line 117 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 118 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 110, ___lambda16__gsource_func, g_object_ref (self), g_object_unref);
#line 797 "Slide.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_boxed_free (json_node_get_type (), self);
#line 805 "Slide.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 144 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return self ? g_object_ref (self) : NULL;
#line 813 "Slide.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 850 "Slide.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 856 "Slide.c"
}

gchar*
spice_slide_serialise (SpiceSlide* self)
{
	JsonObject* _tmp0_;
	gchar* data = NULL;
	gchar* _tmp9_;
	SpiceCanvas* _tmp10_;
	GList* _tmp11_;
	gchar* raw_notes = NULL;
	const gchar* _tmp29_;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_ = 0;
	guint8* _tmp32_;
	gint _tmp32__length1;
	gchar* _tmp33_;
	SpiceCanvas* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GtkStackTransitionType _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* result;
#line 129 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->save_data;
#line 130 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (_tmp0_ != NULL) {
#line 891 "Slide.c"
		JsonNode* root = NULL;
		JsonNode* _tmp1_;
		JsonNode* _tmp2_;
		JsonObject* _tmp3_;
		JsonGenerator* gen = NULL;
		JsonGenerator* _tmp4_;
		JsonGenerator* _tmp5_;
		JsonNode* _tmp6_;
		JsonGenerator* _tmp7_;
		gchar* _tmp8_;
#line 131 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp1_ = json_node_new (JSON_NODE_OBJECT);
#line 131 "../Spice-up-1.9.1/src/Services/Slide.vala"
		root = _tmp1_;
#line 132 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp2_ = root;
#line 132 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp3_ = self->save_data;
#line 132 "../Spice-up-1.9.1/src/Services/Slide.vala"
		json_node_set_object (_tmp2_, _tmp3_);
#line 134 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp4_ = json_generator_new ();
#line 134 "../Spice-up-1.9.1/src/Services/Slide.vala"
		gen = _tmp4_;
#line 135 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp5_ = gen;
#line 135 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp6_ = root;
#line 135 "../Spice-up-1.9.1/src/Services/Slide.vala"
		json_generator_set_root (_tmp5_, _tmp6_);
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp7_ = gen;
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp8_ = json_generator_to_data (_tmp7_, NULL);
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
		result = _tmp8_;
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_object_unref0 (gen);
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
		__vala_JsonNode_free0 (root);
#line 137 "../Spice-up-1.9.1/src/Services/Slide.vala"
		return result;
#line 934 "Slide.c"
	}
#line 140 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp9_ = g_strdup ("");
#line 140 "../Spice-up-1.9.1/src/Services/Slide.vala"
	data = _tmp9_;
#line 142 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp10_ = self->canvas;
#line 142 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp11_ = gtk_container_get_children ((GtkContainer*) _tmp10_);
#line 944 "Slide.c"
	{
		GList* widget_collection = NULL;
		GList* widget_it = NULL;
#line 142 "../Spice-up-1.9.1/src/Services/Slide.vala"
		widget_collection = _tmp11_;
#line 142 "../Spice-up-1.9.1/src/Services/Slide.vala"
		for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
#line 952 "Slide.c"
			GtkWidget* widget = NULL;
#line 142 "../Spice-up-1.9.1/src/Services/Slide.vala"
			widget = (GtkWidget*) widget_it->data;
#line 956 "Slide.c"
			{
				gboolean _tmp12_ = FALSE;
				GtkWidget* _tmp13_;
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
				_tmp13_ = widget;
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
				if (SPICE_IS_CANVAS_ITEM (_tmp13_)) {
#line 964 "Slide.c"
					GtkWidget* _tmp14_;
					gboolean _tmp15_;
					gboolean _tmp16_;
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp14_ = widget;
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp15_ = gtk_widget_get_visible (_tmp14_);
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp16_ = _tmp15_;
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp12_ = _tmp16_;
#line 976 "Slide.c"
				} else {
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp12_ = FALSE;
#line 980 "Slide.c"
				}
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
				if (_tmp12_) {
#line 984 "Slide.c"
					SpiceCanvasItem* item = NULL;
					GtkWidget* _tmp17_;
					SpiceCanvasItem* _tmp18_;
					gchar* _tmp19_ = NULL;
					const gchar* _tmp20_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
#line 144 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp17_ = widget;
#line 144 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem));
#line 144 "../Spice-up-1.9.1/src/Services/Slide.vala"
					item = _tmp18_;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp20_ = data;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
					if (g_strcmp0 (_tmp20_, "") != 0) {
#line 1002 "Slide.c"
						SpiceCanvasItem* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp21_ = item;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp22_ = spice_canvas_item_serialise (_tmp21_);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp23_ = _tmp22_;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp24_ = g_strconcat (",", _tmp23_, NULL);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_g_free0 (_tmp19_);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp19_ = _tmp24_;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_g_free0 (_tmp23_);
#line 1021 "Slide.c"
					} else {
						SpiceCanvasItem* _tmp25_;
						gchar* _tmp26_;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp25_ = item;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp26_ = spice_canvas_item_serialise (_tmp25_);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_g_free0 (_tmp19_);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
						_tmp19_ = _tmp26_;
#line 1033 "Slide.c"
					}
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp27_ = data;
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_tmp28_ = g_strconcat (_tmp27_, _tmp19_, NULL);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_g_free0 (data);
#line 146 "../Spice-up-1.9.1/src/Services/Slide.vala"
					data = _tmp28_;
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_g_free0 (_tmp19_);
#line 143 "../Spice-up-1.9.1/src/Services/Slide.vala"
					_g_object_unref0 (item);
#line 1047 "Slide.c"
				}
			}
		}
#line 142 "../Spice-up-1.9.1/src/Services/Slide.vala"
		(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
#line 1053 "Slide.c"
	}
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp29_ = self->priv->_notes;
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp30_ = string_get_data (_tmp29_, &_tmp31_);
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp30__length1 = _tmp31_;
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp32_ = _tmp30_;
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp32__length1 = _tmp30__length1;
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp33_ = g_base64_encode (_tmp32_, (gint) _tmp32__length1);
#line 150 "../Spice-up-1.9.1/src/Services/Slide.vala"
	raw_notes = (gchar*) _tmp33_;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp34_ = self->canvas;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp35_ = spice_canvas_serialise (_tmp34_);
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp36_ = _tmp35_;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp37_ = self->priv->_transition;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp38_ = data;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp39_ = raw_notes;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp40_ = self->priv->_preview_data;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp41_ = g_strdup_printf ("{%s, \"transition\": %d, \"items\": [%s], \"notes\": \"%s\", \"preview" \
"\": \"%s\"}\n", _tmp36_, (gint) _tmp37_, _tmp38_, _tmp39_, _tmp40_);
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp42_ = _tmp41_;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_free0 (_tmp36_);
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	result = _tmp42_;
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_free0 (raw_notes);
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_free0 (data);
#line 151 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 1097 "Slide.c"
}

void
spice_slide_delete (SpiceSlide* self)
{
	SpiceServicesHistoryManagerHistoryAction* action = NULL;
	SpiceServicesHistoryManagerHistoryAction* _tmp0_;
	SpiceCanvas* _tmp1_;
	SpiceWindow* _tmp2_;
	SpiceServicesHistoryManager* _tmp3_;
	SpiceServicesHistoryManager* _tmp4_;
#line 154 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 155 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = spice_services_history_manager_history_action_new_slide_changed (SPICE_TYPE_SLIDE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, self, "visible");
#line 155 "../Spice-up-1.9.1/src/Services/Slide.vala"
	action = _tmp0_;
#line 156 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = self->canvas;
#line 156 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp2_ = _tmp1_->window;
#line 156 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp3_ = spice_window_get_history_manager (_tmp2_);
#line 156 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp4_ = _tmp3_;
#line 156 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_services_history_manager_add_undoable_action (_tmp4_, action, TRUE);
#line 158 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_set_visible (self, FALSE);
#line 154 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (action);
#line 1129 "Slide.c"
}

void
spice_slide_destroy (SpiceSlide* self)
{
	SpiceCanvas* _tmp0_;
#line 161 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 162 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->canvas;
#line 162 "../Spice-up-1.9.1/src/Services/Slide.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1142 "Slide.c"
}

const gchar*
spice_slide_get_preview_data (SpiceSlide* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->priv->_preview_data;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	result = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 1158 "Slide.c"
}

static void
spice_slide_set_preview_data (SpiceSlide* self,
                              const gchar* value)
{
	gchar* old_value;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	old_value = spice_slide_get_preview_data (self);
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1172 "Slide.c"
		gchar* _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp0_ = g_strdup (value);
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_free0 (self->priv->_preview_data);
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
		self->priv->_preview_data = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_slide_properties[SPICE_SLIDE_PREVIEW_DATA_PROPERTY]);
#line 1182 "Slide.c"
	}
}

const gchar*
spice_slide_get_notes (SpiceSlide* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->priv->_notes;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	result = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 1199 "Slide.c"
}

void
spice_slide_set_notes (SpiceSlide* self,
                       const gchar* value)
{
	gchar* old_value;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	old_value = spice_slide_get_notes (self);
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1213 "Slide.c"
		gchar* _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_tmp0_ = g_strdup (value);
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
		_g_free0 (self->priv->_notes);
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
		self->priv->_notes = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_slide_properties[SPICE_SLIDE_NOTES_PROPERTY]);
#line 1223 "Slide.c"
	}
}

GtkStackTransitionType
spice_slide_get_transition (SpiceSlide* self)
{
	GtkStackTransitionType result;
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	result = self->priv->_transition;
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 1237 "Slide.c"
}

void
spice_slide_set_transition (SpiceSlide* self,
                            GtkStackTransitionType value)
{
	GtkStackTransitionType old_value;
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	old_value = spice_slide_get_transition (self);
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	if (old_value != value) {
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
		self->priv->_transition = value;
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_slide_properties[SPICE_SLIDE_TRANSITION_PROPERTY]);
#line 1255 "Slide.c"
	}
}

gboolean
spice_slide_get_visible (SpiceSlide* self)
{
	gboolean result;
#line 36 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 37 "../Spice-up-1.9.1/src/Services/Slide.vala"
	result = self->priv->visible_;
#line 37 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return result;
#line 1269 "Slide.c"
}

void
spice_slide_set_visible (SpiceSlide* self,
                         gboolean value)
{
	SpiceCanvas* _tmp0_;
#line 38 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_return_if_fail (self != NULL);
#line 39 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->priv->visible_ = value;
#line 40 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = self->canvas;
#line 40 "../Spice-up-1.9.1/src/Services/Slide.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
#line 41 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_signal_emit (self, spice_slide_signals[SPICE_SLIDE_VISIBLE_CHANGED_SIGNAL], 0, value);
#line 38 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_slide_properties[SPICE_SLIDE_VISIBLE_PROPERTY]);
#line 1289 "Slide.c"
}

static GObject *
spice_slide_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SpiceSlide * self;
	GtkImage* _tmp0_;
#line 68 "../Spice-up-1.9.1/src/Services/Slide.vala"
	parent_class = G_OBJECT_CLASS (spice_slide_parent_class);
#line 68 "../Spice-up-1.9.1/src/Services/Slide.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 68 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_SLIDE, SpiceSlide);
#line 69 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = (GtkImage*) gtk_image_new ();
#line 69 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_ref_sink (_tmp0_);
#line 69 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (self->preview);
#line 69 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->preview = _tmp0_;
#line 68 "../Spice-up-1.9.1/src/Services/Slide.vala"
	return obj;
#line 1317 "Slide.c"
}

static void
spice_slide_class_init (SpiceSlideClass * klass,
                        gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_type_class_adjust_private_offset (klass, &SpiceSlide_private_offset);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_slide_get_property;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_slide_set_property;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	G_OBJECT_CLASS (klass)->constructor = spice_slide_constructor;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_slide_finalize;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_PREVIEW_DATA_PROPERTY, spice_slide_properties[SPICE_SLIDE_PREVIEW_DATA_PROPERTY] = g_param_spec_string ("preview-data", "preview-data", "preview-data", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_NOTES_PROPERTY, spice_slide_properties[SPICE_SLIDE_NOTES_PROPERTY] = g_param_spec_string ("notes", "notes", "notes", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_TRANSITION_PROPERTY, spice_slide_properties[SPICE_SLIDE_TRANSITION_PROPERTY] = g_param_spec_enum ("transition", "transition", "transition", gtk_stack_transition_type_get_type (), GTK_STACK_TRANSITION_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_SLIDE_VISIBLE_PROPERTY, spice_slide_properties[SPICE_SLIDE_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	spice_slide_signals[SPICE_SLIDE_VISIBLE_CHANGED_SIGNAL] = g_signal_new ("visible-changed", SPICE_TYPE_SLIDE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 1346 "Slide.c"
}

static void
spice_slide_instance_init (SpiceSlide * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->priv = spice_slide_get_instance_private (self);
#line 25 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->save_data = NULL;
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp0_ = g_strdup ("");
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->priv->_preview_data = _tmp0_;
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_tmp1_ = g_strdup ("");
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->priv->_notes = _tmp1_;
#line 32 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->priv->_transition = GTK_STACK_TRANSITION_TYPE_NONE;
#line 34 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self->priv->visible_ = TRUE;
#line 1371 "Slide.c"
}

static void
spice_slide_finalize (GObject * obj)
{
	SpiceSlide * self;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_SLIDE, SpiceSlide);
#line 25 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_json_object_unref0 (self->save_data);
#line 27 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (self->canvas);
#line 28 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_object_unref0 (self->preview);
#line 30 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_free0 (self->priv->_preview_data);
#line 31 "../Spice-up-1.9.1/src/Services/Slide.vala"
	_g_free0 (self->priv->_notes);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	G_OBJECT_CLASS (spice_slide_parent_class)->finalize (obj);
#line 1392 "Slide.c"
}

static GType
spice_slide_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceSlideClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_slide_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceSlide), 0, (GInstanceInitFunc) spice_slide_instance_init, NULL };
	GType spice_slide_type_id;
	spice_slide_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceSlide", &g_define_type_info, 0);
	SpiceSlide_private_offset = g_type_add_instance_private (spice_slide_type_id, sizeof (SpiceSlidePrivate));
	return spice_slide_type_id;
}

GType
spice_slide_get_type (void)
{
	static volatile gsize spice_slide_type_id__once = 0;
	if (g_once_init_enter (&spice_slide_type_id__once)) {
		GType spice_slide_type_id;
		spice_slide_type_id = spice_slide_get_type_once ();
		g_once_init_leave (&spice_slide_type_id__once, spice_slide_type_id);
	}
	return spice_slide_type_id__once;
}

static void
_vala_spice_slide_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SpiceSlide * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE, SpiceSlide);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_PREVIEW_DATA_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_value_set_string (value, spice_slide_get_preview_data (self));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_NOTES_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_value_set_string (value, spice_slide_get_notes (self));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_TRANSITION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_value_set_enum (value, spice_slide_get_transition (self));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_VISIBLE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		g_value_set_boolean (value, spice_slide_get_visible (self));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 1451 "Slide.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 1457 "Slide.c"
	}
}

static void
_vala_spice_slide_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SpiceSlide * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_SLIDE, SpiceSlide);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_PREVIEW_DATA_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_preview_data (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_NOTES_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_notes (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_TRANSITION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_transition (self, g_value_get_enum (value));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		case SPICE_SLIDE_VISIBLE_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		spice_slide_set_visible (self, g_value_get_boolean (value));
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 1495 "Slide.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/Slide.vala"
		break;
#line 1501 "Slide.c"
	}
}

