/* ImageHandler.c generated by valac 0.56.18, the Vala compiler
 * generated from ImageHandler.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define SPICE_IMAGE_HANDLER_FILENAME "/spice-up-%s-img-%u.%s"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_IMAGE_HANDLER (spice_image_handler_get_type ())
#define SPICE_IMAGE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandler))
#define SPICE_IMAGE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandlerClass))
#define SPICE_IS_IMAGE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_HANDLER))
#define SPICE_IS_IMAGE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_HANDLER))
#define SPICE_IMAGE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandlerClass))

typedef struct _SpiceImageHandler SpiceImageHandler;
typedef struct _SpiceImageHandlerClass SpiceImageHandlerClass;
typedef struct _SpiceImageHandlerPrivate SpiceImageHandlerPrivate;
enum  {
	SPICE_IMAGE_HANDLER_0_PROPERTY,
	SPICE_IMAGE_HANDLER_IMAGE_EXTENSION_PROPERTY,
	SPICE_IMAGE_HANDLER_URL_PROPERTY,
	SPICE_IMAGE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* spice_image_handler_properties[SPICE_IMAGE_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SPICE_IMAGE_HANDLER_FILE_CHANGED_SIGNAL,
	SPICE_IMAGE_HANDLER_NUM_SIGNALS
};
static guint spice_image_handler_signals[SPICE_IMAGE_HANDLER_NUM_SIGNALS] = {0};

struct _SpiceImageHandler {
	GObject parent_instance;
	SpiceImageHandlerPrivate * priv;
	gboolean valid;
};

struct _SpiceImageHandlerClass {
	GObjectClass parent_class;
};

struct _SpiceImageHandlerPrivate {
	guint file_id;
	GFileMonitor* monitor;
	gboolean file_changing;
	gchar* base64_image;
	gchar* _image_extension;
	gchar* url_;
};

struct _Block6Data {
	int _ref_count_;
	SpiceImageHandler* self;
	GFile* file;
};

static gint SpiceImageHandler_private_offset;
static gpointer spice_image_handler_parent_class = NULL;
VALA_EXTERN guint spice_image_handler_FILE_ID;
guint spice_image_handler_FILE_ID = (guint) 0;

VALA_EXTERN GType spice_image_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageHandler, g_object_unref)
VALA_EXTERN SpiceImageHandler* spice_image_handler_new_from_data (const gchar* _extension,
                                                      const gchar* _base64_data);
VALA_EXTERN SpiceImageHandler* spice_image_handler_construct_from_data (GType object_type,
                                                            const gchar* _extension,
                                                            const gchar* _base64_data);
static void spice_image_handler_set_image_extension (SpiceImageHandler* self,
                                              const gchar* value);
static gchar* spice_image_handler_data_to_file (SpiceImageHandler* self,
                                         const gchar* data);
VALA_EXTERN void spice_image_handler_set_url (SpiceImageHandler* self,
                                  const gchar* value);
VALA_EXTERN SpiceImageHandler* spice_image_handler_new_from_file (GFile* file);
VALA_EXTERN SpiceImageHandler* spice_image_handler_construct_from_file (GType object_type,
                                                            GFile* file);
VALA_EXTERN void spice_image_handler_replace (SpiceImageHandler* self,
                                  GFile* file);
static gchar* spice_image_handler_get_extension (SpiceImageHandler* self,
                                          const gchar* filename);
static void spice_image_handler_data_from_file (SpiceImageHandler* self,
                                         GFile* file);
VALA_EXTERN gchar* spice_image_handler_serialize (SpiceImageHandler* self);
VALA_EXTERN const gchar* spice_image_handler_get_image_extension (SpiceImageHandler* self);
static void spice_image_handler_monitor_file (SpiceImageHandler* self,
                                       GFile* file);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda14_ (Block6Data* _data6_,
                   GFile* src,
                   GFile* dest,
                   GFileMonitorEvent event);
static void ____lambda14__g_file_monitor_changed (GFileMonitor* _sender,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           gpointer self);
VALA_EXTERN gchar* spice_services_file_manager_file_to_base64 (GFile* file);
VALA_EXTERN void spice_services_file_manager_base64_to_file (const gchar* filename,
                                                 const gchar* base64_data);
VALA_EXTERN SpiceImageHandler* spice_image_handler_new (void);
VALA_EXTERN SpiceImageHandler* spice_image_handler_construct (GType object_type);
VALA_EXTERN const gchar* spice_image_handler_get_url (SpiceImageHandler* self);
VALA_EXTERN gboolean spice_utils_is_valid_image (GFile* file);
static void spice_image_handler_finalize (GObject * obj);
static GType spice_image_handler_get_type_once (void);
static void _vala_spice_image_handler_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_spice_image_handler_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
spice_image_handler_get_instance_private (SpiceImageHandler* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceImageHandler_private_offset);
}

SpiceImageHandler*
spice_image_handler_construct_from_data (GType object_type,
                                         const gchar* _extension,
                                         const gchar* _base64_data)
{
	SpiceImageHandler * self = NULL;
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 52 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (_extension != NULL, NULL);
#line 52 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (_base64_data != NULL, NULL);
#line 52 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self = (SpiceImageHandler*) g_object_new (object_type, NULL);
#line 53 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = spice_image_handler_FILE_ID;
#line 53 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_FILE_ID = _tmp0_ + 1;
#line 53 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->file_id = _tmp0_;
#line 54 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (g_strcmp0 (_extension, "") != 0) {
#line 54 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp1_ = _extension;
#line 203 "ImageHandler.c"
	} else {
#line 54 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp1_ = "png";
#line 207 "ImageHandler.c"
	}
#line 54 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_set_image_extension (self, _tmp1_);
#line 55 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2_ = g_strdup (_base64_data);
#line 55 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (self->priv->base64_image);
#line 55 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->base64_image = _tmp2_;
#line 56 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp3_ = spice_image_handler_data_to_file (self, _base64_data);
#line 56 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp4_ = _tmp3_;
#line 56 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_set_url (self, _tmp4_);
#line 56 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (_tmp4_);
#line 52 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return self;
#line 227 "ImageHandler.c"
}

SpiceImageHandler*
spice_image_handler_new_from_data (const gchar* _extension,
                                   const gchar* _base64_data)
{
#line 52 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return spice_image_handler_construct_from_data (SPICE_TYPE_IMAGE_HANDLER, _extension, _base64_data);
#line 236 "ImageHandler.c"
}

SpiceImageHandler*
spice_image_handler_construct_from_file (GType object_type,
                                         GFile* file)
{
	SpiceImageHandler * self = NULL;
	guint _tmp0_;
#line 59 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 59 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self = (SpiceImageHandler*) g_object_new (object_type, NULL);
#line 60 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = spice_image_handler_FILE_ID;
#line 60 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_FILE_ID = _tmp0_ + 1;
#line 60 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->file_id = _tmp0_;
#line 61 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_replace (self, file);
#line 59 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return self;
#line 259 "ImageHandler.c"
}

SpiceImageHandler*
spice_image_handler_new_from_file (GFile* file)
{
#line 59 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return spice_image_handler_construct_from_file (SPICE_TYPE_IMAGE_HANDLER, file);
#line 267 "ImageHandler.c"
}

void
spice_image_handler_replace (SpiceImageHandler* self,
                             GFile* file)
{
	GFileMonitor* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 64 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (self != NULL);
#line 64 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (file != NULL);
#line 65 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = self->priv->monitor;
#line 65 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (_tmp0_ != NULL) {
#line 290 "ImageHandler.c"
		GFileMonitor* _tmp1_;
#line 66 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp1_ = self->priv->monitor;
#line 66 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_file_monitor_cancel (_tmp1_);
#line 296 "ImageHandler.c"
	}
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2_ = g_file_get_basename (file);
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp3_ = _tmp2_;
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp4_ = spice_image_handler_get_extension (self, _tmp3_);
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp5_ = _tmp4_;
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_set_image_extension (self, _tmp5_);
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (_tmp5_);
#line 69 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (_tmp3_);
#line 70 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_data_from_file (self, file);
#line 71 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp6_ = self->priv->base64_image;
#line 71 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp7_ = spice_image_handler_data_to_file (self, _tmp6_);
#line 71 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp8_ = _tmp7_;
#line 71 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_set_url (self, _tmp8_);
#line 71 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (_tmp8_);
#line 324 "ImageHandler.c"
}

gchar*
spice_image_handler_serialize (SpiceImageHandler* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 74 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = self->priv->_image_extension;
#line 75 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp1_ = self->priv->base64_image;
#line 75 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2_ = g_strdup_printf ("\"image\":\"%s\", \"image-data\":\"%s\" ", _tmp0_, _tmp1_);
#line 75 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	result = _tmp2_;
#line 75 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return result;
#line 346 "ImageHandler.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return self ? g_object_ref (self) : NULL;
#line 354 "ImageHandler.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return _data6_;
#line 364 "ImageHandler.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 374 "ImageHandler.c"
		SpiceImageHandler* self;
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		self = _data6_->self;
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_g_object_unref0 (_data6_->file);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_g_object_unref0 (self);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_slice_free (Block6Data, _data6_);
#line 384 "ImageHandler.c"
	}
}

static void
___lambda14_ (Block6Data* _data6_,
              GFile* src,
              GFile* dest,
              GFileMonitorEvent event)
{
	SpiceImageHandler* self;
#line 82 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self = _data6_->self;
#line 82 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (src != NULL);
#line 83 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (event == G_FILE_MONITOR_EVENT_CHANGED) {
#line 84 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		self->priv->file_changing = TRUE;
#line 403 "ImageHandler.c"
	} else {
		gboolean _tmp0_ = FALSE;
#line 85 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		if (event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
#line 85 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
			_tmp0_ = self->priv->file_changing;
#line 410 "ImageHandler.c"
		} else {
#line 85 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
			_tmp0_ = FALSE;
#line 414 "ImageHandler.c"
		}
#line 85 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		if (_tmp0_) {
#line 86 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
			spice_image_handler_data_from_file (self, _data6_->file);
#line 87 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
			g_signal_emit (self, spice_image_handler_signals[SPICE_IMAGE_HANDLER_FILE_CHANGED_SIGNAL], 0);
#line 88 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
			self->priv->file_changing = FALSE;
#line 424 "ImageHandler.c"
		}
	}
}

static void
____lambda14__g_file_monitor_changed (GFileMonitor* _sender,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type,
                                      gpointer self)
{
#line 82 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	___lambda14_ (self, file, other_file, event_type);
#line 438 "ImageHandler.c"
}

static void
spice_image_handler_monitor_file (SpiceImageHandler* self,
                                  GFile* file)
{
	Block6Data* _data6_;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (self != NULL);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (file != NULL);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_data6_->_ref_count_ = 1;
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_data6_->self = g_object_ref (self);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_object_unref0 (_data6_->file);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_data6_->file = _tmp0_;
#line 464 "ImageHandler.c"
	{
		GFileMonitor* _tmp1_ = NULL;
		GFileMonitor* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp2_ = g_file_monitor (_data6_->file, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp1_ = _tmp2_;
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 476 "ImageHandler.c"
			goto __catch0_g_error;
		}
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp3_ = _tmp1_;
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp1_ = NULL;
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_g_object_unref0 (self->priv->monitor);
#line 80 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		self->priv->monitor = _tmp3_;
#line 82 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp4_ = self->priv->monitor;
#line 82 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_signal_connect_data (_tmp4_, "changed", (GCallback) ____lambda14__g_file_monitor_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_g_object_unref0 (_tmp1_);
#line 493 "ImageHandler.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		e = _inner_error0_;
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_inner_error0_ = NULL;
#line 92 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp5_ = e;
#line 92 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp6_ = _tmp5_->message;
#line 92 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_warning ("ImageHandler.vala:92: Could not monitor file: %s", _tmp6_);
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_g_error_free0 (e);
#line 513 "ImageHandler.c"
	}
	__finally0:
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		block6_data_unref (_data6_);
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_data6_ = NULL;
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_clear_error (&_inner_error0_);
#line 79 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		return;
#line 528 "ImageHandler.c"
	}
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	block6_data_unref (_data6_);
#line 78 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_data6_ = NULL;
#line 534 "ImageHandler.c"
}

static gchar*
spice_image_handler_get_extension (SpiceImageHandler* self,
                                   const gchar* filename)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* result;
#line 96 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 97 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp1_ = _tmp0_ = g_strsplit (filename, ".", 0);
#line 97 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	parts = _tmp1_;
#line 97 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	parts_length1 = _vala_array_length (_tmp0_);
#line 97 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_parts_size_ = parts_length1;
#line 98 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2_ = parts;
#line 98 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2__length1 = parts_length1;
#line 98 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (_tmp2__length1 > 1) {
#line 567 "ImageHandler.c"
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp3_ = parts;
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp3__length1 = parts_length1;
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp4_ = parts;
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp4__length1 = parts_length1;
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp5_ = _tmp3_[_tmp4__length1 - 1];
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		result = _tmp6_;
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 99 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		return result;
#line 592 "ImageHandler.c"
	} else {
		gchar* _tmp7_;
#line 101 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp7_ = g_strdup ("png");
#line 101 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		result = _tmp7_;
#line 101 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 101 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		return result;
#line 603 "ImageHandler.c"
	}
}

static void
spice_image_handler_data_from_file (SpiceImageHandler* self,
                                    GFile* file)
{
	gchar* _tmp0_;
#line 105 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (self != NULL);
#line 105 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (file != NULL);
#line 106 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = spice_services_file_manager_file_to_base64 (file);
#line 106 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (self->priv->base64_image);
#line 106 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->base64_image = _tmp0_;
#line 622 "ImageHandler.c"
}

static gchar*
spice_image_handler_data_to_file (SpiceImageHandler* self,
                                  const gchar* data)
{
	gchar* filename = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
#line 109 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 109 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = g_get_tmp_dir ();
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp1_ = g_get_user_name ();
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2_ = self->priv->_image_extension;
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp3_ = g_strdup_printf (SPICE_IMAGE_HANDLER_FILENAME, _tmp1_, self->priv->file_id, _tmp2_);
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp4_ = _tmp3_;
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp5_ = g_strconcat (_tmp0_, _tmp4_, NULL);
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp6_ = _tmp5_;
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (_tmp4_);
#line 110 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	filename = _tmp6_;
#line 111 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_services_file_manager_base64_to_file (filename, data);
#line 113 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	result = filename;
#line 113 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return result;
#line 666 "ImageHandler.c"
}

SpiceImageHandler*
spice_image_handler_construct (GType object_type)
{
	SpiceImageHandler * self = NULL;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self = (SpiceImageHandler*) g_object_new (object_type, NULL);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return self;
#line 677 "ImageHandler.c"
}

SpiceImageHandler*
spice_image_handler_new (void)
{
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return spice_image_handler_construct (SPICE_TYPE_IMAGE_HANDLER);
#line 685 "ImageHandler.c"
}

const gchar*
spice_image_handler_get_image_extension (SpiceImageHandler* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = self->priv->_image_extension;
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	result = _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return result;
#line 701 "ImageHandler.c"
}

static void
spice_image_handler_set_image_extension (SpiceImageHandler* self,
                                         const gchar* value)
{
	gchar* old_value;
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (self != NULL);
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	old_value = spice_image_handler_get_image_extension (self);
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 715 "ImageHandler.c"
		gchar* _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp0_ = g_strdup (value);
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_g_free0 (self->priv->_image_extension);
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		self->priv->_image_extension = _tmp0_;
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_object_notify_by_pspec ((GObject *) self, spice_image_handler_properties[SPICE_IMAGE_HANDLER_IMAGE_EXTENSION_PROPERTY]);
#line 725 "ImageHandler.c"
	}
}

const gchar*
spice_image_handler_get_url (SpiceImageHandler* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 41 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = self->priv->url_;
#line 42 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	result = _tmp0_;
#line 42 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	return result;
#line 742 "ImageHandler.c"
}

void
spice_image_handler_set_url (SpiceImageHandler* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
#line 43 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_return_if_fail (self != NULL);
#line 44 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = g_strdup (value);
#line 44 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (self->priv->url_);
#line 44 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->url_ = _tmp0_;
#line 45 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp1_ = g_file_new_for_path (value);
#line 45 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	file = _tmp1_;
#line 46 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp2_ = file;
#line 46 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_monitor_file (self, _tmp2_);
#line 47 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp4_ = file;
#line 47 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	if (g_file_query_exists (_tmp4_, NULL)) {
#line 775 "ImageHandler.c"
		GFile* _tmp5_;
#line 47 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp5_ = file;
#line 47 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp3_ = spice_utils_is_valid_image (_tmp5_);
#line 781 "ImageHandler.c"
	} else {
#line 47 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		_tmp3_ = FALSE;
#line 785 "ImageHandler.c"
	}
#line 47 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->valid = _tmp3_;
#line 48 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_signal_emit (self, spice_image_handler_signals[SPICE_IMAGE_HANDLER_FILE_CHANGED_SIGNAL], 0);
#line 43 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_object_unref0 (file);
#line 43 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_object_notify_by_pspec ((GObject *) self, spice_image_handler_properties[SPICE_IMAGE_HANDLER_URL_PROPERTY]);
#line 795 "ImageHandler.c"
}

static void
spice_image_handler_class_init (SpiceImageHandlerClass * klass,
                                gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_type_class_adjust_private_offset (klass, &SpiceImageHandler_private_offset);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spice_image_handler_get_property;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spice_image_handler_set_property;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_image_handler_finalize;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_IMAGE_HANDLER_IMAGE_EXTENSION_PROPERTY, spice_image_handler_properties[SPICE_IMAGE_HANDLER_IMAGE_EXTENSION_PROPERTY] = g_param_spec_string ("image-extension", "image-extension", "image-extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPICE_IMAGE_HANDLER_URL_PROPERTY, spice_image_handler_properties[SPICE_IMAGE_HANDLER_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	spice_image_handler_signals[SPICE_IMAGE_HANDLER_FILE_CHANGED_SIGNAL] = g_signal_new ("file-changed", SPICE_TYPE_IMAGE_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 818 "ImageHandler.c"
}

static void
spice_image_handler_instance_init (SpiceImageHandler * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv = spice_image_handler_get_instance_private (self);
#line 31 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->monitor = NULL;
#line 32 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->file_changing = FALSE;
#line 34 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->valid = FALSE;
#line 35 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->base64_image = NULL;
#line 39 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_tmp0_ = g_strdup ("");
#line 39 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self->priv->url_ = _tmp0_;
#line 840 "ImageHandler.c"
}

static void
spice_image_handler_finalize (GObject * obj)
{
	SpiceImageHandler * self;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandler);
#line 31 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_object_unref0 (self->priv->monitor);
#line 35 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (self->priv->base64_image);
#line 37 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (self->priv->_image_extension);
#line 39 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	_g_free0 (self->priv->url_);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	G_OBJECT_CLASS (spice_image_handler_parent_class)->finalize (obj);
#line 859 "ImageHandler.c"
}

static GType
spice_image_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceImageHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_image_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceImageHandler), 0, (GInstanceInitFunc) spice_image_handler_instance_init, NULL };
	GType spice_image_handler_type_id;
	spice_image_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceImageHandler", &g_define_type_info, 0);
	SpiceImageHandler_private_offset = g_type_add_instance_private (spice_image_handler_type_id, sizeof (SpiceImageHandlerPrivate));
	return spice_image_handler_type_id;
}

GType
spice_image_handler_get_type (void)
{
	static volatile gsize spice_image_handler_type_id__once = 0;
	if (g_once_init_enter (&spice_image_handler_type_id__once)) {
		GType spice_image_handler_type_id;
		spice_image_handler_type_id = spice_image_handler_get_type_once ();
		g_once_init_leave (&spice_image_handler_type_id__once, spice_image_handler_type_id);
	}
	return spice_image_handler_type_id__once;
}

static void
_vala_spice_image_handler_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SpiceImageHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandler);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		case SPICE_IMAGE_HANDLER_IMAGE_EXTENSION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_value_set_string (value, spice_image_handler_get_image_extension (self));
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		case SPICE_IMAGE_HANDLER_URL_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		g_value_set_string (value, spice_image_handler_get_url (self));
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		break;
#line 906 "ImageHandler.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		break;
#line 912 "ImageHandler.c"
	}
}

static void
_vala_spice_image_handler_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SpiceImageHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPICE_TYPE_IMAGE_HANDLER, SpiceImageHandler);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
	switch (property_id) {
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		case SPICE_IMAGE_HANDLER_IMAGE_EXTENSION_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		spice_image_handler_set_image_extension (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		break;
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		case SPICE_IMAGE_HANDLER_URL_PROPERTY:
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		spice_image_handler_set_url (self, g_value_get_string (value));
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		break;
#line 938 "ImageHandler.c"
		default:
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "../Spice-up-1.9.1/src/Services/ImageHandler.vala"
		break;
#line 944 "ImageHandler.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

