/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_winbind.h"
#include "bin/default/librpc/gen_ndr/ndr_winbind_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* winbind - dcerpc server boilerplate generated by pidl */
static NTSTATUS winbind__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WINBIND_BIND
	return DCESRV_INTERFACE_WINBIND_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void winbind__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WINBIND_UNBIND
	DCESRV_INTERFACE_WINBIND_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS winbind__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_winbind.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_winbind.calls[opnum].struct_size, "struct %s", ndr_table_winbind.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_winbind.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS winbind__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* wbint_Ping */
		struct wbint_Ping *r2 = (struct wbint_Ping *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_Ping, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.out_data = talloc_zero(r2, uint32_t);
		if (r2->out.out_data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_Ping(p, r2);
		break;
	}
	case 1: { /* wbint_LookupSid */
		struct wbint_LookupSid *r2 = (struct wbint_LookupSid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupSid, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.type = talloc_zero(r2, enum lsa_SidType);
		if (r2->out.type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.domain = talloc_zero(r2, const char *);
		if (r2->out.domain == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.name = talloc_zero(r2, const char *);
		if (r2->out.name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupSid(p, r2);
		break;
	}
	case 2: { /* wbint_LookupSids */
		struct wbint_LookupSids *r2 = (struct wbint_LookupSids *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupSids, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.domains = talloc_zero(r2, struct lsa_RefDomainList);
		if (r2->out.domains == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.names = talloc_zero(r2, struct lsa_TransNameArray);
		if (r2->out.names == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupSids(p, r2);
		break;
	}
	case 3: { /* wbint_LookupName */
		struct wbint_LookupName *r2 = (struct wbint_LookupName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupName, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.type = talloc_zero(r2, enum lsa_SidType);
		if (r2->out.type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.sid = talloc_zero(r2, struct dom_sid);
		if (r2->out.sid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupName(p, r2);
		break;
	}
	case 4: { /* wbint_Sids2UnixIDs */
		struct wbint_Sids2UnixIDs *r2 = (struct wbint_Sids2UnixIDs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_Sids2UnixIDs, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ids = r2->in.ids;
		r2->out.result = _wbint_Sids2UnixIDs(p, r2);
		break;
	}
	case 5: { /* wbint_UnixIDs2Sids */
		struct wbint_UnixIDs2Sids *r2 = (struct wbint_UnixIDs2Sids *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_UnixIDs2Sids, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.xids = r2->in.xids;
		r2->out.sids = talloc_zero_array(r2, struct dom_sid, r2->in.num_ids);
		if (r2->out.sids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_UnixIDs2Sids(p, r2);
		break;
	}
	case 6: { /* wbint_AllocateUid */
		struct wbint_AllocateUid *r2 = (struct wbint_AllocateUid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_AllocateUid, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.uid = talloc_zero(r2, uint64_t);
		if (r2->out.uid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_AllocateUid(p, r2);
		break;
	}
	case 7: { /* wbint_AllocateGid */
		struct wbint_AllocateGid *r2 = (struct wbint_AllocateGid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_AllocateGid, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.gid = talloc_zero(r2, uint64_t);
		if (r2->out.gid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_AllocateGid(p, r2);
		break;
	}
	case 8: { /* wbint_GetNssInfo */
		struct wbint_GetNssInfo *r2 = (struct wbint_GetNssInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_GetNssInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.result = _wbint_GetNssInfo(p, r2);
		break;
	}
	case 9: { /* wbint_LookupUserAliases */
		struct wbint_LookupUserAliases *r2 = (struct wbint_LookupUserAliases *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupUserAliases, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rids = talloc_zero(r2, struct wbint_RidArray);
		if (r2->out.rids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupUserAliases(p, r2);
		break;
	}
	case 10: { /* wbint_LookupUserGroups */
		struct wbint_LookupUserGroups *r2 = (struct wbint_LookupUserGroups *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupUserGroups, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sids = talloc_zero(r2, struct wbint_SidArray);
		if (r2->out.sids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupUserGroups(p, r2);
		break;
	}
	case 11: { /* wbint_QuerySequenceNumber */
		struct wbint_QuerySequenceNumber *r2 = (struct wbint_QuerySequenceNumber *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_QuerySequenceNumber, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sequence = talloc_zero(r2, uint32_t);
		if (r2->out.sequence == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_QuerySequenceNumber(p, r2);
		break;
	}
	case 12: { /* wbint_LookupGroupMembers */
		struct wbint_LookupGroupMembers *r2 = (struct wbint_LookupGroupMembers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupGroupMembers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.members = talloc_zero(r2, struct wbint_Principals);
		if (r2->out.members == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupGroupMembers(p, r2);
		break;
	}
	case 13: { /* wbint_LookupAliasMembers */
		struct wbint_LookupAliasMembers *r2 = (struct wbint_LookupAliasMembers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupAliasMembers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sids = talloc_zero(r2, struct wbint_SidArray);
		if (r2->out.sids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupAliasMembers(p, r2);
		break;
	}
	case 14: { /* wbint_QueryGroupList */
		struct wbint_QueryGroupList *r2 = (struct wbint_QueryGroupList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_QueryGroupList, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.groups = talloc_zero(r2, struct wbint_Principals);
		if (r2->out.groups == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_QueryGroupList(p, r2);
		break;
	}
	case 15: { /* wbint_QueryUserRidList */
		struct wbint_QueryUserRidList *r2 = (struct wbint_QueryUserRidList *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_QueryUserRidList, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rids = talloc_zero(r2, struct wbint_RidArray);
		if (r2->out.rids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_QueryUserRidList(p, r2);
		break;
	}
	case 16: { /* wbint_DsGetDcName */
		struct wbint_DsGetDcName *r2 = (struct wbint_DsGetDcName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_DsGetDcName, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dc_info = talloc_zero(r2, struct netr_DsRGetDCNameInfo *);
		if (r2->out.dc_info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_DsGetDcName(p, r2);
		break;
	}
	case 17: { /* wbint_LookupRids */
		struct wbint_LookupRids *r2 = (struct wbint_LookupRids *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupRids, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.domain_name = talloc_zero(r2, const char *);
		if (r2->out.domain_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.names = talloc_zero(r2, struct wbint_Principals);
		if (r2->out.names == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_LookupRids(p, r2);
		break;
	}
	case 18: { /* wbint_CheckMachineAccount */
		struct wbint_CheckMachineAccount *r2 = (struct wbint_CheckMachineAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_CheckMachineAccount, NDR_IN, r2);
		}
		r2->out.result = _wbint_CheckMachineAccount(p, r2);
		break;
	}
	case 19: { /* wbint_ChangeMachineAccount */
		struct wbint_ChangeMachineAccount *r2 = (struct wbint_ChangeMachineAccount *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_ChangeMachineAccount, NDR_IN, r2);
		}
		r2->out.result = _wbint_ChangeMachineAccount(p, r2);
		break;
	}
	case 20: { /* wbint_PingDc */
		struct wbint_PingDc *r2 = (struct wbint_PingDc *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PingDc, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dcname = talloc_zero(r2, const char *);
		if (r2->out.dcname == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_PingDc(p, r2);
		break;
	}
	case 21: { /* wbint_ListTrustedDomains */
		struct wbint_ListTrustedDomains *r2 = (struct wbint_ListTrustedDomains *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_ListTrustedDomains, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.domains = talloc_zero(r2, struct netr_DomainTrustList);
		if (r2->out.domains == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_ListTrustedDomains(p, r2);
		break;
	}
	case 22: { /* wbint_PamAuth */
		struct wbint_PamAuth *r2 = (struct wbint_PamAuth *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuth, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.validation = talloc_zero(r2, struct wbint_Validation);
		if (r2->out.validation == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_PamAuth(p, r2);
		break;
	}
	case 23: { /* wbint_PamAuthCrap */
		struct wbint_PamAuthCrap *r2 = (struct wbint_PamAuthCrap *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuthCrap, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.authoritative = talloc_zero(r2, uint8_t);
		if (r2->out.authoritative == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.validation = talloc_zero(r2, struct wbint_PamAuthCrapValidation);
		if (r2->out.validation == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_PamAuthCrap(p, r2);
		break;
	}
	case 24: { /* wbint_PamLogOff */
		struct wbint_PamLogOff *r2 = (struct wbint_PamLogOff *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamLogOff, NDR_IN, r2);
		}
		r2->out.result = _wbint_PamLogOff(p, r2);
		break;
	}
	case 25: { /* wbint_PamAuthCrapChangePassword */
		struct wbint_PamAuthCrapChangePassword *r2 = (struct wbint_PamAuthCrapChangePassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuthCrapChangePassword, NDR_IN, r2);
		}
		r2->out.result = _wbint_PamAuthCrapChangePassword(p, r2);
		break;
	}
	case 26: { /* wbint_PamAuthChangePassword */
		struct wbint_PamAuthChangePassword *r2 = (struct wbint_PamAuthChangePassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuthChangePassword, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dominfo = talloc_zero(r2, struct samr_DomInfo1 *);
		if (r2->out.dominfo == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.reject_reason = talloc_zero(r2, enum samPwdChangeReason);
		if (r2->out.reject_reason == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_PamAuthChangePassword(p, r2);
		break;
	}
	case 27: { /* wbint_InitConnection */
		struct wbint_InitConnection *r2 = (struct wbint_InitConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_InitConnection, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.name = talloc_zero(r2, const char *);
		if (r2->out.name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.alt_name = talloc_zero(r2, const char *);
		if (r2->out.alt_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.sid = talloc_zero(r2, struct dom_sid);
		if (r2->out.sid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.flags = talloc_zero(r2, enum DomainInfoFlags);
		if (r2->out.flags == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_InitConnection(p, r2);
		break;
	}
	case 28: { /* wbint_NormalizeNameMap */
		struct wbint_NormalizeNameMap *r2 = (struct wbint_NormalizeNameMap *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_NormalizeNameMap, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.mapped_name = talloc_zero(r2, const char *);
		if (r2->out.mapped_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_NormalizeNameMap(p, r2);
		break;
	}
	case 29: { /* wbint_NormalizeNameUnmap */
		struct wbint_NormalizeNameUnmap *r2 = (struct wbint_NormalizeNameUnmap *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_NormalizeNameUnmap, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.unmapped_name = talloc_zero(r2, const char *);
		if (r2->out.unmapped_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wbint_NormalizeNameUnmap(p, r2);
		break;
	}
	case 30: { /* winbind_SamLogon */
		struct winbind_SamLogon *r2 = (struct winbind_SamLogon *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_SamLogon, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.result = _winbind_SamLogon(p, r2);
		break;
	}
	case 31: { /* winbind_DsrUpdateReadOnlyServerDnsRecords */
		struct winbind_DsrUpdateReadOnlyServerDnsRecords *r2 = (struct winbind_DsrUpdateReadOnlyServerDnsRecords *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_DsrUpdateReadOnlyServerDnsRecords, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dns_names = r2->in.dns_names;
		r2->out.result = _winbind_DsrUpdateReadOnlyServerDnsRecords(p, r2);
		break;
	}
	case 32: { /* winbind_LogonControl */
		struct winbind_LogonControl *r2 = (struct winbind_LogonControl *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_LogonControl, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.query = talloc_zero(r2, union netr_CONTROL_QUERY_INFORMATION);
		if (r2->out.query == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winbind_LogonControl(p, r2);
		break;
	}
	case 33: { /* winbind_GetForestTrustInformation */
		struct winbind_GetForestTrustInformation *r2 = (struct winbind_GetForestTrustInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_GetForestTrustInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.forest_trust_info = talloc_zero(r2, struct lsa_ForestTrustInformation *);
		if (r2->out.forest_trust_info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _winbind_GetForestTrustInformation(p, r2);
		break;
	}
	case 34: { /* winbind_SendToSam */
		struct winbind_SendToSam *r2 = (struct winbind_SendToSam *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_SendToSam, NDR_IN, r2);
		}
		r2->out.result = _winbind_SendToSam(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS winbind__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return winbind__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS winbind__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* wbint_Ping */
		struct wbint_Ping *r2 = (struct wbint_Ping *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_Ping replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_Ping, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_Ping\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* wbint_LookupSid */
		struct wbint_LookupSid *r2 = (struct wbint_LookupSid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupSid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupSid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupSid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* wbint_LookupSids */
		struct wbint_LookupSids *r2 = (struct wbint_LookupSids *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupSids replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupSids, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupSids\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* wbint_LookupName */
		struct wbint_LookupName *r2 = (struct wbint_LookupName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* wbint_Sids2UnixIDs */
		struct wbint_Sids2UnixIDs *r2 = (struct wbint_Sids2UnixIDs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_Sids2UnixIDs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_Sids2UnixIDs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_Sids2UnixIDs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* wbint_UnixIDs2Sids */
		struct wbint_UnixIDs2Sids *r2 = (struct wbint_UnixIDs2Sids *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_UnixIDs2Sids replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_UnixIDs2Sids, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_UnixIDs2Sids\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* wbint_AllocateUid */
		struct wbint_AllocateUid *r2 = (struct wbint_AllocateUid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_AllocateUid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_AllocateUid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_AllocateUid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* wbint_AllocateGid */
		struct wbint_AllocateGid *r2 = (struct wbint_AllocateGid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_AllocateGid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_AllocateGid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_AllocateGid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* wbint_GetNssInfo */
		struct wbint_GetNssInfo *r2 = (struct wbint_GetNssInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_GetNssInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_GetNssInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_GetNssInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* wbint_LookupUserAliases */
		struct wbint_LookupUserAliases *r2 = (struct wbint_LookupUserAliases *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupUserAliases replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupUserAliases, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupUserAliases\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* wbint_LookupUserGroups */
		struct wbint_LookupUserGroups *r2 = (struct wbint_LookupUserGroups *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupUserGroups replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupUserGroups, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupUserGroups\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* wbint_QuerySequenceNumber */
		struct wbint_QuerySequenceNumber *r2 = (struct wbint_QuerySequenceNumber *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_QuerySequenceNumber replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_QuerySequenceNumber, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_QuerySequenceNumber\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* wbint_LookupGroupMembers */
		struct wbint_LookupGroupMembers *r2 = (struct wbint_LookupGroupMembers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupGroupMembers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupGroupMembers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupGroupMembers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* wbint_LookupAliasMembers */
		struct wbint_LookupAliasMembers *r2 = (struct wbint_LookupAliasMembers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupAliasMembers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupAliasMembers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupAliasMembers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* wbint_QueryGroupList */
		struct wbint_QueryGroupList *r2 = (struct wbint_QueryGroupList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_QueryGroupList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_QueryGroupList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_QueryGroupList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* wbint_QueryUserRidList */
		struct wbint_QueryUserRidList *r2 = (struct wbint_QueryUserRidList *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_QueryUserRidList replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_QueryUserRidList, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_QueryUserRidList\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* wbint_DsGetDcName */
		struct wbint_DsGetDcName *r2 = (struct wbint_DsGetDcName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_DsGetDcName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_DsGetDcName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_DsGetDcName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* wbint_LookupRids */
		struct wbint_LookupRids *r2 = (struct wbint_LookupRids *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_LookupRids replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_LookupRids, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_LookupRids\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* wbint_CheckMachineAccount */
		struct wbint_CheckMachineAccount *r2 = (struct wbint_CheckMachineAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_CheckMachineAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_CheckMachineAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_CheckMachineAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* wbint_ChangeMachineAccount */
		struct wbint_ChangeMachineAccount *r2 = (struct wbint_ChangeMachineAccount *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_ChangeMachineAccount replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_ChangeMachineAccount, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_ChangeMachineAccount\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* wbint_PingDc */
		struct wbint_PingDc *r2 = (struct wbint_PingDc *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_PingDc replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PingDc, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_PingDc\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* wbint_ListTrustedDomains */
		struct wbint_ListTrustedDomains *r2 = (struct wbint_ListTrustedDomains *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_ListTrustedDomains replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_ListTrustedDomains, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_ListTrustedDomains\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* wbint_PamAuth */
		struct wbint_PamAuth *r2 = (struct wbint_PamAuth *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_PamAuth replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuth, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_PamAuth\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* wbint_PamAuthCrap */
		struct wbint_PamAuthCrap *r2 = (struct wbint_PamAuthCrap *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_PamAuthCrap replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuthCrap, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_PamAuthCrap\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* wbint_PamLogOff */
		struct wbint_PamLogOff *r2 = (struct wbint_PamLogOff *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_PamLogOff replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamLogOff, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_PamLogOff\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* wbint_PamAuthCrapChangePassword */
		struct wbint_PamAuthCrapChangePassword *r2 = (struct wbint_PamAuthCrapChangePassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_PamAuthCrapChangePassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuthCrapChangePassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_PamAuthCrapChangePassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* wbint_PamAuthChangePassword */
		struct wbint_PamAuthChangePassword *r2 = (struct wbint_PamAuthChangePassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_PamAuthChangePassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_PamAuthChangePassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_PamAuthChangePassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* wbint_InitConnection */
		struct wbint_InitConnection *r2 = (struct wbint_InitConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_InitConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_InitConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_InitConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* wbint_NormalizeNameMap */
		struct wbint_NormalizeNameMap *r2 = (struct wbint_NormalizeNameMap *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_NormalizeNameMap replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_NormalizeNameMap, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_NormalizeNameMap\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* wbint_NormalizeNameUnmap */
		struct wbint_NormalizeNameUnmap *r2 = (struct wbint_NormalizeNameUnmap *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wbint_NormalizeNameUnmap replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wbint_NormalizeNameUnmap, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wbint_NormalizeNameUnmap\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* winbind_SamLogon */
		struct winbind_SamLogon *r2 = (struct winbind_SamLogon *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winbind_SamLogon replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_SamLogon, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winbind_SamLogon\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* winbind_DsrUpdateReadOnlyServerDnsRecords */
		struct winbind_DsrUpdateReadOnlyServerDnsRecords *r2 = (struct winbind_DsrUpdateReadOnlyServerDnsRecords *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winbind_DsrUpdateReadOnlyServerDnsRecords replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_DsrUpdateReadOnlyServerDnsRecords, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winbind_DsrUpdateReadOnlyServerDnsRecords\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* winbind_LogonControl */
		struct winbind_LogonControl *r2 = (struct winbind_LogonControl *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winbind_LogonControl replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_LogonControl, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winbind_LogonControl\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* winbind_GetForestTrustInformation */
		struct winbind_GetForestTrustInformation *r2 = (struct winbind_GetForestTrustInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winbind_GetForestTrustInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_GetForestTrustInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winbind_GetForestTrustInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* winbind_SendToSam */
		struct winbind_SendToSam *r2 = (struct winbind_SendToSam *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function winbind_SendToSam replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(winbind_SendToSam, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in winbind_SendToSam\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS winbind__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_winbind.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS winbind__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return winbind__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_winbind_interface = {
	.name      = "winbind",
	.syntax_id = {{0xbf09192c,0xed60,0x4928,{0x9d,0xff},{0xd0,0xd7,0xbc,0xb0,0x3e,0xd8}},1.0},
	.bind      = winbind__op_bind,
	.unbind    = winbind__op_unbind,
	.ndr_pull  = winbind__op_ndr_pull,
	.dispatch  = winbind__op_dispatch,
	.reply     = winbind__op_reply,
	.ndr_push  = winbind__op_ndr_push,
	.local     = winbind__op_local,
#ifdef DCESRV_INTERFACE_WINBIND_FLAGS
	.flags     = DCESRV_INTERFACE_WINBIND_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS winbind__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_WINBIND_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_WINBIND_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_winbind.endpoints->count;i++) {
		const char *name = ndr_table_winbind.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_winbind_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS winbind__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool winbind__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_winbind_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_winbind_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_winbind_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool winbind__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_winbind_interface.name, name)==0) {
		memcpy(iface, &dcesrv_winbind_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server winbind_ep_server = {
	/* fill in our name */
	.name = "winbind",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_WINBIND_INIT_SERVER
	.init_server = DCESRV_INTERFACE_WINBIND_INIT_SERVER,
#else
	.init_server = winbind__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_WINBIND_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_WINBIND_SHUTDOWN_SERVER,
#else
	.shutdown_server = winbind__op_shutdown_server,
#endif
	.interface_by_uuid = winbind__op_interface_by_uuid,
	.interface_by_name = winbind__op_interface_by_name
};

const struct dcesrv_endpoint_server *winbind_get_ep_server(void)
{
	return &winbind_ep_server;
}
