/*
 * $Id: proc_version.c,v 1.1 2001/03/15 22:16:13 jpormann Exp jpormann $
 *
 * procstatd - Copyright (c) 1999 by Robert G. Brown, rgb@phy.duke.edu
 *         GPL version 2b (b for beverage) granted.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * procstatd - A daemon to extract statistics from /proc/stat and publish them
 *         on demand via a socket connection or broadcast.
 */

#include "procstatd.h"

/*
 * All code to handle PROC_VERSION
 */

void init_proc_version()
{

 char delim[7],*nextval;
 int i,numfields;

 /* 
  * Open /proc/version.
  */
 stat_fd[PROC_VERSION] = fopen("/proc/version","r");

 /*
  * If the open succeeded, the file descriptor is nonzero.  We then
  * initialize all stats derived from /proc/version.  Put values into
  * stats[FIELD].{name,source,avail,current,previous,rate}
  */

 /* /proc/version */
 if(stat_fd[PROC_VERSION]){
   /* Only contains one line, so not much to parse */
   fgets(statbuf,BUFLEN,stat_fd[PROC_VERSION]);
   /* parse the line into fields */
   numfields = parse(statbuf,fields,MAXFIELDNUMBER,BUFLEN);

   /* VERSION */
   /* JBP: removed equals-signs, used to be "version=%s" */
   sprintf(stats[VERSION].name,"version %s",fields[2]);	/* Label contains data. */
   stats[VERSION].source = PROC_VERSION;		/* Tag its source for xref */
   stats[VERSION].avail = 1;			/* Yes, we found it */
   stats[VERSION].current = 0.0;		/* current value is unimportant */

 }

 /*
  * The code above is the standard "object" code.  However, we have to
  * set some global variables for use in all the OTHER proc_XXXX routines
  * to adjust for changes in /proc formats.  The following is therefore
  * ad hoc code that will pull kernel.major, kernel.minor, kernel.revision
  * from fields[2].
  */

/* 
 * Parse on . or - separators; the latter to split off e.g. RH's id number
 */
 delim[0] = '.';                /* period */
 delim[1] = '-';                /* dash */
 delim[6] = (char) NULL;        /* terminator */

 nextval = strtok(fields[2],delim);
 kernel.major = atoi(nextval);
 nextval = strtok((char *) NULL, delim);
 kernel.minor = atoi(nextval);
 nextval = strtok((char *) NULL, delim);
 kernel.revision = atoi(nextval);

 /* ... and ignore the rest? */

} /* End init_proc_version.  Leave stat_fd[PROC_VERSION] open */

/* Get PROC_VERSION stats */
void get_proc_version()
{

  /* Dummy routine.  Kernel version never changes.  We hope. */

} /* End of get_proc_version() */


/*
 * I'm leaving a loop through all enumerated types in places like this
 * (for now) even though it would be faster to just put in the only
 * three hits inline and skip the loop and case switch.  This is to
 * make it really easy to turn this whole thing into real OO code (or
 * move the ordinary code even further toward OO structure).  I could
 * define a "method" for evaluating stats[OBJ].rate, for example, that
 * worked for all the different "kinds" of rates (since basically either
 * the raw value or the interval rate is returned for everything but e.g.
 * users and time).  Wastes a bit of time, but I think that this code is
 * really pretty cheap anyway and can afford it during development...
 */

void eval_proc_version()
{

  /* Dummy routine.  Kernel version never changes.  We hope. */

} /* End eval_proc_version() */
