/* DockItemProvider.c generated by valac 0.56.17, the Vala compiler
 * generated from DockItemProvider.vala, do not modify */

/**/
/*  Copyright (C) 2014 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_ITEM_PROVIDER_0_PROPERTY,
	PLANK_DOCK_ITEM_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* plank_dock_item_provider_properties[PLANK_DOCK_ITEM_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer plank_dock_item_provider_parent_class = NULL;

static gboolean plank_dock_item_provider_real_item_exists_for_uri (PlankDockItemProvider* self,
                                                            const gchar* uri);
static PlankDockItem* plank_dock_item_provider_real_item_for_uri (PlankDockItemProvider* self,
                                                           const gchar* uri);
static gboolean plank_dock_item_provider_real_add_item_with_uri (PlankDockItemProvider* self,
                                                          const gchar* uri,
                                                          PlankDockItem* target);
static gboolean plank_dock_item_provider_real_can_accept_drop (PlankDockElement* base,
                                                        GeeArrayList* uris);
static gboolean plank_dock_item_provider_real_accept_drop (PlankDockElement* base,
                                                    GeeArrayList* uris);
static void plank_dock_item_provider_real_connect_element (PlankDockContainer* base,
                                                    PlankDockElement* element);
static void plank_dock_item_provider_handle_item_state_changed (PlankDockItemProvider* self);
static void _plank_dock_item_provider_handle_item_state_changed_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void _plank_dock_item_provider_handle_item_state_changed_plank_dock_element_needs_redraw (PlankDockElement* _sender,
                                                                                          gpointer self);
static void _plank_dock_item_provider_handle_item_deleted_plank_dock_item_deleted (PlankDockItem* _sender,
                                                                            gpointer self);
static void plank_dock_item_provider_real_disconnect_element (PlankDockContainer* base,
                                                       PlankDockElement* element);
static void plank_dock_item_provider_real_handle_item_deleted (PlankDockItemProvider* self,
                                                        PlankDockItem* item);
static gchar** plank_dock_item_provider_real_get_dockitem_filenames (PlankDockItemProvider* self,
                                                              gint* result_length1);
static GType plank_dock_item_provider_get_type_once (void);

/**
 * Creates a new container for dock items.
 */
PlankDockItemProvider*
plank_dock_item_provider_construct (GType object_type)
{
	PlankDockItemProvider * self = NULL;
	self = (PlankDockItemProvider*) g_object_new (object_type, NULL);
	return self;
}

PlankDockItemProvider*
plank_dock_item_provider_new (void)
{
	return plank_dock_item_provider_construct (PLANK_TYPE_DOCK_ITEM_PROVIDER);
}

/**
 * Whether a dock item with the given URI exists in this provider.
 *
 * @param uri the URI to look for
 */
static gboolean
plank_dock_item_provider_real_item_exists_for_uri (PlankDockItemProvider* self,
                                                   const gchar* uri)
{
	PlankDockItem* _tmp0_;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = plank_dock_item_provider_item_for_uri (self, uri);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
plank_dock_item_provider_item_exists_for_uri (PlankDockItemProvider* self,
                                              const gchar* uri)
{
	PlankDockItemProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_ITEM_PROVIDER_GET_CLASS (self);
	if (_klass_->item_exists_for_uri) {
		return _klass_->item_exists_for_uri (self, uri);
	}
	return FALSE;
}

/**
 * Get the dock item for the given URI if it exists or null.
 *
 * @param uri the URI to look for
 */
static PlankDockItem*
plank_dock_item_provider_real_item_for_uri (PlankDockItemProvider* self,
                                            const gchar* uri)
{
	PlankDockItem* result;
	g_return_val_if_fail (uri != NULL, NULL);
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp0_;
		gint _element_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _element_index = 0;
		_tmp0_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp0_;
		_tmp1_ = _element_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_element_size = _tmp3_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp8_;
			gboolean _tmp9_ = FALSE;
			PlankDockItem* _tmp10_;
			_element_index = _element_index + 1;
			_tmp4_ = _element_index;
			_tmp5_ = _element_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _element_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _element_index);
			element = (PlankDockElement*) _tmp7_;
			_tmp8_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp8_) ? ((PlankDockItem*) _tmp8_) : NULL;
			_tmp10_ = item;
			if (_tmp10_ != NULL) {
				PlankDockItem* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = item;
				_tmp12_ = plank_dock_item_get_Launcher (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp9_ = g_strcmp0 (_tmp13_, uri) == 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				PlankDockItem* _tmp14_;
				_tmp14_ = item;
				result = _tmp14_;
				_g_object_unref0 (element);
				return result;
			}
			_g_object_unref0 (element);
		}
	}
	result = NULL;
	return result;
}

PlankDockItem*
plank_dock_item_provider_item_for_uri (PlankDockItemProvider* self,
                                       const gchar* uri)
{
	PlankDockItemProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_DOCK_ITEM_PROVIDER_GET_CLASS (self);
	if (_klass_->item_for_uri) {
		return _klass_->item_for_uri (self, uri);
	}
	return NULL;
}

/**
 * Adds a dock item with the given URI to the collection.
 *
 * @param uri the URI to add a dock item for
 * @param target an existing item where to put this new one at
 * @return whether adding the URI was successful
 */
static gboolean
plank_dock_item_provider_real_add_item_with_uri (PlankDockItemProvider* self,
                                                 const gchar* uri,
                                                 PlankDockItem* target)
{
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_warning ("DockItemProvider.vala:70: Not implemented by default");
	result = FALSE;
	return result;
}

gboolean
plank_dock_item_provider_add_item_with_uri (PlankDockItemProvider* self,
                                            const gchar* uri,
                                            PlankDockItem* target)
{
	PlankDockItemProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_ITEM_PROVIDER_GET_CLASS (self);
	if (_klass_->add_item_with_uri) {
		return _klass_->add_item_with_uri (self, uri, target);
	}
	return FALSE;
}

static gboolean
plank_dock_item_provider_real_can_accept_drop (PlankDockElement* base,
                                               GeeArrayList* uris)
{
	PlankDockItemProvider * self;
	gboolean result;
	self = (PlankDockItemProvider*) base;
	g_return_val_if_fail (uris != NULL, FALSE);
	{
		GeeArrayList* _uri_list = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _uri_index = 0;
		_uri_list = uris;
		_tmp0_ = _uri_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_uri_size = _tmp2_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			gchar* uri = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
			_uri_index = _uri_index + 1;
			_tmp3_ = _uri_index;
			_tmp4_ = _uri_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _uri_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _uri_index);
			uri = (gchar*) _tmp6_;
			_tmp7_ = uri;
			if (!plank_dock_item_provider_item_exists_for_uri (self, _tmp7_)) {
				result = TRUE;
				_g_free0 (uri);
				return result;
			}
			_g_free0 (uri);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
plank_dock_item_provider_real_accept_drop (PlankDockElement* base,
                                           GeeArrayList* uris)
{
	PlankDockItemProvider * self;
	gboolean _result_ = FALSE;
	PlankDockItem* target_item = NULL;
	PlankDockController* controller = NULL;
	PlankDockController* _tmp0_;
	gboolean _tmp1_ = FALSE;
	PlankDockController* _tmp2_;
	gboolean result;
	self = (PlankDockItemProvider*) base;
	g_return_val_if_fail (uris != NULL, FALSE);
	_result_ = FALSE;
	target_item = NULL;
	_tmp0_ = plank_dock_element_get_dock ((PlankDockElement*) self);
	controller = _tmp0_;
	_tmp2_ = controller;
	if (_tmp2_ != NULL) {
		PlankDockController* _tmp3_;
		PlankDockWindow* _tmp4_;
		PlankDockWindow* _tmp5_;
		PlankDockItemProvider* _tmp6_;
		PlankDockItemProvider* _tmp7_;
		_tmp3_ = controller;
		_tmp4_ = plank_dock_controller_get_window (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = plank_dock_window_get_HoveredItemProvider (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == self;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PlankDockController* _tmp8_;
		PlankPositionManager* _tmp9_;
		PlankPositionManager* _tmp10_;
		PlankDockItem* _tmp11_;
		_tmp8_ = controller;
		_tmp9_ = plank_dock_controller_get_position_manager (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = plank_position_manager_get_current_target_item (_tmp10_, (PlankDockContainer*) self);
		target_item = _tmp11_;
	}
	{
		GeeArrayList* _uri_list = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _uri_index = 0;
		_uri_list = uris;
		_tmp12_ = _uri_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_uri_size = _tmp14_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gchar* uri = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			const gchar* _tmp19_;
			_uri_index = _uri_index + 1;
			_tmp15_ = _uri_index;
			_tmp16_ = _uri_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _uri_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _uri_index);
			uri = (gchar*) _tmp18_;
			_tmp19_ = uri;
			if (!plank_dock_item_provider_item_exists_for_uri (self, _tmp19_)) {
				const gchar* _tmp20_;
				PlankDockItem* _tmp21_;
				_tmp20_ = uri;
				_tmp21_ = target_item;
				plank_dock_item_provider_add_item_with_uri (self, _tmp20_, _tmp21_);
				_result_ = TRUE;
			}
			_g_free0 (uri);
		}
	}
	result = _result_;
	return result;
}

static void
_plank_dock_item_provider_handle_item_state_changed_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	plank_dock_item_provider_handle_item_state_changed ((PlankDockItemProvider*) self);
}

static void
_plank_dock_item_provider_handle_item_state_changed_plank_dock_element_needs_redraw (PlankDockElement* _sender,
                                                                                     gpointer self)
{
	plank_dock_item_provider_handle_item_state_changed ((PlankDockItemProvider*) self);
}

static void
_plank_dock_item_provider_handle_item_deleted_plank_dock_item_deleted (PlankDockItem* _sender,
                                                                       gpointer self)
{
	plank_dock_item_provider_handle_item_deleted ((PlankDockItemProvider*) self, _sender);
}

static void
plank_dock_item_provider_real_connect_element (PlankDockContainer* base,
                                               PlankDockElement* element)
{
	PlankDockItemProvider * self;
	PlankDockItem* item = NULL;
	PlankDockItem* _tmp0_;
	PlankDockItem* _tmp1_;
	PlankDockItem* _tmp2_;
	PlankDockItem* _tmp3_;
	PlankDockItem* _tmp4_;
	PlankDockItem* _tmp5_;
	self = (PlankDockItemProvider*) base;
	g_return_if_fail (element != NULL);
	item = PLANK_IS_DOCK_ITEM (element) ? ((PlankDockItem*) element) : NULL;
	_tmp0_ = item;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = item;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::Indicator", (GCallback) _plank_dock_item_provider_handle_item_state_changed_g_object_notify, self, 0);
	_tmp2_ = item;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::State", (GCallback) _plank_dock_item_provider_handle_item_state_changed_g_object_notify, self, 0);
	_tmp3_ = item;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::LastClicked", (GCallback) _plank_dock_item_provider_handle_item_state_changed_g_object_notify, self, 0);
	_tmp4_ = item;
	g_signal_connect_object ((PlankDockElement*) _tmp4_, "needs-redraw", (GCallback) _plank_dock_item_provider_handle_item_state_changed_plank_dock_element_needs_redraw, self, 0);
	_tmp5_ = item;
	g_signal_connect_object (_tmp5_, "deleted", (GCallback) _plank_dock_item_provider_handle_item_deleted_plank_dock_item_deleted, self, 0);
}

static void
plank_dock_item_provider_real_disconnect_element (PlankDockContainer* base,
                                                  PlankDockElement* element)
{
	PlankDockItemProvider * self;
	PlankDockItem* item = NULL;
	PlankDockItem* _tmp0_;
	PlankDockItem* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	PlankDockItem* _tmp4_;
	guint _tmp5_;
	GQuark _tmp6_;
	PlankDockItem* _tmp7_;
	guint _tmp8_;
	GQuark _tmp9_;
	PlankDockItem* _tmp10_;
	guint _tmp11_;
	PlankDockItem* _tmp12_;
	guint _tmp13_;
	self = (PlankDockItemProvider*) base;
	g_return_if_fail (element != NULL);
	item = PLANK_IS_DOCK_ITEM (element) ? ((PlankDockItem*) element) : NULL;
	_tmp0_ = item;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = item;
	g_signal_parse_name ("notify::Indicator", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _plank_dock_item_provider_handle_item_state_changed_g_object_notify, self);
	_tmp4_ = item;
	g_signal_parse_name ("notify::State", G_TYPE_OBJECT, &_tmp5_, &_tmp6_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) _plank_dock_item_provider_handle_item_state_changed_g_object_notify, self);
	_tmp7_ = item;
	g_signal_parse_name ("notify::LastClicked", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _plank_dock_item_provider_handle_item_state_changed_g_object_notify, self);
	_tmp10_ = item;
	g_signal_parse_name ("needs-redraw", PLANK_TYPE_DOCK_ELEMENT, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((PlankDockElement*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _plank_dock_item_provider_handle_item_state_changed_plank_dock_element_needs_redraw, self);
	_tmp12_ = item;
	g_signal_parse_name ("deleted", PLANK_TYPE_DOCK_ITEM, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _plank_dock_item_provider_handle_item_deleted_plank_dock_item_deleted, self);
}

static void
plank_dock_item_provider_handle_item_state_changed (PlankDockItemProvider* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((PlankDockContainer*) self, "states-changed");
}

static void
plank_dock_item_provider_real_handle_item_deleted (PlankDockItemProvider* self,
                                                   PlankDockItem* item)
{
	g_return_if_fail (item != NULL);
	plank_dock_container_remove ((PlankDockContainer*) self, (PlankDockElement*) item);
}

void
plank_dock_item_provider_handle_item_deleted (PlankDockItemProvider* self,
                                              PlankDockItem* item)
{
	PlankDockItemProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_ITEM_PROVIDER_GET_CLASS (self);
	if (_klass_->handle_item_deleted) {
		_klass_->handle_item_deleted (self, item);
	}
}

/**
 * Get ordered array of dockitem-filenames handled by this provider
 *
 * @return an ordered array of strings containing all basenames
 */
static gchar**
plank_dock_item_provider_real_get_dockitem_filenames (PlankDockItemProvider* self,
                                                      gint* result_length1)
{
	GeeArrayList* item_list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp20_;
	gint _tmp21_ = 0;
	gpointer* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** result;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	item_list = _tmp0_;
	{
		GeeArrayList* _element_list = NULL;
		GeeArrayList* _tmp1_;
		gint _element_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _element_index = 0;
		_tmp1_ = ((PlankDockContainer*) self)->internal_elements;
		_element_list = _tmp1_;
		_tmp2_ = _element_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_element_size = _tmp4_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp9_;
			PlankDockItem* _tmp10_;
			gchar* dock_item_filename = NULL;
			PlankDockItem* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_element_index = _element_index + 1;
			_tmp5_ = _element_index;
			_tmp6_ = _element_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _element_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _element_index);
			element = (PlankDockElement*) _tmp8_;
			_tmp9_ = element;
			item = PLANK_IS_DOCK_ITEM (_tmp9_) ? ((PlankDockItem*) _tmp9_) : NULL;
			_tmp10_ = item;
			if (_tmp10_ == NULL) {
				_g_object_unref0 (element);
				continue;
			}
			_tmp11_ = item;
			_tmp12_ = plank_dock_item_get_DockItemFilename (_tmp11_);
			_tmp13_ = _tmp12_;
			dock_item_filename = _tmp13_;
			_tmp14_ = dock_item_filename;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ > 0) {
				GeeArrayList* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = item_list;
				_tmp18_ = dock_item_filename;
				dock_item_filename = NULL;
				_tmp19_ = _tmp18_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp19_);
				_g_free0 (_tmp19_);
			}
			_g_free0 (dock_item_filename);
			_g_object_unref0 (element);
		}
	}
	_tmp20_ = item_list;
	_tmp22_ = gee_collection_to_array ((GeeCollection*) _tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_g_object_unref0 (item_list);
	return result;
}

gchar**
plank_dock_item_provider_get_dockitem_filenames (PlankDockItemProvider* self,
                                                 gint* result_length1)
{
	PlankDockItemProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PLANK_DOCK_ITEM_PROVIDER_GET_CLASS (self);
	if (_klass_->get_dockitem_filenames) {
		return _klass_->get_dockitem_filenames (self, result_length1);
	}
	return NULL;
}

static void
plank_dock_item_provider_class_init (PlankDockItemProviderClass * klass,
                                     gpointer klass_data)
{
	plank_dock_item_provider_parent_class = g_type_class_peek_parent (klass);
	((PlankDockItemProviderClass *) klass)->item_exists_for_uri = (gboolean (*) (PlankDockItemProvider*, const gchar*)) plank_dock_item_provider_real_item_exists_for_uri;
	((PlankDockItemProviderClass *) klass)->item_for_uri = (PlankDockItem* (*) (PlankDockItemProvider*, const gchar*)) plank_dock_item_provider_real_item_for_uri;
	((PlankDockItemProviderClass *) klass)->add_item_with_uri = (gboolean (*) (PlankDockItemProvider*, const gchar*, PlankDockItem*)) plank_dock_item_provider_real_add_item_with_uri;
	((PlankDockElementClass *) klass)->can_accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) plank_dock_item_provider_real_can_accept_drop;
	((PlankDockElementClass *) klass)->accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) plank_dock_item_provider_real_accept_drop;
	((PlankDockContainerClass *) klass)->connect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_dock_item_provider_real_connect_element;
	((PlankDockContainerClass *) klass)->disconnect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_dock_item_provider_real_disconnect_element;
	((PlankDockItemProviderClass *) klass)->handle_item_deleted = (void (*) (PlankDockItemProvider*, PlankDockItem*)) plank_dock_item_provider_real_handle_item_deleted;
	((PlankDockItemProviderClass *) klass)->get_dockitem_filenames = (gchar** (*) (PlankDockItemProvider*, gint*)) plank_dock_item_provider_real_get_dockitem_filenames;
}

static void
plank_dock_item_provider_instance_init (PlankDockItemProvider * self,
                                        gpointer klass)
{
}

/**
 * A container and controller class for managing dock items.
 */
static GType
plank_dock_item_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockItemProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_item_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockItemProvider), 0, (GInstanceInitFunc) plank_dock_item_provider_instance_init, NULL };
	GType plank_dock_item_provider_type_id;
	plank_dock_item_provider_type_id = g_type_register_static (PLANK_TYPE_DOCK_CONTAINER, "PlankDockItemProvider", &g_define_type_info, 0);
	return plank_dock_item_provider_type_id;
}

GType
plank_dock_item_provider_get_type (void)
{
	static volatile gsize plank_dock_item_provider_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_item_provider_type_id__once)) {
		GType plank_dock_item_provider_type_id;
		plank_dock_item_provider_type_id = plank_dock_item_provider_get_type_once ();
		g_once_init_leave (&plank_dock_item_provider_type_id__once, plank_dock_item_provider_type_id);
	}
	return plank_dock_item_provider_type_id__once;
}

