/* Interfaces.c generated by valac 0.56.17, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include "plank.h"

#define PLANK_DBUS_PING_NAME "Ping"
#define PLANK_DBUS_DOCK_INTERFACE_NAME "net.launchpad.plank"
#define PLANK_DBUS_CLIENT_INTERFACE_NAME "net.launchpad.plank.Client"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PLANK_TYPE_DBUS_ITEMS_IFACE (plank_dbus_items_iface_get_type ())
#define PLANK_DBUS_ITEMS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE, PlankDBusItemsIface))
#define PLANK_IS_DBUS_ITEMS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE))
#define PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PLANK_TYPE_DBUS_ITEMS_IFACE, PlankDBusItemsIfaceIface))

typedef struct _PlankDBusItemsIface PlankDBusItemsIface;
typedef struct _PlankDBusItemsIfaceIface PlankDBusItemsIfaceIface;

#define PLANK_TYPE_DBUS_ITEMS_IFACE_PROXY (plank_dbus_items_iface_proxy_get_type ())
enum  {
	PLANK_DBUS_ITEMS_IFACE_CHANGED_SIGNAL,
	PLANK_DBUS_ITEMS_IFACE_NUM_SIGNALS
};
static guint plank_dbus_items_iface_signals[PLANK_DBUS_ITEMS_IFACE_NUM_SIGNALS] = {0};
typedef GDBusProxy PlankDBusItemsIfaceProxy;
typedef GDBusProxyClass PlankDBusItemsIfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PlankDBusItemsIfaceIface {
	GTypeInterface parent_iface;
	gboolean (*add) (PlankDBusItemsIface* self, const gchar* uri, GError** error);
	gboolean (*remove) (PlankDBusItemsIface* self, const gchar* uri, GError** error);
	gint (*get_count) (PlankDBusItemsIface* self, GError** error);
	gchar** (*get_persistent_applications) (PlankDBusItemsIface* self, gint* result_length1, GError** error);
	gchar** (*get_transient_applications) (PlankDBusItemsIface* self, gint* result_length1, GError** error);
	gboolean (*get_hover_position) (PlankDBusItemsIface* self, const gchar* uri, gint* x, gint* y, GtkPositionType* dock_position, GError** error);
};

VALA_EXTERN GType plank_dbus_items_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint plank_dbus_items_iface_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
VALA_EXTERN GType plank_dbus_items_iface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean plank_dbus_items_iface_add (PlankDBusItemsIface* self,
                                     const gchar* uri,
                                     GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_remove (PlankDBusItemsIface* self,
                                        const gchar* uri,
                                        GError** error);
VALA_EXTERN gint plank_dbus_items_iface_get_count (PlankDBusItemsIface* self,
                                       GError** error);
VALA_EXTERN gchar** plank_dbus_items_iface_get_persistent_applications (PlankDBusItemsIface* self,
                                                            gint* result_length1,
                                                            GError** error);
VALA_EXTERN gchar** plank_dbus_items_iface_get_transient_applications (PlankDBusItemsIface* self,
                                                           gint* result_length1,
                                                           GError** error);
VALA_EXTERN gboolean plank_dbus_items_iface_get_hover_position (PlankDBusItemsIface* self,
                                                    const gchar* uri,
                                                    gint* x,
                                                    gint* y,
                                                    GtkPositionType* dock_position,
                                                    GError** error);
static GType plank_dbus_items_iface_get_type_once (void);
static void plank_dbus_items_iface_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static void _dbus_handle_plank_dbus_items_iface_changed (PlankDBusItemsIface* self,
                                                  GVariant* parameters);
static gboolean plank_dbus_items_iface_proxy_add (PlankDBusItemsIface* self,
                                           const gchar* uri,
                                           GError** error);
static gboolean plank_dbus_items_iface_proxy_remove (PlankDBusItemsIface* self,
                                              const gchar* uri,
                                              GError** error);
static gint plank_dbus_items_iface_proxy_get_count (PlankDBusItemsIface* self,
                                             GError** error);
static gchar** plank_dbus_items_iface_proxy_get_persistent_applications (PlankDBusItemsIface* self,
                                                                  gint* result_length1,
                                                                  GError** error);
static gchar** plank_dbus_items_iface_proxy_get_transient_applications (PlankDBusItemsIface* self,
                                                                 gint* result_length1,
                                                                 GError** error);
static gboolean plank_dbus_items_iface_proxy_get_hover_position (PlankDBusItemsIface* self,
                                                          const gchar* uri,
                                                          gint* x,
                                                          gint* y,
                                                          GtkPositionType* dock_position,
                                                          GError** error);
static void plank_dbus_items_iface_proxy_plank_dbus_items_iface_interface_init (PlankDBusItemsIfaceIface* iface);
static void _dbus_plank_dbus_items_iface_add (PlankDBusItemsIface* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_plank_dbus_items_iface_remove (PlankDBusItemsIface* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_plank_dbus_items_iface_get_count (PlankDBusItemsIface* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_plank_dbus_items_iface_get_persistent_applications (PlankDBusItemsIface* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation);
static void _dbus_plank_dbus_items_iface_get_transient_applications (PlankDBusItemsIface* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_plank_dbus_items_iface_get_hover_position (PlankDBusItemsIface* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void plank_dbus_items_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* plank_dbus_items_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean plank_dbus_items_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _dbus_plank_dbus_items_iface_changed (GObject* _sender,
                                           gpointer* _data);
static void _plank_dbus_items_iface_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_add_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_add_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_add_in[] = {&_plank_dbus_items_iface_dbus_arg_info_add_uri, NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_add_out[] = {&_plank_dbus_items_iface_dbus_arg_info_add_result, NULL};
static const GDBusMethodInfo _plank_dbus_items_iface_dbus_method_info_add = {-1, "Add", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_add_in), (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_add_out), NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_remove_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_remove_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_remove_in[] = {&_plank_dbus_items_iface_dbus_arg_info_remove_uri, NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_remove_out[] = {&_plank_dbus_items_iface_dbus_arg_info_remove_result, NULL};
static const GDBusMethodInfo _plank_dbus_items_iface_dbus_method_info_remove = {-1, "Remove", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_remove_in), (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_remove_out), NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_count_result = {-1, "result", "i", NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_count_in[] = {NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_count_out[] = {&_plank_dbus_items_iface_dbus_arg_info_get_count_result, NULL};
static const GDBusMethodInfo _plank_dbus_items_iface_dbus_method_info_get_count = {-1, "GetCount", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_count_in), (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_count_out), NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_persistent_applications_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_persistent_applications_in[] = {NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_persistent_applications_out[] = {&_plank_dbus_items_iface_dbus_arg_info_get_persistent_applications_result, NULL};
static const GDBusMethodInfo _plank_dbus_items_iface_dbus_method_info_get_persistent_applications = {-1, "GetPersistentApplications", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_persistent_applications_in), (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_persistent_applications_out), NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_transient_applications_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_transient_applications_in[] = {NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_transient_applications_out[] = {&_plank_dbus_items_iface_dbus_arg_info_get_transient_applications_result, NULL};
static const GDBusMethodInfo _plank_dbus_items_iface_dbus_method_info_get_transient_applications = {-1, "GetTransientApplications", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_transient_applications_in), (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_transient_applications_out), NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_hover_position_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_hover_position_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_hover_position_y = {-1, "y", "i", NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_hover_position_dock_position = {-1, "dock_position", "i", NULL};
static const GDBusArgInfo _plank_dbus_items_iface_dbus_arg_info_get_hover_position_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_hover_position_in[] = {&_plank_dbus_items_iface_dbus_arg_info_get_hover_position_uri, NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_get_hover_position_out[] = {&_plank_dbus_items_iface_dbus_arg_info_get_hover_position_x, &_plank_dbus_items_iface_dbus_arg_info_get_hover_position_y, &_plank_dbus_items_iface_dbus_arg_info_get_hover_position_dock_position, &_plank_dbus_items_iface_dbus_arg_info_get_hover_position_result, NULL};
static const GDBusMethodInfo _plank_dbus_items_iface_dbus_method_info_get_hover_position = {-1, "GetHoverPosition", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_hover_position_in), (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_get_hover_position_out), NULL};
static const GDBusMethodInfo * const _plank_dbus_items_iface_dbus_method_info[] = {&_plank_dbus_items_iface_dbus_method_info_add, &_plank_dbus_items_iface_dbus_method_info_remove, &_plank_dbus_items_iface_dbus_method_info_get_count, &_plank_dbus_items_iface_dbus_method_info_get_persistent_applications, &_plank_dbus_items_iface_dbus_method_info_get_transient_applications, &_plank_dbus_items_iface_dbus_method_info_get_hover_position, NULL};
static const GDBusArgInfo * const _plank_dbus_items_iface_dbus_arg_info_changed[] = {NULL};
static const GDBusSignalInfo _plank_dbus_items_iface_dbus_signal_info_changed = {-1, "Changed", (GDBusArgInfo **) (&_plank_dbus_items_iface_dbus_arg_info_changed), NULL};
static const GDBusSignalInfo * const _plank_dbus_items_iface_dbus_signal_info[] = {&_plank_dbus_items_iface_dbus_signal_info_changed, NULL};
static const GDBusPropertyInfo * const _plank_dbus_items_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _plank_dbus_items_iface_dbus_interface_info = {-1, "net.launchpad.plank.Items", (GDBusMethodInfo **) (&_plank_dbus_items_iface_dbus_method_info), (GDBusSignalInfo **) (&_plank_dbus_items_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_plank_dbus_items_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _plank_dbus_items_iface_dbus_interface_vtable = {plank_dbus_items_iface_dbus_interface_method_call, plank_dbus_items_iface_dbus_interface_get_property, plank_dbus_items_iface_dbus_interface_set_property};

/**
 * Add a new item for the given uri to the dock
 *
 * @param uri an URI
 * @return whether it was successfully added
 */
gboolean
plank_dbus_items_iface_add (PlankDBusItemsIface* self,
                            const gchar* uri,
                            GError** error)
{
	PlankDBusItemsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE (self);
	if (_iface_->add) {
		return _iface_->add (self, uri, error);
	}
	return FALSE;
}

/**
 * Remove an existing item for the given uri from the dock
 *
 * @param uri an URI
 * @return whether it was successfully removed
 */
gboolean
plank_dbus_items_iface_remove (PlankDBusItemsIface* self,
                               const gchar* uri,
                               GError** error)
{
	PlankDBusItemsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE (self);
	if (_iface_->remove) {
		return _iface_->remove (self, uri, error);
	}
	return FALSE;
}

/**
 * Returns the number of currently visible items on the dock
 *
 * @return the item-count
 */
gint
plank_dbus_items_iface_get_count (PlankDBusItemsIface* self,
                                  GError** error)
{
	PlankDBusItemsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE (self);
	if (_iface_->get_count) {
		return _iface_->get_count (self, error);
	}
	return -1;
}

/**
 * Returns an array of uris of the persistent applications on the dock
 *
 * @return the array of uris
 */
gchar**
plank_dbus_items_iface_get_persistent_applications (PlankDBusItemsIface* self,
                                                    gint* result_length1,
                                                    GError** error)
{
	PlankDBusItemsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE (self);
	if (_iface_->get_persistent_applications) {
		return _iface_->get_persistent_applications (self, result_length1, error);
	}
	return NULL;
}

/**
 * Returns an array of uris of the transient applications on the dock
 *
 * @return the array of uris
 */
gchar**
plank_dbus_items_iface_get_transient_applications (PlankDBusItemsIface* self,
                                                   gint* result_length1,
                                                   GError** error)
{
	PlankDBusItemsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE (self);
	if (_iface_->get_transient_applications) {
		return _iface_->get_transient_applications (self, result_length1, error);
	}
	return NULL;
}

/**
 * Gets the x,y coords with the dock's position to display a hover window for an item.
 *
 * @param uri an URI
 * @param x the resulting x position
 * @param y the resulting y position
 * @param dock_position the position of the dock
 * @return whether it was successfully retrieved
 */
gboolean
plank_dbus_items_iface_get_hover_position (PlankDBusItemsIface* self,
                                           const gchar* uri,
                                           gint* x,
                                           gint* y,
                                           GtkPositionType* dock_position,
                                           GError** error)
{
	PlankDBusItemsIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = PLANK_DBUS_ITEMS_IFACE_GET_INTERFACE (self);
	if (_iface_->get_hover_position) {
		return _iface_->get_hover_position (self, uri, x, y, dock_position, error);
	}
	return FALSE;
}

static void
plank_dbus_items_iface_default_init (PlankDBusItemsIfaceIface * iface,
                                     gpointer iface_data)
{
	/**
	 * Emmited when items are changed
	 */
	plank_dbus_items_iface_signals[PLANK_DBUS_ITEMS_IFACE_CHANGED_SIGNAL] = g_signal_new ("changed", PLANK_TYPE_DBUS_ITEMS_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

/**
 * Provide an interface to manage items of the dock
 */
static GType
plank_dbus_items_iface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDBusItemsIfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dbus_items_iface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plank_dbus_items_iface_type_id;
	plank_dbus_items_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "PlankDBusItemsIface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plank_dbus_items_iface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (plank_dbus_items_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) plank_dbus_items_iface_proxy_get_type);
	g_type_set_qdata (plank_dbus_items_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.launchpad.plank.Items");
	g_type_set_qdata (plank_dbus_items_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_plank_dbus_items_iface_dbus_interface_info));
	g_type_set_qdata (plank_dbus_items_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) plank_dbus_items_iface_register_object);
	return plank_dbus_items_iface_type_id;
}

GType
plank_dbus_items_iface_get_type (void)
{
	static volatile gsize plank_dbus_items_iface_type_id__once = 0;
	if (g_once_init_enter (&plank_dbus_items_iface_type_id__once)) {
		GType plank_dbus_items_iface_type_id;
		plank_dbus_items_iface_type_id = plank_dbus_items_iface_get_type_once ();
		g_once_init_leave (&plank_dbus_items_iface_type_id__once, plank_dbus_items_iface_type_id);
	}
	return plank_dbus_items_iface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PlankDBusItemsIfaceProxy, plank_dbus_items_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PLANK_TYPE_DBUS_ITEMS_IFACE, plank_dbus_items_iface_proxy_plank_dbus_items_iface_interface_init) )
static void
plank_dbus_items_iface_proxy_class_init (PlankDBusItemsIfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = plank_dbus_items_iface_proxy_g_signal;
}

static void
_dbus_handle_plank_dbus_items_iface_changed (PlankDBusItemsIface* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "changed");
}

static void
plank_dbus_items_iface_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
	if (strcmp (signal_name, "Changed") == 0) {
		_dbus_handle_plank_dbus_items_iface_changed ((PlankDBusItemsIface*) proxy, parameters);
	}
}

static void
plank_dbus_items_iface_proxy_init (PlankDBusItemsIfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_plank_dbus_items_iface_dbus_interface_info));
}

static gboolean
plank_dbus_items_iface_proxy_add (PlankDBusItemsIface* self,
                                  const gchar* uri,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp2_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.plank.Items", "Add");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp1_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static gboolean
plank_dbus_items_iface_proxy_remove (PlankDBusItemsIface* self,
                                     const gchar* uri,
                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result = FALSE;
	GVariant* _tmp5_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.plank.Items", "Remove");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp3_ = FALSE;
		return _tmp3_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp4_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp4_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp5_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp5_);
	g_variant_unref (_tmp5_);
	g_object_unref (_reply_message);
	return _result;
}

static gint
plank_dbus_items_iface_proxy_get_count (PlankDBusItemsIface* self,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint _result = 0;
	GVariant* _tmp8_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.plank.Items", "GetCount");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gint _tmp6_ = 0;
		return _tmp6_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gint _tmp7_ = 0;
		g_object_unref (_reply_message);
		return _tmp7_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp8_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_int32 (_tmp8_);
	g_variant_unref (_tmp8_);
	g_object_unref (_reply_message);
	return _result;
}

static gchar**
plank_dbus_items_iface_proxy_get_persistent_applications (PlankDBusItemsIface* self,
                                                          gint* result_length1,
                                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length;
	gint _tmp10__size;
	gint _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.plank.Items", "GetPersistentApplications");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp9_ = g_variant_iter_next_value (&_reply_iter);
	_tmp10_ = g_new (gchar*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; (_tmp12_ = g_variant_iter_next_value (&_tmp11_)) != NULL; _tmp10__length1++) {
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (gchar*, _tmp10_, _tmp10__size + 1);
		}
		_tmp10_[_tmp10__length++] = g_variant_dup_string (_tmp12_, NULL);
		g_variant_unref (_tmp12_);
	}
	_result_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	_result = _tmp10_;
	g_variant_unref (_tmp9_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gchar**
plank_dbus_items_iface_proxy_get_transient_applications (PlankDBusItemsIface* self,
                                                         gint* result_length1,
                                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length;
	gint _tmp14__size;
	gint _tmp14__length1;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.plank.Items", "GetTransientApplications");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp13_ = g_variant_iter_next_value (&_reply_iter);
	_tmp14_ = g_new (gchar*, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	g_variant_iter_init (&_tmp15_, _tmp13_);
	for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp14__length1++) {
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (gchar*, _tmp14_, _tmp14__size + 1);
		}
		_tmp14_[_tmp14__length++] = g_variant_dup_string (_tmp16_, NULL);
		g_variant_unref (_tmp16_);
	}
	_result_length1 = _tmp14__length1;
	_tmp14_[_tmp14__length] = NULL;
	_result = _tmp14_;
	g_variant_unref (_tmp13_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gboolean
plank_dbus_items_iface_proxy_get_hover_position (PlankDBusItemsIface* self,
                                                 const gchar* uri,
                                                 gint* x,
                                                 gint* y,
                                                 GtkPositionType* dock_position,
                                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint _vala_x = 0;
	GVariant* _tmp19_;
	gint _vala_y = 0;
	GVariant* _tmp20_;
	GtkPositionType _vala_dock_position = 0;
	GVariant* _tmp21_;
	gboolean _result = FALSE;
	GVariant* _tmp22_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "net.launchpad.plank.Items", "GetHoverPosition");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		gboolean _tmp17_ = FALSE;
		return _tmp17_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		gboolean _tmp18_ = FALSE;
		g_object_unref (_reply_message);
		return _tmp18_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp19_ = g_variant_iter_next_value (&_reply_iter);
	_vala_x = g_variant_get_int32 (_tmp19_);
	g_variant_unref (_tmp19_);
	*x = _vala_x;
	_tmp20_ = g_variant_iter_next_value (&_reply_iter);
	_vala_y = g_variant_get_int32 (_tmp20_);
	g_variant_unref (_tmp20_);
	*y = _vala_y;
	_tmp21_ = g_variant_iter_next_value (&_reply_iter);
	_vala_dock_position = g_variant_get_int32 (_tmp21_);
	g_variant_unref (_tmp21_);
	*dock_position = _vala_dock_position;
	_tmp22_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp22_);
	g_variant_unref (_tmp22_);
	g_object_unref (_reply_message);
	return _result;
}

static void
plank_dbus_items_iface_proxy_plank_dbus_items_iface_interface_init (PlankDBusItemsIfaceIface* iface)
{
	iface->add = plank_dbus_items_iface_proxy_add;
	iface->remove = plank_dbus_items_iface_proxy_remove;
	iface->get_count = plank_dbus_items_iface_proxy_get_count;
	iface->get_persistent_applications = plank_dbus_items_iface_proxy_get_persistent_applications;
	iface->get_transient_applications = plank_dbus_items_iface_proxy_get_transient_applications;
	iface->get_hover_position = plank_dbus_items_iface_proxy_get_hover_position;
}

static void
_dbus_plank_dbus_items_iface_add (PlankDBusItemsIface* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp23_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	result = plank_dbus_items_iface_add (self, uri, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (uri);
	;
}

static void
_dbus_plank_dbus_items_iface_remove (PlankDBusItemsIface* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp24_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	result = plank_dbus_items_iface_remove (self, uri, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (uri);
	;
}

static void
_dbus_plank_dbus_items_iface_get_count (PlankDBusItemsIface* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = plank_dbus_items_iface_get_count (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_plank_dbus_items_iface_get_persistent_applications (PlankDBusItemsIface* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp25_;
	GVariantBuilder _tmp26_;
	gint _tmp27_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = plank_dbus_items_iface_get_persistent_applications (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp25_ = result;
	g_variant_builder_init (&_tmp26_, G_VARIANT_TYPE ("as"));
	for (_tmp27_ = 0; _tmp27_ < result_length1; _tmp27_++) {
		g_variant_builder_add_value (&_tmp26_, g_variant_new_string (*_tmp25_));
		_tmp25_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp26_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_plank_dbus_items_iface_get_transient_applications (PlankDBusItemsIface* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp28_;
	GVariantBuilder _tmp29_;
	gint _tmp30_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = plank_dbus_items_iface_get_transient_applications (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp28_ = result;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE ("as"));
	for (_tmp30_ = 0; _tmp30_ < result_length1; _tmp30_++) {
		g_variant_builder_add_value (&_tmp29_, g_variant_new_string (*_tmp28_));
		_tmp28_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp29_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_plank_dbus_items_iface_get_hover_position (PlankDBusItemsIface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp31_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint x = 0;
	gint y = 0;
	GtkPositionType dock_position = 0;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	result = plank_dbus_items_iface_get_hover_position (self, uri, &x, &y, &dock_position, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (y));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (dock_position));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (uri);
	;
}

static void
plank_dbus_items_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Add") == 0) {
		_dbus_plank_dbus_items_iface_add (object, parameters, invocation);
	} else if (strcmp (method_name, "Remove") == 0) {
		_dbus_plank_dbus_items_iface_remove (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCount") == 0) {
		_dbus_plank_dbus_items_iface_get_count (object, parameters, invocation);
	} else if (strcmp (method_name, "GetPersistentApplications") == 0) {
		_dbus_plank_dbus_items_iface_get_persistent_applications (object, parameters, invocation);
	} else if (strcmp (method_name, "GetTransientApplications") == 0) {
		_dbus_plank_dbus_items_iface_get_transient_applications (object, parameters, invocation);
	} else if (strcmp (method_name, "GetHoverPosition") == 0) {
		_dbus_plank_dbus_items_iface_get_hover_position (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
plank_dbus_items_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
plank_dbus_items_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_plank_dbus_items_iface_changed (GObject* _sender,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "net.launchpad.plank.Items", "Changed", _arguments, NULL);
}

guint
plank_dbus_items_iface_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_plank_dbus_items_iface_dbus_interface_info), &_plank_dbus_items_iface_dbus_interface_vtable, data, _plank_dbus_items_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_plank_dbus_items_iface_changed, data);
	return result;
}

static void
_plank_dbus_items_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_plank_dbus_items_iface_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

