/* window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window.vala, do not modify */

/* window.vala
 *
 * Copyright 2023-2024 Diego Iván
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <poppler.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAPER_CLIP_TYPE_WINDOW (paper_clip_window_get_type ())
#define PAPER_CLIP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_WINDOW, PaperClipWindow))
#define PAPER_CLIP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_WINDOW, PaperClipWindowClass))
#define PAPER_CLIP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_WINDOW))
#define PAPER_CLIP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_WINDOW))
#define PAPER_CLIP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_WINDOW, PaperClipWindowClass))

typedef struct _PaperClipWindow PaperClipWindow;
typedef struct _PaperClipWindowClass PaperClipWindowClass;
typedef struct _PaperClipWindowPrivate PaperClipWindowPrivate;

#define PAPER_CLIP_TYPE_DOCUMENT_VIEW (paper_clip_document_view_get_type ())
#define PAPER_CLIP_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_DOCUMENT_VIEW, PaperClipDocumentView))
#define PAPER_CLIP_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_DOCUMENT_VIEW, PaperClipDocumentViewClass))
#define PAPER_CLIP_IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_DOCUMENT_VIEW))
#define PAPER_CLIP_IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_DOCUMENT_VIEW))
#define PAPER_CLIP_DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_DOCUMENT_VIEW, PaperClipDocumentViewClass))

typedef struct _PaperClipDocumentView PaperClipDocumentView;
typedef struct _PaperClipDocumentViewClass PaperClipDocumentViewClass;

#define PAPER_CLIP_TYPE_DROP_OVERLAY (paper_clip_drop_overlay_get_type ())
#define PAPER_CLIP_DROP_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_DROP_OVERLAY, PaperClipDropOverlay))
#define PAPER_CLIP_DROP_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_DROP_OVERLAY, PaperClipDropOverlayClass))
#define PAPER_CLIP_IS_DROP_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_DROP_OVERLAY))
#define PAPER_CLIP_IS_DROP_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_DROP_OVERLAY))
#define PAPER_CLIP_DROP_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_DROP_OVERLAY, PaperClipDropOverlayClass))

typedef struct _PaperClipDropOverlay PaperClipDropOverlay;
typedef struct _PaperClipDropOverlayClass PaperClipDropOverlayClass;
typedef enum  {
	PAPER_CLIP_WINDOW_STATE_NONE,
	PAPER_CLIP_WINDOW_STATE_OPENING_FILE,
	PAPER_CLIP_WINDOW_STATE_CLOSING,
	PAPER_CLIP_WINDOW_STATE_OPENING_DROPPED
} PaperClipWindowState;

#define PAPER_CLIP_TYPE_WINDOW_STATE (paper_clip_window_state_get_type ())

#define PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER (paper_clip_services_document_manager_get_type ())
#define PAPER_CLIP_SERVICES_DOCUMENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER, PaperClipServicesDocumentManager))
#define PAPER_CLIP_SERVICES_DOCUMENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER, PaperClipServicesDocumentManagerClass))
#define PAPER_CLIP_SERVICES_IS_DOCUMENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER))
#define PAPER_CLIP_SERVICES_IS_DOCUMENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER))
#define PAPER_CLIP_SERVICES_DOCUMENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER, PaperClipServicesDocumentManagerClass))

typedef struct _PaperClipServicesDocumentManager PaperClipServicesDocumentManager;
typedef struct _PaperClipServicesDocumentManagerClass PaperClipServicesDocumentManagerClass;
enum  {
	PAPER_CLIP_WINDOW_0_PROPERTY,
	PAPER_CLIP_WINDOW_STATE_PROPERTY,
	PAPER_CLIP_WINDOW_DOCUMENT_MANAGER_PROPERTY,
	PAPER_CLIP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* paper_clip_window_properties[PAPER_CLIP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PaperClipWindowOpenDroppedFileData PaperClipWindowOpenDroppedFileData;
typedef struct _PaperClipWindowLoadDroppedFileData PaperClipWindowLoadDroppedFileData;
typedef struct _PaperClipWindowOpenFileData PaperClipWindowOpenFileData;

#define PAPER_CLIP_TYPE_DOCUMENT (paper_clip_document_get_type ())
#define PAPER_CLIP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocument))
#define PAPER_CLIP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocumentClass))
#define PAPER_CLIP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_DOCUMENT))
#define PAPER_CLIP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_DOCUMENT))
#define PAPER_CLIP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocumentClass))

typedef struct _PaperClipDocument PaperClipDocument;
typedef struct _PaperClipDocumentClass PaperClipDocumentClass;
typedef struct _PaperClipWindowLoadDocumentToViewData PaperClipWindowLoadDocumentToViewData;

#define PAPER_CLIP_TYPE_PASSWORD_DIALOG (paper_clip_password_dialog_get_type ())
#define PAPER_CLIP_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_PASSWORD_DIALOG, PaperClipPasswordDialog))
#define PAPER_CLIP_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_PASSWORD_DIALOG, PaperClipPasswordDialogClass))
#define PAPER_CLIP_IS_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_PASSWORD_DIALOG))
#define PAPER_CLIP_IS_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_PASSWORD_DIALOG))
#define PAPER_CLIP_PASSWORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_PASSWORD_DIALOG, PaperClipPasswordDialogClass))

typedef struct _PaperClipPasswordDialog PaperClipPasswordDialog;
typedef struct _PaperClipPasswordDialogClass PaperClipPasswordDialogClass;
typedef struct _PaperClipWindowCreateDocumentData PaperClipWindowCreateDocumentData;
typedef struct _PaperClipWindowSaveFileData PaperClipWindowSaveFileData;
typedef struct _PaperClipWindowSaveFileAsData PaperClipWindowSaveFileAsData;
typedef struct _PaperClipWindowQuitAndSaveData PaperClipWindowQuitAndSaveData;

#define PAPER_CLIP_TYPE_SAVE_CHANGES_DIALOG (paper_clip_save_changes_dialog_get_type ())
#define PAPER_CLIP_SAVE_CHANGES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_SAVE_CHANGES_DIALOG, PaperClipSaveChangesDialog))
#define PAPER_CLIP_SAVE_CHANGES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_SAVE_CHANGES_DIALOG, PaperClipSaveChangesDialogClass))
#define PAPER_CLIP_IS_SAVE_CHANGES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_SAVE_CHANGES_DIALOG))
#define PAPER_CLIP_IS_SAVE_CHANGES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_SAVE_CHANGES_DIALOG))
#define PAPER_CLIP_SAVE_CHANGES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_SAVE_CHANGES_DIALOG, PaperClipSaveChangesDialogClass))

typedef struct _PaperClipSaveChangesDialog PaperClipSaveChangesDialog;
typedef struct _PaperClipSaveChangesDialogClass PaperClipSaveChangesDialogClass;
typedef enum  {
	PAPER_CLIP_SAVE_CHANGES_RESPONSE_CANCEL,
	PAPER_CLIP_SAVE_CHANGES_RESPONSE_DISCARD,
	PAPER_CLIP_SAVE_CHANGES_RESPONSE_SAVE
} PaperClipSaveChangesResponse;

#define PAPER_CLIP_TYPE_SAVE_CHANGES_RESPONSE (paper_clip_save_changes_response_get_type ())
typedef struct _PaperClipWindowShowUnsavedWarningData PaperClipWindowShowUnsavedWarningData;
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PaperClipWindow {
	AdwApplicationWindow parent_instance;
	PaperClipWindowPrivate * priv;
};

struct _PaperClipWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _PaperClipWindowPrivate {
	PaperClipDocumentView* doc_view;
	GtkStack* view_stack;
	GtkMenuButton* menu_button;
	AdwToastOverlay* toast_overlay;
	PaperClipDropOverlay* drop_overlay;
	GtkProgressBar* progress_bar;
	PaperClipWindowState _state;
	PaperClipServicesDocumentManager* _document_manager;
	GFile* _dropped_file;
};

struct _PaperClipWindowOpenDroppedFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	PaperClipServicesDocumentManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
};

struct _PaperClipWindowLoadDroppedFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	GFile* _tmp0_;
};

struct _PaperClipWindowOpenFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	GtkFileDialog* file_dialog;
	GtkFileDialog* _tmp0_;
	GtkFileFilter* pdf_filter;
	gchar* _tmp1_;
	GtkFileFilter* _tmp2_;
	GListStore* filters;
	GListStore* _tmp3_;
	GFile* opened_file;
	GFile* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _PaperClipWindowLoadDocumentToViewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	GFile* file;
	PaperClipDocument* doc;
	PaperClipDocument* _tmp0_;
	PaperClipServicesDocumentManager* _tmp1_;
	PaperClipDocumentView* _tmp2_;
	GtkStack* _tmp3_;
	GError* e;
	GError* _tmp4_;
	AdwToast* toast;
	AdwToast* _tmp5_;
	AdwToastOverlay* _tmp6_;
	AdwToast* _tmp7_;
	AdwToast* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _PaperClipWindowCreateDocumentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	GFile* file;
	PaperClipDocument* result;
	PaperClipDocument* doc;
	PaperClipDocument* _tmp0_;
	PaperClipDocument* _tmp1_;
	PaperClipDocument* _tmp2_;
	GError* e;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	PaperClipDocument* _tmp6_;
	PaperClipPasswordDialog* dialog;
	PaperClipPasswordDialog* _tmp7_;
	PaperClipDocument* _tmp8_;
	PaperClipPasswordDialog* _tmp9_;
	PaperClipDocument* _tmp10_;
	PaperClipDocument* _tmp11_;
	GError* _inner_error0_;
};

struct _PaperClipWindowSaveFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	gboolean _tmp0_;
	PaperClipServicesDocumentManager* _tmp1_;
	PaperClipDocument* _tmp2_;
	PaperClipDocument* _tmp3_;
	PaperClipServicesDocumentManager* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	PaperClipServicesDocumentManager* _tmp7_;
	PaperClipServicesDocumentManager* _tmp8_;
	PaperClipDocument* _tmp9_;
	PaperClipDocument* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _PaperClipWindowSaveFileAsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	PaperClipServicesDocumentManager* _tmp0_;
	PaperClipDocument* _tmp1_;
	PaperClipDocument* _tmp2_;
	GtkFileDialog* file_dialog;
	PaperClipServicesDocumentManager* _tmp3_;
	PaperClipDocument* _tmp4_;
	PaperClipDocument* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	GtkFileDialog* _tmp9_;
	GtkFileFilter* pdf_filter;
	gchar* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileFilter* _tmp12_;
	GListStore* filters;
	GListStore* _tmp13_;
	GListStore* _tmp14_;
	GtkFileFilter* _tmp15_;
	GtkFileDialog* _tmp16_;
	GListStore* _tmp17_;
	GFile* file;
	GtkFileDialog* _tmp18_;
	GFile* _tmp19_;
	PaperClipServicesDocumentManager* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GError* _inner_error0_;
};

struct _PaperClipWindowQuitAndSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
};

struct _PaperClipWindowShowUnsavedWarningData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipWindow* self;
	PaperClipSaveChangesDialog* save_changes_dialog;
	GtkWindow* _tmp0_;
	PaperClipSaveChangesDialog* _tmp1_;
	PaperClipSaveChangesResponse response;
	PaperClipSaveChangesDialog* _tmp2_;
	PaperClipServicesDocumentManager* _tmp3_;
	PaperClipServicesDocumentManager* _tmp4_;
	PaperClipServicesDocumentManager** _tmp5_;
	PaperClipServicesDocumentManager** _tmp6_;
	gint _tmp6__length1;
	PaperClipSaveChangesResponse _tmp7_;
};

static gint PaperClipWindow_private_offset;
static gpointer paper_clip_window_parent_class = NULL;

VALA_EXTERN GType paper_clip_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipWindow, g_object_unref)
VALA_EXTERN GType paper_clip_document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipDocumentView, g_object_unref)
VALA_EXTERN GType paper_clip_drop_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipDropOverlay, g_object_unref)
VALA_EXTERN GType paper_clip_window_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType paper_clip_services_document_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipServicesDocumentManager, g_object_unref)
VALA_EXTERN PaperClipServicesDocumentManager* paper_clip_services_document_manager_new (void);
VALA_EXTERN PaperClipServicesDocumentManager* paper_clip_services_document_manager_construct (GType object_type);
VALA_EXTERN PaperClipWindow* paper_clip_window_new (GtkApplication* app);
VALA_EXTERN PaperClipWindow* paper_clip_window_construct (GType object_type,
                                              GtkApplication* app);
static gboolean paper_clip_window_on_file_dropped (PaperClipWindow* self,
                                            GValue* value);
static void paper_clip_window_set_dropped_file (PaperClipWindow* self,
                                         GFile* value);
VALA_EXTERN void paper_clip_window_set_state (PaperClipWindow* self,
                                  PaperClipWindowState value);
static void paper_clip_window_open_dropped_file (PaperClipWindow* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void paper_clip_window_open_dropped_file_finish (PaperClipWindow* self,
                                                 GAsyncResult* _res_);
static void paper_clip_window_open_dropped_file_data_free (gpointer _data);
static gboolean paper_clip_window_open_dropped_file_co (PaperClipWindowOpenDroppedFileData* _data_);
VALA_EXTERN PaperClipServicesDocumentManager* paper_clip_window_get_document_manager (PaperClipWindow* self);
VALA_EXTERN gboolean paper_clip_services_document_manager_get_changed (PaperClipServicesDocumentManager* self);
static void paper_clip_window_show_unsaved_warning (PaperClipWindow* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void paper_clip_window_show_unsaved_warning_finish (PaperClipWindow* self,
                                                    GAsyncResult* _res_);
static void paper_clip_window_load_dropped_file (PaperClipWindow* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void paper_clip_window_load_dropped_file_finish (PaperClipWindow* self,
                                                 GAsyncResult* _res_);
static void paper_clip_window_load_dropped_file_data_free (gpointer _data);
static gboolean paper_clip_window_load_dropped_file_co (PaperClipWindowLoadDroppedFileData* _data_);
static void paper_clip_window_pulse_progress_bar (PaperClipWindow* self);
static void paper_clip_window_load_document_to_view (PaperClipWindow* self,
                                              GFile* file,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void paper_clip_window_load_document_to_view_finish (PaperClipWindow* self,
                                                     GAsyncResult* _res_);
static GFile* paper_clip_window_get_dropped_file (PaperClipWindow* self);
static void paper_clip_window_load_dropped_file_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void paper_clip_window_hide_progress_bar_animation (PaperClipWindow* self);
VALA_EXTERN void paper_clip_window_open_command_line_file (PaperClipWindow* self,
                                               GFile* file);
static void paper_clip_window_on_open_action (PaperClipWindow* self);
static void paper_clip_window_open_file (PaperClipWindow* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void paper_clip_window_open_file_finish (PaperClipWindow* self,
                                         GAsyncResult* _res_);
static void paper_clip_window_open_file_data_free (gpointer _data);
static gboolean paper_clip_window_open_file_co (PaperClipWindowOpenFileData* _data_);
static void paper_clip_window_open_file_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void paper_clip_window_on_open_with_action (PaperClipWindow* self);
VALA_EXTERN void paper_clip_document_view_open_on_app (PaperClipDocumentView* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void paper_clip_document_view_open_on_app_finish (PaperClipDocumentView* self,
                                                  GAsyncResult* _res_);
static void paper_clip_window_load_document_to_view_data_free (gpointer _data);
static gboolean paper_clip_window_load_document_to_view_co (PaperClipWindowLoadDocumentToViewData* _data_);
VALA_EXTERN GType paper_clip_document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipDocument, g_object_unref)
static void paper_clip_window_create_document (PaperClipWindow* self,
                                        GFile* file,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static PaperClipDocument* paper_clip_window_create_document_finish (PaperClipWindow* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void paper_clip_window_load_document_to_view_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
VALA_EXTERN void paper_clip_document_view_set_document (PaperClipDocumentView* self,
                                            PaperClipDocument* value);
VALA_EXTERN void paper_clip_services_document_manager_set_document (PaperClipServicesDocumentManager* self,
                                                        PaperClipDocument* value);
static void paper_clip_window_create_document_data_free (gpointer _data);
static gboolean paper_clip_window_create_document_co (PaperClipWindowCreateDocumentData* _data_);
VALA_EXTERN void paper_clip_document_new (GFile* original_file,
                              const gchar* password,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN PaperClipDocument* paper_clip_document_new_finish (GAsyncResult* _res_,
                                                   GError** error);
VALA_EXTERN void paper_clip_document_construct (GType object_type,
                                    GFile* original_file,
                                    const gchar* password,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN PaperClipDocument* paper_clip_document_construct_finish (GAsyncResult* _res_,
                                                         GError** error);
static void paper_clip_window_create_document_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN GType paper_clip_password_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipPasswordDialog, g_object_unref)
VALA_EXTERN PaperClipPasswordDialog* paper_clip_password_dialog_new (void);
VALA_EXTERN PaperClipPasswordDialog* paper_clip_password_dialog_construct (GType object_type);
VALA_EXTERN void paper_clip_password_dialog_decrypt (PaperClipPasswordDialog* self,
                                         GFile* file,
                                         GtkWindow* parent,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN PaperClipDocument* paper_clip_password_dialog_decrypt_finish (PaperClipPasswordDialog* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static void paper_clip_window_save_file_action (PaperClipWindow* self);
static void paper_clip_window_save_file (PaperClipWindow* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void paper_clip_window_save_file_finish (PaperClipWindow* self,
                                         GAsyncResult* _res_);
static void paper_clip_window_save_file_data_free (gpointer _data);
static gboolean paper_clip_window_save_file_co (PaperClipWindowSaveFileData* _data_);
VALA_EXTERN PaperClipDocument* paper_clip_services_document_manager_get_document (PaperClipServicesDocumentManager* self);
static void paper_clip_window_file_save_animation (PaperClipWindow* self);
VALA_EXTERN void paper_clip_services_document_manager_save (PaperClipServicesDocumentManager* self,
                                                const gchar* uri,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void paper_clip_services_document_manager_save_finish (PaperClipServicesDocumentManager* self,
                                                       GAsyncResult* _res_);
VALA_EXTERN GFile* paper_clip_document_get_original_file (PaperClipDocument* self);
static void paper_clip_window_save_file_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void paper_clip_window_proceed_with_state (PaperClipWindow* self);
static void paper_clip_window_save_file_as_action (PaperClipWindow* self);
static void paper_clip_window_save_file_as (PaperClipWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void paper_clip_window_save_file_as_finish (PaperClipWindow* self,
                                            GAsyncResult* _res_);
static void paper_clip_window_save_file_as_data_free (gpointer _data);
static gboolean paper_clip_window_save_file_as_co (PaperClipWindowSaveFileAsData* _data_);
static void paper_clip_window_save_file_as_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void _paper_clip_window_hide_progress_bar_animation_adw_animation_done (AdwAnimation* _sender,
                                                                        gpointer self);
VALA_EXTERN void paper_clip_window_shortcuts (PaperClipWindow* self);
static void paper_clip_window_on_main_menu_action (PaperClipWindow* self);
static gboolean paper_clip_window_on_close_request (PaperClipWindow* self);
VALA_EXTERN PaperClipWindowState paper_clip_window_get_state (PaperClipWindow* self);
static void paper_clip_window_quit_and_save (PaperClipWindow* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void paper_clip_window_quit_and_save_finish (PaperClipWindow* self,
                                             GAsyncResult* _res_);
static gboolean _paper_clip_window_on_close_request_gtk_window_close_request (GtkWindow* _sender,
                                                                       gpointer self);
static void paper_clip_window_quit_and_save_data_free (gpointer _data);
static gboolean paper_clip_window_quit_and_save_co (PaperClipWindowQuitAndSaveData* _data_);
static void paper_clip_window_quit_and_save_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void paper_clip_window_show_unsaved_warning_data_free (gpointer _data);
static gboolean paper_clip_window_show_unsaved_warning_co (PaperClipWindowShowUnsavedWarningData* _data_);
VALA_EXTERN GType paper_clip_save_changes_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipSaveChangesDialog, g_object_unref)
VALA_EXTERN PaperClipSaveChangesDialog* paper_clip_save_changes_dialog_new (void);
VALA_EXTERN PaperClipSaveChangesDialog* paper_clip_save_changes_dialog_construct (GType object_type);
VALA_EXTERN GType paper_clip_save_changes_response_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void paper_clip_save_changes_dialog_ask (PaperClipSaveChangesDialog* self,
                                         PaperClipServicesDocumentManager** document_managers,
                                         gint document_managers_length1,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN PaperClipSaveChangesResponse paper_clip_save_changes_dialog_ask_finish (PaperClipSaveChangesDialog* self,
                                                                        GAsyncResult* _res_);
static void paper_clip_window_show_unsaved_warning_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static GObject * paper_clip_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _paper_clip_window_on_open_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void _paper_clip_window_on_open_with_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void _paper_clip_window_save_file_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void _paper_clip_window_save_file_as_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void _paper_clip_window_on_main_menu_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static gboolean _paper_clip_window_on_file_dropped_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                  GValue* value,
                                                                  gdouble x,
                                                                  gdouble y,
                                                                  gpointer self);
VALA_EXTERN void paper_clip_drop_overlay_set_drop_target (PaperClipDropOverlay* self,
                                              GtkDropTarget* value);
static void paper_clip_window_finalize (GObject * obj);
static GType paper_clip_window_get_type_once (void);
static void _vala_paper_clip_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_paper_clip_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
paper_clip_window_get_instance_private (PaperClipWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PaperClipWindow_private_offset);
}

PaperClipWindow*
paper_clip_window_construct (GType object_type,
                             GtkApplication* app)
{
	PaperClipWindow * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	self = (PaperClipWindow*) g_object_new (object_type, "application", app, NULL);
	gtk_widget_action_set_enabled ((GtkWidget*) self, "win.save", FALSE);
	gtk_widget_action_set_enabled ((GtkWidget*) self, "win.save-as", FALSE);
	gtk_widget_action_set_enabled ((GtkWidget*) self, "win.open-with", FALSE);
	return self;
}

PaperClipWindow*
paper_clip_window_new (GtkApplication* app)
{
	return paper_clip_window_construct (PAPER_CLIP_TYPE_WINDOW, app);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
paper_clip_window_on_file_dropped (PaperClipWindow* self,
                                   GValue* value)
{
	GFile* file = NULL;
	GValue _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = *value;
	_tmp1_ = _g_object_ref0 (g_value_get_object (&_tmp0_));
	file = _tmp1_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp2_;
		gchar* content_type = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = g_file_query_info (file, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_file_info_get_content_type (info);
		_tmp4_ = g_strdup (_tmp3_);
		content_type = _tmp4_;
		_tmp5_ = content_type;
		if (g_strcmp0 (_tmp5_, "application/pdf") != 0) {
			g_critical ("window.vala:86: File is not a PDF");
			result = FALSE;
			_g_free0 (content_type);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		paper_clip_window_set_dropped_file (self, file);
		paper_clip_window_set_state (self, PAPER_CLIP_WINDOW_STATE_OPENING_DROPPED);
		paper_clip_window_open_dropped_file (self, NULL, NULL);
		_g_free0 (content_type);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("window.vala:95: %s", _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	result = TRUE;
	_g_object_unref0 (file);
	return result;
}

static void
paper_clip_window_open_dropped_file_data_free (gpointer _data)
{
	PaperClipWindowOpenDroppedFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowOpenDroppedFileData, _data_);
}

static void
paper_clip_window_open_dropped_file (PaperClipWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	PaperClipWindowOpenDroppedFileData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowOpenDroppedFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_open_dropped_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_open_dropped_file_co (_data_);
}

static void
paper_clip_window_open_dropped_file_finish (PaperClipWindow* self,
                                            GAsyncResult* _res_)
{
	PaperClipWindowOpenDroppedFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
paper_clip_window_open_dropped_file_co (PaperClipWindowOpenDroppedFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_document_manager;
	_data_->_tmp1_ = paper_clip_services_document_manager_get_changed (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_) {
		paper_clip_window_show_unsaved_warning (_data_->self, NULL, NULL);
	} else {
		paper_clip_window_load_dropped_file (_data_->self, NULL, NULL);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_load_dropped_file_data_free (gpointer _data)
{
	PaperClipWindowLoadDroppedFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowLoadDroppedFileData, _data_);
}

static void
paper_clip_window_load_dropped_file (PaperClipWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	PaperClipWindowLoadDroppedFileData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowLoadDroppedFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_load_dropped_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_load_dropped_file_co (_data_);
}

static void
paper_clip_window_load_dropped_file_finish (PaperClipWindow* self,
                                            GAsyncResult* _res_)
{
	PaperClipWindowLoadDroppedFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_load_dropped_file_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	PaperClipWindowLoadDroppedFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_load_dropped_file_co (_data_);
}

static gboolean
paper_clip_window_load_dropped_file_co (PaperClipWindowLoadDroppedFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	paper_clip_window_pulse_progress_bar (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->_dropped_file;
	_data_->_state_ = 1;
	paper_clip_window_load_document_to_view (_data_->self, _data_->_tmp0_, paper_clip_window_load_dropped_file_ready, _data_);
	return FALSE;
	_state_1:
	paper_clip_window_load_document_to_view_finish (_data_->self, _data_->_res_);
	paper_clip_window_hide_progress_bar_animation (_data_->self);
	paper_clip_window_set_dropped_file (_data_->self, NULL);
	paper_clip_window_set_state (_data_->self, PAPER_CLIP_WINDOW_STATE_NONE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
paper_clip_window_open_command_line_file (PaperClipWindow* self,
                                          GFile* file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_vala_return_if_fail (g_file_query_exists (file, NULL), "file.query_exists ()");
	paper_clip_window_set_state (self, PAPER_CLIP_WINDOW_STATE_OPENING_FILE);
	paper_clip_window_set_dropped_file (self, file);
	paper_clip_window_open_dropped_file (self, NULL, NULL);
}

static void
paper_clip_window_on_open_action (PaperClipWindow* self)
{
	PaperClipServicesDocumentManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	paper_clip_window_set_state (self, PAPER_CLIP_WINDOW_STATE_OPENING_FILE);
	_tmp0_ = self->priv->_document_manager;
	_tmp1_ = paper_clip_services_document_manager_get_changed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		paper_clip_window_show_unsaved_warning (self, NULL, NULL);
	} else {
		paper_clip_window_open_file (self, NULL, NULL);
	}
}

static void
paper_clip_window_open_file_data_free (gpointer _data)
{
	PaperClipWindowOpenFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowOpenFileData, _data_);
}

static void
paper_clip_window_open_file (PaperClipWindow* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	PaperClipWindowOpenFileData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowOpenFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_open_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_open_file_co (_data_);
}

static void
paper_clip_window_open_file_finish (PaperClipWindow* self,
                                    GAsyncResult* _res_)
{
	PaperClipWindowOpenFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_open_file_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	PaperClipWindowOpenFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_open_file_co (_data_);
}

static gboolean
paper_clip_window_open_file_co (PaperClipWindowOpenFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_file_dialog_new ();
	_data_->file_dialog = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("PDF");
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = gtk_file_filter_new ();
	g_object_set (_data_->_tmp2_, "name", _data_->_tmp1_, NULL);
	_g_free0 (_data_->_tmp1_);
	_data_->pdf_filter = _data_->_tmp2_;
	gtk_file_filter_add_mime_type (_data_->pdf_filter, "application/pdf");
	_data_->_tmp3_ = g_list_store_new (gtk_file_filter_get_type ());
	_data_->filters = _data_->_tmp3_;
	g_list_store_append (_data_->filters, (GObject*) _data_->pdf_filter);
	gtk_file_dialog_set_filters (_data_->file_dialog, (GListModel*) _data_->filters);
	{
		_data_->_state_ = 1;
		gtk_file_dialog_open (_data_->file_dialog, (GtkWindow*) _data_->self, NULL, paper_clip_window_open_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = gtk_file_dialog_open_finish (_data_->file_dialog, _data_->_res_, &_data_->_inner_error0_);
		_data_->opened_file = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		paper_clip_window_pulse_progress_bar (_data_->self);
		_data_->_state_ = 2;
		paper_clip_window_load_document_to_view (_data_->self, _data_->opened_file, paper_clip_window_open_file_ready, _data_);
		return FALSE;
		_state_2:
		paper_clip_window_load_document_to_view_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->opened_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_critical ("window.vala:155: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->filters);
		_g_object_unref0 (_data_->pdf_filter);
		_g_object_unref0 (_data_->file_dialog);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_window_set_state (_data_->self, PAPER_CLIP_WINDOW_STATE_NONE);
	_g_object_unref0 (_data_->filters);
	_g_object_unref0 (_data_->pdf_filter);
	_g_object_unref0 (_data_->file_dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_on_open_with_action (PaperClipWindow* self)
{
	PaperClipDocumentView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->doc_view;
	paper_clip_document_view_open_on_app (_tmp0_, NULL, NULL);
}

static void
paper_clip_window_load_document_to_view_data_free (gpointer _data)
{
	PaperClipWindowLoadDocumentToViewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowLoadDocumentToViewData, _data_);
}

static void
paper_clip_window_load_document_to_view (PaperClipWindow* self,
                                         GFile* file,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	PaperClipWindowLoadDocumentToViewData* _data_;
	PaperClipWindow* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (PaperClipWindowLoadDocumentToViewData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_load_document_to_view_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	paper_clip_window_load_document_to_view_co (_data_);
}

static void
paper_clip_window_load_document_to_view_finish (PaperClipWindow* self,
                                                GAsyncResult* _res_)
{
	PaperClipWindowLoadDocumentToViewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_load_document_to_view_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	PaperClipWindowLoadDocumentToViewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_load_document_to_view_co (_data_);
}

static gboolean
paper_clip_window_load_document_to_view_co (PaperClipWindowLoadDocumentToViewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		paper_clip_window_create_document (_data_->self, _data_->file, paper_clip_window_load_document_to_view_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = paper_clip_window_create_document_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->doc = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->self->priv->_document_manager;
		_data_->_tmp2_ = _data_->self->priv->doc_view;
		paper_clip_document_view_set_document (_data_->_tmp2_, _data_->doc);
		paper_clip_services_document_manager_set_document (_data_->_tmp1_, _data_->doc);
		gtk_widget_action_set_enabled ((GtkWidget*) _data_->self, "win.save", TRUE);
		gtk_widget_action_set_enabled ((GtkWidget*) _data_->self, "win.save-as", TRUE);
		gtk_widget_action_set_enabled ((GtkWidget*) _data_->self, "win.open-with", TRUE);
		_data_->_tmp3_ = _data_->self->priv->view_stack;
		gtk_stack_set_visible_child_name (_data_->_tmp3_, "editor");
		_g_object_unref0 (_data_->doc);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		if (g_error_matches (_data_->_tmp4_, POPPLER_ERROR, POPPLER_ERROR_ENCRYPTED)) {
			_data_->_tmp5_ = adw_toast_new (_ ("Failed to open the document. The provided password is incorrect."));
			_data_->toast = _data_->_tmp5_;
			_data_->_tmp6_ = _data_->self->priv->toast_overlay;
			_data_->_tmp7_ = _data_->toast;
			_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
			adw_toast_overlay_add_toast (_data_->_tmp6_, _data_->_tmp8_);
			_g_object_unref0 (_data_->toast);
		}
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_critical ("window.vala:178: %s", _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_window_hide_progress_bar_animation (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_create_document_data_free (gpointer _data)
{
	PaperClipWindowCreateDocumentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowCreateDocumentData, _data_);
}

static void
paper_clip_window_create_document (PaperClipWindow* self,
                                   GFile* file,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PaperClipWindowCreateDocumentData* _data_;
	PaperClipWindow* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (PaperClipWindowCreateDocumentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_create_document_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	paper_clip_window_create_document_co (_data_);
}

static PaperClipDocument*
paper_clip_window_create_document_finish (PaperClipWindow* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	PaperClipDocument* result;
	PaperClipWindowCreateDocumentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
paper_clip_window_create_document_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	PaperClipWindowCreateDocumentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_create_document_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
paper_clip_window_create_document_co (PaperClipWindowCreateDocumentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->doc = NULL;
	{
		_data_->_state_ = 1;
		paper_clip_document_new (_data_->file, NULL, paper_clip_window_create_document_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = paper_clip_document_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->doc);
		_data_->doc = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		if (!g_error_matches (_data_->_tmp3_, POPPLER_ERROR, POPPLER_ERROR_ENCRYPTED)) {
			_data_->_tmp4_ = _data_->e;
			_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
			_data_->_inner_error0_ = _data_->_tmp5_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->doc);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->doc;
	if (_data_->_tmp6_ != NULL) {
		_data_->result = _data_->doc;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = paper_clip_password_dialog_new ();
	g_object_ref_sink (_data_->_tmp7_);
	_data_->dialog = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->dialog;
	_data_->_state_ = 2;
	paper_clip_password_dialog_decrypt (_data_->_tmp9_, _data_->file, (GtkWindow*) _data_->self, NULL, paper_clip_window_create_document_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp10_ = paper_clip_password_dialog_decrypt_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp8_ = _data_->_tmp10_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->dialog);
		_g_object_unref0 (_data_->doc);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->_tmp8_;
	_data_->_tmp8_ = NULL;
	_data_->result = _data_->_tmp11_;
	_g_object_unref0 (_data_->_tmp8_);
	_g_object_unref0 (_data_->dialog);
	_g_object_unref0 (_data_->doc);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_save_file_action (PaperClipWindow* self)
{
	g_return_if_fail (self != NULL);
	paper_clip_window_save_file (self, NULL, NULL);
}

static void
paper_clip_window_save_file_data_free (gpointer _data)
{
	PaperClipWindowSaveFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowSaveFileData, _data_);
}

static void
paper_clip_window_save_file (PaperClipWindow* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	PaperClipWindowSaveFileData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowSaveFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_save_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_save_file_co (_data_);
}

static void
paper_clip_window_save_file_finish (PaperClipWindow* self,
                                    GAsyncResult* _res_)
{
	PaperClipWindowSaveFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_save_file_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	PaperClipWindowSaveFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_save_file_co (_data_);
}

static gboolean
paper_clip_window_save_file_co (PaperClipWindowSaveFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_document_manager;
	_data_->_tmp2_ = paper_clip_services_document_manager_get_document (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->_document_manager;
		_data_->_tmp5_ = paper_clip_services_document_manager_get_changed (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp0_ = !_data_->_tmp6_;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_window_file_save_animation (_data_->self);
	_data_->_tmp7_ = _data_->self->priv->_document_manager;
	_data_->_tmp8_ = _data_->self->priv->_document_manager;
	_data_->_tmp9_ = paper_clip_services_document_manager_get_document (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = paper_clip_document_get_original_file (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_file_get_uri (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_state_ = 1;
	paper_clip_services_document_manager_save (_data_->_tmp7_, _data_->_tmp14_, paper_clip_window_save_file_ready, _data_);
	return FALSE;
	_state_1:
	paper_clip_services_document_manager_save_finish (_data_->_tmp7_, _data_->_res_);
	_g_free0 (_data_->_tmp14_);
	paper_clip_window_proceed_with_state (_data_->self);
	paper_clip_window_set_state (_data_->self, PAPER_CLIP_WINDOW_STATE_NONE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_save_file_as_action (PaperClipWindow* self)
{
	g_return_if_fail (self != NULL);
	paper_clip_window_save_file_as (self, NULL, NULL);
}

static void
paper_clip_window_save_file_as_data_free (gpointer _data)
{
	PaperClipWindowSaveFileAsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowSaveFileAsData, _data_);
}

static void
paper_clip_window_save_file_as (PaperClipWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	PaperClipWindowSaveFileAsData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowSaveFileAsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_save_file_as_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_save_file_as_co (_data_);
}

static void
paper_clip_window_save_file_as_finish (PaperClipWindow* self,
                                       GAsyncResult* _res_)
{
	PaperClipWindowSaveFileAsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_save_file_as_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	PaperClipWindowSaveFileAsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_save_file_as_co (_data_);
}

static gboolean
paper_clip_window_save_file_as_co (PaperClipWindowSaveFileAsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_document_manager;
	_data_->_tmp1_ = paper_clip_services_document_manager_get_document (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->_document_manager;
	_data_->_tmp4_ = paper_clip_services_document_manager_get_document (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = paper_clip_document_get_original_file (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = g_file_get_basename (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_initial_name (_data_->_tmp9_, _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	_data_->file_dialog = _data_->_tmp9_;
	_data_->_tmp10_ = g_strdup ("PDF");
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = gtk_file_filter_new ();
	g_object_set (_data_->_tmp11_, "name", _data_->_tmp10_, NULL);
	_g_free0 (_data_->_tmp10_);
	_data_->pdf_filter = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->pdf_filter;
	gtk_file_filter_add_mime_type (_data_->_tmp12_, "application/pdf");
	_data_->_tmp13_ = g_list_store_new (gtk_file_filter_get_type ());
	_data_->filters = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->filters;
	_data_->_tmp15_ = _data_->pdf_filter;
	g_list_store_append (_data_->_tmp14_, (GObject*) _data_->_tmp15_);
	_data_->_tmp16_ = _data_->file_dialog;
	_data_->_tmp17_ = _data_->filters;
	gtk_file_dialog_set_filters (_data_->_tmp16_, (GListModel*) _data_->_tmp17_);
	{
		_data_->_tmp18_ = _data_->file_dialog;
		_data_->_state_ = 1;
		gtk_file_dialog_save (_data_->_tmp18_, (GtkWindow*) _data_->self, NULL, paper_clip_window_save_file_as_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp19_ = gtk_file_dialog_save_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
		_data_->file = _data_->_tmp19_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		paper_clip_window_file_save_animation (_data_->self);
		_data_->_tmp20_ = _data_->self->priv->_document_manager;
		_data_->_tmp21_ = _data_->file;
		_data_->_tmp22_ = g_file_get_uri (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_state_ = 2;
		paper_clip_services_document_manager_save (_data_->_tmp20_, _data_->_tmp23_, paper_clip_window_save_file_as_ready, _data_);
		return FALSE;
		_state_2:
		paper_clip_services_document_manager_save_finish (_data_->_tmp20_, _data_->_res_);
		_g_free0 (_data_->_tmp23_);
		paper_clip_window_proceed_with_state (_data_->self);
		_g_object_unref0 (_data_->file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp24_ = _data_->e;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_critical ("window.vala:246: %s", _data_->_tmp25_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->filters);
		_g_object_unref0 (_data_->pdf_filter);
		_g_object_unref0 (_data_->file_dialog);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_window_set_state (_data_->self, PAPER_CLIP_WINDOW_STATE_NONE);
	_g_object_unref0 (_data_->filters);
	_g_object_unref0 (_data_->pdf_filter);
	_g_object_unref0 (_data_->file_dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_paper_clip_window_hide_progress_bar_animation_adw_animation_done (AdwAnimation* _sender,
                                                                   gpointer self)
{
	paper_clip_window_hide_progress_bar_animation ((PaperClipWindow*) self);
}

static void
paper_clip_window_file_save_animation (PaperClipWindow* self)
{
	AdwPropertyAnimationTarget* property_target = NULL;
	GtkProgressBar* _tmp0_;
	AdwPropertyAnimationTarget* _tmp1_;
	AdwTimedAnimation* animation = NULL;
	GtkProgressBar* _tmp2_;
	AdwAnimationTarget* _tmp3_;
	AdwTimedAnimation* _tmp4_ = NULL;
	GtkProgressBar* _tmp5_;
	GtkProgressBar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	_tmp1_ = (AdwPropertyAnimationTarget*) adw_property_animation_target_new ((GObject*) _tmp0_, "fraction");
	property_target = _tmp1_;
	_tmp2_ = self->priv->progress_bar;
	_tmp3_ = _g_object_ref0 ((AdwAnimationTarget*) property_target);
	_tmp4_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) _tmp2_, (gdouble) 0, (gdouble) 1, (guint) 200, _tmp3_);
	adw_timed_animation_set_easing (_tmp4_, ADW_EASE_IN_OUT_SINE);
	animation = _tmp4_;
	g_signal_connect_object ((AdwAnimation*) animation, "done", (GCallback) _paper_clip_window_hide_progress_bar_animation_adw_animation_done, self, 0);
	_tmp5_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp5_, (gdouble) 0);
	_tmp6_ = self->priv->progress_bar;
	gtk_widget_set_opacity ((GtkWidget*) _tmp6_, (gdouble) 1);
	adw_animation_play ((AdwAnimation*) animation);
	_g_object_unref0 (animation);
	_g_object_unref0 (property_target);
}

void
paper_clip_window_shortcuts (PaperClipWindow* self)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkShortcutsWindow* shortcuts_window = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkShortcutsWindow* _tmp3_;
	GtkShortcutsWindow* _tmp4_;
	GtkShortcutsWindow* _tmp5_;
	GtkShortcutsWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/io/github/diegoivan/pdf_metadata_editor/gtk/shortcut-window.ui");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "shortcut_window");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_shortcuts_window_get_type ()) ? ((GtkShortcutsWindow*) _tmp2_) : NULL);
	shortcuts_window = _tmp3_;
	_tmp4_ = shortcuts_window;
	if (_tmp4_ == NULL) {
		g_critical ("window.vala:268: Failed to load shortcuts");
		_g_object_unref0 (shortcuts_window);
		_g_object_unref0 (builder);
		return;
	}
	_tmp5_ = shortcuts_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) self);
	_tmp6_ = shortcuts_window;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_g_object_unref0 (shortcuts_window);
	_g_object_unref0 (builder);
}

static void
paper_clip_window_on_main_menu_action (PaperClipWindow* self)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->menu_button;
	gtk_menu_button_popup (_tmp0_);
}

static void
paper_clip_window_hide_progress_bar_animation (PaperClipWindow* self)
{
	AdwPropertyAnimationTarget* property_target = NULL;
	GtkProgressBar* _tmp0_;
	AdwPropertyAnimationTarget* _tmp1_;
	AdwTimedAnimation* animation = NULL;
	GtkProgressBar* _tmp2_;
	AdwAnimationTarget* _tmp3_;
	AdwTimedAnimation* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	_tmp1_ = (AdwPropertyAnimationTarget*) adw_property_animation_target_new ((GObject*) _tmp0_, "opacity");
	property_target = _tmp1_;
	_tmp2_ = self->priv->progress_bar;
	_tmp3_ = _g_object_ref0 ((AdwAnimationTarget*) property_target);
	_tmp4_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) _tmp2_, (gdouble) 1, (gdouble) 0, (guint) 200, _tmp3_);
	adw_timed_animation_set_easing (_tmp4_, ADW_EASE_IN_OUT_SINE);
	animation = _tmp4_;
	adw_animation_play ((AdwAnimation*) animation);
	_g_object_unref0 (animation);
	_g_object_unref0 (property_target);
}

static void
paper_clip_window_pulse_progress_bar (PaperClipWindow* self)
{
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_bar;
	gtk_widget_set_opacity ((GtkWidget*) _tmp0_, (gdouble) 1);
	_tmp1_ = self->priv->progress_bar;
	gtk_progress_bar_pulse (_tmp1_);
}

static gboolean
paper_clip_window_on_close_request (PaperClipWindow* self)
{
	gboolean _tmp0_ = FALSE;
	PaperClipServicesDocumentManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_document_manager;
	_tmp2_ = paper_clip_services_document_manager_get_changed (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		PaperClipWindowState _tmp4_;
		_tmp4_ = self->priv->_state;
		_tmp0_ = _tmp4_ == PAPER_CLIP_WINDOW_STATE_CLOSING;
	}
	if (_tmp0_) {
		paper_clip_window_set_state (self, PAPER_CLIP_WINDOW_STATE_NONE);
		result = FALSE;
		return result;
	}
	paper_clip_window_quit_and_save (self, NULL, NULL);
	result = TRUE;
	return result;
}

static gboolean
_paper_clip_window_on_close_request_gtk_window_close_request (GtkWindow* _sender,
                                                              gpointer self)
{
	gboolean result;
	result = paper_clip_window_on_close_request ((PaperClipWindow*) self);
	return result;
}

static void
paper_clip_window_quit_and_save_data_free (gpointer _data)
{
	PaperClipWindowQuitAndSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowQuitAndSaveData, _data_);
}

static void
paper_clip_window_quit_and_save (PaperClipWindow* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	PaperClipWindowQuitAndSaveData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowQuitAndSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_quit_and_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_quit_and_save_co (_data_);
}

static void
paper_clip_window_quit_and_save_finish (PaperClipWindow* self,
                                        GAsyncResult* _res_)
{
	PaperClipWindowQuitAndSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_quit_and_save_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	PaperClipWindowQuitAndSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_quit_and_save_co (_data_);
}

static gboolean
paper_clip_window_quit_and_save_co (PaperClipWindowQuitAndSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	paper_clip_window_set_state (_data_->self, PAPER_CLIP_WINDOW_STATE_CLOSING);
	_data_->_state_ = 1;
	paper_clip_window_show_unsaved_warning (_data_->self, paper_clip_window_quit_and_save_ready, _data_);
	return FALSE;
	_state_1:
	paper_clip_window_show_unsaved_warning_finish (_data_->self, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_show_unsaved_warning_data_free (gpointer _data)
{
	PaperClipWindowShowUnsavedWarningData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipWindowShowUnsavedWarningData, _data_);
}

static void
paper_clip_window_show_unsaved_warning (PaperClipWindow* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	PaperClipWindowShowUnsavedWarningData* _data_;
	PaperClipWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipWindowShowUnsavedWarningData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_window_show_unsaved_warning_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_window_show_unsaved_warning_co (_data_);
}

static void
paper_clip_window_show_unsaved_warning_finish (PaperClipWindow* self,
                                               GAsyncResult* _res_)
{
	PaperClipWindowShowUnsavedWarningData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
paper_clip_window_show_unsaved_warning_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	PaperClipWindowShowUnsavedWarningData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_window_show_unsaved_warning_co (_data_);
}

static gboolean
paper_clip_window_show_unsaved_warning_co (PaperClipWindowShowUnsavedWarningData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _g_object_ref0 ((GtkWindow*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = paper_clip_save_changes_dialog_new ();
	gtk_window_set_transient_for ((GtkWindow*) _data_->_tmp1_, _data_->_tmp0_);
	_g_object_unref0 (_data_->_tmp0_);
	gtk_window_set_modal ((GtkWindow*) _data_->_tmp1_, TRUE);
	g_object_ref_sink (_data_->_tmp1_);
	_data_->save_changes_dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->save_changes_dialog;
	_data_->_tmp3_ = _data_->self->priv->_document_manager;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->_tmp5_ = g_new0 (PaperClipServicesDocumentManager*, 1 + 1);
	_data_->_tmp5_[0] = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = 1;
	_data_->_state_ = 1;
	paper_clip_save_changes_dialog_ask (_data_->_tmp2_, _data_->_tmp6_, (gint) 1, NULL, paper_clip_window_show_unsaved_warning_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = paper_clip_save_changes_dialog_ask_finish (_data_->_tmp2_, _data_->_res_);
	_data_->_tmp6_ = (_vala_array_free (_data_->_tmp6_, _data_->_tmp6__length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->response = _data_->_tmp7_;
	if (_data_->response == PAPER_CLIP_SAVE_CHANGES_RESPONSE_CANCEL) {
		paper_clip_window_set_state (_data_->self, PAPER_CLIP_WINDOW_STATE_NONE);
		_g_object_unref0 (_data_->save_changes_dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->response == PAPER_CLIP_SAVE_CHANGES_RESPONSE_SAVE) {
		_data_->_state_ = 2;
		paper_clip_window_save_file (_data_->self, paper_clip_window_show_unsaved_warning_ready, _data_);
		return FALSE;
		_state_2:
		paper_clip_window_save_file_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->save_changes_dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_window_proceed_with_state (_data_->self);
	_g_object_unref0 (_data_->save_changes_dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_window_proceed_with_state (PaperClipWindow* self)
{
	PaperClipWindowState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case PAPER_CLIP_WINDOW_STATE_NONE:
		{
			return;
		}
		case PAPER_CLIP_WINDOW_STATE_OPENING_FILE:
		{
			paper_clip_window_open_file (self, NULL, NULL);
			break;
		}
		case PAPER_CLIP_WINDOW_STATE_OPENING_DROPPED:
		{
			paper_clip_window_load_dropped_file (self, NULL, NULL);
			break;
		}
		case PAPER_CLIP_WINDOW_STATE_CLOSING:
		{
			gtk_window_close ((GtkWindow*) self);
			break;
		}
		default:
		break;
	}
}

PaperClipWindowState
paper_clip_window_get_state (PaperClipWindow* self)
{
	PaperClipWindowState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
paper_clip_window_set_state (PaperClipWindow* self,
                             PaperClipWindowState value)
{
	PaperClipWindowState old_value;
	g_return_if_fail (self != NULL);
	old_value = paper_clip_window_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, paper_clip_window_properties[PAPER_CLIP_WINDOW_STATE_PROPERTY]);
	}
}

PaperClipServicesDocumentManager*
paper_clip_window_get_document_manager (PaperClipWindow* self)
{
	PaperClipServicesDocumentManager* result;
	PaperClipServicesDocumentManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_document_manager;
	result = _tmp0_;
	return result;
}

static GFile*
paper_clip_window_get_dropped_file (PaperClipWindow* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dropped_file;
	result = _tmp0_;
	return result;
}

static void
paper_clip_window_set_dropped_file (PaperClipWindow* self,
                                    GFile* value)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_dropped_file);
	self->priv->_dropped_file = _tmp0_;
}

static void
_paper_clip_window_on_open_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	paper_clip_window_on_open_action ((PaperClipWindow*) self);
}

static void
_paper_clip_window_on_open_with_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	paper_clip_window_on_open_with_action ((PaperClipWindow*) self);
}

static void
_paper_clip_window_save_file_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	paper_clip_window_save_file_action ((PaperClipWindow*) self);
}

static void
_paper_clip_window_save_file_as_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	paper_clip_window_save_file_as_action ((PaperClipWindow*) self);
}

static void
_paper_clip_window_on_main_menu_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	paper_clip_window_on_main_menu_action ((PaperClipWindow*) self);
}

static gboolean
_paper_clip_window_on_file_dropped_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                         GValue* value,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self)
{
	gboolean result;
	result = paper_clip_window_on_file_dropped ((PaperClipWindow*) self, value);
	return result;
}

static GObject *
paper_clip_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PaperClipWindow * self;
	GActionEntry* entries = NULL;
	GActionEntry _tmp0_ = {0};
	GActionEntry _tmp1_ = {0};
	GActionEntry _tmp2_ = {0};
	GActionEntry _tmp3_ = {0};
	GActionEntry _tmp4_ = {0};
	GActionEntry* _tmp5_;
	gint entries_length1;
	gint _entries_size_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp6_;
	GSimpleActionGroup* _tmp7_;
	GActionEntry* _tmp8_;
	gint _tmp8__length1;
	GSimpleActionGroup* _tmp9_;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp10_;
	GtkDropTarget* _tmp11_;
	GtkStack* _tmp12_;
	GtkDropTarget* _tmp13_;
	GtkEventController* _tmp14_;
	PaperClipDropOverlay* _tmp15_;
	GtkDropTarget* _tmp16_;
	parent_class = G_OBJECT_CLASS (paper_clip_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_TYPE_WINDOW, PaperClipWindow);
	memset (&_tmp0_, 0, sizeof (GActionEntry));
	_tmp0_.name = "open";
	_tmp0_.activate = _paper_clip_window_on_open_action_gsimple_action_activate_callback;
	memset (&_tmp1_, 0, sizeof (GActionEntry));
	_tmp1_.name = "open-with";
	_tmp1_.activate = _paper_clip_window_on_open_with_action_gsimple_action_activate_callback;
	memset (&_tmp2_, 0, sizeof (GActionEntry));
	_tmp2_.name = "save";
	_tmp2_.activate = _paper_clip_window_save_file_action_gsimple_action_activate_callback;
	memset (&_tmp3_, 0, sizeof (GActionEntry));
	_tmp3_.name = "save-as";
	_tmp3_.activate = _paper_clip_window_save_file_as_action_gsimple_action_activate_callback;
	memset (&_tmp4_, 0, sizeof (GActionEntry));
	_tmp4_.name = "main-menu";
	_tmp4_.activate = _paper_clip_window_on_main_menu_action_gsimple_action_activate_callback;
	_tmp5_ = g_new0 (GActionEntry, 5);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	entries = _tmp5_;
	entries_length1 = 5;
	_entries_size_ = entries_length1;
	_tmp6_ = g_simple_action_group_new ();
	action_group = _tmp6_;
	_tmp7_ = action_group;
	_tmp8_ = entries;
	_tmp8__length1 = entries_length1;
	g_action_map_add_action_entries ((GActionMap*) _tmp7_, _tmp8_, (gint) _tmp8__length1, self);
	_tmp9_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "win", (GActionGroup*) _tmp9_);
	_tmp10_ = gtk_drop_target_new (g_file_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp10_;
	_tmp11_ = drop_target;
	g_signal_connect_object (_tmp11_, "drop", (GCallback) _paper_clip_window_on_file_dropped_gtk_drop_target_drop, self, 0);
	_tmp12_ = self->priv->view_stack;
	_tmp13_ = drop_target;
	_tmp14_ = _g_object_ref0 ((GtkEventController*) _tmp13_);
	gtk_widget_add_controller ((GtkWidget*) _tmp12_, _tmp14_);
	_tmp15_ = self->priv->drop_overlay;
	_tmp16_ = drop_target;
	paper_clip_drop_overlay_set_drop_target (_tmp15_, _tmp16_);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (action_group);
	entries = (g_free (entries), NULL);
	return obj;
}

static void
paper_clip_window_class_init (PaperClipWindowClass * klass,
                              gpointer klass_data)
{
	paper_clip_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaperClipWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paper_clip_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paper_clip_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = paper_clip_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = paper_clip_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_WINDOW_STATE_PROPERTY, paper_clip_window_properties[PAPER_CLIP_WINDOW_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", PAPER_CLIP_TYPE_WINDOW_STATE, PAPER_CLIP_WINDOW_STATE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_WINDOW_DOCUMENT_MANAGER_PROPERTY, paper_clip_window_properties[PAPER_CLIP_WINDOW_DOCUMENT_MANAGER_PROPERTY] = g_param_spec_object ("document-manager", "document-manager", "document-manager", PAPER_CLIP_SERVICES_TYPE_DOCUMENT_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/io/github/diegoivan/pdf_metadata_editor/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "doc_view", FALSE, PaperClipWindow_private_offset + G_STRUCT_OFFSET (PaperClipWindowPrivate, doc_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_stack", FALSE, PaperClipWindow_private_offset + G_STRUCT_OFFSET (PaperClipWindowPrivate, view_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, PaperClipWindow_private_offset + G_STRUCT_OFFSET (PaperClipWindowPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, PaperClipWindow_private_offset + G_STRUCT_OFFSET (PaperClipWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "drop_overlay", FALSE, PaperClipWindow_private_offset + G_STRUCT_OFFSET (PaperClipWindowPrivate, drop_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_bar", FALSE, PaperClipWindow_private_offset + G_STRUCT_OFFSET (PaperClipWindowPrivate, progress_bar));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_close_request", G_CALLBACK(_paper_clip_window_on_close_request_gtk_window_close_request));
	g_type_ensure (PAPER_CLIP_TYPE_DROP_OVERLAY);
}

static void
paper_clip_window_instance_init (PaperClipWindow * self,
                                 gpointer klass)
{
	PaperClipServicesDocumentManager* _tmp0_;
	self->priv = paper_clip_window_get_instance_private (self);
	self->priv->_state = PAPER_CLIP_WINDOW_STATE_NONE;
	_tmp0_ = paper_clip_services_document_manager_new ();
	self->priv->_document_manager = _tmp0_;
	self->priv->_dropped_file = NULL;
	g_type_ensure (PAPER_CLIP_TYPE_DOCUMENT_VIEW);
	g_type_ensure (PAPER_CLIP_TYPE_DROP_OVERLAY);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
paper_clip_window_finalize (GObject * obj)
{
	PaperClipWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_TYPE_WINDOW, PaperClipWindow);
	_g_object_unref0 (self->priv->_document_manager);
	_g_object_unref0 (self->priv->_dropped_file);
	G_OBJECT_CLASS (paper_clip_window_parent_class)->finalize (obj);
}

static GType
paper_clip_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PaperClipWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paper_clip_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaperClipWindow), 0, (GInstanceInitFunc) paper_clip_window_instance_init, NULL };
	GType paper_clip_window_type_id;
	paper_clip_window_type_id = g_type_register_static (adw_application_window_get_type (), "PaperClipWindow", &g_define_type_info, 0);
	PaperClipWindow_private_offset = g_type_add_instance_private (paper_clip_window_type_id, sizeof (PaperClipWindowPrivate));
	return paper_clip_window_type_id;
}

GType
paper_clip_window_get_type (void)
{
	static volatile gsize paper_clip_window_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_window_type_id__once)) {
		GType paper_clip_window_type_id;
		paper_clip_window_type_id = paper_clip_window_get_type_once ();
		g_once_init_leave (&paper_clip_window_type_id__once, paper_clip_window_type_id);
	}
	return paper_clip_window_type_id__once;
}

static void
_vala_paper_clip_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	PaperClipWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_WINDOW, PaperClipWindow);
	switch (property_id) {
		case PAPER_CLIP_WINDOW_STATE_PROPERTY:
		g_value_set_enum (value, paper_clip_window_get_state (self));
		break;
		case PAPER_CLIP_WINDOW_DOCUMENT_MANAGER_PROPERTY:
		g_value_set_object (value, paper_clip_window_get_document_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_paper_clip_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	PaperClipWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_WINDOW, PaperClipWindow);
	switch (property_id) {
		case PAPER_CLIP_WINDOW_STATE_PROPERTY:
		paper_clip_window_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
paper_clip_window_state_get_type_once (void)
{
	static const GEnumValue values[] = {{PAPER_CLIP_WINDOW_STATE_NONE, "PAPER_CLIP_WINDOW_STATE_NONE", "none"}, {PAPER_CLIP_WINDOW_STATE_OPENING_FILE, "PAPER_CLIP_WINDOW_STATE_OPENING_FILE", "opening-file"}, {PAPER_CLIP_WINDOW_STATE_CLOSING, "PAPER_CLIP_WINDOW_STATE_CLOSING", "closing"}, {PAPER_CLIP_WINDOW_STATE_OPENING_DROPPED, "PAPER_CLIP_WINDOW_STATE_OPENING_DROPPED", "opening-dropped"}, {0, NULL, NULL}};
	GType paper_clip_window_state_type_id;
	paper_clip_window_state_type_id = g_enum_register_static ("PaperClipWindowState", values);
	return paper_clip_window_state_type_id;
}

GType
paper_clip_window_state_get_type (void)
{
	static volatile gsize paper_clip_window_state_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_window_state_type_id__once)) {
		GType paper_clip_window_state_type_id;
		paper_clip_window_state_type_id = paper_clip_window_state_get_type_once ();
		g_once_init_leave (&paper_clip_window_state_type_id__once, paper_clip_window_state_type_id);
	}
	return paper_clip_window_state_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

