/* Tags.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Tags.vala, do not modify */

/*
* Copyright (c) 2011-2016 Felipe Escoto (https://github.com/Philip-Scott/Notes-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ENOTES_TYPE_TAG (enotes_tag_get_type ())
#define ENOTES_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAG, ENotesTag))
#define ENOTES_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAG, ENotesTagClass))
#define ENOTES_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAG))
#define ENOTES_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAG))
#define ENOTES_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAG, ENotesTagClass))

typedef struct _ENotesTag ENotesTag;
typedef struct _ENotesTagClass ENotesTagClass;
typedef struct _ENotesTagPrivate ENotesTagPrivate;
enum  {
	ENOTES_TAG_0_PROPERTY,
	ENOTES_TAG_NUM_PROPERTIES
};
static GParamSpec* enotes_tag_properties[ENOTES_TAG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define ENOTES_TYPE_TAGS_TABLE (enotes_tags_table_get_type ())
#define ENOTES_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTable))
#define ENOTES_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))
#define ENOTES_IS_TAGS_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_IS_TAGS_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_TAGS_TABLE))
#define ENOTES_TAGS_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_TAGS_TABLE, ENotesTagsTableClass))

typedef struct _ENotesTagsTable ENotesTagsTable;
typedef struct _ENotesTagsTableClass ENotesTagsTableClass;
typedef struct _ENotesTagsTablePrivate ENotesTagsTablePrivate;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ENOTES_TYPE_PAGE (enotes_page_get_type ())
#define ENOTES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ENOTES_TYPE_PAGE, ENotesPage))
#define ENOTES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ENOTES_TYPE_PAGE, ENotesPageClass))
#define ENOTES_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ENOTES_TYPE_PAGE))
#define ENOTES_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ENOTES_TYPE_PAGE))
#define ENOTES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ENOTES_TYPE_PAGE, ENotesPageClass))

typedef struct _ENotesPage ENotesPage;
typedef struct _ENotesPageClass ENotesPageClass;
typedef struct _ENotesPagePrivate ENotesPagePrivate;

struct _ENotesTag {
	GObject parent_instance;
	ENotesTagPrivate * priv;
	gint64 id;
	gchar* name;
	gchar* data;
};

struct _ENotesTagClass {
	GObjectClass parent_class;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ENotesTagsTable {
	DatabaseTable parent_instance;
	ENotesTagsTablePrivate * priv;
};

struct _ENotesTagsTableClass {
	DatabaseTableClass parent_class;
};

struct _ENotesPage {
	GObject parent_instance;
	ENotesPagePrivate * priv;
	gint64 id;
	gint64 notebook_id;
	gchar* name;
	gchar* data;
	gchar* subtitle;
	gchar* html_cache;
	gint64 creation_date;
	gint64 modification_date;
	gboolean new_page;
	gboolean cache_changed;
	gchar* full_path;
};

struct _ENotesPageClass {
	GObjectClass parent_class;
};

static gpointer enotes_tag_parent_class = NULL;
static gpointer enotes_tags_table_parent_class = NULL;
static ENotesTagsTable* enotes_tags_table_instance;
static ENotesTagsTable* enotes_tags_table_instance = NULL;

VALA_EXTERN GType enotes_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTag, g_object_unref)
VALA_EXTERN ENotesTag* enotes_tag_new (void);
VALA_EXTERN ENotesTag* enotes_tag_construct (GType object_type);
static void enotes_tag_finalize (GObject * obj);
static GType enotes_tag_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType enotes_tags_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesTagsTable, database_table_unref)
VALA_EXTERN ENotesTagsTable* enotes_tags_table_get_instance (void);
static ENotesTagsTable* enotes_tags_table_new (void);
static ENotesTagsTable* enotes_tags_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN sqlite3_stmt* database_table_create_stmt (const gchar* data);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN GeeArrayList* enotes_tags_table_get_tags_for_page (ENotesTagsTable* self,
                                                   gint64 page_id);
VALA_EXTERN void database_table_bind_int (sqlite3_stmt* stmt,
                              gint column,
                              gint64 data);
VALA_EXTERN GType enotes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ENotesPage, g_object_unref)
VALA_EXTERN void enotes_tags_table_create_tag (ENotesTagsTable* self,
                                   const gchar* name,
                                   ENotesPage* page);
VALA_EXTERN void database_table_bind_text (sqlite3_stmt* stmt,
                               gint column,
                               const gchar* data);
VALA_EXTERN void enotes_tags_table_delete_tag (ENotesTagsTable* self,
                                   ENotesTag* tag);
VALA_EXTERN void enotes_tags_table_remove_tags_from_page (ENotesTagsTable* self,
                                              gint64 page_id);
VALA_EXTERN void enotes_tags_table_remove_tag_from_page (ENotesTagsTable* self,
                                             gint64 tag_id,
                                             gint64 page_id);
VALA_EXTERN gboolean enotes_tags_table_save_tag (ENotesTagsTable* self,
                                     ENotesTag* tag);
VALA_EXTERN GeeArrayList* enotes_tags_table_get_tags (ENotesTagsTable* self);
VALA_EXTERN GeeArrayList* enotes_tags_table_get_pages_for_tag (ENotesTagsTable* self,
                                                   ENotesTag* tag);
VALA_EXTERN ENotesPage* enotes_page_new (void);
VALA_EXTERN ENotesPage* enotes_page_construct (GType object_type);
VALA_EXTERN void enotes_tags_table_reset_instance (void);
static void enotes_tags_table_finalize (DatabaseTable * obj);
static GType enotes_tags_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ENotesTag*
enotes_tag_construct (GType object_type)
{
	ENotesTag * self = NULL;
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	self = (ENotesTag*) g_object_new (object_type, NULL);
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return self;
#line 234 "Tags.c"
}

ENotesTag*
enotes_tag_new (void)
{
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return enotes_tag_construct (ENOTES_TYPE_TAG);
#line 242 "Tags.c"
}

static void
enotes_tag_class_init (ENotesTagClass * klass,
                       gpointer klass_data)
{
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	enotes_tag_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	G_OBJECT_CLASS (klass)->finalize = enotes_tag_finalize;
#line 253 "Tags.c"
}

static void
enotes_tag_instance_init (ENotesTag * self,
                          gpointer klass)
{
#line 23 "../Notes-up-2.0.6/src/Services/Tags.vala"
	self->id = (gint64) -1;
#line 262 "Tags.c"
}

static void
enotes_tag_finalize (GObject * obj)
{
	ENotesTag * self;
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_TAG, ENotesTag);
#line 24 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_g_free0 (self->name);
#line 25 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_g_free0 (self->data);
#line 22 "../Notes-up-2.0.6/src/Services/Tags.vala"
	G_OBJECT_CLASS (enotes_tag_parent_class)->finalize (obj);
#line 277 "Tags.c"
}

static GType
enotes_tag_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesTagClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_tag_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesTag), 0, (GInstanceInitFunc) enotes_tag_instance_init, NULL };
	GType enotes_tag_type_id;
	enotes_tag_type_id = g_type_register_static (G_TYPE_OBJECT, "ENotesTag", &g_define_type_info, 0);
	return enotes_tag_type_id;
}

GType
enotes_tag_get_type (void)
{
	static volatile gsize enotes_tag_type_id__once = 0;
	if (g_once_init_enter (&enotes_tag_type_id__once)) {
		GType enotes_tag_type_id;
		enotes_tag_type_id = enotes_tag_get_type_once ();
		g_once_init_leave (&enotes_tag_type_id__once, enotes_tag_type_id);
	}
	return enotes_tag_type_id__once;
}

static gpointer
_database_table_ref0 (gpointer self)
{
#line 36 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return self ? database_table_ref (self) : NULL;
#line 306 "Tags.c"
}

ENotesTagsTable*
enotes_tags_table_get_instance (void)
{
	ENotesTagsTable* _tmp0_;
	ENotesTagsTable* _tmp2_;
	ENotesTagsTable* _tmp3_;
	ENotesTagsTable* result;
#line 32 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = enotes_tags_table_instance;
#line 32 "../Notes-up-2.0.6/src/Services/Tags.vala"
	if (_tmp0_ == NULL) {
#line 320 "Tags.c"
		ENotesTagsTable* _tmp1_;
#line 33 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp1_ = enotes_tags_table_new ();
#line 33 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_database_table_unref0 (enotes_tags_table_instance);
#line 33 "../Notes-up-2.0.6/src/Services/Tags.vala"
		enotes_tags_table_instance = _tmp1_;
#line 328 "Tags.c"
	}
#line 36 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp2_ = enotes_tags_table_instance;
#line 36 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 36 "../Notes-up-2.0.6/src/Services/Tags.vala"
	result = _tmp3_;
#line 36 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return result;
#line 338 "Tags.c"
}

static ENotesTagsTable*
enotes_tags_table_construct (GType object_type)
{
	ENotesTagsTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
#line 39 "../Notes-up-2.0.6/src/Services/Tags.vala"
	self = (ENotesTagsTable*) database_table_construct (object_type);
#line 40 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("CREATE TABLE IF NOT EXISTS Tags (" "id INTEGER PRIMARY KEY AUTOINCREMENT, " "name TEXT UNIQUE NOT NULL DEFAULT '', " "data TEXT NOT NULL DEFAULT '')");
#line 40 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp0_;
#line 45 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = stmt;
#line 45 "../Notes-up-2.0.6/src/Services/Tags.vala"
	res = sqlite3_step (_tmp1_);
#line 47 "../Notes-up-2.0.6/src/Services/Tags.vala"
	if (res != SQLITE_DONE) {
#line 48 "../Notes-up-2.0.6/src/Services/Tags.vala"
		database_table_fatal ("Failed to create tag table", res);
#line 365 "Tags.c"
	}
#line 50 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp2_ = database_table_create_stmt ("CREATE TABLE IF NOT EXISTS TagsPage (" "page_id INTEGER, " "tag_id INTEGER)");
#line 50 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 50 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp2_;
#line 54 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp3_ = stmt;
#line 54 "../Notes-up-2.0.6/src/Services/Tags.vala"
	res = sqlite3_step (_tmp3_);
#line 56 "../Notes-up-2.0.6/src/Services/Tags.vala"
	if (res != SQLITE_DONE) {
#line 57 "../Notes-up-2.0.6/src/Services/Tags.vala"
		database_table_fatal ("Failed to create tag table", res);
#line 381 "Tags.c"
	}
#line 60 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_set_table_name ((DatabaseTable*) self, "Tags");
#line 39 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 39 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return self;
#line 389 "Tags.c"
}

static ENotesTagsTable*
enotes_tags_table_new (void)
{
#line 39 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return enotes_tags_table_construct (ENOTES_TYPE_TAGS_TABLE);
#line 397 "Tags.c"
}

GeeArrayList*
enotes_tags_table_get_tags_for_page (ENotesTagsTable* self,
                                     gint64 page_id)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	GeeArrayList* tags = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* result;
#line 63 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("SELECT id, name, data " "FROM Tags tag " "INNER JOIN TagsPage tp " "   ON tp.tag_id = tag.id " "WHERE tp.page_id = ?");
#line 64 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp0_;
#line 70 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = stmt;
#line 70 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (_tmp1_, 1, page_id);
#line 72 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp2_ = gee_array_list_new (ENOTES_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 72 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tags = _tmp2_;
#line 424 "Tags.c"
	{
		gboolean _tmp3_ = FALSE;
#line 74 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp3_ = TRUE;
#line 74 "../Notes-up-2.0.6/src/Services/Tags.vala"
		while (TRUE) {
#line 431 "Tags.c"
			gint res = 0;
			sqlite3_stmt* _tmp4_;
			ENotesTag* row = NULL;
			ENotesTag* _tmp5_;
			ENotesTag* _tmp6_;
			sqlite3_stmt* _tmp7_;
			ENotesTag* _tmp8_;
			sqlite3_stmt* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			ENotesTag* _tmp12_;
			sqlite3_stmt* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			GeeArrayList* _tmp16_;
			ENotesTag* _tmp17_;
#line 74 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (!_tmp3_) {
#line 450 "Tags.c"
			}
#line 74 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp3_ = FALSE;
#line 75 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp4_ = stmt;
#line 75 "../Notes-up-2.0.6/src/Services/Tags.vala"
			res = sqlite3_step (_tmp4_);
#line 76 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (res == SQLITE_DONE) {
#line 77 "../Notes-up-2.0.6/src/Services/Tags.vala"
				break;
#line 462 "Tags.c"
			} else {
#line 78 "../Notes-up-2.0.6/src/Services/Tags.vala"
				if (res != SQLITE_ROW) {
#line 79 "../Notes-up-2.0.6/src/Services/Tags.vala"
					database_table_fatal ("get_all_tags", res);
#line 80 "../Notes-up-2.0.6/src/Services/Tags.vala"
					break;
#line 470 "Tags.c"
				}
			}
#line 83 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp5_ = enotes_tag_new ();
#line 83 "../Notes-up-2.0.6/src/Services/Tags.vala"
			row = _tmp5_;
#line 85 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp6_ = row;
#line 85 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp7_ = stmt;
#line 85 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp6_->id = sqlite3_column_int64 (_tmp7_, 0);
#line 86 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp8_ = row;
#line 86 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp9_ = stmt;
#line 86 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 1);
#line 86 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 86 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_free0 (_tmp8_->name);
#line 86 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp8_->name = _tmp11_;
#line 87 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp12_ = row;
#line 87 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp13_ = stmt;
#line 87 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp14_ = (const gchar*) sqlite3_column_text (_tmp13_, 2);
#line 87 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp15_ = g_strdup (_tmp14_);
#line 87 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_free0 (_tmp12_->data);
#line 87 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp12_->data = _tmp15_;
#line 89 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp16_ = tags;
#line 89 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp17_ = row;
#line 89 "../Notes-up-2.0.6/src/Services/Tags.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
#line 74 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_object_unref0 (row);
#line 515 "Tags.c"
		}
	}
#line 92 "../Notes-up-2.0.6/src/Services/Tags.vala"
	result = tags;
#line 92 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 92 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return result;
#line 524 "Tags.c"
}

void
enotes_tags_table_create_tag (ENotesTagsTable* self,
                              const gchar* name,
                              ENotesPage* page)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	gint64 tag_id = 0LL;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp16_;
	sqlite3_stmt* _tmp17_;
	sqlite3_stmt* _tmp18_;
	sqlite3_stmt* _tmp19_;
#line 95 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (self != NULL);
#line 95 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (name != NULL);
#line 95 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (page != NULL);
#line 96 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("INSERT INTO Tags (name) VALUES (?)");
#line 96 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp0_;
#line 97 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = stmt;
#line 97 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_text (_tmp1_, 1, name);
#line 98 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp2_ = stmt;
#line 98 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (_tmp2_);
#line 100 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp3_ = database_table_create_stmt ("SELECT id, name FROM Tags WHERE name = ?");
#line 100 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 100 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp3_;
#line 101 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp4_ = stmt;
#line 101 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_text (_tmp4_, 1, name);
#line 103 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp5_ = stmt;
#line 103 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (_tmp5_);
#line 104 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp6_ = stmt;
#line 104 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tag_id = sqlite3_column_int64 (_tmp6_, 0);
#line 581 "Tags.c"
	{
		GeeArrayList* _tag_list = NULL;
		GeeArrayList* _tmp7_;
		gint _tag_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tag_index = 0;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp7_ = enotes_tags_table_get_tags_for_page (self, page->id);
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tag_list = _tmp7_;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp8_ = _tag_list;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp10_ = _tmp9_;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tag_size = _tmp10_;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tag_index = -1;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		while (TRUE) {
#line 606 "Tags.c"
			gint _tmp11_;
			gint _tmp12_;
			ENotesTag* tag = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			ENotesTag* _tmp15_;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tag_index = _tag_index + 1;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp11_ = _tag_index;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp12_ = _tag_size;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (!(_tmp11_ < _tmp12_)) {
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
				break;
#line 623 "Tags.c"
			}
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp13_ = _tag_list;
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tag_index);
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			tag = (ENotesTag*) _tmp14_;
#line 107 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp15_ = tag;
#line 107 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (_tmp15_->id == tag_id) {
#line 108 "../Notes-up-2.0.6/src/Services/Tags.vala"
				_g_object_unref0 (tag);
#line 108 "../Notes-up-2.0.6/src/Services/Tags.vala"
				_g_object_unref0 (_tag_list);
#line 108 "../Notes-up-2.0.6/src/Services/Tags.vala"
				_sqlite3_finalize0 (stmt);
#line 108 "../Notes-up-2.0.6/src/Services/Tags.vala"
				return;
#line 643 "Tags.c"
			}
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_object_unref0 (tag);
#line 647 "Tags.c"
		}
#line 106 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_g_object_unref0 (_tag_list);
#line 651 "Tags.c"
	}
#line 112 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp16_ = database_table_create_stmt ("INSERT INTO TagsPage (tag_id, page_id) VALUES (?, ?)");
#line 112 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 112 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp16_;
#line 113 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp17_ = stmt;
#line 113 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (_tmp17_, 1, tag_id);
#line 114 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp18_ = stmt;
#line 114 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (_tmp18_, 2, page->id);
#line 116 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp19_ = stmt;
#line 116 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (_tmp19_);
#line 95 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 673 "Tags.c"
}

void
enotes_tags_table_delete_tag (ENotesTagsTable* self,
                              ENotesTag* tag)
{
	sqlite3_stmt* tag_page = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp1_;
#line 119 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (self != NULL);
#line 119 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (tag != NULL);
#line 120 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("DELETE FROM TagsPage WHERE tag_id = ?");
#line 120 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tag_page = _tmp0_;
#line 121 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (tag_page, 1, tag->id);
#line 123 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (tag_page);
#line 125 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = database_table_create_stmt ("DELETE FROM Tags WHERE id = ?");
#line 125 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp1_;
#line 126 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (stmt, 1, tag->id);
#line 128 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (stmt);
#line 119 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 119 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (tag_page);
#line 708 "Tags.c"
}

void
enotes_tags_table_remove_tags_from_page (ENotesTagsTable* self,
                                         gint64 page_id)
{
	sqlite3_stmt* tag_page = NULL;
	sqlite3_stmt* _tmp0_;
#line 131 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (self != NULL);
#line 132 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("DELETE FROM TagsPage WHERE page_id = ?");
#line 132 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tag_page = _tmp0_;
#line 133 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (tag_page, 1, page_id);
#line 135 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (tag_page);
#line 131 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (tag_page);
#line 729 "Tags.c"
}

void
enotes_tags_table_remove_tag_from_page (ENotesTagsTable* self,
                                        gint64 tag_id,
                                        gint64 page_id)
{
	sqlite3_stmt* tag_page = NULL;
	sqlite3_stmt* _tmp0_;
#line 138 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_if_fail (self != NULL);
#line 139 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("DELETE FROM TagsPage WHERE page_id = ? AND tag_id = ?");
#line 139 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tag_page = _tmp0_;
#line 140 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (tag_page, 1, page_id);
#line 141 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (tag_page, 2, tag_id);
#line 143 "../Notes-up-2.0.6/src/Services/Tags.vala"
	sqlite3_step (tag_page);
#line 138 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (tag_page);
#line 753 "Tags.c"
}

gboolean
enotes_tags_table_save_tag (ENotesTagsTable* self,
                            ENotesTag* tag)
{
	sqlite3_stmt* tag_page = NULL;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint res = 0;
	gboolean result;
#line 146 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 146 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 147 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("UPDATE Tags SET name = ?, data = ? WHERE id = ?");
#line 147 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tag_page = _tmp0_;
#line 149 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = tag->name;
#line 149 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_text (tag_page, 1, _tmp1_);
#line 150 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp2_ = tag->data;
#line 150 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_text (tag_page, 2, _tmp2_);
#line 151 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (tag_page, 3, tag->id);
#line 153 "../Notes-up-2.0.6/src/Services/Tags.vala"
	res = sqlite3_step (tag_page);
#line 155 "../Notes-up-2.0.6/src/Services/Tags.vala"
	result = res == SQLITE_DONE;
#line 155 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (tag_page);
#line 155 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return result;
#line 792 "Tags.c"
}

GeeArrayList*
enotes_tags_table_get_tags (ENotesTagsTable* self)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	GeeArrayList* tags = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
#line 158 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("SELECT id, name, data FROM Tags");
#line 159 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp0_;
#line 161 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = gee_array_list_new (ENOTES_TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 161 "../Notes-up-2.0.6/src/Services/Tags.vala"
	tags = _tmp1_;
#line 813 "Tags.c"
	{
		gboolean _tmp2_ = FALSE;
#line 163 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp2_ = TRUE;
#line 163 "../Notes-up-2.0.6/src/Services/Tags.vala"
		while (TRUE) {
#line 820 "Tags.c"
			gint res = 0;
			sqlite3_stmt* _tmp3_;
			ENotesTag* row = NULL;
			ENotesTag* _tmp4_;
			ENotesTag* _tmp5_;
			sqlite3_stmt* _tmp6_;
			ENotesTag* _tmp7_;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			ENotesTag* _tmp11_;
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			GeeArrayList* _tmp15_;
			ENotesTag* _tmp16_;
#line 163 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (!_tmp2_) {
#line 839 "Tags.c"
			}
#line 163 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp2_ = FALSE;
#line 164 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp3_ = stmt;
#line 164 "../Notes-up-2.0.6/src/Services/Tags.vala"
			res = sqlite3_step (_tmp3_);
#line 165 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (res == SQLITE_DONE) {
#line 166 "../Notes-up-2.0.6/src/Services/Tags.vala"
				break;
#line 851 "Tags.c"
			} else {
#line 167 "../Notes-up-2.0.6/src/Services/Tags.vala"
				if (res != SQLITE_ROW) {
#line 168 "../Notes-up-2.0.6/src/Services/Tags.vala"
					database_table_fatal ("get_all_tags", res);
#line 169 "../Notes-up-2.0.6/src/Services/Tags.vala"
					break;
#line 859 "Tags.c"
				}
			}
#line 172 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp4_ = enotes_tag_new ();
#line 172 "../Notes-up-2.0.6/src/Services/Tags.vala"
			row = _tmp4_;
#line 174 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp5_ = row;
#line 174 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp6_ = stmt;
#line 174 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp5_->id = sqlite3_column_int64 (_tmp6_, 0);
#line 175 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp7_ = row;
#line 175 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp8_ = stmt;
#line 175 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 1);
#line 175 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 175 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_free0 (_tmp7_->name);
#line 175 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp7_->name = _tmp10_;
#line 176 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp11_ = row;
#line 176 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp12_ = stmt;
#line 176 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 2);
#line 176 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 176 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_free0 (_tmp11_->data);
#line 176 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp11_->data = _tmp14_;
#line 178 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp15_ = tags;
#line 178 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp16_ = row;
#line 178 "../Notes-up-2.0.6/src/Services/Tags.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
#line 163 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_object_unref0 (row);
#line 904 "Tags.c"
		}
	}
#line 181 "../Notes-up-2.0.6/src/Services/Tags.vala"
	result = tags;
#line 181 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 181 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return result;
#line 913 "Tags.c"
}

GeeArrayList*
enotes_tags_table_get_pages_for_tag (ENotesTagsTable* self,
                                     ENotesTag* tag)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	GeeArrayList* pages = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* result;
#line 184 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 184 "../Notes-up-2.0.6/src/Services/Tags.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 185 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp0_ = database_table_create_stmt ("SELECT id, name, subtitle " "FROM Page p " "INNER JOIN TagsPage tp " "   ON tp.page_id = p.id " "WHERE tp.tag_id = ?");
#line 185 "../Notes-up-2.0.6/src/Services/Tags.vala"
	stmt = _tmp0_;
#line 191 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp1_ = stmt;
#line 191 "../Notes-up-2.0.6/src/Services/Tags.vala"
	database_table_bind_int (_tmp1_, 1, tag->id);
#line 193 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_tmp2_ = gee_array_list_new (ENOTES_TYPE_PAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 193 "../Notes-up-2.0.6/src/Services/Tags.vala"
	pages = _tmp2_;
#line 942 "Tags.c"
	{
		gboolean _tmp3_ = FALSE;
#line 195 "../Notes-up-2.0.6/src/Services/Tags.vala"
		_tmp3_ = TRUE;
#line 195 "../Notes-up-2.0.6/src/Services/Tags.vala"
		while (TRUE) {
#line 949 "Tags.c"
			gint res = 0;
			sqlite3_stmt* _tmp4_;
			ENotesPage* row = NULL;
			ENotesPage* _tmp5_;
			ENotesPage* _tmp6_;
			sqlite3_stmt* _tmp7_;
			ENotesPage* _tmp8_;
			sqlite3_stmt* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			ENotesPage* _tmp12_;
			sqlite3_stmt* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			GeeArrayList* _tmp16_;
			ENotesPage* _tmp17_;
#line 195 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (!_tmp3_) {
#line 968 "Tags.c"
			}
#line 195 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp3_ = FALSE;
#line 196 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp4_ = stmt;
#line 196 "../Notes-up-2.0.6/src/Services/Tags.vala"
			res = sqlite3_step (_tmp4_);
#line 197 "../Notes-up-2.0.6/src/Services/Tags.vala"
			if (res == SQLITE_DONE) {
#line 198 "../Notes-up-2.0.6/src/Services/Tags.vala"
				break;
#line 980 "Tags.c"
			} else {
#line 199 "../Notes-up-2.0.6/src/Services/Tags.vala"
				if (res != SQLITE_ROW) {
#line 200 "../Notes-up-2.0.6/src/Services/Tags.vala"
					database_table_fatal ("get_pages_for_tag", res);
#line 201 "../Notes-up-2.0.6/src/Services/Tags.vala"
					break;
#line 988 "Tags.c"
				}
			}
#line 204 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp5_ = enotes_page_new ();
#line 204 "../Notes-up-2.0.6/src/Services/Tags.vala"
			row = _tmp5_;
#line 206 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp6_ = row;
#line 206 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp7_ = stmt;
#line 206 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp6_->id = sqlite3_column_int64 (_tmp7_, 0);
#line 207 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp8_ = row;
#line 207 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp9_ = stmt;
#line 207 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 1);
#line 207 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 207 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_free0 (_tmp8_->name);
#line 207 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp8_->name = _tmp11_;
#line 208 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp12_ = row;
#line 208 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp13_ = stmt;
#line 208 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp14_ = (const gchar*) sqlite3_column_text (_tmp13_, 2);
#line 208 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp15_ = g_strdup (_tmp14_);
#line 208 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_free0 (_tmp12_->subtitle);
#line 208 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp12_->subtitle = _tmp15_;
#line 210 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp16_ = pages;
#line 210 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_tmp17_ = row;
#line 210 "../Notes-up-2.0.6/src/Services/Tags.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
#line 195 "../Notes-up-2.0.6/src/Services/Tags.vala"
			_g_object_unref0 (row);
#line 1033 "Tags.c"
		}
	}
#line 213 "../Notes-up-2.0.6/src/Services/Tags.vala"
	result = pages;
#line 213 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_sqlite3_finalize0 (stmt);
#line 213 "../Notes-up-2.0.6/src/Services/Tags.vala"
	return result;
#line 1042 "Tags.c"
}

void
enotes_tags_table_reset_instance (void)
{
#line 217 "../Notes-up-2.0.6/src/Services/Tags.vala"
	_database_table_unref0 (enotes_tags_table_instance);
#line 217 "../Notes-up-2.0.6/src/Services/Tags.vala"
	enotes_tags_table_instance = NULL;
#line 1052 "Tags.c"
}

static void
enotes_tags_table_class_init (ENotesTagsTableClass * klass,
                              gpointer klass_data)
{
#line 28 "../Notes-up-2.0.6/src/Services/Tags.vala"
	enotes_tags_table_parent_class = g_type_class_peek_parent (klass);
#line 28 "../Notes-up-2.0.6/src/Services/Tags.vala"
	((DatabaseTableClass *) klass)->finalize = enotes_tags_table_finalize;
#line 1063 "Tags.c"
}

static void
enotes_tags_table_instance_init (ENotesTagsTable * self,
                                 gpointer klass)
{
}

static void
enotes_tags_table_finalize (DatabaseTable * obj)
{
	ENotesTagsTable * self;
#line 28 "../Notes-up-2.0.6/src/Services/Tags.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ENOTES_TYPE_TAGS_TABLE, ENotesTagsTable);
#line 28 "../Notes-up-2.0.6/src/Services/Tags.vala"
	DATABASE_TABLE_CLASS (enotes_tags_table_parent_class)->finalize (obj);
#line 1080 "Tags.c"
}

static GType
enotes_tags_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ENotesTagsTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enotes_tags_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ENotesTagsTable), 0, (GInstanceInitFunc) enotes_tags_table_instance_init, NULL };
	GType enotes_tags_table_type_id;
	enotes_tags_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "ENotesTagsTable", &g_define_type_info, 0);
	return enotes_tags_table_type_id;
}

GType
enotes_tags_table_get_type (void)
{
	static volatile gsize enotes_tags_table_type_id__once = 0;
	if (g_once_init_enter (&enotes_tags_table_type_id__once)) {
		GType enotes_tags_table_type_id;
		enotes_tags_table_type_id = enotes_tags_table_get_type_once ();
		g_once_init_leave (&enotes_tags_table_type_id__once, enotes_tags_table_type_id);
	}
	return enotes_tags_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

