use glib::{Object, Properties, prelude::*, subclass};
use gtk4::{Accessible, Buildable, CompositeTemplate, ConstraintTarget, Widget, subclass::prelude::*};
use libadwaita::{Bin, subclass::prelude::*};
use std::cell::Cell;

mod imp {
    use super::*;

    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::FontSizeControl)]
    #[template(file = "data/resources/ui_templates/article_view/font_size.blp")]
    pub struct FontSizeControl {
        #[property(get, set, name = "font-size")]
        pub font_size: Cell<u32>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for FontSizeControl {
        const NAME: &'static str = "FontSizeControl";
        type Type = super::FontSizeControl;
        type ParentType = Bin;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
            klass.bind_template_callbacks();
        }

        fn instance_init(obj: &subclass::InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for FontSizeControl {}

    impl WidgetImpl for FontSizeControl {}

    impl BinImpl for FontSizeControl {}

    #[gtk4::template_callbacks]
    impl FontSizeControl {
        #[template_callback]
        fn int_to_string(&self, int: u32) -> String {
            format!("{int} pt")
        }
    }
}

glib::wrapper! {
    pub struct FontSizeControl(ObjectSubclass<imp::FontSizeControl>)
        @extends Widget, Bin,
        @implements Accessible, Buildable, ConstraintTarget;
}

impl Default for FontSizeControl {
    fn default() -> Self {
        Object::new()
    }
}
