/* UndoNodeMove.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoNodeMove.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_NODE_MOVE (undo_node_move_get_type ())
#define UNDO_NODE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_NODE_MOVE, UndoNodeMove))
#define UNDO_NODE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_NODE_MOVE, UndoNodeMoveClass))
#define IS_UNDO_NODE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_NODE_MOVE))
#define IS_UNDO_NODE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_NODE_MOVE))
#define UNDO_NODE_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_NODE_MOVE, UndoNodeMoveClass))

typedef struct _UndoNodeMove UndoNodeMove;
typedef struct _UndoNodeMoveClass UndoNodeMoveClass;
typedef struct _UndoNodeMovePrivate UndoNodeMovePrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_SUMMARY_NODE (summary_node_get_type ())
#define SUMMARY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUMMARY_NODE, SummaryNode))
#define SUMMARY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUMMARY_NODE, SummaryNodeClass))
#define IS_SUMMARY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUMMARY_NODE))
#define IS_SUMMARY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUMMARY_NODE))
#define SUMMARY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUMMARY_NODE, SummaryNodeClass))

typedef struct _SummaryNode SummaryNode;
typedef struct _SummaryNodeClass SummaryNodeClass;
enum  {
	UNDO_NODE_MOVE_0_PROPERTY,
	UNDO_NODE_MOVE_NUM_PROPERTIES
};
static GParamSpec* undo_node_move_properties[UNDO_NODE_MOVE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ANIMATOR (animator_get_type ())
#define ANIMATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR, Animator))
#define ANIMATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR, AnimatorClass))
#define IS_ANIMATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR))
#define IS_ANIMATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR))
#define ANIMATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR, AnimatorClass))

typedef struct _Animator Animator;
typedef struct _AnimatorClass AnimatorClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoNodeMove {
	UndoItem parent_instance;
	UndoNodeMovePrivate * priv;
};

struct _UndoNodeMoveClass {
	UndoItemClass parent_class;
};

struct _UndoNodeMovePrivate {
	Node* _n;
	NodeSide _old_side;
	gint _old_index;
	SummaryNode* _old_summary;
	NodeSide _new_side;
	gint _new_index;
	SummaryNode* _new_summary;
};

static gint UndoNodeMove_private_offset;
static gpointer undo_node_move_parent_class = NULL;

VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_node_move_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoNodeMove, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType summary_node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SummaryNode, g_object_unref)
VALA_EXTERN void undo_item_undo (UndoItem* self,
                     DrawArea* da);
VALA_EXTERN void undo_item_redo (UndoItem* self,
                     DrawArea* da);
VALA_EXTERN UndoNodeMove* undo_node_move_new (Node* n,
                                  NodeSide old_side,
                                  gint old_index,
                                  SummaryNode* old_summary);
VALA_EXTERN UndoNodeMove* undo_node_move_construct (GType object_type,
                                        Node* n,
                                        NodeSide old_side,
                                        gint old_index,
                                        SummaryNode* old_summary);
VALA_EXTERN UndoItem* undo_item_new (const gchar* name);
VALA_EXTERN UndoItem* undo_item_construct (GType object_type,
                               const gchar* name);
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gint node_index (Node* self);
VALA_EXTERN SummaryNode* node_summary_node (Node* self);
VALA_EXTERN void undo_node_move_change (UndoNodeMove* self,
                            DrawArea* da,
                            NodeSide old_side,
                            SummaryNode* old_summary,
                            NodeSide new_side,
                            gint new_index,
                            SummaryNode* new_summary);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN GType animator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Animator, g_object_unref)
VALA_EXTERN Animator* draw_area_get_animator (DrawArea* self);
VALA_EXTERN void animator_add_nodes (Animator* self,
                         GArray* n,
                         const gchar* name);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN void node_detach (Node* self,
                  NodeSide side);
VALA_EXTERN void summary_node_remove_node (SummaryNode* self,
                               Node* node);
VALA_EXTERN void node_set_side (Node* self,
                    NodeSide value);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN void layout_propagate_side (Layout* self,
                            Node* parent,
                            NodeSide side);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void node_attach (Node* self,
                  Node* parent,
                  gint index,
                  Theme* theme,
                  gboolean set_side);
VALA_EXTERN void summary_node_add_node (SummaryNode* self,
                            Node* node);
VALA_EXTERN void animator_animate (Animator* self);
static void undo_node_move_real_undo (UndoItem* base,
                               DrawArea* da);
static void undo_node_move_real_redo (UndoItem* base,
                               DrawArea* da);
static void undo_node_move_finalize (GObject * obj);
static GType undo_node_move_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_node_move_get_instance_private (UndoNodeMove* self)
{
	return G_STRUCT_MEMBER_P (self, UndoNodeMove_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

UndoNodeMove*
undo_node_move_construct (GType object_type,
                          Node* n,
                          NodeSide old_side,
                          gint old_index,
                          SummaryNode* old_summary)
{
	UndoNodeMove * self = NULL;
	Node* _tmp0_;
	SummaryNode* _tmp1_;
	NodeSide _tmp2_;
	NodeSide _tmp3_;
	SummaryNode* _tmp4_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (UndoNodeMove*) undo_item_construct (object_type, _ ("move node"));
	_tmp0_ = _g_object_ref0 (n);
	_g_object_unref0 (self->priv->_n);
	self->priv->_n = _tmp0_;
	self->priv->_old_side = old_side;
	self->priv->_old_index = old_index;
	_tmp1_ = _g_object_ref0 (old_summary);
	_g_object_unref0 (self->priv->_old_summary);
	self->priv->_old_summary = _tmp1_;
	_tmp2_ = node_get_side (n);
	_tmp3_ = _tmp2_;
	self->priv->_new_side = _tmp3_;
	self->priv->_new_index = node_index (n);
	_tmp4_ = node_summary_node (n);
	_g_object_unref0 (self->priv->_new_summary);
	self->priv->_new_summary = _tmp4_;
	return self;
}

UndoNodeMove*
undo_node_move_new (Node* n,
                    NodeSide old_side,
                    gint old_index,
                    SummaryNode* old_summary)
{
	return undo_node_move_construct (TYPE_UNDO_NODE_MOVE, n, old_side, old_index, old_summary);
}

void
undo_node_move_change (UndoNodeMove* self,
                       DrawArea* da,
                       NodeSide old_side,
                       SummaryNode* old_summary,
                       NodeSide new_side,
                       gint new_index,
                       SummaryNode* new_summary)
{
	Node* parent = NULL;
	Node* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	Node* _tmp3_;
	Animator* _tmp4_;
	Animator* _tmp5_;
	GArray* _tmp6_;
	GArray* _tmp7_;
	Node* _tmp8_;
	Node* _tmp10_;
	Node* _tmp11_;
	Layout* _tmp12_;
	Layout* _tmp13_;
	Node* _tmp14_;
	Node* _tmp15_;
	Node* _tmp16_;
	Animator* _tmp18_;
	Animator* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_n;
	_tmp1_ = node_get_parent (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = draw_area_get_animator (da);
	_tmp5_ = _tmp4_;
	_tmp6_ = draw_area_get_nodes (da);
	_tmp7_ = _tmp6_;
	animator_add_nodes (_tmp5_, _tmp7_, "undo move");
	_g_array_unref0 (_tmp7_);
	_tmp8_ = self->priv->_n;
	node_detach (_tmp8_, old_side);
	if (old_summary != NULL) {
		Node* _tmp9_;
		_tmp9_ = self->priv->_n;
		summary_node_remove_node (old_summary, _tmp9_);
	}
	_tmp10_ = self->priv->_n;
	node_set_side (_tmp10_, new_side);
	_tmp11_ = self->priv->_n;
	_tmp12_ = node_get_layout (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_n;
	layout_propagate_side (_tmp13_, _tmp14_, new_side);
	_tmp15_ = self->priv->_n;
	_tmp16_ = parent;
	node_attach (_tmp15_, _tmp16_, new_index, NULL, FALSE);
	if (new_summary != NULL) {
		Node* _tmp17_;
		_tmp17_ = self->priv->_n;
		summary_node_add_node (new_summary, _tmp17_);
	}
	_tmp18_ = draw_area_get_animator (da);
	_tmp19_ = _tmp18_;
	animator_animate (_tmp19_);
	_g_object_unref0 (parent);
}

static void
undo_node_move_real_undo (UndoItem* base,
                          DrawArea* da)
{
	UndoNodeMove * self;
	SummaryNode* _tmp0_;
	SummaryNode* _tmp1_;
	self = (UndoNodeMove*) base;
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_new_summary;
	_tmp1_ = self->priv->_old_summary;
	undo_node_move_change (self, da, self->priv->_new_side, _tmp0_, self->priv->_old_side, self->priv->_old_index, _tmp1_);
}

static void
undo_node_move_real_redo (UndoItem* base,
                          DrawArea* da)
{
	UndoNodeMove * self;
	SummaryNode* _tmp0_;
	SummaryNode* _tmp1_;
	self = (UndoNodeMove*) base;
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_old_summary;
	_tmp1_ = self->priv->_new_summary;
	undo_node_move_change (self, da, self->priv->_old_side, _tmp0_, self->priv->_new_side, self->priv->_new_index, _tmp1_);
}

static void
undo_node_move_class_init (UndoNodeMoveClass * klass,
                           gpointer klass_data)
{
	undo_node_move_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoNodeMove_private_offset);
	((UndoItemClass *) klass)->undo = (void (*) (UndoItem*, DrawArea*)) undo_node_move_real_undo;
	((UndoItemClass *) klass)->redo = (void (*) (UndoItem*, DrawArea*)) undo_node_move_real_redo;
	G_OBJECT_CLASS (klass)->finalize = undo_node_move_finalize;
}

static void
undo_node_move_instance_init (UndoNodeMove * self,
                              gpointer klass)
{
	self->priv = undo_node_move_get_instance_private (self);
}

static void
undo_node_move_finalize (GObject * obj)
{
	UndoNodeMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_NODE_MOVE, UndoNodeMove);
	_g_object_unref0 (self->priv->_n);
	_g_object_unref0 (self->priv->_old_summary);
	_g_object_unref0 (self->priv->_new_summary);
	G_OBJECT_CLASS (undo_node_move_parent_class)->finalize (obj);
}

static GType
undo_node_move_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoNodeMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_node_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoNodeMove), 0, (GInstanceInitFunc) undo_node_move_instance_init, NULL };
	GType undo_node_move_type_id;
	undo_node_move_type_id = g_type_register_static (TYPE_UNDO_ITEM, "UndoNodeMove", &g_define_type_info, 0);
	UndoNodeMove_private_offset = g_type_add_instance_private (undo_node_move_type_id, sizeof (UndoNodeMovePrivate));
	return undo_node_move_type_id;
}

GType
undo_node_move_get_type (void)
{
	static volatile gsize undo_node_move_type_id__once = 0;
	if (g_once_init_enter (&undo_node_move_type_id__once)) {
		GType undo_node_move_type_id;
		undo_node_move_type_id = undo_node_move_get_type_once ();
		g_once_init_leave (&undo_node_move_type_id__once, undo_node_move_type_id);
	}
	return undo_node_move_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

