/* Exporter.c generated by valac 0.56.18, the Vala compiler
 * generated from Exporter.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
typedef struct _ExporterPrivate ExporterPrivate;
enum  {
	EXPORTER_0_PROPERTY,
	EXPORTER_NUM_PROPERTIES
};
static GParamSpec* exporter_properties[EXPORTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block20Data Block20Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;

#define TYPE_EXPORTS (exports_get_type ())
#define EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTS, Exports))
#define EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTS, ExportsClass))
#define IS_EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTS))
#define IS_EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTS))
#define EXPORTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTS, ExportsClass))

typedef struct _Exports Exports;
typedef struct _ExportsClass ExportsClass;
#define _export_unref0(var) ((var == NULL) ? NULL : (var = (export_unref (var), NULL)))
typedef struct _Block21Data Block21Data;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
enum  {
	EXPORTER_EXPORT_DONE_SIGNAL,
	EXPORTER_NUM_SIGNALS
};
static guint exporter_signals[EXPORTER_NUM_SIGNALS] = {0};

struct _Exporter {
	GtkBox parent_instance;
	ExporterPrivate * priv;
};

struct _ExporterClass {
	GtkBoxClass parent_class;
};

struct _ExporterPrivate {
	GtkMenuButton* _mb;
	GtkRevealer* _stack_reveal;
	GtkStack* _stack;
};

struct _Block20Data {
	int _ref_count_;
	Exporter* self;
	MainWindow* win;
};

struct _Block21Data {
	int _ref_count_;
	Exporter* self;
	MainWindow* win;
	Export* export;
};

static gint Exporter_private_offset;
static gpointer exporter_parent_class = NULL;

VALA_EXTERN GType exporter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exporter, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN Exporter* exporter_new (MainWindow* win);
VALA_EXTERN Exporter* exporter_construct (GType object_type,
                              MainWindow* win);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN gchar* utils_tooltip_with_accel (const gchar* tooltip,
                                 const gchar* accel);
static void __lambda160_ (Block20Data* _data20_);
VALA_EXTERN void exporter_do_export (Exporter* self,
                         MainWindow* win);
static void ___lambda160__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void exporter_populate (Exporter* self,
                        MainWindow* win);
VALA_EXTERN GSettings* main_window_get_settings (MainWindow* self);
VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN gpointer exports_ref (gpointer instance);
VALA_EXTERN void exports_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exports (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_exports (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_exports (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_exports (const GValue* value);
VALA_EXTERN GType exports_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exports, exports_unref)
VALA_EXTERN Exports* main_window_get_exports (MainWindow* self);
VALA_EXTERN Export* exports_get_by_name (Exports* self,
                             const gchar* name);
static void exporter_handle_mb_change (Exporter* self,
                                MainWindow* win,
                                Export* export);
VALA_EXTERN gint exports_length (Exports* self);
VALA_EXTERN Export* exports_index (Exports* self,
                       gint idx);
VALA_EXTERN gboolean export_get_exportable (Export* self);
static void exporter_add_export (Exporter* self,
                          MainWindow* win,
                          Export* export);
VALA_EXTERN const gchar* export_get_label (Export* self);
VALA_EXTERN const gchar* export_get_name (Export* self);
VALA_EXTERN gboolean export_settings_available (Export* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void __lambda161_ (Block21Data* _data21_);
static void ___lambda161__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void utils_set_chooser_folder (GtkFileChooser* chooser);
VALA_EXTERN gchar* utils_rootname (const gchar* filename);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN DrawArea* main_window_get_current_da (MainWindow* self,
                                      const gchar* caller);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* draw_area_get_doc (DrawArea* self);
VALA_EXTERN const gchar* document_get_filename (Document* self);
VALA_EXTERN gchar* main_window_repair_filename (MainWindow* self,
                                    const gchar* fname,
                                    gchar** extensions,
                                    gint extensions_length1);
VALA_EXTERN gchar** export_get_extensions (Export* self,
                               gint* result_length1);
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN void utils_store_chooser_folder (const gchar* file,
                                 gboolean is_dir);
VALA_EXTERN void main_window_notification (MainWindow* self,
                               const gchar* title,
                               const gchar* msg,
                               GNotificationPriority priority);
static void exporter_finalize (GObject * obj);
static GType exporter_get_type_once (void);

static inline gpointer
exporter_get_instance_private (Exporter* self)
{
	return G_STRUCT_MEMBER_P (self, Exporter_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		Exporter* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->win);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
__lambda160_ (Block20Data* _data20_)
{
	Exporter* self;
	self = _data20_->self;
	exporter_do_export (self, _data20_->win);
	g_signal_emit (self, exporter_signals[EXPORTER_EXPORT_DONE_SIGNAL], 0);
}

static void
___lambda160__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda160_ (self);
}

Exporter*
exporter_construct (GType object_type,
                    MainWindow* win)
{
	Exporter * self = NULL;
	Block20Data* _data20_;
	MainWindow* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkMenuButton* _tmp2_;
	GtkMenu* _tmp3_;
	GtkMenu* _tmp4_;
	GtkMenuButton* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkMenuButton* _tmp8_;
	GtkMenuButton* _tmp9_;
	GtkButton* export = NULL;
	GtkButton* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkBox* bbox = NULL;
	GtkBox* _tmp13_;
	GtkMenuButton* _tmp14_;
	GtkStack* _tmp15_;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	GtkStack* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkRevealer* _tmp20_;
	GtkStack* _tmp21_;
	GtkMenuButton* _tmp22_;
	GtkMenu* _tmp23_;
	GtkMenu* _tmp24_;
	GtkRevealer* _tmp25_;
	gchar* last = NULL;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	gchar* _tmp28_;
	Export* current = NULL;
	Exports* _tmp29_;
	Exports* _tmp30_;
	Export* _tmp31_;
	g_return_val_if_fail (win != NULL, NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (_data20_->win);
	_data20_->win = _tmp0_;
	self = (Exporter*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_data20_->self = g_object_ref (self);
	_tmp1_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_mb);
	self->priv->_mb = _tmp1_;
	_tmp2_ = self->priv->_mb;
	_tmp3_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_menu_button_set_popup (_tmp2_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_mb;
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_button_set_image ((GtkButton*) _tmp5_, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->_mb;
	gtk_button_set_image_position ((GtkButton*) _tmp8_, GTK_POS_RIGHT);
	_tmp9_ = self->priv->_mb;
	gtk_button_set_always_show_image ((GtkButton*) _tmp9_, TRUE);
	_tmp10_ = (GtkButton*) gtk_button_new_with_label (_ ("Export…"));
	g_object_ref_sink (_tmp10_);
	export = _tmp10_;
	_tmp11_ = utils_tooltip_with_accel (_ ("Export With Current Settings"), "<Control>e");
	_tmp12_ = _tmp11_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) export, _tmp12_);
	_g_free0 (_tmp12_);
	g_signal_connect_data (export, "clicked", (GCallback) ___lambda160__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp13_);
	bbox = _tmp13_;
	_tmp14_ = self->priv->_mb;
	gtk_box_pack_start (bbox, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	gtk_box_pack_end (bbox, (GtkWidget*) export, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->_stack);
	self->priv->_stack = _tmp15_;
	_tmp16_ = self->priv->_stack;
	gtk_stack_set_transition_type (_tmp16_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp17_ = self->priv->_stack;
	gtk_stack_set_hhomogeneous (_tmp17_, TRUE);
	_tmp18_ = self->priv->_stack;
	gtk_stack_set_vhomogeneous (_tmp18_, FALSE);
	_tmp19_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->_stack_reveal);
	self->priv->_stack_reveal = _tmp19_;
	_tmp20_ = self->priv->_stack_reveal;
	_tmp21_ = self->priv->_stack;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	exporter_populate (self, _data20_->win);
	_tmp22_ = self->priv->_mb;
	_tmp23_ = gtk_menu_button_get_popup (_tmp22_);
	_tmp24_ = _tmp23_;
	gtk_widget_show_all ((GtkWidget*) _tmp24_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) bbox, FALSE, TRUE, (guint) 0);
	_tmp25_ = self->priv->_stack_reveal;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp25_, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp26_ = main_window_get_settings (_data20_->win);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_settings_get_string (_tmp27_, "last-export");
	last = _tmp28_;
	_tmp29_ = main_window_get_exports (_data20_->win);
	_tmp30_ = _tmp29_;
	_tmp31_ = exports_get_by_name (_tmp30_, last);
	current = _tmp31_;
	exporter_handle_mb_change (self, _data20_->win, current);
	_export_unref0 (current);
	_g_free0 (last);
	_g_object_unref0 (bbox);
	_g_object_unref0 (export);
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return self;
}

Exporter*
exporter_new (MainWindow* win)
{
	return exporter_construct (TYPE_EXPORTER, win);
}

static void
exporter_populate (Exporter* self,
                   MainWindow* win)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Exports* _tmp2_;
				Exports* _tmp3_;
				Exports* _tmp4_;
				Exports* _tmp5_;
				Export* _tmp6_;
				Export* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = main_window_get_exports (win);
				_tmp3_ = _tmp2_;
				if (!(i < exports_length (_tmp3_))) {
					break;
				}
				_tmp4_ = main_window_get_exports (win);
				_tmp5_ = _tmp4_;
				_tmp6_ = exports_index (_tmp5_, i);
				_tmp7_ = _tmp6_;
				_tmp8_ = export_get_exportable (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_export_unref0 (_tmp7_);
				if (_tmp10_) {
					Exports* _tmp11_;
					Exports* _tmp12_;
					Export* _tmp13_;
					Export* _tmp14_;
					_tmp11_ = main_window_get_exports (win);
					_tmp12_ = _tmp11_;
					_tmp13_ = exports_index (_tmp12_, i);
					_tmp14_ = _tmp13_;
					exporter_add_export (self, win, _tmp14_);
					_export_unref0 (_tmp14_);
				}
			}
		}
	}
}

static void
exporter_handle_mb_change (Exporter* self,
                           MainWindow* win,
                           Export* export)
{
	GtkMenuButton* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkStack* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkRevealer* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	g_return_if_fail (export != NULL);
	_tmp0_ = self->priv->_mb;
	_tmp1_ = export_get_label (export);
	_tmp2_ = _tmp1_;
	gtk_button_set_label ((GtkButton*) _tmp0_, _tmp2_);
	_tmp3_ = self->priv->_stack;
	_tmp4_ = export_get_name (export);
	_tmp5_ = _tmp4_;
	gtk_stack_set_visible_child_name (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->_stack_reveal;
	gtk_revealer_set_reveal_child (_tmp6_, export_settings_available (export));
	_tmp7_ = main_window_get_settings (win);
	_tmp8_ = _tmp7_;
	_tmp9_ = export_get_name (export);
	_tmp10_ = _tmp9_;
	g_settings_set_string (_tmp8_, "last-export", _tmp10_);
}

static gpointer
_export_ref0 (gpointer self)
{
	return self ? export_ref (self) : NULL;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		Exporter* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->win);
		_export_unref0 (_data21_->export);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
__lambda161_ (Block21Data* _data21_)
{
	Exporter* self;
	self = _data21_->self;
	exporter_handle_mb_change (self, _data21_->win, _data21_->export);
}

static void
___lambda161__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	__lambda161_ (self);
}

static void
exporter_add_export (Exporter* self,
                     MainWindow* win,
                     Export* export)
{
	Block21Data* _data21_;
	MainWindow* _tmp0_;
	Export* _tmp1_;
	GtkMenuItem* mnu = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenuButton* _tmp5_;
	GtkMenu* _tmp6_;
	GtkMenu* _tmp7_;
	GtkGrid* opts = NULL;
	GtkGrid* _tmp8_;
	GtkLabel* label = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp15_;
	GtkStack* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	g_return_if_fail (export != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (win);
	_g_object_unref0 (_data21_->win);
	_data21_->win = _tmp0_;
	_tmp1_ = _export_ref0 (export);
	_export_unref0 (_data21_->export);
	_data21_->export = _tmp1_;
	_tmp2_ = export_get_label (_data21_->export);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp3_);
	g_object_ref_sink (_tmp4_);
	mnu = _tmp4_;
	g_signal_connect_data (mnu, "activate", (GCallback) ___lambda161__gtk_menu_item_activate, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
	_tmp5_ = self->priv->_mb;
	_tmp6_ = gtk_menu_button_get_popup (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) mnu);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	opts = _tmp8_;
	g_object_set ((GtkWidget*) opts, "margin", 5, NULL);
	gtk_grid_set_column_homogeneous (opts, TRUE);
	gtk_grid_set_row_spacing (opts, 5);
	gtk_grid_set_column_spacing (opts, 5);
	g_object_set ((GtkWidget*) opts, "expand", TRUE, NULL);
	export_add_settings (_data21_->export, opts);
	_tmp9_ = g_strconcat ("<i>", _ ("Export Options"), NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, "</i>", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	label = _tmp14_;
	gtk_label_set_use_markup (label, TRUE);
	_tmp15_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp15_);
	frame = _tmp15_;
	gtk_frame_set_label_widget (frame, (GtkWidget*) label);
	g_object_set (frame, "label-xalign", (gfloat) 0.5, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) frame, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) frame, 5);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) opts);
	_tmp16_ = self->priv->_stack;
	_tmp17_ = export_get_name (_data21_->export);
	_tmp18_ = _tmp17_;
	gtk_stack_add_named (_tmp16_, (GtkWidget*) frame, _tmp18_);
	_g_object_unref0 (frame);
	_g_object_unref0 (label);
	_g_object_unref0 (opts);
	_g_object_unref0 (mnu);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

void
exporter_do_export (Exporter* self,
                    MainWindow* win)
{
	gchar* name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	Export* export = NULL;
	Exports* _tmp4_;
	Exports* _tmp5_;
	const gchar* _tmp6_;
	Export* _tmp7_;
	GtkFileChooserDialog* dialog = NULL;
	Export* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	GtkFileChooserDialog* _tmp14_;
	GtkFileChooserDialog* _tmp15_;
	gchar* default_fname = NULL;
	DrawArea* _tmp16_;
	DrawArea* _tmp17_;
	Document* _tmp18_;
	Document* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkFileChooserDialog* _tmp24_;
	const gchar* _tmp25_;
	Export* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_ = 0;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp32_;
	GtkFileFilter* _tmp33_;
	Export* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	Export* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_ = 0;
	gchar** _tmp40_;
	gint _tmp40__length1;
	GtkFileChooserDialog* _tmp46_;
	GtkFileFilter* _tmp47_;
	GtkFileChooserDialog* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_tmp0_ = self->priv->_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = main_window_get_exports (win);
	_tmp5_ = _tmp4_;
	_tmp6_ = name;
	_tmp7_ = exports_get_by_name (_tmp5_, _tmp6_);
	export = _tmp7_;
	_tmp8_ = export;
	_tmp9_ = export_get_label (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (_ ("Export As %s"), _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp12_, (GtkWindow*) win, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Cancel"), GTK_RESPONSE_CANCEL, _ ("Export"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	dialog = _tmp14_;
	_tmp15_ = dialog;
	utils_set_chooser_folder ((GtkFileChooser*) _tmp15_);
	_tmp16_ = main_window_get_current_da (win, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = draw_area_get_doc (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = document_get_filename (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = utils_rootname (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp19_);
	_g_object_unref0 (_tmp17_);
	default_fname = _tmp23_;
	_tmp24_ = dialog;
	_tmp25_ = default_fname;
	_tmp26_ = export;
	_tmp27_ = export_get_extensions (_tmp26_, &_tmp28_);
	_tmp27__length1 = _tmp28_;
	_tmp29_ = _tmp27_;
	_tmp29__length1 = _tmp27__length1;
	_tmp30_ = main_window_repair_filename (win, _tmp25_, _tmp29_, (gint) _tmp29__length1);
	_tmp31_ = _tmp30_;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp24_, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp32_);
	filter = _tmp32_;
	_tmp33_ = filter;
	_tmp34_ = export;
	_tmp35_ = export_get_label (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_file_filter_set_name (_tmp33_, _tmp36_);
	_tmp37_ = export;
	_tmp38_ = export_get_extensions (_tmp37_, &_tmp39_);
	_tmp38__length1 = _tmp39_;
	_tmp40_ = _tmp38_;
	_tmp40__length1 = _tmp38__length1;
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = _tmp40_;
		extension_collection_length1 = _tmp40__length1;
		for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
			gchar* _tmp41_;
			gchar* extension = NULL;
			_tmp41_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp41_;
			{
				GtkFileFilter* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp42_ = filter;
				_tmp43_ = extension;
				_tmp44_ = g_strconcat ("*", _tmp43_, NULL);
				_tmp45_ = _tmp44_;
				gtk_file_filter_add_pattern (_tmp42_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (extension);
			}
		}
	}
	_tmp46_ = dialog;
	_tmp47_ = filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp46_, _tmp47_);
	_tmp48_ = dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp48_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp49_;
		gchar* fname = NULL;
		GtkFileChooserDialog* _tmp50_;
		gchar* _tmp51_;
		Export* _tmp52_;
		const gchar* _tmp53_;
		Export* _tmp54_;
		gchar** _tmp55_;
		gint _tmp55__length1;
		gint _tmp56_ = 0;
		gchar** _tmp57_;
		gint _tmp57__length1;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		DrawArea* _tmp60_;
		DrawArea* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		_tmp49_ = dialog;
		g_signal_emit_by_name ((GtkDialog*) _tmp49_, "close");
		_tmp50_ = dialog;
		_tmp51_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp50_);
		fname = _tmp51_;
		_tmp52_ = export;
		_tmp53_ = fname;
		_tmp54_ = export;
		_tmp55_ = export_get_extensions (_tmp54_, &_tmp56_);
		_tmp55__length1 = _tmp56_;
		_tmp57_ = _tmp55_;
		_tmp57__length1 = _tmp55__length1;
		_tmp58_ = main_window_repair_filename (win, _tmp53_, _tmp57_, (gint) _tmp57__length1);
		_g_free0 (fname);
		fname = _tmp58_;
		_tmp59_ = fname;
		_tmp60_ = main_window_get_current_da (win, NULL);
		_tmp61_ = _tmp60_;
		export_export (_tmp52_, _tmp59_, _tmp61_);
		_g_object_unref0 (_tmp61_);
		_tmp62_ = fname;
		utils_store_chooser_folder (_tmp62_, FALSE);
		_tmp63_ = fname;
		main_window_notification (win, _ ("Minder Export Completed"), _tmp63_, G_NOTIFICATION_PRIORITY_NORMAL);
		_g_free0 (fname);
	} else {
		GtkFileChooserDialog* _tmp64_;
		_tmp64_ = dialog;
		g_signal_emit_by_name ((GtkDialog*) _tmp64_, "close");
	}
	_g_object_unref0 (filter);
	_g_free0 (default_fname);
	_g_object_unref0 (dialog);
	_export_unref0 (export);
	_g_free0 (name);
}

static void
exporter_class_init (ExporterClass * klass,
                     gpointer klass_data)
{
	exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Exporter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = exporter_finalize;
	exporter_signals[EXPORTER_EXPORT_DONE_SIGNAL] = g_signal_new ("export-done", TYPE_EXPORTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
exporter_instance_init (Exporter * self,
                        gpointer klass)
{
	self->priv = exporter_get_instance_private (self);
}

static void
exporter_finalize (GObject * obj)
{
	Exporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER, Exporter);
	_g_object_unref0 (self->priv->_mb);
	_g_object_unref0 (self->priv->_stack_reveal);
	_g_object_unref0 (self->priv->_stack);
	G_OBJECT_CLASS (exporter_parent_class)->finalize (obj);
}

static GType
exporter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Exporter), 0, (GInstanceInitFunc) exporter_instance_init, NULL };
	GType exporter_type_id;
	exporter_type_id = g_type_register_static (gtk_box_get_type (), "Exporter", &g_define_type_info, 0);
	Exporter_private_offset = g_type_add_instance_private (exporter_type_id, sizeof (ExporterPrivate));
	return exporter_type_id;
}

GType
exporter_get_type (void)
{
	static volatile gsize exporter_type_id__once = 0;
	if (g_once_init_enter (&exporter_type_id__once)) {
		GType exporter_type_id;
		exporter_type_id = exporter_get_type_once ();
		g_once_init_leave (&exporter_type_id__once, exporter_type_id);
	}
	return exporter_type_id__once;
}

