/* util.c generated by valac 0.56.17, the Vala compiler
 * generated from util.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include "libskk/libskk.h"
#include <config.h>
#include <gio/gio.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xkbcommon/xkbcommon.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SKK_TYPE_ENTRY (skk_entry_get_type ())
typedef struct _SkkEntry SkkEntry;
typedef enum  {
	SKK_NUMERIC_CONVERSION_TYPE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL,
	SKK_NUMERIC_CONVERSION_TYPE_KANJI,
	SKK_NUMERIC_CONVERSION_TYPE_RECONVERT,
	SKK_NUMERIC_CONVERSION_TYPE_DAIJI,
	SKK_NUMERIC_CONVERSION_TYPE_SHOGI
} SkkNumericConversionType;

#define SKK_TYPE_NUMERIC_CONVERSION_TYPE (skk_numeric_conversion_type_get_type ())

#define SKK_TYPE_UTIL (skk_util_get_type ())
#define SKK_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_UTIL, SkkUtil))
#define SKK_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_UTIL, SkkUtilClass))
#define SKK_IS_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_UTIL))
#define SKK_IS_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_UTIL))
#define SKK_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_UTIL, SkkUtilClass))

typedef struct _SkkUtil SkkUtil;
typedef struct _SkkUtilClass SkkUtilClass;
typedef struct _SkkUtilPrivate SkkUtilPrivate;
enum  {
	SKK_UTIL_0_PROPERTY,
	SKK_UTIL_NUM_PROPERTIES
};
static GParamSpec* skk_util_properties[SKK_UTIL_NUM_PROPERTIES];

#define SKK_UTIL_TYPE_KANA_TABLE_ENTRY (skk_util_kana_table_entry_get_type ())
typedef struct _SkkUtilKanaTableEntry SkkUtilKanaTableEntry;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;

#define SKK_TYPE_UNICODE_STRING (skk_unicode_string_get_type ())
#define SKK_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeString))
#define SKK_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))
#define SKK_IS_UNICODE_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_UNICODE_STRING))
#define SKK_IS_UNICODE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_UNICODE_STRING))
#define SKK_UNICODE_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_UNICODE_STRING, SkkUnicodeStringClass))

typedef struct _SkkUnicodeString SkkUnicodeString;
typedef struct _SkkUnicodeStringClass SkkUnicodeStringClass;
typedef struct _SkkUnicodeStringPrivate SkkUnicodeStringPrivate;
enum  {
	SKK_UNICODE_STRING_0_PROPERTY,
	SKK_UNICODE_STRING_NUM_PROPERTIES
};
static GParamSpec* skk_unicode_string_properties[SKK_UNICODE_STRING_NUM_PROPERTIES];

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;
typedef struct _SkkMemoryMappedFilePrivate SkkMemoryMappedFilePrivate;
enum  {
	SKK_MEMORY_MAPPED_FILE_0_PROPERTY,
	SKK_MEMORY_MAPPED_FILE_MEMORY_PROPERTY,
	SKK_MEMORY_MAPPED_FILE_LENGTH_PROPERTY,
	SKK_MEMORY_MAPPED_FILE_NUM_PROPERTIES
};
static GParamSpec* skk_memory_mapped_file_properties[SKK_MEMORY_MAPPED_FILE_NUM_PROPERTIES];

#define SKK_TYPE_SKK_DICT_ERROR (skk_skk_dict_error_get_type ())

#define SKK_TYPE_KEY_EVENT_UTILS (skk_key_event_utils_get_type ())
#define SKK_KEY_EVENT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEY_EVENT_UTILS, SkkKeyEventUtils))
#define SKK_KEY_EVENT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEY_EVENT_UTILS, SkkKeyEventUtilsClass))
#define SKK_IS_KEY_EVENT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEY_EVENT_UTILS))
#define SKK_IS_KEY_EVENT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEY_EVENT_UTILS))
#define SKK_KEY_EVENT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEY_EVENT_UTILS, SkkKeyEventUtilsClass))

typedef struct _SkkKeyEventUtils SkkKeyEventUtils;
typedef struct _SkkKeyEventUtilsClass SkkKeyEventUtilsClass;
typedef struct _SkkKeyEventUtilsPrivate SkkKeyEventUtilsPrivate;
enum  {
	SKK_KEY_EVENT_UTILS_0_PROPERTY,
	SKK_KEY_EVENT_UTILS_NUM_PROPERTIES
};
static GParamSpec* skk_key_event_utils_properties[SKK_KEY_EVENT_UTILS_NUM_PROPERTIES];

struct _SkkEntry {
	gpointer key;
	gpointer value;
};

struct _SkkUtil {
	GObject parent_instance;
	SkkUtilPrivate * priv;
};

struct _SkkUtilClass {
	GObjectClass parent_class;
};

struct _SkkUtilKanaTableEntry {
	gunichar katakana;
	gchar* hiragana;
	gchar* hankaku_katakana;
};

struct _Block1Data {
	int _ref_count_;
	GString* builder;
};

struct _Block2Data {
	int _ref_count_;
	GString* builder;
};

struct _Block3Data {
	int _ref_count_;
	GString* builder;
};

struct _SkkUnicodeString {
	GObject parent_instance;
	SkkUnicodeStringPrivate * priv;
	gint length;
};

struct _SkkUnicodeStringClass {
	GObjectClass parent_class;
};

struct _SkkUnicodeStringPrivate {
	gchar* str;
};

struct _SkkMemoryMappedFile {
	GObject parent_instance;
	SkkMemoryMappedFilePrivate * priv;
};

struct _SkkMemoryMappedFileClass {
	GObjectClass parent_class;
};

struct _SkkMemoryMappedFilePrivate {
	void* _memory;
	gsize _length;
	GFile* file;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

struct _SkkKeyEventUtils {
	GObject parent_instance;
	SkkKeyEventUtilsPrivate * priv;
};

struct _SkkKeyEventUtilsClass {
	GObjectClass parent_class;
};

static gpointer skk_util_parent_class = NULL;
static GeeMap* skk_util__HiraganaTable;
static GeeMap* skk_util__HiraganaTable = NULL;
static GeeMap* skk_util__KatakanaTable;
static GeeMap* skk_util__KatakanaTable = NULL;
static GeeMap* skk_util__HankakuKatakanaTable;
static GeeMap* skk_util__HankakuKatakanaTable = NULL;
static GeeMap* skk_util__CompositionTable;
static GeeMap* skk_util__CompositionTable = NULL;
static GeeMap* skk_util__WideLatinToLatinTable;
static GeeMap* skk_util__WideLatinToLatinTable = NULL;
static gint SkkUnicodeString_private_offset;
static gpointer skk_unicode_string_parent_class = NULL;
static gint SkkMemoryMappedFile_private_offset;
static gpointer skk_memory_mapped_file_parent_class = NULL;
static gpointer skk_key_event_utils_parent_class = NULL;

VALA_EXTERN GType skk_entry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkEntry* skk_entry_dup (const SkkEntry* self);
VALA_EXTERN void skk_entry_free (SkkEntry* self);
VALA_EXTERN void skk_entry_copy (const SkkEntry* self,
                     SkkEntry* dest);
VALA_EXTERN void skk_entry_destroy (SkkEntry* self);
VALA_EXTERN GType skk_numeric_conversion_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType skk_util_get_type (void) G_GNUC_CONST ;
static GType skk_util_kana_table_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SkkUtilKanaTableEntry* skk_util_kana_table_entry_dup (const SkkUtilKanaTableEntry* self);
static void skk_util_kana_table_entry_free (SkkUtilKanaTableEntry* self);
static void skk_util_kana_table_entry_copy (const SkkUtilKanaTableEntry* self,
                                     SkkUtilKanaTableEntry* dest);
static void skk_util_kana_table_entry_destroy (SkkUtilKanaTableEntry* self);
static gchar* skk_util_get_okurigana_prefix_for_char (gunichar uc);
VALA_EXTERN gchar* skk_util_get_okurigana_prefix (const gchar* okurigana);
VALA_EXTERN gunichar skk_util_get_wide_latin_char (gchar c);
VALA_EXTERN gchar* skk_util_get_wide_latin (const gchar* latin);
static gunichar skk_util_get_katakana_char (gunichar uc);
static void skk_util_foreach_katakana (const gchar* kana,
                                GFunc func,
                                gpointer func_target);
VALA_EXTERN gchar* skk_util_get_katakana (const gchar* kana);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 gunichar uc);
static void ___lambda4__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN gchar* skk_util_get_hiragana (const gchar* kana);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_,
                 gunichar uc);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN gchar* skk_util_get_hankaku_katakana (const gchar* kana);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_,
                 gunichar uc);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN gchar* skk_util_convert_by_input_mode (const gchar* str,
                                       SkkInputMode input_mode);
static gchar* skk_util_get_kanji_numeric (gint numeric,
                                   gchar** num_table,
                                   gint num_table_length1,
                                   gchar** num_pos_table,
                                   gint num_pos_table_length1);
VALA_EXTERN gchar* skk_util_get_numeric (gint numeric,
                             SkkNumericConversionType type);
VALA_EXTERN gchar** skk_util_build_data_path (const gchar* subdir,
                                  gint* result_length1);
VALA_EXTERN SkkUtil* skk_util_new (void);
VALA_EXTERN SkkUtil* skk_util_construct (GType object_type);
static void skk_util_finalize (GObject * obj);
static GType skk_util_get_type_once (void);
VALA_EXTERN GType skk_unicode_string_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkUnicodeString* skk_unicode_string_new (const gchar* str);
VALA_EXTERN SkkUnicodeString* skk_unicode_string_construct (GType object_type,
                                                const gchar* str);
VALA_EXTERN gchar* skk_unicode_string_substring (SkkUnicodeString* self,
                                     glong offset,
                                     glong len);
static void skk_unicode_string_finalize (GObject * obj);
static GType skk_unicode_string_get_type_once (void);
VALA_EXTERN GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
VALA_EXTERN SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type,
                                                       GFile* file);
VALA_EXTERN GQuark skk_skk_dict_error_quark (void);
VALA_EXTERN GType skk_skk_dict_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self,
                                   GError** error);
static void skk_memory_mapped_file_map (SkkMemoryMappedFile* self,
                                 GError** error);
VALA_EXTERN void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
VALA_EXTERN gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self);
static void skk_memory_mapped_file_finalize (GObject * obj);
static GType skk_memory_mapped_file_get_type_once (void);
static void _vala_skk_memory_mapped_file_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
VALA_EXTERN GType skk_key_event_utils_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* skk_key_event_utils_keyval_name (guint keyval);
VALA_EXTERN guint skk_key_event_utils_keyval_from_name (const gchar* name);
VALA_EXTERN gunichar skk_key_event_utils_keyval_unicode (guint keyval);
VALA_EXTERN SkkKeyEventUtils* skk_key_event_utils_construct (GType object_type);
static GType skk_key_event_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const SkkUtilKanaTableEntry SKK_UTIL_KanaTable[96] = {{12450U, "あ", "ｱ"}, {12452U, "い", "ｲ"}, {12454U, "う", "ｳ"}, {12456U, "え", "ｴ"}, {12458U, "お", "ｵ"}, {12459U, "か", "ｶ"}, {12461U, "き", "ｷ"}, {12463U, "く", "ｸ"}, {12465U, "け", "ｹ"}, {12467U, "こ", "ｺ"}, {12469U, "さ", "ｻ"}, {12471U, "し", "ｼ"}, {12473U, "す", "ｽ"}, {12475U, "せ", "ｾ"}, {12477U, "そ", "ｿ"}, {12479U, "た", "ﾀ"}, {12481U, "ち", "ﾁ"}, {12484U, "つ", "ﾂ"}, {12486U, "て", "ﾃ"}, {12488U, "と", "ﾄ"}, {12490U, "な", "ﾅ"}, {12491U, "に", "ﾆ"}, {12492U, "ぬ", "ﾇ"}, {12493U, "ね", "ﾈ"}, {12494U, "の", "ﾉ"}, {12495U, "は", "ﾊ"}, {12498U, "ひ", "ﾋ"}, {12501U, "ふ", "ﾌ"}, {12504U, "へ", "ﾍ"}, {12507U, "ほ", "ﾎ"}, {12510U, "ま", "ﾏ"}, {12511U, "み", "ﾐ"}, {12512U, "む", "ﾑ"}, {12513U, "め", "ﾒ"}, {12514U, "も", "ﾓ"}, {12516U, "や", "ﾔ"}, {12518U, "ゆ", "ﾕ"}, {12520U, "よ", "ﾖ"}, {12521U, "ら", "ﾗ"}, {12522U, "り", "ﾘ"}, {12523U, "る", "ﾙ"}, {12524U, "れ", "ﾚ"}, {12525U, "ろ", "ﾛ"}, {12527U, "わ", "ﾜ"}, {12528U, "ゐ", "ｲ"}, {12529U, "ゑ", "ｴ"}, {12530U, "を", "ｦ"}, {12531U, "ん", "ﾝ"}, {12460U, "が", "ｶﾞ"}, {12462U, "ぎ", "ｷﾞ"}, {12464U, "ぐ", "ｸﾞ"}, {12466U, "げ", "ｹﾞ"}, {12468U, "ご", "ｺﾞ"}, {12470U, "ざ", "ｻﾞ"}, {12472U, "じ", "ｼﾞ"}, {12474U, "ず", "ｽﾞ"}, {12476U, "ぜ", "ｾﾞ"}, {12478U, "ぞ", "ｿﾞ"}, {12480U, "だ", "ﾀﾞ"}, {12482U, "ぢ", "ﾁﾞ"}, {12485U, "づ", "ﾂﾞ"}, {12487U, "で", "ﾃﾞ"}, {12489U, "ど", "ﾄﾞ"}, {12496U, "ば", "ﾊﾞ"}, {12499U, "び", "ﾋﾞ"}, {12502U, "ぶ", "ﾌﾞ"}, {12505U, "べ", "ﾍﾞ"}, {12508U, "ぼ", "ﾎﾞ"}, {12497U, "ぱ", "ﾊﾟ"}, {12500U, "ぴ", "ﾋﾟ"}, {12503U, "ぷ", "ﾌﾟ"}, {12506U, "ぺ", "ﾍﾟ"}, {12509U, "ぽ", "ﾎﾟ"}, {12449U, "ぁ", "ｧ"}, {12451U, "ぃ", "ｨ"}, {12453U, "ぅ", "ｩ"}, {12455U, "ぇ", "ｪ"}, {12457U, "ぉ", "ｫ"}, {12483U, "っ", "ｯ"}, {12515U, "ゃ", "ｬ"}, {12517U, "ゅ", "ｭ"}, {12519U, "ょ", "ｮ"}, {12526U, "ゎ", NULL}, {12532U, "う゛", "ｳﾞ"}, {12533U, "ゕ", NULL}, {12534U, "ゖ", NULL}, {65294U, "．", "."}, {65292U, "，", ","}, {12290U, "。", "｡"}, {12300U, "「", "｢"}, {12301U, "」", "｣"}, {12289U, "、", "､"}, {12539U, "・", "･"}, {12540U, "ー", "ｰ"}, {12443U, "゛", "ﾞ"}, {12444U, "゜", "ﾟ"}};
static const SkkUtilKanaTableEntry SKK_UTIL_HankakuKatakanaSubstitute[3] = {{12526U, NULL, "ﾜ"}, {12533U, NULL, "ｶ"}, {12534U, NULL, "ｹ"}};
static const gchar* SKK_UTIL_WideLatinTable[95] = {"　", "！", "”", "＃", "＄", "％", "＆", "’", "（", "）", "＊", "＋", "，", "−", "．", "／", "０", "１", "２", "３", "４", "５", "６", "７", "８", "９", "：", "；", "＜", "＝", "＞", "？", "＠", "Ａ", "Ｂ", "Ｃ", "Ｄ", "Ｅ", "Ｆ", "Ｇ", "Ｈ", "Ｉ", "Ｊ", "Ｋ", "Ｌ", "Ｍ", "Ｎ", "Ｏ", "Ｐ", "Ｑ", "Ｒ", "Ｓ", "Ｔ", "Ｕ", "Ｖ", "Ｗ", "Ｘ", "Ｙ", "Ｚ", "［", "＼", "］", "＾", "＿", "‘", "ａ", "ｂ", "ｃ", "ｄ", "ｅ", "ｆ", "ｇ", "ｈ", "ｉ", "ｊ", "ｋ", "ｌ", "ｍ", "ｎ", "ｏ", "ｐ", "ｑ", "ｒ", "ｓ", "ｔ", "ｕ", "ｖ", "ｗ", "ｘ", "ｙ", "ｚ", "｛", "｜", "｝", "〜"};
static const gchar* SKK_UTIL_KanaRomTable[83] = {"x", "a", "x", "i", "x", "u", "x", "e", "x", "o", "k", "g", "k", "g", "k", "g", "k", "g", "k", "g", "s", "z", "s", "z", "s", "z", "s", "z", "s", "z", "t", "d", "t", "d", "t", "t", "d", "t", "d", "t", "d", "n", "n", "n", "n", "n", "h", "b", "p", "h", "b", "p", "h", "b", "p", "h", "b", "p", "h", "b", "p", "m", "m", "m", "m", "m", "x", "y", "x", "y", "x", "y", "r", "r", "r", "r", "r", "x", "w", "x", "x", "w", "n"};
static const gchar* SKK_UTIL_KanjiNumericTable[10] = {"〇", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
static const gchar* SKK_UTIL_DaijiNumericTable[10] = {"零", "壱", "弐", "参", "四", "伍", "六", "七", "八", "九"};
static const gchar* SKK_UTIL_KanjiNumericalPositionTable[18] = {NULL, "十", "百", "千", "万", NULL, NULL, NULL, "億", NULL, NULL, NULL, "兆", NULL, NULL, NULL, NULL, "京"};
static const gchar* SKK_UTIL_DaijiNumericalPositionTable[18] = {NULL, "拾", "百", "阡", "萬", NULL, NULL, NULL, "億", NULL, NULL, NULL, "兆", NULL, NULL, NULL, NULL, "京"};

void
skk_entry_copy (const SkkEntry* self,
                SkkEntry* dest)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	(*dest).value = _tmp1_;
}

void
skk_entry_destroy (SkkEntry* self)
{
}

SkkEntry*
skk_entry_dup (const SkkEntry* self)
{
	SkkEntry* dup;
	dup = g_new0 (SkkEntry, 1);
	skk_entry_copy (self, dup);
	return dup;
}

void
skk_entry_free (SkkEntry* self)
{
	skk_entry_destroy (self);
	g_free (self);
}

static GType
skk_entry_get_type_once (void)
{
	GType skk_entry_type_id;
	skk_entry_type_id = g_boxed_type_register_static ("SkkEntry", (GBoxedCopyFunc) skk_entry_dup, (GBoxedFreeFunc) skk_entry_free);
	return skk_entry_type_id;
}

GType
skk_entry_get_type (void)
{
	static volatile gsize skk_entry_type_id__once = 0;
	if (g_once_init_enter (&skk_entry_type_id__once)) {
		GType skk_entry_type_id;
		skk_entry_type_id = skk_entry_get_type_once ();
		g_once_init_leave (&skk_entry_type_id__once, skk_entry_type_id);
	}
	return skk_entry_type_id__once;
}

static GType
skk_numeric_conversion_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SKK_NUMERIC_CONVERSION_TYPE_LATIN, "SKK_NUMERIC_CONVERSION_TYPE_LATIN", "latin"}, {SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN, "SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN", "wide-latin"}, {SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL, "SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL", "kanji-numeral"}, {SKK_NUMERIC_CONVERSION_TYPE_KANJI, "SKK_NUMERIC_CONVERSION_TYPE_KANJI", "kanji"}, {SKK_NUMERIC_CONVERSION_TYPE_RECONVERT, "SKK_NUMERIC_CONVERSION_TYPE_RECONVERT", "reconvert"}, {SKK_NUMERIC_CONVERSION_TYPE_DAIJI, "SKK_NUMERIC_CONVERSION_TYPE_DAIJI", "daiji"}, {SKK_NUMERIC_CONVERSION_TYPE_SHOGI, "SKK_NUMERIC_CONVERSION_TYPE_SHOGI", "shogi"}, {0, NULL, NULL}};
	GType skk_numeric_conversion_type_type_id;
	skk_numeric_conversion_type_type_id = g_enum_register_static ("SkkNumericConversionType", values);
	return skk_numeric_conversion_type_type_id;
}

GType
skk_numeric_conversion_type_get_type (void)
{
	static volatile gsize skk_numeric_conversion_type_type_id__once = 0;
	if (g_once_init_enter (&skk_numeric_conversion_type_type_id__once)) {
		GType skk_numeric_conversion_type_type_id;
		skk_numeric_conversion_type_type_id = skk_numeric_conversion_type_get_type_once ();
		g_once_init_leave (&skk_numeric_conversion_type_type_id__once, skk_numeric_conversion_type_type_id);
	}
	return skk_numeric_conversion_type_type_id__once;
}

static gchar*
skk_util_get_okurigana_prefix_for_char (gunichar uc)
{
	gchar* result;
	if (uc == 12435U) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("n");
		result = _tmp0_;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (uc < 12353U) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = uc > 12435U;
		}
		if (_tmp1_) {
			result = NULL;
			return result;
		} else {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = SKK_UTIL_KanaRomTable[uc - 12353U];
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gchar*
skk_util_get_okurigana_prefix (const gchar* okurigana)
{
	gunichar head = 0U;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (okurigana != NULL, NULL);
	head = string_get_char (okurigana, (glong) 0);
	if (head == 12387U) {
		_tmp0_ = g_strcmp0 (okurigana, "っ") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint index = 0;
		index = string_index_of_nth_char (okurigana, (glong) 1);
		head = string_get_char (okurigana, (glong) index);
	}
	_tmp1_ = skk_util_get_okurigana_prefix_for_char (head);
	result = _tmp1_;
	return result;
}

gunichar
skk_util_get_wide_latin_char (gchar c)
{
	const gchar* _tmp0_;
	gunichar result;
	_tmp0_ = SKK_UTIL_WideLatinTable[c - 32];
	result = string_get_char (_tmp0_, (glong) 0);
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gchar*
skk_util_get_wide_latin (const gchar* latin)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gint index = 0;
	gunichar uc = 0U;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (latin != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	index = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = string_get_next_char (latin, &index, &_tmp1_);
		uc = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		if (((gunichar) 0x20) <= uc) {
			_tmp3_ = uc <= ((gunichar) 0x7E);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GString* _tmp4_;
			_tmp4_ = builder;
			g_string_append_unichar (_tmp4_, skk_util_get_wide_latin_char ((gchar) uc));
		} else {
			GString* _tmp5_;
			_tmp5_ = builder;
			g_string_append_unichar (_tmp5_, uc);
		}
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_string_free0 (builder);
	return result;
}

static gunichar
skk_util_get_katakana_char (gunichar uc)
{
	GeeMap* _tmp0_;
	gunichar result;
	_tmp0_ = skk_util__KatakanaTable;
	if (gee_map_has_key (_tmp0_, (gpointer) ((gintptr) uc))) {
		GeeMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = skk_util__KatakanaTable;
		_tmp2_ = gee_map_get (_tmp1_, (gpointer) ((gintptr) uc));
		result = (gunichar) ((gintptr) _tmp2_);
		return result;
	}
	result = uc;
	return result;
}

static void
skk_util_foreach_katakana (const gchar* kana,
                           GFunc func,
                           gpointer func_target)
{
	gint index = 0;
	gunichar uc0 = 0U;
	g_return_if_fail (kana != NULL);
	index = 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		GeeMap* _tmp2_;
		_tmp1_ = string_get_next_char (kana, &index, &_tmp0_);
		uc0 = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = skk_util__CompositionTable;
		if (gee_map_has_key (_tmp2_, (gpointer) ((gintptr) uc0))) {
			GeeMap* composition = NULL;
			GeeMap* _tmp3_;
			gpointer _tmp4_;
			gunichar uc1 = 0U;
			gunichar _tmp5_ = 0U;
			gboolean _tmp6_;
			_tmp3_ = skk_util__CompositionTable;
			_tmp4_ = gee_map_get (_tmp3_, (gpointer) ((gintptr) uc0));
			composition = (GeeMap*) _tmp4_;
			_tmp6_ = string_get_next_char (kana, &index, &_tmp5_);
			uc1 = _tmp5_;
			if (_tmp6_) {
				GeeMap* _tmp7_;
				_tmp7_ = composition;
				if (gee_map_has_key (_tmp7_, (gpointer) ((gintptr) uc1))) {
					GeeMap* _tmp8_;
					gpointer _tmp9_;
					_tmp8_ = composition;
					_tmp9_ = gee_map_get (_tmp8_, (gpointer) ((gintptr) uc1));
					func ((gpointer) ((gintptr) _tmp9_), func_target);
				} else {
					func ((gpointer) ((gintptr) skk_util_get_katakana_char (uc0)), func_target);
					func ((gpointer) ((gintptr) skk_util_get_katakana_char (uc1)), func_target);
				}
			} else {
				func ((gpointer) ((gintptr) skk_util_get_katakana_char (uc0)), func_target);
				_g_object_unref0 (composition);
				break;
			}
			_g_object_unref0 (composition);
		} else {
			func ((gpointer) ((gintptr) skk_util_get_katakana_char (uc0)), func_target);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_string_free0 (_data1_->builder);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            gunichar uc)
{
	g_string_append_unichar (_data1_->builder, uc);
}

static void
___lambda4__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda4_ (self, (gunichar) ((gintptr) data));
}

gchar*
skk_util_get_katakana (const gchar* kana)
{
	Block1Data* _data1_;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (kana != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data1_->builder = _tmp0_;
	skk_util_foreach_katakana (kana, ___lambda4__gfunc, _data1_);
	_tmp1_ = _data1_->builder->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_string_free0 (_data2_->builder);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda5_ (Block2Data* _data2_,
            gunichar uc)
{
	GeeMap* _tmp0_;
	_tmp0_ = skk_util__HiraganaTable;
	if (gee_map_has_key (_tmp0_, (gpointer) ((gintptr) uc))) {
		GeeMap* _tmp1_;
		gpointer _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = skk_util__HiraganaTable;
		_tmp2_ = gee_map_get (_tmp1_, (gpointer) ((gintptr) uc));
		_tmp3_ = (gchar*) _tmp2_;
		g_string_append (_data2_->builder, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		g_string_append_unichar (_data2_->builder, uc);
	}
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (gunichar) ((gintptr) data));
}

gchar*
skk_util_get_hiragana (const gchar* kana)
{
	Block2Data* _data2_;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (kana != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data2_->builder = _tmp0_;
	skk_util_foreach_katakana (kana, ___lambda5__gfunc, _data2_);
	_tmp1_ = _data2_->builder->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_string_free0 (_data3_->builder);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda6_ (Block3Data* _data3_,
            gunichar uc)
{
	GeeMap* _tmp0_;
	_tmp0_ = skk_util__HankakuKatakanaTable;
	if (gee_map_has_key (_tmp0_, (gpointer) ((gintptr) uc))) {
		GeeMap* _tmp1_;
		gpointer _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = skk_util__HankakuKatakanaTable;
		_tmp2_ = gee_map_get (_tmp1_, (gpointer) ((gintptr) uc));
		_tmp3_ = (gchar*) _tmp2_;
		g_string_append (_data3_->builder, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		g_string_append_unichar (_data3_->builder, uc);
	}
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (gunichar) ((gintptr) data));
}

gchar*
skk_util_get_hankaku_katakana (const gchar* kana)
{
	Block3Data* _data3_;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (kana != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data3_->builder = _tmp0_;
	skk_util_foreach_katakana (kana, ___lambda6__gfunc, _data3_);
	_tmp1_ = _data3_->builder->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

gchar*
skk_util_convert_by_input_mode (const gchar* str,
                                SkkInputMode input_mode)
{
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	switch (input_mode) {
		case SKK_INPUT_MODE_HIRAGANA:
		{
			gchar* _tmp0_;
			_tmp0_ = skk_util_get_hiragana (str);
			result = _tmp0_;
			return result;
		}
		case SKK_INPUT_MODE_KATAKANA:
		{
			gchar* _tmp1_;
			_tmp1_ = skk_util_get_katakana (str);
			result = _tmp1_;
			return result;
		}
		case SKK_INPUT_MODE_HANKAKU_KATAKANA:
		{
			gchar* _tmp2_;
			_tmp2_ = skk_util_get_hankaku_katakana (str);
			result = _tmp2_;
			return result;
		}
		case SKK_INPUT_MODE_WIDE_LATIN:
		{
			gchar* _tmp3_;
			_tmp3_ = skk_util_get_wide_latin (str);
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (str);
			result = _tmp4_;
			return result;
		}
	}
}

static gchar*
skk_util_get_kanji_numeric (gint numeric,
                            gchar** num_table,
                            gint num_table_length1,
                            gchar** num_pos_table,
                            gint num_pos_table_length1)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* str = NULL;
	gchar* _tmp1_;
	gunichar uc = 0U;
	gchar* result;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = g_strdup_printf ("%i", numeric);
	str = _tmp1_;
	if (num_pos_table == NULL) {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					const gchar* _tmp3_;
					gunichar _tmp4_ = 0U;
					gboolean _tmp5_;
					GString* _tmp6_;
					const gchar* _tmp7_;
					if (!_tmp2_) {
					}
					_tmp2_ = FALSE;
					_tmp3_ = str;
					_tmp5_ = string_get_next_char (_tmp3_, &index, &_tmp4_);
					uc = _tmp4_;
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = builder;
					_tmp7_ = num_table[uc - '0'];
					g_string_append (_tmp6_, _tmp7_);
				}
			}
		}
		_tmp8_ = builder;
		_tmp9_ = _tmp8_->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_free0 (str);
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					const gchar* _tmp12_;
					gunichar _tmp13_ = 0U;
					gboolean _tmp14_;
					if (!_tmp11_) {
					}
					_tmp11_ = FALSE;
					_tmp12_ = str;
					_tmp14_ = string_get_next_char (_tmp12_, &index, &_tmp13_);
					uc = _tmp13_;
					if (!_tmp14_) {
						break;
					}
					if (uc > ((gunichar) '0')) {
						gint pos_index = 0;
						const gchar* _tmp15_;
						gint _tmp16_;
						gint _tmp17_;
						gboolean _tmp18_ = FALSE;
						gchar* pos = NULL;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						gboolean _tmp23_ = FALSE;
						const gchar* _tmp24_;
						const gchar* _tmp27_;
						_tmp15_ = str;
						_tmp16_ = strlen (_tmp15_);
						_tmp17_ = _tmp16_;
						pos_index = _tmp17_ - index;
						if (uc != ((gunichar) '1')) {
							_tmp18_ = TRUE;
						} else {
							_tmp18_ = (pos_index % 4) == 0;
						}
						if (_tmp18_) {
							GString* _tmp19_;
							const gchar* _tmp20_;
							_tmp19_ = builder;
							_tmp20_ = SKK_UTIL_KanjiNumericTable[uc - '0'];
							g_string_append (_tmp19_, _tmp20_);
						}
						_tmp21_ = num_pos_table[pos_index];
						_tmp22_ = g_strdup (_tmp21_);
						pos = _tmp22_;
						_tmp24_ = pos;
						if (_tmp24_ == NULL) {
							_tmp23_ = (pos_index % 4) > 0;
						} else {
							_tmp23_ = FALSE;
						}
						if (_tmp23_) {
							const gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp25_ = num_pos_table[pos_index % 4];
							_tmp26_ = g_strdup (_tmp25_);
							_g_free0 (pos);
							pos = _tmp26_;
						}
						_tmp27_ = pos;
						if (_tmp27_ != NULL) {
							GString* _tmp28_;
							const gchar* _tmp29_;
							_tmp28_ = builder;
							_tmp29_ = pos;
							g_string_append (_tmp28_, _tmp29_);
						}
						_g_free0 (pos);
					}
				}
			}
		}
		_tmp30_ = builder;
		_tmp31_ = _tmp30_->str;
		_tmp32_ = g_strdup (_tmp31_);
		result = _tmp32_;
		_g_free0 (str);
		_g_string_free0 (builder);
		return result;
	}
}

gchar*
skk_util_get_numeric (gint numeric,
                      SkkNumericConversionType type)
{
	gchar* _tmp8_;
	gchar* result;
	switch (type) {
		case SKK_NUMERIC_CONVERSION_TYPE_LATIN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup_printf ("%i", numeric);
			result = _tmp0_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_WIDE_LATIN:
		{
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp1_ = g_strdup_printf ("%i", numeric);
			_tmp2_ = _tmp1_;
			_tmp3_ = skk_util_get_wide_latin (_tmp2_);
			_tmp4_ = _tmp3_;
			_g_free0 (_tmp2_);
			result = _tmp4_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL:
		{
			gchar* _tmp5_;
			_tmp5_ = skk_util_get_kanji_numeric (numeric, SKK_UTIL_KanjiNumericTable, (gint) G_N_ELEMENTS (SKK_UTIL_KanjiNumericTable), NULL, (gint) 0);
			result = _tmp5_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_KANJI:
		{
			gchar* _tmp6_;
			_tmp6_ = skk_util_get_kanji_numeric (numeric, SKK_UTIL_KanjiNumericTable, (gint) G_N_ELEMENTS (SKK_UTIL_KanjiNumericTable), SKK_UTIL_KanjiNumericalPositionTable, (gint) G_N_ELEMENTS (SKK_UTIL_KanjiNumericalPositionTable));
			result = _tmp6_;
			return result;
		}
		case SKK_NUMERIC_CONVERSION_TYPE_DAIJI:
		{
			gchar* _tmp7_;
			_tmp7_ = skk_util_get_kanji_numeric (numeric, SKK_UTIL_DaijiNumericTable, (gint) G_N_ELEMENTS (SKK_UTIL_DaijiNumericTable), SKK_UTIL_DaijiNumericalPositionTable, (gint) G_N_ELEMENTS (SKK_UTIL_DaijiNumericalPositionTable));
			result = _tmp7_;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	return result;
}

gchar**
skk_util_build_data_path (const gchar* subdir,
                          gint* result_length1)
{
	GeeArrayList* dirs = NULL;
	GeeArrayList* _tmp0_;
	gchar* path = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GeeArrayList* _tmp20_;
	gint _tmp21_ = 0;
	gpointer* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** result;
	g_return_val_if_fail (subdir != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dirs = _tmp0_;
	_tmp1_ = g_getenv ("LIBSKK_DATA_PATH");
	_tmp2_ = g_strdup (_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		GeeArrayList* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GeeArrayList* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = dirs;
		_tmp5_ = g_get_user_config_dir ();
		_tmp6_ = g_build_filename (_tmp5_, PACKAGE_NAME, subdir, NULL);
		_tmp7_ = _tmp6_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = dirs;
		_tmp9_ = g_build_filename (PKGDATADIR, subdir, NULL);
		_tmp10_ = _tmp9_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
		_g_free0 (_tmp10_);
	} else {
		gchar** elements = NULL;
		const gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint elements_length1;
		gint _elements_size_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp11_ = path;
		_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, ":", 0);
		elements = _tmp13_;
		elements_length1 = _vala_array_length (_tmp12_);
		_elements_size_ = elements_length1;
		_tmp14_ = elements;
		_tmp14__length1 = elements_length1;
		{
			gchar** element_collection = NULL;
			gint element_collection_length1 = 0;
			gint _element_collection_size_ = 0;
			gint element_it = 0;
			element_collection = _tmp14_;
			element_collection_length1 = _tmp14__length1;
			for (element_it = 0; element_it < element_collection_length1; element_it = element_it + 1) {
				gchar* _tmp15_;
				gchar* element = NULL;
				_tmp15_ = g_strdup (element_collection[element_it]);
				element = _tmp15_;
				{
					GeeArrayList* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp16_ = dirs;
					_tmp17_ = element;
					_tmp18_ = g_build_filename (_tmp17_, subdir, NULL);
					_tmp19_ = _tmp18_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
					_g_free0 (_tmp19_);
					_g_free0 (element);
				}
			}
		}
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp20_ = dirs;
	_tmp22_ = gee_collection_to_array ((GeeCollection*) _tmp20_, &_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp21_;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	_g_free0 (path);
	_g_object_unref0 (dirs);
	return result;
}

SkkUtil*
skk_util_construct (GType object_type)
{
	SkkUtil * self = NULL;
	self = (SkkUtil*) g_object_new (object_type, NULL);
	return self;
}

SkkUtil*
skk_util_new (void)
{
	return skk_util_construct (SKK_TYPE_UTIL);
}

static void
skk_util_kana_table_entry_copy (const SkkUtilKanaTableEntry* self,
                                SkkUtilKanaTableEntry* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	(*dest).katakana = (*self).katakana;
	_tmp0_ = (*self).hiragana;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).hiragana);
	(*dest).hiragana = _tmp1_;
	_tmp2_ = (*self).hankaku_katakana;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).hankaku_katakana);
	(*dest).hankaku_katakana = _tmp3_;
}

static void
skk_util_kana_table_entry_destroy (SkkUtilKanaTableEntry* self)
{
	_g_free0 ((*self).hiragana);
	_g_free0 ((*self).hankaku_katakana);
}

static SkkUtilKanaTableEntry*
skk_util_kana_table_entry_dup (const SkkUtilKanaTableEntry* self)
{
	SkkUtilKanaTableEntry* dup;
	dup = g_new0 (SkkUtilKanaTableEntry, 1);
	skk_util_kana_table_entry_copy (self, dup);
	return dup;
}

static void
skk_util_kana_table_entry_free (SkkUtilKanaTableEntry* self)
{
	skk_util_kana_table_entry_destroy (self);
	g_free (self);
}

static GType
skk_util_kana_table_entry_get_type_once (void)
{
	GType skk_util_kana_table_entry_type_id;
	skk_util_kana_table_entry_type_id = g_boxed_type_register_static ("SkkUtilKanaTableEntry", (GBoxedCopyFunc) skk_util_kana_table_entry_dup, (GBoxedFreeFunc) skk_util_kana_table_entry_free);
	return skk_util_kana_table_entry_type_id;
}

static GType
skk_util_kana_table_entry_get_type (void)
{
	static volatile gsize skk_util_kana_table_entry_type_id__once = 0;
	if (g_once_init_enter (&skk_util_kana_table_entry_type_id__once)) {
		GType skk_util_kana_table_entry_type_id;
		skk_util_kana_table_entry_type_id = skk_util_kana_table_entry_get_type_once ();
		g_once_init_leave (&skk_util_kana_table_entry_type_id__once, skk_util_kana_table_entry_type_id);
	}
	return skk_util_kana_table_entry_type_id__once;
}

static void
skk_util_class_init (SkkUtilClass * klass,
                     gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	skk_util_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = skk_util_finalize;
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	skk_util__HiraganaTable = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	skk_util__KatakanaTable = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	skk_util__HankakuKatakanaTable = (GeeMap*) _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	skk_util__CompositionTable = (GeeMap*) _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_CHAR, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	skk_util__WideLatinToLatinTable = (GeeMap*) _tmp4_;
	{
		SkkUtilKanaTableEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_UTIL_KanaTable;
		entry_collection_length1 = G_N_ELEMENTS (SKK_UTIL_KanaTable);
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			SkkUtilKanaTableEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				GeeMap* _tmp5_;
				SkkUtilKanaTableEntry _tmp6_;
				SkkUtilKanaTableEntry _tmp7_;
				const gchar* _tmp8_;
				GeeMap* _tmp9_;
				SkkUtilKanaTableEntry _tmp10_;
				SkkUtilKanaTableEntry _tmp11_;
				const gchar* _tmp12_;
				SkkUtilKanaTableEntry _tmp17_;
				const gchar* _tmp18_;
				SkkUtilKanaTableEntry _tmp39_;
				const gchar* _tmp40_;
				_tmp5_ = skk_util__HiraganaTable;
				_tmp6_ = entry;
				_tmp7_ = entry;
				_tmp8_ = _tmp7_.hiragana;
				gee_map_set (_tmp5_, (gpointer) ((gintptr) _tmp6_.katakana), _tmp8_);
				_tmp9_ = skk_util__HankakuKatakanaTable;
				_tmp10_ = entry;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_.hankaku_katakana;
				gee_map_set (_tmp9_, (gpointer) ((gintptr) _tmp10_.katakana), _tmp12_);
				{
					SkkUtilKanaTableEntry* substitute_collection = NULL;
					gint substitute_collection_length1 = 0;
					gint _substitute_collection_size_ = 0;
					gint substitute_it = 0;
					substitute_collection = SKK_UTIL_HankakuKatakanaSubstitute;
					substitute_collection_length1 = G_N_ELEMENTS (SKK_UTIL_HankakuKatakanaSubstitute);
					for (substitute_it = 0; substitute_it < substitute_collection_length1; substitute_it = substitute_it + 1) {
						SkkUtilKanaTableEntry substitute = {0};
						substitute = substitute_collection[substitute_it];
						{
							GeeMap* _tmp13_;
							SkkUtilKanaTableEntry _tmp14_;
							SkkUtilKanaTableEntry _tmp15_;
							const gchar* _tmp16_;
							_tmp13_ = skk_util__HankakuKatakanaTable;
							_tmp14_ = substitute;
							_tmp15_ = substitute;
							_tmp16_ = _tmp15_.hankaku_katakana;
							gee_map_set (_tmp13_, (gpointer) ((gintptr) _tmp14_.katakana), _tmp16_);
						}
					}
				}
				_tmp17_ = entry;
				_tmp18_ = _tmp17_.hiragana;
				if (_tmp18_ != NULL) {
					SkkUtilKanaTableEntry _tmp19_;
					const gchar* _tmp20_;
					_tmp19_ = entry;
					_tmp20_ = _tmp19_.hiragana;
					if (g_utf8_strlen (_tmp20_, (gssize) -1) > 1) {
						gint index = 0;
						gunichar uc0 = 0U;
						gunichar uc1 = 0U;
						SkkUtilKanaTableEntry _tmp21_;
						const gchar* _tmp22_;
						gunichar _tmp23_ = 0U;
						SkkUtilKanaTableEntry _tmp24_;
						const gchar* _tmp25_;
						gunichar _tmp26_ = 0U;
						GeeMap* _tmp27_;
						GeeMap* composition = NULL;
						GeeMap* _tmp31_;
						gpointer _tmp32_;
						GeeMap* _tmp33_;
						SkkUtilKanaTableEntry _tmp34_;
						index = 0;
						_tmp21_ = entry;
						_tmp22_ = _tmp21_.hiragana;
						string_get_next_char (_tmp22_, &index, &_tmp23_);
						uc0 = _tmp23_;
						_tmp24_ = entry;
						_tmp25_ = _tmp24_.hiragana;
						string_get_next_char (_tmp25_, &index, &_tmp26_);
						uc1 = _tmp26_;
						_tmp27_ = skk_util__CompositionTable;
						if (!gee_map_has_key (_tmp27_, (gpointer) ((gintptr) uc0))) {
							GeeMap* _tmp28_;
							GeeHashMap* _tmp29_;
							GeeHashMap* _tmp30_;
							_tmp28_ = skk_util__CompositionTable;
							_tmp29_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
							_tmp30_ = _tmp29_;
							gee_map_set (_tmp28_, (gpointer) ((gintptr) uc0), (GeeMap*) _tmp30_);
							_g_object_unref0 (_tmp30_);
						}
						_tmp31_ = skk_util__CompositionTable;
						_tmp32_ = gee_map_get (_tmp31_, (gpointer) ((gintptr) uc0));
						composition = (GeeMap*) _tmp32_;
						_tmp33_ = composition;
						_tmp34_ = entry;
						gee_map_set (_tmp33_, (gpointer) ((gintptr) uc1), (gpointer) ((gintptr) _tmp34_.katakana));
						_g_object_unref0 (composition);
					} else {
						GeeMap* _tmp35_;
						SkkUtilKanaTableEntry _tmp36_;
						const gchar* _tmp37_;
						SkkUtilKanaTableEntry _tmp38_;
						_tmp35_ = skk_util__KatakanaTable;
						_tmp36_ = entry;
						_tmp37_ = _tmp36_.hiragana;
						_tmp38_ = entry;
						gee_map_set (_tmp35_, (gpointer) ((gintptr) string_get_char (_tmp37_, (glong) 0)), (gpointer) ((gintptr) _tmp38_.katakana));
					}
				}
				_tmp39_ = entry;
				_tmp40_ = _tmp39_.hankaku_katakana;
				if (_tmp40_ != NULL) {
					SkkUtilKanaTableEntry _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = entry;
					_tmp42_ = _tmp41_.hankaku_katakana;
					if (g_utf8_strlen (_tmp42_, (gssize) -1) > 1) {
						gint index = 0;
						gunichar uc0 = 0U;
						gunichar uc1 = 0U;
						SkkUtilKanaTableEntry _tmp43_;
						const gchar* _tmp44_;
						gunichar _tmp45_ = 0U;
						SkkUtilKanaTableEntry _tmp46_;
						const gchar* _tmp47_;
						gunichar _tmp48_ = 0U;
						GeeMap* _tmp49_;
						GeeMap* composition = NULL;
						GeeMap* _tmp53_;
						gpointer _tmp54_;
						GeeMap* _tmp55_;
						SkkUtilKanaTableEntry _tmp56_;
						index = 0;
						_tmp43_ = entry;
						_tmp44_ = _tmp43_.hankaku_katakana;
						string_get_next_char (_tmp44_, &index, &_tmp45_);
						uc0 = _tmp45_;
						_tmp46_ = entry;
						_tmp47_ = _tmp46_.hankaku_katakana;
						string_get_next_char (_tmp47_, &index, &_tmp48_);
						uc1 = _tmp48_;
						_tmp49_ = skk_util__CompositionTable;
						if (!gee_map_has_key (_tmp49_, (gpointer) ((gintptr) uc0))) {
							GeeMap* _tmp50_;
							GeeHashMap* _tmp51_;
							GeeHashMap* _tmp52_;
							_tmp50_ = skk_util__CompositionTable;
							_tmp51_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
							_tmp52_ = _tmp51_;
							gee_map_set (_tmp50_, (gpointer) ((gintptr) uc0), (GeeMap*) _tmp52_);
							_g_object_unref0 (_tmp52_);
						}
						_tmp53_ = skk_util__CompositionTable;
						_tmp54_ = gee_map_get (_tmp53_, (gpointer) ((gintptr) uc0));
						composition = (GeeMap*) _tmp54_;
						_tmp55_ = composition;
						_tmp56_ = entry;
						gee_map_set (_tmp55_, (gpointer) ((gintptr) uc1), (gpointer) ((gintptr) _tmp56_.katakana));
						_g_object_unref0 (composition);
					} else {
						GeeMap* _tmp57_;
						SkkUtilKanaTableEntry _tmp58_;
						const gchar* _tmp59_;
						SkkUtilKanaTableEntry _tmp60_;
						_tmp57_ = skk_util__KatakanaTable;
						_tmp58_ = entry;
						_tmp59_ = _tmp58_.hankaku_katakana;
						_tmp60_ = entry;
						gee_map_set (_tmp57_, (gpointer) ((gintptr) string_get_char (_tmp59_, (glong) 0)), (gpointer) ((gintptr) _tmp60_.katakana));
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp61_ = FALSE;
			_tmp61_ = TRUE;
			while (TRUE) {
				GeeMap* _tmp63_;
				const gchar* _tmp64_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = i;
					i = _tmp62_ + 1;
				}
				_tmp61_ = FALSE;
				if (!(i < G_N_ELEMENTS (SKK_UTIL_WideLatinTable))) {
					break;
				}
				_tmp63_ = skk_util__WideLatinToLatinTable;
				_tmp64_ = SKK_UTIL_WideLatinTable[i];
				gee_map_set (_tmp63_, _tmp64_, (gpointer) ((gintptr) (i + 32)));
			}
		}
	}
}

static void
skk_util_instance_init (SkkUtil * self,
                        gpointer klass)
{
}

static void
skk_util_finalize (GObject * obj)
{
	SkkUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_UTIL, SkkUtil);
	G_OBJECT_CLASS (skk_util_parent_class)->finalize (obj);
}

static GType
skk_util_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUtil), 0, (GInstanceInitFunc) skk_util_instance_init, NULL };
	GType skk_util_type_id;
	skk_util_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkUtil", &g_define_type_info, 0);
	return skk_util_type_id;
}

GType
skk_util_get_type (void)
{
	static volatile gsize skk_util_type_id__once = 0;
	if (g_once_init_enter (&skk_util_type_id__once)) {
		GType skk_util_type_id;
		skk_util_type_id = skk_util_get_type_once ();
		g_once_init_leave (&skk_util_type_id__once, skk_util_type_id);
	}
	return skk_util_type_id__once;
}

static inline gpointer
skk_unicode_string_get_instance_private (SkkUnicodeString* self)
{
	return G_STRUCT_MEMBER_P (self, SkkUnicodeString_private_offset);
}

SkkUnicodeString*
skk_unicode_string_construct (GType object_type,
                              const gchar* str)
{
	SkkUnicodeString * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, NULL);
	self = (SkkUnicodeString*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (str);
	_g_free0 (self->priv->str);
	self->priv->str = _tmp0_;
	self->length = g_utf8_strlen (str, (gssize) -1);
	return self;
}

SkkUnicodeString*
skk_unicode_string_new (const gchar* str)
{
	return skk_unicode_string_construct (SKK_TYPE_UNICODE_STRING, str);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
skk_unicode_string_substring (SkkUnicodeString* self,
                              glong offset,
                              glong len)
{
	glong byte_offset = 0L;
	const gchar* _tmp0_;
	glong byte_len = 0L;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->str;
	byte_offset = (glong) string_index_of_nth_char (_tmp0_, offset);
	if (len < ((glong) 0)) {
		byte_len = len;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->str;
		byte_len = string_index_of_nth_char (_tmp1_, offset + len) - byte_offset;
	}
	_tmp2_ = self->priv->str;
	_tmp3_ = string_substring (_tmp2_, byte_offset, byte_len);
	result = _tmp3_;
	return result;
}

static void
skk_unicode_string_class_init (SkkUnicodeStringClass * klass,
                               gpointer klass_data)
{
	skk_unicode_string_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkUnicodeString_private_offset);
	G_OBJECT_CLASS (klass)->finalize = skk_unicode_string_finalize;
}

static void
skk_unicode_string_instance_init (SkkUnicodeString * self,
                                  gpointer klass)
{
	self->priv = skk_unicode_string_get_instance_private (self);
}

static void
skk_unicode_string_finalize (GObject * obj)
{
	SkkUnicodeString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_UNICODE_STRING, SkkUnicodeString);
	_g_free0 (self->priv->str);
	G_OBJECT_CLASS (skk_unicode_string_parent_class)->finalize (obj);
}

static GType
skk_unicode_string_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkUnicodeStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_unicode_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUnicodeString), 0, (GInstanceInitFunc) skk_unicode_string_instance_init, NULL };
	GType skk_unicode_string_type_id;
	skk_unicode_string_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkUnicodeString", &g_define_type_info, 0);
	SkkUnicodeString_private_offset = g_type_add_instance_private (skk_unicode_string_type_id, sizeof (SkkUnicodeStringPrivate));
	return skk_unicode_string_type_id;
}

GType
skk_unicode_string_get_type (void)
{
	static volatile gsize skk_unicode_string_type_id__once = 0;
	if (g_once_init_enter (&skk_unicode_string_type_id__once)) {
		GType skk_unicode_string_type_id;
		skk_unicode_string_type_id = skk_unicode_string_get_type_once ();
		g_once_init_leave (&skk_unicode_string_type_id__once, skk_unicode_string_type_id);
	}
	return skk_unicode_string_type_id__once;
}

static inline gpointer
skk_memory_mapped_file_get_instance_private (SkkMemoryMappedFile* self)
{
	return G_STRUCT_MEMBER_P (self, SkkMemoryMappedFile_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SkkMemoryMappedFile*
skk_memory_mapped_file_construct (GType object_type,
                                  GFile* file)
{
	SkkMemoryMappedFile * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (SkkMemoryMappedFile*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

SkkMemoryMappedFile*
skk_memory_mapped_file_new (GFile* file)
{
	return skk_memory_mapped_file_construct (SKK_TYPE_MEMORY_MAPPED_FILE, file);
}

void
skk_memory_mapped_file_remap (SkkMemoryMappedFile* self,
                              GError** error)
{
	void* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_memory;
	if (_tmp0_ != NULL) {
		void* _tmp1_;
		_tmp1_ = self->priv->_memory;
		munmap (_tmp1_, self->priv->_length);
		self->priv->_memory = NULL;
	}
	skk_memory_mapped_file_map (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
skk_memory_mapped_file_map (SkkMemoryMappedFile* self,
                            GError** error)
{
	gint fd = 0;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	struct stat stat = {0};
	gint retval = 0;
	struct stat _tmp9_ = {0};
	gint _tmp10_;
	struct stat _tmp12_;
	void* _tmp13_;
	void* _tmp14_;
	void* _tmp15_;
	struct stat _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = open (_tmp2_, O_RDONLY, (mode_t) 0);
	_g_free0 (_tmp2_);
	fd = _tmp3_;
	if (fd < 0) {
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp4_ = self->priv->file;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't open %s", _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = fstat (fd, &_tmp9_);
	stat = _tmp9_;
	retval = _tmp10_;
	if (retval < 0) {
		GError* _tmp11_;
		_tmp11_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't stat fd");
		_inner_error0_ = _tmp11_;
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = stat;
	_tmp13_ = mmap (NULL, _tmp12_.st_size, PROT_READ, MAP_SHARED, fd, (off_t) 0);
	self->priv->_memory = _tmp13_;
	_tmp14_ = self->priv->_memory;
	_tmp15_ = MAP_FAILED;
	if (_tmp14_ == _tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "mmap failed");
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp17_ = stat;
	self->priv->_length = _tmp17_.st_size;
}

void*
skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self)
{
	void* result;
	void* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_memory;
	result = _tmp0_;
	return result;
}

gsize
skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self)
{
	gsize result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_length;
	return result;
}

static void
skk_memory_mapped_file_class_init (SkkMemoryMappedFileClass * klass,
                                   gpointer klass_data)
{
	skk_memory_mapped_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkMemoryMappedFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_memory_mapped_file_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_memory_mapped_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_MEMORY_MAPPED_FILE_MEMORY_PROPERTY, skk_memory_mapped_file_properties[SKK_MEMORY_MAPPED_FILE_MEMORY_PROPERTY] = g_param_spec_pointer ("memory", "memory", "memory", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_MEMORY_MAPPED_FILE_LENGTH_PROPERTY, skk_memory_mapped_file_properties[SKK_MEMORY_MAPPED_FILE_LENGTH_PROPERTY] = g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
skk_memory_mapped_file_instance_init (SkkMemoryMappedFile * self,
                                      gpointer klass)
{
	self->priv = skk_memory_mapped_file_get_instance_private (self);
	self->priv->_memory = NULL;
	self->priv->_length = (gsize) 0;
}

static void
skk_memory_mapped_file_finalize (GObject * obj)
{
	SkkMemoryMappedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (skk_memory_mapped_file_parent_class)->finalize (obj);
}

static GType
skk_memory_mapped_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkMemoryMappedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_memory_mapped_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkMemoryMappedFile), 0, (GInstanceInitFunc) skk_memory_mapped_file_instance_init, NULL };
	GType skk_memory_mapped_file_type_id;
	skk_memory_mapped_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkMemoryMappedFile", &g_define_type_info, 0);
	SkkMemoryMappedFile_private_offset = g_type_add_instance_private (skk_memory_mapped_file_type_id, sizeof (SkkMemoryMappedFilePrivate));
	return skk_memory_mapped_file_type_id;
}

GType
skk_memory_mapped_file_get_type (void)
{
	static volatile gsize skk_memory_mapped_file_type_id__once = 0;
	if (g_once_init_enter (&skk_memory_mapped_file_type_id__once)) {
		GType skk_memory_mapped_file_type_id;
		skk_memory_mapped_file_type_id = skk_memory_mapped_file_get_type_once ();
		g_once_init_leave (&skk_memory_mapped_file_type_id__once, skk_memory_mapped_file_type_id);
	}
	return skk_memory_mapped_file_type_id__once;
}

static void
_vala_skk_memory_mapped_file_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SkkMemoryMappedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile);
	switch (property_id) {
		case SKK_MEMORY_MAPPED_FILE_MEMORY_PROPERTY:
		g_value_set_pointer (value, skk_memory_mapped_file_get_memory (self));
		break;
		case SKK_MEMORY_MAPPED_FILE_LENGTH_PROPERTY:
		g_value_set_ulong (value, skk_memory_mapped_file_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
skk_key_event_utils_keyval_name (guint keyval)
{
	guint8* buffer = NULL;
	guint8* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gint ret = 0;
	gchar* result;
	_tmp0_ = g_new0 (guint8, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	ret = -1;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			guint8* _tmp3_;
			gint _tmp3__length1;
			guint8* _tmp4_;
			gint _tmp4__length1;
			guint8* _tmp7_;
			gint _tmp7__length1;
			guint8* _tmp8_;
			if (!_tmp1_) {
				guint8* _tmp2_;
				gint _tmp2__length1;
				_tmp2_ = buffer;
				_tmp2__length1 = buffer_length1;
				if (!(ret >= _tmp2__length1)) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp3_ = buffer;
			_tmp3__length1 = buffer_length1;
			ret = xkb_keysym_get_name ((guint32) keyval, _tmp3_, (size_t) _tmp3__length1);
			if (ret == -1) {
				result = NULL;
				buffer = (g_free (buffer), NULL);
				return result;
			}
			_tmp4_ = buffer;
			_tmp4__length1 = buffer_length1;
			if (ret < _tmp4__length1) {
				guint8* _tmp5_;
				gint _tmp5__length1;
				gchar* _tmp6_;
				_tmp5_ = buffer;
				_tmp5__length1 = buffer_length1;
				_tmp6_ = g_strdup ((const gchar*) _tmp5_);
				result = _tmp6_;
				buffer = (g_free (buffer), NULL);
				return result;
			}
			_tmp7_ = buffer;
			_tmp7__length1 = buffer_length1;
			_tmp8_ = g_new0 (guint8, _tmp7__length1 * 2);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp8_;
			buffer_length1 = _tmp7__length1 * 2;
			_buffer_size_ = buffer_length1;
		}
	}
	result = NULL;
	buffer = (g_free (buffer), NULL);
	return result;
}

guint
skk_key_event_utils_keyval_from_name (const gchar* name)
{
	guint32 keysym = 0U;
	guint result;
	g_return_val_if_fail (name != NULL, 0U);
	if (g_strcmp0 (name, " ") == 0) {
		name = "space";
	} else {
		if (g_strcmp0 (name, "\t") == 0) {
			name = "Tab";
		} else {
			if (g_strcmp0 (name, "\n") == 0) {
				name = "Return";
			} else {
				if (g_strcmp0 (name, "\b") == 0) {
					name = "BackSpace";
				}
			}
		}
	}
	keysym = xkb_keysym_from_name (name, XKB_KEYSYM_NO_FLAGS);
	if (keysym == XKB_KEY_NoSymbol) {
		if (g_utf8_strlen (name, (gssize) -1) == 1) {
			gunichar code = 0U;
			gboolean _tmp0_ = FALSE;
			code = string_get_char (name, (glong) 0);
			if (((gunichar) 0x20) <= code) {
				_tmp0_ = code < ((gunichar) 0x7F);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = (guint) code;
				return result;
			}
		}
		result = SKK_KEYSYMS_VoidSymbol;
		return result;
	}
	result = (guint) keysym;
	return result;
}

gunichar
skk_key_event_utils_keyval_unicode (guint keyval)
{
	gboolean _tmp0_ = FALSE;
	guint8* buffer = NULL;
	guint8* _tmp1_;
	gint buffer_length1;
	gint _buffer_size_;
	gint ret = 0;
	gunichar result;
	if (((guint) 0x20) <= keyval) {
		_tmp0_ = keyval < ((guint) 0x7F);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gunichar) keyval;
		return result;
	}
	if (keyval == SKK_KEYSYMS_yen) {
		result = string_get_char ("\xc2\xa5", (glong) 0);
		return result;
	}
	_tmp1_ = g_new0 (guint8, 8);
	buffer = _tmp1_;
	buffer_length1 = 8;
	_buffer_size_ = buffer_length1;
	ret = -1;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			guint8* _tmp3_;
			gint _tmp3__length1;
			guint8* _tmp4_;
			gint _tmp4__length1;
			guint8* _tmp5_;
			if (!_tmp2_) {
				if (!(ret == -1)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp3_ = buffer;
			_tmp3__length1 = buffer_length1;
			ret = xkb_keysym_to_utf8 ((guint32) keyval, _tmp3_, (size_t) _tmp3__length1);
			if (ret == 0) {
				result = (gunichar) '\0';
				buffer = (g_free (buffer), NULL);
				return result;
			}
			_tmp4_ = buffer;
			_tmp4__length1 = buffer_length1;
			_tmp5_ = g_new0 (guint8, _tmp4__length1 * 2);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp5_;
			buffer_length1 = _tmp4__length1 * 2;
			_buffer_size_ = buffer_length1;
		}
	}
	result = (gunichar) '\0';
	buffer = (g_free (buffer), NULL);
	return result;
}

SkkKeyEventUtils*
skk_key_event_utils_construct (GType object_type)
{
	SkkKeyEventUtils * self = NULL;
	self = (SkkKeyEventUtils*) g_object_new (object_type, NULL);
	return self;
}

static void
skk_key_event_utils_class_init (SkkKeyEventUtilsClass * klass,
                                gpointer klass_data)
{
	skk_key_event_utils_parent_class = g_type_class_peek_parent (klass);
}

static void
skk_key_event_utils_instance_init (SkkKeyEventUtils * self,
                                   gpointer klass)
{
}

static GType
skk_key_event_utils_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkKeyEventUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_key_event_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeyEventUtils), 0, (GInstanceInitFunc) skk_key_event_utils_instance_init, NULL };
	GType skk_key_event_utils_type_id;
	skk_key_event_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeyEventUtils", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return skk_key_event_utils_type_id;
}

GType
skk_key_event_utils_get_type (void)
{
	static volatile gsize skk_key_event_utils_type_id__once = 0;
	if (g_once_init_enter (&skk_key_event_utils_type_id__once)) {
		GType skk_key_event_utils_type_id;
		skk_key_event_utils_type_id = skk_key_event_utils_get_type_once ();
		g_once_init_leave (&skk_key_event_utils_type_id__once, skk_key_event_utils_type_id);
	}
	return skk_key_event_utils_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

