/* animatedValue.c generated by valac 0.56.18, the Vala compiler
 * generated from animatedValue.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_ANIMATED_VALUE (gnome_pie_animated_value_get_type ())
#define GNOME_PIE_ANIMATED_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValue))
#define GNOME_PIE_ANIMATED_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValueClass))
#define GNOME_PIE_IS_ANIMATED_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_ANIMATED_VALUE))
#define GNOME_PIE_IS_ANIMATED_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_ANIMATED_VALUE))
#define GNOME_PIE_ANIMATED_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValueClass))

typedef struct _GnomePieAnimatedValue GnomePieAnimatedValue;
typedef struct _GnomePieAnimatedValueClass GnomePieAnimatedValueClass;
typedef struct _GnomePieAnimatedValuePrivate GnomePieAnimatedValuePrivate;
typedef enum  {
	GNOME_PIE_ANIMATED_VALUE_TYPE_LINEAR,
	GNOME_PIE_ANIMATED_VALUE_TYPE_CUBIC
} GnomePieAnimatedValueType;

#define GNOME_PIE_ANIMATED_VALUE_TYPE_TYPE (gnome_pie_animated_value_type_get_type ())
typedef enum  {
	GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN,
	GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT,
	GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN_OUT,
	GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT_IN
} GnomePieAnimatedValueDirection;

#define GNOME_PIE_ANIMATED_VALUE_TYPE_DIRECTION (gnome_pie_animated_value_direction_get_type ())
enum  {
	GNOME_PIE_ANIMATED_VALUE_0_PROPERTY,
	GNOME_PIE_ANIMATED_VALUE_VAL_PROPERTY,
	GNOME_PIE_ANIMATED_VALUE_START_PROPERTY,
	GNOME_PIE_ANIMATED_VALUE_END_PROPERTY,
	GNOME_PIE_ANIMATED_VALUE_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_NUM_PROPERTIES];

struct _GnomePieAnimatedValue {
	GObject parent_instance;
	GnomePieAnimatedValuePrivate * priv;
};

struct _GnomePieAnimatedValueClass {
	GObjectClass parent_class;
};

struct _GnomePieAnimatedValuePrivate {
	gdouble _val;
	gdouble _start;
	gdouble _end;
	gdouble state;
	gdouble duration;
	gdouble multiplier;
	GnomePieAnimatedValueType type;
	GnomePieAnimatedValueDirection direction;
};

static gint GnomePieAnimatedValue_private_offset;
static gpointer gnome_pie_animated_value_parent_class = NULL;

VALA_EXTERN GType gnome_pie_animated_value_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieAnimatedValue, g_object_unref)
static GType gnome_pie_animated_value_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType gnome_pie_animated_value_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_new_linear (gdouble start,
                                                            gdouble end,
                                                            gdouble duration);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_construct_linear (GType object_type,
                                                                  gdouble start,
                                                                  gdouble end,
                                                                  gdouble duration);
static void gnome_pie_animated_value_set_val (GnomePieAnimatedValue* self,
                                       gdouble value);
static void gnome_pie_animated_value_set_start (GnomePieAnimatedValue* self,
                                         gdouble value);
static void gnome_pie_animated_value_set_end (GnomePieAnimatedValue* self,
                                       gdouble value);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_new_cubic (GnomePieAnimatedValueDirection direction,
                                                           gdouble start,
                                                           gdouble end,
                                                           gdouble duration,
                                                           gdouble multiplier);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_construct_cubic (GType object_type,
                                                                 GnomePieAnimatedValueDirection direction,
                                                                 gdouble start,
                                                                 gdouble end,
                                                                 gdouble duration,
                                                                 gdouble multiplier);
VALA_EXTERN void gnome_pie_animated_value_reset_target (GnomePieAnimatedValue* self,
                                            gdouble end,
                                            gdouble duration);
VALA_EXTERN gdouble gnome_pie_animated_value_get_val (GnomePieAnimatedValue* self);
VALA_EXTERN void gnome_pie_animated_value_update (GnomePieAnimatedValue* self,
                                      gdouble time);
static gdouble gnome_pie_animated_value_update_linear (GnomePieAnimatedValue* self,
                                                gdouble t,
                                                gdouble s,
                                                gdouble e);
VALA_EXTERN gdouble gnome_pie_animated_value_get_start (GnomePieAnimatedValue* self);
VALA_EXTERN gdouble gnome_pie_animated_value_get_end (GnomePieAnimatedValue* self);
static gdouble gnome_pie_animated_value_update_ease_in (GnomePieAnimatedValue* self,
                                                 gdouble t,
                                                 gdouble s,
                                                 gdouble e);
static gdouble gnome_pie_animated_value_update_ease_out (GnomePieAnimatedValue* self,
                                                  gdouble t,
                                                  gdouble s,
                                                  gdouble e);
static gdouble gnome_pie_animated_value_update_ease_in_out (GnomePieAnimatedValue* self,
                                                     gdouble t,
                                                     gdouble s,
                                                     gdouble e);
static gdouble gnome_pie_animated_value_update_ease_out_in (GnomePieAnimatedValue* self,
                                                     gdouble t,
                                                     gdouble s,
                                                     gdouble e);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_new (void);
VALA_EXTERN GnomePieAnimatedValue* gnome_pie_animated_value_construct (GType object_type);
static void gnome_pie_animated_value_finalize (GObject * obj);
static GType gnome_pie_animated_value_get_type_once (void);
static void _vala_gnome_pie_animated_value_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_gnome_pie_animated_value_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
gnome_pie_animated_value_get_instance_private (GnomePieAnimatedValue* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePieAnimatedValue_private_offset);
}

static GType
gnome_pie_animated_value_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN, "GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN", "in"}, {GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT, "GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT", "out"}, {GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN_OUT, "GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN_OUT", "in-out"}, {GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT_IN, "GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT_IN", "out-in"}, {0, NULL, NULL}};
	GType gnome_pie_animated_value_direction_type_id;
	gnome_pie_animated_value_direction_type_id = g_enum_register_static ("GnomePieAnimatedValueDirection", values);
	return gnome_pie_animated_value_direction_type_id;
}

GType
gnome_pie_animated_value_direction_get_type (void)
{
	static volatile gsize gnome_pie_animated_value_direction_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_animated_value_direction_type_id__once)) {
		GType gnome_pie_animated_value_direction_type_id;
		gnome_pie_animated_value_direction_type_id = gnome_pie_animated_value_direction_get_type_once ();
		g_once_init_leave (&gnome_pie_animated_value_direction_type_id__once, gnome_pie_animated_value_direction_type_id);
	}
	return gnome_pie_animated_value_direction_type_id__once;
}

static GType
gnome_pie_animated_value_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GNOME_PIE_ANIMATED_VALUE_TYPE_LINEAR, "GNOME_PIE_ANIMATED_VALUE_TYPE_LINEAR", "linear"}, {GNOME_PIE_ANIMATED_VALUE_TYPE_CUBIC, "GNOME_PIE_ANIMATED_VALUE_TYPE_CUBIC", "cubic"}, {0, NULL, NULL}};
	GType gnome_pie_animated_value_type_type_id;
	gnome_pie_animated_value_type_type_id = g_enum_register_static ("GnomePieAnimatedValueType", values);
	return gnome_pie_animated_value_type_type_id;
}

static GType
gnome_pie_animated_value_type_get_type (void)
{
	static volatile gsize gnome_pie_animated_value_type_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_animated_value_type_type_id__once)) {
		GType gnome_pie_animated_value_type_type_id;
		gnome_pie_animated_value_type_type_id = gnome_pie_animated_value_type_get_type_once ();
		g_once_init_leave (&gnome_pie_animated_value_type_type_id__once, gnome_pie_animated_value_type_type_id);
	}
	return gnome_pie_animated_value_type_type_id__once;
}

GnomePieAnimatedValue*
gnome_pie_animated_value_construct_linear (GType object_type,
                                           gdouble start,
                                           gdouble end,
                                           gdouble duration)
{
	GnomePieAnimatedValue * self = NULL;
	self = (GnomePieAnimatedValue*) g_object_new (object_type, NULL);
	gnome_pie_animated_value_set_val (self, start);
	gnome_pie_animated_value_set_start (self, start);
	gnome_pie_animated_value_set_end (self, end);
	self->priv->duration = duration;
	return self;
}

GnomePieAnimatedValue*
gnome_pie_animated_value_new_linear (gdouble start,
                                     gdouble end,
                                     gdouble duration)
{
	return gnome_pie_animated_value_construct_linear (GNOME_PIE_TYPE_ANIMATED_VALUE, start, end, duration);
}

GnomePieAnimatedValue*
gnome_pie_animated_value_construct_cubic (GType object_type,
                                          GnomePieAnimatedValueDirection direction,
                                          gdouble start,
                                          gdouble end,
                                          gdouble duration,
                                          gdouble multiplier)
{
	GnomePieAnimatedValue * self = NULL;
	self = (GnomePieAnimatedValue*) g_object_new (object_type, NULL);
	gnome_pie_animated_value_set_val (self, start);
	gnome_pie_animated_value_set_start (self, start);
	gnome_pie_animated_value_set_end (self, end);
	self->priv->duration = duration;
	self->priv->direction = direction;
	self->priv->type = GNOME_PIE_ANIMATED_VALUE_TYPE_CUBIC;
	self->priv->multiplier = multiplier;
	return self;
}

GnomePieAnimatedValue*
gnome_pie_animated_value_new_cubic (GnomePieAnimatedValueDirection direction,
                                    gdouble start,
                                    gdouble end,
                                    gdouble duration,
                                    gdouble multiplier)
{
	return gnome_pie_animated_value_construct_cubic (GNOME_PIE_TYPE_ANIMATED_VALUE, direction, start, end, duration, multiplier);
}

void
gnome_pie_animated_value_reset_target (GnomePieAnimatedValue* self,
                                       gdouble end,
                                       gdouble duration)
{
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	gnome_pie_animated_value_set_end (self, end);
	self->priv->duration = duration;
	_tmp0_ = self->priv->_val;
	gnome_pie_animated_value_set_start (self, _tmp0_);
	if (duration == 0.0) {
		gnome_pie_animated_value_set_val (self, end);
		self->priv->state = 1.0;
	} else {
		self->priv->state = 0.0;
	}
}

void
gnome_pie_animated_value_update (GnomePieAnimatedValue* self,
                                 gdouble time)
{
	g_return_if_fail (self != NULL);
	self->priv->state = self->priv->state + (time / self->priv->duration);
	if (self->priv->state < ((gdouble) 1)) {
		switch (self->priv->type) {
			case GNOME_PIE_ANIMATED_VALUE_TYPE_LINEAR:
			{
				gdouble _tmp0_;
				gdouble _tmp1_;
				_tmp0_ = self->priv->_start;
				_tmp1_ = self->priv->_end;
				gnome_pie_animated_value_set_val (self, gnome_pie_animated_value_update_linear (self, self->priv->state, _tmp0_, _tmp1_));
				break;
			}
			case GNOME_PIE_ANIMATED_VALUE_TYPE_CUBIC:
			{
				switch (self->priv->direction) {
					case GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN:
					{
						gdouble _tmp2_;
						gdouble _tmp3_;
						_tmp2_ = self->priv->_start;
						_tmp3_ = self->priv->_end;
						gnome_pie_animated_value_set_val (self, gnome_pie_animated_value_update_ease_in (self, self->priv->state, _tmp2_, _tmp3_));
						return;
					}
					case GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT:
					{
						gdouble _tmp4_;
						gdouble _tmp5_;
						_tmp4_ = self->priv->_start;
						_tmp5_ = self->priv->_end;
						gnome_pie_animated_value_set_val (self, gnome_pie_animated_value_update_ease_out (self, self->priv->state, _tmp4_, _tmp5_));
						return;
					}
					case GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN_OUT:
					{
						gdouble _tmp6_;
						gdouble _tmp7_;
						_tmp6_ = self->priv->_start;
						_tmp7_ = self->priv->_end;
						gnome_pie_animated_value_set_val (self, gnome_pie_animated_value_update_ease_in_out (self, self->priv->state, _tmp6_, _tmp7_));
						return;
					}
					case GNOME_PIE_ANIMATED_VALUE_DIRECTION_OUT_IN:
					{
						gdouble _tmp8_;
						gdouble _tmp9_;
						_tmp8_ = self->priv->_start;
						_tmp9_ = self->priv->_end;
						gnome_pie_animated_value_set_val (self, gnome_pie_animated_value_update_ease_out_in (self, self->priv->state, _tmp8_, _tmp9_));
						return;
					}
					default:
					break;
				}
				break;
			}
			default:
			break;
		}
	} else {
		gdouble _tmp10_;
		gdouble _tmp11_;
		_tmp10_ = self->priv->_val;
		_tmp11_ = self->priv->_end;
		if (_tmp10_ != _tmp11_) {
			gdouble _tmp12_;
			_tmp12_ = self->priv->_end;
			gnome_pie_animated_value_set_val (self, _tmp12_);
		}
	}
}

static gdouble
gnome_pie_animated_value_update_linear (GnomePieAnimatedValue* self,
                                        gdouble t,
                                        gdouble s,
                                        gdouble e)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = s + (t * (e - s));
	return result;
}

static gdouble
gnome_pie_animated_value_update_ease_in (GnomePieAnimatedValue* self,
                                         gdouble t,
                                         gdouble s,
                                         gdouble e)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = s + (((t * t) * (((self->priv->multiplier + 1) * t) - self->priv->multiplier)) * (e - s));
	return result;
}

static gdouble
gnome_pie_animated_value_update_ease_out (GnomePieAnimatedValue* self,
                                          gdouble t,
                                          gdouble s,
                                          gdouble e)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = s + (((((t - 1) * (t - 1)) * (((self->priv->multiplier + 1) * (t - 1)) + self->priv->multiplier)) + 1) * (e - s));
	return result;
}

static gdouble
gnome_pie_animated_value_update_ease_in_out (GnomePieAnimatedValue* self,
                                             gdouble t,
                                             gdouble s,
                                             gdouble e)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->state < 0.5) {
		result = gnome_pie_animated_value_update_ease_in (self, t * 2, s, e - ((e - s) * 0.5));
		return result;
	} else {
		result = gnome_pie_animated_value_update_ease_out (self, (t * 2) - 1, s + ((e - s) * 0.5), e);
		return result;
	}
}

static gdouble
gnome_pie_animated_value_update_ease_out_in (GnomePieAnimatedValue* self,
                                             gdouble t,
                                             gdouble s,
                                             gdouble e)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->state < 0.5) {
		result = gnome_pie_animated_value_update_ease_out (self, t * 2, s, e - ((e - s) * 0.5));
		return result;
	} else {
		result = gnome_pie_animated_value_update_ease_in (self, (t * 2) - 1, s + ((e - s) * 0.5), e);
		return result;
	}
}

GnomePieAnimatedValue*
gnome_pie_animated_value_construct (GType object_type)
{
	GnomePieAnimatedValue * self = NULL;
	self = (GnomePieAnimatedValue*) g_object_new (object_type, NULL);
	return self;
}

GnomePieAnimatedValue*
gnome_pie_animated_value_new (void)
{
	return gnome_pie_animated_value_construct (GNOME_PIE_TYPE_ANIMATED_VALUE);
}

gdouble
gnome_pie_animated_value_get_val (GnomePieAnimatedValue* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_val;
	return result;
}

static void
gnome_pie_animated_value_set_val (GnomePieAnimatedValue* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_animated_value_get_val (self);
	if (old_value != value) {
		self->priv->_val = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_VAL_PROPERTY]);
	}
}

gdouble
gnome_pie_animated_value_get_start (GnomePieAnimatedValue* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_start;
	return result;
}

static void
gnome_pie_animated_value_set_start (GnomePieAnimatedValue* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_animated_value_get_start (self);
	if (old_value != value) {
		self->priv->_start = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_START_PROPERTY]);
	}
}

gdouble
gnome_pie_animated_value_get_end (GnomePieAnimatedValue* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_end;
	return result;
}

static void
gnome_pie_animated_value_set_end (GnomePieAnimatedValue* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_animated_value_get_end (self);
	if (old_value != value) {
		self->priv->_end = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_END_PROPERTY]);
	}
}

static void
gnome_pie_animated_value_class_init (GnomePieAnimatedValueClass * klass,
                                     gpointer klass_data)
{
	gnome_pie_animated_value_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePieAnimatedValue_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_animated_value_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_animated_value_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_animated_value_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_ANIMATED_VALUE_VAL_PROPERTY, gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_VAL_PROPERTY] = g_param_spec_double ("val", "val", "val", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_ANIMATED_VALUE_START_PROPERTY, gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_START_PROPERTY] = g_param_spec_double ("start", "start", "start", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_ANIMATED_VALUE_END_PROPERTY, gnome_pie_animated_value_properties[GNOME_PIE_ANIMATED_VALUE_END_PROPERTY] = g_param_spec_double ("end", "end", "end", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gnome_pie_animated_value_instance_init (GnomePieAnimatedValue * self,
                                        gpointer klass)
{
	self->priv = gnome_pie_animated_value_get_instance_private (self);
	self->priv->_start = 0.0;
	self->priv->_end = 0.0;
	self->priv->state = 0.0;
	self->priv->duration = 0.0;
	self->priv->multiplier = 0.0;
	self->priv->type = GNOME_PIE_ANIMATED_VALUE_TYPE_LINEAR;
	self->priv->direction = GNOME_PIE_ANIMATED_VALUE_DIRECTION_IN;
}

static void
gnome_pie_animated_value_finalize (GObject * obj)
{
	GnomePieAnimatedValue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValue);
	G_OBJECT_CLASS (gnome_pie_animated_value_parent_class)->finalize (obj);
}

static GType
gnome_pie_animated_value_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieAnimatedValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_animated_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieAnimatedValue), 0, (GInstanceInitFunc) gnome_pie_animated_value_instance_init, NULL };
	GType gnome_pie_animated_value_type_id;
	gnome_pie_animated_value_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePieAnimatedValue", &g_define_type_info, 0);
	GnomePieAnimatedValue_private_offset = g_type_add_instance_private (gnome_pie_animated_value_type_id, sizeof (GnomePieAnimatedValuePrivate));
	return gnome_pie_animated_value_type_id;
}

GType
gnome_pie_animated_value_get_type (void)
{
	static volatile gsize gnome_pie_animated_value_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_animated_value_type_id__once)) {
		GType gnome_pie_animated_value_type_id;
		gnome_pie_animated_value_type_id = gnome_pie_animated_value_get_type_once ();
		g_once_init_leave (&gnome_pie_animated_value_type_id__once, gnome_pie_animated_value_type_id);
	}
	return gnome_pie_animated_value_type_id__once;
}

static void
_vala_gnome_pie_animated_value_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GnomePieAnimatedValue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValue);
	switch (property_id) {
		case GNOME_PIE_ANIMATED_VALUE_VAL_PROPERTY:
		g_value_set_double (value, gnome_pie_animated_value_get_val (self));
		break;
		case GNOME_PIE_ANIMATED_VALUE_START_PROPERTY:
		g_value_set_double (value, gnome_pie_animated_value_get_start (self));
		break;
		case GNOME_PIE_ANIMATED_VALUE_END_PROPERTY:
		g_value_set_double (value, gnome_pie_animated_value_get_end (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_animated_value_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GnomePieAnimatedValue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_ANIMATED_VALUE, GnomePieAnimatedValue);
	switch (property_id) {
		case GNOME_PIE_ANIMATED_VALUE_VAL_PROPERTY:
		gnome_pie_animated_value_set_val (self, g_value_get_double (value));
		break;
		case GNOME_PIE_ANIMATED_VALUE_START_PROPERTY:
		gnome_pie_animated_value_set_start (self, g_value_get_double (value));
		break;
		case GNOME_PIE_ANIMATED_VALUE_END_PROPERTY:
		gnome_pie_animated_value_set_end (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

