/* theme-renderer.c generated by valac 0.56.18, the Vala compiler
 * generated from theme-renderer.vala, do not modify */

/*
 * Color lines for GNOME
 * Copyright © 1999 Free Software Foundation
 * Authors: Robert Szokovacs <szo@szo.hu>
 *          Szabolcs Ban <shooby@gnome.hu>
 *          Karuna Grewal <karunagrewal98@gmail.com>
 *          Ruxandra Simion <ruxandra.simion93@gmail.com>
 * Copyright © 2007 Christian Persch
 *
 * This game is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <librsvg/rsvg.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#define THEME_RENDERER_DEFAULT_SPRITE_SIZE 20
#define FIVE_OR_MORE_APP_KEY_THEME "ball-theme"
#define GAME_N_TYPES 7
#define GAME_N_ANIMATIONS 4
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME_RENDERER (theme_renderer_get_type ())
#define THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_RENDERER, ThemeRenderer))
#define THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_RENDERER, ThemeRendererClass))
#define IS_THEME_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_RENDERER))
#define IS_THEME_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_RENDERER))
#define THEME_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_RENDERER, ThemeRendererClass))

typedef struct _ThemeRenderer ThemeRenderer;
typedef struct _ThemeRendererClass ThemeRendererClass;
typedef struct _ThemeRendererPrivate ThemeRendererPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _ParamSpecThemeRenderer ParamSpecThemeRenderer;
enum  {
	THEME_RENDERER_THEME_CHANGED_SIGNAL,
	THEME_RENDERER_NUM_SIGNALS
};
static guint theme_renderer_signals[THEME_RENDERER_NUM_SIGNALS] = {0};

struct _ThemeRenderer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThemeRendererPrivate * priv;
};

struct _ThemeRendererClass {
	GTypeClass parent_class;
	void (*finalize) (ThemeRenderer *self);
};

struct _ThemeRendererPrivate {
	GSettings* settings;
	gint sprite_size;
	gdouble sprite_sheet_width;
	gdouble sprite_sheet_height;
	gdouble theme_sprite_size;
	gchar* theme_name;
	RsvgHandle* theme;
	cairo_pattern_t* tile_pattern;
	cairo_t* cr_preview;
	gboolean is_theme_changed;
};

struct _ParamSpecThemeRenderer {
	GParamSpec parent_instance;
};

static gint ThemeRenderer_private_offset;
static gpointer theme_renderer_parent_class = NULL;

VALA_EXTERN gpointer theme_renderer_ref (gpointer instance);
VALA_EXTERN void theme_renderer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_theme_renderer (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_theme_renderer (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_theme_renderer (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_theme_renderer (const GValue* value);
VALA_EXTERN GType theme_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeRenderer, theme_renderer_unref)
VALA_EXTERN ThemeRenderer* theme_renderer_new (GSettings* settings);
VALA_EXTERN ThemeRenderer* theme_renderer_construct (GType object_type,
                                         GSettings* settings);
static void theme_renderer_change_theme_cb (ThemeRenderer* self);
static void _theme_renderer_change_theme_cb_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self);
static void theme_renderer_load_theme (ThemeRenderer* self,
                                const gchar* theme_file,
                                GError** error);
VALA_EXTERN void theme_renderer_render_sprite (ThemeRenderer* self,
                                   cairo_t* cr,
                                   gint type,
                                   gint animation,
                                   gdouble x,
                                   gdouble y,
                                   gint size);
static void theme_renderer_finalize (ThemeRenderer * obj);
static GType theme_renderer_get_type_once (void);

const gchar* THEME_RENDERER_themes[3] = {"balls.svg", "shapes.svg", "tango.svg"};

static inline gpointer
theme_renderer_get_instance_private (ThemeRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, ThemeRenderer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_theme_renderer_change_theme_cb_g_settings_changed (GSettings* _sender,
                                                    const gchar* key,
                                                    gpointer self)
{
	theme_renderer_change_theme_cb ((ThemeRenderer*) self);
}

ThemeRenderer*
theme_renderer_construct (GType object_type,
                          GSettings* settings)
{
	ThemeRenderer* self = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ThemeRenderer*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_strconcat ("changed::", FIVE_OR_MORE_APP_KEY_THEME, NULL);
	g_signal_connect (settings, _tmp1_, (GCallback) _theme_renderer_change_theme_cb_g_settings_changed, self);
	_g_free0 (_tmp1_);
	theme_renderer_change_theme_cb (self);
	self->priv->is_theme_changed = FALSE;
	return self;
}

ThemeRenderer*
theme_renderer_new (GSettings* settings)
{
	return theme_renderer_construct (TYPE_THEME_RENDERER, settings);
}

static void
theme_renderer_change_theme_cb (ThemeRenderer* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* theme_file = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, FIVE_OR_MORE_APP_KEY_THEME);
	_g_free0 (self->priv->theme_name);
	self->priv->theme_name = _tmp1_;
	_tmp2_ = self->priv->theme_name;
	_tmp3_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp2_, NULL);
	theme_file = _tmp3_;
	{
		const gchar* _tmp4_;
		_tmp4_ = theme_file;
		theme_renderer_load_theme (self, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GSettings* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_default_value (_tmp5_, FIVE_OR_MORE_APP_KEY_THEME);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_variant_get_string (_tmp7_, NULL);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->theme_name);
		self->priv->theme_name = _tmp9_;
		_g_variant_unref0 (_tmp7_);
		_tmp10_ = self->priv->theme_name;
		_tmp11_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp10_, NULL);
		_g_free0 (theme_file);
		theme_file = _tmp11_;
		{
			const gchar* _tmp12_;
			_tmp12_ = theme_file;
			theme_renderer_load_theme (self, _tmp12_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("theme-renderer.vala:78: Unable to load default theme\n");
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (theme_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_warning ("theme-renderer.vala:81: Unable to load chosen theme\n");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (theme_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (theme_file);
}

static void
theme_renderer_load_theme (ThemeRenderer* self,
                           const gchar* theme_file,
                           GError** error)
{
	RsvgHandle* _tmp0_ = NULL;
	RsvgHandle* _tmp1_;
	RsvgHandle* _tmp2_;
	RsvgHandle* _tmp3_;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_file != NULL);
	_tmp1_ = rsvg_handle_new_from_file (theme_file, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->theme);
	self->priv->theme = _tmp2_;
	_tmp3_ = self->priv->theme;
	rsvg_handle_get_intrinsic_size_in_pixels (_tmp3_, &_tmp4_, &_tmp5_);
	self->priv->sprite_sheet_width = _tmp4_;
	self->priv->sprite_sheet_height = _tmp5_;
	self->priv->theme_sprite_size = self->priv->sprite_sheet_height / GAME_N_TYPES;
	g_signal_emit (self, theme_renderer_signals[THEME_RENDERER_THEME_CHANGED_SIGNAL], 0);
	self->priv->is_theme_changed = TRUE;
	_g_object_unref0 (_tmp0_);
}

void
theme_renderer_render_sprite (ThemeRenderer* self,
                              cairo_t* cr,
                              gint type,
                              gint animation,
                              gdouble x,
                              gdouble y,
                              gint size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_pattern_t* _tmp13_;
	gint texture_x = 0;
	gint texture_y = 0;
	cairo_matrix_t m = {0};
	cairo_pattern_t* _tmp14_;
	cairo_matrix_t _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (self->priv->is_theme_changed) {
		_tmp1_ = TRUE;
	} else {
		cairo_pattern_t* _tmp2_;
		_tmp2_ = self->priv->tile_pattern;
		_tmp1_ = _tmp2_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->sprite_size != size;
	}
	if (_tmp0_) {
		cairo_surface_t* preview_surface = NULL;
		cairo_surface_t* _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_surface_t* _tmp5_;
		cairo_t* _tmp6_;
		cairo_matrix_t matrix = {0};
		cairo_t* _tmp7_;
		cairo_matrix_t _tmp8_;
		RsvgHandle* _tmp9_;
		cairo_t* _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_pattern_t* _tmp12_;
		self->priv->is_theme_changed = FALSE;
		self->priv->sprite_size = size;
		_tmp3_ = cairo_get_target (cr);
		_tmp4_ = cairo_surface_create_similar (_tmp3_, CAIRO_CONTENT_COLOR_ALPHA, GAME_N_ANIMATIONS * self->priv->sprite_size, GAME_N_TYPES * self->priv->sprite_size);
		preview_surface = _tmp4_;
		_tmp5_ = preview_surface;
		_tmp6_ = cairo_create (_tmp5_);
		_cairo_destroy0 (self->priv->cr_preview);
		self->priv->cr_preview = _tmp6_;
		cairo_matrix_init_identity (&matrix);
		cairo_matrix_scale (&matrix, ((self->priv->sprite_sheet_width / self->priv->theme_sprite_size) * self->priv->sprite_size) / self->priv->sprite_sheet_width, (GAME_N_TYPES * self->priv->sprite_size) / self->priv->sprite_sheet_height);
		_tmp7_ = self->priv->cr_preview;
		_tmp8_ = matrix;
		cairo_set_matrix (_tmp7_, &_tmp8_);
		_tmp9_ = self->priv->theme;
		_tmp10_ = self->priv->cr_preview;
		rsvg_handle_render_cairo (_tmp9_, _tmp10_);
		_tmp11_ = preview_surface;
		_tmp12_ = cairo_pattern_create_for_surface (_tmp11_);
		_cairo_pattern_destroy0 (self->priv->tile_pattern);
		self->priv->tile_pattern = _tmp12_;
		_cairo_surface_destroy0 (preview_surface);
	}
	_tmp13_ = self->priv->tile_pattern;
	cairo_set_source (cr, _tmp13_);
	texture_x = self->priv->sprite_size * animation;
	texture_y = self->priv->sprite_size * type;
	cairo_matrix_init_identity (&m);
	cairo_matrix_translate (&m, texture_x - x, texture_y - y);
	_tmp14_ = self->priv->tile_pattern;
	_tmp15_ = m;
	cairo_pattern_set_matrix (_tmp14_, &_tmp15_);
	cairo_rectangle (cr, x, y, (gdouble) self->priv->sprite_size, (gdouble) self->priv->sprite_size);
	cairo_fill (cr);
}

static void
value_theme_renderer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_theme_renderer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		theme_renderer_unref (value->data[0].v_pointer);
	}
}

static void
value_theme_renderer_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = theme_renderer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_theme_renderer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_theme_renderer_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ThemeRenderer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = theme_renderer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_theme_renderer_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	ThemeRenderer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = theme_renderer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_theme_renderer (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecThemeRenderer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THEME_RENDERER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_theme_renderer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME_RENDERER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_theme_renderer (GValue* value,
                          gpointer v_object)
{
	ThemeRenderer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME_RENDERER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME_RENDERER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		theme_renderer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		theme_renderer_unref (old);
	}
}

void
value_take_theme_renderer (GValue* value,
                           gpointer v_object)
{
	ThemeRenderer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME_RENDERER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME_RENDERER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		theme_renderer_unref (old);
	}
}

static void
theme_renderer_class_init (ThemeRendererClass * klass,
                           gpointer klass_data)
{
	theme_renderer_parent_class = g_type_class_peek_parent (klass);
	((ThemeRendererClass *) klass)->finalize = theme_renderer_finalize;
	g_type_class_adjust_private_offset (klass, &ThemeRenderer_private_offset);
	theme_renderer_signals[THEME_RENDERER_THEME_CHANGED_SIGNAL] = g_signal_new ("theme-changed", TYPE_THEME_RENDERER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
theme_renderer_instance_init (ThemeRenderer * self,
                              gpointer klass)
{
	self->priv = theme_renderer_get_instance_private (self);
	self->priv->sprite_size = THEME_RENDERER_DEFAULT_SPRITE_SIZE;
	self->priv->theme = NULL;
	self->priv->tile_pattern = NULL;
	self->ref_count = 1;
}

static void
theme_renderer_finalize (ThemeRenderer * obj)
{
	ThemeRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_RENDERER, ThemeRenderer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->settings);
	_g_free0 (self->priv->theme_name);
	_g_object_unref0 (self->priv->theme);
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	_cairo_destroy0 (self->priv->cr_preview);
}

static GType
theme_renderer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_theme_renderer_init, value_theme_renderer_free_value, value_theme_renderer_copy_value, value_theme_renderer_peek_pointer, "p", value_theme_renderer_collect_value, "p", value_theme_renderer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ThemeRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeRenderer), 0, (GInstanceInitFunc) theme_renderer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType theme_renderer_type_id;
	theme_renderer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThemeRenderer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ThemeRenderer_private_offset = g_type_add_instance_private (theme_renderer_type_id, sizeof (ThemeRendererPrivate));
	return theme_renderer_type_id;
}

GType
theme_renderer_get_type (void)
{
	static volatile gsize theme_renderer_type_id__once = 0;
	if (g_once_init_enter (&theme_renderer_type_id__once)) {
		GType theme_renderer_type_id;
		theme_renderer_type_id = theme_renderer_get_type_once ();
		g_once_init_leave (&theme_renderer_type_id__once, theme_renderer_type_id);
	}
	return theme_renderer_type_id__once;
}

gpointer
theme_renderer_ref (gpointer instance)
{
	ThemeRenderer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
theme_renderer_unref (gpointer instance)
{
	ThemeRenderer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THEME_RENDERER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

