/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> void Options::set(
    options::regExpElim__option_t,
    const options::regExpElim__option_t::type& x)
{
  d_holder->regExpElim = x;
}
template <> const options::regExpElim__option_t::type& Options::operator[](
    options::regExpElim__option_t) const
{
  return d_holder->regExpElim;
}
template <> bool Options::wasSetByUser(options::regExpElim__option_t) const
{
  return d_holder->regExpElim__setByUser__;
}
template <> void Options::set(
    options::regExpElimAgg__option_t,
    const options::regExpElimAgg__option_t::type& x)
{
  d_holder->regExpElimAgg = x;
}
template <> const options::regExpElimAgg__option_t::type& Options::operator[](
    options::regExpElimAgg__option_t) const
{
  return d_holder->regExpElimAgg;
}
template <> bool Options::wasSetByUser(options::regExpElimAgg__option_t) const
{
  return d_holder->regExpElimAgg__setByUser__;
}
template <> void Options::set(
    options::stringRegExpInterMode__option_t,
    const options::stringRegExpInterMode__option_t::type& x)
{
  d_holder->stringRegExpInterMode = x;
}
template <> const options::stringRegExpInterMode__option_t::type& Options::operator[](
    options::stringRegExpInterMode__option_t) const
{
  return d_holder->stringRegExpInterMode;
}
template <> bool Options::wasSetByUser(options::stringRegExpInterMode__option_t) const
{
  return d_holder->stringRegExpInterMode__setByUser__;
}
template <> const options::stringCheckEntailLen__option_t::type& Options::operator[](
    options::stringCheckEntailLen__option_t) const
{
  return d_holder->stringCheckEntailLen;
}
template <> bool Options::wasSetByUser(options::stringCheckEntailLen__option_t) const
{
  return d_holder->stringCheckEntailLen__setByUser__;
}
template <> const options::stringEager__option_t::type& Options::operator[](
    options::stringEager__option_t) const
{
  return d_holder->stringEager;
}
template <> bool Options::wasSetByUser(options::stringEager__option_t) const
{
  return d_holder->stringEager__setByUser__;
}
template <> const options::stringEagerLen__option_t::type& Options::operator[](
    options::stringEagerLen__option_t) const
{
  return d_holder->stringEagerLen;
}
template <> bool Options::wasSetByUser(options::stringEagerLen__option_t) const
{
  return d_holder->stringEagerLen__setByUser__;
}
template <> void Options::set(
    options::stringExp__option_t,
    const options::stringExp__option_t::type& x)
{
  d_holder->stringExp = x;
}
template <> const options::stringExp__option_t::type& Options::operator[](
    options::stringExp__option_t) const
{
  return d_holder->stringExp;
}
template <> bool Options::wasSetByUser(options::stringExp__option_t) const
{
  return d_holder->stringExp__setByUser__;
}
template <> const options::stringFlatForms__option_t::type& Options::operator[](
    options::stringFlatForms__option_t) const
{
  return d_holder->stringFlatForms;
}
template <> bool Options::wasSetByUser(options::stringFlatForms__option_t) const
{
  return d_holder->stringFlatForms__setByUser__;
}
template <> void Options::set(
    options::stringFMF__option_t,
    const options::stringFMF__option_t::type& x)
{
  d_holder->stringFMF = x;
}
template <> const options::stringFMF__option_t::type& Options::operator[](
    options::stringFMF__option_t) const
{
  return d_holder->stringFMF;
}
template <> bool Options::wasSetByUser(options::stringFMF__option_t) const
{
  return d_holder->stringFMF__setByUser__;
}
template <> const options::stringGuessModel__option_t::type& Options::operator[](
    options::stringGuessModel__option_t) const
{
  return d_holder->stringGuessModel;
}
template <> bool Options::wasSetByUser(options::stringGuessModel__option_t) const
{
  return d_holder->stringGuessModel__setByUser__;
}
template <> const options::stringInferAsLemmas__option_t::type& Options::operator[](
    options::stringInferAsLemmas__option_t) const
{
  return d_holder->stringInferAsLemmas;
}
template <> bool Options::wasSetByUser(options::stringInferAsLemmas__option_t) const
{
  return d_holder->stringInferAsLemmas__setByUser__;
}
template <> const options::stringInferSym__option_t::type& Options::operator[](
    options::stringInferSym__option_t) const
{
  return d_holder->stringInferSym;
}
template <> bool Options::wasSetByUser(options::stringInferSym__option_t) const
{
  return d_holder->stringInferSym__setByUser__;
}
template <> const options::stringIgnNegMembership__option_t::type& Options::operator[](
    options::stringIgnNegMembership__option_t) const
{
  return d_holder->stringIgnNegMembership;
}
template <> bool Options::wasSetByUser(options::stringIgnNegMembership__option_t) const
{
  return d_holder->stringIgnNegMembership__setByUser__;
}
template <> const options::stringLazyPreproc__option_t::type& Options::operator[](
    options::stringLazyPreproc__option_t) const
{
  return d_holder->stringLazyPreproc;
}
template <> bool Options::wasSetByUser(options::stringLazyPreproc__option_t) const
{
  return d_holder->stringLazyPreproc__setByUser__;
}
template <> const options::stringLenNorm__option_t::type& Options::operator[](
    options::stringLenNorm__option_t) const
{
  return d_holder->stringLenNorm;
}
template <> bool Options::wasSetByUser(options::stringLenNorm__option_t) const
{
  return d_holder->stringLenNorm__setByUser__;
}
template <> const options::stringLenPropCsp__option_t::type& Options::operator[](
    options::stringLenPropCsp__option_t) const
{
  return d_holder->stringLenPropCsp;
}
template <> bool Options::wasSetByUser(options::stringLenPropCsp__option_t) const
{
  return d_holder->stringLenPropCsp__setByUser__;
}
template <> const options::stringMinPrefixExplain__option_t::type& Options::operator[](
    options::stringMinPrefixExplain__option_t) const
{
  return d_holder->stringMinPrefixExplain;
}
template <> bool Options::wasSetByUser(options::stringMinPrefixExplain__option_t) const
{
  return d_holder->stringMinPrefixExplain__setByUser__;
}
template <> const options::stdPrintASCII__option_t::type& Options::operator[](
    options::stdPrintASCII__option_t) const
{
  return d_holder->stdPrintASCII;
}
template <> bool Options::wasSetByUser(options::stdPrintASCII__option_t) const
{
  return d_holder->stdPrintASCII__setByUser__;
}
template <> void Options::set(
    options::stringProcessLoopMode__option_t,
    const options::stringProcessLoopMode__option_t::type& x)
{
  d_holder->stringProcessLoopMode = x;
}
template <> const options::stringProcessLoopMode__option_t::type& Options::operator[](
    options::stringProcessLoopMode__option_t) const
{
  return d_holder->stringProcessLoopMode;
}
template <> bool Options::wasSetByUser(options::stringProcessLoopMode__option_t) const
{
  return d_holder->stringProcessLoopMode__setByUser__;
}
template <> const options::stringRExplainLemmas__option_t::type& Options::operator[](
    options::stringRExplainLemmas__option_t) const
{
  return d_holder->stringRExplainLemmas;
}
template <> bool Options::wasSetByUser(options::stringRExplainLemmas__option_t) const
{
  return d_holder->stringRExplainLemmas__setByUser__;
}


namespace options {

struct regExpElim__option_t regExpElim;
struct regExpElimAgg__option_t regExpElimAgg;
struct stringRegExpInterMode__option_t stringRegExpInterMode;
struct stringCheckEntailLen__option_t stringCheckEntailLen;
struct stringEager__option_t stringEager;
struct stringEagerLen__option_t stringEagerLen;
struct stringExp__option_t stringExp;
struct stringFlatForms__option_t stringFlatForms;
struct stringFMF__option_t stringFMF;
struct stringGuessModel__option_t stringGuessModel;
struct stringInferAsLemmas__option_t stringInferAsLemmas;
struct stringInferSym__option_t stringInferSym;
struct stringIgnNegMembership__option_t stringIgnNegMembership;
struct stringLazyPreproc__option_t stringLazyPreproc;
struct stringLenNorm__option_t stringLenNorm;
struct stringLenPropCsp__option_t stringLenPropCsp;
struct stringMinPrefixExplain__option_t stringMinPrefixExplain;
struct stdPrintASCII__option_t stdPrintASCII;
struct stringProcessLoopMode__option_t stringProcessLoopMode;
struct stringRExplainLemmas__option_t stringRExplainLemmas;


std::ostream&
operator<<(std::ostream& os, RegExpInterMode mode)
{
  os << "RegExpInterMode::";
  switch(mode) {
    case RegExpInterMode::ALL:
      os << "ALL";
      break;
    case RegExpInterMode::CONSTANT:
      os << "CONSTANT";
      break;
    case RegExpInterMode::ONE_CONSTANT:
      os << "ONE_CONSTANT";
      break;
    case RegExpInterMode::NONE:
      os << "NONE";
      break;
    default:
        Unreachable();
  }
  return os;
}

RegExpInterMode
stringToRegExpInterMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "all")
  {
    return RegExpInterMode::ALL;
  }
  else if (optarg == "constant")
  {
    return RegExpInterMode::CONSTANT;
  }
  else if (optarg == "one-constant")
  {
    return RegExpInterMode::ONE_CONSTANT;
  }
  else if (optarg == "none")
  {
    return RegExpInterMode::NONE;
  }
  else if (optarg == "help")
  {
    puts("Regular expression intersection modes.\n"
         "Available modes for --re-inter-mode are:\n"
         "+ all\n"
         "  Compute intersections for all regular expressions.\n"
         "+ constant (default)\n"
         "  Compute intersections only between regular expressions that do not contain\n"
         "  re.allchar or re.range.\n"
         "+ one-constant\n"
         "  Compute intersections only between regular expressions such that at least one\n"
         "  side does not contain re.allchar or re.range.\n"
         "+ none\n"
         "  Do not compute intersections for regular expressions.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --re-inter-mode: `") +
                          optarg + "'.  Try --re-inter-mode=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, ProcessLoopMode mode)
{
  os << "ProcessLoopMode::";
  switch(mode) {
    case ProcessLoopMode::FULL:
      os << "FULL";
      break;
    case ProcessLoopMode::SIMPLE:
      os << "SIMPLE";
      break;
    case ProcessLoopMode::SIMPLE_ABORT:
      os << "SIMPLE_ABORT";
      break;
    case ProcessLoopMode::NONE:
      os << "NONE";
      break;
    case ProcessLoopMode::ABORT:
      os << "ABORT";
      break;
    default:
        Unreachable();
  }
  return os;
}

ProcessLoopMode
stringToProcessLoopMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "full")
  {
    return ProcessLoopMode::FULL;
  }
  else if (optarg == "simple")
  {
    return ProcessLoopMode::SIMPLE;
  }
  else if (optarg == "simple-abort")
  {
    return ProcessLoopMode::SIMPLE_ABORT;
  }
  else if (optarg == "none")
  {
    return ProcessLoopMode::NONE;
  }
  else if (optarg == "abort")
  {
    return ProcessLoopMode::ABORT;
  }
  else if (optarg == "help")
  {
    puts("Loop processing modes.\n"
         "Available modes for --strings-process-loop-mode are:\n"
         "+ full (default)\n"
         "  Perform full processing of looping word equations.\n"
         "+ simple\n"
         "  Omit normal loop breaking (default with --strings-fmf).\n"
         "+ simple-abort\n"
         "  Abort when normal loop breaking is required.\n"
         "+ none\n"
         "  Omit loop processing.\n"
         "+ abort\n"
         "  Abort if looping word equations are encountered.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --strings-process-loop-mode: `") +
                          optarg + "'.  Try --strings-process-loop-mode=help.");
  }
}


}  // namespace options
}  // namespace CVC4
