/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::setsExt__option_t::type& Options::operator[](
    options::setsExt__option_t) const
{
  return d_holder->setsExt;
}
template <> bool Options::wasSetByUser(options::setsExt__option_t) const
{
  return d_holder->setsExt__setByUser__;
}
template <> const options::setsInferAsLemmas__option_t::type& Options::operator[](
    options::setsInferAsLemmas__option_t) const
{
  return d_holder->setsInferAsLemmas;
}
template <> bool Options::wasSetByUser(options::setsInferAsLemmas__option_t) const
{
  return d_holder->setsInferAsLemmas__setByUser__;
}
template <> const options::setsProxyLemmas__option_t::type& Options::operator[](
    options::setsProxyLemmas__option_t) const
{
  return d_holder->setsProxyLemmas;
}
template <> bool Options::wasSetByUser(options::setsProxyLemmas__option_t) const
{
  return d_holder->setsProxyLemmas__setByUser__;
}


namespace options {

struct setsExt__option_t setsExt;
struct setsInferAsLemmas__option_t setsInferAsLemmas;
struct setsProxyLemmas__option_t setsProxyLemmas;



}  // namespace options
}  // namespace CVC4
