/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__PARSER_H
#define CVC4__OPTIONS__PARSER_H

#include "options/options.h"




#define CVC4_OPTIONS__PARSER__FOR_OPTION_HOLDER \
  filesystemAccess__option_t::type filesystemAccess;\
  bool filesystemAccess__setByUser__; \
  forceLogicString__option_t::type forceLogicString;\
  bool forceLogicString__setByUser__; \
  globalDeclarations__option_t::type globalDeclarations;\
  bool globalDeclarations__setByUser__; \
  memoryMap__option_t::type memoryMap;\
  bool memoryMap__setByUser__; \
  semanticChecks__option_t::type semanticChecks;\
  bool semanticChecks__setByUser__; \
  strictParsing__option_t::type strictParsing;\
  bool strictParsing__setByUser__;


namespace CVC4 {

namespace options {



extern struct CVC4_PUBLIC filesystemAccess__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} filesystemAccess CVC4_PUBLIC;
extern struct CVC4_PUBLIC forceLogicString__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
} forceLogicString CVC4_PUBLIC;
extern struct CVC4_PUBLIC globalDeclarations__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} globalDeclarations CVC4_PUBLIC;
extern struct CVC4_PUBLIC memoryMap__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} memoryMap CVC4_PUBLIC;
extern struct CVC4_PUBLIC semanticChecks__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} semanticChecks CVC4_PUBLIC;
extern struct CVC4_PUBLIC strictParsing__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} strictParsing CVC4_PUBLIC;

}  // namespace options

template <> const options::filesystemAccess__option_t::type& Options::operator[](
    options::filesystemAccess__option_t) const;
template <> bool Options::wasSetByUser(options::filesystemAccess__option_t) const;
template <> void Options::assignBool(
    options::filesystemAccess__option_t,
    std::string option,
    bool value);
template <> const options::forceLogicString__option_t::type& Options::operator[](
    options::forceLogicString__option_t) const;
template <> bool Options::wasSetByUser(options::forceLogicString__option_t) const;
template <> void Options::assign(
    options::forceLogicString__option_t,
    std::string option,
    std::string value);
template <> const options::globalDeclarations__option_t::type& Options::operator[](
    options::globalDeclarations__option_t) const;
template <> bool Options::wasSetByUser(options::globalDeclarations__option_t) const;
template <> void Options::assignBool(
    options::globalDeclarations__option_t,
    std::string option,
    bool value);
template <> const options::memoryMap__option_t::type& Options::operator[](
    options::memoryMap__option_t) const;
template <> bool Options::wasSetByUser(options::memoryMap__option_t) const;
template <> void Options::assignBool(
    options::memoryMap__option_t,
    std::string option,
    bool value);
template <> const options::semanticChecks__option_t::type& Options::operator[](
    options::semanticChecks__option_t) const;
template <> bool Options::wasSetByUser(options::semanticChecks__option_t) const;
template <> void Options::assignBool(
    options::semanticChecks__option_t,
    std::string option,
    bool value);
template <> const options::strictParsing__option_t::type& Options::operator[](
    options::strictParsing__option_t) const;
template <> bool Options::wasSetByUser(options::strictParsing__option_t) const;
template <> void Options::assignBool(
    options::strictParsing__option_t,
    std::string option,
    bool value);


namespace options {

inline filesystemAccess__option_t::type filesystemAccess__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool filesystemAccess__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline forceLogicString__option_t::type forceLogicString__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool forceLogicString__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline globalDeclarations__option_t::type globalDeclarations__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool globalDeclarations__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline memoryMap__option_t::type memoryMap__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool memoryMap__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline semanticChecks__option_t::type semanticChecks__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool semanticChecks__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline strictParsing__option_t::type strictParsing__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool strictParsing__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__PARSER_H */
