/*
 * // Copyright (c) Radzivon Bartoshyk 7/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

pub(crate) static POWF_R2: [u64; 193] = [
    0x3ff0101000000000,
    0x3ff00fd000000000,
    0x3ff00f9000000000,
    0x3ff00f5000000000,
    0x3ff00f1000000000,
    0x3ff00ed000000000,
    0x3ff00e9000000000,
    0x3ff00e5000000000,
    0x3ff00e1000000000,
    0x3ff00dd000000000,
    0x3ff00d9000000000,
    0x3ff00d5000000000,
    0x3ff00d1000000000,
    0x3ff00cd000000000,
    0x3ff00c9000000000,
    0x3ff00c5000000000,
    0x3ff00c1000000000,
    0x3ff00bd000000000,
    0x3ff00b9000000000,
    0x3ff00b4000000000,
    0x3ff00b0000000000,
    0x3ff00ac000000000,
    0x3ff00a8000000000,
    0x3ff00a4000000000,
    0x3ff00a0000000000,
    0x3ff009c000000000,
    0x3ff0098000000000,
    0x3ff0094000000000,
    0x3ff0090000000000,
    0x3ff008c000000000,
    0x3ff0088000000000,
    0x3ff0084000000000,
    0x3ff0080000000000,
    0x3ff007c000000000,
    0x3ff0078000000000,
    0x3ff0074000000000,
    0x3ff0070000000000,
    0x3ff006c000000000,
    0x3ff0068000000000,
    0x3ff0064000000000,
    0x3ff0060000000000,
    0x3ff005c000000000,
    0x3ff0058000000000,
    0x3ff0054000000000,
    0x3ff0050000000000,
    0x3ff004c000000000,
    0x3ff0048000000000,
    0x3ff0044000000000,
    0x3ff0040000000000,
    0x3ff003c000000000,
    0x3ff0038000000000,
    0x3ff0034000000000,
    0x3ff0030000000000,
    0x3ff002c000000000,
    0x3ff0028000000000,
    0x3ff0024000000000,
    0x3ff0020000000000,
    0x3ff001c000000000,
    0x3ff0018000000000,
    0x3ff0014000000000,
    0x3ff0010000000000,
    0x3ff000c000000000,
    0x3ff0008000000000,
    0x3ff0004000000000,
    0x3ff0000000000000,
    0x3fefff8000000000,
    0x3fefff0000000000,
    0x3feffe8000000000,
    0x3feffe0000000000,
    0x3feffd8000000000,
    0x3feffd0000000000,
    0x3feffc8000000000,
    0x3feffc0000000000,
    0x3feffb8000000000,
    0x3feffb0000000000,
    0x3feffa8000000000,
    0x3feffa0000000000,
    0x3feff98000000000,
    0x3feff90000000000,
    0x3feff88000000000,
    0x3feff80000000000,
    0x3feff78000000000,
    0x3feff70000000000,
    0x3feff68000000000,
    0x3feff60000000000,
    0x3feff58000000000,
    0x3feff50000000000,
    0x3feff48000000000,
    0x3feff40000000000,
    0x3feff38000000000,
    0x3feff30000000000,
    0x3feff28000000000,
    0x3feff20000000000,
    0x3feff18000000000,
    0x3feff10000000000,
    0x3feff08000000000,
    0x3feff00000000000,
    0x3fefef8000000000,
    0x3fefef0000000000,
    0x3fefee8000000000,
    0x3fefee0000000000,
    0x3fefed8000000000,
    0x3fefed0000000000,
    0x3fefec8000000000,
    0x3fefec0000000000,
    0x3fefeb8000000000,
    0x3fefeb0000000000,
    0x3fefea8000000000,
    0x3fefea0000000000,
    0x3fefe98000000000,
    0x3fefe92000000000,
    0x3fefe8a000000000,
    0x3fefe82000000000,
    0x3fefe7a000000000,
    0x3fefe72000000000,
    0x3fefe6a000000000,
    0x3fefe62000000000,
    0x3fefe5a000000000,
    0x3fefe52000000000,
    0x3fefe4a000000000,
    0x3fefe42000000000,
    0x3fefe3a000000000,
    0x3fefe32000000000,
    0x3fefe2a000000000,
    0x3fefe22000000000,
    0x3fefe1a000000000,
    0x3fefe12000000000,
    0x3fefe0a000000000,
    0x3fefe02000000000,
    0x3fefdfa000000000,
    0x3fefdf2000000000,
    0x3fefdea000000000,
    0x3fefde2000000000,
    0x3fefdda000000000,
    0x3fefdd2000000000,
    0x3fefdca000000000,
    0x3fefdc2000000000,
    0x3fefdba000000000,
    0x3fefdb2000000000,
    0x3fefdaa000000000,
    0x3fefda2000000000,
    0x3fefd9a000000000,
    0x3fefd92000000000,
    0x3fefd8c000000000,
    0x3fefd84000000000,
    0x3fefd7c000000000,
    0x3fefd74000000000,
    0x3fefd6c000000000,
    0x3fefd64000000000,
    0x3fefd5c000000000,
    0x3fefd54000000000,
    0x3fefd4c000000000,
    0x3fefd44000000000,
    0x3fefd3c000000000,
    0x3fefd34000000000,
    0x3fefd2c000000000,
    0x3fefd24000000000,
    0x3fefd1c000000000,
    0x3fefd14000000000,
    0x3fefd0c000000000,
    0x3fefd04000000000,
    0x3fefcfc000000000,
    0x3fefcf4000000000,
    0x3fefcec000000000,
    0x3fefce4000000000,
    0x3fefcdc000000000,
    0x3fefcd6000000000,
    0x3fefcce000000000,
    0x3fefcc6000000000,
    0x3fefcbe000000000,
    0x3fefcb6000000000,
    0x3fefcae000000000,
    0x3fefca6000000000,
    0x3fefc9e000000000,
    0x3fefc96000000000,
    0x3fefc8e000000000,
    0x3fefc86000000000,
    0x3fefc7e000000000,
    0x3fefc76000000000,
    0x3fefc6e000000000,
    0x3fefc66000000000,
    0x3fefc5e000000000,
    0x3fefc56000000000,
    0x3fefc4e000000000,
    0x3fefc46000000000,
    0x3fefc40000000000,
    0x3fefc38000000000,
    0x3fefc30000000000,
    0x3fefc28000000000,
    0x3fefc20000000000,
    0x3fefc18000000000,
    0x3fefc10000000000,
    0x3fefc08000000000,
];

pub(crate) static LOG2_R_TD: [(u64, u64, u64); 128] = [
    (0x0000000000000000, 0x0000000000000000, 0x0000000000000000),
    (0x3b084a2c615b70ad, 0xbe6177c23362928c, 0x3f872c8000000000),
    (0xbb3f27b820fd03ea, 0xbe9179e0caa9c9ab, 0x3f97440000000000),
    (0xbb2f27ef487c8f34, 0xbe8c6cea541f5b70, 0x3fa184c000000000),
    (0xbb3e3f80fbc71454, 0xbe966c4d4e554434, 0x3fa773a000000000),
    (0xbb09f8ef14d5f6ee, 0xbe770700a00fdd55, 0x3fad6ec000000000),
    (0x3b2452bbce7398c1, 0x3e853002a4e86631, 0x3fb1bb3000000000),
    (0xbae990555535afd0, 0x3e6fcd15f101c142, 0x3fb4c56000000000),
    (0x3b1447e30ad393ee, 0x3e925b3eed319ced, 0x3fb7d60000000000),
    (0x3b3b7759da88a2da, 0xbe94195120d8486f, 0x3fb960d000000000),
    (0x3b1cee7766ece702, 0x3e845b878e27d0d9, 0x3fbc7b5000000000),
    (0xbb2a55c745ecdc2f, 0x3e9770744593a4cb, 0x3fbf9c9000000000),
    (0x3b2f7ec992caa67f, 0x3e9c673032495d24, 0x3fc097e000000000),
    (0xbb2433638c6ece3e, 0xbe91eaa65b49696e, 0x3fc22db000000000),
    (0x3b358f27b6518824, 0x3e9b2866f2850b22, 0x3fc3c6f800000000),
    (0xbb086bdcfdfd4a4c, 0x3e68ee37cd2ea9d3, 0x3fc494f800000000),
    (0xbafff7044a68a7fa, 0x3e77e86f9c2154fb, 0x3fc633a800000000),
    (0xbaeaa21694561327, 0x3e58e3cfc25f0ce6, 0x3fc7046000000000),
    (0xba8d209f2d4239c6, 0x3e357f7a64ccd537, 0x3fc8a89800000000),
    (0xbb3a55e97e60e632, 0xbe9a761c09fbd2ae, 0x3fc97c2000000000),
    (0x3b3261179225541e, 0x3e924bea9a2c66f3, 0x3fcb260000000000),
    (0xbad08fa30510fca9, 0xbe660002ccfe43f5, 0x3fcbfc6800000000),
    (0xbb363ec8d56242f9, 0x3e969f220e97f22c, 0x3fcdac2000000000),
    (0x3b38bcdaf0534365, 0xbe96164f64c210e0, 0x3fce858000000000),
    (0x3b11003282896056, 0xbe70c1678ae89767, 0x3fd01d9c00000000),
    (0x3b101bcc7025fa92, 0xbe9f26a05c813d57, 0x3fd08bd000000000),
    (0xbaffe8a8648e9ebc, 0x3e74d8fc561c8d44, 0x3fd169c000000000),
    (0x3b008dfb23650c75, 0xbe9362ad8f7ca2d0, 0x3fd1d98400000000),
    (0xbb0f8d5a89861a5e, 0x3e92b13cd6c4d042, 0x3fd249cc00000000),
    (0xbb3a1c872983511e, 0xbe91c8f11979a5db, 0x3fd32c0000000000),
    (0x3b2e8e21bff3336b, 0x3e8c2ab3edefe569, 0x3fd39de800000000),
    (0x3affd1994fb2c4a1, 0x3e57c3eca28e69ca, 0x3fd4106000000000),
    (0x3af6b94b51cf76b1, 0xbe734c4e99e1c6c6, 0x3fd4f6fc00000000),
    (0xbb331d55da1d0f66, 0xbe9194a871b63619, 0x3fd56b2400000000),
    (0xbb2378b22691e28b, 0x3e8e3dd5c1c885ae, 0x3fd5dfdc00000000),
    (0x3ac99e302970e411, 0xbe86ccf3b1129b7c, 0x3fd6552c00000000),
    (0x3ad20164a049664d, 0xbe82f346e2bf924b, 0x3fd6cb1000000000),
    (0xbb2d14aac4d864c3, 0xbe8fa61aaa59c1d8, 0x3fd7b8a000000000),
    (0x3b0496ab4e4b293f, 0x3e990c11fd32a3ab, 0x3fd8304c00000000),
    (0xba9d209f2d4239c6, 0x3e457f7a64ccd537, 0x3fd8a89800000000),
    (0x3aeeae3326327bab, 0x3e4249ba76fee235, 0x3fd9218000000000),
    (0x3b2fa05bddfded8c, 0xbe8aad2729b21ae5, 0x3fd99b0800000000),
    (0xbb2624140d175ba2, 0x3e971810a5e18180, 0x3fda8ff800000000),
    (0x3aef1c5160c515c1, 0xbe46172fe015e13c, 0x3fdb0b6800000000),
    (0xbb086a6204eec8c0, 0x3e75ec6c1bfbf89a, 0x3fdb877c00000000),
    (0x3b1718f761dd3915, 0x3e7678bf6cdedf51, 0x3fdc043800000000),
    (0xbb3d4ee66c3700e4, 0x3e9c2d45fe43895e, 0x3fdc819c00000000),
    (0xbb27d14533586306, 0xbe99ee52ed49d71d, 0x3fdcffb000000000),
    (0x3ae5ce9fb5a7bb5b, 0x3e45786af187a96b, 0x3fdd7e6c00000000),
    (0xbb2ae6face57ad3b, 0x3e83ab0dc56138c9, 0x3fddfdd800000000),
    (0x3b15ac93b443d55f, 0x3e9fe538ab34efb5, 0x3fde7df400000000),
    (0x3b3f1753e0ae1e8f, 0xbe9e4fee07aa4b68, 0x3fdefec800000000),
    (0x3b3cdfd4c297069b, 0xbe9172f32fe67287, 0x3fdf804c00000000),
    (0x3b097a0e8f3ba742, 0xbe99a83ff9ab9cc8, 0x3fe0014400000000),
    (0xbb1800450f5b2357, 0xbe968cb06cece193, 0x3fe042be00000000),
    (0xbb1a839041241fe7, 0x3e98cd71ddf82e20, 0x3fe0849400000000),
    (0x3b1ed0b8eeccca86, 0x3e95e18ab2df3ae6, 0x3fe0c6ca00000000),
    (0x3b03dd41df9689b3, 0x3e65dee4d9d8a273, 0x3fe1096000000000),
    (0xbad990555535afd0, 0x3e5fcd15f101c142, 0x3fe14c5600000000),
    (0xbb21773d02c9055c, 0xbe82474b0f992ba1, 0x3fe18fae00000000),
    (0xbb14aeef330c53c1, 0x3e74b5a92a606047, 0x3fe1d36800000000),
    (0x3b28e6ff749ebacb, 0x3e916186fcf54bbd, 0x3fe2178600000000),
    (0x3abc09d761c548eb, 0x3e418efabeb7d722, 0x3fe25c0a00000000),
    (0x3b1aaa73a428e1e4, 0xbe7e5fc7d238691d, 0x3fe2a0f400000000),
    (0xbb0af2f3d8b63fba, 0x3e9f5809faf6283c, 0x3fe2e64400000000),
    (0xbb0af2f3d8b63fba, 0x3e9f5809faf6283c, 0x3fe2e64400000000),
    (0x3b278de359f2bb88, 0x3e9c6e1dcd0cb449, 0x3fe32bfe00000000),
    (0xbb3415ae1a715618, 0x3e976e0e8f74b4d5, 0x3fe3722200000000),
    (0xbb04991b5375621f, 0xbe7cb82c89692d99, 0x3fe3b8b200000000),
    (0xbb3827d37deb2236, 0xbe963161c5432aeb, 0x3fe3ffae00000000),
    (0x3b29576edac01c78, 0x3e9458104c41b901, 0x3fe4471600000000),
    (0x3b29576edac01c78, 0x3e9458104c41b901, 0x3fe4471600000000),
    (0xbb205a27b81e2219, 0xbe9cd9d0cde578d5, 0x3fe48ef000000000),
    (0x3ad237616778b4ba, 0x3e5b9884591add87, 0x3fe4d73800000000),
    (0x3b33b7d7e5d148bb, 0x3e9c6042978605ff, 0x3fe51ff200000000),
    (0xbb0cc3f936a5977c, 0xbe9fc4c96b37dcf6, 0x3fe5692200000000),
    (0x3ac20164a049664d, 0xbe72f346e2bf924b, 0x3fe5b2c400000000),
    (0x3ac20164a049664d, 0xbe72f346e2bf924b, 0x3fe5b2c400000000),
    (0xbb2a212919a92f7a, 0x3e9c4e4fbb68a4d1, 0x3fe5fcdc00000000),
    (0xbb2b64b03f7230dd, 0xbe89d499bd9b3226, 0x3fe6476e00000000),
    (0xbb21ec6379e6e3b9, 0xbe8f89b355ede26f, 0x3fe6927800000000),
    (0xbb21ec6379e6e3b9, 0xbe8f89b355ede26f, 0x3fe6927800000000),
    (0xbb14ba44c03bfbbd, 0x3e753c7e319f6e92, 0x3fe6ddfc00000000),
    (0xbb2c36fc650d030f, 0xbe9b291f070528c7, 0x3fe729fe00000000),
    (0xbaf69e5693a7f067, 0x3e62967a451a7b48, 0x3fe7767c00000000),
    (0xbaf69e5693a7f067, 0x3e62967a451a7b48, 0x3fe7767c00000000),
    (0x3b36598aae91499a, 0x3e9244fcff690fce, 0x3fe7c37a00000000),
    (0x3b299d61ec432837, 0x3e846fd97f5dc572, 0x3fe810fa00000000),
    (0x3b299d61ec432837, 0x3e846fd97f5dc572, 0x3fe810fa00000000),
    (0x3b3855c42078f81b, 0xbe9f3a7352663e50, 0x3fe85efe00000000),
    (0xbb259408e8151070, 0x3e8b3cda690370b5, 0x3fe8ad8400000000),
    (0xbb259408e8151070, 0x3e8b3cda690370b5, 0x3fe8ad8400000000),
    (0x3b133b318085e50a, 0x3e83226b211bf1d9, 0x3fe8fc9200000000),
    (0x3b0343fe7c9cb4ae, 0x3e8d24b136c101ee, 0x3fe94c2800000000),
    (0x3b0343fe7c9cb4ae, 0x3e8d24b136c101ee, 0x3fe94c2800000000),
    (0xbb3d19522e56fe60, 0x3e97c40c7907e82a, 0x3fe99c4800000000),
    (0xbb223b9d8ea55c3e, 0xbe9e81781d97ee91, 0x3fe9ecf600000000),
    (0xbb223b9d8ea55c3e, 0xbe9e81781d97ee91, 0x3fe9ecf600000000),
    (0x3b1829440c24aeb6, 0xbe96a77813f94e01, 0x3fea3e3000000000),
    (0xbb3624140d175ba2, 0xbe91cfdeb43cfd00, 0x3fea8ffa00000000),
    (0xbb3624140d175ba2, 0xbe91cfdeb43cfd00, 0x3fea8ffa00000000),
    (0x3b2afa6f024fb045, 0xbe8f983f74d3138f, 0x3feae25600000000),
    (0xbb1603ad3a5d326d, 0xbe8e278ae1a1f51f, 0x3feb354600000000),
    (0xbb1603ad3a5d326d, 0xbe8e278ae1a1f51f, 0x3feb354600000000),
    (0xbb20c1e0e5855d6a, 0xbe897552b7b5ea45, 0x3feb88cc00000000),
    (0xbb20c1e0e5855d6a, 0xbe897552b7b5ea45, 0x3feb88cc00000000),
    (0x3b1c817ad56baa16, 0xbe719b4f3c72c4f8, 0x3febdcea00000000),
    (0x3b244c47ac1bf62b, 0x3e8f7402d26f1a12, 0x3fec31a200000000),
    (0x3b244c47ac1bf62b, 0x3e8f7402d26f1a12, 0x3fec31a200000000),
    (0xbb169b9465eae1e6, 0xbe82056d5dd31d96, 0x3fec86f800000000),
    (0xbb169b9465eae1e6, 0xbe82056d5dd31d96, 0x3fec86f800000000),
    (0xbb024a6d9d1d1904, 0xbe76e46335aae723, 0x3fecdcec00000000),
    (0xbb33826144575ac4, 0xbe9beb244c59f331, 0x3fed338200000000),
    (0xbb33826144575ac4, 0xbe9beb244c59f331, 0x3fed338200000000),
    (0x3aedbc96b3b12b25, 0x3e416c071e93fd97, 0x3fed8aba00000000),
    (0x3aedbc96b3b12b25, 0x3e416c071e93fd97, 0x3fed8aba00000000),
    (0x3b268a8ccdbd1f33, 0x3e9d8175819530c2, 0x3fede29800000000),
    (0x3b268a8ccdbd1f33, 0x3e9d8175819530c2, 0x3fede29800000000),
    (0x3b0e586711df5ea1, 0x3e851bd552842c1c, 0x3fee3b2000000000),
    (0x3b0e586711df5ea1, 0x3e851bd552842c1c, 0x3fee3b2000000000),
    (0xbb0bc25adf042483, 0x3e9914e204f19d94, 0x3fee945200000000),
    (0xbb0bc25adf042483, 0x3e9914e204f19d94, 0x3fee945200000000),
    (0x3b3d7d82b65c5686, 0x3e9c55d997da24fd, 0x3feeee3200000000),
    (0x3b3d7d82b65c5686, 0x3e9c55d997da24fd, 0x3feeee3200000000),
    (0xbb23f108c0857ca3, 0xbe9685c2d2298a6e, 0x3fef48c400000000),
    (0xbb23f108c0857ca3, 0xbe9685c2d2298a6e, 0x3fef48c400000000),
    (0xbb1bd800bca7a221, 0x3e97a4887bd74039, 0x3fefa40600000000),
    (0x0000000000000000, 0x0000000000000000, 0x3ff0000000000000),
];

// Look up table for the second range reduction step:
// Generated by Sollya with:
// > for i from -64 to 128 do {
//     r = 2^-16 * nearestint(2^16 / (1 + i * 2^-14) );
//     a = -log2(r);
//     b = round(a, D, RN);
//     c = round(a - b, D, RN);
//     print("{", c, ", ", b, "},");
//    };
pub(crate) static LOG2_R2_DD: [(u64, u64); 193] = [
    (0x3c1ff25180953e64, 0xbf7720c2ab2312a9),
    (0xbc115ffd79560d8f, 0xbf76c4c92b1478ff),
    (0x3c1b8d6d6f2e3579, 0xbf7668ce3c873549),
    (0xbc15bfc3f0d5ef71, 0xbf760cd1df6fde91),
    (0xbbfd1f7a8777984a, 0xbf75b0d413c30b5e),
    (0x3bd8e858515b8343, 0xbf7554d4d97551ab),
    (0x3c1e165c4014c1f2, 0xbf74f8d4307b46ec),
    (0x3c00f84b2cc14c7e, 0xbf749cd218c9800b),
    (0x3c1de618ed0db9a6, 0xbf7440ce9254916c),
    (0xbc1f6b8587e64f22, 0xbf73e4c99d110ee7),
    (0xbbf7f793c84cfa63, 0xbf7388c338f38bd0),
    (0xbbe7d7ecf6258c9a, 0xbf732cbb65f09aee),
    (0xbc1810bc5ac188f5, 0xbf72d0b223fcce81),
    (0xbc1950035fc5b67c, 0xbf7274a7730cb841),
    (0x3c14f47f3048cdad, 0xbf72189b5314e95d),
    (0x3bb269519861e298, 0xbf71bc8dc409f279),
    (0xbc15c2b0a46a7e2f, 0xbf71607ec5e063b3),
    (0x3c05001ac8f0bda8, 0xbf71046e588ccca0),
    (0x3c1106f246af5d41, 0xbf70a85c7c03bc4a),
    (0x3bd82a00583b34ba, 0xbf70354423e3c666),
    (0x3beb6f37deb31370, 0xbf6fb25e19f11aec),
    (0xbc044a2140444811, 0xbf6efa310d6550ec),
    (0x3c0f5e68a763133f, 0xbf6e4201220d4858),
    (0x3c0692083115f0b9, 0xbf6d89ce57d219a6),
    (0x3c0144bb17b9ac9c, 0xbf6cd198ae9cdc3d),
    (0x3c0ee7f086d32c05, 0xbf6c19602656a671),
    (0xbc0d4f1167538dbe, 0xbf6b6124bee88d82),
    (0x3c07df8d226c67e0, 0xbf6aa8e6783ba5a2),
    (0x3c060545d61b9512, 0xbf69f0a5523901eb),
    (0x3c054c99c2917020, 0xbf6938614cc9b468),
    (0xbbfa7e678d7280de, 0xbf68801a67d6ce10),
    (0xbbf6d419bbeb223a, 0xbf67c7d0a3495ec9),
    (0x3bfce2b9892e27e9, 0xbf670f83ff0a7565),
    (0xbc0a4db4eff7bd61, 0xbf6657347b031fa2),
    (0x3c05bb04682fab82, 0xbf659ee2171c6a2f),
    (0xbbf78b8bfe6a3ade, 0xbf64e68cd33f60a3),
    (0x3c0574c3ce9b89b1, 0xbf642e34af550d87),
    (0x3c008fb216647b7b, 0xbf6375d9ab467a4d),
    (0x3bded5a50e7b919c, 0xbf62bd7bc6fcaf56),
    (0x3c091ad7a23f86fe, 0xbf62051b0260b3f0),
    (0x3bf3ab2c932b8b0a, 0xbf614cb75d5b8e54),
    (0xbc0c63bcdf120f7a, 0xbf609450d7d643a9),
    (0x3bf8af8c4ab4e82d, 0xbf5fb7cee373b008),
    (0x3bea52c2ca9d8b9b, 0xbf5e46f655de9cc6),
    (0xbbf460b177a58742, 0xbf5cd61806bf5166),
    (0x3bd611089de8d12a, 0xbf5b6533f5e7cf9b),
    (0xbba4209853cee70c, 0xbf59f44a232a16ee),
    (0x3bf964e032541a28, 0xbf58835a8e5824c3),
    (0xbbdfa9f94392637b, 0xbf5712653743f454),
    (0xbbf3293693721a53, 0xbf55a16a1dbf7eb6),
    (0xbbb6e2af03c83c6e, 0xbf543069419cbad5),
    (0xbbeb5f05b9d5bd29, 0xbf52bf62a2ad9d74),
    (0x3bf3db883c072f72, 0xbf514e5640c41930),
    (0xbbba675a1c045304, 0xbf4fba8837643cf6),
    (0x3bd3b9c2aeb00068, 0xbf4cd85866933743),
    (0xbbd2911a381901eb, 0xbf49f61d0eb8f98b),
    (0xbbb5ea75a74def03, 0xbf4713d62f7957c3),
    (0xbbc305b92f93ffe0, 0xbf443183c878218d),
    (0x3bbb7c8c8dd40d35, 0xbf414f25d959223a),
    (0x3bddc915d58a62f6, 0xbf3cd978c3804191),
    (0x3bdc7bc3fe53cd94, 0xbf37148ec2a1bfc9),
    (0xbbc427ce595cc53c, 0xbf314f8daf5e3bcf),
    (0xbbcd523885ac824c, 0xbf2714eb11fa5363),
    (0xbba945957f63330a, 0xbf1715193b17d35d),
    (0x0000000000000000, 0x0000000000000000),
    (0xbb988fb2ea8bf9ea, 0x3f17157590356aee),
    (0xbbb5aeaee345d04e, 0x3f2715a3bc3593d5),
    (0xbbd7fce430230132, 0x3f31505d6ee104c5),
    (0xbb99a480f204ff09, 0x3f3716001718cb2b),
    (0xbbb00e7233f2d8bd, 0x3f3cdbb9d77ae5a8),
    (0x3bc09d379fa18c5d, 0x3f4150c5586012b8),
    (0x3beb6b9d90a104d3, 0x3f4433b951d0b231),
    (0x3be4d9a3ea651885, 0x3f4716b8d86bc285),
    (0xbbc7590b3a76f0f9, 0x3f49f9c3ec8db94f),
    (0x3bef183ca5b21bfe, 0x3f4cdcda8e93107f),
    (0xbbda7e3465ba1270, 0x3f4fbffcbed8465f),
    (0xbbf7821f738d1221, 0x3f5151953edceec6),
    (0x3be3bb4c0fb95359, 0x3f52c331e5ca2e7d),
    (0x3bf236028e962f80, 0x3f5434d4546227fc),
    (0x3bdaaaa64d30f184, 0x3f55a67c8ad32315),
    (0xbbfa821b7cc57a7a, 0x3f57182a894b69c6),
    (0xbbf13d9d78aace21, 0x3f5889de4ff94838),
    (0xbbf2f249a6b923a0, 0x3f59fb97df0b0cc2),
    (0xbbbd47dc3664be7a, 0x3f5b6d5736af07e6),
    (0x3bfbd1522c6418fb, 0x3f5cdf1c57138c53),
    (0xbbfbacdbb22d2163, 0x3f5e50e74066eee6),
    (0xbbfca7604812d77b, 0x3f5fc2b7f2d786a5),
    (0xbc02b6832f8830bf, 0x3f609a473749d663),
    (0x3be4e712033d0457, 0x3f61533559e4de55),
    (0xbbd473dd044017b5, 0x3f620c26615409f1),
    (0xbc0e033bcac726d3, 0x3f62c51a4dae8915),
    (0xbc04a47a2b18a0fa, 0x3f637e111f0b8cb5),
    (0x3bd6f3615771c17b, 0x3f64370ad58246dd),
    (0x3bec0ee6c32d6236, 0x3f64f0077129eab0),
    (0x3bffa94c99761b8f, 0x3f65a906f219ac67),
    (0xbbf979e6b473fbf8, 0x3f6662095868c153),
    (0x3bf30edde8d24c7b, 0x3f671b0ea42e5fda),
    (0xbbfd01594fe1421c, 0x3f67d416d581bf7c),
    (0x3c050bf7b995b49a, 0x3f688d21ec7a18cd),
    (0xbc028ea2bcec5018, 0x3f69462fe92ea57c),
    (0x3beed6add489c30b, 0x3f69ff40cbb6a04b),
    (0x3bf201d5c3bbeb69, 0x3f6ab85494294517),
    (0xbbfa05d0d4461ea9, 0x3f6b716b429dd0d3),
    (0xbc07c974c8a392fd, 0x3f6c2a84d72b8189),
    (0xbbff068238451bde, 0x3f6ce3a151e9965b),
    (0xbbd5e4d95c6259c3, 0x3f6d9cc0b2ef4f83),
    (0xbc01fc262efaad6c, 0x3f6e55e2fa53ee53),
    (0x3c049eee7abc7716, 0x3f6f0f08282eb533),
    (0xbbe903de284d2782, 0x3f6fc8303c96e7a6),
    (0xbc0ec564845134cb, 0x3f7040ad9bd1e522),
    (0xbbd7692b7791cf1f, 0x3f70861eadabc3dc),
    (0xbc137829afb11c10, 0x3f70e2b6b51e4f7e),
    (0x3c16706b91c3b0ba, 0x3f713f5030033459),
    (0xbc17558ccd710756, 0x3f719beb1e6616c9),
    (0x3c179f72a5bbe9de, 0x3f71f88780529bb1),
    (0xbc1e1297c110b250, 0x3f72552555d46886),
    (0x3c129930d567ca26, 0x3f72b1c49ef72343),
    (0x3bea08cbd7592a17, 0x3f730e655bc67275),
    (0x3c1e4f9d4ac5db83, 0x3f736b078c4dfd31),
    (0xbc1ed1b0aafd30c2, 0x3f73c7ab30996b1c),
    (0x3c1e78f0aa014b32, 0x3f74245048b46462),
    (0x3ba8594548038a0f, 0x3f7480f6d4aa91c2),
    (0x3c03df498168a333, 0x3f74dd9ed4879c82),
    (0x3c1b1c502544f82a, 0x3f753a4848572e77),
    (0xbc0dc50552fe0da9, 0x3f7596f33024f203),
    (0xbc1671d85c357d5e, 0x3f75f39f8bfc9212),
    (0x3bf1c670cabccefa, 0x3f76504d5be9ba1e),
    (0xbc19983a9e98f318, 0x3f76acfc9ff8162f),
    (0x3c1ae1a26af3eebe, 0x3f7709ad583352d6),
    (0x3c1655eb510bfda3, 0x3f77665f84a71d35),
    (0xbbfe287bc0192e15, 0x3f77c313255f22f8),
    (0x3c0cc4944139ccbf, 0x3f781fc83a671257),
    (0x3c14e09b4cb8645b, 0x3f787c7ec3ca9a19),
    (0xbbf5becc991e3a5f, 0x3f78d936c1956991),
    (0xbc1ddfa3f1e15ba8, 0x3f7935f033d3309e),
    (0xbc1b7b06ea3fb362, 0x3f7992ab1a8f9fac),
    (0x3c132d614904e46c, 0x3f79ef6775d667b4),
    (0xbbf7186892b5bfae, 0x3f7a4c2545b33a3e),
    (0xbc1d4de10b28dfd8, 0x3f7aa8e48a31c95c),
    (0x3c14bb4b3bdc8175, 0x3f7b05a5435dc7ad),
    (0x3c19cedbd1d7fba5, 0x3f7b62677142e860),
    (0xbbd0ed3379beaffd, 0x3f7bbf2b13ecdf2f),
    (0x3c16e86a125567a6, 0x3f7c1bf02b676060),
    (0xbc135038e0c0a52c, 0x3f7c6184f1b326d9),
    (0x3bc05ef8bf5adf5e, 0x3f7cbe4c95b6c5ab),
    (0xbbeb7338b99a6b26, 0x3f7d1b15aeab217c),
    (0x3c09e901c30c427e, 0x3f7d77e03c9bf0a4),
    (0xbc11f28a9c0b3d47, 0x3f7dd4ac3f94ea0a),
    (0xbc1140ef760d3b63, 0x3f7e3179b7a1c520),
    (0xbc0ab65b1037f517, 0x3f7e8e48a4ce39e7),
    (0xbc076940c457ce6d, 0x3f7eeb19072600ed),
    (0x3bfda3ae65a605cf, 0x3f7f47eadeb4d34d),
    (0x3c1b15d0bce2ede6, 0x3f7fa4be2b866ab0),
    (0x3c2e02aa1fa9dc57, 0x3f8000c976d340a6),
    (0x3c16be971a5565b9, 0x3f802f34929068f3),
    (0xbbf8a9319a6ed164, 0x3f805da069008be7),
    (0x3c1825079f1e0ec5, 0x3f808c0cfa298771),
    (0x3c060d5749321466, 0x3f80ba7a461139c8),
    (0xbc25b8f4c479e2e0, 0x3f80e8e84cbd8169),
    (0xbc1e3e1248004e29, 0x3f8117570e343d17),
    (0x3c09ac06487c3750, 0x3f8145c68a7b4bdd),
    (0x3c1f657ea5c03ea4, 0x3f817436c1988d0d),
    (0xbc25a965659a05e2, 0x3f81a2a7b391e040),
    (0xbc221ce9b9bfc512, 0x3f81d119606d2554),
    (0xbc230fda247ad0e1, 0x3f81ff8bc8303c70),
    (0xbc1382c78a45cdea, 0x3f822dfeeae10601),
    (0x3c246ae4a64073d4, 0x3f8250d5bf952374),
    (0xbc1dcad2cec3b84b, 0x3f827f4a29740a2f),
    (0xbc2413fbeb0b0635, 0x3f82adbf4e50cdf9),
    (0x3c2f28e6a48bcb90, 0x3f82dc352e315049),
    (0xbc296f286e1eb086, 0x3f830aabc91b72e0),
    (0xbc2f88c04206dfa1, 0x3f8339231f1517c1),
    (0xbc211ea20e195841, 0x3f83679b30242139),
    (0xbc0d6e71452b674a, 0x3f839613fc4e71dc),
    (0xbc257c578233b1b3, 0x3f83c48d8399ec85),
    (0xbc0ec430f03b76e0, 0x3f83f307c60c7455),
    (0x3c2e00dd1902ffb9, 0x3f842182c3abecb5),
    (0xbc2f22bcd96afe38, 0x3f844ffe7c7e3957),
    (0x3c208fd90f841d30, 0x3f847e7af0893e2f),
    (0x3c109594c5552bcc, 0x3f84acf81fd2df7e),
    (0xbc201a8a652e5602, 0x3f84db760a6101c9),
    (0xbbf826168febb3d0, 0x3f8509f4b03989dc),
    (0xbc17eb21a35021e3, 0x3f85387411625ccc),
    (0xbc266cbc818e1750, 0x3f8566f42de15ff4),
    (0x3bf9b784dd6cebda, 0x3f85957505bc78f6),
    (0x3c22b121ab482456, 0x3f85b8562298c65b),
    (0xbc15d29869dd8233, 0x3f85e6d842633702),
    (0xbc2572a1b6cd63cf, 0x3f86155b1d99f672),
    (0xbc1a1f355360e877, 0x3f8643deb442eb59),
    (0xbc2b6f1cd2e1c03f, 0x3f8672630663fcad),
    (0xbc22aaa11ccddcae, 0x3f86a0e8140311aa),
    (0x3c23d979ddf4746c, 0x3f86cf6ddd2611d4),
    (0xbc0dc930484501f8, 0x3f86fdf461d2e4f8),
];
