/* utils.c generated by valac 0.56.18, the Vala compiler
 * generated from utils.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and contains some utility functions
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib-object.h>
#include <unistd.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <libsoup/soup.h>
#include <webkit2/webkit2.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_NOT_AVAILABLE _ ("Not Available")
#define BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_VALUE "=="
#define BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_START "~~"
#define BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_END "##\n"
#define BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_LINES_PER_PAGE 30
#define BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_PER_LINE 80
#define BOOKWORM_APP_CONSTANTS_PREFIX_FOR_FILE_URL "file:///"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_BOOKS _ ("Books")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_IMAGES _ ("Images")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_ALL_FILES _ ("All Files")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _webkit_javascript_result_unref0(var) ((var == NULL) ? NULL : (var = (webkit_javascript_result_unref (var), NULL)))

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
};

struct _Block2Data {
	int _ref_count_;
	GtkFileChooserDialog* aFileChooserDialog;
};

struct _Block3Data {
	int _ref_count_;
	GtkFileChooserDialog* aFileChooserDialog;
};

struct _Block4Data {
	int _ref_count_;
	gchar* selectedText;
	GMainLoop* loop;
};

VALA_EXTERN gchar* bookworm_app_utils_last_file_chooser_path;
gchar* bookworm_app_utils_last_file_chooser_path = NULL;
VALA_EXTERN GString* bookworm_app_utils_spawn_async_with_pipes_output;
GString* bookworm_app_utils_spawn_async_with_pipes_output = NULL;
VALA_EXTERN gchar* bookworm_app_utils_bookwormStateData;
gchar* bookworm_app_utils_bookwormStateData = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;
VALA_EXTERN WebKitWebView* bookworm_app_app_window_aWebView;

VALA_EXTERN gboolean bookworm_app_utils_process_line (GIOChannel* channel,
                                          GIOCondition condition,
                                          const gchar* stream_name);
VALA_EXTERN gint bookworm_app_utils_execute_async_multiarg_command_pipes (gchar** spawn_args,
                                                              gint spawn_args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda34_ (GIOChannel* channel,
                       GIOCondition condition);
static gboolean ____lambda34__gio_func (GIOChannel* source,
                                 GIOCondition condition,
                                 gpointer self);
static gboolean ___lambda35_ (GIOChannel* channel,
                       GIOCondition condition);
static gboolean ____lambda35__gio_func (GIOChannel* source,
                                 GIOCondition condition,
                                 gpointer self);
static void ___lambda36_ (Block1Data* _data1_,
                   GPid pid,
                   gint status);
static void ____lambda36__gchild_watch_func (GPid pid,
                                      gint wait_status,
                                      gpointer self);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN gchar* bookworm_app_utils_getFullPathFromFilename (const gchar* rootDirectoryToSearch,
                                                   const gchar* fileName);
VALA_EXTERN gchar** bookworm_app_utils_getListOfRepeatingSegments (const gchar* data,
                                                       const gchar* repeatingIdentifier,
                                                       gint* result_length1,
                                                       GError** error);
VALA_EXTERN gchar* bookworm_app_utils_extractBetweenTwoStrings (const gchar* stringToBeSearched,
                                                    const gchar* startString,
                                                    const gchar* endString,
                                                    GError** error);
VALA_EXTERN gchar** bookworm_app_utils_multiExtractBetweenTwoStrings (const gchar* stringToBeSearched,
                                                          const gchar* startString,
                                                          const gchar* endString,
                                                          gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GeeArrayList* bookworm_app_utils_convertMultiLinesToTableArray (const gchar* dataForList,
                                                                gint noOfColumns,
                                                                const gchar* columnToken,
                                                                GError** error);
VALA_EXTERN gchar* bookworm_app_utils_extractXMLTag (const gchar* xmlData,
                                         const gchar* startTag,
                                         const gchar* endTag,
                                         GError** error);
VALA_EXTERN gchar* bookworm_app_utils_extractXMLAttribute (const gchar* xmlData,
                                               const gchar* tagName,
                                               const gchar* attributeID,
                                               const gchar* attributeName,
                                               GError** error);
VALA_EXTERN GeeHashMap* bookworm_app_utils_extractTagAttributes (const gchar* xmlData,
                                                     const gchar* tagName,
                                                     const gchar* attributeID,
                                                     gboolean doesAttributeValueExists,
                                                     GError** error);
VALA_EXTERN gchar* bookworm_app_utils_extractNestedXMLAttribute (const gchar* xmlData,
                                                     const gchar* startTag,
                                                     const gchar* endTag,
                                                     gint nestCount,
                                                     GError** error);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN GeeArrayList* bookworm_app_utils_createPagination (GeeArrayList* contentLocationList);
VALA_EXTERN gchar* bookworm_app_utils_createTableOfContents (GeeArrayList* bookContentList);
VALA_EXTERN GtkFileChooserDialog* bookworm_app_utils_new_file_chooser_dialog (GtkFileChooserAction action,
                                                                  const gchar* title,
                                                                  GtkWindow* parent,
                                                                  gboolean select_multiple,
                                                                  const gchar* filterType);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block2Data* _data2_,
                     GdkEventKey* ev);
static gboolean ___lambda9__gtk_widget_key_press_event (GtkWidget* _sender,
                                                 GdkEventKey* event,
                                                 gpointer self);
VALA_EXTERN GeeArrayList* bookworm_app_utils_selectFileChooser (GtkFileChooserAction action,
                                                    const gchar* title,
                                                    GtkWindow* parent,
                                                    gboolean select_multiple,
                                                    const gchar* filterType);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN GeeArrayList* bookworm_app_utils_selectDirChooser (const gchar* title,
                                                   GtkWindow* parent,
                                                   gboolean select_multiple);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda25_ (Block3Data* _data3_,
                      GdkEventKey* ev);
static gboolean ___lambda25__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
VALA_EXTERN gchar* bookworm_app_utils_parseMarkUp (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_utils_encodeHTMLChars (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_utils_removeMarkUp (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_utils_removeTagsFromText (const gchar* input);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN gchar* bookworm_app_utils_convertContentListToString (BookwormAppBook* aBook);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_convertStringToContentList (BookwormAppBook* aBook,
                                                                const gchar* contentListString);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN gchar* bookworm_app_utils_convertTreeMapToString (GeeTreeMap* aMap);
VALA_EXTERN GeeTreeMap* bookworm_app_utils_convertStringToTreeMap (const gchar* stringForTreeMap);
VALA_EXTERN gchar* bookworm_app_utils_convertTOCToString (BookwormAppBook* aBook);
VALA_EXTERN GeeArrayList* bookworm_app_book_getTOC (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_convertStringToTOC (BookwormAppBook* aBook,
                                                        const gchar* tocString);
VALA_EXTERN void bookworm_app_book_setTOC (BookwormAppBook* self,
                               GeeHashMap* toc);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN gint bookworm_app_book_getBookId (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN void bookworm_app_book_setBookCoverLocation (BookwormAppBook* self,
                                             const gchar* aBookCoverLocation);
VALA_EXTERN gchar* bookworm_app_utils_setWebViewTitle (const gchar* javascript);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda7_ (Block4Data* _data4_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN gchar* bookworm_app_utils_minimizeStringLength (const gchar* originalString,
                                                gint maxLength);
VALA_EXTERN gchar* bookworm_app_utils_breakString (const gchar* originalString,
                                       gint breakLength,
                                       const gchar* breakString);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_EBOOKS[8];
VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES[5];

gboolean
bookworm_app_utils_process_line (GIOChannel* channel,
                                 GIOCondition condition,
                                 const gchar* stream_name)
{
	GString* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 25 "../src/utils.vala"
	g_return_val_if_fail (channel != NULL, FALSE);
#line 25 "../src/utils.vala"
	g_return_val_if_fail (stream_name != NULL, FALSE);
#line 26 "../src/utils.vala"
	_tmp0_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 26 "../src/utils.vala"
	if (_tmp0_ == NULL) {
#line 309 "utils.c"
		GString* _tmp1_;
#line 27 "../src/utils.vala"
		_tmp1_ = g_string_new ("");
#line 27 "../src/utils.vala"
		_g_string_free0 (bookworm_app_utils_spawn_async_with_pipes_output);
#line 27 "../src/utils.vala"
		bookworm_app_utils_spawn_async_with_pipes_output = _tmp1_;
#line 317 "utils.c"
	}
#line 29 "../src/utils.vala"
	if (condition == G_IO_HUP) {
#line 30 "../src/utils.vala"
		result = FALSE;
#line 30 "../src/utils.vala"
		return result;
#line 325 "utils.c"
	}
	{
		gchar* line = NULL;
		gchar* _tmp2_ = NULL;
		GString* _tmp4_;
		const gchar* _tmp5_;
#line 34 "../src/utils.vala"
		g_io_channel_read_line (channel, &_tmp2_, NULL, NULL, &_inner_error0_);
#line 34 "../src/utils.vala"
		_g_free0 (line);
#line 34 "../src/utils.vala"
		line = _tmp2_;
#line 34 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 340 "utils.c"
			gboolean _tmp3_ = FALSE;
#line 34 "../src/utils.vala"
			_g_free0 (line);
#line 34 "../src/utils.vala"
			if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
#line 346 "utils.c"
				goto __catch0_g_io_channel_error;
			}
#line 34 "../src/utils.vala"
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 351 "utils.c"
				goto __catch0_g_convert_error;
			}
#line 34 "../src/utils.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 34 "../src/utils.vala"
			g_clear_error (&_inner_error0_);
#line 34 "../src/utils.vala"
			return _tmp3_;
#line 360 "utils.c"
		}
#line 35 "../src/utils.vala"
		_tmp4_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 35 "../src/utils.vala"
		_tmp5_ = line;
#line 35 "../src/utils.vala"
		g_string_append (_tmp4_, _tmp5_);
#line 32 "../src/utils.vala"
		_g_free0 (line);
#line 370 "utils.c"
	}
	goto __finally0;
	__catch0_g_io_channel_error:
	{
		GError* e = NULL;
		GString* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 32 "../src/utils.vala"
		e = _inner_error0_;
#line 32 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 37 "../src/utils.vala"
		_tmp6_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 37 "../src/utils.vala"
		_tmp7_ = e;
#line 37 "../src/utils.vala"
		_tmp8_ = _tmp7_->message;
#line 37 "../src/utils.vala"
		g_string_append (_tmp6_, _tmp8_);
#line 38 "../src/utils.vala"
		result = FALSE;
#line 38 "../src/utils.vala"
		_g_error_free0 (e);
#line 38 "../src/utils.vala"
		return result;
#line 397 "utils.c"
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GString* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 32 "../src/utils.vala"
		e = _inner_error0_;
#line 32 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 40 "../src/utils.vala"
		_tmp9_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 40 "../src/utils.vala"
		_tmp10_ = e;
#line 40 "../src/utils.vala"
		_tmp11_ = _tmp10_->message;
#line 40 "../src/utils.vala"
		g_string_append (_tmp9_, _tmp11_);
#line 41 "../src/utils.vala"
		_tmp12_ = e;
#line 41 "../src/utils.vala"
		_tmp13_ = _tmp12_->message;
#line 41 "../src/utils.vala"
		_tmp14_ = g_strconcat ("Failure in reading command output:", _tmp13_, NULL);
#line 41 "../src/utils.vala"
		_tmp15_ = _tmp14_;
#line 41 "../src/utils.vala"
		g_warning ("utils.vala:41: %s", _tmp15_);
#line 41 "../src/utils.vala"
		_g_free0 (_tmp15_);
#line 42 "../src/utils.vala"
		result = FALSE;
#line 42 "../src/utils.vala"
		_g_error_free0 (e);
#line 42 "../src/utils.vala"
		return result;
#line 440 "utils.c"
	}
	__finally0:
#line 32 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 445 "utils.c"
		gboolean _tmp16_ = FALSE;
#line 32 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 32 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 32 "../src/utils.vala"
		return _tmp16_;
#line 453 "utils.c"
	}
#line 44 "../src/utils.vala"
	result = TRUE;
#line 44 "../src/utils.vala"
	return result;
#line 459 "utils.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 47 "../src/utils.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 47 "../src/utils.vala"
	return _data1_;
#line 469 "utils.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 47 "../src/utils.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 47 "../src/utils.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 47 "../src/utils.vala"
		g_slice_free (Block1Data, _data1_);
#line 483 "utils.c"
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 498 "utils.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 502 "utils.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 508 "utils.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 513 "utils.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 519 "utils.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 523 "utils.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 527 "utils.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 531 "utils.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 535 "utils.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 539 "utils.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 554 "utils.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 563 "utils.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 570 "utils.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 576 "utils.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 584 "utils.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 588 "utils.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 594 "utils.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 599 "utils.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 605 "utils.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 609 "utils.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 613 "utils.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 619 "utils.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 625 "utils.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 637 "utils.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 641 "utils.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 645 "utils.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 650 "utils.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 658 "utils.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 676 "utils.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 682 "utils.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 686 "utils.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 694 "utils.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 703 "utils.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 712 "utils.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 718 "utils.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 726 "utils.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 738 "utils.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 744 "utils.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 748 "utils.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 756 "utils.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 767 "utils.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 776 "utils.c"
	}
}

static gboolean
___lambda34_ (GIOChannel* channel,
              GIOCondition condition)
{
	gboolean result;
#line 74 "../src/utils.vala"
	g_return_val_if_fail (channel != NULL, FALSE);
#line 75 "../src/utils.vala"
	result = bookworm_app_utils_process_line (channel, condition, "stdout");
#line 75 "../src/utils.vala"
	return result;
#line 791 "utils.c"
}

static gboolean
____lambda34__gio_func (GIOChannel* source,
                        GIOCondition condition,
                        gpointer self)
{
	gboolean result;
	result = ___lambda34_ (source, condition);
#line 74 "../src/utils.vala"
	return result;
#line 803 "utils.c"
}

static gboolean
___lambda35_ (GIOChannel* channel,
              GIOCondition condition)
{
	gboolean result;
#line 80 "../src/utils.vala"
	g_return_val_if_fail (channel != NULL, FALSE);
#line 81 "../src/utils.vala"
	result = bookworm_app_utils_process_line (channel, condition, "stderr");
#line 81 "../src/utils.vala"
	return result;
#line 817 "utils.c"
}

static gboolean
____lambda35__gio_func (GIOChannel* source,
                        GIOCondition condition,
                        gpointer self)
{
	gboolean result;
	result = ___lambda35_ (source, condition);
#line 80 "../src/utils.vala"
	return result;
#line 829 "utils.c"
}

static void
___lambda36_ (Block1Data* _data1_,
              GPid pid,
              gint status)
{
#line 86 "../src/utils.vala"
	g_spawn_close_pid (pid);
#line 87 "../src/utils.vala"
	g_main_loop_quit (_data1_->loop);
#line 841 "utils.c"
}

static void
____lambda36__gchild_watch_func (GPid pid,
                                 gint wait_status,
                                 gpointer self)
{
#line 84 "../src/utils.vala"
	___lambda36_ (self, pid, wait_status);
#line 851 "utils.c"
}

gint
bookworm_app_utils_execute_async_multiarg_command_pipes (gchar** spawn_args,
                                                         gint spawn_args_length1)
{
	Block1Data* _data1_;
	GString* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GString* _tmp6_;
	GMainLoop* _tmp7_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError* _inner_error0_ = NULL;
	gint result;
#line 47 "../src/utils.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 47 "../src/utils.vala"
	_data1_->_ref_count_ = 1;
#line 48 "../src/utils.vala"
	_tmp0_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 48 "../src/utils.vala"
	if (_tmp0_ == NULL) {
#line 882 "utils.c"
		GString* _tmp1_;
#line 49 "../src/utils.vala"
		_tmp1_ = g_string_new ("");
#line 49 "../src/utils.vala"
		_g_string_free0 (bookworm_app_utils_spawn_async_with_pipes_output);
#line 49 "../src/utils.vala"
		bookworm_app_utils_spawn_async_with_pipes_output = _tmp1_;
#line 890 "utils.c"
	}
#line 51 "../src/utils.vala"
	_tmp2_ = _vala_g_strjoinv (" ", spawn_args, (gint) spawn_args_length1);
#line 51 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 51 "../src/utils.vala"
	_tmp4_ = g_strconcat ("Starting to execute async command: ", _tmp3_, NULL);
#line 51 "../src/utils.vala"
	_tmp5_ = _tmp4_;
#line 51 "../src/utils.vala"
	g_debug ("utils.vala:51: %s", _tmp5_);
#line 51 "../src/utils.vala"
	_g_free0 (_tmp5_);
#line 51 "../src/utils.vala"
	_g_free0 (_tmp3_);
#line 52 "../src/utils.vala"
	_tmp6_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 52 "../src/utils.vala"
	g_string_erase (_tmp6_, (gssize) 0, (gssize) -1);
#line 53 "../src/utils.vala"
	_tmp7_ = g_main_loop_new (NULL, FALSE);
#line 53 "../src/utils.vala"
	_data1_->loop = _tmp7_;
#line 914 "utils.c"
	{
		gchar** spawn_env = NULL;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint spawn_env_length1;
		gint _spawn_env_size_;
		GPid child_pid = 0;
		gint standard_input = 0;
		gint standard_output = 0;
		gint standard_error = 0;
		GPid _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GIOChannel* output = NULL;
		GIOChannel* _tmp15_;
		GIOChannel* _tmp16_;
		GIOChannel* _error_ = NULL;
		GIOChannel* _tmp17_;
		GIOChannel* _tmp18_;
#line 55 "../src/utils.vala"
		_tmp9_ = _tmp8_ = g_get_environ ();
#line 55 "../src/utils.vala"
		spawn_env = _tmp9_;
#line 55 "../src/utils.vala"
		spawn_env_length1 = _vala_array_length (_tmp8_);
#line 55 "../src/utils.vala"
		_spawn_env_size_ = spawn_env_length1;
#line 62 "../src/utils.vala"
		g_spawn_async_with_pipes ("/", spawn_args, spawn_env, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error0_);
#line 62 "../src/utils.vala"
		child_pid = _tmp10_;
#line 62 "../src/utils.vala"
		standard_input = _tmp11_;
#line 62 "../src/utils.vala"
		standard_output = _tmp12_;
#line 62 "../src/utils.vala"
		standard_error = _tmp13_;
#line 62 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 955 "utils.c"
			gint _tmp14_ = -1;
#line 62 "../src/utils.vala"
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
#line 62 "../src/utils.vala"
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
#line 961 "utils.c"
				goto __catch0_g_spawn_error;
			}
#line 62 "../src/utils.vala"
			block1_data_unref (_data1_);
#line 62 "../src/utils.vala"
			_data1_ = NULL;
#line 62 "../src/utils.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 62 "../src/utils.vala"
			g_clear_error (&_inner_error0_);
#line 62 "../src/utils.vala"
			return _tmp14_;
#line 974 "utils.c"
		}
#line 73 "../src/utils.vala"
		_tmp15_ = g_io_channel_unix_new (standard_output);
#line 73 "../src/utils.vala"
		output = _tmp15_;
#line 74 "../src/utils.vala"
		_tmp16_ = output;
#line 74 "../src/utils.vala"
		g_io_add_watch (_tmp16_, G_IO_IN | G_IO_HUP, ____lambda34__gio_func, NULL);
#line 79 "../src/utils.vala"
		_tmp17_ = g_io_channel_unix_new (standard_error);
#line 79 "../src/utils.vala"
		_error_ = _tmp17_;
#line 80 "../src/utils.vala"
		_tmp18_ = _error_;
#line 80 "../src/utils.vala"
		g_io_add_watch (_tmp18_, G_IO_IN | G_IO_HUP, ____lambda35__gio_func, NULL);
#line 84 "../src/utils.vala"
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, ____lambda36__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
#line 89 "../src/utils.vala"
		g_main_loop_run (_data1_->loop);
#line 54 "../src/utils.vala"
		_g_io_channel_unref0 (_error_);
#line 54 "../src/utils.vala"
		_g_io_channel_unref0 (output);
#line 54 "../src/utils.vala"
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
#line 1002 "utils.c"
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GString* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 54 "../src/utils.vala"
		e = _inner_error0_;
#line 54 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 91 "../src/utils.vala"
		_tmp19_ = _vala_g_strjoinv (" ", spawn_args, (gint) spawn_args_length1);
#line 91 "../src/utils.vala"
		_tmp20_ = _tmp19_;
#line 91 "../src/utils.vala"
		_tmp21_ = g_strconcat ("Failure in executing async command [", _tmp20_, NULL);
#line 91 "../src/utils.vala"
		_tmp22_ = _tmp21_;
#line 91 "../src/utils.vala"
		_tmp23_ = g_strconcat (_tmp22_, "] : ", NULL);
#line 91 "../src/utils.vala"
		_tmp24_ = _tmp23_;
#line 91 "../src/utils.vala"
		_tmp25_ = e;
#line 91 "../src/utils.vala"
		_tmp26_ = _tmp25_->message;
#line 91 "../src/utils.vala"
		_tmp27_ = g_strconcat (_tmp24_, _tmp26_, NULL);
#line 91 "../src/utils.vala"
		_tmp28_ = _tmp27_;
#line 91 "../src/utils.vala"
		g_warning ("utils.vala:91: %s", _tmp28_);
#line 91 "../src/utils.vala"
		_g_free0 (_tmp28_);
#line 91 "../src/utils.vala"
		_g_free0 (_tmp24_);
#line 91 "../src/utils.vala"
		_g_free0 (_tmp22_);
#line 91 "../src/utils.vala"
		_g_free0 (_tmp20_);
#line 92 "../src/utils.vala"
		_tmp29_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 92 "../src/utils.vala"
		_tmp30_ = e;
#line 92 "../src/utils.vala"
		_tmp31_ = _tmp30_->message;
#line 92 "../src/utils.vala"
		g_string_append (_tmp29_, _tmp31_);
#line 54 "../src/utils.vala"
		_g_error_free0 (e);
#line 1065 "utils.c"
	}
	__finally0:
#line 54 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1070 "utils.c"
		gint _tmp32_ = -1;
#line 54 "../src/utils.vala"
		block1_data_unref (_data1_);
#line 54 "../src/utils.vala"
		_data1_ = NULL;
#line 54 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 54 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 54 "../src/utils.vala"
		return _tmp32_;
#line 1082 "utils.c"
	}
#line 94 "../src/utils.vala"
	_tmp33_ = _vala_g_strjoinv (" ", spawn_args, (gint) spawn_args_length1);
#line 94 "../src/utils.vala"
	_tmp34_ = _tmp33_;
#line 94 "../src/utils.vala"
	_tmp35_ = g_strconcat ("Completed executing async command[", _tmp34_, NULL);
#line 94 "../src/utils.vala"
	_tmp36_ = _tmp35_;
#line 94 "../src/utils.vala"
	_tmp37_ = g_strconcat (_tmp36_, "]...", NULL);
#line 94 "../src/utils.vala"
	_tmp38_ = _tmp37_;
#line 94 "../src/utils.vala"
	g_debug ("utils.vala:94: %s", _tmp38_);
#line 94 "../src/utils.vala"
	_g_free0 (_tmp38_);
#line 94 "../src/utils.vala"
	_g_free0 (_tmp36_);
#line 94 "../src/utils.vala"
	_g_free0 (_tmp34_);
#line 95 "../src/utils.vala"
	result = 0;
#line 95 "../src/utils.vala"
	block1_data_unref (_data1_);
#line 95 "../src/utils.vala"
	_data1_ = NULL;
#line 95 "../src/utils.vala"
	return result;
#line 1112 "utils.c"
}

gchar*
bookworm_app_utils_execute_sync_command (const gchar* cmd)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint exitCodeForCommand = 0;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 98 "../src/utils.vala"
	g_return_val_if_fail (cmd != NULL, NULL);
#line 99 "../src/utils.vala"
	_tmp0_ = g_strconcat ("Starting to execute sync command [", cmd, NULL);
#line 99 "../src/utils.vala"
	_tmp1_ = _tmp0_;
#line 99 "../src/utils.vala"
	_tmp2_ = g_strconcat (_tmp1_, "]...", NULL);
#line 99 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 99 "../src/utils.vala"
	g_debug ("utils.vala:99: %s", _tmp3_);
#line 99 "../src/utils.vala"
	_g_free0 (_tmp3_);
#line 99 "../src/utils.vala"
	_g_free0 (_tmp1_);
#line 102 "../src/utils.vala"
	exitCodeForCommand = 0;
#line 1151 "utils.c"
	{
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 104 "../src/utils.vala"
		g_spawn_command_line_sync (cmd, &_tmp4_, &_tmp5_, &_tmp6_, &_inner_error0_);
#line 104 "../src/utils.vala"
		_g_free0 (std_out);
#line 104 "../src/utils.vala"
		std_out = _tmp4_;
#line 104 "../src/utils.vala"
		_g_free0 (std_err);
#line 104 "../src/utils.vala"
		std_err = _tmp5_;
#line 104 "../src/utils.vala"
		exitCodeForCommand = _tmp6_;
#line 104 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1170 "utils.c"
			goto __catch0_g_error;
		}
#line 105 "../src/utils.vala"
		if (exitCodeForCommand != 0) {
#line 1175 "utils.c"
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
#line 106 "../src/utils.vala"
			_tmp7_ = g_strconcat ("Execution of sync command [", cmd, NULL);
#line 106 "../src/utils.vala"
			_tmp8_ = _tmp7_;
#line 106 "../src/utils.vala"
			_tmp9_ = g_strconcat (_tmp8_, "]: exited with non zero error code[", NULL);
#line 106 "../src/utils.vala"
			_tmp10_ = _tmp9_;
#line 106 "../src/utils.vala"
			_tmp11_ = g_strdup_printf ("%i", exitCodeForCommand);
#line 106 "../src/utils.vala"
			_tmp12_ = _tmp11_;
#line 106 "../src/utils.vala"
			_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
#line 106 "../src/utils.vala"
			_tmp14_ = _tmp13_;
#line 106 "../src/utils.vala"
			_tmp15_ = g_strconcat (_tmp14_, "]. Error message:", NULL);
#line 106 "../src/utils.vala"
			_tmp16_ = _tmp15_;
#line 106 "../src/utils.vala"
			_tmp17_ = g_strconcat (_tmp16_, std_err, NULL);
#line 106 "../src/utils.vala"
			_tmp18_ = _tmp17_;
#line 106 "../src/utils.vala"
			g_warning ("utils.vala:106: %s", _tmp18_);
#line 106 "../src/utils.vala"
			_g_free0 (_tmp18_);
#line 106 "../src/utils.vala"
			_g_free0 (_tmp16_);
#line 106 "../src/utils.vala"
			_g_free0 (_tmp14_);
#line 106 "../src/utils.vala"
			_g_free0 (_tmp12_);
#line 106 "../src/utils.vala"
			_g_free0 (_tmp10_);
#line 106 "../src/utils.vala"
			_g_free0 (_tmp8_);
#line 107 "../src/utils.vala"
			_tmp19_ = g_strdup ("false");
#line 107 "../src/utils.vala"
			result = _tmp19_;
#line 107 "../src/utils.vala"
			_g_free0 (std_err);
#line 107 "../src/utils.vala"
			_g_free0 (std_out);
#line 107 "../src/utils.vala"
			return result;
#line 1237 "utils.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
#line 103 "../src/utils.vala"
		e = _inner_error0_;
#line 103 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 110 "../src/utils.vala"
		_tmp20_ = g_strconcat ("Error encountered in execution of sync command [", cmd, NULL);
#line 110 "../src/utils.vala"
		_tmp21_ = _tmp20_;
#line 110 "../src/utils.vala"
		_tmp22_ = g_strconcat (_tmp21_, "]: ", NULL);
#line 110 "../src/utils.vala"
		_tmp23_ = _tmp22_;
#line 110 "../src/utils.vala"
		_tmp24_ = e;
#line 110 "../src/utils.vala"
		_tmp25_ = _tmp24_->message;
#line 110 "../src/utils.vala"
		_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
#line 110 "../src/utils.vala"
		_tmp27_ = _tmp26_;
#line 110 "../src/utils.vala"
		g_warning ("utils.vala:110: %s", _tmp27_);
#line 110 "../src/utils.vala"
		_g_free0 (_tmp27_);
#line 110 "../src/utils.vala"
		_g_free0 (_tmp23_);
#line 110 "../src/utils.vala"
		_g_free0 (_tmp21_);
#line 111 "../src/utils.vala"
		_tmp28_ = g_strdup ("false");
#line 111 "../src/utils.vala"
		result = _tmp28_;
#line 111 "../src/utils.vala"
		_g_error_free0 (e);
#line 111 "../src/utils.vala"
		_g_free0 (std_err);
#line 111 "../src/utils.vala"
		_g_free0 (std_out);
#line 111 "../src/utils.vala"
		return result;
#line 1293 "utils.c"
	}
	__finally0:
#line 103 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 103 "../src/utils.vala"
		_g_free0 (std_err);
#line 103 "../src/utils.vala"
		_g_free0 (std_out);
#line 103 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 103 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 103 "../src/utils.vala"
		return NULL;
#line 1308 "utils.c"
	}
#line 113 "../src/utils.vala"
	_tmp29_ = g_strconcat ("Completed execution of sync command [", cmd, NULL);
#line 113 "../src/utils.vala"
	_tmp30_ = _tmp29_;
#line 113 "../src/utils.vala"
	_tmp31_ = g_strconcat (_tmp30_, "] with output:", NULL);
#line 113 "../src/utils.vala"
	_tmp32_ = _tmp31_;
#line 113 "../src/utils.vala"
	_tmp33_ = g_strconcat (_tmp32_, std_out, NULL);
#line 113 "../src/utils.vala"
	_tmp34_ = _tmp33_;
#line 113 "../src/utils.vala"
	g_debug ("utils.vala:113: %s", _tmp34_);
#line 113 "../src/utils.vala"
	_g_free0 (_tmp34_);
#line 113 "../src/utils.vala"
	_g_free0 (_tmp32_);
#line 113 "../src/utils.vala"
	_g_free0 (_tmp30_);
#line 114 "../src/utils.vala"
	result = std_out;
#line 114 "../src/utils.vala"
	_g_free0 (std_err);
#line 114 "../src/utils.vala"
	return result;
#line 1336 "utils.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 1357 "utils.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1376 "utils.c"
}

gchar*
bookworm_app_utils_getFullPathFromFilename (const gchar* rootDirectoryToSearch,
                                            const gchar* fileName)
{
	gchar* grepOutput = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 117 "../src/utils.vala"
	g_return_val_if_fail (rootDirectoryToSearch != NULL, NULL);
#line 117 "../src/utils.vala"
	g_return_val_if_fail (fileName != NULL, NULL);
#line 118 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 118 "../src/utils.vala"
	grepOutput = _tmp0_;
#line 1395 "utils.c"
	{
		gchar* baseName = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
#line 120 "../src/utils.vala"
		_tmp1_ = g_file_new_for_path (fileName);
#line 120 "../src/utils.vala"
		_tmp2_ = _tmp1_;
#line 120 "../src/utils.vala"
		_tmp3_ = g_file_get_basename (_tmp2_);
#line 120 "../src/utils.vala"
		_tmp4_ = _tmp3_;
#line 120 "../src/utils.vala"
		_g_object_unref0 (_tmp2_);
#line 120 "../src/utils.vala"
		baseName = _tmp4_;
#line 121 "../src/utils.vala"
		_tmp5_ = g_strconcat ("find \"", rootDirectoryToSearch, NULL);
#line 121 "../src/utils.vala"
		_tmp6_ = _tmp5_;
#line 121 "../src/utils.vala"
		_tmp7_ = g_strconcat (_tmp6_, "\" -name \"", NULL);
#line 121 "../src/utils.vala"
		_tmp8_ = _tmp7_;
#line 121 "../src/utils.vala"
		_tmp9_ = baseName;
#line 121 "../src/utils.vala"
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
#line 121 "../src/utils.vala"
		_tmp11_ = _tmp10_;
#line 121 "../src/utils.vala"
		_tmp12_ = g_strconcat (_tmp11_, "\"", NULL);
#line 121 "../src/utils.vala"
		_tmp13_ = _tmp12_;
#line 121 "../src/utils.vala"
		_tmp14_ = bookworm_app_utils_execute_sync_command (_tmp13_);
#line 121 "../src/utils.vala"
		_tmp15_ = _tmp14_;
#line 121 "../src/utils.vala"
		_tmp16_ = string_strip (_tmp15_);
#line 121 "../src/utils.vala"
		_g_free0 (grepOutput);
#line 121 "../src/utils.vala"
		grepOutput = _tmp16_;
#line 121 "../src/utils.vala"
		_g_free0 (_tmp15_);
#line 121 "../src/utils.vala"
		_g_free0 (_tmp13_);
#line 121 "../src/utils.vala"
		_g_free0 (_tmp11_);
#line 121 "../src/utils.vala"
		_g_free0 (_tmp8_);
#line 121 "../src/utils.vala"
		_g_free0 (_tmp6_);
#line 123 "../src/utils.vala"
		_tmp17_ = grepOutput;
#line 123 "../src/utils.vala"
		if (string_contains (_tmp17_, "\n")) {
#line 1471 "utils.c"
			gchar** listOfFilePaths = NULL;
			const gchar* _tmp18_;
			gint _tmp19_ = 0;
			gchar** _tmp20_;
			gint listOfFilePaths_length1;
			gint _listOfFilePaths_size_;
			gchar** _tmp21_;
			gint _tmp21__length1;
			const gchar* _tmp22_;
			gchar* _tmp23_;
#line 124 "../src/utils.vala"
			_tmp18_ = grepOutput;
#line 124 "../src/utils.vala"
			_tmp20_ = bookworm_app_utils_getListOfRepeatingSegments (_tmp18_, "\n", &_tmp19_, &_inner_error0_);
#line 124 "../src/utils.vala"
			listOfFilePaths = _tmp20_;
#line 124 "../src/utils.vala"
			listOfFilePaths_length1 = _tmp19_;
#line 124 "../src/utils.vala"
			_listOfFilePaths_size_ = listOfFilePaths_length1;
#line 124 "../src/utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 124 "../src/utils.vala"
				_g_free0 (baseName);
#line 1496 "utils.c"
				goto __catch0_g_error;
			}
#line 125 "../src/utils.vala"
			_tmp21_ = listOfFilePaths;
#line 125 "../src/utils.vala"
			_tmp21__length1 = listOfFilePaths_length1;
#line 125 "../src/utils.vala"
			_tmp22_ = _tmp21_[0];
#line 125 "../src/utils.vala"
			_tmp23_ = g_strdup (_tmp22_);
#line 125 "../src/utils.vala"
			_g_free0 (grepOutput);
#line 125 "../src/utils.vala"
			grepOutput = _tmp23_;
#line 123 "../src/utils.vala"
			listOfFilePaths = (_vala_array_free (listOfFilePaths, listOfFilePaths_length1, (GDestroyNotify) g_free), NULL);
#line 1513 "utils.c"
		}
#line 130 "../src/utils.vala"
		_tmp24_ = grepOutput;
#line 130 "../src/utils.vala"
		_tmp25_ = string_strip (_tmp24_);
#line 130 "../src/utils.vala"
		result = _tmp25_;
#line 130 "../src/utils.vala"
		_g_free0 (baseName);
#line 130 "../src/utils.vala"
		_g_free0 (grepOutput);
#line 130 "../src/utils.vala"
		return result;
#line 1527 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GError* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
#line 119 "../src/utils.vala"
		e = _inner_error0_;
#line 119 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 132 "../src/utils.vala"
		_tmp26_ = g_strconcat ("Error encountered in getting full path for filename [", fileName, NULL);
#line 132 "../src/utils.vala"
		_tmp27_ = _tmp26_;
#line 132 "../src/utils.vala"
		_tmp28_ = g_strconcat (_tmp27_, "] searching within directory[", NULL);
#line 132 "../src/utils.vala"
		_tmp29_ = _tmp28_;
#line 132 "../src/utils.vala"
		_tmp30_ = g_strconcat (_tmp29_, rootDirectoryToSearch, NULL);
#line 132 "../src/utils.vala"
		_tmp31_ = _tmp30_;
#line 132 "../src/utils.vala"
		_tmp32_ = g_strconcat (_tmp31_, "]: ", NULL);
#line 132 "../src/utils.vala"
		_tmp33_ = _tmp32_;
#line 132 "../src/utils.vala"
		_tmp34_ = e;
#line 132 "../src/utils.vala"
		_tmp35_ = _tmp34_->message;
#line 132 "../src/utils.vala"
		_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
#line 132 "../src/utils.vala"
		_tmp37_ = _tmp36_;
#line 132 "../src/utils.vala"
		g_warning ("utils.vala:132: %s", _tmp37_);
#line 132 "../src/utils.vala"
		_g_free0 (_tmp37_);
#line 132 "../src/utils.vala"
		_g_free0 (_tmp33_);
#line 132 "../src/utils.vala"
		_g_free0 (_tmp31_);
#line 132 "../src/utils.vala"
		_g_free0 (_tmp29_);
#line 132 "../src/utils.vala"
		_g_free0 (_tmp27_);
#line 119 "../src/utils.vala"
		_g_error_free0 (e);
#line 1587 "utils.c"
	}
	__finally0:
#line 119 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 119 "../src/utils.vala"
		_g_free0 (grepOutput);
#line 119 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 119 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 119 "../src/utils.vala"
		return NULL;
#line 1600 "utils.c"
	}
#line 134 "../src/utils.vala"
	result = grepOutput;
#line 134 "../src/utils.vala"
	return result;
#line 1606 "utils.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1630 "utils.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1638 "utils.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1644 "utils.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 1668 "utils.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 1677 "utils.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1696 "utils.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1700 "utils.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1706 "utils.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1716 "utils.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1724 "utils.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1728 "utils.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 1734 "utils.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 1744 "utils.c"
}

gchar*
bookworm_app_utils_extractBetweenTwoStrings (const gchar* stringToBeSearched,
                                             const gchar* startString,
                                             const gchar* endString,
                                             GError** error)
{
	gchar* extractedString = NULL;
	gchar* _tmp0_;
	gint positionOfStartStringInData = 0;
	gchar* result;
#line 137 "../src/utils.vala"
	g_return_val_if_fail (stringToBeSearched != NULL, NULL);
#line 137 "../src/utils.vala"
	g_return_val_if_fail (startString != NULL, NULL);
#line 137 "../src/utils.vala"
	g_return_val_if_fail (endString != NULL, NULL);
#line 138 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 138 "../src/utils.vala"
	extractedString = _tmp0_;
#line 139 "../src/utils.vala"
	positionOfStartStringInData = string_index_of (stringToBeSearched, startString, 0);
#line 140 "../src/utils.vala"
	if (positionOfStartStringInData > -1) {
#line 1771 "utils.c"
		gint positionOfEndOfStartString = 0;
		gint positionOfStartOfEndString = 0;
#line 141 "../src/utils.vala"
		positionOfEndOfStartString = positionOfStartStringInData + g_utf8_strlen (startString, (gssize) -1);
#line 142 "../src/utils.vala"
		positionOfStartOfEndString = string_index_of (stringToBeSearched, endString, positionOfEndOfStartString + 1);
#line 143 "../src/utils.vala"
		if (positionOfStartOfEndString > -1) {
#line 1780 "utils.c"
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
#line 144 "../src/utils.vala"
			_tmp1_ = string_substring (stringToBeSearched, (glong) positionOfEndOfStartString, (glong) (positionOfStartOfEndString - positionOfEndOfStartString));
#line 144 "../src/utils.vala"
			_tmp2_ = _tmp1_;
#line 144 "../src/utils.vala"
			_tmp3_ = string_strip (_tmp2_);
#line 144 "../src/utils.vala"
			_g_free0 (extractedString);
#line 144 "../src/utils.vala"
			extractedString = _tmp3_;
#line 144 "../src/utils.vala"
			_g_free0 (_tmp2_);
#line 1796 "utils.c"
		}
	} else {
		gchar* _tmp4_;
#line 146 "../src/utils.vala"
		_tmp4_ = g_strdup (BOOKWORM_APP_CONSTANTS_TEXT_FOR_NOT_AVAILABLE);
#line 146 "../src/utils.vala"
		_g_free0 (extractedString);
#line 146 "../src/utils.vala"
		extractedString = _tmp4_;
#line 1806 "utils.c"
	}
#line 148 "../src/utils.vala"
	result = extractedString;
#line 148 "../src/utils.vala"
	return result;
#line 1812 "utils.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1834 "utils.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1838 "utils.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1844 "utils.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1848 "utils.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1852 "utils.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1860 "utils.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1888 "utils.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1897 "utils.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1911 "utils.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1920 "utils.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1934 "utils.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1943 "utils.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1952 "utils.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 160 "../src/utils.vala"
	if ((*length) == (*size)) {
#line 160 "../src/utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 160 "../src/utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1967 "utils.c"
	}
#line 160 "../src/utils.vala"
	(*array)[(*length)++] = value;
#line 160 "../src/utils.vala"
	(*array)[*length] = NULL;
#line 1973 "utils.c"
}

gchar**
bookworm_app_utils_multiExtractBetweenTwoStrings (const gchar* stringToBeSearched,
                                                  const gchar* startString,
                                                  const gchar* endString,
                                                  gint* result_length1)
{
	gchar** results = NULL;
	gchar** _tmp0_;
	gint results_length1;
	gint _results_size_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
#line 151 "../src/utils.vala"
	g_return_val_if_fail (stringToBeSearched != NULL, NULL);
#line 151 "../src/utils.vala"
	g_return_val_if_fail (startString != NULL, NULL);
#line 151 "../src/utils.vala"
	g_return_val_if_fail (endString != NULL, NULL);
#line 152 "../src/utils.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 152 "../src/utils.vala"
	results = _tmp0_;
#line 152 "../src/utils.vala"
	results_length1 = 0;
#line 152 "../src/utils.vala"
	_results_size_ = results_length1;
#line 2004 "utils.c"
	{
		gchar* taggedInput = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** occurencesOfStartString = NULL;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint occurencesOfStartString_length1;
		gint _occurencesOfStartString_size_;
		GString* searchResult = NULL;
		GString* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
#line 154 "../src/utils.vala"
		_tmp1_ = g_strconcat ("#~#~#~#~#~#~#~#~#", startString, NULL);
#line 154 "../src/utils.vala"
		_tmp2_ = _tmp1_;
#line 154 "../src/utils.vala"
		_tmp3_ = string_replace (stringToBeSearched, startString, _tmp2_);
#line 154 "../src/utils.vala"
		_tmp4_ = _tmp3_;
#line 154 "../src/utils.vala"
		_g_free0 (_tmp2_);
#line 154 "../src/utils.vala"
		taggedInput = _tmp4_;
#line 155 "../src/utils.vala"
		_tmp5_ = taggedInput;
#line 155 "../src/utils.vala"
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "#~#~#~#~#~#~#~#~#", -1);
#line 155 "../src/utils.vala"
		occurencesOfStartString = _tmp7_;
#line 155 "../src/utils.vala"
		occurencesOfStartString_length1 = _vala_array_length (_tmp6_);
#line 155 "../src/utils.vala"
		_occurencesOfStartString_size_ = occurencesOfStartString_length1;
#line 156 "../src/utils.vala"
		_tmp8_ = g_string_new ("");
#line 156 "../src/utils.vala"
		searchResult = _tmp8_;
#line 157 "../src/utils.vala"
		_tmp9_ = occurencesOfStartString;
#line 157 "../src/utils.vala"
		_tmp9__length1 = occurencesOfStartString_length1;
#line 2051 "utils.c"
		{
			gchar** splitString_collection = NULL;
			gint splitString_collection_length1 = 0;
			gint _splitString_collection_size_ = 0;
			gint splitString_it = 0;
#line 157 "../src/utils.vala"
			splitString_collection = _tmp9_;
#line 157 "../src/utils.vala"
			splitString_collection_length1 = _tmp9__length1;
#line 157 "../src/utils.vala"
			for (splitString_it = 0; splitString_it < splitString_collection_length1; splitString_it = splitString_it + 1) {
#line 2063 "utils.c"
				gchar* _tmp10_;
				gchar* splitString = NULL;
#line 157 "../src/utils.vala"
				_tmp10_ = g_strdup (splitString_collection[splitString_it]);
#line 157 "../src/utils.vala"
				splitString = _tmp10_;
#line 2070 "utils.c"
				{
					gchar* _tmp11_ = NULL;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					GString* _tmp14_;
					GString* _tmp15_;
					const gchar* _tmp16_;
#line 158 "../src/utils.vala"
					_tmp12_ = splitString;
#line 158 "../src/utils.vala"
					_tmp13_ = bookworm_app_utils_extractBetweenTwoStrings (_tmp12_, startString, endString, &_inner_error0_);
#line 158 "../src/utils.vala"
					_tmp11_ = _tmp13_;
#line 158 "../src/utils.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "../src/utils.vala"
						_g_free0 (splitString);
#line 158 "../src/utils.vala"
						_g_string_free0 (searchResult);
#line 158 "../src/utils.vala"
						occurencesOfStartString = (_vala_array_free (occurencesOfStartString, occurencesOfStartString_length1, (GDestroyNotify) g_free), NULL);
#line 158 "../src/utils.vala"
						_g_free0 (taggedInput);
#line 2094 "utils.c"
						goto __catch0_g_error;
					}
#line 158 "../src/utils.vala"
					_tmp14_ = searchResult;
#line 158 "../src/utils.vala"
					g_string_assign (_tmp14_, _tmp11_);
#line 159 "../src/utils.vala"
					_tmp15_ = searchResult;
#line 159 "../src/utils.vala"
					_tmp16_ = _tmp15_->str;
#line 159 "../src/utils.vala"
					if (g_strcmp0 (_tmp16_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_NOT_AVAILABLE) != 0) {
#line 2107 "utils.c"
						GString* _tmp17_;
						const gchar* _tmp18_;
						gchar* _tmp19_;
#line 160 "../src/utils.vala"
						_tmp17_ = searchResult;
#line 160 "../src/utils.vala"
						_tmp18_ = _tmp17_->str;
#line 160 "../src/utils.vala"
						_tmp19_ = g_strdup (_tmp18_);
#line 160 "../src/utils.vala"
						_vala_array_add1 (&results, &results_length1, &_results_size_, _tmp19_);
#line 2119 "utils.c"
					}
#line 157 "../src/utils.vala"
					_g_free0 (_tmp11_);
#line 157 "../src/utils.vala"
					_g_free0 (splitString);
#line 2125 "utils.c"
				}
			}
		}
#line 153 "../src/utils.vala"
		_g_string_free0 (searchResult);
#line 153 "../src/utils.vala"
		occurencesOfStartString = (_vala_array_free (occurencesOfStartString, occurencesOfStartString_length1, (GDestroyNotify) g_free), NULL);
#line 153 "../src/utils.vala"
		_g_free0 (taggedInput);
#line 2135 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
#line 153 "../src/utils.vala"
		e = _inner_error0_;
#line 153 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 163 "../src/utils.vala"
		_tmp20_ = e;
#line 163 "../src/utils.vala"
		_tmp21_ = _tmp20_->message;
#line 163 "../src/utils.vala"
		_tmp22_ = g_strconcat ("Failure in utility multi extract between strings:", _tmp21_, NULL);
#line 163 "../src/utils.vala"
		_tmp23_ = _tmp22_;
#line 163 "../src/utils.vala"
		g_warning ("utils.vala:163: %s", _tmp23_);
#line 163 "../src/utils.vala"
		_g_free0 (_tmp23_);
#line 153 "../src/utils.vala"
		_g_error_free0 (e);
#line 2163 "utils.c"
	}
	__finally0:
#line 153 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "../src/utils.vala"
		results = (_vala_array_free (results, results_length1, (GDestroyNotify) g_free), NULL);
#line 153 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 153 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 153 "../src/utils.vala"
		return NULL;
#line 2176 "utils.c"
	}
#line 165 "../src/utils.vala"
	_tmp24_ = results;
#line 165 "../src/utils.vala"
	_tmp24__length1 = results_length1;
#line 165 "../src/utils.vala"
	if (result_length1) {
#line 165 "../src/utils.vala"
		*result_length1 = _tmp24__length1;
#line 2186 "utils.c"
	}
#line 165 "../src/utils.vala"
	result = _tmp24_;
#line 165 "../src/utils.vala"
	return result;
#line 2192 "utils.c"
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 179 "../src/utils.vala"
	if ((*length) == (*size)) {
#line 179 "../src/utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 179 "../src/utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2207 "utils.c"
	}
#line 179 "../src/utils.vala"
	(*array)[(*length)++] = value;
#line 179 "../src/utils.vala"
	(*array)[*length] = NULL;
#line 2213 "utils.c"
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
#line 1548 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1549 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1549 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1549 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1550 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1551 "glib-2.0.vapi"
		start = string_length + start;
#line 2249 "utils.c"
	}
#line 1553 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1554 "glib-2.0.vapi"
		end = string_length + end;
#line 2255 "utils.c"
	}
#line 1556 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1556 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2261 "utils.c"
	} else {
#line 1556 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2265 "utils.c"
	}
#line 1556 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1557 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1557 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2273 "utils.c"
	} else {
#line 1557 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2277 "utils.c"
	}
#line 1557 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1558 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1561 "glib-2.0.vapi"
	if (str == NULL) {
#line 1562 "glib-2.0.vapi"
		str_size = (gsize) 0;
#line 2287 "utils.c"
	} else {
		gint _tmp4_;
		gint _tmp5_;
#line 1564 "glib-2.0.vapi"
		_tmp4_ = strlen ((const gchar*) str);
#line 1564 "glib-2.0.vapi"
		_tmp5_ = _tmp4_;
#line 1564 "glib-2.0.vapi"
		str_size = (gsize) _tmp5_;
#line 2297 "utils.c"
	}
#line 1567 "glib-2.0.vapi"
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
#line 1567 "glib-2.0.vapi"
	_result_ = _tmp6_;
#line 1569 "glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1569 "glib-2.0.vapi"
	dest = (gchar*) _tmp7_;
#line 1571 "glib-2.0.vapi"
	_tmp8_ = dest;
#line 1571 "glib-2.0.vapi"
	memcpy (_tmp8_, self, (gsize) start);
#line 1572 "glib-2.0.vapi"
	_tmp9_ = dest;
#line 1572 "glib-2.0.vapi"
	dest = _tmp9_ + start;
#line 1574 "glib-2.0.vapi"
	if (str != NULL) {
#line 2317 "utils.c"
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 1575 "glib-2.0.vapi"
		_tmp10_ = dest;
#line 1575 "glib-2.0.vapi"
		memcpy (_tmp10_, str, str_size);
#line 1576 "glib-2.0.vapi"
		_tmp11_ = dest;
#line 1576 "glib-2.0.vapi"
		dest = _tmp11_ + str_size;
#line 2328 "utils.c"
	}
#line 1579 "glib-2.0.vapi"
	_tmp12_ = dest;
#line 1579 "glib-2.0.vapi"
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
#line 1581 "glib-2.0.vapi"
	_tmp13_ = _result_;
#line 1581 "glib-2.0.vapi"
	_result_ = NULL;
#line 1581 "glib-2.0.vapi"
	result = (gchar*) _tmp13_;
#line 1581 "glib-2.0.vapi"
	return result;
#line 2342 "utils.c"
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 183 "../src/utils.vala"
	if ((*length) == (*size)) {
#line 183 "../src/utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 183 "../src/utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2357 "utils.c"
	}
#line 183 "../src/utils.vala"
	(*array)[(*length)++] = value;
#line 183 "../src/utils.vala"
	(*array)[*length] = NULL;
#line 2363 "utils.c"
}

gchar**
bookworm_app_utils_getListOfRepeatingSegments (const gchar* data,
                                               const gchar* repeatingIdentifier,
                                               gint* result_length1,
                                               GError** error)
{
	gchar** segments = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint segments_length1;
	gint _segments_size_;
	gchar* currentSegment = NULL;
	gchar* _tmp2_;
	gint positionCurrentSegment = 0;
	gint positionOfNextSegment = 0;
	gboolean isSegmentsRemaning = FALSE;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** result;
#line 168 "../src/utils.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 168 "../src/utils.vala"
	g_return_val_if_fail (repeatingIdentifier != NULL, NULL);
#line 169 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 169 "../src/utils.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 169 "../src/utils.vala"
	_tmp1_[0] = _tmp0_;
#line 169 "../src/utils.vala"
	segments = _tmp1_;
#line 169 "../src/utils.vala"
	segments_length1 = 1;
#line 169 "../src/utils.vala"
	_segments_size_ = segments_length1;
#line 170 "../src/utils.vala"
	_tmp2_ = g_strdup ("");
#line 170 "../src/utils.vala"
	currentSegment = _tmp2_;
#line 171 "../src/utils.vala"
	positionCurrentSegment = string_index_of (data, repeatingIdentifier, 0);
#line 172 "../src/utils.vala"
	positionOfNextSegment = 0;
#line 173 "../src/utils.vala"
	isSegmentsRemaning = TRUE;
#line 174 "../src/utils.vala"
	if (positionCurrentSegment != -1) {
#line 175 "../src/utils.vala"
		while (TRUE) {
#line 175 "../src/utils.vala"
			if (!isSegmentsRemaning) {
#line 175 "../src/utils.vala"
				break;
#line 2419 "utils.c"
			}
#line 176 "../src/utils.vala"
			positionOfNextSegment = string_index_of (data, repeatingIdentifier, positionCurrentSegment + 1);
#line 177 "../src/utils.vala"
			if (positionOfNextSegment != -1) {
#line 2425 "utils.c"
				gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
#line 178 "../src/utils.vala"
				_tmp3_ = string_substring (data, (glong) positionCurrentSegment, (glong) (positionOfNextSegment - positionCurrentSegment));
#line 178 "../src/utils.vala"
				_g_free0 (currentSegment);
#line 178 "../src/utils.vala"
				currentSegment = _tmp3_;
#line 179 "../src/utils.vala"
				_tmp4_ = currentSegment;
#line 179 "../src/utils.vala"
				_tmp5_ = g_strdup (_tmp4_);
#line 179 "../src/utils.vala"
				_vala_array_add2 (&segments, &segments_length1, &_segments_size_, _tmp5_);
#line 180 "../src/utils.vala"
				_tmp6_ = string_splice (data, (glong) positionCurrentSegment, (glong) positionOfNextSegment, "");
#line 180 "../src/utils.vala"
				_tmp7_ = _tmp6_;
#line 180 "../src/utils.vala"
				_g_free0 (_tmp7_);
#line 181 "../src/utils.vala"
				positionCurrentSegment = positionOfNextSegment;
#line 2451 "utils.c"
			} else {
				gchar* _tmp8_;
#line 183 "../src/utils.vala"
				_tmp8_ = string_substring (data, (glong) positionCurrentSegment, (glong) -1);
#line 183 "../src/utils.vala"
				_vala_array_add3 (&segments, &segments_length1, &_segments_size_, _tmp8_);
#line 184 "../src/utils.vala"
				isSegmentsRemaning = FALSE;
#line 2460 "utils.c"
			}
		}
	} else {
		gchar* _tmp9_;
		gchar** _tmp10_;
#line 188 "../src/utils.vala"
		_tmp9_ = g_strdup (BOOKWORM_APP_CONSTANTS_TEXT_FOR_NOT_AVAILABLE);
#line 188 "../src/utils.vala"
		_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 188 "../src/utils.vala"
		_tmp10_[0] = _tmp9_;
#line 188 "../src/utils.vala"
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
#line 188 "../src/utils.vala"
		segments = _tmp10_;
#line 188 "../src/utils.vala"
		segments_length1 = 1;
#line 188 "../src/utils.vala"
		_segments_size_ = segments_length1;
#line 2480 "utils.c"
	}
#line 190 "../src/utils.vala"
	_tmp11_ = segments;
#line 190 "../src/utils.vala"
	_tmp11__length1 = segments_length1;
#line 190 "../src/utils.vala"
	if (result_length1) {
#line 190 "../src/utils.vala"
		*result_length1 = _tmp11__length1;
#line 2490 "utils.c"
	}
#line 190 "../src/utils.vala"
	result = _tmp11_;
#line 190 "../src/utils.vala"
	_g_free0 (currentSegment);
#line 190 "../src/utils.vala"
	return result;
#line 2498 "utils.c"
}

GeeArrayList*
bookworm_app_utils_convertMultiLinesToTableArray (const gchar* dataForList,
                                                  gint noOfColumns,
                                                  const gchar* columnToken,
                                                  GError** error)
{
	GeeArrayList* rowsData = NULL;
	GeeArrayList* _tmp0_;
	gchar** individualLines = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint individualLines_length1;
	gint _individualLines_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GeeArrayList* result;
#line 193 "../src/utils.vala"
	g_return_val_if_fail (dataForList != NULL, NULL);
#line 193 "../src/utils.vala"
	g_return_val_if_fail (columnToken != NULL, NULL);
#line 194 "../src/utils.vala"
	_tmp0_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 194 "../src/utils.vala"
	rowsData = _tmp0_;
#line 195 "../src/utils.vala"
	_tmp1_ = string_strip (dataForList);
#line 195 "../src/utils.vala"
	_tmp2_ = _tmp1_;
#line 195 "../src/utils.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", -1);
#line 195 "../src/utils.vala"
	_tmp5_ = _tmp4_;
#line 195 "../src/utils.vala"
	_tmp5__length1 = _vala_array_length (_tmp3_);
#line 195 "../src/utils.vala"
	_g_free0 (_tmp2_);
#line 195 "../src/utils.vala"
	individualLines = _tmp5_;
#line 195 "../src/utils.vala"
	individualLines_length1 = _tmp5__length1;
#line 195 "../src/utils.vala"
	_individualLines_size_ = individualLines_length1;
#line 196 "../src/utils.vala"
	_tmp6_ = individualLines;
#line 196 "../src/utils.vala"
	_tmp6__length1 = individualLines_length1;
#line 2551 "utils.c"
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
#line 196 "../src/utils.vala"
		line_collection = _tmp6_;
#line 196 "../src/utils.vala"
		line_collection_length1 = _tmp6__length1;
#line 196 "../src/utils.vala"
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
#line 2563 "utils.c"
			gchar* _tmp7_;
			gchar* line = NULL;
#line 196 "../src/utils.vala"
			_tmp7_ = g_strdup (line_collection[line_it]);
#line 196 "../src/utils.vala"
			line = _tmp7_;
#line 2570 "utils.c"
			{
				gchar** valuesInALine = NULL;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint valuesInALine_length1;
				gint _valuesInALine_size_;
				GeeArrayList* columnsData = NULL;
				GeeArrayList* _tmp14_;
				GeeArrayList* _tmp27_;
				GeeArrayList* _tmp28_;
#line 197 "../src/utils.vala"
				_tmp8_ = line;
#line 197 "../src/utils.vala"
				_tmp9_ = string_strip (_tmp8_);
#line 197 "../src/utils.vala"
				_tmp10_ = _tmp9_;
#line 197 "../src/utils.vala"
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, columnToken, -1);
#line 197 "../src/utils.vala"
				_tmp13_ = _tmp12_;
#line 197 "../src/utils.vala"
				_tmp13__length1 = _vala_array_length (_tmp11_);
#line 197 "../src/utils.vala"
				_g_free0 (_tmp10_);
#line 197 "../src/utils.vala"
				valuesInALine = _tmp13_;
#line 197 "../src/utils.vala"
				valuesInALine_length1 = _tmp13__length1;
#line 197 "../src/utils.vala"
				_valuesInALine_size_ = valuesInALine_length1;
#line 198 "../src/utils.vala"
				_tmp14_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 198 "../src/utils.vala"
				columnsData = _tmp14_;
#line 2610 "utils.c"
				{
					gint count = 0;
#line 199 "../src/utils.vala"
					count = 0;
#line 2615 "utils.c"
					{
						gboolean _tmp15_ = FALSE;
#line 199 "../src/utils.vala"
						_tmp15_ = TRUE;
#line 199 "../src/utils.vala"
						while (TRUE) {
#line 2622 "utils.c"
							gboolean _tmp17_ = FALSE;
							gchar** _tmp18_;
							gint _tmp18__length1;
#line 199 "../src/utils.vala"
							if (!_tmp15_) {
#line 2628 "utils.c"
								gint _tmp16_;
#line 199 "../src/utils.vala"
								_tmp16_ = count;
#line 199 "../src/utils.vala"
								count = _tmp16_ + 1;
#line 2634 "utils.c"
							}
#line 199 "../src/utils.vala"
							_tmp15_ = FALSE;
#line 199 "../src/utils.vala"
							if (!(count < noOfColumns)) {
#line 199 "../src/utils.vala"
								break;
#line 2642 "utils.c"
							}
#line 200 "../src/utils.vala"
							_tmp18_ = valuesInALine;
#line 200 "../src/utils.vala"
							_tmp18__length1 = valuesInALine_length1;
#line 200 "../src/utils.vala"
							if (count <= _tmp18__length1) {
#line 2650 "utils.c"
								gchar** _tmp19_;
								gint _tmp19__length1;
								const gchar* _tmp20_;
#line 200 "../src/utils.vala"
								_tmp19_ = valuesInALine;
#line 200 "../src/utils.vala"
								_tmp19__length1 = valuesInALine_length1;
#line 200 "../src/utils.vala"
								_tmp20_ = _tmp19_[count];
#line 200 "../src/utils.vala"
								_tmp17_ = _tmp20_ != NULL;
#line 2662 "utils.c"
							} else {
#line 200 "../src/utils.vala"
								_tmp17_ = FALSE;
#line 2666 "utils.c"
							}
#line 200 "../src/utils.vala"
							if (_tmp17_) {
#line 2670 "utils.c"
								GeeArrayList* _tmp21_;
								gchar** _tmp22_;
								gint _tmp22__length1;
								const gchar* _tmp23_;
								gchar* _tmp24_;
								gchar* _tmp25_;
#line 201 "../src/utils.vala"
								_tmp21_ = columnsData;
#line 201 "../src/utils.vala"
								_tmp22_ = valuesInALine;
#line 201 "../src/utils.vala"
								_tmp22__length1 = valuesInALine_length1;
#line 201 "../src/utils.vala"
								_tmp23_ = _tmp22_[count];
#line 201 "../src/utils.vala"
								_tmp24_ = string_strip (_tmp23_);
#line 201 "../src/utils.vala"
								_tmp25_ = _tmp24_;
#line 201 "../src/utils.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp25_);
#line 201 "../src/utils.vala"
								_g_free0 (_tmp25_);
#line 2693 "utils.c"
							} else {
								GeeArrayList* _tmp26_;
#line 203 "../src/utils.vala"
								_tmp26_ = columnsData;
#line 203 "../src/utils.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, " ");
#line 2700 "utils.c"
							}
						}
					}
				}
#line 206 "../src/utils.vala"
				_tmp27_ = rowsData;
#line 206 "../src/utils.vala"
				_tmp28_ = columnsData;
#line 206 "../src/utils.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
#line 196 "../src/utils.vala"
				_g_object_unref0 (columnsData);
#line 196 "../src/utils.vala"
				valuesInALine = (_vala_array_free (valuesInALine, valuesInALine_length1, (GDestroyNotify) g_free), NULL);
#line 196 "../src/utils.vala"
				_g_free0 (line);
#line 2717 "utils.c"
			}
		}
	}
#line 208 "../src/utils.vala"
	result = rowsData;
#line 208 "../src/utils.vala"
	individualLines = (_vala_array_free (individualLines, individualLines_length1, (GDestroyNotify) g_free), NULL);
#line 208 "../src/utils.vala"
	return result;
#line 2727 "utils.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 2754 "utils.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 2760 "utils.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2766 "utils.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2770 "utils.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2778 "utils.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2782 "utils.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 2794 "utils.c"
}

gchar*
bookworm_app_utils_extractXMLTag (const gchar* xmlData,
                                  const gchar* startTag,
                                  const gchar* endTag,
                                  GError** error)
{
	gchar* extractedData = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* result;
#line 211 "../src/utils.vala"
	g_return_val_if_fail (xmlData != NULL, NULL);
#line 211 "../src/utils.vala"
	g_return_val_if_fail (startTag != NULL, NULL);
#line 211 "../src/utils.vala"
	g_return_val_if_fail (endTag != NULL, NULL);
#line 212 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 212 "../src/utils.vala"
	extractedData = _tmp0_;
#line 213 "../src/utils.vala"
	if (string_contains (xmlData, startTag)) {
#line 213 "../src/utils.vala"
		_tmp1_ = string_contains (xmlData, endTag);
#line 2821 "utils.c"
	} else {
#line 213 "../src/utils.vala"
		_tmp1_ = FALSE;
#line 2825 "utils.c"
	}
#line 213 "../src/utils.vala"
	if (_tmp1_) {
#line 2829 "utils.c"
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
#line 214 "../src/utils.vala"
		_tmp2_ = strlen (startTag);
#line 214 "../src/utils.vala"
		_tmp3_ = _tmp2_;
#line 214 "../src/utils.vala"
		_tmp4_ = string_slice (xmlData, (glong) (string_index_of (xmlData, startTag, 0) + _tmp3_), (glong) string_index_of (xmlData, endTag, 0));
#line 214 "../src/utils.vala"
		_g_free0 (extractedData);
#line 214 "../src/utils.vala"
		extractedData = _tmp4_;
#line 2843 "utils.c"
	}
#line 216 "../src/utils.vala"
	result = extractedData;
#line 216 "../src/utils.vala"
	return result;
#line 2849 "utils.c"
}

gchar*
bookworm_app_utils_extractXMLAttribute (const gchar* xmlData,
                                        const gchar* tagName,
                                        const gchar* attributeID,
                                        const gchar* attributeName,
                                        GError** error)
{
	gchar* extractedData = NULL;
	gchar* _tmp0_;
	gint startPos = 0;
	gint endPos = 0;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* result;
#line 219 "../src/utils.vala"
	g_return_val_if_fail (xmlData != NULL, NULL);
#line 219 "../src/utils.vala"
	g_return_val_if_fail (tagName != NULL, NULL);
#line 219 "../src/utils.vala"
	g_return_val_if_fail (attributeID != NULL, NULL);
#line 219 "../src/utils.vala"
	g_return_val_if_fail (attributeName != NULL, NULL);
#line 220 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 220 "../src/utils.vala"
	extractedData = _tmp0_;
#line 221 "../src/utils.vala"
	startPos = -1;
#line 222 "../src/utils.vala"
	endPos = -1;
#line 224 "../src/utils.vala"
	_tmp2_ = g_strconcat ("<", tagName, NULL);
#line 224 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 224 "../src/utils.vala"
	_tmp4_ = string_contains (xmlData, _tmp3_);
#line 224 "../src/utils.vala"
	_g_free0 (_tmp3_);
#line 224 "../src/utils.vala"
	if (_tmp4_) {
#line 2894 "utils.c"
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 224 "../src/utils.vala"
		_tmp5_ = g_strconcat (attributeID, "=\"", NULL);
#line 224 "../src/utils.vala"
		_tmp6_ = _tmp5_;
#line 224 "../src/utils.vala"
		_tmp7_ = g_strconcat (_tmp6_, attributeName, NULL);
#line 224 "../src/utils.vala"
		_tmp8_ = _tmp7_;
#line 224 "../src/utils.vala"
		_tmp9_ = g_strconcat (_tmp8_, "\"", NULL);
#line 224 "../src/utils.vala"
		_tmp10_ = _tmp9_;
#line 224 "../src/utils.vala"
		_tmp1_ = string_contains (xmlData, _tmp10_);
#line 224 "../src/utils.vala"
		_g_free0 (_tmp10_);
#line 224 "../src/utils.vala"
		_g_free0 (_tmp8_);
#line 224 "../src/utils.vala"
		_g_free0 (_tmp6_);
#line 2921 "utils.c"
	} else {
#line 224 "../src/utils.vala"
		_tmp1_ = FALSE;
#line 2925 "utils.c"
	}
#line 224 "../src/utils.vala"
	if (_tmp1_) {
#line 2929 "utils.c"
		gchar* tagData = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
#line 226 "../src/utils.vala"
		_tmp11_ = g_strconcat ("<", tagName, NULL);
#line 226 "../src/utils.vala"
		_tmp12_ = _tmp11_;
#line 226 "../src/utils.vala"
		_tmp13_ = g_strconcat ("<", tagName, NULL);
#line 226 "../src/utils.vala"
		_tmp14_ = _tmp13_;
#line 226 "../src/utils.vala"
		_tmp15_ = string_slice (xmlData, (glong) string_index_of (xmlData, _tmp12_, 0), (glong) string_index_of (xmlData, ">", string_index_of (xmlData, _tmp14_, 0) + 1));
#line 226 "../src/utils.vala"
		_tmp16_ = _tmp15_;
#line 226 "../src/utils.vala"
		_g_free0 (_tmp14_);
#line 226 "../src/utils.vala"
		_g_free0 (_tmp12_);
#line 226 "../src/utils.vala"
		tagData = _tmp16_;
#line 227 "../src/utils.vala"
		_tmp17_ = tagData;
#line 227 "../src/utils.vala"
		_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) -1);
#line 227 "../src/utils.vala"
		_tmp19_ = _tmp18_;
#line 227 "../src/utils.vala"
		_tmp20_ = string_contains (_tmp19_, "value");
#line 227 "../src/utils.vala"
		_g_free0 (_tmp19_);
#line 227 "../src/utils.vala"
		if (_tmp20_) {
#line 2973 "utils.c"
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
#line 228 "../src/utils.vala"
			_tmp21_ = g_strconcat (attributeID, "=\"", NULL);
#line 228 "../src/utils.vala"
			_tmp22_ = _tmp21_;
#line 228 "../src/utils.vala"
			_tmp23_ = g_strconcat (_tmp22_, attributeName, NULL);
#line 228 "../src/utils.vala"
			_tmp24_ = _tmp23_;
#line 228 "../src/utils.vala"
			_tmp25_ = g_strconcat (_tmp24_, "\"", NULL);
#line 228 "../src/utils.vala"
			_tmp26_ = _tmp25_;
#line 228 "../src/utils.vala"
			startPos = string_index_of (xmlData, "value=\"", string_index_of (xmlData, _tmp26_, 0)) + 7;
#line 228 "../src/utils.vala"
			_g_free0 (_tmp26_);
#line 228 "../src/utils.vala"
			_g_free0 (_tmp24_);
#line 228 "../src/utils.vala"
			_g_free0 (_tmp22_);
#line 229 "../src/utils.vala"
			endPos = string_index_of (xmlData, "\"", startPos);
#line 3002 "utils.c"
		} else {
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
#line 231 "../src/utils.vala"
			_tmp27_ = g_strconcat ("<", tagName, NULL);
#line 231 "../src/utils.vala"
			_tmp28_ = _tmp27_;
#line 231 "../src/utils.vala"
			startPos = string_index_of (xmlData, ">", string_index_of (xmlData, _tmp28_, 0)) + 1;
#line 231 "../src/utils.vala"
			_g_free0 (_tmp28_);
#line 232 "../src/utils.vala"
			_tmp29_ = g_strconcat ("</", tagName, NULL);
#line 232 "../src/utils.vala"
			_tmp30_ = _tmp29_;
#line 232 "../src/utils.vala"
			_tmp31_ = g_strconcat (_tmp30_, ">", NULL);
#line 232 "../src/utils.vala"
			_tmp32_ = _tmp31_;
#line 232 "../src/utils.vala"
			_tmp33_ = g_strconcat ("<", tagName, NULL);
#line 232 "../src/utils.vala"
			_tmp34_ = _tmp33_;
#line 232 "../src/utils.vala"
			endPos = string_index_of (xmlData, _tmp32_, string_index_of (xmlData, _tmp34_, 0));
#line 232 "../src/utils.vala"
			_g_free0 (_tmp34_);
#line 232 "../src/utils.vala"
			_g_free0 (_tmp32_);
#line 232 "../src/utils.vala"
			_g_free0 (_tmp30_);
#line 3040 "utils.c"
		}
#line 234 "../src/utils.vala"
		if (startPos != -1) {
#line 234 "../src/utils.vala"
			_tmp36_ = endPos != -1;
#line 3046 "utils.c"
		} else {
#line 234 "../src/utils.vala"
			_tmp36_ = FALSE;
#line 3050 "utils.c"
		}
#line 234 "../src/utils.vala"
		if (_tmp36_) {
#line 234 "../src/utils.vala"
			_tmp35_ = endPos > startPos;
#line 3056 "utils.c"
		} else {
#line 234 "../src/utils.vala"
			_tmp35_ = FALSE;
#line 3060 "utils.c"
		}
#line 234 "../src/utils.vala"
		if (_tmp35_) {
#line 3064 "utils.c"
			gchar* _tmp37_;
#line 235 "../src/utils.vala"
			_tmp37_ = string_slice (xmlData, (glong) startPos, (glong) endPos);
#line 235 "../src/utils.vala"
			_g_free0 (extractedData);
#line 235 "../src/utils.vala"
			extractedData = _tmp37_;
#line 3072 "utils.c"
		}
#line 224 "../src/utils.vala"
		_g_free0 (tagData);
#line 3076 "utils.c"
	}
#line 238 "../src/utils.vala"
	result = extractedData;
#line 238 "../src/utils.vala"
	return result;
#line 3082 "utils.c"
}

GeeHashMap*
bookworm_app_utils_extractTagAttributes (const gchar* xmlData,
                                         const gchar* tagName,
                                         const gchar* attributeID,
                                         gboolean doesAttributeValueExists,
                                         GError** error)
{
	GeeHashMap* AttributeMap = NULL;
	GeeHashMap* _tmp0_;
	gint positionOfStartTag = 0;
	gint positionOfEndTag = 0;
	gint positionOfStartAttributeValue = 0;
	gint positionOfEndAttributeValue = 0;
	gint positionOfStartTagValue = 0;
	gint positionOfEndTagValue = 0;
	gchar* qualifiedTagName = NULL;
	gchar* _tmp1_;
	gchar* qualifiedAttributeID = NULL;
	gchar* _tmp2_;
	GString* attributeValue = NULL;
	GString* _tmp3_;
	GString* tagValue = NULL;
	GString* _tmp4_;
	GeeHashMap* result;
#line 241 "../src/utils.vala"
	g_return_val_if_fail (xmlData != NULL, NULL);
#line 241 "../src/utils.vala"
	g_return_val_if_fail (tagName != NULL, NULL);
#line 241 "../src/utils.vala"
	g_return_val_if_fail (attributeID != NULL, NULL);
#line 242 "../src/utils.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 242 "../src/utils.vala"
	AttributeMap = _tmp0_;
#line 243 "../src/utils.vala"
	positionOfStartTag = 0;
#line 244 "../src/utils.vala"
	positionOfEndTag = 0;
#line 245 "../src/utils.vala"
	positionOfStartAttributeValue = 0;
#line 246 "../src/utils.vala"
	positionOfEndAttributeValue = 0;
#line 247 "../src/utils.vala"
	positionOfStartTagValue = 0;
#line 248 "../src/utils.vala"
	positionOfEndTagValue = 0;
#line 249 "../src/utils.vala"
	_tmp1_ = g_strconcat ("<", tagName, NULL);
#line 249 "../src/utils.vala"
	qualifiedTagName = _tmp1_;
#line 250 "../src/utils.vala"
	_tmp2_ = g_strconcat (attributeID, "=\"", NULL);
#line 250 "../src/utils.vala"
	qualifiedAttributeID = _tmp2_;
#line 251 "../src/utils.vala"
	_tmp3_ = g_string_new ("");
#line 251 "../src/utils.vala"
	attributeValue = _tmp3_;
#line 252 "../src/utils.vala"
	_tmp4_ = g_string_new ("");
#line 252 "../src/utils.vala"
	tagValue = _tmp4_;
#line 254 "../src/utils.vala"
	while (TRUE) {
#line 3149 "utils.c"
		const gchar* _tmp5_;
#line 254 "../src/utils.vala"
		if (!(positionOfStartTag != -1)) {
#line 254 "../src/utils.vala"
			break;
#line 3155 "utils.c"
		}
#line 255 "../src/utils.vala"
		_tmp5_ = qualifiedTagName;
#line 255 "../src/utils.vala"
		positionOfStartTag = string_index_of (xmlData, _tmp5_, positionOfStartTag);
#line 256 "../src/utils.vala"
		if (doesAttributeValueExists) {
#line 257 "../src/utils.vala"
			positionOfEndTag = string_index_of (xmlData, "/>", positionOfStartTag);
#line 3165 "utils.c"
		} else {
#line 259 "../src/utils.vala"
			positionOfEndTag = string_index_of (xmlData, ">", positionOfStartTag);
#line 3169 "utils.c"
		}
#line 262 "../src/utils.vala"
		if (positionOfEndTag > positionOfStartTag) {
#line 3173 "utils.c"
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
#line 263 "../src/utils.vala"
			_tmp6_ = qualifiedAttributeID;
#line 263 "../src/utils.vala"
			positionOfStartAttributeValue = string_index_of (xmlData, _tmp6_, positionOfStartTag);
#line 264 "../src/utils.vala"
			_tmp7_ = qualifiedAttributeID;
#line 264 "../src/utils.vala"
			_tmp8_ = strlen (_tmp7_);
#line 264 "../src/utils.vala"
			_tmp9_ = _tmp8_;
#line 264 "../src/utils.vala"
			positionOfEndAttributeValue = string_index_of (xmlData, "\"", positionOfStartAttributeValue + _tmp9_);
#line 265 "../src/utils.vala"
			if (positionOfStartAttributeValue != -1) {
#line 265 "../src/utils.vala"
				_tmp11_ = positionOfEndAttributeValue != -1;
#line 3196 "utils.c"
			} else {
#line 265 "../src/utils.vala"
				_tmp11_ = FALSE;
#line 3200 "utils.c"
			}
#line 265 "../src/utils.vala"
			if (_tmp11_) {
#line 265 "../src/utils.vala"
				_tmp10_ = positionOfEndAttributeValue > positionOfStartAttributeValue;
#line 3206 "utils.c"
			} else {
#line 265 "../src/utils.vala"
				_tmp10_ = FALSE;
#line 3210 "utils.c"
			}
#line 265 "../src/utils.vala"
			if (_tmp10_) {
#line 3214 "utils.c"
				GString* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
#line 266 "../src/utils.vala"
				_tmp12_ = attributeValue;
#line 266 "../src/utils.vala"
				_tmp13_ = qualifiedAttributeID;
#line 266 "../src/utils.vala"
				_tmp14_ = strlen (_tmp13_);
#line 266 "../src/utils.vala"
				_tmp15_ = _tmp14_;
#line 266 "../src/utils.vala"
				_tmp16_ = string_slice (xmlData, (glong) (positionOfStartAttributeValue + _tmp15_), (glong) positionOfEndAttributeValue);
#line 266 "../src/utils.vala"
				_tmp17_ = _tmp16_;
#line 266 "../src/utils.vala"
				g_string_assign (_tmp12_, _tmp17_);
#line 266 "../src/utils.vala"
				_g_free0 (_tmp17_);
#line 3237 "utils.c"
			} else {
				GString* _tmp18_;
#line 268 "../src/utils.vala"
				_tmp18_ = attributeValue;
#line 268 "../src/utils.vala"
				g_string_assign (_tmp18_, "");
#line 3244 "utils.c"
			}
#line 270 "../src/utils.vala"
			if (doesAttributeValueExists) {
#line 3248 "utils.c"
				gint _tmp19_;
				gint _tmp20_;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				GString* _tmp29_;
				const gchar* _tmp30_;
#line 271 "../src/utils.vala"
				positionOfStartTagValue = string_index_of (xmlData, "value=\"", positionOfStartTag);
#line 272 "../src/utils.vala"
				_tmp19_ = strlen ("value=\"");
#line 272 "../src/utils.vala"
				_tmp20_ = _tmp19_;
#line 272 "../src/utils.vala"
				positionOfEndTagValue = string_index_of (xmlData, "\"", positionOfStartTagValue + _tmp20_);
#line 273 "../src/utils.vala"
				if (positionOfStartTagValue != -1) {
#line 273 "../src/utils.vala"
					_tmp22_ = positionOfEndTagValue != -1;
#line 3267 "utils.c"
				} else {
#line 273 "../src/utils.vala"
					_tmp22_ = FALSE;
#line 3271 "utils.c"
				}
#line 273 "../src/utils.vala"
				if (_tmp22_) {
#line 273 "../src/utils.vala"
					_tmp21_ = positionOfEndTagValue > positionOfStartTagValue;
#line 3277 "utils.c"
				} else {
#line 273 "../src/utils.vala"
					_tmp21_ = FALSE;
#line 3281 "utils.c"
				}
#line 273 "../src/utils.vala"
				if (_tmp21_) {
#line 3285 "utils.c"
					GString* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
#line 274 "../src/utils.vala"
					_tmp23_ = tagValue;
#line 274 "../src/utils.vala"
					_tmp24_ = strlen ("value=\"");
#line 274 "../src/utils.vala"
					_tmp25_ = _tmp24_;
#line 274 "../src/utils.vala"
					_tmp26_ = string_slice (xmlData, (glong) (positionOfStartTagValue + _tmp25_), (glong) positionOfEndTagValue);
#line 274 "../src/utils.vala"
					_tmp27_ = _tmp26_;
#line 274 "../src/utils.vala"
					g_string_assign (_tmp23_, _tmp27_);
#line 274 "../src/utils.vala"
					_g_free0 (_tmp27_);
#line 3305 "utils.c"
				} else {
					GString* _tmp28_;
#line 276 "../src/utils.vala"
					_tmp28_ = tagValue;
#line 276 "../src/utils.vala"
					g_string_assign (_tmp28_, "");
#line 3312 "utils.c"
				}
#line 279 "../src/utils.vala"
				_tmp29_ = attributeValue;
#line 279 "../src/utils.vala"
				_tmp30_ = _tmp29_->str;
#line 279 "../src/utils.vala"
				if (g_strcmp0 (_tmp30_, "") != 0) {
#line 3320 "utils.c"
					GeeHashMap* _tmp31_;
					GString* _tmp32_;
					const gchar* _tmp33_;
					GString* _tmp34_;
					const gchar* _tmp35_;
#line 280 "../src/utils.vala"
					_tmp31_ = AttributeMap;
#line 280 "../src/utils.vala"
					_tmp32_ = attributeValue;
#line 280 "../src/utils.vala"
					_tmp33_ = _tmp32_->str;
#line 280 "../src/utils.vala"
					_tmp34_ = tagValue;
#line 280 "../src/utils.vala"
					_tmp35_ = _tmp34_->str;
#line 280 "../src/utils.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp33_, _tmp35_);
#line 3338 "utils.c"
				}
			} else {
				gboolean _tmp36_ = FALSE;
				gboolean _tmp37_ = FALSE;
				GString* _tmp42_;
				const gchar* _tmp43_;
#line 283 "../src/utils.vala"
				positionOfStartTagValue = string_index_of (xmlData, ">", positionOfStartTag);
#line 284 "../src/utils.vala"
				positionOfEndTagValue = string_index_of (xmlData, "</", positionOfStartTagValue + 1);
#line 285 "../src/utils.vala"
				if (positionOfStartTagValue != -1) {
#line 285 "../src/utils.vala"
					_tmp37_ = positionOfEndTagValue != -1;
#line 3353 "utils.c"
				} else {
#line 285 "../src/utils.vala"
					_tmp37_ = FALSE;
#line 3357 "utils.c"
				}
#line 285 "../src/utils.vala"
				if (_tmp37_) {
#line 285 "../src/utils.vala"
					_tmp36_ = positionOfEndTagValue > positionOfStartTagValue;
#line 3363 "utils.c"
				} else {
#line 285 "../src/utils.vala"
					_tmp36_ = FALSE;
#line 3367 "utils.c"
				}
#line 285 "../src/utils.vala"
				if (_tmp36_) {
#line 3371 "utils.c"
					GString* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
#line 286 "../src/utils.vala"
					_tmp38_ = tagValue;
#line 286 "../src/utils.vala"
					_tmp39_ = string_slice (xmlData, (glong) (positionOfStartTagValue + 1), (glong) positionOfEndTagValue);
#line 286 "../src/utils.vala"
					_tmp40_ = _tmp39_;
#line 286 "../src/utils.vala"
					g_string_assign (_tmp38_, _tmp40_);
#line 286 "../src/utils.vala"
					_g_free0 (_tmp40_);
#line 3385 "utils.c"
				} else {
					GString* _tmp41_;
#line 288 "../src/utils.vala"
					_tmp41_ = tagValue;
#line 288 "../src/utils.vala"
					g_string_assign (_tmp41_, "");
#line 3392 "utils.c"
				}
#line 290 "../src/utils.vala"
				_tmp42_ = attributeValue;
#line 290 "../src/utils.vala"
				_tmp43_ = _tmp42_->str;
#line 290 "../src/utils.vala"
				if (g_strcmp0 (_tmp43_, "") != 0) {
#line 3400 "utils.c"
					gboolean _tmp44_ = FALSE;
					GString* _tmp45_;
					const gchar* _tmp46_;
#line 291 "../src/utils.vala"
					_tmp45_ = tagValue;
#line 291 "../src/utils.vala"
					_tmp46_ = _tmp45_->str;
#line 291 "../src/utils.vala"
					if (string_contains (_tmp46_, "<")) {
#line 291 "../src/utils.vala"
						_tmp44_ = TRUE;
#line 3412 "utils.c"
					} else {
						GString* _tmp47_;
						const gchar* _tmp48_;
#line 291 "../src/utils.vala"
						_tmp47_ = tagValue;
#line 291 "../src/utils.vala"
						_tmp48_ = _tmp47_->str;
#line 291 "../src/utils.vala"
						_tmp44_ = string_contains (_tmp48_, ">");
#line 3422 "utils.c"
					}
#line 291 "../src/utils.vala"
					if (!_tmp44_) {
#line 3426 "utils.c"
						GeeHashMap* _tmp49_;
						GString* _tmp50_;
						const gchar* _tmp51_;
						GString* _tmp52_;
						const gchar* _tmp53_;
#line 292 "../src/utils.vala"
						_tmp49_ = AttributeMap;
#line 292 "../src/utils.vala"
						_tmp50_ = attributeValue;
#line 292 "../src/utils.vala"
						_tmp51_ = _tmp50_->str;
#line 292 "../src/utils.vala"
						_tmp52_ = tagValue;
#line 292 "../src/utils.vala"
						_tmp53_ = _tmp52_->str;
#line 292 "../src/utils.vala"
						gee_abstract_map_set ((GeeAbstractMap*) _tmp49_, _tmp51_, _tmp53_);
#line 3444 "utils.c"
					}
				}
			}
		}
#line 296 "../src/utils.vala"
		positionOfStartTag = positionOfEndTag;
#line 3451 "utils.c"
	}
#line 298 "../src/utils.vala"
	result = AttributeMap;
#line 298 "../src/utils.vala"
	_g_string_free0 (tagValue);
#line 298 "../src/utils.vala"
	_g_string_free0 (attributeValue);
#line 298 "../src/utils.vala"
	_g_free0 (qualifiedAttributeID);
#line 298 "../src/utils.vala"
	_g_free0 (qualifiedTagName);
#line 298 "../src/utils.vala"
	return result;
#line 3465 "utils.c"
}

gchar*
bookworm_app_utils_extractNestedXMLAttribute (const gchar* xmlData,
                                              const gchar* startTag,
                                              const gchar* endTag,
                                              gint nestCount,
                                              GError** error)
{
	gchar* extractedData = NULL;
	gchar* _tmp0_;
	GString* xmlDataBuffer = NULL;
	GString* _tmp1_;
	gint positionOfStartTag = 0;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gint positionOfEngTag = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar* result;
#line 301 "../src/utils.vala"
	g_return_val_if_fail (xmlData != NULL, NULL);
#line 301 "../src/utils.vala"
	g_return_val_if_fail (startTag != NULL, NULL);
#line 301 "../src/utils.vala"
	g_return_val_if_fail (endTag != NULL, NULL);
#line 302 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 302 "../src/utils.vala"
	extractedData = _tmp0_;
#line 303 "../src/utils.vala"
	_tmp1_ = g_string_new (xmlData);
#line 303 "../src/utils.vala"
	xmlDataBuffer = _tmp1_;
#line 304 "../src/utils.vala"
	positionOfStartTag = string_index_of (xmlData, startTag, 0);
#line 305 "../src/utils.vala"
	if (positionOfStartTag != -1) {
#line 3504 "utils.c"
		GString* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 306 "../src/utils.vala"
		_tmp2_ = xmlDataBuffer;
#line 306 "../src/utils.vala"
		_tmp3_ = string_slice (xmlData, (glong) positionOfStartTag, (glong) -1);
#line 306 "../src/utils.vala"
		_tmp4_ = _tmp3_;
#line 306 "../src/utils.vala"
		g_string_assign (_tmp2_, _tmp4_);
#line 306 "../src/utils.vala"
		_g_free0 (_tmp4_);
#line 3518 "utils.c"
	}
#line 307 "../src/utils.vala"
	_tmp5_ = xmlDataBuffer;
#line 307 "../src/utils.vala"
	_tmp6_ = _tmp5_->str;
#line 307 "../src/utils.vala"
	positionOfStartTag = string_index_of (_tmp6_, startTag, 0);
#line 308 "../src/utils.vala"
	positionOfEngTag = 0;
#line 3528 "utils.c"
	{
		gint count = 0;
#line 309 "../src/utils.vala"
		count = 0;
#line 3533 "utils.c"
		{
			gboolean _tmp7_ = FALSE;
#line 309 "../src/utils.vala"
			_tmp7_ = TRUE;
#line 309 "../src/utils.vala"
			while (TRUE) {
#line 3540 "utils.c"
				GString* _tmp9_;
				const gchar* _tmp10_;
#line 309 "../src/utils.vala"
				if (!_tmp7_) {
#line 3545 "utils.c"
					gint _tmp8_;
#line 309 "../src/utils.vala"
					_tmp8_ = count;
#line 309 "../src/utils.vala"
					count = _tmp8_ + 1;
#line 3551 "utils.c"
				}
#line 309 "../src/utils.vala"
				_tmp7_ = FALSE;
#line 309 "../src/utils.vala"
				if (!(count < nestCount)) {
#line 309 "../src/utils.vala"
					break;
#line 3559 "utils.c"
				}
#line 310 "../src/utils.vala"
				_tmp9_ = xmlDataBuffer;
#line 310 "../src/utils.vala"
				_tmp10_ = _tmp9_->str;
#line 310 "../src/utils.vala"
				positionOfEngTag = string_index_of (_tmp10_, endTag, (positionOfStartTag + positionOfEngTag) + 1);
#line 3567 "utils.c"
			}
		}
	}
#line 312 "../src/utils.vala"
	if (positionOfStartTag != -1) {
#line 312 "../src/utils.vala"
		_tmp12_ = positionOfEngTag != -1;
#line 3575 "utils.c"
	} else {
#line 312 "../src/utils.vala"
		_tmp12_ = FALSE;
#line 3579 "utils.c"
	}
#line 312 "../src/utils.vala"
	if (_tmp12_) {
#line 3583 "utils.c"
		gint _tmp13_;
		gint _tmp14_;
#line 312 "../src/utils.vala"
		_tmp13_ = strlen (startTag);
#line 312 "../src/utils.vala"
		_tmp14_ = _tmp13_;
#line 312 "../src/utils.vala"
		_tmp11_ = positionOfEngTag > (positionOfStartTag + _tmp14_);
#line 3592 "utils.c"
	} else {
#line 312 "../src/utils.vala"
		_tmp11_ = FALSE;
#line 3596 "utils.c"
	}
#line 312 "../src/utils.vala"
	if (_tmp11_) {
#line 3600 "utils.c"
		GString* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
#line 313 "../src/utils.vala"
		_tmp15_ = xmlDataBuffer;
#line 313 "../src/utils.vala"
		_tmp16_ = _tmp15_->str;
#line 313 "../src/utils.vala"
		_tmp17_ = strlen (startTag);
#line 313 "../src/utils.vala"
		_tmp18_ = _tmp17_;
#line 313 "../src/utils.vala"
		_tmp19_ = string_slice (_tmp16_, (glong) (positionOfStartTag + _tmp18_), (glong) positionOfEngTag);
#line 313 "../src/utils.vala"
		_g_free0 (extractedData);
#line 313 "../src/utils.vala"
		extractedData = _tmp19_;
#line 3620 "utils.c"
	}
#line 315 "../src/utils.vala"
	result = extractedData;
#line 315 "../src/utils.vala"
	_g_string_free0 (xmlDataBuffer);
#line 315 "../src/utils.vala"
	return result;
#line 3628 "utils.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 3665 "utils.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 3671 "utils.c"
}

gchar*
bookworm_app_utils_fileOperations (const gchar* operation,
                                   const gchar* path,
                                   const gchar* filename,
                                   const gchar* contents)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GString* _result_ = NULL;
	GString* _tmp10_;
	gchar* data = NULL;
	gchar* _tmp11_;
	GFile* fileDir = NULL;
	GFile* file = NULL;
	gchar* _tmp230_;
	gchar* _tmp231_;
	gchar* _tmp232_;
	gchar* _tmp233_;
	GString* _tmp234_;
	const gchar* _tmp235_;
	gchar* _tmp236_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 318 "../src/utils.vala"
	g_return_val_if_fail (operation != NULL, NULL);
#line 318 "../src/utils.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 318 "../src/utils.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 318 "../src/utils.vala"
	g_return_val_if_fail (contents != NULL, NULL);
#line 319 "../src/utils.vala"
	_tmp0_ = g_strconcat ("Started file operation[", operation, NULL);
#line 319 "../src/utils.vala"
	_tmp1_ = _tmp0_;
#line 319 "../src/utils.vala"
	_tmp2_ = g_strconcat (_tmp1_, "], for path=", NULL);
#line 319 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 319 "../src/utils.vala"
	_tmp4_ = g_strconcat (_tmp3_, path, NULL);
#line 319 "../src/utils.vala"
	_tmp5_ = _tmp4_;
#line 319 "../src/utils.vala"
	_tmp6_ = g_strconcat (_tmp5_, ", filename=", NULL);
#line 319 "../src/utils.vala"
	_tmp7_ = _tmp6_;
#line 319 "../src/utils.vala"
	_tmp8_ = g_strconcat (_tmp7_, filename, NULL);
#line 319 "../src/utils.vala"
	_tmp9_ = _tmp8_;
#line 319 "../src/utils.vala"
	g_debug ("utils.vala:319: %s", _tmp9_);
#line 319 "../src/utils.vala"
	_g_free0 (_tmp9_);
#line 319 "../src/utils.vala"
	_g_free0 (_tmp7_);
#line 319 "../src/utils.vala"
	_g_free0 (_tmp5_);
#line 319 "../src/utils.vala"
	_g_free0 (_tmp3_);
#line 319 "../src/utils.vala"
	_g_free0 (_tmp1_);
#line 320 "../src/utils.vala"
	_tmp10_ = g_string_new ("false");
#line 320 "../src/utils.vala"
	_result_ = _tmp10_;
#line 321 "../src/utils.vala"
	_tmp11_ = g_strdup ("");
#line 321 "../src/utils.vala"
	data = _tmp11_;
#line 322 "../src/utils.vala"
	fileDir = NULL;
#line 323 "../src/utils.vala"
	file = NULL;
#line 3757 "utils.c"
	{
		gboolean _tmp12_ = FALSE;
		gboolean _tmp16_ = FALSE;
#line 325 "../src/utils.vala"
		if (path != NULL) {
#line 325 "../src/utils.vala"
			_tmp12_ = TRUE;
#line 3765 "utils.c"
		} else {
			gint _tmp13_;
			gint _tmp14_;
#line 325 "../src/utils.vala"
			_tmp13_ = strlen (path);
#line 325 "../src/utils.vala"
			_tmp14_ = _tmp13_;
#line 325 "../src/utils.vala"
			_tmp12_ = _tmp14_ > 1;
#line 3775 "utils.c"
		}
#line 325 "../src/utils.vala"
		if (_tmp12_) {
#line 3779 "utils.c"
			GFile* _tmp15_;
#line 326 "../src/utils.vala"
			_tmp15_ = g_file_new_for_commandline_arg (path);
#line 326 "../src/utils.vala"
			_g_object_unref0 (fileDir);
#line 326 "../src/utils.vala"
			fileDir = _tmp15_;
#line 3787 "utils.c"
		}
#line 328 "../src/utils.vala"
		if (filename != NULL) {
#line 3791 "utils.c"
			gint _tmp17_;
			gint _tmp18_;
#line 328 "../src/utils.vala"
			_tmp17_ = strlen (filename);
#line 328 "../src/utils.vala"
			_tmp18_ = _tmp17_;
#line 328 "../src/utils.vala"
			_tmp16_ = _tmp18_ > 1;
#line 3800 "utils.c"
		} else {
#line 328 "../src/utils.vala"
			_tmp16_ = FALSE;
#line 3804 "utils.c"
		}
#line 328 "../src/utils.vala"
		if (_tmp16_) {
#line 3808 "utils.c"
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GFile* _tmp23_;
#line 329 "../src/utils.vala"
			_tmp19_ = g_strconcat (path, "/", NULL);
#line 329 "../src/utils.vala"
			_tmp20_ = _tmp19_;
#line 329 "../src/utils.vala"
			_tmp21_ = g_strconcat (_tmp20_, filename, NULL);
#line 329 "../src/utils.vala"
			_tmp22_ = _tmp21_;
#line 329 "../src/utils.vala"
			_tmp23_ = g_file_new_for_path (_tmp22_);
#line 329 "../src/utils.vala"
			_g_object_unref0 (file);
#line 329 "../src/utils.vala"
			file = _tmp23_;
#line 329 "../src/utils.vala"
			_g_free0 (_tmp22_);
#line 329 "../src/utils.vala"
			_g_free0 (_tmp20_);
#line 3832 "utils.c"
		} else {
			GFile* _tmp24_;
#line 331 "../src/utils.vala"
			_tmp24_ = g_file_new_for_path (path);
#line 331 "../src/utils.vala"
			_g_object_unref0 (file);
#line 331 "../src/utils.vala"
			file = _tmp24_;
#line 3841 "utils.c"
		}
#line 333 "../src/utils.vala"
		if (g_strcmp0 ("CREATEDIR", operation) == 0) {
#line 3845 "utils.c"
			GFile* _tmp25_;
#line 335 "../src/utils.vala"
			_tmp25_ = fileDir;
#line 335 "../src/utils.vala"
			if (!g_file_query_exists (_tmp25_, NULL)) {
#line 3851 "utils.c"
				GFile* _tmp26_;
				GString* _tmp27_;
				GIOChannel* _tmp28_ = NULL;
				GIOChannel* _tmp29_;
				GFile* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
#line 337 "../src/utils.vala"
				_tmp26_ = fileDir;
#line 337 "../src/utils.vala"
				g_file_make_directory (_tmp26_, NULL, &_inner_error0_);
#line 337 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3867 "utils.c"
					goto __catch0_g_error;
				}
#line 338 "../src/utils.vala"
				_tmp27_ = _result_;
#line 338 "../src/utils.vala"
				g_string_assign (_tmp27_, "true");
#line 340 "../src/utils.vala"
				_tmp29_ = g_io_channel_new_file (path, "r", &_inner_error0_);
#line 340 "../src/utils.vala"
				_tmp28_ = _tmp29_;
#line 340 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3880 "utils.c"
					goto __catch0_g_error;
				}
#line 340 "../src/utils.vala"
				close (g_io_channel_unix_get_fd (_tmp28_));
#line 341 "../src/utils.vala"
				_tmp30_ = fileDir;
#line 341 "../src/utils.vala"
				_tmp31_ = g_file_get_path (_tmp30_);
#line 341 "../src/utils.vala"
				_tmp32_ = _tmp31_;
#line 341 "../src/utils.vala"
				_tmp33_ = g_strconcat ("Directory created:", _tmp32_, NULL);
#line 341 "../src/utils.vala"
				_tmp34_ = _tmp33_;
#line 341 "../src/utils.vala"
				g_debug ("utils.vala:341: %s", _tmp34_);
#line 341 "../src/utils.vala"
				_g_free0 (_tmp34_);
#line 341 "../src/utils.vala"
				_g_free0 (_tmp32_);
#line 335 "../src/utils.vala"
				_g_io_channel_unref0 (_tmp28_);
#line 3903 "utils.c"
			} else {
				GString* _tmp35_;
#line 344 "../src/utils.vala"
				_tmp35_ = _result_;
#line 344 "../src/utils.vala"
				g_string_assign (_tmp35_, "true");
#line 3910 "utils.c"
			}
		}
#line 347 "../src/utils.vala"
		if (g_strcmp0 ("WRITE", operation) == 0) {
#line 3915 "utils.c"
			GFile* _tmp36_;
#line 349 "../src/utils.vala"
			_tmp36_ = fileDir;
#line 349 "../src/utils.vala"
			if (!g_file_query_exists (_tmp36_, NULL)) {
#line 3921 "utils.c"
				GFile* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				GString* _tmp42_;
#line 351 "../src/utils.vala"
				_tmp37_ = fileDir;
#line 351 "../src/utils.vala"
				g_file_make_directory (_tmp37_, NULL, &_inner_error0_);
#line 351 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3934 "utils.c"
					goto __catch0_g_error;
				}
#line 353 "../src/utils.vala"
				_tmp38_ = g_strconcat (path, "/", NULL);
#line 353 "../src/utils.vala"
				_tmp39_ = _tmp38_;
#line 353 "../src/utils.vala"
				_tmp40_ = g_strconcat (_tmp39_, filename, NULL);
#line 353 "../src/utils.vala"
				_tmp41_ = _tmp40_;
#line 353 "../src/utils.vala"
				g_file_set_contents (_tmp41_, contents, (gssize) -1, &_inner_error0_);
#line 353 "../src/utils.vala"
				_g_free0 (_tmp41_);
#line 353 "../src/utils.vala"
				_g_free0 (_tmp39_);
#line 353 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3953 "utils.c"
					goto __catch0_g_error;
				}
#line 354 "../src/utils.vala"
				_tmp42_ = _result_;
#line 354 "../src/utils.vala"
				g_string_assign (_tmp42_, "true");
#line 3960 "utils.c"
			} else {
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				guint8* _tmp47_;
				gint _tmp47__length1;
				gint _tmp48_ = 0;
				guint8* _tmp49_;
				gint _tmp49__length1;
				GString* _tmp50_;
#line 357 "../src/utils.vala"
				_tmp43_ = g_strconcat (path, "/", NULL);
#line 357 "../src/utils.vala"
				_tmp44_ = _tmp43_;
#line 357 "../src/utils.vala"
				_tmp45_ = g_strconcat (_tmp44_, filename, NULL);
#line 357 "../src/utils.vala"
				_tmp46_ = _tmp45_;
#line 357 "../src/utils.vala"
				_tmp47_ = string_get_data (contents, &_tmp48_);
#line 357 "../src/utils.vala"
				_tmp47__length1 = _tmp48_;
#line 357 "../src/utils.vala"
				_tmp49_ = _tmp47_;
#line 357 "../src/utils.vala"
				_tmp49__length1 = _tmp47__length1;
#line 357 "../src/utils.vala"
				g_file_set_contents (_tmp46_, (const char*) _tmp49_, (gsize) _tmp49__length1, &_inner_error0_);
#line 357 "../src/utils.vala"
				_g_free0 (_tmp46_);
#line 357 "../src/utils.vala"
				_g_free0 (_tmp44_);
#line 357 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3996 "utils.c"
					goto __catch0_g_error;
				}
#line 358 "../src/utils.vala"
				_tmp50_ = _result_;
#line 358 "../src/utils.vala"
				g_string_assign (_tmp50_, "true");
#line 4003 "utils.c"
			}
		}
#line 361 "../src/utils.vala"
		if (g_strcmp0 ("WRITE_PROPS", operation) == 0) {
#line 4008 "utils.c"
			GFile* _tmp51_;
			gboolean wasRead = FALSE;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_ = NULL;
			gboolean _tmp62_;
			gboolean _tmp63_;
#line 363 "../src/utils.vala"
			_tmp51_ = fileDir;
#line 363 "../src/utils.vala"
			if (!g_file_query_exists (_tmp51_, NULL)) {
#line 4022 "utils.c"
				GFile* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
#line 365 "../src/utils.vala"
				_tmp52_ = fileDir;
#line 365 "../src/utils.vala"
				g_file_make_directory (_tmp52_, NULL, &_inner_error0_);
#line 365 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4034 "utils.c"
					goto __catch0_g_error;
				}
#line 367 "../src/utils.vala"
				_tmp53_ = g_strconcat (path, "/", NULL);
#line 367 "../src/utils.vala"
				_tmp54_ = _tmp53_;
#line 367 "../src/utils.vala"
				_tmp55_ = g_strconcat (_tmp54_, filename, NULL);
#line 367 "../src/utils.vala"
				_tmp56_ = _tmp55_;
#line 367 "../src/utils.vala"
				g_file_set_contents (_tmp56_, contents, (gssize) -1, &_inner_error0_);
#line 367 "../src/utils.vala"
				_g_free0 (_tmp56_);
#line 367 "../src/utils.vala"
				_g_free0 (_tmp54_);
#line 367 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4053 "utils.c"
					goto __catch0_g_error;
				}
			}
#line 369 "../src/utils.vala"
			_tmp57_ = g_strconcat (path, "/", NULL);
#line 369 "../src/utils.vala"
			_tmp58_ = _tmp57_;
#line 369 "../src/utils.vala"
			_tmp59_ = g_strconcat (_tmp58_, filename, NULL);
#line 369 "../src/utils.vala"
			_tmp60_ = _tmp59_;
#line 369 "../src/utils.vala"
			_tmp62_ = g_file_get_contents (_tmp60_, &_tmp61_, NULL, &_inner_error0_);
#line 369 "../src/utils.vala"
			_g_free0 (data);
#line 369 "../src/utils.vala"
			data = _tmp61_;
#line 369 "../src/utils.vala"
			_tmp63_ = _tmp62_;
#line 369 "../src/utils.vala"
			_g_free0 (_tmp60_);
#line 369 "../src/utils.vala"
			_g_free0 (_tmp58_);
#line 369 "../src/utils.vala"
			wasRead = _tmp63_;
#line 369 "../src/utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4081 "utils.c"
				goto __catch0_g_error;
			}
#line 370 "../src/utils.vala"
			if (wasRead) {
#line 4086 "utils.c"
				gchar** name_value = NULL;
				gchar** _tmp64_;
				gchar** _tmp65_;
				gint name_value_length1;
				gint _name_value_size_;
				GString* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				gchar** _tmp69_;
				gint _tmp69__length1;
				const gchar* _tmp70_;
#line 371 "../src/utils.vala"
				_tmp65_ = _tmp64_ = g_strsplit (contents, BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_VALUE, -1);
#line 371 "../src/utils.vala"
				name_value = _tmp65_;
#line 371 "../src/utils.vala"
				name_value_length1 = _vala_array_length (_tmp64_);
#line 371 "../src/utils.vala"
				_name_value_size_ = name_value_length1;
#line 373 "../src/utils.vala"
				_tmp66_ = _result_;
#line 373 "../src/utils.vala"
				_tmp67_ = data;
#line 373 "../src/utils.vala"
				g_string_assign (_tmp66_, _tmp67_);
#line 375 "../src/utils.vala"
				_tmp68_ = data;
#line 375 "../src/utils.vala"
				_tmp69_ = name_value;
#line 375 "../src/utils.vala"
				_tmp69__length1 = name_value_length1;
#line 375 "../src/utils.vala"
				_tmp70_ = _tmp69_[0];
#line 375 "../src/utils.vala"
				if (string_contains (_tmp68_, _tmp70_)) {
#line 4122 "utils.c"
					gchar* dataBeforeProp = NULL;
					GString* _tmp71_;
					const gchar* _tmp72_;
					gchar** _tmp73_;
					gchar** _tmp74_;
					gchar** _tmp75_;
					gint _tmp75__length1;
					const gchar* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar** _tmp79_;
					gchar** _tmp80_;
					gchar** _tmp81_;
					gint _tmp81__length1;
					const gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* dataAfterProp = NULL;
					GString* _tmp85_;
					const gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar** _tmp89_;
					gchar** _tmp90_;
					gchar** _tmp91_;
					gint _tmp91__length1;
					const gchar* _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					GString* _tmp95_;
					const gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					const gchar* _tmp99_;
					gchar* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					GString* _tmp106_;
					const gchar* _tmp107_;
#line 377 "../src/utils.vala"
					_tmp71_ = _result_;
#line 377 "../src/utils.vala"
					_tmp72_ = _tmp71_->str;
#line 377 "../src/utils.vala"
					_tmp74_ = _tmp73_ = g_strsplit (contents, BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_VALUE, 2);
#line 377 "../src/utils.vala"
					_tmp75_ = _tmp74_;
#line 377 "../src/utils.vala"
					_tmp75__length1 = _vala_array_length (_tmp73_);
#line 377 "../src/utils.vala"
					_tmp76_ = _tmp75_[0];
#line 377 "../src/utils.vala"
					_tmp77_ = g_strconcat (BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_START, _tmp76_, NULL);
#line 377 "../src/utils.vala"
					_tmp78_ = _tmp77_;
#line 377 "../src/utils.vala"
					_tmp80_ = _tmp79_ = g_strsplit (_tmp72_, _tmp78_, 2);
#line 377 "../src/utils.vala"
					_tmp81_ = _tmp80_;
#line 377 "../src/utils.vala"
					_tmp81__length1 = _vala_array_length (_tmp79_);
#line 377 "../src/utils.vala"
					_tmp82_ = _tmp81_[0];
#line 377 "../src/utils.vala"
					_tmp83_ = g_strdup (_tmp82_);
#line 377 "../src/utils.vala"
					_tmp84_ = _tmp83_;
#line 377 "../src/utils.vala"
					_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_free), NULL);
#line 377 "../src/utils.vala"
					_g_free0 (_tmp78_);
#line 377 "../src/utils.vala"
					_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
#line 377 "../src/utils.vala"
					dataBeforeProp = _tmp84_;
#line 380 "../src/utils.vala"
					_tmp85_ = _result_;
#line 380 "../src/utils.vala"
					_tmp86_ = _tmp85_->str;
#line 380 "../src/utils.vala"
					_tmp87_ = g_strconcat (contents, BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_END, NULL);
#line 380 "../src/utils.vala"
					_tmp88_ = _tmp87_;
#line 380 "../src/utils.vala"
					_tmp90_ = _tmp89_ = g_strsplit (_tmp86_, _tmp88_, 0);
#line 380 "../src/utils.vala"
					_tmp91_ = _tmp90_;
#line 380 "../src/utils.vala"
					_tmp91__length1 = _vala_array_length (_tmp89_);
#line 380 "../src/utils.vala"
					_tmp92_ = _tmp91_[1];
#line 380 "../src/utils.vala"
					_tmp93_ = g_strdup (_tmp92_);
#line 380 "../src/utils.vala"
					_tmp94_ = _tmp93_;
#line 380 "../src/utils.vala"
					_tmp91_ = (_vala_array_free (_tmp91_, _tmp91__length1, (GDestroyNotify) g_free), NULL);
#line 380 "../src/utils.vala"
					_g_free0 (_tmp88_);
#line 380 "../src/utils.vala"
					dataAfterProp = _tmp94_;
#line 382 "../src/utils.vala"
					_tmp95_ = _result_;
#line 382 "../src/utils.vala"
					_tmp96_ = dataBeforeProp;
#line 382 "../src/utils.vala"
					_tmp97_ = g_strconcat (_tmp96_, contents, NULL);
#line 382 "../src/utils.vala"
					_tmp98_ = _tmp97_;
#line 382 "../src/utils.vala"
					_tmp99_ = dataAfterProp;
#line 382 "../src/utils.vala"
					_tmp100_ = g_strconcat (_tmp98_, _tmp99_, NULL);
#line 382 "../src/utils.vala"
					_tmp101_ = _tmp100_;
#line 382 "../src/utils.vala"
					g_string_append (_tmp95_, _tmp101_);
#line 382 "../src/utils.vala"
					_g_free0 (_tmp101_);
#line 382 "../src/utils.vala"
					_g_free0 (_tmp98_);
#line 384 "../src/utils.vala"
					_tmp102_ = g_strconcat (path, "/", NULL);
#line 384 "../src/utils.vala"
					_tmp103_ = _tmp102_;
#line 384 "../src/utils.vala"
					_tmp104_ = g_strconcat (_tmp103_, filename, NULL);
#line 384 "../src/utils.vala"
					_tmp105_ = _tmp104_;
#line 384 "../src/utils.vala"
					_tmp106_ = _result_;
#line 384 "../src/utils.vala"
					_tmp107_ = _tmp106_->str;
#line 384 "../src/utils.vala"
					g_file_set_contents (_tmp105_, _tmp107_, (gssize) -1, &_inner_error0_);
#line 384 "../src/utils.vala"
					_g_free0 (_tmp105_);
#line 384 "../src/utils.vala"
					_g_free0 (_tmp103_);
#line 384 "../src/utils.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 384 "../src/utils.vala"
						_g_free0 (dataAfterProp);
#line 384 "../src/utils.vala"
						_g_free0 (dataBeforeProp);
#line 384 "../src/utils.vala"
						name_value = (_vala_array_free (name_value, name_value_length1, (GDestroyNotify) g_free), NULL);
#line 4273 "utils.c"
						goto __catch0_g_error;
					}
#line 375 "../src/utils.vala"
					_g_free0 (dataAfterProp);
#line 375 "../src/utils.vala"
					_g_free0 (dataBeforeProp);
#line 4280 "utils.c"
				} else {
					GString* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					GString* _tmp117_;
					const gchar* _tmp118_;
#line 387 "../src/utils.vala"
					_tmp108_ = _result_;
#line 387 "../src/utils.vala"
					_tmp109_ = g_strconcat (BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_START, contents, NULL);
#line 387 "../src/utils.vala"
					_tmp110_ = _tmp109_;
#line 387 "../src/utils.vala"
					_tmp111_ = g_strconcat (_tmp110_, BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_END, NULL);
#line 387 "../src/utils.vala"
					_tmp112_ = _tmp111_;
#line 387 "../src/utils.vala"
					g_string_append (_tmp108_, _tmp112_);
#line 387 "../src/utils.vala"
					_g_free0 (_tmp112_);
#line 387 "../src/utils.vala"
					_g_free0 (_tmp110_);
#line 388 "../src/utils.vala"
					_tmp113_ = g_strconcat (path, "/", NULL);
#line 388 "../src/utils.vala"
					_tmp114_ = _tmp113_;
#line 388 "../src/utils.vala"
					_tmp115_ = g_strconcat (_tmp114_, filename, NULL);
#line 388 "../src/utils.vala"
					_tmp116_ = _tmp115_;
#line 388 "../src/utils.vala"
					_tmp117_ = _result_;
#line 388 "../src/utils.vala"
					_tmp118_ = _tmp117_->str;
#line 388 "../src/utils.vala"
					g_file_set_contents (_tmp116_, _tmp118_, (gssize) -1, &_inner_error0_);
#line 388 "../src/utils.vala"
					_g_free0 (_tmp116_);
#line 388 "../src/utils.vala"
					_g_free0 (_tmp114_);
#line 388 "../src/utils.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 388 "../src/utils.vala"
						name_value = (_vala_array_free (name_value, name_value_length1, (GDestroyNotify) g_free), NULL);
#line 4331 "utils.c"
						goto __catch0_g_error;
					}
				}
#line 370 "../src/utils.vala"
				name_value = (_vala_array_free (name_value, name_value_length1, (GDestroyNotify) g_free), NULL);
#line 4337 "utils.c"
			} else {
				GString* _tmp119_;
#line 391 "../src/utils.vala"
				_tmp119_ = _result_;
#line 391 "../src/utils.vala"
				g_string_assign (_tmp119_, "false");
#line 4344 "utils.c"
			}
		}
#line 393 "../src/utils.vala"
		if (g_strcmp0 ("READ", operation) == 0) {
#line 4349 "utils.c"
			GFile* _tmp120_;
#line 394 "../src/utils.vala"
			_tmp120_ = file;
#line 394 "../src/utils.vala"
			if (g_file_query_exists (_tmp120_, NULL)) {
#line 4355 "utils.c"
				gboolean wasRead = FALSE;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				gchar* _tmp124_;
				gchar* _tmp125_ = NULL;
				gboolean _tmp126_;
				gboolean _tmp127_;
#line 395 "../src/utils.vala"
				_tmp121_ = g_strconcat (path, "/", NULL);
#line 395 "../src/utils.vala"
				_tmp122_ = _tmp121_;
#line 395 "../src/utils.vala"
				_tmp123_ = g_strconcat (_tmp122_, filename, NULL);
#line 395 "../src/utils.vala"
				_tmp124_ = _tmp123_;
#line 395 "../src/utils.vala"
				_tmp126_ = g_file_get_contents (_tmp124_, &_tmp125_, NULL, &_inner_error0_);
#line 395 "../src/utils.vala"
				_g_free0 (data);
#line 395 "../src/utils.vala"
				data = _tmp125_;
#line 395 "../src/utils.vala"
				_tmp127_ = _tmp126_;
#line 395 "../src/utils.vala"
				_g_free0 (_tmp124_);
#line 395 "../src/utils.vala"
				_g_free0 (_tmp122_);
#line 395 "../src/utils.vala"
				wasRead = _tmp127_;
#line 395 "../src/utils.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4388 "utils.c"
					goto __catch0_g_error;
				}
#line 396 "../src/utils.vala"
				if (wasRead) {
#line 4393 "utils.c"
					GString* _tmp128_;
					const gchar* _tmp129_;
#line 397 "../src/utils.vala"
					_tmp128_ = _result_;
#line 397 "../src/utils.vala"
					_tmp129_ = data;
#line 397 "../src/utils.vala"
					g_string_assign (_tmp128_, _tmp129_);
#line 4402 "utils.c"
				} else {
					GString* _tmp130_;
#line 399 "../src/utils.vala"
					_tmp130_ = _result_;
#line 399 "../src/utils.vala"
					g_string_assign (_tmp130_, "false");
#line 4409 "utils.c"
				}
			} else {
				GString* _tmp131_;
#line 402 "../src/utils.vala"
				_tmp131_ = _result_;
#line 402 "../src/utils.vala"
				g_string_assign (_tmp131_, "false");
#line 4417 "utils.c"
			}
		}
#line 405 "../src/utils.vala"
		if (g_strcmp0 ("READ_FILE", operation) == 0) {
#line 4422 "utils.c"
			gboolean wasRead = FALSE;
			gchar* _tmp132_ = NULL;
			gboolean _tmp133_;
#line 406 "../src/utils.vala"
			_tmp133_ = g_file_get_contents (path, &_tmp132_, NULL, &_inner_error0_);
#line 406 "../src/utils.vala"
			_g_free0 (data);
#line 406 "../src/utils.vala"
			data = _tmp132_;
#line 406 "../src/utils.vala"
			wasRead = _tmp133_;
#line 406 "../src/utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4436 "utils.c"
				goto __catch0_g_error;
			}
#line 407 "../src/utils.vala"
			if (wasRead) {
#line 4441 "utils.c"
				GString* _tmp134_;
				const gchar* _tmp135_;
#line 408 "../src/utils.vala"
				_tmp134_ = _result_;
#line 408 "../src/utils.vala"
				_tmp135_ = data;
#line 408 "../src/utils.vala"
				g_string_assign (_tmp134_, _tmp135_);
#line 4450 "utils.c"
			} else {
				GString* _tmp136_;
#line 410 "../src/utils.vala"
				_tmp136_ = _result_;
#line 410 "../src/utils.vala"
				g_string_assign (_tmp136_, "false");
#line 4457 "utils.c"
			}
		}
#line 413 "../src/utils.vala"
		if (g_strcmp0 ("READ_PROPS", operation) == 0) {
#line 4462 "utils.c"
			gboolean _tmp137_ = FALSE;
			const gchar* _tmp138_;
			GString* _tmp156_;
			const gchar* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			gchar** _tmp162_;
			gchar** _tmp163_;
			gchar** _tmp164_;
			gint _tmp164__length1;
			const gchar* _tmp165_;
			GString* _tmp166_;
			GString* _tmp167_;
			const gchar* _tmp168_;
			gchar** _tmp169_;
			gchar** _tmp170_;
			gchar** _tmp171_;
			gint _tmp171__length1;
			const gchar* _tmp172_;
#line 414 "../src/utils.vala"
			_tmp138_ = bookworm_app_utils_bookwormStateData;
#line 414 "../src/utils.vala"
			if (_tmp138_ != NULL) {
#line 4488 "utils.c"
				const gchar* _tmp139_;
				gint _tmp140_;
				gint _tmp141_;
#line 414 "../src/utils.vala"
				_tmp139_ = bookworm_app_utils_bookwormStateData;
#line 414 "../src/utils.vala"
				_tmp140_ = strlen (_tmp139_);
#line 414 "../src/utils.vala"
				_tmp141_ = _tmp140_;
#line 414 "../src/utils.vala"
				_tmp137_ = _tmp141_ > 5;
#line 4500 "utils.c"
			} else {
#line 414 "../src/utils.vala"
				_tmp137_ = FALSE;
#line 4504 "utils.c"
			}
#line 414 "../src/utils.vala"
			if (_tmp137_) {
#line 4508 "utils.c"
				const gchar* _tmp142_;
				gchar* _tmp143_;
#line 415 "../src/utils.vala"
				_tmp142_ = bookworm_app_utils_bookwormStateData;
#line 415 "../src/utils.vala"
				_tmp143_ = g_strdup (_tmp142_);
#line 415 "../src/utils.vala"
				_g_free0 (data);
#line 415 "../src/utils.vala"
				data = _tmp143_;
#line 4519 "utils.c"
			} else {
				GFile* _tmp144_;
#line 417 "../src/utils.vala"
				_tmp144_ = file;
#line 417 "../src/utils.vala"
				if (g_file_query_exists (_tmp144_, NULL)) {
#line 4526 "utils.c"
					gboolean wasRead = FALSE;
					gchar* _tmp145_;
					gchar* _tmp146_;
					gchar* _tmp147_;
					gchar* _tmp148_;
					gchar* _tmp149_ = NULL;
					gboolean _tmp150_;
					gboolean _tmp151_;
#line 418 "../src/utils.vala"
					_tmp145_ = g_strconcat (path, "/", NULL);
#line 418 "../src/utils.vala"
					_tmp146_ = _tmp145_;
#line 418 "../src/utils.vala"
					_tmp147_ = g_strconcat (_tmp146_, filename, NULL);
#line 418 "../src/utils.vala"
					_tmp148_ = _tmp147_;
#line 418 "../src/utils.vala"
					_tmp150_ = g_file_get_contents (_tmp148_, &_tmp149_, NULL, &_inner_error0_);
#line 418 "../src/utils.vala"
					_g_free0 (data);
#line 418 "../src/utils.vala"
					data = _tmp149_;
#line 418 "../src/utils.vala"
					_tmp151_ = _tmp150_;
#line 418 "../src/utils.vala"
					_g_free0 (_tmp148_);
#line 418 "../src/utils.vala"
					_g_free0 (_tmp146_);
#line 418 "../src/utils.vala"
					wasRead = _tmp151_;
#line 418 "../src/utils.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4559 "utils.c"
						goto __catch0_g_error;
					}
#line 419 "../src/utils.vala"
					if (wasRead) {
#line 4564 "utils.c"
						const gchar* _tmp152_;
						gchar* _tmp153_;
#line 421 "../src/utils.vala"
						_tmp152_ = data;
#line 421 "../src/utils.vala"
						_tmp153_ = g_strdup (_tmp152_);
#line 421 "../src/utils.vala"
						_g_free0 (bookworm_app_utils_bookwormStateData);
#line 421 "../src/utils.vala"
						bookworm_app_utils_bookwormStateData = _tmp153_;
#line 4575 "utils.c"
					} else {
						GString* _tmp154_;
#line 423 "../src/utils.vala"
						_tmp154_ = _result_;
#line 423 "../src/utils.vala"
						g_string_assign (_tmp154_, "false");
#line 4582 "utils.c"
					}
				} else {
					GString* _tmp155_;
#line 426 "../src/utils.vala"
					_tmp155_ = _result_;
#line 426 "../src/utils.vala"
					g_string_assign (_tmp155_, "false");
#line 4590 "utils.c"
				}
			}
#line 430 "../src/utils.vala"
			_tmp156_ = _result_;
#line 430 "../src/utils.vala"
			_tmp157_ = data;
#line 430 "../src/utils.vala"
			_tmp158_ = g_strconcat (BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_START, contents, NULL);
#line 430 "../src/utils.vala"
			_tmp159_ = _tmp158_;
#line 430 "../src/utils.vala"
			_tmp160_ = g_strconcat (_tmp159_, BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_VALUE, NULL);
#line 430 "../src/utils.vala"
			_tmp161_ = _tmp160_;
#line 430 "../src/utils.vala"
			_tmp163_ = _tmp162_ = g_strsplit (_tmp157_, _tmp161_, 2);
#line 430 "../src/utils.vala"
			_tmp164_ = _tmp163_;
#line 430 "../src/utils.vala"
			_tmp164__length1 = _vala_array_length (_tmp162_);
#line 430 "../src/utils.vala"
			_tmp165_ = _tmp164_[1];
#line 430 "../src/utils.vala"
			g_string_assign (_tmp156_, _tmp165_);
#line 430 "../src/utils.vala"
			_tmp164_ = (_vala_array_free (_tmp164_, _tmp164__length1, (GDestroyNotify) g_free), NULL);
#line 430 "../src/utils.vala"
			_g_free0 (_tmp161_);
#line 430 "../src/utils.vala"
			_g_free0 (_tmp159_);
#line 433 "../src/utils.vala"
			_tmp166_ = _result_;
#line 433 "../src/utils.vala"
			_tmp167_ = _result_;
#line 433 "../src/utils.vala"
			_tmp168_ = _tmp167_->str;
#line 433 "../src/utils.vala"
			_tmp170_ = _tmp169_ = g_strsplit (_tmp168_, BOOKWORM_APP_CONSTANTS_IDENTIFIER_FOR_PROPERTY_END, 2);
#line 433 "../src/utils.vala"
			_tmp171_ = _tmp170_;
#line 433 "../src/utils.vala"
			_tmp171__length1 = _vala_array_length (_tmp169_);
#line 433 "../src/utils.vala"
			_tmp172_ = _tmp171_[0];
#line 433 "../src/utils.vala"
			g_string_assign (_tmp166_, _tmp172_);
#line 433 "../src/utils.vala"
			_tmp171_ = (_vala_array_free (_tmp171_, _tmp171__length1, (GDestroyNotify) g_free), NULL);
#line 4639 "utils.c"
		}
#line 435 "../src/utils.vala"
		if (g_strcmp0 ("DELETE", operation) == 0) {
#line 4643 "utils.c"
			gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
#line 436 "../src/utils.vala"
			_tmp173_ = g_strconcat (path, "/", NULL);
#line 436 "../src/utils.vala"
			_tmp174_ = _tmp173_;
#line 436 "../src/utils.vala"
			_tmp175_ = g_strconcat (_tmp174_, filename, NULL);
#line 436 "../src/utils.vala"
			_tmp176_ = _tmp175_;
#line 436 "../src/utils.vala"
			g_remove (_tmp176_);
#line 436 "../src/utils.vala"
			_g_free0 (_tmp176_);
#line 436 "../src/utils.vala"
			_g_free0 (_tmp174_);
#line 4662 "utils.c"
		}
#line 438 "../src/utils.vala"
		if (g_strcmp0 ("EXISTS", operation) == 0) {
#line 4666 "utils.c"
			GFile* _tmp177_;
#line 439 "../src/utils.vala"
			_tmp177_ = file;
#line 439 "../src/utils.vala"
			if (g_file_query_exists (_tmp177_, NULL)) {
#line 4672 "utils.c"
				GString* _tmp178_;
#line 440 "../src/utils.vala"
				_tmp178_ = _result_;
#line 440 "../src/utils.vala"
				g_string_assign (_tmp178_, "true");
#line 4678 "utils.c"
			}
		}
#line 443 "../src/utils.vala"
		if (g_strcmp0 ("DIR_EXISTS", operation) == 0) {
#line 4683 "utils.c"
			GFile* _tmp179_;
#line 444 "../src/utils.vala"
			_tmp179_ = fileDir;
#line 444 "../src/utils.vala"
			if (g_file_query_exists (_tmp179_, NULL)) {
#line 4689 "utils.c"
				GString* _tmp180_;
#line 445 "../src/utils.vala"
				_tmp180_ = _result_;
#line 445 "../src/utils.vala"
				g_string_assign (_tmp180_, "true");
#line 4695 "utils.c"
			}
		}
#line 448 "../src/utils.vala"
		if (g_strcmp0 ("IS_EXECUTABLE", operation) == 0) {
#line 4700 "utils.c"
			gchar* _tmp181_;
			gchar* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			gboolean _tmp185_;
#line 449 "../src/utils.vala"
			_tmp181_ = g_strconcat (path, "/", NULL);
#line 449 "../src/utils.vala"
			_tmp182_ = _tmp181_;
#line 449 "../src/utils.vala"
			_tmp183_ = g_strconcat (_tmp182_, filename, NULL);
#line 449 "../src/utils.vala"
			_tmp184_ = _tmp183_;
#line 449 "../src/utils.vala"
			_tmp185_ = g_file_test (_tmp184_, G_FILE_TEST_IS_EXECUTABLE);
#line 449 "../src/utils.vala"
			_g_free0 (_tmp184_);
#line 449 "../src/utils.vala"
			_g_free0 (_tmp182_);
#line 449 "../src/utils.vala"
			if (_tmp185_) {
#line 4722 "utils.c"
				GString* _tmp186_;
#line 450 "../src/utils.vala"
				_tmp186_ = _result_;
#line 450 "../src/utils.vala"
				g_string_assign (_tmp186_, "true");
#line 4728 "utils.c"
			}
		}
#line 453 "../src/utils.vala"
		if (g_strcmp0 ("MAKE_EXECUTABLE", operation) == 0) {
#line 4733 "utils.c"
			gchar* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			GString* _tmp195_;
#line 454 "../src/utils.vala"
			_tmp187_ = g_strconcat ("chmod +x ", path, NULL);
#line 454 "../src/utils.vala"
			_tmp188_ = _tmp187_;
#line 454 "../src/utils.vala"
			_tmp189_ = g_strconcat (_tmp188_, "/", NULL);
#line 454 "../src/utils.vala"
			_tmp190_ = _tmp189_;
#line 454 "../src/utils.vala"
			_tmp191_ = g_strconcat (_tmp190_, filename, NULL);
#line 454 "../src/utils.vala"
			_tmp192_ = _tmp191_;
#line 454 "../src/utils.vala"
			_tmp193_ = bookworm_app_utils_execute_sync_command (_tmp192_);
#line 454 "../src/utils.vala"
			_tmp194_ = _tmp193_;
#line 454 "../src/utils.vala"
			_g_free0 (_tmp194_);
#line 454 "../src/utils.vala"
			_g_free0 (_tmp192_);
#line 454 "../src/utils.vala"
			_g_free0 (_tmp190_);
#line 454 "../src/utils.vala"
			_g_free0 (_tmp188_);
#line 455 "../src/utils.vala"
			_tmp195_ = _result_;
#line 455 "../src/utils.vala"
			g_string_assign (_tmp195_, "true");
#line 4771 "utils.c"
		}
#line 457 "../src/utils.vala"
		if (g_strcmp0 ("SET_PERMISSIONS", operation) == 0) {
#line 4775 "utils.c"
			gchar* _tmp196_;
			gchar* _tmp197_;
			gchar* _tmp198_;
			gchar* _tmp199_;
			gchar* _tmp200_;
			gchar* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gchar* _tmp204_;
			gchar* _tmp205_;
			gchar* _tmp206_;
			gchar* _tmp207_;
			GString* _tmp208_;
#line 458 "../src/utils.vala"
			_tmp196_ = g_strconcat ("chmod ", contents, NULL);
#line 458 "../src/utils.vala"
			_tmp197_ = _tmp196_;
#line 458 "../src/utils.vala"
			_tmp198_ = g_strconcat (_tmp197_, " ", NULL);
#line 458 "../src/utils.vala"
			_tmp199_ = _tmp198_;
#line 458 "../src/utils.vala"
			_tmp200_ = g_strconcat (_tmp199_, path, NULL);
#line 458 "../src/utils.vala"
			_tmp201_ = _tmp200_;
#line 458 "../src/utils.vala"
			_tmp202_ = g_strconcat (_tmp201_, "/", NULL);
#line 458 "../src/utils.vala"
			_tmp203_ = _tmp202_;
#line 458 "../src/utils.vala"
			_tmp204_ = g_strconcat (_tmp203_, filename, NULL);
#line 458 "../src/utils.vala"
			_tmp205_ = _tmp204_;
#line 458 "../src/utils.vala"
			_tmp206_ = bookworm_app_utils_execute_sync_command (_tmp205_);
#line 458 "../src/utils.vala"
			_tmp207_ = _tmp206_;
#line 458 "../src/utils.vala"
			_g_free0 (_tmp207_);
#line 458 "../src/utils.vala"
			_g_free0 (_tmp205_);
#line 458 "../src/utils.vala"
			_g_free0 (_tmp203_);
#line 458 "../src/utils.vala"
			_g_free0 (_tmp201_);
#line 458 "../src/utils.vala"
			_g_free0 (_tmp199_);
#line 458 "../src/utils.vala"
			_g_free0 (_tmp197_);
#line 459 "../src/utils.vala"
			_tmp208_ = _result_;
#line 459 "../src/utils.vala"
			g_string_assign (_tmp208_, "true");
#line 4829 "utils.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp209_;
		gchar* _tmp210_;
		gchar* _tmp211_;
		gchar* _tmp212_;
		gchar* _tmp213_;
		gchar* _tmp214_;
		gchar* _tmp215_;
		gchar* _tmp216_;
		gchar* _tmp217_;
		gchar* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		GError* _tmp221_;
		const gchar* _tmp222_;
		gchar* _tmp223_;
		gchar* _tmp224_;
		GString* _tmp225_;
		GError* _tmp226_;
		const gchar* _tmp227_;
		gchar* _tmp228_;
		gchar* _tmp229_;
#line 324 "../src/utils.vala"
		e = _inner_error0_;
#line 324 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 462 "../src/utils.vala"
		_tmp209_ = g_strconcat ("Failure in File Operation [operation=", operation, NULL);
#line 462 "../src/utils.vala"
		_tmp210_ = _tmp209_;
#line 462 "../src/utils.vala"
		_tmp211_ = g_strconcat (_tmp210_, ",path=", NULL);
#line 462 "../src/utils.vala"
		_tmp212_ = _tmp211_;
#line 462 "../src/utils.vala"
		_tmp213_ = g_strconcat (_tmp212_, path, NULL);
#line 462 "../src/utils.vala"
		_tmp214_ = _tmp213_;
#line 462 "../src/utils.vala"
		_tmp215_ = g_strconcat (_tmp214_, ", filename=", NULL);
#line 462 "../src/utils.vala"
		_tmp216_ = _tmp215_;
#line 462 "../src/utils.vala"
		_tmp217_ = g_strconcat (_tmp216_, filename, NULL);
#line 462 "../src/utils.vala"
		_tmp218_ = _tmp217_;
#line 462 "../src/utils.vala"
		_tmp219_ = g_strconcat (_tmp218_, "]: ", NULL);
#line 462 "../src/utils.vala"
		_tmp220_ = _tmp219_;
#line 462 "../src/utils.vala"
		_tmp221_ = e;
#line 462 "../src/utils.vala"
		_tmp222_ = _tmp221_->message;
#line 462 "../src/utils.vala"
		_tmp223_ = g_strconcat (_tmp220_, _tmp222_, NULL);
#line 462 "../src/utils.vala"
		_tmp224_ = _tmp223_;
#line 462 "../src/utils.vala"
		g_warning ("utils.vala:462: %s", _tmp224_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp224_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp220_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp218_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp216_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp214_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp212_);
#line 462 "../src/utils.vala"
		_g_free0 (_tmp210_);
#line 463 "../src/utils.vala"
		_tmp225_ = _result_;
#line 463 "../src/utils.vala"
		_tmp226_ = e;
#line 463 "../src/utils.vala"
		_tmp227_ = _tmp226_->message;
#line 463 "../src/utils.vala"
		_tmp228_ = g_strconcat ("false:", _tmp227_, NULL);
#line 463 "../src/utils.vala"
		_tmp229_ = _tmp228_;
#line 463 "../src/utils.vala"
		g_string_assign (_tmp225_, _tmp229_);
#line 463 "../src/utils.vala"
		_g_free0 (_tmp229_);
#line 324 "../src/utils.vala"
		_g_error_free0 (e);
#line 4925 "utils.c"
	}
	__finally0:
#line 324 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 324 "../src/utils.vala"
		_g_object_unref0 (file);
#line 324 "../src/utils.vala"
		_g_object_unref0 (fileDir);
#line 324 "../src/utils.vala"
		_g_free0 (data);
#line 324 "../src/utils.vala"
		_g_string_free0 (_result_);
#line 324 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 324 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 324 "../src/utils.vala"
		return NULL;
#line 4944 "utils.c"
	}
#line 465 "../src/utils.vala"
	_tmp230_ = g_strconcat ("Completed file operation[", operation, NULL);
#line 465 "../src/utils.vala"
	_tmp231_ = _tmp230_;
#line 465 "../src/utils.vala"
	_tmp232_ = g_strconcat (_tmp231_, "]...", NULL);
#line 465 "../src/utils.vala"
	_tmp233_ = _tmp232_;
#line 465 "../src/utils.vala"
	g_debug ("utils.vala:465: %s", _tmp233_);
#line 465 "../src/utils.vala"
	_g_free0 (_tmp233_);
#line 465 "../src/utils.vala"
	_g_free0 (_tmp231_);
#line 466 "../src/utils.vala"
	_tmp234_ = _result_;
#line 466 "../src/utils.vala"
	_tmp235_ = _tmp234_->str;
#line 466 "../src/utils.vala"
	_tmp236_ = g_strdup (_tmp235_);
#line 466 "../src/utils.vala"
	result = _tmp236_;
#line 466 "../src/utils.vala"
	_g_object_unref0 (file);
#line 466 "../src/utils.vala"
	_g_object_unref0 (fileDir);
#line 466 "../src/utils.vala"
	_g_free0 (data);
#line 466 "../src/utils.vala"
	_g_string_free0 (_result_);
#line 466 "../src/utils.vala"
	return result;
#line 4978 "utils.c"
}

GeeArrayList*
bookworm_app_utils_createPagination (GeeArrayList* contentLocationList)
{
	GeeArrayList* pageContentList = NULL;
	GeeArrayList* _tmp0_;
	GString* aPageContent = NULL;
	GString* _tmp1_;
	gint current_number_of_lines_per_page = 0;
	gint current_position = 0;
	GeeArrayList* result;
#line 469 "../src/utils.vala"
	g_return_val_if_fail (contentLocationList != NULL, NULL);
#line 470 "../src/utils.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 470 "../src/utils.vala"
	pageContentList = _tmp0_;
#line 471 "../src/utils.vala"
	_tmp1_ = g_string_new ("");
#line 471 "../src/utils.vala"
	aPageContent = _tmp1_;
#line 472 "../src/utils.vala"
	current_number_of_lines_per_page = 0;
#line 473 "../src/utils.vala"
	current_position = 0;
#line 5005 "utils.c"
	{
		gint i = 0;
#line 474 "../src/utils.vala"
		i = 0;
#line 5010 "utils.c"
		{
			gboolean _tmp2_ = FALSE;
#line 474 "../src/utils.vala"
			_tmp2_ = TRUE;
#line 474 "../src/utils.vala"
			while (TRUE) {
#line 5017 "utils.c"
				gint _tmp4_;
				gint _tmp5_;
				gchar* contents = NULL;
				gpointer _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
#line 474 "../src/utils.vala"
				if (!_tmp2_) {
#line 5027 "utils.c"
					gint _tmp3_;
#line 474 "../src/utils.vala"
					_tmp3_ = i;
#line 474 "../src/utils.vala"
					i = _tmp3_ + 1;
#line 5033 "utils.c"
				}
#line 474 "../src/utils.vala"
				_tmp2_ = FALSE;
#line 474 "../src/utils.vala"
				_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) contentLocationList);
#line 474 "../src/utils.vala"
				_tmp5_ = _tmp4_;
#line 474 "../src/utils.vala"
				if (!(i < _tmp5_)) {
#line 474 "../src/utils.vala"
					break;
#line 5045 "utils.c"
				}
#line 476 "../src/utils.vala"
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) contentLocationList, i);
#line 476 "../src/utils.vala"
				_tmp7_ = (gchar*) _tmp6_;
#line 476 "../src/utils.vala"
				_tmp8_ = bookworm_app_utils_fileOperations ("READ_FILE", _tmp7_, "", "");
#line 476 "../src/utils.vala"
				_tmp9_ = _tmp8_;
#line 476 "../src/utils.vala"
				_g_free0 (_tmp7_);
#line 476 "../src/utils.vala"
				contents = _tmp9_;
#line 477 "../src/utils.vala"
				while (TRUE) {
#line 5061 "utils.c"
					const gchar* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
#line 477 "../src/utils.vala"
					_tmp10_ = contents;
#line 477 "../src/utils.vala"
					_tmp11_ = strlen (_tmp10_);
#line 477 "../src/utils.vala"
					_tmp12_ = _tmp11_;
#line 477 "../src/utils.vala"
					if (!(current_position < _tmp12_)) {
#line 477 "../src/utils.vala"
						break;
#line 5077 "utils.c"
					}
#line 478 "../src/utils.vala"
					while (TRUE) {
#line 5081 "utils.c"
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						GString* _tmp17_;
						GString* _tmp18_;
						const gchar* _tmp19_;
						gint _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
#line 478 "../src/utils.vala"
						if (!(current_number_of_lines_per_page < BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_LINES_PER_PAGE)) {
#line 478 "../src/utils.vala"
							break;
#line 5104 "utils.c"
						}
#line 479 "../src/utils.vala"
						_tmp13_ = contents;
#line 479 "../src/utils.vala"
						_tmp14_ = contents;
#line 479 "../src/utils.vala"
						_tmp15_ = string_slice (_tmp13_, (glong) current_position, (glong) string_index_of (_tmp14_, " ", current_position + BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_PER_LINE));
#line 479 "../src/utils.vala"
						_tmp16_ = _tmp15_;
#line 479 "../src/utils.vala"
						_tmp17_ = g_string_append (aPageContent, _tmp16_);
#line 479 "../src/utils.vala"
						_tmp18_ = g_string_append (_tmp17_, " ");
#line 479 "../src/utils.vala"
						g_string_append (_tmp18_, "<br>");
#line 479 "../src/utils.vala"
						_g_free0 (_tmp16_);
#line 481 "../src/utils.vala"
						_tmp19_ = contents;
#line 481 "../src/utils.vala"
						current_position = string_index_of (_tmp19_, " ", current_position + BOOKWORM_APP_CONSTANTS_MAX_NUMBER_OF_CHARS_PER_LINE) + 1;
#line 482 "../src/utils.vala"
						_tmp20_ = current_number_of_lines_per_page;
#line 482 "../src/utils.vala"
						current_number_of_lines_per_page = _tmp20_ + 1;
#line 483 "../src/utils.vala"
						_tmp21_ = g_strdup_printf ("%i", current_position);
#line 483 "../src/utils.vala"
						_tmp22_ = _tmp21_;
#line 483 "../src/utils.vala"
						_tmp23_ = g_strconcat ("current_position:", _tmp22_, NULL);
#line 483 "../src/utils.vala"
						_tmp24_ = _tmp23_;
#line 483 "../src/utils.vala"
						_tmp25_ = g_strconcat (_tmp24_, "::::current_number_of_lines_per_page:", NULL);
#line 483 "../src/utils.vala"
						_tmp26_ = _tmp25_;
#line 483 "../src/utils.vala"
						_tmp27_ = g_strdup_printf ("%i", current_number_of_lines_per_page);
#line 483 "../src/utils.vala"
						_tmp28_ = _tmp27_;
#line 483 "../src/utils.vala"
						_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
#line 483 "../src/utils.vala"
						_tmp30_ = _tmp29_;
#line 483 "../src/utils.vala"
						g_debug ("utils.vala:483: %s", _tmp30_);
#line 483 "../src/utils.vala"
						_g_free0 (_tmp30_);
#line 483 "../src/utils.vala"
						_g_free0 (_tmp28_);
#line 483 "../src/utils.vala"
						_g_free0 (_tmp26_);
#line 483 "../src/utils.vala"
						_g_free0 (_tmp24_);
#line 483 "../src/utils.vala"
						_g_free0 (_tmp22_);
#line 5162 "utils.c"
					}
#line 486 "../src/utils.vala"
					_tmp31_ = aPageContent->str;
#line 486 "../src/utils.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) pageContentList, _tmp31_);
#line 487 "../src/utils.vala"
					_tmp32_ = aPageContent->str;
#line 487 "../src/utils.vala"
					g_debug ("utils.vala:487: %s", _tmp32_);
#line 488 "../src/utils.vala"
					g_string_erase (aPageContent, (gssize) 0, (gssize) -1);
#line 5174 "utils.c"
				}
#line 491 "../src/utils.vala"
				_g_free0 (contents);
#line 491 "../src/utils.vala"
				break;
#line 5180 "utils.c"
			}
		}
	}
#line 493 "../src/utils.vala"
	result = pageContentList;
#line 493 "../src/utils.vala"
	_g_string_free0 (aPageContent);
#line 493 "../src/utils.vala"
	return result;
#line 5190 "utils.c"
}

gchar*
bookworm_app_utils_createTableOfContents (GeeArrayList* bookContentList)
{
	GString* tocHTML = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp24_;
	GString* _tmp25_;
	GString* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* result;
#line 496 "../src/utils.vala"
	g_return_val_if_fail (bookContentList != NULL, NULL);
#line 497 "../src/utils.vala"
	g_debug ("utils.vala:497: Started creating Table Of Contents....");
#line 498 "../src/utils.vala"
	_tmp0_ = g_string_new ("");
#line 498 "../src/utils.vala"
	tocHTML = _tmp0_;
#line 499 "../src/utils.vala"
	_tmp1_ = tocHTML;
#line 499 "../src/utils.vala"
	_tmp2_ = g_string_append (_tmp1_, "<html>");
#line 499 "../src/utils.vala"
	_tmp3_ = g_string_append (_tmp2_, "<head></head>");
#line 499 "../src/utils.vala"
	_tmp4_ = g_string_append (_tmp3_, "<body> <font align=\"right\"><b>Book Contents</b>");
#line 499 "../src/utils.vala"
	g_string_append (_tmp4_, "<table>");
#line 5227 "utils.c"
	{
		gint i = 0;
#line 503 "../src/utils.vala"
		i = 0;
#line 5232 "utils.c"
		{
			gboolean _tmp5_ = FALSE;
#line 503 "../src/utils.vala"
			_tmp5_ = TRUE;
#line 503 "../src/utils.vala"
			while (TRUE) {
#line 5239 "utils.c"
				gint _tmp7_;
				gint _tmp8_;
				GString* _tmp9_;
				GString* _tmp10_;
				gpointer _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GString* _tmp23_;
#line 503 "../src/utils.vala"
				if (!_tmp5_) {
#line 5259 "utils.c"
					gint _tmp6_;
#line 503 "../src/utils.vala"
					_tmp6_ = i;
#line 503 "../src/utils.vala"
					i = _tmp6_ + 1;
#line 5265 "utils.c"
				}
#line 503 "../src/utils.vala"
				_tmp5_ = FALSE;
#line 503 "../src/utils.vala"
				_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) bookContentList);
#line 503 "../src/utils.vala"
				_tmp8_ = _tmp7_;
#line 503 "../src/utils.vala"
				if (!(i < _tmp8_)) {
#line 503 "../src/utils.vala"
					break;
#line 5277 "utils.c"
				}
#line 504 "../src/utils.vala"
				_tmp9_ = tocHTML;
#line 504 "../src/utils.vala"
				_tmp10_ = g_string_append (_tmp9_, "<tr><td>");
#line 504 "../src/utils.vala"
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) bookContentList, i);
#line 504 "../src/utils.vala"
				_tmp12_ = (gchar*) _tmp11_;
#line 504 "../src/utils.vala"
				_tmp13_ = g_strconcat ("<a href=\"" BOOKWORM_APP_CONSTANTS_PREFIX_FOR_FILE_URL, _tmp12_, NULL);
#line 504 "../src/utils.vala"
				_tmp14_ = _tmp13_;
#line 504 "../src/utils.vala"
				_tmp15_ = g_strconcat (_tmp14_, "\">Content Part ", NULL);
#line 504 "../src/utils.vala"
				_tmp16_ = _tmp15_;
#line 504 "../src/utils.vala"
				_tmp17_ = g_strdup_printf ("%i", i + 1);
#line 504 "../src/utils.vala"
				_tmp18_ = _tmp17_;
#line 504 "../src/utils.vala"
				_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
#line 504 "../src/utils.vala"
				_tmp20_ = _tmp19_;
#line 504 "../src/utils.vala"
				_tmp21_ = g_strconcat (_tmp20_, "</a></td><td>", NULL);
#line 504 "../src/utils.vala"
				_tmp22_ = _tmp21_;
#line 504 "../src/utils.vala"
				_tmp23_ = g_string_append (_tmp10_, _tmp22_);
#line 504 "../src/utils.vala"
				g_string_append (_tmp23_, "</td></tr>");
#line 504 "../src/utils.vala"
				_g_free0 (_tmp22_);
#line 504 "../src/utils.vala"
				_g_free0 (_tmp20_);
#line 504 "../src/utils.vala"
				_g_free0 (_tmp18_);
#line 504 "../src/utils.vala"
				_g_free0 (_tmp16_);
#line 504 "../src/utils.vala"
				_g_free0 (_tmp14_);
#line 504 "../src/utils.vala"
				_g_free0 (_tmp12_);
#line 5323 "utils.c"
			}
		}
	}
#line 508 "../src/utils.vala"
	_tmp24_ = tocHTML;
#line 508 "../src/utils.vala"
	_tmp25_ = g_string_append (_tmp24_, "</table>");
#line 508 "../src/utils.vala"
	_tmp26_ = g_string_append (_tmp25_, "</body>");
#line 508 "../src/utils.vala"
	g_string_append (_tmp26_, "</html>");
#line 511 "../src/utils.vala"
	g_debug ("utils.vala:511: Completed creating Table Of Contents....");
#line 512 "../src/utils.vala"
	_tmp27_ = tocHTML;
#line 512 "../src/utils.vala"
	_tmp28_ = _tmp27_->str;
#line 512 "../src/utils.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 512 "../src/utils.vala"
	result = _tmp29_;
#line 512 "../src/utils.vala"
	_g_string_free0 (tocHTML);
#line 512 "../src/utils.vala"
	return result;
#line 5349 "utils.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 517 "../src/utils.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 517 "../src/utils.vala"
	return _data2_;
#line 5359 "utils.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 517 "../src/utils.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 517 "../src/utils.vala"
		_g_object_unref0 (_data2_->aFileChooserDialog);
#line 517 "../src/utils.vala"
		g_slice_free (Block2Data, _data2_);
#line 5373 "utils.c"
	}
}

static gboolean
__lambda9_ (Block2Data* _data2_,
            GdkEventKey* ev)
{
	gboolean result;
#line 537 "../src/utils.vala"
	g_return_val_if_fail (ev != NULL, FALSE);
#line 538 "../src/utils.vala"
	if (ev->keyval == ((guint) 65307)) {
#line 5386 "utils.c"
		GtkFileChooserDialog* _tmp0_;
#line 539 "../src/utils.vala"
		_tmp0_ = _data2_->aFileChooserDialog;
#line 539 "../src/utils.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 5392 "utils.c"
	}
#line 540 "../src/utils.vala"
	result = FALSE;
#line 540 "../src/utils.vala"
	return result;
#line 5398 "utils.c"
}

static gboolean
___lambda9__gtk_widget_key_press_event (GtkWidget* _sender,
                                        GdkEventKey* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda9_ (self, event);
#line 537 "../src/utils.vala"
	return result;
#line 5410 "utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 552 "../src/utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 5418 "utils.c"
}

GtkFileChooserDialog*
bookworm_app_utils_new_file_chooser_dialog (GtkFileChooserAction action,
                                            const gchar* title,
                                            GtkWindow* parent,
                                            gboolean select_multiple,
                                            const gchar* filterType)
{
	Block2Data* _data2_;
	GtkFileChooserDialog* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GtkFileChooserDialog* _tmp27_;
	const gchar* _tmp28_;
	GQuark _tmp30_ = 0U;
#line 544 "../src/utils.vala"
	static GQuark _tmp29_label0 = 0;
#line 544 "../src/utils.vala"
	static GQuark _tmp29_label1 = 0;
#line 5442 "utils.c"
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp47_;
	GtkFileChooserDialog* _tmp48_;
	GtkFileFilter* _tmp49_;
	GtkFileChooserDialog* _tmp50_;
	GtkFileChooserDialog* _tmp51_;
	GError* _inner_error0_ = NULL;
	GtkFileChooserDialog* result;
#line 517 "../src/utils.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 517 "../src/utils.vala"
	g_return_val_if_fail (filterType != NULL, NULL);
#line 517 "../src/utils.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 517 "../src/utils.vala"
	_data2_->_ref_count_ = 1;
#line 518 "../src/utils.vala"
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (title, parent, action, NULL);
#line 518 "../src/utils.vala"
	g_object_ref_sink (_tmp0_);
#line 518 "../src/utils.vala"
	_data2_->aFileChooserDialog = _tmp0_;
#line 519 "../src/utils.vala"
	_tmp1_ = _data2_->aFileChooserDialog;
#line 519 "../src/utils.vala"
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp1_, select_multiple);
#line 520 "../src/utils.vala"
	_tmp2_ = _data2_->aFileChooserDialog;
#line 520 "../src/utils.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp2_, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 521 "../src/utils.vala"
	if (action == GTK_FILE_CHOOSER_ACTION_OPEN) {
#line 5475 "utils.c"
		GtkFileChooserDialog* _tmp3_;
#line 522 "../src/utils.vala"
		_tmp3_ = _data2_->aFileChooserDialog;
#line 522 "../src/utils.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp3_, _ ("Open"), (gint) GTK_RESPONSE_ACCEPT);
#line 5481 "utils.c"
	} else {
		GtkFileChooserDialog* _tmp4_;
		GtkFileChooserDialog* _tmp5_;
#line 524 "../src/utils.vala"
		_tmp4_ = _data2_->aFileChooserDialog;
#line 524 "../src/utils.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("Save"), (gint) GTK_RESPONSE_ACCEPT);
#line 525 "../src/utils.vala"
		_tmp5_ = _data2_->aFileChooserDialog;
#line 525 "../src/utils.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp5_, "");
#line 5493 "utils.c"
	}
#line 527 "../src/utils.vala"
	_tmp6_ = _data2_->aFileChooserDialog;
#line 527 "../src/utils.vala"
	gtk_dialog_set_default_response ((GtkDialog*) _tmp6_, (gint) GTK_RESPONSE_ACCEPT);
#line 528 "../src/utils.vala"
	_tmp8_ = bookworm_app_utils_last_file_chooser_path;
#line 528 "../src/utils.vala"
	if (_tmp8_ != NULL) {
#line 5503 "utils.c"
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 528 "../src/utils.vala"
		_tmp9_ = bookworm_app_utils_last_file_chooser_path;
#line 528 "../src/utils.vala"
		_tmp10_ = strlen (_tmp9_);
#line 528 "../src/utils.vala"
		_tmp11_ = _tmp10_;
#line 528 "../src/utils.vala"
		_tmp7_ = _tmp11_ != 0;
#line 5515 "utils.c"
	} else {
#line 528 "../src/utils.vala"
		_tmp7_ = FALSE;
#line 5519 "utils.c"
	}
#line 528 "../src/utils.vala"
	if (_tmp7_) {
#line 5523 "utils.c"
		{
			GtkFileChooserDialog* _tmp12_;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
#line 530 "../src/utils.vala"
			_tmp12_ = _data2_->aFileChooserDialog;
#line 530 "../src/utils.vala"
			_tmp13_ = bookworm_app_utils_last_file_chooser_path;
#line 530 "../src/utils.vala"
			_tmp14_ = g_file_new_for_path (_tmp13_);
#line 530 "../src/utils.vala"
			_tmp15_ = _tmp14_;
#line 530 "../src/utils.vala"
			gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp12_, _tmp15_, &_inner_error0_);
#line 530 "../src/utils.vala"
			_g_object_unref0 (_tmp15_);
#line 530 "../src/utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 5543 "utils.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
#line 529 "../src/utils.vala"
			e = _inner_error0_;
#line 529 "../src/utils.vala"
			_inner_error0_ = NULL;
#line 532 "../src/utils.vala"
			_tmp16_ = bookworm_app_utils_last_file_chooser_path;
#line 532 "../src/utils.vala"
			_tmp17_ = g_strconcat ("Could not set folder [", _tmp16_, NULL);
#line 532 "../src/utils.vala"
			_tmp18_ = _tmp17_;
#line 532 "../src/utils.vala"
			_tmp19_ = g_strconcat (_tmp18_, "] for file chooser dialog : ", NULL);
#line 532 "../src/utils.vala"
			_tmp20_ = _tmp19_;
#line 532 "../src/utils.vala"
			_tmp21_ = e;
#line 532 "../src/utils.vala"
			_tmp22_ = _tmp21_->message;
#line 532 "../src/utils.vala"
			_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
#line 532 "../src/utils.vala"
			_tmp24_ = _tmp23_;
#line 532 "../src/utils.vala"
			g_warning ("utils.vala:532: %s", _tmp24_);
#line 532 "../src/utils.vala"
			_g_free0 (_tmp24_);
#line 532 "../src/utils.vala"
			_g_free0 (_tmp20_);
#line 532 "../src/utils.vala"
			_g_free0 (_tmp18_);
#line 529 "../src/utils.vala"
			_g_error_free0 (e);
#line 5592 "utils.c"
		}
		__finally0:
#line 529 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 529 "../src/utils.vala"
			block2_data_unref (_data2_);
#line 529 "../src/utils.vala"
			_data2_ = NULL;
#line 529 "../src/utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 529 "../src/utils.vala"
			g_clear_error (&_inner_error0_);
#line 529 "../src/utils.vala"
			return NULL;
#line 5607 "utils.c"
		}
	} else {
		GtkFileChooserDialog* _tmp25_;
		const gchar* _tmp26_;
#line 535 "../src/utils.vala"
		_tmp25_ = _data2_->aFileChooserDialog;
#line 535 "../src/utils.vala"
		_tmp26_ = g_get_home_dir ();
#line 535 "../src/utils.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp25_, _tmp26_);
#line 5618 "utils.c"
	}
#line 537 "../src/utils.vala"
	_tmp27_ = _data2_->aFileChooserDialog;
#line 537 "../src/utils.vala"
	g_signal_connect_data ((GtkWidget*) _tmp27_, "key-press-event", (GCallback) ___lambda9__gtk_widget_key_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 544 "../src/utils.vala"
	_tmp28_ = filterType;
#line 544 "../src/utils.vala"
	_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
#line 544 "../src/utils.vala"
	if (_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string ("EBOOKS")))) {
#line 544 "../src/utils.vala"
		switch (0) {
#line 5632 "utils.c"
			default:
			{
				GtkFileFilter* ebook_files_filter = NULL;
				GtkFileFilter* _tmp31_;
				GtkFileFilter* _tmp32_;
				GtkFileChooserDialog* _tmp36_;
				GtkFileFilter* _tmp37_;
				GtkFileFilter* _tmp38_;
#line 546 "../src/utils.vala"
				_tmp31_ = gtk_file_filter_new ();
#line 546 "../src/utils.vala"
				g_object_ref_sink (_tmp31_);
#line 546 "../src/utils.vala"
				ebook_files_filter = _tmp31_;
#line 548 "../src/utils.vala"
				_tmp32_ = ebook_files_filter;
#line 548 "../src/utils.vala"
				gtk_file_filter_set_name (_tmp32_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_BOOKS);
#line 5651 "utils.c"
				{
					const gchar** pattern_collection = NULL;
					gint pattern_collection_length1 = 0;
					gint _pattern_collection_size_ = 0;
					gint pattern_it = 0;
#line 549 "../src/utils.vala"
					pattern_collection = BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_EBOOKS;
#line 549 "../src/utils.vala"
					pattern_collection_length1 = G_N_ELEMENTS (BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_EBOOKS);
#line 549 "../src/utils.vala"
					for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 5663 "utils.c"
						gchar* _tmp33_;
						gchar* pattern = NULL;
#line 549 "../src/utils.vala"
						_tmp33_ = g_strdup (pattern_collection[pattern_it]);
#line 549 "../src/utils.vala"
						pattern = _tmp33_;
#line 5670 "utils.c"
						{
							GtkFileFilter* _tmp34_;
							const gchar* _tmp35_;
#line 550 "../src/utils.vala"
							_tmp34_ = ebook_files_filter;
#line 550 "../src/utils.vala"
							_tmp35_ = pattern;
#line 550 "../src/utils.vala"
							gtk_file_filter_add_pattern (_tmp34_, _tmp35_);
#line 549 "../src/utils.vala"
							_g_free0 (pattern);
#line 5682 "utils.c"
						}
					}
				}
#line 552 "../src/utils.vala"
				_tmp36_ = _data2_->aFileChooserDialog;
#line 552 "../src/utils.vala"
				_tmp37_ = ebook_files_filter;
#line 552 "../src/utils.vala"
				_tmp38_ = _g_object_ref0 (_tmp37_);
#line 552 "../src/utils.vala"
				gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp36_, _tmp38_);
#line 553 "../src/utils.vala"
				_g_object_unref0 (ebook_files_filter);
#line 553 "../src/utils.vala"
				break;
#line 5698 "utils.c"
			}
		}
	} else if (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string ("IMAGES")))) {
#line 544 "../src/utils.vala"
		switch (0) {
#line 5704 "utils.c"
			default:
			{
				GtkFileFilter* image_files_filter = NULL;
				GtkFileFilter* _tmp39_;
				GtkFileFilter* _tmp40_;
				GtkFileChooserDialog* _tmp44_;
				GtkFileFilter* _tmp45_;
				GtkFileFilter* _tmp46_;
#line 555 "../src/utils.vala"
				_tmp39_ = gtk_file_filter_new ();
#line 555 "../src/utils.vala"
				g_object_ref_sink (_tmp39_);
#line 555 "../src/utils.vala"
				image_files_filter = _tmp39_;
#line 557 "../src/utils.vala"
				_tmp40_ = image_files_filter;
#line 557 "../src/utils.vala"
				gtk_file_filter_set_name (_tmp40_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_IMAGES);
#line 5723 "utils.c"
				{
					const gchar** pattern_collection = NULL;
					gint pattern_collection_length1 = 0;
					gint _pattern_collection_size_ = 0;
					gint pattern_it = 0;
#line 558 "../src/utils.vala"
					pattern_collection = BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES;
#line 558 "../src/utils.vala"
					pattern_collection_length1 = G_N_ELEMENTS (BOOKWORM_APP_CONSTANTS_FILE_CHOOSER_FILTER_IMAGES);
#line 558 "../src/utils.vala"
					for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 5735 "utils.c"
						gchar* _tmp41_;
						gchar* pattern = NULL;
#line 558 "../src/utils.vala"
						_tmp41_ = g_strdup (pattern_collection[pattern_it]);
#line 558 "../src/utils.vala"
						pattern = _tmp41_;
#line 5742 "utils.c"
						{
							GtkFileFilter* _tmp42_;
							const gchar* _tmp43_;
#line 559 "../src/utils.vala"
							_tmp42_ = image_files_filter;
#line 559 "../src/utils.vala"
							_tmp43_ = pattern;
#line 559 "../src/utils.vala"
							gtk_file_filter_add_pattern (_tmp42_, _tmp43_);
#line 558 "../src/utils.vala"
							_g_free0 (pattern);
#line 5754 "utils.c"
						}
					}
				}
#line 561 "../src/utils.vala"
				_tmp44_ = _data2_->aFileChooserDialog;
#line 561 "../src/utils.vala"
				_tmp45_ = image_files_filter;
#line 561 "../src/utils.vala"
				_tmp46_ = _g_object_ref0 (_tmp45_);
#line 561 "../src/utils.vala"
				gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp44_, _tmp46_);
#line 562 "../src/utils.vala"
				_g_object_unref0 (image_files_filter);
#line 562 "../src/utils.vala"
				break;
#line 5770 "utils.c"
			}
		}
	} else {
#line 544 "../src/utils.vala"
		switch (0) {
#line 5776 "utils.c"
			default:
			{
#line 564 "../src/utils.vala"
				break;
#line 5781 "utils.c"
			}
		}
	}
#line 567 "../src/utils.vala"
	_tmp47_ = gtk_file_filter_new ();
#line 567 "../src/utils.vala"
	g_object_ref_sink (_tmp47_);
#line 567 "../src/utils.vala"
	all_files_filter = _tmp47_;
#line 568 "../src/utils.vala"
	gtk_file_filter_set_name (all_files_filter, BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_ALL_FILES);
#line 569 "../src/utils.vala"
	gtk_file_filter_add_pattern (all_files_filter, "*");
#line 570 "../src/utils.vala"
	_tmp48_ = _data2_->aFileChooserDialog;
#line 570 "../src/utils.vala"
	_tmp49_ = _g_object_ref0 (all_files_filter);
#line 570 "../src/utils.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp48_, _tmp49_);
#line 571 "../src/utils.vala"
	_tmp50_ = _data2_->aFileChooserDialog;
#line 571 "../src/utils.vala"
	_tmp51_ = _g_object_ref0 (_tmp50_);
#line 571 "../src/utils.vala"
	result = _tmp51_;
#line 571 "../src/utils.vala"
	_g_object_unref0 (all_files_filter);
#line 571 "../src/utils.vala"
	block2_data_unref (_data2_);
#line 571 "../src/utils.vala"
	_data2_ = NULL;
#line 571 "../src/utils.vala"
	return result;
#line 5815 "utils.c"
}

static void
_g_free0_ (gpointer var)
{
#line 579 "../src/utils.vala"
	var = (g_free (var), NULL);
#line 5823 "utils.c"
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
#line 579 "../src/utils.vala"
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
#line 5831 "utils.c"
}

GeeArrayList*
bookworm_app_utils_selectFileChooser (GtkFileChooserAction action,
                                      const gchar* title,
                                      GtkWindow* parent,
                                      gboolean select_multiple,
                                      const gchar* filterType)
{
	GeeArrayList* eBookLocationList = NULL;
	GeeArrayList* _tmp0_;
	GtkFileChooserDialog* aFileChooserDialog = NULL;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GeeArrayList* result;
#line 574 "../src/utils.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 574 "../src/utils.vala"
	g_return_val_if_fail (filterType != NULL, NULL);
#line 575 "../src/utils.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 575 "../src/utils.vala"
	eBookLocationList = _tmp0_;
#line 577 "../src/utils.vala"
	_tmp1_ = bookworm_app_utils_new_file_chooser_dialog (action, title, parent, select_multiple, filterType);
#line 577 "../src/utils.vala"
	aFileChooserDialog = _tmp1_;
#line 578 "../src/utils.vala"
	_tmp2_ = aFileChooserDialog;
#line 578 "../src/utils.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
#line 579 "../src/utils.vala"
	_tmp3_ = aFileChooserDialog;
#line 579 "../src/utils.vala"
	if (gtk_dialog_run ((GtkDialog*) _tmp3_) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 5868 "utils.c"
		GSList* uris = NULL;
		GtkFileChooserDialog* _tmp4_;
		GSList* _tmp5_;
		GSList* _tmp6_;
		GtkFileChooserDialog* _tmp13_;
#line 580 "../src/utils.vala"
		_tmp4_ = aFileChooserDialog;
#line 580 "../src/utils.vala"
		_tmp5_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp4_);
#line 580 "../src/utils.vala"
		uris = _tmp5_;
#line 581 "../src/utils.vala"
		_tmp6_ = uris;
#line 5882 "utils.c"
		{
			GSList* uri_collection = NULL;
			GSList* uri_it = NULL;
#line 581 "../src/utils.vala"
			uri_collection = _tmp6_;
#line 581 "../src/utils.vala"
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
#line 5890 "utils.c"
				const gchar* uri = NULL;
#line 581 "../src/utils.vala"
				uri = (const gchar*) uri_it->data;
#line 5894 "utils.c"
				{
					GeeArrayList* _tmp7_;
					const gchar* _tmp8_;
					GFile* _tmp9_;
					GFile* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
#line 582 "../src/utils.vala"
					_tmp7_ = eBookLocationList;
#line 582 "../src/utils.vala"
					_tmp8_ = uri;
#line 582 "../src/utils.vala"
					_tmp9_ = g_file_new_for_uri (_tmp8_);
#line 582 "../src/utils.vala"
					_tmp10_ = _tmp9_;
#line 582 "../src/utils.vala"
					_tmp11_ = g_file_get_path (_tmp10_);
#line 582 "../src/utils.vala"
					_tmp12_ = _tmp11_;
#line 582 "../src/utils.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp12_);
#line 582 "../src/utils.vala"
					_g_free0 (_tmp12_);
#line 582 "../src/utils.vala"
					_g_object_unref0 (_tmp10_);
#line 5920 "utils.c"
				}
			}
		}
#line 584 "../src/utils.vala"
		_tmp13_ = aFileChooserDialog;
#line 584 "../src/utils.vala"
		g_signal_emit_by_name ((GtkDialog*) _tmp13_, "close");
#line 579 "../src/utils.vala"
		(uris == NULL) ? NULL : (uris = (_g_slist_free__g_free0_ (uris), NULL));
#line 5930 "utils.c"
	} else {
		GtkFileChooserDialog* _tmp14_;
#line 586 "../src/utils.vala"
		_tmp14_ = aFileChooserDialog;
#line 586 "../src/utils.vala"
		g_signal_emit_by_name ((GtkDialog*) _tmp14_, "close");
#line 5937 "utils.c"
	}
#line 588 "../src/utils.vala"
	result = eBookLocationList;
#line 588 "../src/utils.vala"
	_g_object_unref0 (aFileChooserDialog);
#line 588 "../src/utils.vala"
	return result;
#line 5945 "utils.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 591 "../src/utils.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 591 "../src/utils.vala"
	return _data3_;
#line 5955 "utils.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 591 "../src/utils.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 591 "../src/utils.vala"
		_g_object_unref0 (_data3_->aFileChooserDialog);
#line 591 "../src/utils.vala"
		g_slice_free (Block3Data, _data3_);
#line 5969 "utils.c"
	}
}

static gboolean
__lambda25_ (Block3Data* _data3_,
             GdkEventKey* ev)
{
	gboolean result;
#line 620 "../src/utils.vala"
	g_return_val_if_fail (ev != NULL, FALSE);
#line 621 "../src/utils.vala"
	if (ev->keyval == ((guint) 65307)) {
#line 5982 "utils.c"
		GtkFileChooserDialog* _tmp0_;
#line 622 "../src/utils.vala"
		_tmp0_ = _data3_->aFileChooserDialog;
#line 622 "../src/utils.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 5988 "utils.c"
	}
#line 623 "../src/utils.vala"
	result = FALSE;
#line 623 "../src/utils.vala"
	return result;
#line 5994 "utils.c"
}

static gboolean
___lambda25__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda25_ (self, event);
#line 620 "../src/utils.vala"
	return result;
#line 6006 "utils.c"
}

GeeArrayList*
bookworm_app_utils_selectDirChooser (const gchar* title,
                                     GtkWindow* parent,
                                     gboolean select_multiple)
{
	Block3Data* _data3_;
	GeeArrayList* selectedDirList = NULL;
	GeeArrayList* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp25_;
	GtkFileFilter* _tmp26_;
	GtkFileFilter* _tmp27_;
	GtkFileChooserDialog* _tmp28_;
	GtkFileFilter* _tmp29_;
	GtkFileFilter* _tmp30_;
	GtkFileChooserDialog* _tmp31_;
	GtkFileChooserDialog* _tmp32_;
	GtkFileChooserDialog* _tmp44_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
#line 591 "../src/utils.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 591 "../src/utils.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 591 "../src/utils.vala"
	_data3_->_ref_count_ = 1;
#line 592 "../src/utils.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 592 "../src/utils.vala"
	selectedDirList = _tmp0_;
#line 593 "../src/utils.vala"
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (title, parent, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, NULL);
#line 593 "../src/utils.vala"
	g_object_ref_sink (_tmp1_);
#line 593 "../src/utils.vala"
	_data3_->aFileChooserDialog = _tmp1_;
#line 594 "../src/utils.vala"
	_tmp2_ = _data3_->aFileChooserDialog;
#line 594 "../src/utils.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp2_, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 595 "../src/utils.vala"
	_tmp3_ = _data3_->aFileChooserDialog;
#line 595 "../src/utils.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp3_, _ ("Open"), (gint) GTK_RESPONSE_ACCEPT);
#line 596 "../src/utils.vala"
	_tmp4_ = _data3_->aFileChooserDialog;
#line 596 "../src/utils.vala"
	gtk_dialog_set_default_response ((GtkDialog*) _tmp4_, (gint) GTK_RESPONSE_ACCEPT);
#line 597 "../src/utils.vala"
	_tmp6_ = bookworm_app_utils_last_file_chooser_path;
#line 597 "../src/utils.vala"
	if (_tmp6_ != NULL) {
#line 6067 "utils.c"
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 597 "../src/utils.vala"
		_tmp7_ = bookworm_app_utils_last_file_chooser_path;
#line 597 "../src/utils.vala"
		_tmp8_ = strlen (_tmp7_);
#line 597 "../src/utils.vala"
		_tmp9_ = _tmp8_;
#line 597 "../src/utils.vala"
		_tmp5_ = _tmp9_ != 0;
#line 6079 "utils.c"
	} else {
#line 597 "../src/utils.vala"
		_tmp5_ = FALSE;
#line 6083 "utils.c"
	}
#line 597 "../src/utils.vala"
	if (_tmp5_) {
#line 6087 "utils.c"
		{
			GtkFileChooserDialog* _tmp10_;
			const gchar* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
#line 599 "../src/utils.vala"
			_tmp10_ = _data3_->aFileChooserDialog;
#line 599 "../src/utils.vala"
			_tmp11_ = bookworm_app_utils_last_file_chooser_path;
#line 599 "../src/utils.vala"
			_tmp12_ = g_file_new_for_path (_tmp11_);
#line 599 "../src/utils.vala"
			_tmp13_ = _tmp12_;
#line 599 "../src/utils.vala"
			gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp10_, _tmp13_, &_inner_error0_);
#line 599 "../src/utils.vala"
			_g_object_unref0 (_tmp13_);
#line 599 "../src/utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 6107 "utils.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GError* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 598 "../src/utils.vala"
			e = _inner_error0_;
#line 598 "../src/utils.vala"
			_inner_error0_ = NULL;
#line 601 "../src/utils.vala"
			_tmp14_ = bookworm_app_utils_last_file_chooser_path;
#line 601 "../src/utils.vala"
			_tmp15_ = g_strconcat ("Error in setting the folder [", _tmp14_, NULL);
#line 601 "../src/utils.vala"
			_tmp16_ = _tmp15_;
#line 601 "../src/utils.vala"
			_tmp17_ = g_strconcat (_tmp16_, "] for the File Chooser Dialog:", NULL);
#line 601 "../src/utils.vala"
			_tmp18_ = _tmp17_;
#line 601 "../src/utils.vala"
			_tmp19_ = e;
#line 601 "../src/utils.vala"
			_tmp20_ = _tmp19_->message;
#line 601 "../src/utils.vala"
			_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
#line 601 "../src/utils.vala"
			_tmp22_ = _tmp21_;
#line 601 "../src/utils.vala"
			g_warning ("utils.vala:601: %s", _tmp22_);
#line 601 "../src/utils.vala"
			_g_free0 (_tmp22_);
#line 601 "../src/utils.vala"
			_g_free0 (_tmp18_);
#line 601 "../src/utils.vala"
			_g_free0 (_tmp16_);
#line 598 "../src/utils.vala"
			_g_error_free0 (e);
#line 6156 "utils.c"
		}
		__finally0:
#line 598 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 598 "../src/utils.vala"
			_g_object_unref0 (selectedDirList);
#line 598 "../src/utils.vala"
			block3_data_unref (_data3_);
#line 598 "../src/utils.vala"
			_data3_ = NULL;
#line 598 "../src/utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 598 "../src/utils.vala"
			g_clear_error (&_inner_error0_);
#line 598 "../src/utils.vala"
			return NULL;
#line 6173 "utils.c"
		}
	} else {
		GtkFileChooserDialog* _tmp23_;
		const gchar* _tmp24_;
#line 604 "../src/utils.vala"
		_tmp23_ = _data3_->aFileChooserDialog;
#line 604 "../src/utils.vala"
		_tmp24_ = g_get_home_dir ();
#line 604 "../src/utils.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp23_, _tmp24_);
#line 6184 "utils.c"
	}
#line 606 "../src/utils.vala"
	_tmp25_ = gtk_file_filter_new ();
#line 606 "../src/utils.vala"
	g_object_ref_sink (_tmp25_);
#line 606 "../src/utils.vala"
	all_files_filter = _tmp25_;
#line 607 "../src/utils.vala"
	_tmp26_ = all_files_filter;
#line 607 "../src/utils.vala"
	gtk_file_filter_set_name (_tmp26_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_FILE_CHOOSER_FILTER_ALL_FILES);
#line 608 "../src/utils.vala"
	_tmp27_ = all_files_filter;
#line 608 "../src/utils.vala"
	gtk_file_filter_add_pattern (_tmp27_, "*");
#line 609 "../src/utils.vala"
	_tmp28_ = _data3_->aFileChooserDialog;
#line 609 "../src/utils.vala"
	_tmp29_ = all_files_filter;
#line 609 "../src/utils.vala"
	_tmp30_ = _g_object_ref0 (_tmp29_);
#line 609 "../src/utils.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp28_, _tmp30_);
#line 610 "../src/utils.vala"
	_tmp31_ = _data3_->aFileChooserDialog;
#line 610 "../src/utils.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp31_);
#line 611 "../src/utils.vala"
	_tmp32_ = _data3_->aFileChooserDialog;
#line 611 "../src/utils.vala"
	if (gtk_dialog_run ((GtkDialog*) _tmp32_) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 6216 "utils.c"
		GSList* uris = NULL;
		GtkFileChooserDialog* _tmp33_;
		GSList* _tmp34_;
		GSList* _tmp35_;
		GtkFileChooserDialog* _tmp42_;
#line 612 "../src/utils.vala"
		_tmp33_ = _data3_->aFileChooserDialog;
#line 612 "../src/utils.vala"
		_tmp34_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp33_);
#line 612 "../src/utils.vala"
		uris = _tmp34_;
#line 613 "../src/utils.vala"
		_tmp35_ = uris;
#line 6230 "utils.c"
		{
			GSList* uri_collection = NULL;
			GSList* uri_it = NULL;
#line 613 "../src/utils.vala"
			uri_collection = _tmp35_;
#line 613 "../src/utils.vala"
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
#line 6238 "utils.c"
				const gchar* uri = NULL;
#line 613 "../src/utils.vala"
				uri = (const gchar*) uri_it->data;
#line 6242 "utils.c"
				{
					GeeArrayList* _tmp36_;
					const gchar* _tmp37_;
					GFile* _tmp38_;
					GFile* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
#line 614 "../src/utils.vala"
					_tmp36_ = selectedDirList;
#line 614 "../src/utils.vala"
					_tmp37_ = uri;
#line 614 "../src/utils.vala"
					_tmp38_ = g_file_new_for_uri (_tmp37_);
#line 614 "../src/utils.vala"
					_tmp39_ = _tmp38_;
#line 614 "../src/utils.vala"
					_tmp40_ = g_file_get_path (_tmp39_);
#line 614 "../src/utils.vala"
					_tmp41_ = _tmp40_;
#line 614 "../src/utils.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp41_);
#line 614 "../src/utils.vala"
					_g_free0 (_tmp41_);
#line 614 "../src/utils.vala"
					_g_object_unref0 (_tmp39_);
#line 6268 "utils.c"
				}
			}
		}
#line 616 "../src/utils.vala"
		_tmp42_ = _data3_->aFileChooserDialog;
#line 616 "../src/utils.vala"
		g_signal_emit_by_name ((GtkDialog*) _tmp42_, "close");
#line 611 "../src/utils.vala"
		(uris == NULL) ? NULL : (uris = (_g_slist_free__g_free0_ (uris), NULL));
#line 6278 "utils.c"
	} else {
		GtkFileChooserDialog* _tmp43_;
#line 618 "../src/utils.vala"
		_tmp43_ = _data3_->aFileChooserDialog;
#line 618 "../src/utils.vala"
		g_signal_emit_by_name ((GtkDialog*) _tmp43_, "close");
#line 6285 "utils.c"
	}
#line 620 "../src/utils.vala"
	_tmp44_ = _data3_->aFileChooserDialog;
#line 620 "../src/utils.vala"
	g_signal_connect_data ((GtkWidget*) _tmp44_, "key-press-event", (GCallback) ___lambda25__gtk_widget_key_press_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 626 "../src/utils.vala"
	result = selectedDirList;
#line 626 "../src/utils.vala"
	_g_object_unref0 (all_files_filter);
#line 626 "../src/utils.vala"
	block3_data_unref (_data3_);
#line 626 "../src/utils.vala"
	_data3_ = NULL;
#line 626 "../src/utils.vala"
	return result;
#line 6301 "utils.c"
}

gchar*
bookworm_app_utils_parseMarkUp (const gchar* inputString)
{
	gchar* outputString = NULL;
	gchar* _tmp0_;
	gunichar accel_char = 0U;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 629 "../src/utils.vala"
	g_return_val_if_fail (inputString != NULL, NULL);
#line 630 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 630 "../src/utils.vala"
	outputString = _tmp0_;
#line 6318 "utils.c"
	{
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_ = NULL;
		gunichar _tmp4_ = 0U;
#line 633 "../src/utils.vala"
		_tmp1_ = strlen (inputString);
#line 633 "../src/utils.vala"
		_tmp2_ = _tmp1_;
#line 633 "../src/utils.vala"
		pango_parse_markup (inputString, _tmp2_, (gunichar) 0, NULL, &_tmp3_, &_tmp4_, &_inner_error0_);
#line 633 "../src/utils.vala"
		_g_free0 (outputString);
#line 633 "../src/utils.vala"
		outputString = _tmp3_;
#line 633 "../src/utils.vala"
		accel_char = _tmp4_;
#line 633 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 6338 "utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 632 "../src/utils.vala"
		e = _inner_error0_;
#line 632 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 635 "../src/utils.vala"
		_tmp5_ = g_strconcat ("Could not parseMarkUp [", inputString, NULL);
#line 635 "../src/utils.vala"
		_tmp6_ = _tmp5_;
#line 635 "../src/utils.vala"
		_tmp7_ = g_strconcat (_tmp6_, "] : ", NULL);
#line 635 "../src/utils.vala"
		_tmp8_ = _tmp7_;
#line 635 "../src/utils.vala"
		_tmp9_ = e;
#line 635 "../src/utils.vala"
		_tmp10_ = _tmp9_->message;
#line 635 "../src/utils.vala"
		_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
#line 635 "../src/utils.vala"
		_tmp12_ = _tmp11_;
#line 635 "../src/utils.vala"
		g_warning ("utils.vala:635: %s", _tmp12_);
#line 635 "../src/utils.vala"
		_g_free0 (_tmp12_);
#line 635 "../src/utils.vala"
		_g_free0 (_tmp8_);
#line 635 "../src/utils.vala"
		_g_free0 (_tmp6_);
#line 636 "../src/utils.vala"
		_tmp13_ = g_strdup (inputString);
#line 636 "../src/utils.vala"
		_g_free0 (outputString);
#line 636 "../src/utils.vala"
		outputString = _tmp13_;
#line 632 "../src/utils.vala"
		_g_error_free0 (e);
#line 6391 "utils.c"
	}
	__finally0:
#line 632 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 632 "../src/utils.vala"
		_g_free0 (outputString);
#line 632 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 632 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 632 "../src/utils.vala"
		return NULL;
#line 6404 "utils.c"
	}
#line 638 "../src/utils.vala"
	result = outputString;
#line 638 "../src/utils.vala"
	return result;
#line 6410 "utils.c"
}

gchar*
bookworm_app_utils_decodeHTMLChars (const gchar* inputString)
{
	gchar* outputString = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 641 "../src/utils.vala"
	g_return_val_if_fail (inputString != NULL, NULL);
#line 642 "../src/utils.vala"
	_tmp0_ = soup_uri_decode (inputString);
#line 642 "../src/utils.vala"
	outputString = _tmp0_;
#line 643 "../src/utils.vala"
	result = outputString;
#line 643 "../src/utils.vala"
	return result;
#line 6429 "utils.c"
}

gchar*
bookworm_app_utils_encodeHTMLChars (const gchar* inputString)
{
	gchar* outputString = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 646 "../src/utils.vala"
	g_return_val_if_fail (inputString != NULL, NULL);
#line 647 "../src/utils.vala"
	_tmp0_ = string_replace (inputString, "#", "%23");
#line 647 "../src/utils.vala"
	outputString = _tmp0_;
#line 648 "../src/utils.vala"
	result = outputString;
#line 648 "../src/utils.vala"
	return result;
#line 6448 "utils.c"
}

gchar*
bookworm_app_utils_removeMarkUp (const gchar* inputString)
{
	gchar* outputString = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
#line 651 "../src/utils.vala"
	g_return_val_if_fail (inputString != NULL, NULL);
#line 652 "../src/utils.vala"
	_tmp0_ = soup_uri_decode (inputString);
#line 652 "../src/utils.vala"
	outputString = _tmp0_;
#line 654 "../src/utils.vala"
	_tmp1_ = outputString;
#line 654 "../src/utils.vala"
	_tmp2_ = string_replace (_tmp1_, "&#160;", " ");
#line 654 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 654 "../src/utils.vala"
	_tmp4_ = string_replace (_tmp3_, "#160;", " ");
#line 654 "../src/utils.vala"
	_tmp5_ = _tmp4_;
#line 654 "../src/utils.vala"
	_tmp6_ = string_replace (_tmp5_, "&#160", " ");
#line 654 "../src/utils.vala"
	_g_free0 (outputString);
#line 654 "../src/utils.vala"
	outputString = _tmp6_;
#line 654 "../src/utils.vala"
	_g_free0 (_tmp5_);
#line 654 "../src/utils.vala"
	_g_free0 (_tmp3_);
#line 655 "../src/utils.vala"
	result = outputString;
#line 655 "../src/utils.vala"
	return result;
#line 6493 "utils.c"
}

gchar*
bookworm_app_utils_removeTagsFromText (const gchar* input)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GString* filteredInput = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	gint posOfStartTag = 0;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gint posOfEndTag = 0;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GString* _tmp21_;
	const gchar* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GString* _tmp36_;
	const gchar* _tmp37_;
	GString* _tmp38_;
	const gchar* _tmp39_;
	gboolean _tmp40_ = FALSE;
	GString* _tmp50_;
	const gchar* _tmp51_;
	GString* _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp68_ = FALSE;
	GString* _tmp69_;
	const gchar* _tmp70_;
	GString* _tmp80_;
	GString* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	GString* _tmp85_;
	GString* _tmp86_;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	GString* _tmp90_;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	GString* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* result;
#line 658 "../src/utils.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 659 "../src/utils.vala"
	_tmp0_ = g_strconcat ("Starting execution of removeTagsFromText on text:", input, NULL);
#line 659 "../src/utils.vala"
	_tmp1_ = _tmp0_;
#line 659 "../src/utils.vala"
	g_debug ("utils.vala:659: %s", _tmp1_);
#line 659 "../src/utils.vala"
	_g_free0 (_tmp1_);
#line 660 "../src/utils.vala"
	_tmp2_ = string_strip (input);
#line 660 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 660 "../src/utils.vala"
	_tmp4_ = g_string_new (_tmp3_);
#line 660 "../src/utils.vala"
	_tmp5_ = _tmp4_;
#line 660 "../src/utils.vala"
	_g_free0 (_tmp3_);
#line 660 "../src/utils.vala"
	filteredInput = _tmp5_;
#line 661 "../src/utils.vala"
	_tmp6_ = filteredInput;
#line 661 "../src/utils.vala"
	_tmp7_ = _tmp6_->str;
#line 661 "../src/utils.vala"
	posOfStartTag = string_index_of (_tmp7_, "<", 0);
#line 662 "../src/utils.vala"
	_tmp8_ = filteredInput;
#line 662 "../src/utils.vala"
	_tmp9_ = _tmp8_->str;
#line 662 "../src/utils.vala"
	posOfEndTag = string_index_of (_tmp9_, ">", 0);
#line 664 "../src/utils.vala"
	if (posOfStartTag != -1) {
#line 664 "../src/utils.vala"
		_tmp11_ = posOfEndTag != -1;
#line 6589 "utils.c"
	} else {
#line 664 "../src/utils.vala"
		_tmp11_ = FALSE;
#line 6593 "utils.c"
	}
#line 664 "../src/utils.vala"
	if (_tmp11_) {
#line 664 "../src/utils.vala"
		_tmp10_ = posOfEndTag > posOfStartTag;
#line 6599 "utils.c"
	} else {
#line 664 "../src/utils.vala"
		_tmp10_ = FALSE;
#line 6603 "utils.c"
	}
#line 664 "../src/utils.vala"
	if (_tmp10_) {
#line 6607 "utils.c"
		GString* _tmp12_;
		GString* _tmp13_;
		const gchar* _tmp14_;
		GString* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
#line 665 "../src/utils.vala"
		_tmp12_ = filteredInput;
#line 665 "../src/utils.vala"
		_tmp13_ = filteredInput;
#line 665 "../src/utils.vala"
		_tmp14_ = _tmp13_->str;
#line 665 "../src/utils.vala"
		_tmp15_ = filteredInput;
#line 665 "../src/utils.vala"
		_tmp16_ = _tmp15_->str;
#line 665 "../src/utils.vala"
		_tmp17_ = string_slice (_tmp16_, (glong) posOfStartTag, (glong) (posOfEndTag + 1));
#line 665 "../src/utils.vala"
		_tmp18_ = _tmp17_;
#line 665 "../src/utils.vala"
		_tmp19_ = string_replace (_tmp14_, _tmp18_, "");
#line 665 "../src/utils.vala"
		_tmp20_ = _tmp19_;
#line 665 "../src/utils.vala"
		g_string_assign (_tmp12_, _tmp20_);
#line 665 "../src/utils.vala"
		_g_free0 (_tmp20_);
#line 665 "../src/utils.vala"
		_g_free0 (_tmp18_);
#line 6641 "utils.c"
	}
#line 667 "../src/utils.vala"
	_tmp21_ = filteredInput;
#line 667 "../src/utils.vala"
	_tmp22_ = _tmp21_->str;
#line 667 "../src/utils.vala"
	posOfStartTag = string_index_of (_tmp22_, "<", 0);
#line 668 "../src/utils.vala"
	_tmp23_ = filteredInput;
#line 668 "../src/utils.vala"
	_tmp24_ = _tmp23_->str;
#line 668 "../src/utils.vala"
	posOfEndTag = string_index_of (_tmp24_, ">", 0);
#line 670 "../src/utils.vala"
	if (posOfStartTag != -1) {
#line 670 "../src/utils.vala"
		_tmp26_ = posOfEndTag != -1;
#line 6659 "utils.c"
	} else {
#line 670 "../src/utils.vala"
		_tmp26_ = FALSE;
#line 6663 "utils.c"
	}
#line 670 "../src/utils.vala"
	if (_tmp26_) {
#line 670 "../src/utils.vala"
		_tmp25_ = posOfStartTag > posOfEndTag;
#line 6669 "utils.c"
	} else {
#line 670 "../src/utils.vala"
		_tmp25_ = FALSE;
#line 6673 "utils.c"
	}
#line 670 "../src/utils.vala"
	if (_tmp25_) {
#line 6677 "utils.c"
		GString* _tmp27_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		GString* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
#line 671 "../src/utils.vala"
		_tmp27_ = filteredInput;
#line 671 "../src/utils.vala"
		_tmp28_ = filteredInput;
#line 671 "../src/utils.vala"
		_tmp29_ = _tmp28_->str;
#line 671 "../src/utils.vala"
		_tmp30_ = filteredInput;
#line 671 "../src/utils.vala"
		_tmp31_ = _tmp30_->str;
#line 671 "../src/utils.vala"
		_tmp32_ = string_slice (_tmp31_, (glong) 0, (glong) (posOfEndTag + 1));
#line 671 "../src/utils.vala"
		_tmp33_ = _tmp32_;
#line 671 "../src/utils.vala"
		_tmp34_ = string_replace (_tmp29_, _tmp33_, "");
#line 671 "../src/utils.vala"
		_tmp35_ = _tmp34_;
#line 671 "../src/utils.vala"
		g_string_assign (_tmp27_, _tmp35_);
#line 671 "../src/utils.vala"
		_g_free0 (_tmp35_);
#line 671 "../src/utils.vala"
		_g_free0 (_tmp33_);
#line 6711 "utils.c"
	}
#line 673 "../src/utils.vala"
	_tmp36_ = filteredInput;
#line 673 "../src/utils.vala"
	_tmp37_ = _tmp36_->str;
#line 673 "../src/utils.vala"
	posOfStartTag = string_index_of (_tmp37_, "<", 0);
#line 674 "../src/utils.vala"
	_tmp38_ = filteredInput;
#line 674 "../src/utils.vala"
	_tmp39_ = _tmp38_->str;
#line 674 "../src/utils.vala"
	posOfEndTag = string_index_of (_tmp39_, ">", 0);
#line 676 "../src/utils.vala"
	if (posOfEndTag != -1) {
#line 676 "../src/utils.vala"
		_tmp40_ = posOfStartTag == -1;
#line 6729 "utils.c"
	} else {
#line 676 "../src/utils.vala"
		_tmp40_ = FALSE;
#line 6733 "utils.c"
	}
#line 676 "../src/utils.vala"
	if (_tmp40_) {
#line 6737 "utils.c"
		GString* _tmp41_;
		GString* _tmp42_;
		const gchar* _tmp43_;
		GString* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
#line 677 "../src/utils.vala"
		_tmp41_ = filteredInput;
#line 677 "../src/utils.vala"
		_tmp42_ = filteredInput;
#line 677 "../src/utils.vala"
		_tmp43_ = _tmp42_->str;
#line 677 "../src/utils.vala"
		_tmp44_ = filteredInput;
#line 677 "../src/utils.vala"
		_tmp45_ = _tmp44_->str;
#line 677 "../src/utils.vala"
		_tmp46_ = string_slice (_tmp45_, (glong) 0, (glong) (posOfEndTag + 1));
#line 677 "../src/utils.vala"
		_tmp47_ = _tmp46_;
#line 677 "../src/utils.vala"
		_tmp48_ = string_replace (_tmp43_, _tmp47_, "");
#line 677 "../src/utils.vala"
		_tmp49_ = _tmp48_;
#line 677 "../src/utils.vala"
		g_string_assign (_tmp41_, _tmp49_);
#line 677 "../src/utils.vala"
		_g_free0 (_tmp49_);
#line 677 "../src/utils.vala"
		_g_free0 (_tmp47_);
#line 6771 "utils.c"
	}
#line 679 "../src/utils.vala"
	_tmp50_ = filteredInput;
#line 679 "../src/utils.vala"
	_tmp51_ = _tmp50_->str;
#line 679 "../src/utils.vala"
	posOfStartTag = string_index_of (_tmp51_, "<", 0);
#line 680 "../src/utils.vala"
	_tmp52_ = filteredInput;
#line 680 "../src/utils.vala"
	_tmp53_ = _tmp52_->str;
#line 680 "../src/utils.vala"
	posOfEndTag = string_index_of (_tmp53_, ">", 0);
#line 682 "../src/utils.vala"
	if (posOfStartTag != -1) {
#line 682 "../src/utils.vala"
		_tmp54_ = posOfEndTag == -1;
#line 6789 "utils.c"
	} else {
#line 682 "../src/utils.vala"
		_tmp54_ = FALSE;
#line 6793 "utils.c"
	}
#line 682 "../src/utils.vala"
	if (_tmp54_) {
#line 6797 "utils.c"
		GString* _tmp55_;
		GString* _tmp56_;
		const gchar* _tmp57_;
		GString* _tmp58_;
		const gchar* _tmp59_;
		GString* _tmp60_;
		const gchar* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
#line 683 "../src/utils.vala"
		_tmp55_ = filteredInput;
#line 683 "../src/utils.vala"
		_tmp56_ = filteredInput;
#line 683 "../src/utils.vala"
		_tmp57_ = _tmp56_->str;
#line 683 "../src/utils.vala"
		_tmp58_ = filteredInput;
#line 683 "../src/utils.vala"
		_tmp59_ = _tmp58_->str;
#line 683 "../src/utils.vala"
		_tmp60_ = filteredInput;
#line 683 "../src/utils.vala"
		_tmp61_ = _tmp60_->str;
#line 683 "../src/utils.vala"
		_tmp62_ = strlen (_tmp61_);
#line 683 "../src/utils.vala"
		_tmp63_ = _tmp62_;
#line 683 "../src/utils.vala"
		_tmp64_ = string_slice (_tmp59_, (glong) posOfStartTag, (glong) _tmp63_);
#line 683 "../src/utils.vala"
		_tmp65_ = _tmp64_;
#line 683 "../src/utils.vala"
		_tmp66_ = string_replace (_tmp57_, _tmp65_, "");
#line 683 "../src/utils.vala"
		_tmp67_ = _tmp66_;
#line 683 "../src/utils.vala"
		g_string_assign (_tmp55_, _tmp67_);
#line 683 "../src/utils.vala"
		_g_free0 (_tmp67_);
#line 683 "../src/utils.vala"
		_g_free0 (_tmp65_);
#line 6843 "utils.c"
	}
#line 686 "../src/utils.vala"
	_tmp69_ = filteredInput;
#line 686 "../src/utils.vala"
	_tmp70_ = _tmp69_->str;
#line 686 "../src/utils.vala"
	if (string_index_of (_tmp70_, "<", 0) != -1) {
#line 686 "../src/utils.vala"
		_tmp68_ = TRUE;
#line 6853 "utils.c"
	} else {
		GString* _tmp71_;
		const gchar* _tmp72_;
#line 686 "../src/utils.vala"
		_tmp71_ = filteredInput;
#line 686 "../src/utils.vala"
		_tmp72_ = _tmp71_->str;
#line 686 "../src/utils.vala"
		_tmp68_ = string_index_of (_tmp72_, ">", 0) != -1;
#line 6863 "utils.c"
	}
#line 686 "../src/utils.vala"
	if (_tmp68_) {
#line 6867 "utils.c"
		GString* _tmp73_;
		GString* _tmp74_;
		const gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
#line 687 "../src/utils.vala"
		_tmp73_ = filteredInput;
#line 687 "../src/utils.vala"
		_tmp74_ = filteredInput;
#line 687 "../src/utils.vala"
		_tmp75_ = _tmp74_->str;
#line 687 "../src/utils.vala"
		_tmp76_ = string_strip (_tmp75_);
#line 687 "../src/utils.vala"
		_tmp77_ = _tmp76_;
#line 687 "../src/utils.vala"
		_tmp78_ = bookworm_app_utils_removeTagsFromText (_tmp77_);
#line 687 "../src/utils.vala"
		_tmp79_ = _tmp78_;
#line 687 "../src/utils.vala"
		g_string_assign (_tmp73_, _tmp79_);
#line 687 "../src/utils.vala"
		_g_free0 (_tmp79_);
#line 687 "../src/utils.vala"
		_g_free0 (_tmp77_);
#line 6895 "utils.c"
	}
#line 690 "../src/utils.vala"
	_tmp80_ = filteredInput;
#line 690 "../src/utils.vala"
	_tmp81_ = filteredInput;
#line 690 "../src/utils.vala"
	_tmp82_ = _tmp81_->str;
#line 690 "../src/utils.vala"
	_tmp83_ = bookworm_app_utils_removeMarkUp (_tmp82_);
#line 690 "../src/utils.vala"
	_tmp84_ = _tmp83_;
#line 690 "../src/utils.vala"
	g_string_assign (_tmp80_, _tmp84_);
#line 690 "../src/utils.vala"
	_g_free0 (_tmp84_);
#line 692 "../src/utils.vala"
	_tmp85_ = filteredInput;
#line 692 "../src/utils.vala"
	_tmp86_ = filteredInput;
#line 692 "../src/utils.vala"
	_tmp87_ = _tmp86_->str;
#line 692 "../src/utils.vala"
	_tmp88_ = string_replace (_tmp87_, "\n", "");
#line 692 "../src/utils.vala"
	_tmp89_ = _tmp88_;
#line 692 "../src/utils.vala"
	g_string_assign (_tmp85_, _tmp89_);
#line 692 "../src/utils.vala"
	_g_free0 (_tmp89_);
#line 693 "../src/utils.vala"
	_tmp90_ = filteredInput;
#line 693 "../src/utils.vala"
	_tmp91_ = _tmp90_->str;
#line 693 "../src/utils.vala"
	_tmp92_ = g_strconcat ("Completed execution of removeTagsFromText with text:", _tmp91_, NULL);
#line 693 "../src/utils.vala"
	_tmp93_ = _tmp92_;
#line 693 "../src/utils.vala"
	g_debug ("utils.vala:693: %s", _tmp93_);
#line 693 "../src/utils.vala"
	_g_free0 (_tmp93_);
#line 694 "../src/utils.vala"
	_tmp94_ = filteredInput;
#line 694 "../src/utils.vala"
	_tmp95_ = _tmp94_->str;
#line 694 "../src/utils.vala"
	_tmp96_ = string_strip (_tmp95_);
#line 694 "../src/utils.vala"
	result = _tmp96_;
#line 694 "../src/utils.vala"
	_g_string_free0 (filteredInput);
#line 694 "../src/utils.vala"
	return result;
#line 6949 "utils.c"
}

gchar*
bookworm_app_utils_convertContentListToString (BookwormAppBook* aBook)
{
	GString* contentListString = NULL;
	GString* _tmp0_;
	GeeArrayList* contentList = NULL;
	GeeArrayList* _tmp1_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
#line 697 "../src/utils.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 698 "../src/utils.vala"
	_tmp0_ = g_string_new ("");
#line 698 "../src/utils.vala"
	contentListString = _tmp0_;
#line 699 "../src/utils.vala"
	_tmp1_ = bookworm_app_book_getBookContentList (aBook);
#line 699 "../src/utils.vala"
	contentList = _tmp1_;
#line 6973 "utils.c"
	{
		GeeArrayList* _content_list = NULL;
		GeeArrayList* _tmp2_;
		gint _content_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _content_index = 0;
#line 700 "../src/utils.vala"
		_tmp2_ = contentList;
#line 700 "../src/utils.vala"
		_content_list = _tmp2_;
#line 700 "../src/utils.vala"
		_tmp3_ = _content_list;
#line 700 "../src/utils.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 700 "../src/utils.vala"
		_tmp5_ = _tmp4_;
#line 700 "../src/utils.vala"
		_content_size = _tmp5_;
#line 700 "../src/utils.vala"
		_content_index = -1;
#line 700 "../src/utils.vala"
		while (TRUE) {
#line 6998 "utils.c"
			gint _tmp6_;
			gint _tmp7_;
			gchar* content = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			GString* _tmp12_;
#line 700 "../src/utils.vala"
			_content_index = _content_index + 1;
#line 700 "../src/utils.vala"
			_tmp6_ = _content_index;
#line 700 "../src/utils.vala"
			_tmp7_ = _content_size;
#line 700 "../src/utils.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 700 "../src/utils.vala"
				break;
#line 7017 "utils.c"
			}
#line 700 "../src/utils.vala"
			_tmp8_ = _content_list;
#line 700 "../src/utils.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _content_index);
#line 700 "../src/utils.vala"
			content = (gchar*) _tmp9_;
#line 701 "../src/utils.vala"
			_tmp10_ = contentListString;
#line 701 "../src/utils.vala"
			_tmp11_ = content;
#line 701 "../src/utils.vala"
			_tmp12_ = g_string_append (_tmp10_, _tmp11_);
#line 701 "../src/utils.vala"
			g_string_append (_tmp12_, "~~##~~");
#line 700 "../src/utils.vala"
			_g_free0 (content);
#line 7035 "utils.c"
		}
	}
#line 703 "../src/utils.vala"
	_tmp13_ = contentListString;
#line 703 "../src/utils.vala"
	_tmp14_ = _tmp13_->str;
#line 703 "../src/utils.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 703 "../src/utils.vala"
	result = _tmp15_;
#line 703 "../src/utils.vala"
	_g_object_unref0 (contentList);
#line 703 "../src/utils.vala"
	_g_string_free0 (contentListString);
#line 703 "../src/utils.vala"
	return result;
#line 7052 "utils.c"
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 713 "../src/utils.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 7060 "utils.c"
}

BookwormAppBook*
bookworm_app_utils_convertStringToContentList (BookwormAppBook* aBook,
                                               const gchar* contentListString)
{
	gchar** contentListArray = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint contentListArray_length1;
	gint _contentListArray_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	BookwormAppBook* _tmp10_;
	BookwormAppBook* result;
#line 706 "../src/utils.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 706 "../src/utils.vala"
	g_return_val_if_fail (contentListString != NULL, NULL);
#line 707 "../src/utils.vala"
	_tmp1_ = _tmp0_ = g_strsplit (contentListString, "~~##~~", 0);
#line 707 "../src/utils.vala"
	contentListArray = _tmp1_;
#line 707 "../src/utils.vala"
	contentListArray_length1 = _vala_array_length (_tmp0_);
#line 707 "../src/utils.vala"
	_contentListArray_size_ = contentListArray_length1;
#line 708 "../src/utils.vala"
	_tmp2_ = contentListArray;
#line 708 "../src/utils.vala"
	_tmp2__length1 = contentListArray_length1;
#line 7092 "utils.c"
	{
		gchar** content_collection = NULL;
		gint content_collection_length1 = 0;
		gint _content_collection_size_ = 0;
		gint content_it = 0;
#line 708 "../src/utils.vala"
		content_collection = _tmp2_;
#line 708 "../src/utils.vala"
		content_collection_length1 = _tmp2__length1;
#line 708 "../src/utils.vala"
		for (content_it = 0; content_it < content_collection_length1; content_it = content_it + 1) {
#line 7104 "utils.c"
			gchar* _tmp3_;
			gchar* content = NULL;
#line 708 "../src/utils.vala"
			_tmp3_ = g_strdup (content_collection[content_it]);
#line 708 "../src/utils.vala"
			content = _tmp3_;
#line 7111 "utils.c"
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_;
#line 709 "../src/utils.vala"
				_tmp5_ = content;
#line 709 "../src/utils.vala"
				if (_tmp5_ != NULL) {
#line 7119 "utils.c"
					const gchar* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
#line 709 "../src/utils.vala"
					_tmp6_ = content;
#line 709 "../src/utils.vala"
					_tmp7_ = strlen (_tmp6_);
#line 709 "../src/utils.vala"
					_tmp8_ = _tmp7_;
#line 709 "../src/utils.vala"
					_tmp4_ = _tmp8_ > 0;
#line 7131 "utils.c"
				} else {
#line 709 "../src/utils.vala"
					_tmp4_ = FALSE;
#line 7135 "utils.c"
				}
#line 709 "../src/utils.vala"
				if (_tmp4_) {
#line 7139 "utils.c"
					const gchar* _tmp9_;
#line 710 "../src/utils.vala"
					_tmp9_ = content;
#line 710 "../src/utils.vala"
					bookworm_app_book_setBookContentList (aBook, _tmp9_);
#line 7145 "utils.c"
				}
#line 708 "../src/utils.vala"
				_g_free0 (content);
#line 7149 "utils.c"
			}
		}
	}
#line 713 "../src/utils.vala"
	_tmp10_ = _bookworm_app_book_ref0 (aBook);
#line 713 "../src/utils.vala"
	result = _tmp10_;
#line 713 "../src/utils.vala"
	contentListArray = (_vala_array_free (contentListArray, contentListArray_length1, (GDestroyNotify) g_free), NULL);
#line 713 "../src/utils.vala"
	_bookworm_app_book_unref0 (aBook);
#line 713 "../src/utils.vala"
	return result;
#line 7163 "utils.c"
}

gchar*
bookworm_app_utils_convertTreeMapToString (GeeTreeMap* aMap)
{
	GString* stringForTreeMap = NULL;
	GString* _tmp0_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
#line 716 "../src/utils.vala"
	g_return_val_if_fail (aMap != NULL, NULL);
#line 717 "../src/utils.vala"
	_tmp0_ = g_string_new ("");
#line 717 "../src/utils.vala"
	stringForTreeMap = _tmp0_;
#line 7181 "utils.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 718 "../src/utils.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) aMap);
#line 718 "../src/utils.vala"
		_tmp2_ = _tmp1_;
#line 718 "../src/utils.vala"
		_tmp3_ = _tmp2_;
#line 718 "../src/utils.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 718 "../src/utils.vala"
		_tmp5_ = _tmp4_;
#line 718 "../src/utils.vala"
		_g_object_unref0 (_tmp3_);
#line 718 "../src/utils.vala"
		_entry_it = _tmp5_;
#line 718 "../src/utils.vala"
		while (TRUE) {
#line 7205 "utils.c"
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GString* _tmp9_;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			gconstpointer _tmp12_;
			GString* _tmp13_;
			GString* _tmp14_;
			GeeMapEntry* _tmp15_;
			gconstpointer _tmp16_;
			gconstpointer _tmp17_;
			GString* _tmp18_;
#line 718 "../src/utils.vala"
			_tmp6_ = _entry_it;
#line 718 "../src/utils.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 718 "../src/utils.vala"
				break;
#line 7226 "utils.c"
			}
#line 718 "../src/utils.vala"
			_tmp7_ = _entry_it;
#line 718 "../src/utils.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 718 "../src/utils.vala"
			entry = (GeeMapEntry*) _tmp8_;
#line 719 "../src/utils.vala"
			_tmp9_ = stringForTreeMap;
#line 719 "../src/utils.vala"
			_tmp10_ = entry;
#line 719 "../src/utils.vala"
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
#line 719 "../src/utils.vala"
			_tmp12_ = _tmp11_;
#line 719 "../src/utils.vala"
			_tmp13_ = g_string_append (_tmp9_, (const gchar*) _tmp12_);
#line 719 "../src/utils.vala"
			_tmp14_ = g_string_append (_tmp13_, "~~##~~");
#line 719 "../src/utils.vala"
			_tmp15_ = entry;
#line 719 "../src/utils.vala"
			_tmp16_ = gee_map_entry_get_value (_tmp15_);
#line 719 "../src/utils.vala"
			_tmp17_ = _tmp16_;
#line 719 "../src/utils.vala"
			g_string_append (_tmp14_, (const gchar*) _tmp17_);
#line 720 "../src/utils.vala"
			_tmp18_ = stringForTreeMap;
#line 720 "../src/utils.vala"
			g_string_append (_tmp18_, "~~^^~~");
#line 718 "../src/utils.vala"
			_g_object_unref0 (entry);
#line 7260 "utils.c"
		}
#line 718 "../src/utils.vala"
		_g_object_unref0 (_entry_it);
#line 7264 "utils.c"
	}
#line 722 "../src/utils.vala"
	_tmp19_ = stringForTreeMap;
#line 722 "../src/utils.vala"
	_tmp20_ = _tmp19_->str;
#line 722 "../src/utils.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 722 "../src/utils.vala"
	result = _tmp21_;
#line 722 "../src/utils.vala"
	_g_string_free0 (stringForTreeMap);
#line 722 "../src/utils.vala"
	return result;
#line 7278 "utils.c"
}

GeeTreeMap*
bookworm_app_utils_convertStringToTreeMap (const gchar* stringForTreeMap)
{
	GeeTreeMap* treeMap = NULL;
	GeeTreeMap* _tmp0_;
	GeeTreeMap* result;
#line 725 "../src/utils.vala"
	g_return_val_if_fail (stringForTreeMap != NULL, NULL);
#line 726 "../src/utils.vala"
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 726 "../src/utils.vala"
	treeMap = _tmp0_;
#line 727 "../src/utils.vala"
	if (string_index_of (stringForTreeMap, "~~^^~~", 0) != -1) {
#line 7295 "utils.c"
		gchar** treeMapArray = NULL;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint treeMapArray_length1;
		gint _treeMapArray_size_;
		gchar** _tmp3_;
		gint _tmp3__length1;
#line 728 "../src/utils.vala"
		_tmp2_ = _tmp1_ = g_strsplit (stringForTreeMap, "~~^^~~", 0);
#line 728 "../src/utils.vala"
		treeMapArray = _tmp2_;
#line 728 "../src/utils.vala"
		treeMapArray_length1 = _vala_array_length (_tmp1_);
#line 728 "../src/utils.vala"
		_treeMapArray_size_ = treeMapArray_length1;
#line 729 "../src/utils.vala"
		_tmp3_ = treeMapArray;
#line 729 "../src/utils.vala"
		_tmp3__length1 = treeMapArray_length1;
#line 7315 "utils.c"
		{
			gchar** mapEntry_collection = NULL;
			gint mapEntry_collection_length1 = 0;
			gint _mapEntry_collection_size_ = 0;
			gint mapEntry_it = 0;
#line 729 "../src/utils.vala"
			mapEntry_collection = _tmp3_;
#line 729 "../src/utils.vala"
			mapEntry_collection_length1 = _tmp3__length1;
#line 729 "../src/utils.vala"
			for (mapEntry_it = 0; mapEntry_it < mapEntry_collection_length1; mapEntry_it = mapEntry_it + 1) {
#line 7327 "utils.c"
				gchar* _tmp4_;
				gchar* mapEntry = NULL;
#line 729 "../src/utils.vala"
				_tmp4_ = g_strdup (mapEntry_collection[mapEntry_it]);
#line 729 "../src/utils.vala"
				mapEntry = _tmp4_;
#line 7334 "utils.c"
				{
					const gchar* _tmp5_;
#line 730 "../src/utils.vala"
					_tmp5_ = mapEntry;
#line 730 "../src/utils.vala"
					if (string_index_of (_tmp5_, "~~##~~", 0) != -1) {
#line 7341 "utils.c"
						gchar** keyValPair = NULL;
						const gchar* _tmp6_;
						gchar** _tmp7_;
						gchar** _tmp8_;
						gint keyValPair_length1;
						gint _keyValPair_size_;
						GeeTreeMap* _tmp9_;
						gchar** _tmp10_;
						gint _tmp10__length1;
						const gchar* _tmp11_;
						gchar** _tmp12_;
						gint _tmp12__length1;
						const gchar* _tmp13_;
#line 731 "../src/utils.vala"
						_tmp6_ = mapEntry;
#line 731 "../src/utils.vala"
						_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "~~##~~", 0);
#line 731 "../src/utils.vala"
						keyValPair = _tmp8_;
#line 731 "../src/utils.vala"
						keyValPair_length1 = _vala_array_length (_tmp7_);
#line 731 "../src/utils.vala"
						_keyValPair_size_ = keyValPair_length1;
#line 732 "../src/utils.vala"
						_tmp9_ = treeMap;
#line 732 "../src/utils.vala"
						_tmp10_ = keyValPair;
#line 732 "../src/utils.vala"
						_tmp10__length1 = keyValPair_length1;
#line 732 "../src/utils.vala"
						_tmp11_ = _tmp10_[0];
#line 732 "../src/utils.vala"
						_tmp12_ = keyValPair;
#line 732 "../src/utils.vala"
						_tmp12__length1 = keyValPair_length1;
#line 732 "../src/utils.vala"
						_tmp13_ = _tmp12_[1];
#line 732 "../src/utils.vala"
						gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp11_, _tmp13_);
#line 730 "../src/utils.vala"
						keyValPair = (_vala_array_free (keyValPair, keyValPair_length1, (GDestroyNotify) g_free), NULL);
#line 7383 "utils.c"
					}
#line 729 "../src/utils.vala"
					_g_free0 (mapEntry);
#line 7387 "utils.c"
				}
			}
		}
#line 727 "../src/utils.vala"
		treeMapArray = (_vala_array_free (treeMapArray, treeMapArray_length1, (GDestroyNotify) g_free), NULL);
#line 7393 "utils.c"
	}
#line 736 "../src/utils.vala"
	result = treeMap;
#line 736 "../src/utils.vala"
	return result;
#line 7399 "utils.c"
}

gchar*
bookworm_app_utils_convertTOCToString (BookwormAppBook* aBook)
{
	GString* tocString = NULL;
	GString* _tmp0_;
	GeeArrayList* tocList = NULL;
	GeeArrayList* _tmp1_;
	GString* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result;
#line 739 "../src/utils.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 740 "../src/utils.vala"
	_tmp0_ = g_string_new ("");
#line 740 "../src/utils.vala"
	tocString = _tmp0_;
#line 741 "../src/utils.vala"
	_tmp1_ = bookworm_app_book_getTOC (aBook);
#line 741 "../src/utils.vala"
	tocList = _tmp1_;
#line 7423 "utils.c"
	{
		GeeArrayList* _tocListItemMap_list = NULL;
		GeeArrayList* _tmp2_;
		gint _tocListItemMap_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tocListItemMap_index = 0;
#line 742 "../src/utils.vala"
		_tmp2_ = tocList;
#line 742 "../src/utils.vala"
		_tocListItemMap_list = _tmp2_;
#line 742 "../src/utils.vala"
		_tmp3_ = _tocListItemMap_list;
#line 742 "../src/utils.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 742 "../src/utils.vala"
		_tmp5_ = _tmp4_;
#line 742 "../src/utils.vala"
		_tocListItemMap_size = _tmp5_;
#line 742 "../src/utils.vala"
		_tocListItemMap_index = -1;
#line 742 "../src/utils.vala"
		while (TRUE) {
#line 7448 "utils.c"
			gint _tmp6_;
			gint _tmp7_;
			GeeHashMap* tocListItemMap = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GString* _tmp28_;
#line 742 "../src/utils.vala"
			_tocListItemMap_index = _tocListItemMap_index + 1;
#line 742 "../src/utils.vala"
			_tmp6_ = _tocListItemMap_index;
#line 742 "../src/utils.vala"
			_tmp7_ = _tocListItemMap_size;
#line 742 "../src/utils.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 742 "../src/utils.vala"
				break;
#line 7465 "utils.c"
			}
#line 742 "../src/utils.vala"
			_tmp8_ = _tocListItemMap_list;
#line 742 "../src/utils.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tocListItemMap_index);
#line 742 "../src/utils.vala"
			tocListItemMap = (GeeHashMap*) _tmp9_;
#line 7473 "utils.c"
			{
				GeeIterator* _entry_it = NULL;
				GeeHashMap* _tmp10_;
				GeeSet* _tmp11_;
				GeeSet* _tmp12_;
				GeeSet* _tmp13_;
				GeeIterator* _tmp14_;
				GeeIterator* _tmp15_;
#line 743 "../src/utils.vala"
				_tmp10_ = tocListItemMap;
#line 743 "../src/utils.vala"
				_tmp11_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp10_);
#line 743 "../src/utils.vala"
				_tmp12_ = _tmp11_;
#line 743 "../src/utils.vala"
				_tmp13_ = _tmp12_;
#line 743 "../src/utils.vala"
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
#line 743 "../src/utils.vala"
				_tmp15_ = _tmp14_;
#line 743 "../src/utils.vala"
				_g_object_unref0 (_tmp13_);
#line 743 "../src/utils.vala"
				_entry_it = _tmp15_;
#line 743 "../src/utils.vala"
				while (TRUE) {
#line 7500 "utils.c"
					GeeIterator* _tmp16_;
					GeeMapEntry* entry = NULL;
					GeeIterator* _tmp17_;
					gpointer _tmp18_;
					GString* _tmp19_;
					GeeMapEntry* _tmp20_;
					gconstpointer _tmp21_;
					gconstpointer _tmp22_;
					GString* _tmp23_;
					GString* _tmp24_;
					GeeMapEntry* _tmp25_;
					gconstpointer _tmp26_;
					gconstpointer _tmp27_;
#line 743 "../src/utils.vala"
					_tmp16_ = _entry_it;
#line 743 "../src/utils.vala"
					if (!gee_iterator_next (_tmp16_)) {
#line 743 "../src/utils.vala"
						break;
#line 7520 "utils.c"
					}
#line 743 "../src/utils.vala"
					_tmp17_ = _entry_it;
#line 743 "../src/utils.vala"
					_tmp18_ = gee_iterator_get (_tmp17_);
#line 743 "../src/utils.vala"
					entry = (GeeMapEntry*) _tmp18_;
#line 744 "../src/utils.vala"
					_tmp19_ = tocString;
#line 744 "../src/utils.vala"
					_tmp20_ = entry;
#line 744 "../src/utils.vala"
					_tmp21_ = gee_map_entry_get_key (_tmp20_);
#line 744 "../src/utils.vala"
					_tmp22_ = _tmp21_;
#line 744 "../src/utils.vala"
					_tmp23_ = g_string_append (_tmp19_, (const gchar*) _tmp22_);
#line 744 "../src/utils.vala"
					_tmp24_ = g_string_append (_tmp23_, "~~##~~");
#line 744 "../src/utils.vala"
					_tmp25_ = entry;
#line 744 "../src/utils.vala"
					_tmp26_ = gee_map_entry_get_value (_tmp25_);
#line 744 "../src/utils.vala"
					_tmp27_ = _tmp26_;
#line 744 "../src/utils.vala"
					g_string_append (_tmp24_, (const gchar*) _tmp27_);
#line 743 "../src/utils.vala"
					_g_object_unref0 (entry);
#line 7550 "utils.c"
				}
#line 743 "../src/utils.vala"
				_g_object_unref0 (_entry_it);
#line 7554 "utils.c"
			}
#line 746 "../src/utils.vala"
			_tmp28_ = tocString;
#line 746 "../src/utils.vala"
			g_string_append (_tmp28_, "~~^^~~");
#line 742 "../src/utils.vala"
			_g_object_unref0 (tocListItemMap);
#line 7562 "utils.c"
		}
	}
#line 748 "../src/utils.vala"
	_tmp29_ = tocString;
#line 748 "../src/utils.vala"
	_tmp30_ = _tmp29_->str;
#line 748 "../src/utils.vala"
	_tmp31_ = g_strdup (_tmp30_);
#line 748 "../src/utils.vala"
	result = _tmp31_;
#line 748 "../src/utils.vala"
	_g_object_unref0 (tocList);
#line 748 "../src/utils.vala"
	_g_string_free0 (tocString);
#line 748 "../src/utils.vala"
	return result;
#line 7579 "utils.c"
}

BookwormAppBook*
bookworm_app_utils_convertStringToTOC (BookwormAppBook* aBook,
                                       const gchar* tocString)
{
	gchar** tocStringArray = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tocStringArray_length1;
	gint _tocStringArray_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	BookwormAppBook* _tmp15_;
	BookwormAppBook* result;
#line 751 "../src/utils.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 751 "../src/utils.vala"
	g_return_val_if_fail (tocString != NULL, NULL);
#line 753 "../src/utils.vala"
	_tmp1_ = _tmp0_ = g_strsplit (tocString, "~~^^~~", 0);
#line 753 "../src/utils.vala"
	tocStringArray = _tmp1_;
#line 753 "../src/utils.vala"
	tocStringArray_length1 = _vala_array_length (_tmp0_);
#line 753 "../src/utils.vala"
	_tocStringArray_size_ = tocStringArray_length1;
#line 755 "../src/utils.vala"
	_tmp2_ = tocStringArray;
#line 755 "../src/utils.vala"
	_tmp2__length1 = tocStringArray_length1;
#line 7611 "utils.c"
	{
		gchar** tocItemStr_collection = NULL;
		gint tocItemStr_collection_length1 = 0;
		gint _tocItemStr_collection_size_ = 0;
		gint tocItemStr_it = 0;
#line 755 "../src/utils.vala"
		tocItemStr_collection = _tmp2_;
#line 755 "../src/utils.vala"
		tocItemStr_collection_length1 = _tmp2__length1;
#line 755 "../src/utils.vala"
		for (tocItemStr_it = 0; tocItemStr_it < tocItemStr_collection_length1; tocItemStr_it = tocItemStr_it + 1) {
#line 7623 "utils.c"
			gchar* _tmp3_;
			gchar* tocItemStr = NULL;
#line 755 "../src/utils.vala"
			_tmp3_ = g_strdup (tocItemStr_collection[tocItemStr_it]);
#line 755 "../src/utils.vala"
			tocItemStr = _tmp3_;
#line 7630 "utils.c"
			{
				gchar** tocItemStringArray = NULL;
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gint tocItemStringArray_length1;
				gint _tocItemStringArray_size_;
				gchar** _tmp7_;
				gint _tmp7__length1;
#line 756 "../src/utils.vala"
				_tmp4_ = tocItemStr;
#line 756 "../src/utils.vala"
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "~~##~~", 0);
#line 756 "../src/utils.vala"
				tocItemStringArray = _tmp6_;
#line 756 "../src/utils.vala"
				tocItemStringArray_length1 = _vala_array_length (_tmp5_);
#line 756 "../src/utils.vala"
				_tocItemStringArray_size_ = tocItemStringArray_length1;
#line 757 "../src/utils.vala"
				_tmp7_ = tocItemStringArray;
#line 757 "../src/utils.vala"
				_tmp7__length1 = tocItemStringArray_length1;
#line 757 "../src/utils.vala"
				if (_tmp7__length1 == 2) {
#line 7656 "utils.c"
					GeeHashMap* tocListItemMap = NULL;
					GeeHashMap* _tmp8_;
					GeeHashMap* _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					GeeHashMap* _tmp14_;
#line 758 "../src/utils.vala"
					_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 758 "../src/utils.vala"
					tocListItemMap = _tmp8_;
#line 759 "../src/utils.vala"
					_tmp9_ = tocListItemMap;
#line 759 "../src/utils.vala"
					_tmp10_ = tocItemStringArray;
#line 759 "../src/utils.vala"
					_tmp10__length1 = tocItemStringArray_length1;
#line 759 "../src/utils.vala"
					_tmp11_ = _tmp10_[0];
#line 759 "../src/utils.vala"
					_tmp12_ = tocItemStringArray;
#line 759 "../src/utils.vala"
					_tmp12__length1 = tocItemStringArray_length1;
#line 759 "../src/utils.vala"
					_tmp13_ = _tmp12_[1];
#line 759 "../src/utils.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp11_, _tmp13_);
#line 760 "../src/utils.vala"
					_tmp14_ = tocListItemMap;
#line 760 "../src/utils.vala"
					bookworm_app_book_setTOC (aBook, _tmp14_);
#line 757 "../src/utils.vala"
					_g_object_unref0 (tocListItemMap);
#line 7693 "utils.c"
				}
#line 755 "../src/utils.vala"
				tocItemStringArray = (_vala_array_free (tocItemStringArray, tocItemStringArray_length1, (GDestroyNotify) g_free), NULL);
#line 755 "../src/utils.vala"
				_g_free0 (tocItemStr);
#line 7699 "utils.c"
			}
		}
	}
#line 763 "../src/utils.vala"
	_tmp15_ = _bookworm_app_book_ref0 (aBook);
#line 763 "../src/utils.vala"
	result = _tmp15_;
#line 763 "../src/utils.vala"
	tocStringArray = (_vala_array_free (tocStringArray, tocStringArray_length1, (GDestroyNotify) g_free), NULL);
#line 763 "../src/utils.vala"
	_bookworm_app_book_unref0 (aBook);
#line 763 "../src/utils.vala"
	return result;
#line 7713 "utils.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 7737 "utils.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 7745 "utils.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 7751 "utils.c"
	}
}

BookwormAppBook*
bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                      const gchar* bookCoverImageLocation)
{
	gchar* coverImageFileName = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* coverImageFileExtension = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* bookwormCoverLocation = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	BookwormAppBook* _tmp36_;
	BookwormAppBook* result;
#line 766 "../src/utils.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 766 "../src/utils.vala"
	g_return_val_if_fail (bookCoverImageLocation != NULL, NULL);
#line 768 "../src/utils.vala"
	_tmp0_ = g_file_new_for_commandline_arg (bookCoverImageLocation);
#line 768 "../src/utils.vala"
	_tmp1_ = _tmp0_;
#line 768 "../src/utils.vala"
	_tmp2_ = g_file_get_basename (_tmp1_);
#line 768 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 768 "../src/utils.vala"
	_g_object_unref0 (_tmp1_);
#line 768 "../src/utils.vala"
	coverImageFileName = _tmp3_;
#line 769 "../src/utils.vala"
	_tmp4_ = g_strdup ("");
#line 769 "../src/utils.vala"
	coverImageFileExtension = _tmp4_;
#line 770 "../src/utils.vala"
	_tmp5_ = coverImageFileName;
#line 770 "../src/utils.vala"
	if (string_index_of (_tmp5_, ".", 0) != -1) {
#line 7818 "utils.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
#line 771 "../src/utils.vala"
		_tmp6_ = coverImageFileName;
#line 771 "../src/utils.vala"
		_tmp7_ = coverImageFileName;
#line 771 "../src/utils.vala"
		_tmp8_ = coverImageFileName;
#line 771 "../src/utils.vala"
		_tmp9_ = strlen (_tmp8_);
#line 771 "../src/utils.vala"
		_tmp10_ = _tmp9_;
#line 771 "../src/utils.vala"
		_tmp11_ = string_slice (_tmp6_, (glong) (string_last_index_of (_tmp7_, ".", 0) + 1), (glong) _tmp10_);
#line 771 "../src/utils.vala"
		_g_free0 (coverImageFileExtension);
#line 771 "../src/utils.vala"
		coverImageFileExtension = _tmp11_;
#line 7841 "utils.c"
	}
#line 773 "../src/utils.vala"
	_tmp12_ = bookworm_app_bookworm_bookworm_config_path;
#line 773 "../src/utils.vala"
	_tmp13_ = g_strconcat (_tmp12_, "/covers/", NULL);
#line 773 "../src/utils.vala"
	_tmp14_ = _tmp13_;
#line 773 "../src/utils.vala"
	_tmp15_ = g_strdup_printf ("%i", bookworm_app_book_getBookId (aBook));
#line 773 "../src/utils.vala"
	_tmp16_ = _tmp15_;
#line 773 "../src/utils.vala"
	_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
#line 773 "../src/utils.vala"
	_tmp18_ = _tmp17_;
#line 773 "../src/utils.vala"
	_tmp19_ = g_strconcat (_tmp18_, "_cover.", NULL);
#line 773 "../src/utils.vala"
	_tmp20_ = _tmp19_;
#line 773 "../src/utils.vala"
	_tmp21_ = coverImageFileExtension;
#line 773 "../src/utils.vala"
	_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
#line 773 "../src/utils.vala"
	_tmp23_ = _tmp22_;
#line 773 "../src/utils.vala"
	_g_free0 (_tmp20_);
#line 773 "../src/utils.vala"
	_g_free0 (_tmp18_);
#line 773 "../src/utils.vala"
	_g_free0 (_tmp16_);
#line 773 "../src/utils.vala"
	_g_free0 (_tmp14_);
#line 773 "../src/utils.vala"
	bookwormCoverLocation = _tmp23_;
#line 776 "../src/utils.vala"
	_tmp24_ = g_strconcat ("cp \"", bookCoverImageLocation, NULL);
#line 776 "../src/utils.vala"
	_tmp25_ = _tmp24_;
#line 776 "../src/utils.vala"
	_tmp26_ = g_strconcat (_tmp25_, "\" \"", NULL);
#line 776 "../src/utils.vala"
	_tmp27_ = _tmp26_;
#line 776 "../src/utils.vala"
	_tmp28_ = g_strconcat (_tmp27_, bookwormCoverLocation, NULL);
#line 776 "../src/utils.vala"
	_tmp29_ = _tmp28_;
#line 776 "../src/utils.vala"
	_tmp30_ = g_strconcat (_tmp29_, "\"", NULL);
#line 776 "../src/utils.vala"
	_tmp31_ = _tmp30_;
#line 776 "../src/utils.vala"
	_tmp32_ = bookworm_app_utils_execute_sync_command (_tmp31_);
#line 776 "../src/utils.vala"
	_tmp33_ = _tmp32_;
#line 776 "../src/utils.vala"
	_g_free0 (_tmp33_);
#line 776 "../src/utils.vala"
	_g_free0 (_tmp31_);
#line 776 "../src/utils.vala"
	_g_free0 (_tmp29_);
#line 776 "../src/utils.vala"
	_g_free0 (_tmp27_);
#line 776 "../src/utils.vala"
	_g_free0 (_tmp25_);
#line 778 "../src/utils.vala"
	bookworm_app_book_setIsBookCoverImagePresent (aBook, TRUE);
#line 779 "../src/utils.vala"
	bookworm_app_book_setBookCoverLocation (aBook, bookwormCoverLocation);
#line 780 "../src/utils.vala"
	_tmp34_ = g_strconcat ("eBook cover image extracted successfully into location:", bookwormCoverLocation, NULL);
#line 780 "../src/utils.vala"
	_tmp35_ = _tmp34_;
#line 780 "../src/utils.vala"
	g_debug ("utils.vala:780: %s", _tmp35_);
#line 780 "../src/utils.vala"
	_g_free0 (_tmp35_);
#line 781 "../src/utils.vala"
	_tmp36_ = _bookworm_app_book_ref0 (aBook);
#line 781 "../src/utils.vala"
	result = _tmp36_;
#line 781 "../src/utils.vala"
	_g_free0 (bookwormCoverLocation);
#line 781 "../src/utils.vala"
	_g_free0 (coverImageFileExtension);
#line 781 "../src/utils.vala"
	_g_free0 (coverImageFileName);
#line 781 "../src/utils.vala"
	_bookworm_app_book_unref0 (aBook);
#line 781 "../src/utils.vala"
	return result;
#line 7933 "utils.c"
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 784 "../src/utils.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 784 "../src/utils.vala"
	return _data4_;
#line 7943 "utils.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 784 "../src/utils.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 784 "../src/utils.vala"
		_g_main_loop_unref0 (_data4_->loop);
#line 784 "../src/utils.vala"
		_g_free0 (_data4_->selectedText);
#line 784 "../src/utils.vala"
		g_slice_free (Block4Data, _data4_);
#line 7959 "utils.c"
	}
}

static void
__lambda7_ (Block4Data* _data4_,
            GObject* obj,
            GAsyncResult* res)
{
	WebKitWebView* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
#line 788 "../src/utils.vala"
	g_return_if_fail (res != NULL);
#line 7974 "utils.c"
	{
		WebKitWebView* _tmp0_;
		WebKitJavascriptResult* _tmp1_;
		WebKitJavascriptResult* _tmp2_;
#line 790 "../src/utils.vala"
		_tmp0_ = bookworm_app_app_window_aWebView;
#line 790 "../src/utils.vala"
		_tmp1_ = webkit_web_view_run_javascript_finish (_tmp0_, res, &_inner_error0_);
#line 790 "../src/utils.vala"
		_tmp2_ = _tmp1_;
#line 790 "../src/utils.vala"
		_webkit_javascript_result_unref0 (_tmp2_);
#line 790 "../src/utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 7989 "utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 789 "../src/utils.vala"
		e = _inner_error0_;
#line 789 "../src/utils.vala"
		_inner_error0_ = NULL;
#line 792 "../src/utils.vala"
		_tmp3_ = e;
#line 792 "../src/utils.vala"
		_tmp4_ = _tmp3_->message;
#line 792 "../src/utils.vala"
		_tmp5_ = g_strconcat ("Could not get selected text, javascript error: ", _tmp4_, NULL);
#line 792 "../src/utils.vala"
		_tmp6_ = _tmp5_;
#line 792 "../src/utils.vala"
		g_warning ("utils.vala:792: %s", _tmp6_);
#line 792 "../src/utils.vala"
		_g_free0 (_tmp6_);
#line 789 "../src/utils.vala"
		_g_error_free0 (e);
#line 8019 "utils.c"
	}
	__finally0:
#line 789 "../src/utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 789 "../src/utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 789 "../src/utils.vala"
		g_clear_error (&_inner_error0_);
#line 789 "../src/utils.vala"
		return;
#line 8030 "utils.c"
	}
#line 794 "../src/utils.vala"
	_tmp7_ = bookworm_app_app_window_aWebView;
#line 794 "../src/utils.vala"
	_tmp8_ = webkit_web_view_get_title (_tmp7_);
#line 794 "../src/utils.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 794 "../src/utils.vala"
	_g_free0 (_data4_->selectedText);
#line 794 "../src/utils.vala"
	_data4_->selectedText = _tmp9_;
#line 795 "../src/utils.vala"
	g_main_loop_quit (_data4_->loop);
#line 8044 "utils.c"
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 788 "../src/utils.vala"
	__lambda7_ (self, source_object, res);
#line 788 "../src/utils.vala"
	block4_data_unref (self);
#line 8056 "utils.c"
}

gchar*
bookworm_app_utils_setWebViewTitle (const gchar* javascript)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GMainLoop* _tmp3_;
	WebKitWebView* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
#line 784 "../src/utils.vala"
	g_return_val_if_fail (javascript != NULL, NULL);
#line 784 "../src/utils.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 784 "../src/utils.vala"
	_data4_->_ref_count_ = 1;
#line 785 "../src/utils.vala"
	_tmp0_ = g_strdup ("");
#line 785 "../src/utils.vala"
	_data4_->selectedText = _tmp0_;
#line 786 "../src/utils.vala"
	_tmp1_ = g_strconcat ("Javascrit for setting Webview Title:", javascript, NULL);
#line 786 "../src/utils.vala"
	_tmp2_ = _tmp1_;
#line 786 "../src/utils.vala"
	g_debug ("utils.vala:786: %s", _tmp2_);
#line 786 "../src/utils.vala"
	_g_free0 (_tmp2_);
#line 787 "../src/utils.vala"
	_tmp3_ = g_main_loop_new (NULL, FALSE);
#line 787 "../src/utils.vala"
	_data4_->loop = _tmp3_;
#line 788 "../src/utils.vala"
	_tmp4_ = bookworm_app_app_window_aWebView;
#line 788 "../src/utils.vala"
	webkit_web_view_run_javascript (_tmp4_, javascript, NULL, ___lambda7__gasync_ready_callback, block4_data_ref (_data4_));
#line 797 "../src/utils.vala"
	g_main_loop_run (_data4_->loop);
#line 798 "../src/utils.vala"
	_tmp5_ = g_strconcat ("Webview Title set as:", _data4_->selectedText, NULL);
#line 798 "../src/utils.vala"
	_tmp6_ = _tmp5_;
#line 798 "../src/utils.vala"
	g_debug ("utils.vala:798: %s", _tmp6_);
#line 798 "../src/utils.vala"
	_g_free0 (_tmp6_);
#line 799 "../src/utils.vala"
	_tmp7_ = g_strdup (_data4_->selectedText);
#line 799 "../src/utils.vala"
	result = _tmp7_;
#line 799 "../src/utils.vala"
	block4_data_unref (_data4_);
#line 799 "../src/utils.vala"
	_data4_ = NULL;
#line 799 "../src/utils.vala"
	return result;
#line 8118 "utils.c"
}

gchar*
bookworm_app_utils_minimizeStringLength (const gchar* originalString,
                                         gint maxLength)
{
	gchar* modifiedString = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* result;
#line 802 "../src/utils.vala"
	g_return_val_if_fail (originalString != NULL, NULL);
#line 803 "../src/utils.vala"
	_tmp0_ = g_strdup (originalString);
#line 803 "../src/utils.vala"
	modifiedString = _tmp0_;
#line 804 "../src/utils.vala"
	_tmp1_ = modifiedString;
#line 804 "../src/utils.vala"
	_tmp2_ = strlen (_tmp1_);
#line 804 "../src/utils.vala"
	_tmp3_ = _tmp2_;
#line 804 "../src/utils.vala"
	if (_tmp3_ > maxLength) {
#line 8145 "utils.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 805 "../src/utils.vala"
		_tmp4_ = modifiedString;
#line 805 "../src/utils.vala"
		_tmp5_ = string_slice (_tmp4_, (glong) 0, (glong) maxLength);
#line 805 "../src/utils.vala"
		_tmp6_ = _tmp5_;
#line 805 "../src/utils.vala"
		_tmp7_ = g_strconcat (_tmp6_, "...", NULL);
#line 805 "../src/utils.vala"
		_g_free0 (modifiedString);
#line 805 "../src/utils.vala"
		modifiedString = _tmp7_;
#line 805 "../src/utils.vala"
		_g_free0 (_tmp6_);
#line 8164 "utils.c"
	}
#line 807 "../src/utils.vala"
	result = modifiedString;
#line 807 "../src/utils.vala"
	return result;
#line 8170 "utils.c"
}

gchar*
bookworm_app_utils_breakString (const gchar* originalString,
                                gint breakLength,
                                const gchar* breakString)
{
	GString* formattedString = NULL;
	GString* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
#line 810 "../src/utils.vala"
	g_return_val_if_fail (originalString != NULL, NULL);
#line 810 "../src/utils.vala"
	g_return_val_if_fail (breakString != NULL, NULL);
#line 811 "../src/utils.vala"
	_tmp0_ = g_string_new ("");
#line 811 "../src/utils.vala"
	formattedString = _tmp0_;
#line 813 "../src/utils.vala"
	_tmp1_ = strlen (originalString);
#line 813 "../src/utils.vala"
	_tmp2_ = _tmp1_;
#line 813 "../src/utils.vala"
	if (_tmp2_ > breakLength) {
#line 8200 "utils.c"
		GString* extractedString = NULL;
		GString* _tmp3_;
		gint charCount = 0;
		GString* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 814 "../src/utils.vala"
		_tmp3_ = g_string_new ("");
#line 814 "../src/utils.vala"
		extractedString = _tmp3_;
#line 815 "../src/utils.vala"
		charCount = 0;
#line 817 "../src/utils.vala"
		while (TRUE) {
#line 8217 "utils.c"
			gboolean _tmp4_ = FALSE;
			gint _tmp5_;
			gint _tmp6_;
			GString* _tmp9_;
			GString* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GString* _tmp13_;
			const gchar* _tmp14_;
#line 817 "../src/utils.vala"
			_tmp5_ = strlen (originalString);
#line 817 "../src/utils.vala"
			_tmp6_ = _tmp5_;
#line 817 "../src/utils.vala"
			if (charCount < _tmp6_) {
#line 8233 "utils.c"
				gint _tmp7_;
				gint _tmp8_;
#line 817 "../src/utils.vala"
				_tmp7_ = strlen (originalString);
#line 817 "../src/utils.vala"
				_tmp8_ = _tmp7_;
#line 817 "../src/utils.vala"
				_tmp4_ = (_tmp8_ - charCount) > breakLength;
#line 8242 "utils.c"
			} else {
#line 817 "../src/utils.vala"
				_tmp4_ = FALSE;
#line 8246 "utils.c"
			}
#line 817 "../src/utils.vala"
			if (!_tmp4_) {
#line 817 "../src/utils.vala"
				break;
#line 8252 "utils.c"
			}
#line 819 "../src/utils.vala"
			_tmp9_ = extractedString;
#line 819 "../src/utils.vala"
			g_string_assign (_tmp9_, "");
#line 820 "../src/utils.vala"
			_tmp10_ = extractedString;
#line 820 "../src/utils.vala"
			_tmp11_ = string_slice (originalString, (glong) charCount, (glong) (charCount + breakLength));
#line 820 "../src/utils.vala"
			_tmp12_ = _tmp11_;
#line 820 "../src/utils.vala"
			g_string_assign (_tmp10_, _tmp12_);
#line 820 "../src/utils.vala"
			_g_free0 (_tmp12_);
#line 822 "../src/utils.vala"
			_tmp13_ = extractedString;
#line 822 "../src/utils.vala"
			_tmp14_ = _tmp13_->str;
#line 822 "../src/utils.vala"
			if (string_index_of (_tmp14_, breakString, 0) != -1) {
#line 8274 "utils.c"
				GString* _tmp15_;
				GString* _tmp16_;
				const gchar* _tmp17_;
#line 824 "../src/utils.vala"
				_tmp15_ = formattedString;
#line 824 "../src/utils.vala"
				_tmp16_ = extractedString;
#line 824 "../src/utils.vala"
				_tmp17_ = _tmp16_->str;
#line 824 "../src/utils.vala"
				g_string_append (_tmp15_, _tmp17_);
#line 8286 "utils.c"
			} else {
				GString* _tmp18_;
				GString* _tmp19_;
				const gchar* _tmp20_;
				GString* _tmp21_;
#line 827 "../src/utils.vala"
				_tmp18_ = formattedString;
#line 827 "../src/utils.vala"
				_tmp19_ = extractedString;
#line 827 "../src/utils.vala"
				_tmp20_ = _tmp19_->str;
#line 827 "../src/utils.vala"
				_tmp21_ = g_string_append (_tmp18_, _tmp20_);
#line 827 "../src/utils.vala"
				g_string_append (_tmp21_, breakString);
#line 8302 "utils.c"
			}
#line 829 "../src/utils.vala"
			charCount = charCount + breakLength;
#line 8306 "utils.c"
		}
#line 832 "../src/utils.vala"
		_tmp22_ = formattedString;
#line 832 "../src/utils.vala"
		_tmp23_ = strlen (originalString);
#line 832 "../src/utils.vala"
		_tmp24_ = _tmp23_;
#line 832 "../src/utils.vala"
		_tmp25_ = string_slice (originalString, (glong) charCount, (glong) _tmp24_);
#line 832 "../src/utils.vala"
		_tmp26_ = _tmp25_;
#line 832 "../src/utils.vala"
		g_string_append (_tmp22_, _tmp26_);
#line 832 "../src/utils.vala"
		_g_free0 (_tmp26_);
#line 813 "../src/utils.vala"
		_g_string_free0 (extractedString);
#line 8324 "utils.c"
	} else {
		GString* _tmp27_;
#line 834 "../src/utils.vala"
		_tmp27_ = formattedString;
#line 834 "../src/utils.vala"
		g_string_append (_tmp27_, originalString);
#line 8331 "utils.c"
	}
#line 836 "../src/utils.vala"
	_tmp28_ = formattedString;
#line 836 "../src/utils.vala"
	_tmp29_ = _tmp28_->str;
#line 836 "../src/utils.vala"
	_tmp30_ = g_strdup (_tmp29_);
#line 836 "../src/utils.vala"
	result = _tmp30_;
#line 836 "../src/utils.vala"
	_g_string_free0 (formattedString);
#line 836 "../src/utils.vala"
	return result;
#line 8345 "utils.c"
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

