/* LayerLabel.c generated by valac 0.56.17, the Vala compiler
 * generated from LayerLabel.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LAYER_LABEL_0_PROPERTY,
	BIRD_FONT_LAYER_LABEL_SELECTED_LAYER_PROPERTY,
	BIRD_FONT_LAYER_LABEL_LABEL_PROPERTY,
	BIRD_FONT_LAYER_LABEL_NUM_PROPERTIES
};
static GParamSpec* bird_font_layer_label_properties[BIRD_FONT_LAYER_LABEL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block27Data Block27Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))

struct _BirdFontLayerLabelPrivate {
	gboolean _selected_layer;
	gchar* _label;
	BirdFontText* label_text;
	gboolean active_layer;
};

struct _Block27Data {
	int _ref_count_;
	BirdFontLayerLabel* self;
	BirdFontLayer* layer;
};

static gint BirdFontLayerLabel_private_offset;
static gpointer bird_font_layer_label_parent_class = NULL;

static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void bird_font_layer_label_set_text (BirdFontLayerLabel* self);
static void __lambda169_ (Block27Data* _data27_,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void ___lambda169__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                      BirdFontTool* selected,
                                                      guint button,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static void __lambda171_ (BirdFontLayerLabel* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void bird_font_layer_label_set_layer_name (BirdFontLayerLabel* self);
static void ___lambda171__bird_font_tool_panel_double_click_action (BirdFontTool* _sender,
                                                             BirdFontTool* selected,
                                                             guint button,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self);
static gboolean __lambda174_ (BirdFontLayerLabel* self,
                       BirdFontTool* selected,
                       BirdFontTool* button,
                       gdouble tx,
                       gdouble ty);
static void bird_font_layer_label_move_layer_down (BirdFontLayerLabel* self);
static void bird_font_layer_label_move_layer_up (BirdFontLayerLabel* self);
static gboolean ___lambda174__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                         BirdFontTool* selected,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self);
static void __lambda175_ (BirdFontLayerLabel* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void ___lambda175__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                        BirdFontTool* selected,
                                                        guint button,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self);
static void bird_font_layer_label_set_moving_label (BirdFontLayerLabel* self,
                                             gint i);
static void __lambda172_ (BirdFontLayerLabel* self,
                   const gchar* text);
static void ___lambda172__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda173_ (BirdFontLayerLabel* self);
static void ___lambda173__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static gboolean __lambda170_ (BirdFontLayerLabel* self);
static gboolean ___lambda170__gsource_func (gpointer self);
static void bird_font_layer_label_real_draw_tool (BirdFontTool* base,
                                           cairo_t* cr,
                                           gdouble px,
                                           gdouble py);
static void bird_font_layer_label_finalize (GObject * obj);
static GType bird_font_layer_label_get_type_once (void);
static void _vala_bird_font_layer_label_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_bird_font_layer_label_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
bird_font_layer_label_get_instance_private (BirdFontLayerLabel* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLayerLabel_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		BirdFontLayerLabel* self;
		self = _data27_->self;
		_g_object_unref0 (_data27_->layer);
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static void
__lambda169_ (Block27Data* _data27_,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	BirdFontLayerLabel* self;
	gdouble _tmp0_;
	self = _data27_->self;
	g_return_if_fail (selected != NULL);
	_tmp0_ = ty;
	if ((((BirdFontTool*) self)->y <= _tmp0_) && (_tmp0_ <= (((BirdFontTool*) self)->y + ((BirdFontTool*) self)->h))) {
		if (tx >= (((BirdFontTool*) self)->w - (30 * bird_font_toolbox_get_scale ()))) {
			bird_font_drawing_tools_deselect_layers ();
			bird_font_layer_label_remove_layer (self);
		}
		if (tx < (25 * bird_font_toolbox_get_scale ())) {
			BirdFontFont* _tmp1_;
			BirdFontFont* _tmp2_;
			BirdFontGlyph* _tmp3_;
			BirdFontGlyph* _tmp4_;
			_data27_->layer->visible = !_data27_->layer->visible;
			bird_font_glyph_canvas_redraw ();
			_tmp1_ = bird_font_bird_font_get_current_font ();
			_tmp2_ = _tmp1_;
			bird_font_font_touch (_tmp2_);
			_g_object_unref0 (_tmp2_);
			_tmp3_ = bird_font_main_window_get_current_glyph ();
			_tmp4_ = _tmp3_;
			bird_font_glyph_clear_active_paths (_tmp4_);
			_g_object_unref0 (_tmp4_);
		} else {
			self->priv->active_layer = TRUE;
			bird_font_layer_label_select_layer (self);
		}
	} else {
		bird_font_layer_label_set_selected_layer (self, FALSE);
	}
}

static void
___lambda169__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 guint button,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
	__lambda169_ (self, selected, button, x, y);
}

static void
__lambda171_ (BirdFontLayerLabel* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	gdouble _tmp0_;
	g_return_if_fail (selected != NULL);
	_tmp0_ = ty;
	if ((((BirdFontTool*) self)->y <= _tmp0_) && (_tmp0_ <= (((BirdFontTool*) self)->y + ((BirdFontTool*) self)->h))) {
		gdouble _tmp1_;
		_tmp1_ = tx;
		if (((25 * bird_font_toolbox_get_scale ()) <= _tmp1_) && (_tmp1_ <= (((BirdFontTool*) self)->w - (30 * bird_font_toolbox_get_scale ())))) {
			bird_font_layer_label_set_layer_name (self);
		}
	}
}

static void
___lambda171__bird_font_tool_panel_double_click_action (BirdFontTool* _sender,
                                                        BirdFontTool* selected,
                                                        guint button,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self)
{
	__lambda171_ ((BirdFontLayerLabel*) self, selected, button, x, y);
}

static gboolean
__lambda174_ (BirdFontLayerLabel* self,
              BirdFontTool* selected,
              BirdFontTool* button,
              gdouble tx,
              gdouble ty)
{
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	if (self->priv->active_layer) {
		BirdFontToolbox* _tmp0_;
		BirdFontToolbox* _tmp1_;
		if (ty > ((BirdFontTool*) self)->y) {
			bird_font_layer_label_move_layer_down (self);
		} else {
			if (ty < (((BirdFontTool*) self)->y - ((BirdFontTool*) self)->h)) {
				bird_font_layer_label_move_layer_up (self);
			}
		}
		_tmp0_ = bird_font_main_window_get_toolbox ();
		_tmp1_ = _tmp0_;
		bird_font_toolbox_update_expanders (_tmp1_);
		_g_object_unref0 (_tmp1_);
		bird_font_tool_redraw ((BirdFontTool*) self);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda174__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	gboolean result;
	result = __lambda174_ ((BirdFontLayerLabel*) self, _sender, selected, x, y);
	return result;
}

static void
__lambda175_ (BirdFontLayerLabel* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	g_return_if_fail (selected != NULL);
	self->priv->active_layer = FALSE;
}

static void
___lambda175__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   guint button,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self)
{
	__lambda175_ ((BirdFontLayerLabel*) self, selected, button, x, y);
}

BirdFontLayerLabel*
bird_font_layer_label_construct (GType object_type,
                                 BirdFontLayer* layer)
{
	BirdFontLayerLabel * self = NULL;
	Block27Data* _data27_;
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (layer != NULL, NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (layer);
	_g_object_unref0 (_data27_->layer);
	_data27_->layer = _tmp0_;
	self = (BirdFontLayerLabel*) bird_font_tool_construct (object_type, NULL, "");
	_data27_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data27_->layer);
	_g_object_unref0 (self->layer);
	self->layer = _tmp1_;
	_tmp2_ = _data27_->layer->name;
	bird_font_layer_label_set_label (self, _tmp2_);
	bird_font_layer_label_set_selected_layer (self, FALSE);
	bird_font_layer_label_set_text (self);
	g_signal_connect_data ((BirdFontTool*) self, "panel-press-action", (GCallback) ___lambda169__bird_font_tool_panel_press_action, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-double-click-action", (GCallback) ___lambda171__bird_font_tool_panel_double_click_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-move-action", (GCallback) ___lambda174__bird_font_tool_panel_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-release-action", (GCallback) ___lambda175__bird_font_tool_panel_release_action, self, 0);
	block27_data_unref (_data27_);
	_data27_ = NULL;
	return self;
}

BirdFontLayerLabel*
bird_font_layer_label_new (BirdFontLayer* layer)
{
	return bird_font_layer_label_construct (BIRD_FONT_TYPE_LAYER_LABEL, layer);
}

static void
bird_font_layer_label_move_layer_up (BirdFontLayerLabel* self)
{
	gint i = 0;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontExpander* _tmp1_;
	BirdFontExpander* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = bird_font_drawing_tools_get_layer_tools ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->tool;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g;
	i = (_tmp5_ - _tmp6_->current_layer) - 1;
	_tmp7_ = g;
	bird_font_glyph_move_layer_up (_tmp7_);
	bird_font_drawing_tools_update_layers ();
	if (i < 0) {
		i = 0;
	}
	bird_font_layer_label_set_moving_label (self, i);
	_g_object_unref0 (g);
}

static void
bird_font_layer_label_move_layer_down (BirdFontLayerLabel* self)
{
	gint i = 0;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontExpander* _tmp1_;
	BirdFontExpander* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontExpander* _tmp8_;
	BirdFontExpander* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = bird_font_drawing_tools_get_layer_tools ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->tool;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g;
	i = (_tmp5_ - _tmp6_->current_layer) + 1;
	_tmp7_ = g;
	bird_font_glyph_move_layer_down (_tmp7_);
	bird_font_drawing_tools_update_layers ();
	_tmp8_ = bird_font_drawing_tools_get_layer_tools ();
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_->tool;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (i >= _tmp12_) {
		BirdFontExpander* _tmp13_;
		BirdFontExpander* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp13_ = bird_font_drawing_tools_get_layer_tools ();
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->tool;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		i = _tmp17_ - 1;
	}
	bird_font_layer_label_set_moving_label (self, i);
	_g_object_unref0 (g);
}

static void
bird_font_layer_label_set_moving_label (BirdFontLayerLabel* self,
                                        gint i)
{
	BirdFontLayerLabel* label = NULL;
	gint j = 0;
	g_return_if_fail (self != NULL);
	j = 0;
	{
		GeeArrayList* _layer_list = NULL;
		BirdFontExpander* _tmp0_;
		BirdFontExpander* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _layer_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _layer_index = 0;
		_tmp0_ = bird_font_drawing_tools_get_layer_tools ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_->tool;
		_layer_list = _tmp2_;
		_tmp3_ = _layer_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_layer_size = _tmp5_;
		_layer_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontTool* layer = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontTool* _tmp10_;
			BirdFontLayerLabel* _tmp11_;
			gint _tmp13_;
			_layer_index = _layer_index + 1;
			_tmp6_ = _layer_index;
			_tmp7_ = _layer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _layer_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _layer_index);
			layer = (BirdFontTool*) _tmp9_;
			_tmp10_ = layer;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_LAYER_LABEL, BirdFontLayerLabel));
			_g_object_unref0 (label);
			label = _tmp11_;
			if (i == j) {
				BirdFontLayerLabel* _tmp12_;
				_tmp12_ = label;
				_tmp12_->priv->active_layer = TRUE;
			}
			_tmp13_ = j;
			j = _tmp13_ + 1;
			_g_object_unref0 (layer);
		}
	}
	_g_object_unref0 (label);
}

static void
bird_font_layer_label_set_text (BirdFontLayerLabel* self)
{
	gdouble text_height = 0.0;
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	const gchar* _tmp2_;
	BirdFontText* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->label_text);
	self->priv->label_text = _tmp0_;
	_tmp1_ = self->priv->label_text;
	_tmp2_ = self->priv->_label;
	bird_font_text_set_text (_tmp1_, _tmp2_);
	text_height = 17 * bird_font_toolbox_get_scale ();
	_tmp3_ = self->priv->label_text;
	bird_font_text_set_font_size (_tmp3_, text_height);
}

static void
__lambda172_ (BirdFontLayerLabel* self,
              const gchar* text)
{
	BirdFontLayer* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (text != NULL);
	_tmp0_ = self->layer;
	_tmp1_ = g_strdup (text);
	_g_free0 (_tmp0_->name);
	_tmp0_->name = _tmp1_;
	bird_font_layer_label_set_label (self, text);
	bird_font_layer_label_set_text (self);
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda172__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda172_ ((BirdFontLayerLabel*) self, text);
}

static void
__lambda173_ (BirdFontLayerLabel* self)
{
	bird_font_tab_content_hide_text_input ();
}

static void
___lambda173__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda173_ ((BirdFontLayerLabel*) self);
}

static void
bird_font_layer_label_set_layer_name (BirdFontLayerLabel* self)
{
	BirdFontTextListener* listener = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontLayer* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontTextListener* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_t_ ("Layer");
	_tmp1_ = _tmp0_;
	_tmp2_ = self->layer;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = bird_font_t_ ("Set");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_text_listener_new (_tmp1_, _tmp3_, _tmp5_);
	_g_object_unref0 (listener);
	listener = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp1_);
	g_signal_connect_object (listener, "signal-text-input", (GCallback) ___lambda172__bird_font_text_listener_signal_text_input, self, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda173__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_layer_label_select_layer (BirdFontLayerLabel* self)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontLayer* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontGlyph* _tmp3_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp4_;
	gint index = 0;
	BirdFontLayer* _tmp5_;
	BirdFontFontSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = self->layer;
	bird_font_glyph_set_current_layer (glyph, _tmp1_);
	bird_font_drawing_tools_deselect_layers ();
	bird_font_layer_label_set_selected_layer (self, TRUE);
	_tmp2_ = bird_font_main_window_get_current_glyph ();
	_tmp3_ = _tmp2_;
	bird_font_glyph_clear_active_paths (_tmp3_);
	_g_object_unref0 (_tmp3_);
	bird_font_glyph_canvas_redraw ();
	_tmp4_ = bird_font_bird_font_get_current_font ();
	font = _tmp4_;
	_tmp5_ = self->layer;
	index = bird_font_glyph_get_layer_index (glyph, _tmp5_);
	_tmp6_ = font->settings;
	_tmp7_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) glyph);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat ("Active Layer ", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", index);
	_tmp13_ = _tmp12_;
	bird_font_font_settings_set_setting (_tmp6_, _tmp11_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_g_object_unref0 (font);
	_g_object_unref0 (glyph);
}

static gboolean
__lambda170_ (BirdFontLayerLabel* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontLayer* _tmp1_;
	BirdFontLayer* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontFont* _tmp4_;
	gboolean result;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_glyph_store_undo_state (g, FALSE);
	_tmp1_ = g->layers;
	_tmp2_ = self->layer;
	bird_font_layer_remove_layer (_tmp1_, _tmp2_);
	bird_font_drawing_tools_update_layers ();
	_tmp3_ = bird_font_bird_font_get_current_font ();
	_tmp4_ = _tmp3_;
	bird_font_font_touch (_tmp4_);
	_g_object_unref0 (_tmp4_);
	bird_font_glyph_clear_active_paths (g);
	bird_font_glyph_canvas_redraw ();
	result = FALSE;
	_g_object_unref0 (g);
	return result;
}

static gboolean
___lambda170__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda170_ ((BirdFontLayerLabel*) self);
	return result;
}

void
bird_font_layer_label_remove_layer (BirdFontLayerLabel* self)
{
	GSource* idle = NULL;
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_idle_source_new ();
	idle = _tmp0_;
	g_source_set_callback (idle, ___lambda170__gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (idle, NULL);
	_g_source_unref0 (idle);
}

static void
bird_font_layer_label_real_draw_tool (BirdFontTool* base,
                                      cairo_t* cr,
                                      gdouble px,
                                      gdouble py)
{
	BirdFontLayerLabel * self;
	BirdFontText* visibility_icon = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble text_width = 0.0;
	gdouble visibility_center_y = 0.0;
	gchar* visibility = NULL;
	gboolean _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	BirdFontText* _tmp3_;
	const gchar* _tmp4_ = NULL;
	BirdFontLayer* _tmp5_;
	gchar* _tmp6_;
	BirdFontText* _tmp7_;
	self = (BirdFontLayerLabel*) base;
	g_return_if_fail (cr != NULL);
	x = ((BirdFontTool*) self)->x - px;
	y = ((BirdFontTool*) self)->y - py;
	_tmp0_ = self->priv->_selected_layer;
	if (_tmp0_) {
		cairo_save (cr);
		bird_font_theme_color (cr, "Menu Background");
		cairo_rectangle (cr, (gdouble) 0, y - (2 * bird_font_toolbox_get_scale ()), ((BirdFontTool*) self)->w, ((BirdFontTool*) self)->h);
		cairo_fill (cr);
		cairo_restore (cr);
	}
	cairo_save (cr);
	text_width = (gdouble) bird_font_toolbox_allocation_width;
	text_width -= 30 * bird_font_toolbox_get_scale ();
	text_width -= 20 * bird_font_toolbox_get_scale ();
	_tmp1_ = self->priv->label_text;
	bird_font_text_truncate (_tmp1_, text_width);
	_tmp2_ = self->priv->label_text;
	bird_font_theme_text_color (_tmp2_, "Text Tool Box");
	_tmp3_ = self->priv->label_text;
	bird_font_text_draw_at_top (_tmp3_, cr, x + (20 * bird_font_toolbox_get_scale ()), y, "");
	_tmp5_ = self->layer;
	if (_tmp5_->visible) {
		_tmp4_ = "layer_visible";
	} else {
		_tmp4_ = "layer_hidden";
	}
	_tmp6_ = g_strdup (_tmp4_);
	_g_free0 (visibility);
	visibility = _tmp6_;
	_tmp7_ = bird_font_text_new (visibility, 30 * bird_font_toolbox_get_scale (), (gdouble) 0);
	_g_object_unref0 (visibility_icon);
	visibility_icon = _tmp7_;
	bird_font_text_load_font (visibility_icon, "icons.birdfont");
	bird_font_theme_text_color (visibility_icon, "Text Tool Box");
	visibility_center_y = y + (((BirdFontTool*) self)->h / 2.0);
	visibility_center_y -= bird_font_widget_get_height ((BirdFontWidget*) visibility_icon) / 2.0;
	visibility_center_y -= (gdouble) 2;
	bird_font_text_draw_at_top (visibility_icon, cr, x, visibility_center_y, "");
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color (cr, "Text Tool Box");
	cairo_set_line_width (cr, (gdouble) 1);
	cairo_move_to (cr, ((BirdFontTool*) self)->w - 20, ((y + (((BirdFontTool*) self)->h / 2)) - 2.5) - 2);
	cairo_line_to (cr, ((BirdFontTool*) self)->w - 25, ((y + (((BirdFontTool*) self)->h / 2)) + 2.5) - 2);
	cairo_move_to (cr, ((BirdFontTool*) self)->w - 20, ((y + (((BirdFontTool*) self)->h / 2)) + 2.5) - 2);
	cairo_line_to (cr, ((BirdFontTool*) self)->w - 25, ((y + (((BirdFontTool*) self)->h / 2)) - 2.5) - 2);
	cairo_stroke (cr);
	cairo_restore (cr);
	_g_free0 (visibility);
	_g_object_unref0 (visibility_icon);
}

gboolean
bird_font_layer_label_get_selected_layer (BirdFontLayerLabel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected_layer;
	return result;
}

void
bird_font_layer_label_set_selected_layer (BirdFontLayerLabel* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bird_font_layer_label_get_selected_layer (self);
	if (old_value != value) {
		self->priv->_selected_layer = value;
		g_object_notify_by_pspec ((GObject *) self, bird_font_layer_label_properties[BIRD_FONT_LAYER_LABEL_SELECTED_LAYER_PROPERTY]);
	}
}

const gchar*
bird_font_layer_label_get_label (BirdFontLayerLabel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
bird_font_layer_label_set_label (BirdFontLayerLabel* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = bird_font_layer_label_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bird_font_layer_label_properties[BIRD_FONT_LAYER_LABEL_LABEL_PROPERTY]);
	}
}

static void
bird_font_layer_label_class_init (BirdFontLayerLabelClass * klass,
                                  gpointer klass_data)
{
	bird_font_layer_label_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLayerLabel_private_offset);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_layer_label_real_draw_tool;
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_layer_label_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_layer_label_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_layer_label_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LAYER_LABEL_SELECTED_LAYER_PROPERTY, bird_font_layer_label_properties[BIRD_FONT_LAYER_LABEL_SELECTED_LAYER_PROPERTY] = g_param_spec_boolean ("selected-layer", "selected-layer", "selected-layer", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LAYER_LABEL_LABEL_PROPERTY, bird_font_layer_label_properties[BIRD_FONT_LAYER_LABEL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
bird_font_layer_label_instance_init (BirdFontLayerLabel * self,
                                     gpointer klass)
{
	self->priv = bird_font_layer_label_get_instance_private (self);
	self->priv->active_layer = FALSE;
}

static void
bird_font_layer_label_finalize (GObject * obj)
{
	BirdFontLayerLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LAYER_LABEL, BirdFontLayerLabel);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->layer);
	_g_object_unref0 (self->priv->label_text);
	G_OBJECT_CLASS (bird_font_layer_label_parent_class)->finalize (obj);
}

static GType
bird_font_layer_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLayerLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_layer_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLayerLabel), 0, (GInstanceInitFunc) bird_font_layer_label_instance_init, NULL };
	GType bird_font_layer_label_type_id;
	bird_font_layer_label_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontLayerLabel", &g_define_type_info, 0);
	BirdFontLayerLabel_private_offset = g_type_add_instance_private (bird_font_layer_label_type_id, sizeof (BirdFontLayerLabelPrivate));
	return bird_font_layer_label_type_id;
}

GType
bird_font_layer_label_get_type (void)
{
	static volatile gsize bird_font_layer_label_type_id__once = 0;
	if (g_once_init_enter (&bird_font_layer_label_type_id__once)) {
		GType bird_font_layer_label_type_id;
		bird_font_layer_label_type_id = bird_font_layer_label_get_type_once ();
		g_once_init_leave (&bird_font_layer_label_type_id__once, bird_font_layer_label_type_id);
	}
	return bird_font_layer_label_type_id__once;
}

static void
_vala_bird_font_layer_label_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BirdFontLayerLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_LAYER_LABEL, BirdFontLayerLabel);
	switch (property_id) {
		case BIRD_FONT_LAYER_LABEL_SELECTED_LAYER_PROPERTY:
		g_value_set_boolean (value, bird_font_layer_label_get_selected_layer (self));
		break;
		case BIRD_FONT_LAYER_LABEL_LABEL_PROPERTY:
		g_value_set_string (value, bird_font_layer_label_get_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_layer_label_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BirdFontLayerLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_LAYER_LABEL, BirdFontLayerLabel);
	switch (property_id) {
		case BIRD_FONT_LAYER_LABEL_SELECTED_LAYER_PROPERTY:
		bird_font_layer_label_set_selected_layer (self, g_value_get_boolean (value));
		break;
		case BIRD_FONT_LAYER_LABEL_LABEL_PROPERTY:
		bird_font_layer_label_set_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

