/* KerningClasses.c generated by valac 0.56.17, the Vala compiler
 * generated from KerningClasses.vala, do not modify */

/*
Copyright (C) 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERNING_CLASSES_0_PROPERTY,
	BIRD_FONT_KERNING_CLASSES_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_classes_properties[BIRD_FONT_KERNING_CLASSES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;

struct _BirdFontKerningClassesPrivate {
	GeeHashMap* single_kerning;
	gboolean protect_map;
};

struct _Block20Data {
	int _ref_count_;
	BirdFontKerningClasses* self;
	BirdFontKerningClassesKerningClassIterator iter;
	gpointer iter_target;
};

struct _Block21Data {
	int _ref_count_;
	BirdFontKerningClasses* self;
	gint i;
	gint index;
	gchar* left;
	gchar* right;
};

static gint BirdFontKerningClasses_private_offset;
static gpointer bird_font_kerning_classes_parent_class = NULL;

static void __lambda12_ (BirdFontKerningClasses* self);
static void ___lambda12__bird_font_font_font_deleted (BirdFontFont* _sender,
                                               gpointer self);
static gdouble* _double_dup (gdouble* self);
static GeeArrayList* bird_font_kerning_classes_get_spacing_class (BirdFontKerningClasses* self,
                                                           const gchar* c);
static gboolean bird_font_kerning_classes_set_protect_map (BirdFontKerningClasses* self,
                                                    gboolean p);
static void __lambda380_ (BirdFontKerningClasses* self,
                   BirdFontKerningPair* k);
static void ___lambda380__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                               gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda57_ (Block20Data* _data20_,
                  BirdFontKerningPair* kl);
static void ___lambda57__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                              gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void __lambda324_ (Block21Data* _data21_,
                   const gchar* l,
                   const gchar* r,
                   gdouble kerning);
static void ___lambda324__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                     const gchar* right,
                                                                     gdouble kerning,
                                                                     gpointer self);
static void bird_font_kerning_classes_delete_kerning_for_one_pair (BirdFontKerningClasses* self,
                                                            const gchar* left,
                                                            const gchar* right);
static void bird_font_kerning_classes_finalize (GObject * obj);
static GType bird_font_kerning_classes_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_kerning_classes_get_instance_private (BirdFontKerningClasses* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontKerningClasses_private_offset);
}

static void
__lambda12_ (BirdFontKerningClasses* self)
{
	BirdFontFont* _tmp0_;
	_tmp0_ = bird_font_font_empty;
	self->font = _tmp0_;
}

static void
___lambda12__bird_font_font_font_deleted (BirdFontFont* _sender,
                                          gpointer self)
{
	__lambda12_ ((BirdFontKerningClasses*) self);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

BirdFontKerningClasses*
bird_font_kerning_classes_construct (GType object_type,
                                     BirdFontFont* font)
{
	BirdFontKerningClasses * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeHashMap* _tmp5_;
	g_return_val_if_fail (font != NULL, NULL);
	self = (BirdFontKerningClasses*) g_object_new (object_type, NULL);
	self->font = font;
	g_signal_connect_object (font, "font-deleted", (GCallback) ___lambda12__bird_font_font_font_deleted, self, 0);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_RANGE, (GBoxedCopyFunc) bird_font_glyph_range_ref, (GDestroyNotify) bird_font_glyph_range_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->classes_first);
	self->classes_first = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_RANGE, (GBoxedCopyFunc) bird_font_glyph_range_ref, (GDestroyNotify) bird_font_glyph_range_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->classes_last);
	self->classes_last = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_KERNING, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->classes_kerning);
	self->classes_kerning = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->single_kerning_letters_left);
	self->single_kerning_letters_left = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->single_kerning_letters_right);
	self->single_kerning_letters_right = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->single_kerning);
	self->priv->single_kerning = _tmp5_;
	return self;
}

BirdFontKerningClasses*
bird_font_kerning_classes_new (BirdFontFont* font)
{
	return bird_font_kerning_classes_construct (BIRD_FONT_TYPE_KERNING_CLASSES, font);
}

void
bird_font_kerning_classes_update_range (BirdFontKerningClasses* self,
                                        BirdFontGlyphRange* old,
                                        BirdFontGlyphRange* new_range)
{
	gchar* o = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old != NULL);
	g_return_if_fail (new_range != NULL);
	_tmp0_ = bird_font_glyph_range_get_all_ranges (old);
	o = _tmp0_;
	{
		GeeArrayList* _gr_list = NULL;
		GeeArrayList* _tmp1_;
		gint _gr_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _gr_index = 0;
		_tmp1_ = self->classes_first;
		_gr_list = _tmp1_;
		_tmp2_ = _gr_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_gr_size = _tmp4_;
		_gr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontGlyphRange* gr = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_gr_index = _gr_index + 1;
			_tmp5_ = _gr_index;
			_tmp6_ = _gr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _gr_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _gr_index);
			gr = (BirdFontGlyphRange*) _tmp8_;
			{
				BirdFontGlyphRange* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				_tmp9_ = gr;
				_tmp10_ = bird_font_glyph_range_get_all_ranges (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = o;
				_tmp13_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
				_g_free0 (_tmp11_);
				if (_tmp13_) {
					BirdFontGlyphRange* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = gr;
					_tmp15_ = bird_font_glyph_range_get_all_ranges (new_range);
					_tmp16_ = _tmp15_;
					bird_font_glyph_range_parse_ranges (_tmp14_, _tmp16_, &_inner_error0_);
					_g_free0 (_tmp16_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_MARKUP_ERROR) {
							goto __catch0_g_markup_error;
						}
						_bird_font_glyph_range_unref0 (gr);
						_g_free0 (o);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			goto __finally0;
			__catch0_g_markup_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				const gchar* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				g_warning ("KerningClasses.vala:68: %s", _tmp18_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_bird_font_glyph_range_unref0 (gr);
				_g_free0 (o);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_bird_font_glyph_range_unref0 (gr);
		}
	}
	{
		GeeArrayList* _gr_list = NULL;
		GeeArrayList* _tmp19_;
		gint _gr_size = 0;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _gr_index = 0;
		_tmp19_ = self->classes_last;
		_gr_list = _tmp19_;
		_tmp20_ = _gr_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_gr_size = _tmp22_;
		_gr_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			BirdFontGlyphRange* gr = NULL;
			GeeArrayList* _tmp25_;
			gpointer _tmp26_;
			_gr_index = _gr_index + 1;
			_tmp23_ = _gr_index;
			_tmp24_ = _gr_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _gr_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _gr_index);
			gr = (BirdFontGlyphRange*) _tmp26_;
			{
				BirdFontGlyphRange* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp31_;
				_tmp27_ = gr;
				_tmp28_ = bird_font_glyph_range_get_all_ranges (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = o;
				_tmp31_ = g_strcmp0 (_tmp29_, _tmp30_) == 0;
				_g_free0 (_tmp29_);
				if (_tmp31_) {
					BirdFontGlyphRange* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp32_ = gr;
					_tmp33_ = bird_font_glyph_range_get_all_ranges (new_range);
					_tmp34_ = _tmp33_;
					bird_font_glyph_range_parse_ranges (_tmp32_, _tmp34_, &_inner_error0_);
					_g_free0 (_tmp34_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_MARKUP_ERROR) {
							goto __catch1_g_markup_error;
						}
						_bird_font_glyph_range_unref0 (gr);
						_g_free0 (o);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			goto __finally1;
			__catch1_g_markup_error:
			{
				GError* e = NULL;
				GError* _tmp35_;
				const gchar* _tmp36_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp35_ = e;
				_tmp36_ = _tmp35_->message;
				g_warning ("KerningClasses.vala:78: %s", _tmp36_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_bird_font_glyph_range_unref0 (gr);
				_g_free0 (o);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_bird_font_glyph_range_unref0 (gr);
		}
	}
	_g_free0 (o);
}

/** Copy kerning pairs for newly created spacing classes. */
void
bird_font_kerning_classes_copy_single_kerning_pairs (BirdFontKerningClasses* self,
                                                     const gchar* from_spacing_class,
                                                     const gchar* to_spacing_class)
{
	gdouble* kerning = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from_spacing_class != NULL);
	g_return_if_fail (to_spacing_class != NULL);
	{
		GeeArrayList* _left_list = NULL;
		GeeArrayList* _tmp0_;
		gint _left_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _left_index = 0;
		_tmp0_ = self->single_kerning_letters_left;
		_left_list = _tmp0_;
		_tmp1_ = _left_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_left_size = _tmp3_;
		_left_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* left = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			gdouble* _tmp9_;
			gdouble* _tmp10_;
			_left_index = _left_index + 1;
			_tmp4_ = _left_index;
			_tmp5_ = _left_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _left_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _left_index);
			left = (gchar*) _tmp7_;
			_tmp8_ = left;
			_tmp9_ = bird_font_kerning_classes_get_kerning_for_single_glyphs (self, _tmp8_, from_spacing_class);
			_g_free0 (kerning);
			kerning = _tmp9_;
			_tmp10_ = kerning;
			if (_tmp10_ != NULL) {
				const gchar* _tmp11_;
				gdouble* _tmp12_;
				_tmp11_ = left;
				_tmp12_ = kerning;
				bird_font_kerning_classes_set_kerning_for_single_glyphs (self, _tmp11_, to_spacing_class, (gdouble) (*_tmp12_));
			}
			_g_free0 (left);
		}
	}
	{
		GeeArrayList* _right_list = NULL;
		GeeArrayList* _tmp13_;
		gint _right_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _right_index = 0;
		_tmp13_ = self->single_kerning_letters_right;
		_right_list = _tmp13_;
		_tmp14_ = _right_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_right_size = _tmp16_;
		_right_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gchar* right = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			const gchar* _tmp21_;
			gdouble* _tmp22_;
			gdouble* _tmp23_;
			_right_index = _right_index + 1;
			_tmp17_ = _right_index;
			_tmp18_ = _right_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _right_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _right_index);
			right = (gchar*) _tmp20_;
			_tmp21_ = right;
			_tmp22_ = bird_font_kerning_classes_get_kerning_for_single_glyphs (self, from_spacing_class, _tmp21_);
			_g_free0 (kerning);
			kerning = _tmp22_;
			_tmp23_ = kerning;
			if (_tmp23_ != NULL) {
				const gchar* _tmp24_;
				gdouble* _tmp25_;
				_tmp24_ = right;
				_tmp25_ = kerning;
				bird_font_kerning_classes_set_kerning_for_single_glyphs (self, to_spacing_class, _tmp24_, (gdouble) (*_tmp25_));
			}
			_g_free0 (right);
		}
	}
	_g_free0 (kerning);
}

/** Class based gpos kerning. */
static gpointer
_bird_font_glyph_range_ref0 (gpointer self)
{
	return self ? bird_font_glyph_range_ref (self) : NULL;
}

gdouble
bird_font_kerning_classes_get_kerning_for_pair (BirdFontKerningClasses* self,
                                                const gchar* a,
                                                const gchar* b,
                                                BirdFontGlyphRange* gr_left,
                                                BirdFontGlyphRange* gr_right)
{
	gdouble k = 0.0;
	BirdFontGlyphRange* grl = NULL;
	BirdFontGlyphRange* grr = NULL;
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	k = (gdouble) 0;
	{
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp14_ = FALSE;
		if (gr_left == NULL) {
			BirdFontGlyphRange* _tmp0_;
			BirdFontGlyphRange* _tmp1_;
			_tmp0_ = bird_font_glyph_range_new ();
			_bird_font_glyph_range_unref0 (grl);
			grl = _tmp0_;
			_tmp1_ = grl;
			bird_font_glyph_range_parse_ranges (_tmp1_, a, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gdouble _tmp2_ = -1.0;
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				_bird_font_glyph_range_unref0 (grr);
				_bird_font_glyph_range_unref0 (grl);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp2_;
			}
		} else {
			BirdFontGlyphRange* _tmp3_;
			_tmp3_ = _bird_font_glyph_range_ref0 (G_TYPE_CHECK_INSTANCE_CAST (gr_left, BIRD_FONT_TYPE_GLYPH_RANGE, BirdFontGlyphRange));
			_bird_font_glyph_range_unref0 (grl);
			grl = _tmp3_;
		}
		if (gr_right == NULL) {
			BirdFontGlyphRange* _tmp4_;
			BirdFontGlyphRange* _tmp5_;
			_tmp4_ = bird_font_glyph_range_new ();
			_bird_font_glyph_range_unref0 (grr);
			grr = _tmp4_;
			_tmp5_ = grr;
			bird_font_glyph_range_parse_ranges (_tmp5_, a, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gdouble _tmp6_ = -1.0;
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				_bird_font_glyph_range_unref0 (grr);
				_bird_font_glyph_range_unref0 (grl);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp6_;
			}
		} else {
			BirdFontGlyphRange* _tmp7_;
			_tmp7_ = _bird_font_glyph_range_ref0 (G_TYPE_CHECK_INSTANCE_CAST (gr_right, BIRD_FONT_TYPE_GLYPH_RANGE, BirdFontGlyphRange));
			_bird_font_glyph_range_unref0 (grr);
			grr = _tmp7_;
		}
		if (gr_left == NULL) {
			_tmp8_ = gr_right == NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			k = bird_font_kerning_classes_get_kerning (self, a, b);
			result = k;
			_bird_font_glyph_range_unref0 (grr);
			_bird_font_glyph_range_unref0 (grl);
			return result;
		}
		if (gr_left != NULL) {
			_tmp9_ = gr_right != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			BirdFontGlyphRange* _tmp10_;
			BirdFontGlyphRange* _tmp11_;
			_tmp10_ = grl;
			_tmp11_ = grr;
			result = bird_font_kerning_classes_get_kerning_for_range (self, _tmp10_, _tmp11_);
			_bird_font_glyph_range_unref0 (grr);
			_bird_font_glyph_range_unref0 (grl);
			return result;
		}
		if (gr_left != NULL) {
			_tmp12_ = gr_right == NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			BirdFontGlyphRange* _tmp13_;
			_tmp13_ = grl;
			result = bird_font_kerning_classes_get_kern_for_range_to_char (self, _tmp13_, b);
			_bird_font_glyph_range_unref0 (grr);
			_bird_font_glyph_range_unref0 (grl);
			return result;
		}
		if (gr_left == NULL) {
			_tmp14_ = gr_right != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			BirdFontGlyphRange* _tmp15_;
			_tmp15_ = grr;
			result = bird_font_kerning_classes_get_kern_for_char_to_range (self, a, _tmp15_);
			_bird_font_glyph_range_unref0 (grr);
			_bird_font_glyph_range_unref0 (grl);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("KerningClasses.vala:141: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gdouble _tmp18_ = -1.0;
		_bird_font_glyph_range_unref0 (grr);
		_bird_font_glyph_range_unref0 (grl);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	if (G_UNLIKELY (k == ((gdouble) 0))) {
		g_warning ("KerningClasses.vala:145: no kerning found");
	}
	result = (gdouble) 0;
	_bird_font_glyph_range_unref0 (grr);
	_bird_font_glyph_range_unref0 (grl);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

gdouble*
bird_font_kerning_classes_get_kerning_for_single_glyphs (BirdFontKerningClasses* self,
                                                         const gchar* first,
                                                         const gchar* next)
{
	gdouble* k = NULL;
	gdouble* kerning = NULL;
	gchar* left = NULL;
	gchar* _tmp0_;
	gchar* right = NULL;
	gchar* _tmp1_;
	gdouble* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (first != NULL, NULL);
	g_return_val_if_fail (next != NULL, NULL);
	k = NULL;
	kerning = NULL;
	_tmp0_ = bird_font_glyph_range_serialize (first);
	left = _tmp0_;
	_tmp1_ = bird_font_glyph_range_serialize (next);
	right = _tmp1_;
	{
		GeeArrayList* _l_list = NULL;
		const gchar* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _l_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _l_index = 0;
		_tmp2_ = left;
		_tmp3_ = bird_font_kerning_classes_get_spacing_class (self, _tmp2_);
		_l_list = _tmp3_;
		_tmp4_ = _l_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_l_size = _tmp6_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* l = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			_l_index = _l_index + 1;
			_tmp7_ = _l_index;
			_tmp8_ = _l_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _l_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _l_index);
			l = (gchar*) _tmp10_;
			{
				GeeArrayList* _r_list = NULL;
				const gchar* _tmp11_;
				GeeArrayList* _tmp12_;
				gint _r_size = 0;
				GeeArrayList* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _r_index = 0;
				_tmp11_ = right;
				_tmp12_ = bird_font_kerning_classes_get_spacing_class (self, _tmp11_);
				_r_list = _tmp12_;
				_tmp13_ = _r_list;
				_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
				_tmp15_ = _tmp14_;
				_r_size = _tmp15_;
				_r_index = -1;
				while (TRUE) {
					gint _tmp16_;
					gint _tmp17_;
					gchar* r = NULL;
					GeeArrayList* _tmp18_;
					gpointer _tmp19_;
					GeeHashMap* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gpointer _tmp27_;
					gdouble* _tmp28_;
					_r_index = _r_index + 1;
					_tmp16_ = _r_index;
					_tmp17_ = _r_size;
					if (!(_tmp16_ < _tmp17_)) {
						break;
					}
					_tmp18_ = _r_list;
					_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _r_index);
					r = (gchar*) _tmp19_;
					_tmp20_ = self->priv->single_kerning;
					_tmp21_ = l;
					_tmp22_ = string_to_string (_tmp21_);
					_tmp23_ = r;
					_tmp24_ = string_to_string (_tmp23_);
					_tmp25_ = g_strconcat (_tmp22_, " - ", _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp26_);
					_g_free0 (kerning);
					kerning = (gdouble*) _tmp27_;
					_g_free0 (_tmp26_);
					_tmp28_ = kerning;
					if (_tmp28_ != NULL) {
						gdouble* _tmp29_;
						gdouble* _tmp30_;
						_tmp29_ = kerning;
						_tmp30_ = __double_dup0 (_tmp29_);
						_g_free0 (k);
						k = _tmp30_;
					}
					_g_free0 (r);
				}
				_g_object_unref0 (_r_list);
			}
			_g_free0 (l);
		}
		_g_object_unref0 (_l_list);
	}
	result = k;
	_g_free0 (right);
	_g_free0 (left);
	_g_free0 (kerning);
	return result;
}

static GeeArrayList*
bird_font_kerning_classes_get_spacing_class (BirdFontKerningClasses* self,
                                             const gchar* c)
{
	BirdFontFont* _tmp0_;
	BirdFontSpacingData* _tmp1_;
	BirdFontSpacingData* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	_tmp0_ = self->font;
	_tmp1_ = bird_font_font_get_spacing (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_spacing_data_get_all_connections (_tmp2_, c);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

void
bird_font_kerning_classes_set_kerning_for_single_glyphs (BirdFontKerningClasses* self,
                                                         const gchar* le,
                                                         const gchar* ri,
                                                         gdouble k)
{
	gchar* left = NULL;
	gchar* _tmp0_;
	gchar* right = NULL;
	gchar* _tmp1_;
	gchar* cleft = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* cright = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (le != NULL);
	g_return_if_fail (ri != NULL);
	_tmp0_ = bird_font_glyph_range_serialize (le);
	left = _tmp0_;
	_tmp1_ = bird_font_glyph_range_serialize (ri);
	right = _tmp1_;
	_tmp2_ = left;
	_tmp3_ = bird_font_glyph_range_unserialize (_tmp2_);
	cleft = (gchar*) _tmp3_;
	_tmp4_ = right;
	_tmp5_ = bird_font_glyph_range_unserialize (_tmp4_);
	cright = (gchar*) _tmp5_;
	if (self->priv->protect_map) {
		g_warning ("KerningClasses.vala:181: Map is protected.");
		_g_free0 (cright);
		_g_free0 (cleft);
		_g_free0 (right);
		_g_free0 (left);
		return;
	}
	{
		GeeArrayList* _l_list = NULL;
		const gchar* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _l_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _l_index = 0;
		_tmp6_ = cleft;
		_tmp7_ = bird_font_kerning_classes_get_spacing_class (self, _tmp6_);
		_l_list = _tmp7_;
		_tmp8_ = _l_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_l_size = _tmp10_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gchar* l = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			_l_index = _l_index + 1;
			_tmp11_ = _l_index;
			_tmp12_ = _l_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _l_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _l_index);
			l = (gchar*) _tmp14_;
			{
				GeeArrayList* _r_list = NULL;
				const gchar* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _r_size = 0;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _r_index = 0;
				_tmp15_ = cright;
				_tmp16_ = bird_font_kerning_classes_get_spacing_class (self, _tmp15_);
				_r_list = _tmp16_;
				_tmp17_ = _r_list;
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_r_size = _tmp19_;
				_r_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					gchar* r = NULL;
					GeeArrayList* _tmp22_;
					gpointer _tmp23_;
					GeeArrayList* _tmp24_;
					const gchar* _tmp25_;
					GeeArrayList* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					GeeHashMap* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_r_index = _r_index + 1;
					_tmp20_ = _r_index;
					_tmp21_ = _r_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _r_list;
					_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _r_index);
					r = (gchar*) _tmp23_;
					_tmp24_ = self->single_kerning_letters_left;
					_tmp25_ = cleft;
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp24_, _tmp25_)) {
						GeeArrayList* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = self->single_kerning_letters_left;
						_tmp27_ = cleft;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
					}
					_tmp28_ = self->single_kerning_letters_right;
					_tmp29_ = cright;
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp28_, _tmp29_)) {
						GeeArrayList* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = self->single_kerning_letters_right;
						_tmp31_ = cright;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
					}
					_tmp32_ = l;
					_tmp33_ = bird_font_glyph_range_serialize (_tmp32_);
					_g_free0 (left);
					left = _tmp33_;
					_tmp34_ = r;
					_tmp35_ = bird_font_glyph_range_serialize (_tmp34_);
					_g_free0 (right);
					right = _tmp35_;
					_tmp36_ = self->priv->single_kerning;
					_tmp37_ = left;
					_tmp38_ = string_to_string (_tmp37_);
					_tmp39_ = right;
					_tmp40_ = string_to_string (_tmp39_);
					_tmp41_ = g_strconcat (_tmp38_, " - ", _tmp40_, NULL);
					_tmp42_ = _tmp41_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp42_, &k);
					_g_free0 (_tmp42_);
					_g_free0 (r);
				}
				_g_object_unref0 (_r_list);
			}
			_g_free0 (l);
		}
		_g_object_unref0 (_l_list);
	}
	_g_free0 (cright);
	_g_free0 (cleft);
	_g_free0 (right);
	_g_free0 (left);
}

void
bird_font_kerning_classes_set_kerning (BirdFontKerningClasses* self,
                                       BirdFontGlyphRange* left_range,
                                       BirdFontGlyphRange* right_range,
                                       gdouble k,
                                       gint class_index)
{
	gint index = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (left_range != NULL);
	g_return_if_fail (right_range != NULL);
	if (bird_font_glyph_range_get_length (left_range) == ((guint32) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = bird_font_glyph_range_get_length (right_range) == ((guint32) 0);
	}
	if (_tmp0_) {
		g_warning ("KerningClasses.vala:206: no glyphs");
		return;
	}
	if (self->priv->protect_map) {
		g_warning ("KerningClasses.vala:211: Map is protected.");
		return;
	}
	if (!bird_font_glyph_range_is_class (left_range)) {
		_tmp1_ = !bird_font_glyph_range_is_class (right_range);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = bird_font_glyph_range_get_all_ranges (left_range);
		_tmp3_ = _tmp2_;
		_tmp4_ = bird_font_glyph_range_get_all_ranges (right_range);
		_tmp5_ = _tmp4_;
		bird_font_kerning_classes_set_kerning_for_single_glyphs (self, _tmp3_, _tmp5_, k);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		return;
	}
	index = bird_font_kerning_classes_get_kerning_item_index (self, left_range, right_range);
	if (index == -1) {
		if (class_index < 0) {
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			GeeArrayList* _tmp8_;
			BirdFontKerning* _tmp9_;
			BirdFontKerning* _tmp10_;
			_tmp6_ = self->classes_first;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, left_range);
			_tmp7_ = self->classes_last;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, right_range);
			_tmp8_ = self->classes_kerning;
			_tmp9_ = bird_font_kerning_new (k);
			_tmp10_ = _tmp9_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
			_g_object_unref0 (_tmp10_);
		} else {
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* _tmp13_;
			BirdFontKerning* _tmp14_;
			BirdFontKerning* _tmp15_;
			_tmp11_ = self->classes_first;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp11_, class_index, left_range);
			_tmp12_ = self->classes_last;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp12_, class_index, right_range);
			_tmp13_ = self->classes_kerning;
			_tmp14_ = bird_font_kerning_new (k);
			_tmp15_ = _tmp14_;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp13_, class_index, _tmp15_);
			_g_object_unref0 (_tmp15_);
		}
	} else {
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GeeArrayList* _tmp20_;
		gpointer _tmp21_;
		BirdFontKerning* _tmp22_;
		_tmp16_ = self->classes_first;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = index;
		g_return_if_fail ((0 <= _tmp19_) && (_tmp19_ < _tmp18_));
		_tmp20_ = self->classes_kerning;
		_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, index);
		_tmp22_ = (BirdFontKerning*) _tmp21_;
		_tmp22_->val = k;
		_g_object_unref0 (_tmp22_);
	}
}

gboolean
bird_font_kerning_classes_has_kerning (BirdFontKerningClasses* self,
                                       const gchar* first,
                                       const gchar* next)
{
	gchar* f = NULL;
	gchar* _tmp0_;
	gchar* n = NULL;
	gchar* _tmp1_;
	BirdFontGlyphRange* gr = NULL;
	BirdFontGlyphRange* gl = NULL;
	gint len = 0;
	GeeArrayList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GeeArrayList* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GeeArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (first != NULL, FALSE);
	g_return_val_if_fail (next != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	f = _tmp0_;
	_tmp1_ = g_strdup ("");
	n = _tmp1_;
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp2_;
		gint _l_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _l_index = 0;
		_tmp2_ = bird_font_kerning_classes_get_spacing_class (self, first);
		_l_list = _tmp2_;
		_tmp3_ = _l_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_l_size = _tmp5_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* l = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			_l_index = _l_index + 1;
			_tmp6_ = _l_index;
			_tmp7_ = _l_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _l_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _l_index);
			l = (gchar*) _tmp9_;
			{
				GeeArrayList* _r_list = NULL;
				GeeArrayList* _tmp10_;
				gint _r_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _r_index = 0;
				_tmp10_ = bird_font_kerning_classes_get_spacing_class (self, next);
				_r_list = _tmp10_;
				_tmp11_ = _r_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_r_size = _tmp13_;
				_r_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					gchar* r = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					GeeHashMap* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gboolean _tmp29_;
					_r_index = _r_index + 1;
					_tmp14_ = _r_index;
					_tmp15_ = _r_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _r_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _r_index);
					r = (gchar*) _tmp17_;
					_tmp18_ = l;
					_tmp19_ = bird_font_glyph_range_serialize (_tmp18_);
					_g_free0 (f);
					f = _tmp19_;
					_tmp20_ = r;
					_tmp21_ = bird_font_glyph_range_serialize (_tmp20_);
					_g_free0 (n);
					n = _tmp21_;
					_tmp22_ = self->priv->single_kerning;
					_tmp23_ = f;
					_tmp24_ = string_to_string (_tmp23_);
					_tmp25_ = n;
					_tmp26_ = string_to_string (_tmp25_);
					_tmp27_ = g_strconcat (_tmp24_, " - ", _tmp26_, NULL);
					_tmp28_ = _tmp27_;
					_tmp29_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp22_, _tmp28_);
					_g_free0 (_tmp28_);
					if (_tmp29_) {
						result = TRUE;
						_g_free0 (r);
						_g_object_unref0 (_r_list);
						_g_free0 (l);
						_g_object_unref0 (_l_list);
						_bird_font_glyph_range_unref0 (gl);
						_bird_font_glyph_range_unref0 (gr);
						_g_free0 (n);
						_g_free0 (f);
						return result;
					}
					_g_free0 (r);
				}
				_g_object_unref0 (_r_list);
			}
			_g_free0 (l);
		}
		_g_object_unref0 (_l_list);
	}
	_tmp30_ = self->classes_first;
	_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	len = (gint) _tmp32_;
	_tmp33_ = self->classes_last;
	_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
	_tmp35_ = _tmp34_;
	g_return_val_if_fail (len == _tmp35_, FALSE);
	_tmp36_ = self->classes_kerning;
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	g_return_val_if_fail (len == _tmp38_, FALSE);
	{
		gint i = 0;
		i = len - 1;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp41_;
				gpointer _tmp42_;
				GeeArrayList* _tmp43_;
				gpointer _tmp44_;
				gboolean _tmp45_ = FALSE;
				BirdFontGlyphRange* _tmp46_;
				if (!_tmp39_) {
					gint _tmp40_;
					_tmp40_ = i;
					i = _tmp40_ - 1;
				}
				_tmp39_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp41_ = self->classes_first;
				_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, i);
				_bird_font_glyph_range_unref0 (gl);
				gl = (BirdFontGlyphRange*) _tmp42_;
				_tmp43_ = self->classes_last;
				_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, i);
				_bird_font_glyph_range_unref0 (gr);
				gr = (BirdFontGlyphRange*) _tmp44_;
				_tmp46_ = gl;
				if (bird_font_glyph_range_has_character (_tmp46_, first)) {
					BirdFontGlyphRange* _tmp47_;
					_tmp47_ = gr;
					_tmp45_ = bird_font_glyph_range_has_character (_tmp47_, next);
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					result = TRUE;
					_bird_font_glyph_range_unref0 (gl);
					_bird_font_glyph_range_unref0 (gr);
					_g_free0 (n);
					_g_free0 (f);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_bird_font_glyph_range_unref0 (gl);
	_bird_font_glyph_range_unref0 (gr);
	_g_free0 (n);
	_g_free0 (f);
	return result;
}

gdouble
bird_font_kerning_classes_get_kerning_for_range (BirdFontKerningClasses* self,
                                                 BirdFontGlyphRange* range_first,
                                                 BirdFontGlyphRange* range_last)
{
	BirdFontGlyphRange* r = NULL;
	BirdFontGlyphRange* l = NULL;
	gint len = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (range_first != NULL, 0.0);
	g_return_val_if_fail (range_last != NULL, 0.0);
	_tmp0_ = self->classes_first;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	len = (gint) _tmp2_;
	_tmp3_ = self->classes_first;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	len = (gint) _tmp5_;
	_tmp6_ = self->classes_last;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_return_val_if_fail (len == _tmp8_, 0);
	_tmp9_ = self->classes_kerning;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_return_val_if_fail (len == _tmp11_, 0);
	if (bird_font_glyph_range_is_class (range_first)) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = bird_font_glyph_range_is_class (range_last);
	}
	if (!_tmp12_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gdouble* _tmp17_;
		gdouble* _tmp18_;
		_tmp13_ = bird_font_glyph_range_get_all_ranges (range_first);
		_tmp14_ = _tmp13_;
		_tmp15_ = bird_font_glyph_range_get_all_ranges (range_last);
		_tmp16_ = _tmp15_;
		_tmp17_ = bird_font_kerning_classes_get_kerning_for_single_glyphs (self, _tmp14_, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		result = (gdouble) 0;
		_bird_font_glyph_range_unref0 (l);
		_bird_font_glyph_range_unref0 (r);
		return result;
	}
	{
		gint i = 0;
		i = len - 1;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp21_;
				gpointer _tmp22_;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				gboolean _tmp25_ = FALSE;
				BirdFontGlyphRange* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gboolean _tmp31_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ - 1;
				}
				_tmp19_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp21_ = self->classes_first;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, i);
				_bird_font_glyph_range_unref0 (l);
				l = (BirdFontGlyphRange*) _tmp22_;
				_tmp23_ = self->classes_last;
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, i);
				_bird_font_glyph_range_unref0 (r);
				r = (BirdFontGlyphRange*) _tmp24_;
				_tmp26_ = l;
				_tmp27_ = bird_font_glyph_range_get_all_ranges (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = bird_font_glyph_range_get_all_ranges (range_first);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strcmp0 (_tmp28_, _tmp30_) == 0;
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				if (_tmp31_) {
					BirdFontGlyphRange* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp32_ = r;
					_tmp33_ = bird_font_glyph_range_get_all_ranges (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = bird_font_glyph_range_get_all_ranges (range_last);
					_tmp36_ = _tmp35_;
					_tmp25_ = g_strcmp0 (_tmp34_, _tmp36_) == 0;
					_g_free0 (_tmp36_);
					_g_free0 (_tmp34_);
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					GeeArrayList* _tmp37_;
					gpointer _tmp38_;
					BirdFontKerning* _tmp39_;
					gdouble _tmp40_;
					_tmp37_ = self->classes_kerning;
					_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, i);
					_tmp39_ = (BirdFontKerning*) _tmp38_;
					_tmp40_ = _tmp39_->val;
					_g_object_unref0 (_tmp39_);
					result = _tmp40_;
					_bird_font_glyph_range_unref0 (l);
					_bird_font_glyph_range_unref0 (r);
					return result;
				}
			}
		}
	}
	result = (gdouble) 0;
	_bird_font_glyph_range_unref0 (l);
	_bird_font_glyph_range_unref0 (r);
	return result;
}

gint
bird_font_kerning_classes_get_kerning_item_index (BirdFontKerningClasses* self,
                                                  BirdFontGlyphRange* range_first,
                                                  BirdFontGlyphRange* range_last)
{
	BirdFontGlyphRange* r = NULL;
	BirdFontGlyphRange* l = NULL;
	gint len = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (range_first != NULL, 0);
	g_return_val_if_fail (range_last != NULL, 0);
	_tmp0_ = self->classes_first;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	len = (gint) _tmp2_;
	_tmp3_ = self->classes_first;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	len = (gint) _tmp5_;
	_tmp6_ = self->classes_last;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_return_val_if_fail (len == _tmp8_, 0);
	_tmp9_ = self->classes_kerning;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_return_val_if_fail (len == _tmp11_, 0);
	if (bird_font_glyph_range_is_class (range_first)) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = bird_font_glyph_range_is_class (range_last);
	}
	if (!_tmp12_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp13_ = bird_font_glyph_range_get_all_ranges (range_first);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = bird_font_glyph_range_get_all_ranges (range_last);
		_tmp17_ = _tmp16_;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("Expecting a class, ", _tmp15_, " and ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		g_warning ("KerningClasses.vala:312: %s", _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		result = -1;
		_bird_font_glyph_range_unref0 (l);
		_bird_font_glyph_range_unref0 (r);
		return result;
	}
	{
		gint i = 0;
		i = len - 1;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				GeeArrayList* _tmp25_;
				gpointer _tmp26_;
				gboolean _tmp27_ = FALSE;
				BirdFontGlyphRange* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ - 1;
				}
				_tmp21_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp23_ = self->classes_first;
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, i);
				_bird_font_glyph_range_unref0 (l);
				l = (BirdFontGlyphRange*) _tmp24_;
				_tmp25_ = self->classes_last;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, i);
				_bird_font_glyph_range_unref0 (r);
				r = (BirdFontGlyphRange*) _tmp26_;
				_tmp28_ = l;
				_tmp29_ = bird_font_glyph_range_get_all_ranges (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = bird_font_glyph_range_get_all_ranges (range_first);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strcmp0 (_tmp30_, _tmp32_) == 0;
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				if (_tmp33_) {
					BirdFontGlyphRange* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp34_ = r;
					_tmp35_ = bird_font_glyph_range_get_all_ranges (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = bird_font_glyph_range_get_all_ranges (range_last);
					_tmp38_ = _tmp37_;
					_tmp27_ = g_strcmp0 (_tmp36_, _tmp38_) == 0;
					_g_free0 (_tmp38_);
					_g_free0 (_tmp36_);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					result = i;
					_bird_font_glyph_range_unref0 (l);
					_bird_font_glyph_range_unref0 (r);
					return result;
				}
			}
		}
	}
	result = -1;
	_bird_font_glyph_range_unref0 (l);
	_bird_font_glyph_range_unref0 (r);
	return result;
}

gdouble
bird_font_kerning_classes_get_kerning (BirdFontKerningClasses* self,
                                       const gchar* left_glyph,
                                       const gchar* right_glyph)
{
	BirdFontGlyphRange* r = NULL;
	BirdFontGlyphRange* l = NULL;
	gint len = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble* d = NULL;
	gdouble* _tmp3_;
	gdouble* _tmp4_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (left_glyph != NULL, 0.0);
	g_return_val_if_fail (right_glyph != NULL, 0.0);
	_tmp0_ = self->classes_first;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	len = (gint) _tmp2_;
	_tmp3_ = bird_font_kerning_classes_get_kerning_for_single_glyphs (self, left_glyph, right_glyph);
	_g_free0 (d);
	d = _tmp3_;
	_tmp4_ = d;
	if (_tmp4_ != NULL) {
		gdouble* _tmp5_;
		_tmp5_ = d;
		result = (gdouble) (*_tmp5_);
		_g_free0 (d);
		_bird_font_glyph_range_unref0 (l);
		_bird_font_glyph_range_unref0 (r);
		return result;
	}
	_tmp6_ = self->classes_first;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	len = (gint) _tmp8_;
	_tmp9_ = self->classes_last;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_return_val_if_fail (len == _tmp11_, 0);
	_tmp12_ = self->classes_kerning;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_return_val_if_fail (len == _tmp14_, 0);
	{
		gint i = 0;
		i = len - 1;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp17_;
				gpointer _tmp18_;
				GeeArrayList* _tmp19_;
				gpointer _tmp20_;
				gboolean _tmp21_ = FALSE;
				BirdFontGlyphRange* _tmp22_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ - 1;
				}
				_tmp15_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp17_ = self->classes_first;
				_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, i);
				_bird_font_glyph_range_unref0 (l);
				l = (BirdFontGlyphRange*) _tmp18_;
				_tmp19_ = self->classes_last;
				_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, i);
				_bird_font_glyph_range_unref0 (r);
				r = (BirdFontGlyphRange*) _tmp20_;
				_tmp22_ = l;
				if (bird_font_glyph_range_has_character (_tmp22_, left_glyph)) {
					BirdFontGlyphRange* _tmp23_;
					_tmp23_ = r;
					_tmp21_ = bird_font_glyph_range_has_character (_tmp23_, right_glyph);
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					GeeArrayList* _tmp24_;
					gpointer _tmp25_;
					BirdFontKerning* _tmp26_;
					gdouble _tmp27_;
					_tmp24_ = self->classes_kerning;
					_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
					_tmp26_ = (BirdFontKerning*) _tmp25_;
					_tmp27_ = _tmp26_->val;
					_g_object_unref0 (_tmp26_);
					result = _tmp27_;
					_g_free0 (d);
					_bird_font_glyph_range_unref0 (l);
					_bird_font_glyph_range_unref0 (r);
					return result;
				}
			}
		}
	}
	result = (gdouble) 0;
	_g_free0 (d);
	_bird_font_glyph_range_unref0 (l);
	_bird_font_glyph_range_unref0 (r);
	return result;
}

gdouble
bird_font_kerning_classes_get_kern_for_range_to_char (BirdFontKerningClasses* self,
                                                      BirdFontGlyphRange* left_range,
                                                      const gchar* right_char)
{
	BirdFontGlyphRange* r = NULL;
	BirdFontGlyphRange* l = NULL;
	gint len = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (left_range != NULL, 0.0);
	g_return_val_if_fail (right_char != NULL, 0.0);
	_tmp0_ = self->classes_first;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	len = (gint) _tmp2_;
	_tmp3_ = self->classes_first;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	len = (gint) _tmp5_;
	_tmp6_ = self->classes_last;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_return_val_if_fail (len == _tmp8_, 0);
	_tmp9_ = self->classes_kerning;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_return_val_if_fail (len == _tmp11_, 0);
	if (G_UNLIKELY (!bird_font_glyph_range_is_class (left_range))) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = bird_font_glyph_range_get_all_ranges (left_range);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("Expecting a class, ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		g_warning ("KerningClasses.vala:368: %s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp13_);
		result = (gdouble) -1;
		_bird_font_glyph_range_unref0 (l);
		_bird_font_glyph_range_unref0 (r);
		return result;
	}
	{
		GeeArrayList* _right_list = NULL;
		GeeArrayList* _tmp17_;
		gint _right_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _right_index = 0;
		_tmp17_ = bird_font_kerning_classes_get_spacing_class (self, right_char);
		_right_list = _tmp17_;
		_tmp18_ = _right_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_right_size = _tmp20_;
		_right_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gchar* right = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			_right_index = _right_index + 1;
			_tmp21_ = _right_index;
			_tmp22_ = _right_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _right_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _right_index);
			right = (gchar*) _tmp24_;
			{
				gint i = 0;
				i = len - 1;
				{
					gboolean _tmp25_ = FALSE;
					_tmp25_ = TRUE;
					while (TRUE) {
						GeeArrayList* _tmp27_;
						gpointer _tmp28_;
						GeeArrayList* _tmp29_;
						gpointer _tmp30_;
						gboolean _tmp31_ = FALSE;
						BirdFontGlyphRange* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gboolean _tmp37_;
						if (!_tmp25_) {
							gint _tmp26_;
							_tmp26_ = i;
							i = _tmp26_ - 1;
						}
						_tmp25_ = FALSE;
						if (!(i >= 0)) {
							break;
						}
						_tmp27_ = self->classes_first;
						_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, i);
						_bird_font_glyph_range_unref0 (l);
						l = (BirdFontGlyphRange*) _tmp28_;
						_tmp29_ = self->classes_last;
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, i);
						_bird_font_glyph_range_unref0 (r);
						r = (BirdFontGlyphRange*) _tmp30_;
						_tmp32_ = l;
						_tmp33_ = bird_font_glyph_range_get_all_ranges (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = bird_font_glyph_range_get_all_ranges (left_range);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strcmp0 (_tmp34_, _tmp36_) == 0;
						_g_free0 (_tmp36_);
						_g_free0 (_tmp34_);
						if (_tmp37_) {
							BirdFontGlyphRange* _tmp38_;
							const gchar* _tmp39_;
							_tmp38_ = r;
							_tmp39_ = right;
							_tmp31_ = bird_font_glyph_range_has_character (_tmp38_, _tmp39_);
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							GeeArrayList* _tmp40_;
							gpointer _tmp41_;
							BirdFontKerning* _tmp42_;
							gdouble _tmp43_;
							_tmp40_ = self->classes_kerning;
							_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, i);
							_tmp42_ = (BirdFontKerning*) _tmp41_;
							_tmp43_ = _tmp42_->val;
							_g_object_unref0 (_tmp42_);
							result = _tmp43_;
							_g_free0 (right);
							_g_object_unref0 (_right_list);
							_bird_font_glyph_range_unref0 (l);
							_bird_font_glyph_range_unref0 (r);
							return result;
						}
					}
				}
			}
			_g_free0 (right);
		}
		_g_object_unref0 (_right_list);
	}
	result = (gdouble) 0;
	_bird_font_glyph_range_unref0 (l);
	_bird_font_glyph_range_unref0 (r);
	return result;
}

gdouble
bird_font_kerning_classes_get_kern_for_char_to_range (BirdFontKerningClasses* self,
                                                      const gchar* left_char,
                                                      BirdFontGlyphRange* right_range)
{
	BirdFontGlyphRange* r = NULL;
	BirdFontGlyphRange* l = NULL;
	gint len = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (left_char != NULL, 0.0);
	g_return_val_if_fail (right_range != NULL, 0.0);
	_tmp0_ = self->classes_first;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	len = (gint) _tmp2_;
	_tmp3_ = self->classes_first;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	len = (gint) _tmp5_;
	_tmp6_ = self->classes_last;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_return_val_if_fail (len == _tmp8_, 0);
	_tmp9_ = self->classes_kerning;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_return_val_if_fail (len == _tmp11_, 0);
	if (!bird_font_glyph_range_is_class (right_range)) {
		g_warning ("KerningClasses.vala:397: Expecting a class");
		result = (gdouble) 0;
		_bird_font_glyph_range_unref0 (l);
		_bird_font_glyph_range_unref0 (r);
		return result;
	}
	{
		GeeArrayList* _left_list = NULL;
		GeeArrayList* _tmp12_;
		gint _left_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _left_index = 0;
		_tmp12_ = bird_font_kerning_classes_get_spacing_class (self, left_char);
		_left_list = _tmp12_;
		_tmp13_ = _left_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_left_size = _tmp15_;
		_left_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gchar* left = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			_left_index = _left_index + 1;
			_tmp16_ = _left_index;
			_tmp17_ = _left_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _left_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _left_index);
			left = (gchar*) _tmp19_;
			{
				gint i = 0;
				i = len - 1;
				{
					gboolean _tmp20_ = FALSE;
					_tmp20_ = TRUE;
					while (TRUE) {
						GeeArrayList* _tmp22_;
						gpointer _tmp23_;
						GeeArrayList* _tmp24_;
						gpointer _tmp25_;
						gboolean _tmp26_ = FALSE;
						BirdFontGlyphRange* _tmp27_;
						const gchar* _tmp28_;
						if (!_tmp20_) {
							gint _tmp21_;
							_tmp21_ = i;
							i = _tmp21_ - 1;
						}
						_tmp20_ = FALSE;
						if (!(i >= 0)) {
							break;
						}
						_tmp22_ = self->classes_first;
						_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, i);
						_bird_font_glyph_range_unref0 (l);
						l = (BirdFontGlyphRange*) _tmp23_;
						_tmp24_ = self->classes_last;
						_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
						_bird_font_glyph_range_unref0 (r);
						r = (BirdFontGlyphRange*) _tmp25_;
						_tmp27_ = l;
						_tmp28_ = left;
						if (bird_font_glyph_range_has_character (_tmp27_, _tmp28_)) {
							BirdFontGlyphRange* _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp29_ = r;
							_tmp30_ = bird_font_glyph_range_get_all_ranges (_tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = bird_font_glyph_range_get_all_ranges (right_range);
							_tmp33_ = _tmp32_;
							_tmp26_ = g_strcmp0 (_tmp31_, _tmp33_) == 0;
							_g_free0 (_tmp33_);
							_g_free0 (_tmp31_);
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							GeeArrayList* _tmp34_;
							gpointer _tmp35_;
							BirdFontKerning* _tmp36_;
							gdouble _tmp37_;
							_tmp34_ = self->classes_kerning;
							_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, i);
							_tmp36_ = (BirdFontKerning*) _tmp35_;
							_tmp37_ = _tmp36_->val;
							_g_object_unref0 (_tmp36_);
							result = _tmp37_;
							_g_free0 (left);
							_g_object_unref0 (_left_list);
							_bird_font_glyph_range_unref0 (l);
							_bird_font_glyph_range_unref0 (r);
							return result;
						}
					}
				}
			}
			_g_free0 (left);
		}
		_g_object_unref0 (_left_list);
	}
	result = (gdouble) 0;
	_bird_font_glyph_range_unref0 (l);
	_bird_font_glyph_range_unref0 (r);
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
__lambda380_ (BirdFontKerningClasses* self,
              BirdFontKerningPair* k)
{
	g_return_if_fail (k != NULL);
	bird_font_kerning_pair_print (k);
}

static void
___lambda380__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                          gpointer self)
{
	__lambda380_ ((BirdFontKerningClasses*) self, list);
}

void
bird_font_kerning_classes_print_all (BirdFontKerningClasses* self)
{
	g_return_if_fail (self != NULL);
	g_print ("Kernings classes:\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				BirdFontGlyphRange* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				BirdFontGlyphRange* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GeeArrayList* _tmp15_;
				gpointer _tmp16_;
				BirdFontKerning* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gboolean _tmp20_ = FALSE;
				GeeArrayList* _tmp21_;
				gpointer _tmp22_;
				BirdFontGlyphRange* _tmp23_;
				gboolean _tmp24_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->classes_first;
				_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->classes_first;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
				_tmp7_ = (BirdFontGlyphRange*) _tmp6_;
				_tmp8_ = bird_font_glyph_range_get_all_ranges (_tmp7_);
				_tmp9_ = _tmp8_;
				g_print ("%s", _tmp9_);
				_g_free0 (_tmp9_);
				_bird_font_glyph_range_unref0 (_tmp7_);
				g_print ("\t\t");
				_tmp10_ = self->classes_last;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i);
				_tmp12_ = (BirdFontGlyphRange*) _tmp11_;
				_tmp13_ = bird_font_glyph_range_get_all_ranges (_tmp12_);
				_tmp14_ = _tmp13_;
				g_print ("%s", _tmp14_);
				_g_free0 (_tmp14_);
				_bird_font_glyph_range_unref0 (_tmp12_);
				g_print ("\t\t");
				_tmp15_ = self->classes_kerning;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, i);
				_tmp17_ = (BirdFontKerning*) _tmp16_;
				_tmp18_ = double_to_string (_tmp17_->val);
				_tmp19_ = _tmp18_;
				g_print ("%s", _tmp19_);
				_g_free0 (_tmp19_);
				_g_object_unref0 (_tmp17_);
				g_print ("\t\t");
				_tmp21_ = self->classes_first;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, i);
				_tmp23_ = (BirdFontGlyphRange*) _tmp22_;
				_tmp24_ = bird_font_glyph_range_is_class (_tmp23_);
				_bird_font_glyph_range_unref0 (_tmp23_);
				if (_tmp24_) {
					_tmp20_ = TRUE;
				} else {
					GeeArrayList* _tmp25_;
					gpointer _tmp26_;
					BirdFontGlyphRange* _tmp27_;
					_tmp25_ = self->classes_last;
					_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, i);
					_tmp27_ = (BirdFontGlyphRange*) _tmp26_;
					_tmp20_ = bird_font_glyph_range_is_class (_tmp27_);
					_bird_font_glyph_range_unref0 (_tmp27_);
				}
				if (_tmp20_) {
					g_print ("class");
				}
				g_print ("\n");
			}
		}
	}
	g_print ("\n");
	g_print ("Kernings for pairs:\n");
	if (!bird_font_kerning_classes_set_protect_map (self, TRUE)) {
		g_warning ("KerningClasses.vala:436: Map is protected.");
		return;
	}
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp28_;
		GeeSet* _tmp29_;
		GeeSet* _tmp30_;
		GeeSet* _tmp31_;
		GeeIterator* _tmp32_;
		GeeIterator* _tmp33_;
		_tmp28_ = self->priv->single_kerning;
		_tmp29_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_key_it = _tmp33_;
		while (TRUE) {
			GeeIterator* _tmp34_;
			gchar* key = NULL;
			GeeIterator* _tmp35_;
			gpointer _tmp36_;
			const gchar* _tmp37_;
			GeeHashMap* _tmp38_;
			const gchar* _tmp39_;
			gpointer _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp34_ = _key_it;
			if (!gee_iterator_next (_tmp34_)) {
				break;
			}
			_tmp35_ = _key_it;
			_tmp36_ = gee_iterator_get (_tmp35_);
			key = (gchar*) _tmp36_;
			_tmp37_ = key;
			g_print ("%s", _tmp37_);
			g_print ("\t\t");
			_tmp38_ = self->priv->single_kerning;
			_tmp39_ = key;
			_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, _tmp39_);
			_tmp41_ = double_to_string ((gdouble) (*((gdouble*) _tmp40_)));
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\n", NULL);
			_tmp44_ = _tmp43_;
			g_print ("%s", _tmp44_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	bird_font_kerning_classes_set_protect_map (self, FALSE);
	g_print ("\n");
	g_print ("Generated table:\n");
	bird_font_kerning_classes_all_pairs (self, ___lambda380__bird_font_kerning_classes_kerning_iterator, self);
}

void
bird_font_kerning_classes_get_classes (BirdFontKerningClasses* self,
                                       BirdFontKerningClassesKerningClassIterator kerningIterator,
                                       gpointer kerningIterator_target)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				BirdFontGlyphRange* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				BirdFontGlyphRange* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GeeArrayList* _tmp15_;
				gpointer _tmp16_;
				BirdFontKerning* _tmp17_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->classes_first;
				_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->classes_first;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
				_tmp7_ = (BirdFontGlyphRange*) _tmp6_;
				_tmp8_ = bird_font_glyph_range_get_all_ranges (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->classes_last;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i);
				_tmp12_ = (BirdFontGlyphRange*) _tmp11_;
				_tmp13_ = bird_font_glyph_range_get_all_ranges (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = self->classes_kerning;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, i);
				_tmp17_ = (BirdFontKerning*) _tmp16_;
				kerningIterator (_tmp9_, _tmp14_, _tmp17_->val, kerningIterator_target);
				_g_object_unref0 (_tmp17_);
				_g_free0 (_tmp14_);
				_bird_font_glyph_range_unref0 (_tmp12_);
				_g_free0 (_tmp9_);
				_bird_font_glyph_range_unref0 (_tmp7_);
			}
		}
	}
}

void
bird_font_kerning_classes_get_single_position_pairs (BirdFontKerningClasses* self,
                                                     BirdFontKerningClassesKerningClassIterator kerningIterator,
                                                     gpointer kerningIterator_target)
{
	gdouble k = 0.0;
	g_return_if_fail (self != NULL);
	k = (gdouble) 0;
	if (!bird_font_kerning_classes_set_protect_map (self, TRUE)) {
		g_warning ("KerningClasses.vala:467: Map is protected.");
		return;
	}
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->single_kerning;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_key_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gchar* key = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			gchar** chars = NULL;
			const gchar* _tmp9_;
			gchar** _tmp10_;
			gchar** _tmp11_;
			gint chars_length1;
			gint _chars_size_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			_tmp6_ = _key_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _key_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			key = (gchar*) _tmp8_;
			_tmp9_ = key;
			_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " - ", 0);
			chars = _tmp11_;
			chars_length1 = _vala_array_length (_tmp10_);
			_chars_size_ = chars_length1;
			_tmp12_ = chars;
			_tmp12__length1 = chars_length1;
			if (_tmp12__length1 != 2) {
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = key;
				_tmp14_ = string_to_string (_tmp13_);
				_tmp15_ = g_strconcat ("Can not parse characters from key: ", _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				g_warning ("KerningClasses.vala:475: %s", _tmp16_);
				_g_free0 (_tmp16_);
			} else {
				GeeHashMap* _tmp17_;
				const gchar* _tmp18_;
				gpointer _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				_tmp17_ = self->priv->single_kerning;
				_tmp18_ = key;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
				k = (gdouble) (*((gdouble*) _tmp19_));
				_g_free0 (_tmp19_);
				_tmp20_ = chars;
				_tmp20__length1 = chars_length1;
				_tmp21_ = _tmp20_[0];
				_tmp22_ = chars;
				_tmp22__length1 = chars_length1;
				_tmp23_ = _tmp22_[1];
				kerningIterator (_tmp21_, _tmp23_, k, kerningIterator_target);
			}
			chars = (_vala_array_free (chars, chars_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	bird_font_kerning_classes_set_protect_map (self, FALSE);
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		BirdFontKerningClasses* self;
		self = _data20_->self;
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda57_ (Block20Data* _data20_,
             BirdFontKerningPair* kl)
{
	BirdFontKerningClasses* self;
	BirdFontGlyph* g2 = NULL;
	BirdFontKerningPair* kerning_list = NULL;
	BirdFontKerningPair* _tmp0_;
	gchar* g1 = NULL;
	BirdFontKerningPair* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gchar* _tmp3_;
	BirdFontKerning* kerning = NULL;
	gint i = 0;
	BirdFontKerningPair* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	self = _data20_->self;
	g_return_if_fail (kl != NULL);
	_tmp0_ = _g_object_ref0 (kl);
	kerning_list = _tmp0_;
	_tmp1_ = kerning_list;
	_tmp2_ = _tmp1_->character;
	_tmp3_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp2_);
	g1 = _tmp3_;
	i = 0;
	_tmp4_ = kerning_list;
	_tmp5_ = _tmp4_->kerning;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	g_return_if_fail (_tmp7_ > 0);
	{
		GeeArrayList* _k_list = NULL;
		BirdFontKerningPair* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _k_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _k_index = 0;
		_tmp8_ = kerning_list;
		_tmp9_ = _tmp8_->kerning;
		_k_list = _tmp9_;
		_tmp10_ = _k_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_k_size = _tmp12_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			BirdFontKerning* k = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			BirdFontKerning* _tmp17_;
			BirdFontGlyph* _tmp18_;
			BirdFontKerningPair* _tmp19_;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			const gchar* _tmp22_;
			BirdFontGlyph* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			BirdFontKerning* _tmp26_;
			_k_index = _k_index + 1;
			_tmp13_ = _k_index;
			_tmp14_ = _k_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _k_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _k_index);
			k = (BirdFontKerning*) _tmp16_;
			_tmp17_ = k;
			_tmp18_ = bird_font_kerning_get_glyph (_tmp17_);
			_g_object_unref0 (g2);
			g2 = _tmp18_;
			_tmp19_ = kerning_list;
			_tmp20_ = _tmp19_->kerning;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, i);
			_g_object_unref0 (kerning);
			kerning = (BirdFontKerning*) _tmp21_;
			_tmp22_ = g1;
			_tmp23_ = g2;
			_tmp24_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = kerning;
			_data20_->iter (_tmp22_, _tmp25_, _tmp26_->val, _data20_->iter_target);
			_g_free0 (_tmp25_);
			_g_object_unref0 (k);
		}
	}
	_g_object_unref0 (kerning);
	_g_free0 (g1);
	_g_object_unref0 (kerning_list);
	_g_object_unref0 (g2);
}

static void
___lambda57__bird_font_kerning_classes_kerning_iterator (BirdFontKerningPair* list,
                                                         gpointer self)
{
	__lambda57_ (self, list);
}

void
bird_font_kerning_classes_each_pair (BirdFontKerningClasses* self,
                                     BirdFontKerningClassesKerningClassIterator iter,
                                     gpointer iter_target)
{
	Block20Data* _data20_;
	g_return_if_fail (self != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_data20_->iter = iter;
	_data20_->iter_target = iter_target;
	bird_font_kerning_classes_all_pairs (self, ___lambda57__bird_font_kerning_classes_kerning_iterator, _data20_);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
bird_font_kerning_classes_all_pairs (BirdFontKerningClasses* self,
                                     BirdFontKerningClassesKerningIterator kerningIterator,
                                     gpointer kerningIterator_target)
{
	GeeArrayList* left_glyphs = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* pairs = NULL;
	GeeArrayList* _tmp1_;
	gdouble kerning = 0.0;
	gchar* right = NULL;
	gchar* name = NULL;
	BirdFontGlyph* g = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	left_glyphs = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_KERNING_PAIR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	pairs = _tmp1_;
	{
		GeeArrayList* _r_list = NULL;
		GeeArrayList* _tmp2_;
		gint _r_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _r_index = 0;
		_tmp2_ = self->classes_first;
		_r_list = _tmp2_;
		_tmp3_ = _r_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_r_size = _tmp5_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontGlyphRange* r = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			_r_index = _r_index + 1;
			_tmp6_ = _r_index;
			_tmp7_ = _r_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _r_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _r_index);
			r = (BirdFontGlyphRange*) _tmp9_;
			{
				GeeArrayList* _u_list = NULL;
				BirdFontGlyphRange* _tmp10_;
				GeeArrayList* _tmp11_;
				gint _u_size = 0;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _u_index = 0;
				_tmp10_ = r;
				_tmp11_ = _tmp10_->ranges;
				_u_list = _tmp11_;
				_tmp12_ = _u_list;
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_u_size = _tmp14_;
				_u_index = -1;
				while (TRUE) {
					gint _tmp15_;
					gint _tmp16_;
					BirdFontUniRange* u = NULL;
					GeeArrayList* _tmp17_;
					gpointer _tmp18_;
					_u_index = _u_index + 1;
					_tmp15_ = _u_index;
					_tmp16_ = _u_size;
					if (!(_tmp15_ < _tmp16_)) {
						break;
					}
					_tmp17_ = _u_list;
					_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _u_index);
					u = (BirdFontUniRange*) _tmp18_;
					{
						gunichar c = 0U;
						BirdFontUniRange* _tmp19_;
						_tmp19_ = u;
						c = _tmp19_->start;
						{
							gboolean _tmp20_ = FALSE;
							_tmp20_ = TRUE;
							while (TRUE) {
								BirdFontUniRange* _tmp22_;
								gchar* _tmp23_;
								BirdFontFont* _tmp24_;
								const gchar* _tmp25_;
								BirdFontGlyph* _tmp26_;
								gboolean _tmp27_ = FALSE;
								BirdFontGlyph* _tmp28_;
								if (!_tmp20_) {
									gunichar _tmp21_;
									_tmp21_ = c;
									c = _tmp21_ + 1;
								}
								_tmp20_ = FALSE;
								_tmp22_ = u;
								if (!(c <= _tmp22_->stop)) {
									break;
								}
								_tmp23_ = g_unichar_to_string (c);
								_g_free0 (name);
								name = (gchar*) _tmp23_;
								_tmp24_ = self->font;
								_tmp25_ = name;
								_tmp26_ = bird_font_font_get_glyph (_tmp24_, _tmp25_);
								_g_object_unref0 (g);
								g = _tmp26_;
								_tmp28_ = g;
								if (_tmp28_ != NULL) {
									GeeArrayList* _tmp29_;
									BirdFontGlyph* _tmp30_;
									_tmp29_ = left_glyphs;
									_tmp30_ = g;
									_tmp27_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
								} else {
									_tmp27_ = FALSE;
								}
								if (_tmp27_) {
									GeeArrayList* _tmp31_;
									BirdFontGlyph* _tmp32_;
									_tmp31_ = left_glyphs;
									_tmp32_ = g;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
								}
							}
						}
					}
					_g_object_unref0 (u);
				}
			}
			{
				GeeArrayList* _n_list = NULL;
				BirdFontGlyphRange* _tmp33_;
				GeeArrayList* _tmp34_;
				gint _n_size = 0;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _n_index = 0;
				_tmp33_ = r;
				_tmp34_ = _tmp33_->unassigned;
				_n_list = _tmp34_;
				_tmp35_ = _n_list;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_n_size = _tmp37_;
				_n_index = -1;
				while (TRUE) {
					gint _tmp38_;
					gint _tmp39_;
					gchar* n = NULL;
					GeeArrayList* _tmp40_;
					gpointer _tmp41_;
					BirdFontFont* _tmp42_;
					const gchar* _tmp43_;
					BirdFontGlyph* _tmp44_;
					gboolean _tmp45_ = FALSE;
					BirdFontGlyph* _tmp46_;
					_n_index = _n_index + 1;
					_tmp38_ = _n_index;
					_tmp39_ = _n_size;
					if (!(_tmp38_ < _tmp39_)) {
						break;
					}
					_tmp40_ = _n_list;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _n_index);
					n = (gchar*) _tmp41_;
					_tmp42_ = self->font;
					_tmp43_ = n;
					_tmp44_ = bird_font_font_get_glyph (_tmp42_, _tmp43_);
					_g_object_unref0 (g);
					g = _tmp44_;
					_tmp46_ = g;
					if (_tmp46_ != NULL) {
						GeeArrayList* _tmp47_;
						BirdFontGlyph* _tmp48_;
						_tmp47_ = left_glyphs;
						_tmp48_ = g;
						_tmp45_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp47_, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						GeeArrayList* _tmp49_;
						BirdFontGlyph* _tmp50_;
						_tmp49_ = left_glyphs;
						_tmp50_ = g;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
					}
					_g_free0 (n);
				}
			}
			_bird_font_glyph_range_unref0 (r);
		}
	}
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp51_;
		gint _n_size = 0;
		GeeArrayList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _n_index = 0;
		_tmp51_ = self->single_kerning_letters_left;
		_n_list = _tmp51_;
		_tmp52_ = _n_list;
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_n_size = _tmp54_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			gchar* n = NULL;
			GeeArrayList* _tmp57_;
			gpointer _tmp58_;
			BirdFontFont* _tmp59_;
			const gchar* _tmp60_;
			BirdFontGlyph* _tmp61_;
			gboolean _tmp62_ = FALSE;
			BirdFontGlyph* _tmp63_;
			_n_index = _n_index + 1;
			_tmp55_ = _n_index;
			_tmp56_ = _n_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _n_list;
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _n_index);
			n = (gchar*) _tmp58_;
			_tmp59_ = self->font;
			_tmp60_ = n;
			_tmp61_ = bird_font_font_get_glyph (_tmp59_, _tmp60_);
			_g_object_unref0 (g);
			g = _tmp61_;
			_tmp63_ = g;
			if (_tmp63_ != NULL) {
				GeeArrayList* _tmp64_;
				BirdFontGlyph* _tmp65_;
				_tmp64_ = left_glyphs;
				_tmp65_ = g;
				_tmp62_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp64_, G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				GeeArrayList* _tmp66_;
				BirdFontGlyph* _tmp67_;
				_tmp66_ = left_glyphs;
				_tmp67_ = g;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			}
			_g_free0 (n);
		}
	}
	{
		GeeArrayList* _character_list = NULL;
		GeeArrayList* _tmp68_;
		gint _character_size = 0;
		GeeArrayList* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		gint _character_index = 0;
		_tmp68_ = left_glyphs;
		_character_list = _tmp68_;
		_tmp69_ = _character_list;
		_tmp70_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp69_);
		_tmp71_ = _tmp70_;
		_character_size = _tmp71_;
		_character_index = -1;
		while (TRUE) {
			gint _tmp72_;
			gint _tmp73_;
			BirdFontGlyph* character = NULL;
			GeeArrayList* _tmp74_;
			gpointer _tmp75_;
			BirdFontKerningPair* kl = NULL;
			BirdFontGlyph* _tmp76_;
			BirdFontKerningPair* _tmp77_;
			BirdFontKerningPair* _tmp164_;
			GeeArrayList* _tmp165_;
			gint _tmp166_;
			gint _tmp167_;
			BirdFontKerningPair* _tmp170_;
			GeeArrayList* _tmp171_;
			gint _tmp172_;
			gint _tmp173_;
			BirdFontKerningPair* _tmp181_;
			_character_index = _character_index + 1;
			_tmp72_ = _character_index;
			_tmp73_ = _character_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _character_list;
			_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp74_, _character_index);
			character = (BirdFontGlyph*) _tmp75_;
			_tmp76_ = character;
			_tmp77_ = bird_font_kerning_pair_new (_tmp76_);
			kl = _tmp77_;
			{
				GeeArrayList* _r_list = NULL;
				GeeArrayList* _tmp78_;
				gint _r_size = 0;
				GeeArrayList* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				gint _r_index = 0;
				_tmp78_ = self->classes_last;
				_r_list = _tmp78_;
				_tmp79_ = _r_list;
				_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
				_tmp81_ = _tmp80_;
				_r_size = _tmp81_;
				_r_index = -1;
				while (TRUE) {
					gint _tmp82_;
					gint _tmp83_;
					BirdFontGlyphRange* r = NULL;
					GeeArrayList* _tmp84_;
					gpointer _tmp85_;
					_r_index = _r_index + 1;
					_tmp82_ = _r_index;
					_tmp83_ = _r_size;
					if (!(_tmp82_ < _tmp83_)) {
						break;
					}
					_tmp84_ = _r_list;
					_tmp85_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, _r_index);
					r = (BirdFontGlyphRange*) _tmp85_;
					{
						GeeArrayList* _u_list = NULL;
						BirdFontGlyphRange* _tmp86_;
						GeeArrayList* _tmp87_;
						gint _u_size = 0;
						GeeArrayList* _tmp88_;
						gint _tmp89_;
						gint _tmp90_;
						gint _u_index = 0;
						_tmp86_ = r;
						_tmp87_ = _tmp86_->ranges;
						_u_list = _tmp87_;
						_tmp88_ = _u_list;
						_tmp89_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp88_);
						_tmp90_ = _tmp89_;
						_u_size = _tmp90_;
						_u_index = -1;
						while (TRUE) {
							gint _tmp91_;
							gint _tmp92_;
							BirdFontUniRange* u = NULL;
							GeeArrayList* _tmp93_;
							gpointer _tmp94_;
							_u_index = _u_index + 1;
							_tmp91_ = _u_index;
							_tmp92_ = _u_size;
							if (!(_tmp91_ < _tmp92_)) {
								break;
							}
							_tmp93_ = _u_list;
							_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, _u_index);
							u = (BirdFontUniRange*) _tmp94_;
							{
								gunichar c = 0U;
								BirdFontUniRange* _tmp95_;
								_tmp95_ = u;
								c = _tmp95_->start;
								{
									gboolean _tmp96_ = FALSE;
									_tmp96_ = TRUE;
									while (TRUE) {
										BirdFontUniRange* _tmp98_;
										gchar* _tmp99_;
										gboolean _tmp100_ = FALSE;
										BirdFontFont* _tmp101_;
										const gchar* _tmp102_;
										if (!_tmp96_) {
											gunichar _tmp97_;
											_tmp97_ = c;
											c = _tmp97_ + 1;
										}
										_tmp96_ = FALSE;
										_tmp98_ = u;
										if (!(c <= _tmp98_->stop)) {
											break;
										}
										_tmp99_ = g_unichar_to_string (c);
										_g_free0 (right);
										right = (gchar*) _tmp99_;
										_tmp101_ = self->font;
										_tmp102_ = right;
										if (bird_font_font_has_glyph (_tmp101_, _tmp102_)) {
											BirdFontGlyph* _tmp103_;
											gchar* _tmp104_;
											gchar* _tmp105_;
											const gchar* _tmp106_;
											_tmp103_ = character;
											_tmp104_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp103_);
											_tmp105_ = _tmp104_;
											_tmp106_ = right;
											_tmp100_ = bird_font_kerning_classes_has_kerning (self, _tmp105_, _tmp106_);
											_g_free0 (_tmp105_);
										} else {
											_tmp100_ = FALSE;
										}
										if (_tmp100_) {
											BirdFontGlyph* _tmp107_;
											gchar* _tmp108_;
											gchar* _tmp109_;
											const gchar* _tmp110_;
											BirdFontKerningPair* _tmp111_;
											BirdFontFont* _tmp112_;
											const gchar* _tmp113_;
											BirdFontGlyph* _tmp114_;
											BirdFontGlyph* _tmp115_;
											_tmp107_ = character;
											_tmp108_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp107_);
											_tmp109_ = _tmp108_;
											_tmp110_ = right;
											kerning = bird_font_kerning_classes_get_kerning (self, _tmp109_, _tmp110_);
											_g_free0 (_tmp109_);
											_tmp111_ = kl;
											_tmp112_ = self->font;
											_tmp113_ = right;
											_tmp114_ = bird_font_font_get_glyph (_tmp112_, _tmp113_);
											_tmp115_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
											bird_font_kerning_pair_add_unique (_tmp111_, _tmp115_, kerning);
											_g_object_unref0 (_tmp115_);
										}
									}
								}
							}
							_g_object_unref0 (u);
						}
					}
					{
						GeeArrayList* _n_list = NULL;
						BirdFontGlyphRange* _tmp116_;
						GeeArrayList* _tmp117_;
						gint _n_size = 0;
						GeeArrayList* _tmp118_;
						gint _tmp119_;
						gint _tmp120_;
						gint _n_index = 0;
						_tmp116_ = r;
						_tmp117_ = _tmp116_->unassigned;
						_n_list = _tmp117_;
						_tmp118_ = _n_list;
						_tmp119_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp118_);
						_tmp120_ = _tmp119_;
						_n_size = _tmp120_;
						_n_index = -1;
						while (TRUE) {
							gint _tmp121_;
							gint _tmp122_;
							gchar* n = NULL;
							GeeArrayList* _tmp123_;
							gpointer _tmp124_;
							gboolean _tmp125_ = FALSE;
							BirdFontFont* _tmp126_;
							const gchar* _tmp127_;
							_n_index = _n_index + 1;
							_tmp121_ = _n_index;
							_tmp122_ = _n_size;
							if (!(_tmp121_ < _tmp122_)) {
								break;
							}
							_tmp123_ = _n_list;
							_tmp124_ = gee_abstract_list_get ((GeeAbstractList*) _tmp123_, _n_index);
							n = (gchar*) _tmp124_;
							_tmp126_ = self->font;
							_tmp127_ = n;
							if (bird_font_font_has_glyph (_tmp126_, _tmp127_)) {
								BirdFontGlyph* _tmp128_;
								gchar* _tmp129_;
								gchar* _tmp130_;
								const gchar* _tmp131_;
								_tmp128_ = character;
								_tmp129_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp128_);
								_tmp130_ = _tmp129_;
								_tmp131_ = n;
								_tmp125_ = bird_font_kerning_classes_has_kerning (self, _tmp130_, _tmp131_);
								_g_free0 (_tmp130_);
							} else {
								_tmp125_ = FALSE;
							}
							if (_tmp125_) {
								BirdFontGlyph* _tmp132_;
								gchar* _tmp133_;
								gchar* _tmp134_;
								const gchar* _tmp135_;
								BirdFontKerningPair* _tmp136_;
								BirdFontFont* _tmp137_;
								const gchar* _tmp138_;
								BirdFontGlyph* _tmp139_;
								BirdFontGlyph* _tmp140_;
								_tmp132_ = character;
								_tmp133_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp132_);
								_tmp134_ = _tmp133_;
								_tmp135_ = n;
								kerning = bird_font_kerning_classes_get_kerning (self, _tmp134_, _tmp135_);
								_g_free0 (_tmp134_);
								_tmp136_ = kl;
								_tmp137_ = self->font;
								_tmp138_ = n;
								_tmp139_ = bird_font_font_get_glyph (_tmp137_, _tmp138_);
								_tmp140_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp139_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph);
								bird_font_kerning_pair_add_unique (_tmp136_, _tmp140_, kerning);
								_g_object_unref0 (_tmp140_);
							}
							_g_free0 (n);
						}
					}
					_bird_font_glyph_range_unref0 (r);
				}
			}
			{
				GeeArrayList* _right_glyph_name_list = NULL;
				GeeArrayList* _tmp141_;
				gint _right_glyph_name_size = 0;
				GeeArrayList* _tmp142_;
				gint _tmp143_;
				gint _tmp144_;
				gint _right_glyph_name_index = 0;
				_tmp141_ = self->single_kerning_letters_right;
				_right_glyph_name_list = _tmp141_;
				_tmp142_ = _right_glyph_name_list;
				_tmp143_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp142_);
				_tmp144_ = _tmp143_;
				_right_glyph_name_size = _tmp144_;
				_right_glyph_name_index = -1;
				while (TRUE) {
					gint _tmp145_;
					gint _tmp146_;
					gchar* right_glyph_name = NULL;
					GeeArrayList* _tmp147_;
					gpointer _tmp148_;
					BirdFontGlyph* gl = NULL;
					BirdFontFont* _tmp149_;
					const gchar* _tmp150_;
					BirdFontGlyph* _tmp151_;
					gboolean _tmp152_ = FALSE;
					BirdFontGlyph* _tmp153_;
					_right_glyph_name_index = _right_glyph_name_index + 1;
					_tmp145_ = _right_glyph_name_index;
					_tmp146_ = _right_glyph_name_size;
					if (!(_tmp145_ < _tmp146_)) {
						break;
					}
					_tmp147_ = _right_glyph_name_list;
					_tmp148_ = gee_abstract_list_get ((GeeAbstractList*) _tmp147_, _right_glyph_name_index);
					right_glyph_name = (gchar*) _tmp148_;
					_tmp149_ = self->font;
					_tmp150_ = right_glyph_name;
					_tmp151_ = bird_font_font_get_glyph (_tmp149_, _tmp150_);
					gl = _tmp151_;
					_tmp153_ = gl;
					if (_tmp153_ != NULL) {
						BirdFontGlyph* _tmp154_;
						gchar* _tmp155_;
						gchar* _tmp156_;
						const gchar* _tmp157_;
						_tmp154_ = character;
						_tmp155_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = right_glyph_name;
						_tmp152_ = bird_font_kerning_classes_has_kerning (self, _tmp156_, _tmp157_);
						_g_free0 (_tmp156_);
					} else {
						_tmp152_ = FALSE;
					}
					if (_tmp152_) {
						BirdFontGlyph* _tmp158_;
						gchar* _tmp159_;
						gchar* _tmp160_;
						const gchar* _tmp161_;
						BirdFontKerningPair* _tmp162_;
						BirdFontGlyph* _tmp163_;
						_tmp158_ = character;
						_tmp159_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp158_);
						_tmp160_ = _tmp159_;
						_tmp161_ = right_glyph_name;
						kerning = bird_font_kerning_classes_get_kerning (self, _tmp160_, _tmp161_);
						_g_free0 (_tmp160_);
						_tmp162_ = kl;
						_tmp163_ = gl;
						bird_font_kerning_pair_add_unique (_tmp162_, G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph), kerning);
					}
					_g_object_unref0 (gl);
					_g_free0 (right_glyph_name);
				}
			}
			_tmp164_ = kl;
			_tmp165_ = _tmp164_->kerning;
			_tmp166_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp165_);
			_tmp167_ = _tmp166_;
			if (_tmp167_ > 0) {
				GeeArrayList* _tmp168_;
				BirdFontKerningPair* _tmp169_;
				_tmp168_ = pairs;
				_tmp169_ = kl;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp168_, _tmp169_);
			}
			_tmp170_ = kl;
			_tmp171_ = _tmp170_->kerning;
			_tmp172_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp171_);
			_tmp173_ = _tmp172_;
			if (_tmp173_ == 0) {
				BirdFontKerningPair* _tmp174_;
				BirdFontGlyph* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				const gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				_tmp174_ = kl;
				_tmp175_ = _tmp174_->character;
				_tmp176_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = string_to_string (_tmp177_);
				_tmp179_ = g_strconcat ("No kerning pairs for character: ", _tmp178_, NULL);
				_tmp180_ = _tmp179_;
				g_warning ("KerningClasses.vala:576: %s", _tmp180_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp177_);
			}
			_tmp181_ = kl;
			bird_font_kerning_pair_sort (_tmp181_);
			_g_object_unref0 (kl);
			_g_object_unref0 (character);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp182_;
		gint _p_size = 0;
		GeeArrayList* _tmp183_;
		gint _tmp184_;
		gint _tmp185_;
		gint _p_index = 0;
		_tmp182_ = pairs;
		_p_list = _tmp182_;
		_tmp183_ = _p_list;
		_tmp184_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp183_);
		_tmp185_ = _tmp184_;
		_p_size = _tmp185_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp186_;
			gint _tmp187_;
			BirdFontKerningPair* p = NULL;
			GeeArrayList* _tmp188_;
			gpointer _tmp189_;
			BirdFontKerningPair* _tmp190_;
			_p_index = _p_index + 1;
			_tmp186_ = _p_index;
			_tmp187_ = _p_size;
			if (!(_tmp186_ < _tmp187_)) {
				break;
			}
			_tmp188_ = _p_list;
			_tmp189_ = gee_abstract_list_get ((GeeAbstractList*) _tmp188_, _p_index);
			p = (BirdFontKerningPair*) _tmp189_;
			_tmp190_ = p;
			kerningIterator (_tmp190_, kerningIterator_target);
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (g);
	_g_free0 (name);
	_g_free0 (right);
	_g_object_unref0 (pairs);
	_g_object_unref0 (left_glyphs);
}

static gboolean
bird_font_kerning_classes_set_protect_map (BirdFontKerningClasses* self,
                                           gboolean p)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (p) {
		_tmp0_ = self->priv->protect_map;
	} else {
		_tmp0_ = FALSE;
	}
	if (G_UNLIKELY (_tmp0_)) {
		g_warning ("KerningClasses.vala:590: Map is already protected.");
		result = FALSE;
		return result;
	}
	self->priv->protect_map = p;
	result = TRUE;
	return result;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		BirdFontKerningClasses* self;
		self = _data21_->self;
		_g_free0 (_data21_->left);
		_g_free0 (_data21_->right);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
__lambda324_ (Block21Data* _data21_,
              const gchar* l,
              const gchar* r,
              gdouble kerning)
{
	BirdFontKerningClasses* self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	self = _data21_->self;
	g_return_if_fail (l != NULL);
	g_return_if_fail (r != NULL);
	if (g_strcmp0 (_data21_->left, l) == 0) {
		_tmp0_ = g_strcmp0 (r, _data21_->right) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_data21_->index = _data21_->i;
	}
	_tmp1_ = _data21_->i;
	_data21_->i = _tmp1_ + 1;
}

static void
___lambda324__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                const gchar* right,
                                                                gdouble kerning,
                                                                gpointer self)
{
	__lambda324_ (self, left, right, kerning);
}

void
bird_font_kerning_classes_delete_kerning_for_class (BirdFontKerningClasses* self,
                                                    const gchar* left,
                                                    const gchar* right)
{
	Block21Data* _data21_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	BirdFontGlyphRange* _tmp8_;
	GeeArrayList* _tmp9_;
	gpointer _tmp10_;
	BirdFontGlyphRange* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	BirdFontKerning* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (left != NULL);
	g_return_if_fail (right != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = g_strdup (left);
	_g_free0 (_data21_->left);
	_data21_->left = _tmp0_;
	_tmp1_ = g_strdup (right);
	_g_free0 (_data21_->right);
	_data21_->right = _tmp1_;
	_data21_->i = 0;
	_data21_->index = -1;
	bird_font_kerning_classes_get_classes (self, ___lambda324__bird_font_kerning_classes_kerning_class_iterator, _data21_);
	if (G_UNLIKELY (_data21_->index < 0)) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = string_to_string (_data21_->left);
		_tmp3_ = string_to_string (_data21_->right);
		_tmp4_ = g_strconcat ("Kerning class not found for ", _tmp2_, " to ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_warning ("KerningClasses.vala:610: %s", _tmp5_);
		_g_free0 (_tmp5_);
		block21_data_unref (_data21_);
		_data21_ = NULL;
		return;
	}
	_tmp6_ = self->classes_first;
	_tmp7_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp6_, _data21_->index);
	_tmp8_ = (BirdFontGlyphRange*) _tmp7_;
	_bird_font_glyph_range_unref0 (_tmp8_);
	_tmp9_ = self->classes_last;
	_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp9_, _data21_->index);
	_tmp11_ = (BirdFontGlyphRange*) _tmp10_;
	_bird_font_glyph_range_unref0 (_tmp11_);
	_tmp12_ = self->classes_kerning;
	_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp12_, _data21_->index);
	_tmp14_ = (BirdFontKerning*) _tmp13_;
	_g_object_unref0 (_tmp14_);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

void
bird_font_kerning_classes_delete_kerning_for_pair (BirdFontKerningClasses* self,
                                                   const gchar* left,
                                                   const gchar* right)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (left != NULL);
	g_return_if_fail (right != NULL);
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp0_;
		gint _l_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _l_index = 0;
		_tmp0_ = bird_font_kerning_classes_get_spacing_class (self, left);
		_l_list = _tmp0_;
		_tmp1_ = _l_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_l_size = _tmp3_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* l = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_l_index = _l_index + 1;
			_tmp4_ = _l_index;
			_tmp5_ = _l_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _l_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _l_index);
			l = (gchar*) _tmp7_;
			{
				GeeArrayList* _r_list = NULL;
				GeeArrayList* _tmp8_;
				gint _r_size = 0;
				GeeArrayList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _r_index = 0;
				_tmp8_ = bird_font_kerning_classes_get_spacing_class (self, right);
				_r_list = _tmp8_;
				_tmp9_ = _r_list;
				_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				_r_size = _tmp11_;
				_r_index = -1;
				while (TRUE) {
					gint _tmp12_;
					gint _tmp13_;
					gchar* r = NULL;
					GeeArrayList* _tmp14_;
					gpointer _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_r_index = _r_index + 1;
					_tmp12_ = _r_index;
					_tmp13_ = _r_size;
					if (!(_tmp12_ < _tmp13_)) {
						break;
					}
					_tmp14_ = _r_list;
					_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _r_index);
					r = (gchar*) _tmp15_;
					_tmp16_ = l;
					_tmp17_ = r;
					bird_font_kerning_classes_delete_kerning_for_one_pair (self, _tmp16_, _tmp17_);
					_g_free0 (r);
				}
				_g_object_unref0 (_r_list);
			}
			_g_free0 (l);
		}
		_g_object_unref0 (_l_list);
	}
}

static void
bird_font_kerning_classes_delete_kerning_for_one_pair (BirdFontKerningClasses* self,
                                                       const gchar* left,
                                                       const gchar* right)
{
	gboolean has_left = FALSE;
	gboolean has_right = FALSE;
	gchar** p = NULL;
	gint p_length1 = 0;
	gint _p_size_ = 0;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (left != NULL);
	g_return_if_fail (right != NULL);
	_tmp0_ = self->priv->single_kerning;
	_tmp1_ = string_to_string (left);
	_tmp2_ = string_to_string (right);
	_tmp3_ = g_strconcat (_tmp1_, " - ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	has_left = FALSE;
	has_right = FALSE;
	{
		GeeIterator* _k_it = NULL;
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp5_ = self->priv->single_kerning;
		_tmp6_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_k_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gchar* k = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			const gchar* _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gchar** _tmp17_;
			gint _tmp17__length1;
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			_tmp11_ = _k_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _k_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			k = (gchar*) _tmp13_;
			_tmp14_ = k;
			_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, " - ", 0);
			p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
			p = _tmp16_;
			p_length1 = _vala_array_length (_tmp15_);
			_p_size_ = p_length1;
			_tmp17_ = p;
			_tmp17__length1 = p_length1;
			g_return_if_fail (_tmp17__length1 == 2);
			_tmp18_ = p;
			_tmp18__length1 = p_length1;
			_tmp19_ = _tmp18_[0];
			if (g_strcmp0 (_tmp19_, left) == 0) {
				has_left = TRUE;
			}
			_tmp20_ = p;
			_tmp20__length1 = p_length1;
			_tmp21_ = _tmp20_[1];
			if (g_strcmp0 (_tmp21_, right) == 0) {
				has_right = TRUE;
			}
			_g_free0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	if (!has_left) {
		GeeArrayList* _tmp22_;
		_tmp22_ = self->single_kerning_letters_left;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp22_, left);
	}
	if (!has_right) {
		GeeArrayList* _tmp23_;
		_tmp23_ = self->single_kerning_letters_right;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp23_, left);
	}
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
}

void
bird_font_kerning_classes_remove_all_pairs (BirdFontKerningClasses* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	BirdFontToolbox* _tmp5_;
	GeeHashMap* _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->protect_map) {
		g_warning ("KerningClasses.vala:660: Map is protected.");
		return;
	}
	_tmp0_ = self->classes_first;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->classes_last;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = self->classes_kerning;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_tmp3_ = self->single_kerning_letters_left;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	_tmp4_ = self->single_kerning_letters_right;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
	bird_font_glyph_canvas_redraw ();
	_tmp5_ = bird_font_main_window_get_toolbox ();
	if (!bird_font_is_null (_tmp5_)) {
		bird_font_toolbox_redraw_tool_box ();
	}
	_tmp6_ = self->priv->single_kerning;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp6_);
}

guint
bird_font_kerning_classes_get_number_of_pairs (BirdFontKerningClasses* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	guint _tmp9_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->single_kerning;
	_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->classes_first;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = (guint) (_tmp5_ + _tmp8_);
	_g_object_unref0 (_tmp3_);
	result = _tmp9_;
	return result;
}

static void
bird_font_kerning_classes_class_init (BirdFontKerningClassesClass * klass,
                                      gpointer klass_data)
{
	bird_font_kerning_classes_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontKerningClasses_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_classes_finalize;
}

static void
bird_font_kerning_classes_instance_init (BirdFontKerningClasses * self,
                                         gpointer klass)
{
	self->priv = bird_font_kerning_classes_get_instance_private (self);
	self->priv->protect_map = FALSE;
}

static void
bird_font_kerning_classes_finalize (GObject * obj)
{
	BirdFontKerningClasses * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERNING_CLASSES, BirdFontKerningClasses);
	_g_object_unref0 (self->classes_first);
	_g_object_unref0 (self->classes_last);
	_g_object_unref0 (self->classes_kerning);
	_g_object_unref0 (self->priv->single_kerning);
	_g_object_unref0 (self->single_kerning_letters_left);
	_g_object_unref0 (self->single_kerning_letters_right);
	G_OBJECT_CLASS (bird_font_kerning_classes_parent_class)->finalize (obj);
}

static GType
bird_font_kerning_classes_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningClassesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_classes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningClasses), 0, (GInstanceInitFunc) bird_font_kerning_classes_instance_init, NULL };
	GType bird_font_kerning_classes_type_id;
	bird_font_kerning_classes_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontKerningClasses", &g_define_type_info, 0);
	BirdFontKerningClasses_private_offset = g_type_add_instance_private (bird_font_kerning_classes_type_id, sizeof (BirdFontKerningClassesPrivate));
	return bird_font_kerning_classes_type_id;
}

GType
bird_font_kerning_classes_get_type (void)
{
	static volatile gsize bird_font_kerning_classes_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_classes_type_id__once)) {
		GType bird_font_kerning_classes_type_id;
		bird_font_kerning_classes_type_id = bird_font_kerning_classes_get_type_once ();
		g_once_init_leave (&bird_font_kerning_classes_type_id__once, bird_font_kerning_classes_type_id);
	}
	return bird_font_kerning_classes_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

