/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of ConvertXS.xs. Do not edit this file, edit ConvertXS.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "convert/ConvertXS.xs"
/* Copyright 2023-2024 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <stdlib.h>

/* Avoid namespace conflicts. */
#define context perl_context

#define PERLIO_NOT_STDIO 0

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef context

#include "command_ids.h"
#include "element_types.h"
#include "tree_types.h"
#include "option_types.h"
#include "options_data.h"
#include "converter_types.h"
/* non_perl_free */
#include "xs_utils.h"
#include "builtin_commands.h"
#include "errors.h"
#include "convert_to_text.h"
#include "convert_to_texinfo.h"
#include "manipulate_indices.h"
/* for command_location_names new_string_list ... */
#include "utils.h"
#include "command_stack.h"
#include "customization_options.h"
/* for call_common_set_output_perl_encoding */
#include "call_perl_function.h"
#include "document.h"
#include "converter.h"
#include "get_perl_info.h"
#include "build_perl_info.h"
#include "build_html_perl_state.h"
#include "get_converter_perl_info.h"
#include "build_html_perl_info.h"
#include "html_conversion_state.h"
#include "convert_html.h"
#include "format_html.h"
#include "html_prepare_converter.h"
#include "html_conversion_api.h"
#include "html_converter_api.h"
#include "get_html_perl_info.h"

 /* See the NOTE in build_perl_info.c on use of functions related to
    memory allocation */

#line 77 "convert/ConvertXS.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 221 "convert/ConvertXS.c"

XS_EUPXS(XS_Texinfo__Convert__ConvertXS_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_init)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "texinfo_uninstalled_sv, converterdatadir_sv, tp_builddir_sv, top_srcdir_sv");
    {
#line 78 "convert/ConvertXS.xs"
        const char *tp_builddir = 0;
        const char *top_srcdir = 0;
        const char *converterdatadir = 0;
        int texinfo_uninstalled = 0;
#line 235 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	texinfo_uninstalled_sv = ST(0)
;
	SV *	converterdatadir_sv = ST(1)
;
	SV *	tp_builddir_sv = ST(2)
;
	SV *	top_srcdir_sv = ST(3)
;
#line 83 "convert/ConvertXS.xs"
        if (SvOK (texinfo_uninstalled_sv))
          texinfo_uninstalled = SvIV (texinfo_uninstalled_sv);
        if (texinfo_uninstalled)
          {
            if (SvOK (tp_builddir_sv))
              tp_builddir = SvPVbyte_nolen (tp_builddir_sv);
            if (SvOK (top_srcdir_sv))
              top_srcdir = SvPVbyte_nolen (top_srcdir_sv);
          }
        else
          converterdatadir = SvPVbyte_nolen (converterdatadir_sv);

        converter_setup (texinfo_uninstalled, converterdatadir, tp_builddir,
                         top_srcdir);
        RETVAL = 1;
#line 262 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_defaults); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_defaults)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, conf_sv");
    {
#line 114 "convert/ConvertXS.xs"
        CONVERTER_INITIALIZATION_INFO *conf;
        CONVERTER_INITIALIZATION_INFO *format_defaults;
        CONVERTER *self = 0;
        const char *class_name = 0;
        enum converter_format converter_format;
#line 283 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	conf_sv = ST(1)
;
#line 121 "convert/ConvertXS.xs"
        if (SvOK (converter_in))
          {
            if (SvROK (converter_in))
              {
                HV *stash = SvSTASH (SvRV (converter_in));
                class_name = HvNAME (stash);
                self = get_or_create_sv_converter (converter_in, class_name);
              }
            else
              class_name = SvPV_nolen (converter_in);
          }

        converter_format
          = find_perl_converter_class_converter_format (class_name);

        /* Do not pass class_name to avoid error messages, there will
           be an error messages in generic_converter_init (as in Perl)
         */
        conf = get_converter_info_from_sv (conf_sv, 0, 0);

        format_defaults = converter_defaults (converter_format, conf);

        if (conf)
          destroy_converter_initialization_info (conf);

        if (self)
          {
            /* store format_defaults in the C converter */
            const char *key = "converter_descriptor";
            HV *converter_hv = (HV *)SvRV (converter_in);

            self->format_defaults = format_defaults;

           /* the converter needs to be found, nothing else to pass to
              Perl */
           /* NOTE unlikely IV overflow if PERL_QUAD_MAX < SIZE_MAX */
            hv_store (converter_hv, key, strlen (key),
                      newSViv ((IV)self->converter_descriptor), 0);

            RETVAL = newSV (0);
          }
        else
          {
       /* no converter, return format_defaults built to Perl for the class */
            RETVAL
              = build_sv_options_from_options_list (&format_defaults->conf, 0);
            destroy_converter_initialization_info (format_defaults);
          }
#line 338 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_generic_converter_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_generic_converter_init)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "converter_in, format_defaults_sv, conf_sv=0");
    {
#line 175 "convert/ConvertXS.xs"
        CONVERTER *self;
        CONVERTER_INITIALIZATION_INFO *format_defaults;
        CONVERTER_INITIALIZATION_INFO *conf;
        HV *converter_hv;
        HV *stash;
        const char *class_name;
#line 360 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	format_defaults_sv = ST(1)
;
	SV *	conf_sv;

	if (items < 3)
	    conf_sv = 0;
	else {
	    conf_sv = ST(2)
;
	}
#line 182 "convert/ConvertXS.xs"
        stash = SvSTASH (SvRV (converter_in));
        class_name = HvNAME (stash);

        self = get_or_create_sv_converter (converter_in, class_name);
        converter_hv = (HV *)SvRV (converter_in);
        self->hv = converter_hv;

        format_defaults = get_converter_info_from_sv (format_defaults_sv,
                                                      class_name, self);
        /* if format_defaults_sv is undef, it should mean that format_defaults
           has been registered in the C converter */
        if (!format_defaults)
          {
            format_defaults = self->format_defaults;
            self->format_defaults = 0;
          }

        conf = get_converter_info_from_sv (conf_sv, class_name, self);

        set_converter_init_information (self, format_defaults, conf);

        if (format_defaults)
          {
    /* set directly Perl converter keys with non 'valid' customization info */
            set_non_customization_sv (converter_hv, format_defaults_sv,
                                &format_defaults->non_valid_customization);
            destroy_converter_initialization_info (format_defaults);
          }

        if (conf)
          {
    /* set directly Perl converter keys with non 'valid' customization info */
            set_non_customization_sv (converter_hv, conf_sv,
                              &conf->non_valid_customization);

            destroy_converter_initialization_info (conf);
          }

       /*
           fprintf (stderr, "XS|CONVERTER Init from SV: %zu; \n",
                    self->converter_descriptor);
        */

        pass_generic_converter_to_converter_sv (converter_in, self);
#line 418 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_set_document); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_set_document)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, document_in");
    {
#line 231 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 433 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	document_in = ST(1)
;
#line 233 "convert/ConvertXS.xs"
        /* if a converter is properly initialized, the XS converter should
           always be found when XS is used */
        self = converter_set_document_from_sv (converter_in, document_in);
        pass_document_to_converter_sv (self, converter_in, document_in);

        call_common_set_output_perl_encoding (self);
#line 445 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_set_conf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_set_conf)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, option_name, value");
    {
	const char *	option_name = (char *)SvPVbyte_nolen(ST(1));
#line 244 "convert/ConvertXS.xs"
        CONVERTER *self;
        int status = 0;
#line 462 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
	SV *	value = ST(2)
;
#line 247 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "set_conf");
        if (self)
          {
            int get_sv_status;
            OPTION *option
              = find_option_string (self->sorted_options, option_name);

            if (!option)
              message_list_document_error (&self->error_messages,
                                           self->conf, 0,
                                  "unknown customization variable: %s",
                                   option_name);
              /*
              croak_nocontext ("XS: BUG: set_conf: unknown option %s\n",
                               option_name);
               */
            else
              {
                get_sv_status = get_sv_option (option, value, 0,
                                               self->conf, self);
                if (get_sv_status == 0)
                  status = 1;
              }
          }
        RETVAL = status;
#line 495 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_force_conf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_force_conf)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, option_name, value");
    {
	const char *	option_name = (char *)SvPVbyte_nolen(ST(1));
#line 279 "convert/ConvertXS.xs"
        CONVERTER *self;
        int status = 0;
#line 514 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
	SV *	value = ST(2)
;
#line 282 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "force_conf");
        if (self)
          {
            int get_sv_status;
            OPTION *option
              = find_option_string (self->sorted_options, option_name);

            if (!option)
              message_list_document_error (&self->error_messages,
                                           self->conf, 0,
                                  "unknown customization variable: %s",
                                   option_name);
               /*
              croak_nocontext ("XS: BUG: force_conf: unknown option %s\n",
                               option_name);
                */
            else
              {
                /* only possible failure would be a type error */
                get_sv_status = get_sv_option (option, value, 1,
                                               self->conf, self);
                if (get_sv_status == 0)
                  status = 1;
              }
          }
        RETVAL = status;
#line 548 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_conf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_conf)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, option_name");
    {
	const char *	option_name = (char *)SvPVbyte_nolen(ST(1));
#line 315 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 566 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 317 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (self && self->sorted_options)
          {
            const OPTION *option
             = find_option_string (self->sorted_options, option_name);

            if (!option)
              {
                message_list_document_error (&self->error_messages,
                                           self->conf, 0,
                                  "unknown customization variable: %s",
                                   option_name);
              /* in Perl cluck is called, no equivalent here */
               /*
              croak_nocontext ("XS: BUG: get_conf: unknown option %s\n", option_name);
                */

                RETVAL = newSV (0);
              }
            else
              RETVAL = build_sv_option (option, self);
          }
        else
          RETVAL = newSV (0);
#line 595 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_line_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_line_error)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, text, error_location_info, ...");
    {
	const char *	text = (char *)SvPVutf8_nolen(ST(1));
#line 349 "convert/ConvertXS.xs"
        CONVERTER *self;
        int continuation = 0;
#line 614 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	error_location_info = ST(2)
;
#line 352 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (items > 3 && SvOK(ST(3)))
          continuation = SvIV (ST(3));

        if (self)
          {
            get_line_message (self, MSG_error, continuation,
                              error_location_info, text);
          }
#line 629 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_line_warn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_line_warn)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, text, error_location_info, ...");
    {
	const char *	text = (char *)SvPVutf8_nolen(ST(1));
#line 367 "convert/ConvertXS.xs"
        CONVERTER *self;
        int continuation = 0;
#line 646 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	error_location_info = ST(2)
;
#line 370 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (items > 3 && SvOK(ST(3)))
          continuation = SvIV (ST(3));

        if (self)
          {
            get_line_message (self, MSG_warning, continuation,
                              error_location_info, text);
          }
#line 661 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_document_error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_document_error)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "converter_in, text, ...");
    {
	const char *	text = (char *)SvPVutf8_nolen(ST(1));
#line 385 "convert/ConvertXS.xs"
        CONVERTER *self;
        int continuation = 0;
#line 678 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 388 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (items > 2 && SvOK(ST(2)))
          continuation = SvIV (ST(2));
        if (self)
          {
            message_list_document_formatted_message (&self->error_messages,
              self->conf, MSG_document_error, continuation, text);
          }
#line 690 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_document_warn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_document_warn)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "converter_in, text, ...");
    {
	const char *	text = (char *)SvPVutf8_nolen(ST(1));
#line 402 "convert/ConvertXS.xs"
        CONVERTER *self;
        int continuation = 0;
#line 707 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 405 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (items > 2 && SvOK(ST(2)))
          continuation = SvIV (ST(2));
        if (self)
          {
            message_list_document_formatted_message (&self->error_messages,
                     self->conf, MSG_document_warning, continuation, text);
          }
#line 719 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_set_global_document_commands); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_converter_set_global_document_commands)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, commands_location_string, selected_commands");
    {
#line 417 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 734 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	char *	commands_location_string = (char *)SvPV_nolen(ST(1))
;
	SV *	selected_commands = ST(2)
;
#line 419 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (self)
          {
            int command_location = -1;
            int i;
            AV *selected_commands_av = (AV *) SvRV (selected_commands);
            SSize_t in_commands_nr = AvFILL (selected_commands_av) +1;
            enum command_id *cmd_list = (enum command_id *) malloc
                          ((in_commands_nr+1) * sizeof (enum command_id));
            /* actual command index/number without unknown commands */
            int command_nr = 0;

            for (i = 0; command_location_names[i]; i++)
              {
                if (!strcmp (commands_location_string,
                             command_location_names[i]))
                  {
                    command_location = i;
                    break;
                  }
              }
            if (command_location < 0)
              {
                fprintf (stderr,
                         "ERROR: unknown command location: %s\n",
                         commands_location_string);
                return;
              }

            for (i = 0; i < in_commands_nr; i++)
              {
                SV **command_sv = av_fetch (selected_commands_av, i, 0);
                if (command_sv)
                  {
                    const char *command_name = SvPV_nolen (*command_sv);
                    enum command_id cmd
                       = lookup_builtin_command (command_name);
                    if (cmd <= 0)
                      {
                        fprintf (stderr,
                                 "ERROR: unknown command (%d): %s\n",
                                 i, command_name);
                      }
                    else
                      {
                        cmd_list[command_nr] = cmd;
                        command_nr++;
                      }
                  }
              }
            cmd_list[command_nr] = 0;
            set_global_document_commands (self, command_location, cmd_list);
            free (cmd_list);
          }
#line 796 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_converter_indices_sorted_by_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_converter_indices_sorted_by_index)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_sv");
    {
#line 477 "convert/ConvertXS.xs"
        CONVERTER *self;
        const INDEX_SORTED_BY_INDEX *index_entries_by_index = 0;
        HV *converter_hv;
        SV **document_sv;
        char *language = 0;
#line 815 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_sv = ST(0)
;
#line 483 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_sv,
                                 "get_converter_indices_sorted_by_index");
        if (self)
          index_entries_by_index
            = get_converter_indices_sorted_by_index (self, &language);

        converter_hv = (HV *) SvRV (converter_sv);
        document_sv = hv_fetch (converter_hv, "document",
                                strlen ("document"), 0);
        RETVAL = 0;
        if (document_sv && self->document->hv)
          {
            /* The sorted indices are cached in the same place as in Perl code
               gathered at document initialization.
               Either Perl code or XS code is used, so this is for consistency
               not really for interoperability */
            /* set to document "sorted_indices_by_index" */
            HV *language_document_sorted_indices_hv = 0;
            /* try first to get sorted index cached in document
               "sorted_indices_by_index".
               Gather the hash to use to cache too in
               language_document_sorted_indices_hv, for use if sorted index is
               not found */
            if (language)
              {
                HV *document_hv = (HV *) self->document->hv;
                SV *index_entries_by_index_sv
                 = get_language_document_hv_sorted_indices (document_hv,
                                    "sorted_indices_by_index", language,
                                  &language_document_sorted_indices_hv);
                if (index_entries_by_index_sv)
                  RETVAL = SvREFCNT_inc (index_entries_by_index_sv);
              }
            if (!RETVAL)
              {
                /* build the sorted indices from C */
                SV *indices_information_sv
                  = document_indices_information (*document_sv);

                if (index_entries_by_index && indices_information_sv
                    && SvOK (indices_information_sv))
                  {
                    HV *indices_information_hv
                      = (HV *) SvRV (indices_information_sv);
                    HV *index_entries_by_index_hv
                     = build_sorted_indices_by_index (index_entries_by_index,
                                                      indices_information_hv);
                    RETVAL
                      = newRV_inc ((SV *) index_entries_by_index_hv);
                   /* the hash for caching was found or created and the sorting
                      language is set, cache the sorted indices */
                    if (language_document_sorted_indices_hv && language)
                      {
                        hv_store (language_document_sorted_indices_hv,
                              language, strlen(language),
                              newRV_inc ((SV *) index_entries_by_index_hv), 0);
                      }
                  }
              }
          }
        if (!RETVAL)
          RETVAL = newSV (0);
#line 882 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_converter_indices_sorted_by_letter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_converter_indices_sorted_by_letter)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_sv");
    {
#line 551 "convert/ConvertXS.xs"
        CONVERTER *self;
        const INDEX_SORTED_BY_LETTER *index_entries_by_letter = 0;
        HV *converter_hv;
        SV **document_sv;
        char *language;
#line 903 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_sv = ST(0)
;
#line 557 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_sv,
                                 "get_converter_indices_sorted_by_letter");
        if (self)
          index_entries_by_letter
            = get_converter_indices_sorted_by_letter (self, &language);

        converter_hv = (HV *) SvRV (converter_sv);
        document_sv = hv_fetch (converter_hv, "document",
                                strlen ("document"), 0);
        RETVAL = 0;
        if (document_sv && self->document->hv)
          {
            /* The sorted indices are cached in the same place as in Perl code
               gathered at document initialization.
               Either Perl code or XS code is used, so this is for consistency
               not really for interoperability */
            /* set to document "sorted_indices_by_letter" */
            HV *language_document_sorted_indices_hv;
            /* try first to get sorted index cached in document
               "sorted_indices_by_letter".
               Gather the hash to use to cache too in
               language_document_sorted_indices_hv, for use if sorted index is
               not found */
            if (language)
              {
                HV *document_hv = (HV *) self->document->hv;
                SV *index_entries_by_index_sv
                 = get_language_document_hv_sorted_indices (document_hv,
                                    "sorted_indices_by_letter", language,
                                  &language_document_sorted_indices_hv);
                if (index_entries_by_index_sv)
                  RETVAL = SvREFCNT_inc (index_entries_by_index_sv);
              }
            if (!RETVAL)
              {
                /* build the sorted indices from C */
                SV *indices_information_sv
                 = document_indices_information (*document_sv);

                if (index_entries_by_letter && indices_information_sv
                    && SvOK (indices_information_sv))
                  {
                    HV *indices_information_hv
                     = (HV *) SvRV (indices_information_sv);
                    HV *index_entries_by_letter_hv
                     = build_sorted_indices_by_letter (index_entries_by_letter,
                                                       indices_information_hv);
                    RETVAL
                     = newRV_inc ((SV *) index_entries_by_letter_hv);
                    /* the hash for caching was found or created, cache the
                       sorted indices */
                    if (language_document_sorted_indices_hv)
                      {
                        hv_store (language_document_sorted_indices_hv,
                              language, strlen(language),
                              newRV_inc ((SV *) index_entries_by_letter_hv), 0);
                      }
                  }
              }
          }
        if (!RETVAL)
          RETVAL = newSV (0);
#line 970 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_unclosed_stream); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_unclosed_stream)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, file_path");
    {
	const char *	file_path = (char *)SvPVbyte_nolen(ST(1));
#line 629 "convert/ConvertXS.xs"
        CONVERTER *self;
        OUTPUT_FILES_INFORMATION *output_files_information;
        FILE_STREAM_LIST *unclosed_files;
        FILE *result = 0;
#line 991 "convert/ConvertXS.c"
	FILE *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 634 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "get_unclosed_stream");
        output_files_information = &self->output_files_information;
        unclosed_files = &output_files_information->unclosed_files;
        if (unclosed_files->number > 0)
          {
            size_t i;
            for (i = 0; i < unclosed_files->number; i++)
              {
                FILE_STREAM *file_stream = &unclosed_files->list[i];
                if (!strcmp (file_path, file_stream->file_path))
                  {
                    result = file_stream->stream;
                    break;
                  }
              }
          }
        RETVAL = result;
#line 1014 "convert/ConvertXS.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		GV *gv = (GV *)sv_newmortal();
		PerlIO *fp = PerlIO_importFILE(RETVAL,0);
		gv_init_pvn(gv, gv_stashpvs("Texinfo::Convert::ConvertXS",1),"__ANONIO__",10,0);
		if ( fp && do_open(gv, "+<&", 3, FALSE, 0, 0, fp) ) {
		    SV *rv = newRV_inc((SV*)gv);
		    rv = sv_bless(rv, GvSTASH(gv));
		    RETVALSV = sv_2mortal(rv);
		}
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_converter_errors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_get_converter_errors)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 658 "convert/ConvertXS.xs"
        AV *errors_av;
        CONVERTER *self = 0;
#line 1045 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 661 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (self && self->error_messages.number)
          {
            errors_av = build_errors (self->error_messages.list,
                                      self->error_messages.number);
            wipe_error_message_list (&self->error_messages);
          }
        else
          errors_av = newAV ();

        RETVAL = newRV_noinc ((SV *) errors_av);
#line 1061 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_reset_converter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_reset_converter)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 678 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1078 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 680 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (self)
          reset_converter (self);
#line 1085 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_destroy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_destroy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 687 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1100 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 689 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (self)
          destroy_converter (self);
#line 1107 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_plain_texinfo_convert_tree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_plain_texinfo_convert_tree)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tree_in");
    {
#line 696 "convert/ConvertXS.xs"
        DOCUMENT *document = 0;
#line 1122 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	tree_in = ST(0)
;
#line 698 "convert/ConvertXS.xs"
        /* caller checks that there is a descriptor */
        document = get_sv_tree_document (tree_in, "plain_texinfo_convert_tree");
        if (document)
          {
            char *result = convert_to_texinfo (document->tree);
            RETVAL = newSVpv_utf8 (result, 0);
            non_perl_free (result);
          }
        else
          RETVAL = newSV(0);
#line 1137 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_text_convert_tree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_text_convert_tree)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "options_in, tree_in");
    {
#line 714 "convert/ConvertXS.xs"
        DOCUMENT *document = 0;
#line 1154 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	options_in = ST(0)
;
	SV *	tree_in = ST(1)
;
#line 716 "convert/ConvertXS.xs"
        /* The caller checks that there is a descriptor */
        document = get_sv_tree_document (tree_in, "text_convert_tree");
        if (document)
          {
            char *result;
            TEXT_OPTIONS *text_options;

            if (SvOK (options_in))
              text_options = copy_sv_options_for_convert_text (options_in);
            else
              text_options = new_text_options ();

            text_options->document_descriptor = document->descriptor;

            result = convert_to_text (document->tree, text_options);

            destroy_text_options (text_options);
            RETVAL = newSVpv_utf8 (result, 0);
            non_perl_free (result);
          }
        else
          {
            RETVAL = newSV(0);
          }
#line 1185 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_format_setup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_format_setup)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	html_format_setup();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_converter_initialize_beginning); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_converter_initialize_beginning)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 751 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1216 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 753 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_converter_initialize_beginning");
        if (self)
          {
            html_converter_initialize_beginning (self);
            html_pass_xtmlxref (&self->htmlxref, converter_in);
          }
#line 1227 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_converter_get_customization_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_converter_get_customization_sv)
{
    dVAR; dXSARGS;
    if (items != 18)
       croak_xs_usage(cv,  "converter_in, default_formatting_references, default_css_string_formatting_references, default_commands_open, default_commands_conversion, default_css_string_commands_conversion, default_types_open, default_types_conversion, default_css_string_types_conversion, default_output_units_conversion, default_special_unit_body, customized_upper_case_commands, customized_type_formatting, customized_accent_entities, customized_style_commands, customized_no_arg_commands_formatting, customized_special_unit_info, customized_direction_strings");
    {
#line 764 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1242 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	default_formatting_references = ST(1)
;
	SV *	default_css_string_formatting_references = ST(2)
;
	SV *	default_commands_open = ST(3)
;
	SV *	default_commands_conversion = ST(4)
;
	SV *	default_css_string_commands_conversion = ST(5)
;
	SV *	default_types_open = ST(6)
;
	SV *	default_types_conversion = ST(7)
;
	SV *	default_css_string_types_conversion = ST(8)
;
	SV *	default_output_units_conversion = ST(9)
;
	SV *	default_special_unit_body = ST(10)
;
	SV *	customized_upper_case_commands = ST(11)
;
	SV *	customized_type_formatting = ST(12)
;
	SV *	customized_accent_entities = ST(13)
;
	SV *	customized_style_commands = ST(14)
;
	SV *	customized_no_arg_commands_formatting = ST(15)
;
	SV *	customized_special_unit_info = ST(16)
;
	SV *	customized_direction_strings = ST(17)
;
#line 766 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_converter_customization_sv");

        /* initialize first the special unit info, as the special unit
           directions are needed for the remainder of initialization.
           Therefore special unit Perl customization needs to be read
           and special unit initialization in C code needs to be run
           too before doing the remaining */
        html_converter_init_special_unit_sv (converter_in,
                                             customized_special_unit_info);
        html_converter_init_special_unit (self);
        html_converter_get_customization_sv (converter_in,
                         default_formatting_references,
                         default_css_string_formatting_references,
                         default_commands_open,
                         default_commands_conversion,
                         default_css_string_commands_conversion,
                         default_types_open,
                         default_types_conversion,
                         default_css_string_types_conversion,
                         default_output_units_conversion,
                         default_special_unit_body,
                         customized_upper_case_commands,
                         customized_type_formatting,
                         customized_accent_entities,
                         customized_style_commands,
                         customized_no_arg_commands_formatting,
                         customized_direction_strings);

        html_converter_customize (self);

   /* at that point, the format specific informations, in particular the
      direction names is available, such that the directions can be set
      in customization variables needing them (icons, buttons). */
   /* fill options using information in associated Perl data */
        html_fill_sv_options (self->conf, self);
   /* fill options with C only information not associated with Perl data */
        html_fill_options_directions (self->conf, self);
#line 1318 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_conversion_initialization); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_conversion_initialization)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "converter_in, context, document_in=0");
    {
#line 813 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1333 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	const char *	context = (const char *)SvPV_nolen(ST(1))
;
	SV *	document_in;

	if (items < 3)
	    document_in = 0;
	else {
	    document_in = ST(2)
;
	}
#line 815 "convert/ConvertXS.xs"
        /* if a converter is properly initialized, the XS converter should
           always be found when XS is used */
        self = converter_set_document_from_sv (converter_in, document_in);

        html_initialize_output_state (self, context);
        /* could be useful if something from Perl is needed
        html_conversion_initialization_sv (converter_in, self);
        */

        html_pass_conversion_initialization (self, converter_in, document_in);
#line 1357 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_setup_output); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_setup_output)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 829 "convert/ConvertXS.xs"
        CONVERTER *self;
        int status = 0;
#line 1373 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 832 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_setup_output");
        RETVAL = newSV (0);
        if (self)
          {
            char *paths[5];

            status = html_setup_output (self, paths);
            if (status)
              {
                AV *result_av = newAV ();
                int i;

                for (i = 0; i < 4; i++)
                  {
                    SV *sv = newSVpv_utf8 (paths[i], 0);
                    av_push (result_av, sv);
                  }
                RETVAL = newRV_noinc ((SV *) result_av);

                for (i = 0; i < 5; i++)
                  {
                    non_perl_free (paths[i]);
                  }
              }

            html_pass_converter_setup_state (self, converter_in);
          }
#line 1405 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_setup_convert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_setup_convert)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 865 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1422 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 867 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_setup_convert");

        if (self)
          {
            html_setup_convert (self);
            html_pass_converter_setup_state (self, converter_in);
          }
#line 1433 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_conversion_finalization); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_conversion_finalization)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 878 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 1448 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 880 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_conversion_finalization");
        if (self)
          {
            html_conversion_finalization (self);

            html_check_transfer_state_finalization (self);
          }
#line 1459 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_conversion_units); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_conversion_units)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "converter_in, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 894 "convert/ConvertXS.xs"
        CONVERTER *self;
        SV *output_units_sv;
        SV *special_units_sv;
        SV *associated_special_units_sv;
#line 1479 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 899 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_prepare_conversion_units");

        html_prepare_conversion_units (self);

        html_pass_conversion_output_units (self, converter_in,
                                     &output_units_sv, &special_units_sv,
                                     &associated_special_units_sv);

        /* calls Perl customization functions, so need to be done after
           build_output_units_list calls to be able to retrieve Perl
           output units references */
        html_prepare_conversion_units_targets (self, self->document_name);

        EXTEND(SP, 3);
        PUSHs(sv_2mortal(output_units_sv));
        PUSHs(sv_2mortal(special_units_sv));
        PUSHs(sv_2mortal(associated_special_units_sv));
#line 1501 "convert/ConvertXS.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_units_directions_files); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_units_directions_files)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "converter_in, output_units_in, special_units_in, associated_special_units_in, output_file, destination_directory, output_filename, document_name");
    {
	const char *	output_file = (char *)SvPVutf8_nolen(ST(4));
	const char *	destination_directory = (char *)SvPVutf8_nolen(ST(5));
	const char *	output_filename = (char *)SvPVutf8_nolen(ST(6));
	const char *	document_name = (char *)SvPVutf8_nolen(ST(7));
#line 928 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
#line 1521 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	output_units_in = ST(1)
;
	SV *	special_units_in = ST(2)
;
	SV *	associated_special_units_in = ST(3)
;
#line 930 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_prepare_units_directions_files");
        html_prepare_units_directions_files (self,
                   output_file, destination_directory, output_filename,
                                document_name);

        html_pass_units_directions_files (self, converter_in, output_units_in,
                                          special_units_in,
                                          associated_special_units_in);

        RETVAL = newSV (0);
#line 1543 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_output_units_global_targets); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_output_units_global_targets)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "converter_in, output_units_in, special_units_in, associated_special_units_in");
    {
#line 950 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
#line 1560 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	output_units_in = ST(1)
;
	SV *	special_units_in = ST(2)
;
	SV *	associated_special_units_in = ST(3)
;
#line 952 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_prepare_output_units_global_targets");
        html_prepare_output_units_global_targets (self);

        html_pass_output_units_global_targets (self, output_units_in,
                              special_units_in, associated_special_units_in);
#line 1576 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_simpletitle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_simpletitle)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 962 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
#line 1591 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 964 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_prepare_simpletitle");
        if (self)
          {
            html_prepare_simpletitle (self);
          }
#line 1600 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_converted_output_info); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_converted_output_info)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, output_file, output_filename, ...");
    {
	const char *	output_file = (char *)SvPVutf8_nolen(ST(1));
	const char *	output_filename = (char *)SvPVutf8_nolen(ST(2));
#line 976 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
        int status = 0;
#line 1618 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 979 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_prepare_converted_output_info");
        if (self)
          status = html_prepare_converted_output_info (self, output_file,
                                                       output_filename);
        RETVAL = status;
#line 1630 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_title_titlepage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_title_titlepage)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, output_file, output_filename, ...");
    {
	const char *	output_file = (char *)SvPVutf8_nolen(ST(1));
	const char *	output_filename = (char *)SvPVutf8_nolen(ST(2));
#line 996 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
#line 1649 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 998 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_prepare_title_titlepage");
        if (self)
          {
            html_prepare_title_titlepage (self, output_file, output_filename);
          }
#line 1658 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_convert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_convert)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "converter_in, ...");
    {
#line 1009 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
        char *result;
#line 1674 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1012 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_convert_convert");
        result = html_convert_convert (self, self->document->tree);
        build_html_formatting_state (self);
        RETVAL = newSVpv_utf8 (result, 0);
        non_perl_free (result);
#line 1684 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_output); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_output)
{
    dVAR; dXSARGS;
    if (items < 5)
       croak_xs_usage(cv,  "converter_in, output_file, destination_directory, output_filename, document_name, ...");
    {
	const char *	output_file = (char *)SvPVutf8_nolen(ST(1));
	const char *	destination_directory = (char *)SvPVutf8_nolen(ST(2));
	const char *	output_filename = (char *)SvPVutf8_nolen(ST(3));
	const char *	document_name = (char *)SvPVutf8_nolen(ST(4));
#line 1029 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
        SV *result_sv = 0;
#line 1706 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1032 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_convert_output");
        if (self && self->document)
          {
            char *result = html_convert_output (self, self->document->tree,
                       output_file, destination_directory, output_filename,
                       document_name);

            build_html_formatting_state (self);

            if (result)
              {
                result_sv = newSVpv_utf8 (result, 0);
                non_perl_free (result);
              }

            build_output_files_information (converter_in,
                                            &self->output_files_information);
          }

        if (result_sv)
          RETVAL = result_sv;
        else
          RETVAL = newSV (0);
#line 1734 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_node_redirection_page); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_prepare_node_redirection_page)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, element_sv, redirection_filename");
    {
	const char *	redirection_filename = (char *)SvPVutf8_nolen(ST(2));
#line 1064 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *redirection_page = 0;
        const ELEMENT *element;
#line 1754 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 1068 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                             "html_prepare_node_redirection_page", &self);
        if (element)
          redirection_page
                = html_prepare_node_redirection_page (self, element,
                                                      redirection_filename);

        if (redirection_page)
          {
            RETVAL = newSVpv_utf8 (redirection_page, 0);
            non_perl_free (redirection_page);
          }
        else
          RETVAL = newSV (0);
#line 1775 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_node_redirections); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_node_redirections)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, output_file, destination_directory, ...");
    {
	const char *	output_file = (char *)SvPVutf8_nolen(ST(1));
	const char *	destination_directory = (char *)SvPVutf8_nolen(ST(2));
#line 1091 "convert/ConvertXS.xs"
        CONVERTER *self;
        int status = -1;
#line 1795 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1094 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_node_redirections");
        if (self)
          {
            status = html_node_redirections (self, output_file,
                                             destination_directory);
          }
        if (status >= 0)
          RETVAL = newSViv (status);
        else
          RETVAL = newSV (0);
#line 1810 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_output); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_output)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, document_in");
    {
#line 1111 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *paths[5];
        int status;
        char *result = 0;
        int i;
        const char *output_file;
        const char *destination_directory;
        const char *output_filename;
        const char *document_name;
        SV *output_units_sv;
        SV *special_units_sv;
        SV *associated_special_units_sv;
#line 1838 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	document_in = ST(1)
;
#line 1124 "convert/ConvertXS.xs"
        /* html_conversion_initialization */
        self = converter_set_document_from_sv (converter_in, document_in);

        html_initialize_output_state (self, "_output");
        /* could be useful if something from Perl is needed
        html_conversion_initialization_sv (converter_in, self);
         */

        html_pass_conversion_initialization (self, converter_in, document_in);

        /* html_setup_output */
        status = html_setup_output (self, paths);
        if (!status)
          {
            memset (paths, 0, 5 * sizeof (char *));
            goto finalization;
          }

        html_pass_converter_setup_state (self, converter_in);

        output_file = paths[0];
        destination_directory = paths[1];
        output_filename = paths[2];
        document_name = paths[3];

        /* html_prepare_conversion_units */
        html_prepare_conversion_units (self);

        html_pass_conversion_output_units (self, converter_in,
                                     &output_units_sv, &special_units_sv,
                                     &associated_special_units_sv);

        /* calls Perl customization functions, so need to be done after
            build_output_units_list calls to be able to retrieve Perl
            output units references */
        html_prepare_conversion_units_targets (self, self->document_name);

        /* html_translate_names */
        html_translate_names (self);
        build_html_formatting_state (self);

        /* html_prepare_units_directions_files */
        html_prepare_units_directions_files (self,
                   output_file, destination_directory, output_filename,
                                document_name);

        html_pass_units_directions_files (self, converter_in, output_units_sv,
                                          special_units_sv,
                                          associated_special_units_sv);

        /* html_prepare_converted_output_info */
        status = html_prepare_converted_output_info (self, output_file,
                                                     output_filename);

        if (!status)
          goto finalization;

        /* html_convert_output */
        if (self->document)
          {
            result = html_convert_output (self, self->document->tree,
                        output_file, destination_directory, output_filename,
                        document_name);

            build_html_formatting_state (self);

            build_output_files_information (converter_in,
                                            &self->output_files_information);
          }

        if (!result)
          goto finalization;

        if (strlen (result) && !strlen (output_file))
          {
            if (self->conf->TEST.o.integer <= 0 )
              {
    /* This case is unlikely to happen, as there is no output file
       only if formatting is called as convert, which only happens in tests.
     */
                html_do_js_files (self);
              }
            goto finalization;
          }

        /* output to a file only */
        non_perl_free (result);
        result = 0;

        status = html_finish_output (self, output_file, destination_directory);

      finalization:
        for (i = 0; i < 5; i++)
          {
            non_perl_free (paths[i]);
          }
        /* html_conversion_finalization */
        html_conversion_finalization (self);

        html_check_transfer_state_finalization (self);

        if (result)
          {
            RETVAL = newSVpv_utf8 (result, 0);
            non_perl_free (result);
          }
        else
          RETVAL = newSV (0);
#line 1953 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, document_in");
    {
#line 1239 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *result;
        SV *output_units_sv;
        SV *special_units_sv;
        SV *associated_special_units_sv;
#line 1974 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	document_in = ST(1)
;
#line 1245 "convert/ConvertXS.xs"
        /* html_conversion_initialization */
        self = converter_set_document_from_sv (converter_in, document_in);

        html_initialize_output_state (self, "_convert");
        /* could be useful if something from Perl is needed
        html_conversion_initialization_sv (converter_in, self);
         */

        html_pass_conversion_initialization (self, converter_in, document_in);

        /* html_setup_convert */
        html_setup_convert (self);
        html_pass_converter_setup_state (self, converter_in);

        /* html_prepare_conversion_units */
        html_prepare_conversion_units (self);

        html_pass_conversion_output_units (self, converter_in,
                                     &output_units_sv, &special_units_sv,
                                     &associated_special_units_sv);

        /* calls Perl customization functions, so need to be done after
           build_output_units_list calls to be able to retrieve Perl
           output units references */
        html_prepare_conversion_units_targets (self, self->document_name);

        /* html_prepare_output_units_global_targets */
        /* setup global targets.  It is not clearly relevant to have those
           global targets when called as convert, but the Top global
           unit directions is often referred to in code, so at least this
           global target needs to be setup.
           Since the relative directions are not set, this leads to lone
           global direction buttons such as [Contents] or [Index] appearing
           in otherwise empty navigation headings if those global directions
           are set and present in the buttons, as is the case in the default
           buttons.  For example in converters_tests/ref_in_sectioning
           or converters_tests/sections_and_printindex.
         */
        html_prepare_output_units_global_targets (self);

        html_pass_output_units_global_targets (self, output_units_sv,
                               special_units_sv, associated_special_units_sv);

        /* html_translate_names */
        /* setup untranslated strings */
        html_translate_names (self);
        build_html_formatting_state (self);

        /* html_prepare_simpletitle */
        html_prepare_simpletitle (self);

        /* html_prepare_title_titlepage */
        /* title.  Not often set in the default case, as convert() is only
           used in the *.t tests, and a title requires both simpletitle_tree
           and SHOW_TITLE set, with the default formatting function.
         */
        html_prepare_title_titlepage (self, "", "");

        /* html_convert_convert */
        /* main conversion here */
        result = html_convert_convert (self, self->document->tree);
        build_html_formatting_state (self);

        /* html_conversion_finalization */
        html_conversion_finalization (self);

        html_check_transfer_state_finalization (self);

        RETVAL = newSVpv_utf8 (result, 0);
        non_perl_free (result);
#line 2051 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_id)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, id");
    {
	const char *	id = (char *)SvPVutf8_nolen(ST(1));
#line 1326 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2069 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1328 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_register_id");
        if (self)
         /* note that we do not care about having the same id twice */
          html_register_id (self, id);
#line 2077 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_id_is_registered); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_id_is_registered)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, id");
    {
	const char *	id = (char *)SvPVutf8_nolen(ST(1));
#line 1338 "convert/ConvertXS.xs"
        CONVERTER *self;
        int found = 0;
#line 2094 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1341 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_id_is_registered");
        if (self)
          found = html_id_is_registered (self, id);
        RETVAL = found;
#line 2104 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_new_document_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_new_document_context)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "converter_in, context_name, ...");
    {
#line 1352 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *document_global_context = 0;
        const char *block_command_name = 0;
        enum command_id block_command = 0;
#line 2124 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	char *	context_name = (char *)SvPV_nolen(ST(1))
;
#line 1357 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_new_document_context");
        if (items > 2 && SvOK(ST(2)))
          document_global_context = SvPVutf8_nolen (ST(2));
        if (items > 3 && SvOK(ST(3)))
          block_command_name = SvPVutf8_nolen (ST(3));
        if (block_command_name)
          block_command = lookup_builtin_command (block_command_name);

        if (self)
          {
            html_new_document_context (self, context_name,
                                       document_global_context, block_command);
          }
#line 2143 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_pop_document_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_pop_document_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1374 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2158 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1376 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_new_document_context");
        if (self)
          {
            html_pop_document_context (self);
          }
#line 2167 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_open_command_update_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_open_command_update_context)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, command_name");
    {
#line 1385 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2182 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
	char *	command_name = (char *)SvPV_nolen(ST(1))
;
#line 1387 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_open_command_update_context");
        RETVAL = 0;
        if (self)
          {
            enum command_id cmd = lookup_builtin_command (command_name);
            RETVAL = html_open_command_update_context (self, cmd);
          }
#line 2198 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_command_update_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_command_update_context)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, command_name");
    {
#line 1401 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2215 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	char *	command_name = (char *)SvPV_nolen(ST(1))
;
#line 1403 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_convert_command_update_context");
        if (self)
          {
            enum command_id cmd = lookup_builtin_command (command_name);
            html_convert_command_update_context (self, cmd);
          }
#line 2228 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_open_type_update_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_open_type_update_context)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, type_name");
    {
#line 1414 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2243 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	char *	type_name = (char *)SvPV_nolen(ST(1))
;
#line 1416 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_open_type_update_context");
        if (self)
          {
            enum element_type type = find_element_type (type_name);
            html_open_type_update_context (self, type);
          }
#line 2256 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_type_update_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_type_update_context)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, type_name");
    {
#line 1427 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2271 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	char *	type_name = (char *)SvPV_nolen(ST(1))
;
#line 1429 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_convert_type_update_context");
        if (self)
          {
            enum element_type type = find_element_type (type_name);
            html_convert_type_update_context (self, type);
          }
#line 2284 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_code_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_code_context)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, code");
    {
#line 1440 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2299 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	int	code = (int)SvIV(ST(1))
;
#line 1442 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_set_code_context");
        if (self)
          html_set_code_context (self, code);
#line 2309 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_pop_code_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_pop_code_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1450 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2324 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1452 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_pop_code_context");
        if (self)
          html_pop_code_context (self);
#line 2332 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_string_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_string_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1460 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2347 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1462 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_set_string_context");
        if (self)
          html_set_string_context (self);
#line 2355 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_unset_string_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_unset_string_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1470 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2370 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1472 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_unset_string_context");
        if (self)
          html_unset_string_context (self);
#line 2378 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_raw_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_raw_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1480 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2393 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1482 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_set_raw_context");
        if (self)
          html_set_raw_context (self);
#line 2401 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_unset_raw_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_unset_raw_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1490 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2416 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1492 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_unset_raw_context");
        if (self)
          html_unset_raw_context (self);
#line 2424 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_multiple_conversions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_multiple_conversions)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, multiple_pass_sv");
    {
#line 1500 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2439 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	multiple_pass_sv = ST(1)
;
#line 1502 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_set_multiple_conversions");
        if (self)
          {
            char *multiple_pass;
            if (SvOK (multiple_pass_sv))
              multiple_pass = SvPVutf8_nolen (multiple_pass_sv);
            else
              multiple_pass = 0;
            html_set_multiple_conversions (self, multiple_pass);
          }
#line 2456 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_unset_multiple_conversions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_unset_multiple_conversions)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1517 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 2471 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1519 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_unset_multiple_conversions");
        if (self)
          html_unset_multiple_conversions (self);
#line 2479 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_multi_expanded); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_multi_expanded)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1527 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *multi_expanded = 0;
#line 2495 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1530 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_multi_expanded");
        if (self)
          multi_expanded = html_in_multi_expanded (self);

        if (multi_expanded)
          RETVAL = newSVpv_utf8 (multi_expanded, 0);
        else
          RETVAL = newSV (0);
#line 2509 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_debug_print_html_contexts); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_debug_print_html_contexts)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1546 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2526 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1548 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_debug_print_html_contexts");
        if (self)
          {
            char *result = debug_print_html_contexts (self);
            RETVAL = newSVpv_utf8 (result, 0);
            non_perl_free (result);
          }
        else
          RETVAL = newSVpv_utf8 ("", 0);
#line 2541 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_info); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_info)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, converter_info");
    {
#line 1564 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2558 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	const char *	converter_info = (const char *)SvPV_nolen(ST(1))
;
#line 1566 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_get_info");
        RETVAL = pass_sv_converter_info (self, converter_info, converter_in);
#line 2568 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_math); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_math)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1575 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2585 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1577 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_math");
        RETVAL = html_in_math (self);
#line 2594 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_preformatted_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_preformatted_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1586 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2611 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1588 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_preformatted_context");
        RETVAL = html_in_preformatted_context (self);
#line 2620 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_inside_preformatted); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_inside_preformatted)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1597 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2637 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1599 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_inside_preformatted");
        RETVAL = html_inside_preformatted (self);
#line 2646 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_upper_case); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_upper_case)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1608 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2663 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1610 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_upper_case");
        RETVAL = html_in_upper_case (self);
#line 2672 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_non_breakable_space); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_non_breakable_space)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1619 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2689 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1621 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_non_breakable_space");
        RETVAL = html_in_non_breakable_space (self);
#line 2698 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_space_protected); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_space_protected)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1630 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2715 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1632 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_space_protected");
        RETVAL = html_in_space_protected (self);
#line 2724 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_code); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_code)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1641 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2741 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1643 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_code");
        RETVAL = html_in_code (self);
#line 2750 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1652 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2767 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1654 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_string");
        RETVAL = html_in_string (self);
#line 2776 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_verbatim); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_verbatim)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1663 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2793 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1665 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_verbatim");
        RETVAL = html_in_verbatim (self);
#line 2802 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_raw); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_raw)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1674 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2819 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1676 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_raw");
        RETVAL = html_in_raw (self);
#line 2828 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_multiple_conversions); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_multiple_conversions)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1685 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2845 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1687 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_in_multiple_conversions");
        RETVAL = self->multiple_conversions;
#line 2854 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_paragraph_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_paragraph_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1696 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2871 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1698 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_paragraph_number");
        RETVAL = html_paragraph_number (self);
#line 2880 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_preformatted_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_preformatted_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1707 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 2897 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1709 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_preformatted_number");
        RETVAL = html_preformatted_number (self);
#line 2906 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_top_block_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_top_block_command)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1718 "convert/ConvertXS.xs"
        const CONVERTER *self;
        enum command_id cmd;
#line 2924 "convert/ConvertXS.c"
	const char *	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1721 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_top_block_command");
        cmd = html_top_block_command (self);
        RETVAL = builtin_command_name (cmd);
#line 2934 "convert/ConvertXS.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_preformatted_classes_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_preformatted_classes_stack)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1731 "convert/ConvertXS.xs"
        const CONVERTER *self;
        const COMMAND_OR_TYPE_STACK *preformatted_classes_stack;
        AV *preformatted_classes_av;
        size_t i;
#line 2955 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1736 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_preformatted_classes_stack");
        preformatted_classes_stack = html_preformatted_classes_stack (self);
        preformatted_classes_av = newAV();
        for (i = 0; i < preformatted_classes_stack->top; i++)
          {
            const COMMAND_OR_TYPE *cmd_or_type
              = &preformatted_classes_stack->stack[i];
            const char *pre_class = 0;
            if (cmd_or_type->variety == CTV_type_command)
              pre_class = builtin_command_data[cmd_or_type->ct.cmd].cmdname;
            else if (cmd_or_type->variety == CTV_type_type)
              pre_class = self->pre_class_types[cmd_or_type->ct.type];
            SV *class_sv
              = newSVpv_utf8 (pre_class, 0);
            av_push (preformatted_classes_av, class_sv);
          }
        RETVAL = newRV_noinc ((SV *)preformatted_classes_av);
#line 2978 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_align); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_in_align)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1760 "convert/ConvertXS.xs"
        const CONVERTER *self;
        enum command_id cmd;
#line 2996 "convert/ConvertXS.c"
	const char *	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
#line 1763 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_in_align");
        cmd = html_in_align (self);
        RETVAL = builtin_command_name (cmd);
#line 3005 "convert/ConvertXS.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_current_filename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_current_filename)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1772 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 3023 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1774 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_current_filename");
        RETVAL = newSVpv_utf8 (self->current_filename.filename, 0);
#line 3030 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_current_output_unit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_current_output_unit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 1782 "convert/ConvertXS.xs"
        const CONVERTER *self;
#line 3047 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1784 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_current_output_unit");
        if (!self->current_output_unit)
          RETVAL = newSV (0);
        else
          RETVAL = newRV_inc ((SV *) self->current_output_unit->hv);
#line 3057 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_count_elements_in_filename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_count_elements_in_filename)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, spec, filename");
    {
	const char *	filename = (char *)SvPVutf8_nolen(ST(2));
#line 1796 "convert/ConvertXS.xs"
        IV count = -1;
        const CONVERTER *self;
#line 3076 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	const char *	spec = (const char *)SvPV_nolen(ST(1))
;
#line 1799 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_count_elements_in_filename");
        if (self)
          {
            int i;
            for (i = 0; count_elements_in_filename_type_names[i]; i++)
              if (!strcmp (spec, count_elements_in_filename_type_names[i]))
                break;
            if (!count_elements_in_filename_type_names[i])
              {
                fprintf (stderr, "ERROR: unknown count type: %s\n", spec);
              }
            else
              {
                count = (IV) html_count_elements_in_filename (self, i,
                                                              filename);
              }
          }
         if (count >= 0)
          RETVAL = newSViv (count);
        else
          RETVAL = newSV (0);
#line 3105 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_is_format_expanded); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_is_format_expanded)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, format");
    {
	char *	format = (char *)SvPVutf8_nolen(ST(1));
#line 1828 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 3123 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 1830 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_is_format_expanded");
        if (self)
          {
            int expanded = format_expanded_p (self->expanded_formats, format);
            RETVAL = newSViv ((IV)expanded);
          }
        else
          RETVAL = newSV (0);
#line 3137 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_file_information); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_file_information)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, key, value");
    {
	char *	key = (char *)SvPVutf8_nolen(ST(1));
#line 1846 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 3155 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	int	value = (int)SvIV(ST(2))
;
#line 1848 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_register_file_information");
        if (self)
          {
            char *stored_key = add_string (key, &self->small_strings);
            html_register_file_information (self, stored_key, value);
          }
#line 3168 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_file_information); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_file_information)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "converter_in, key, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	key = (char *)SvPVutf8_nolen(ST(1));
#line 1861 "convert/ConvertXS.xs"
        CONVERTER *self;
        SV *filename_sv = 0;
        int found = 0;
        int result = 0;
        SV *found_sv;
        SV *result_sv;
#line 3191 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 1868 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_get_file_information");
        if (items > 2 && SvOK(ST(2)))
          filename_sv = ST(2);
        if (self)
          {
            const char *filename = 0;
            int status;
            if (filename_sv)
              filename = SvPVutf8_nolen (filename_sv);
            result = html_get_file_information (self, key, filename, &status);
            if (status >= 0)
              found = 1;
          }
        found_sv = newSViv ((IV)found);
        if (found)
          result_sv = newSViv ((IV)result);
        else
          result_sv = newSV (0);

        EXTEND(SP, 2);
        PUSHs(sv_2mortal(found_sv));
        PUSHs(sv_2mortal(result_sv));
#line 3218 "convert/ConvertXS.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_target); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_target)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 1898 "convert/ConvertXS.xs"
        CONVERTER *self;
        HV *html_target_hv = 0;
#line 3235 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 1901 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_get_target");
        if (self)
          {
            size_t output_units_descriptor
              = get_output_units_descriptor_converter_sv (converter_in);
            const ELEMENT *element;
            element = html_find_element_from_sv (self, element_sv,
                                                 output_units_descriptor);
            if (element)
              {
                const HTML_TARGET *target_info = html_get_target (self, element);
                if (target_info)
                  html_target_hv = build_html_target (target_info);
              }
          }
        if (html_target_hv)
          {
            RETVAL = newRV_noinc ((SV *) html_target_hv);
          }
        else
          RETVAL = newSV (0);
#line 3264 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_id)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 1929 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *id = 0;
        const ELEMENT *element;
#line 3283 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 1933 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                             "html_command_id", &self);
        if (element)
          id = html_command_id (self, element);

        if (id)
          RETVAL = newSVpv_utf8 (id, 0);
        else
          RETVAL = newSV (0);
#line 3299 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_contents_target); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_contents_target)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, element_sv, cmdname");
    {
	const char *	cmdname = (char *)SvPVutf8_nolen(ST(2));
#line 1949 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *id = 0;
        const ELEMENT *element;
#line 3319 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 1953 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                             "html_command_contents_target",
                                             &self);
        if (element)
          {
            enum command_id cmd = lookup_builtin_command (cmdname);
            id = html_command_contents_target (self, element, cmd);
          }

        if (id)
          RETVAL = newSVpv_utf8 (id, 0);
        else
          RETVAL = newSV (0);
#line 3339 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_footnote_location_target); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_footnote_location_target)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 1972 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *id = 0;
        const ELEMENT *element;
#line 3358 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 1976 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                             "html_footnote_location_target",
                                             &self);
        if (element)
          id = html_footnote_location_target (self, element);

        if (id)
          RETVAL = newSVpv_utf8 (id, 0);
        else
          RETVAL = newSV (0);
#line 3375 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_filename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_filename)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 1992 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *filename = 0;
        const ELEMENT *element;
#line 3394 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 1996 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                             "html_command_filename",
                                             &self);
        if (element)
          {
            const FILE_NUMBER_NAME *file_number_name
              = html_command_filename (self, element);
            if (file_number_name)
              {
                filename = file_number_name->filename;
              }
          }

        if (filename)
          RETVAL = newSVpv_utf8 (filename, 0);
        else
          RETVAL = newSV (0);
#line 3418 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_root_element_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_root_element_command)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 2019 "convert/ConvertXS.xs"
        CONVERTER *self;
        const ELEMENT *root_element_command = 0;
        const ELEMENT *element;
#line 3437 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 2023 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                    "html_command_root_element_command",
                                             &self);
        if (element)
          {
            root_element_command
              = html_command_root_element_command (self, element);
          }

        if (root_element_command)
          RETVAL = newRV_inc ((SV *) root_element_command->hv);
        else
          RETVAL = newSV (0);
#line 3457 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_node); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_node)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 2042 "convert/ConvertXS.xs"
        CONVERTER *self;
        const ELEMENT *node_element = 0;
        const ELEMENT *element;
#line 3476 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 2046 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                             "html_command_node", &self);
        if (element)
          node_element = html_command_node (self, element);

        if (node_element)
          RETVAL = newRV_inc ((SV *) node_element->hv);
        else
          RETVAL = newSV (0);
#line 3492 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_internal_command_href); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_internal_command_href)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "converter_in, element_sv, source_filename_sv=0, specified_target_sv=0");
    {
#line 2061 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *href = 0;
        const ELEMENT *element;
#line 3511 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
	SV *	source_filename_sv;
	SV *	specified_target_sv;

	if (items < 3)
	    source_filename_sv = 0;
	else {
	    source_filename_sv = ST(2)
;
	}

	if (items < 4)
	    specified_target_sv = 0;
	else {
	    specified_target_sv = ST(3)
;
	}
#line 2065 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                        "html_internal_command_href", &self);

        if (element)
          {
            const char *source_filename = 0;
            const char *specified_target = 0;
            if (source_filename_sv && SvOK (source_filename_sv))
              source_filename = SvPVutf8_nolen (source_filename_sv);
            if (specified_target_sv && SvOK (specified_target_sv))
              specified_target = SvPVutf8_nolen (specified_target_sv);
            href = html_internal_command_href (self, element, source_filename,
                                               specified_target);
          }

        if (href)
          {
            RETVAL = newSVpv_utf8 (href, 0);
            non_perl_free (href);
          }
        else
          RETVAL = newSV (0);
#line 3556 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_contents_href); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_contents_href)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "converter_in, element_sv, cmdname, source_filename_sv=0");
    {
	char *	cmdname = (char *)SvPVutf8_nolen(ST(2));
#line 2094 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *href = 0;
        const ELEMENT *element;
#line 3576 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
	SV *	source_filename_sv;

	if (items < 4)
	    source_filename_sv = 0;
	else {
	    source_filename_sv = ST(3)
;
	}
#line 2098 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                        "html_command_contents_href", &self);

        if (element)
          {
            enum command_id cmd = lookup_builtin_command (cmdname);
            const char *source_filename = 0;
            if (source_filename_sv && SvOK (source_filename_sv))
              source_filename = SvPVutf8_nolen(source_filename_sv);
            href = html_command_contents_href (self, element, cmd,
                                               source_filename);
          }

        if (href)
          {
            RETVAL = newSVpv_utf8 (href, 0);
            non_perl_free (href);
          }
        else
          RETVAL = newSV (0);
#line 3611 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_footnote_location_href); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_footnote_location_href)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 5)
       croak_xs_usage(cv,  "converter_in, element_sv, source_filename_sv=0, specified_target_sv=0, target_filename_sv=0");
    {
#line 2124 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *href = 0;
        const ELEMENT *element;
#line 3630 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
	SV *	source_filename_sv;
	SV *	specified_target_sv;
	SV *	target_filename_sv;

	if (items < 3)
	    source_filename_sv = 0;
	else {
	    source_filename_sv = ST(2)
;
	}

	if (items < 4)
	    specified_target_sv = 0;
	else {
	    specified_target_sv = ST(3)
;
	}

	if (items < 5)
	    target_filename_sv = 0;
	else {
	    target_filename_sv = ST(4)
;
	}
#line 2128 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                        "html_footnote_location_href", &self);
        if (element)
          {
            const char *source_filename = 0;
            const char *specified_target = 0;
            const char *target_filename_in = 0;
            if (source_filename_sv && SvOK(source_filename_sv))
              source_filename = SvPVutf8_nolen (source_filename_sv);
            if (specified_target_sv && SvOK(specified_target_sv))
              specified_target = SvPVutf8_nolen (specified_target_sv);
            if (target_filename_sv && SvOK(target_filename_sv))
              target_filename_in = SvPVutf8_nolen (target_filename_sv);

            href = html_footnote_location_href (self, element, source_filename,
                                         specified_target, target_filename_in);
          }

        if (href)
          {
            RETVAL = newSVpv_utf8 (href, 0);
            non_perl_free (href);
          }
        else
          RETVAL = newSV (0);
#line 3686 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_internal_command_tree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_internal_command_tree)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, element_sv, no_number_sv");
    {
#line 2159 "convert/ConvertXS.xs"
        CONVERTER *self;
        ELEMENT *command_tree = 0;
        const ELEMENT *element;
#line 3705 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
	SV*	no_number_sv = ST(2)
;
#line 2163 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                        "html_internal_command_tree", &self);
        if (element)
          {
            int no_number = 0;
            TREE_ADDED_ELEMENTS *tree;

            if (SvOK (no_number_sv))
              no_number = SvIV (no_number_sv);

            tree = html_internal_command_tree (self, element, no_number);
            build_tree_to_build (&self->tree_to_build);

            if (tree)
              command_tree = tree->tree;
          }

        if (command_tree)
          RETVAL = newRV_inc ((SV *) command_tree->hv);
        else
          RETVAL = newSV (0);
#line 3735 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_internal_command_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_internal_command_text)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, element_sv, type");
    {
#line 2190 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *text = 0;
        const ELEMENT *element;
#line 3754 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
	const char *	type = (const char *)SvPV_nolen(ST(2))
;
#line 2194 "convert/ConvertXS.xs"
        element = element_converter_from_sv (converter_in, element_sv,
                                        "html_internal_command_text", &self);
        if (element)
          {
            int j;
            enum html_text_type text_type = 0;
            for (j = 0; j < HTT_section +1; j++)
              {
                if (!strcmp (html_command_text_type_name[j], type))
                  {
                    text_type = j;
                    break;
                  }
              }
            text
              = html_internal_command_text (self, element, text_type);
          }

        if (text)
          {
            RETVAL = newSVpv_utf8 (text, 0);
            non_perl_free (text);
          }
        else
          RETVAL = newSV (0);
#line 3788 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_description); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_description)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "converter_in, element_sv, type=0");
    {
#line 2225 "convert/ConvertXS.xs"
         CONVERTER *self;
         char *text = 0;
         const ELEMENT *element;
#line 3807 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
	const char *	type;

	if (items < 3)
	    type = 0;
	else {
	    type = (const char *)SvPV_nolen(ST(2))
;
	}
#line 2229 "convert/ConvertXS.xs"
         element = element_converter_from_sv (converter_in, element_sv,
                                         "html_command_description", &self);
         if (element)
           {
             int j;
             enum html_text_type text_type = 0;
             for (j = 0; j < HTT_string +1; j++)
               {
                 if (!strcmp (html_command_text_type_name[j], type))
                   {
                     text_type = j;
                     break;
                   }
               }
             text
               = html_command_description (self, element, text_type);
           }

         if (text)
           {
             RETVAL = newSVpv_utf8 (text, 0);
             non_perl_free (text);
           }
         else
           RETVAL = newSV (0);
#line 3847 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_global_direction_unit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_global_direction_unit)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, direction_name");
    {
	const char *	direction_name = (char *)SvPVutf8_nolen(ST(1));
#line 2261 "convert/ConvertXS.xs"
        CONVERTER *self;
        const OUTPUT_UNIT *output_unit = 0;
#line 3866 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2264 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_global_direction_unit");
        if (self)
          {
            output_unit
              = html_find_direction_name_global_unit (self, direction_name);
          }
        if (output_unit && output_unit->hv)
          RETVAL = newRV_inc ((SV *) output_unit->hv);
        /* should not happen */
        else
          RETVAL = newSV (0);
#line 3883 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_translate_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_translate_names)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 2282 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
#line 3900 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 2284 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, "html_translate_names");

        html_translate_names (self);
        build_html_formatting_state (self);
#line 3908 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_shared_conversion_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_set_shared_conversion_state)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, cmdname, state_name, ...");
    {
	const char *	cmdname = (char *)SvPVutf8_nolen(ST(1));
	const char *	state_name = (char *)SvPVutf8_nolen(ST(2));
#line 2294 "convert/ConvertXS.xs"
        CONVERTER *self;
        SV **args_sv = 0;
        int args_nr = 0;
#line 3927 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 2298 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_set_shared_conversion_state");
        args_nr = items - 3;
        if (args_nr > 0)
          {
            int i;
            args_sv = (SV **) malloc (args_nr * sizeof (SV *));
            for (i = 0; i < args_nr; i++)
              {
                args_sv[i] = ST(i+3);
              }
          }
        html_set_shared_conversion_state (self, converter_in,
                               cmdname, state_name, args_nr, args_sv);
        free (args_sv);
#line 3946 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_shared_conversion_state); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_shared_conversion_state)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "converter_in, cmdname, state_name, ...");
    {
	const char *	cmdname = (char *)SvPVutf8_nolen(ST(1));
	const char *	state_name = (char *)SvPVutf8_nolen(ST(2));
#line 2319 "convert/ConvertXS.xs"
        CONVERTER *self;
        SV **args_sv = 0;
        int args_nr = 0;
#line 3965 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2323 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_get_shared_conversion_state");
        args_nr = items - 3;
        if (args_nr > 0)
          {
            int i;
            args_sv = (SV **) malloc (args_nr * sizeof (SV *));
            for (i = 0; i < args_nr; i++)
              {
                args_sv[i] = ST(i+3);
              }
          }
        RETVAL = html_get_shared_conversion_state (self, converter_in,
                                    cmdname, state_name, args_nr, args_sv);
        free (args_sv);
#line 3985 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_opened_section_level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_opened_section_level)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "converter_in, filename, level, close_string");
    {
	const char *	filename = (char *)SvPVutf8_nolen(ST(1));
	const char *	close_string = (char *)SvPVutf8_nolen(ST(3));
#line 2346 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4004 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	int	level = (int)SvIV(ST(2))
;
#line 2348 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_register_opened_section_level");
        if (self)
          {
            html_register_opened_filename_section_level (self, filename,
                                                         level, close_string);
          }
#line 4017 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_close_registered_sections_level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_close_registered_sections_level)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, filename, level");
    {
	const char *	filename = (char *)SvPVutf8_nolen(ST(1));
#line 2360 "convert/ConvertXS.xs"
        CONVERTER *self;
        AV *closed_elements_av;
#line 4034 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	int	level = (int)SvIV(ST(2))
;
#line 2363 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_close_registered_sections_level");
        closed_elements_av = newAV ();
        if (self)
          {
            STRING_LIST *closed_elements
              = html_close_registered_filename_sections_level (self,
                                                            filename, level);

            if (closed_elements->number > 0)
              {
                size_t i;
                for (i = 0; i < closed_elements->number; i++)
                  {
                    SV *close_string_sv
                         = newSVpv_utf8 (closed_elements->list[i], 0);
                    av_push (closed_elements_av, close_string_sv);
                  }
              }
            destroy_strings_list (closed_elements);
          }
        RETVAL = newRV_noinc ((SV *) closed_elements_av);
#line 4063 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_attribute_class); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_attribute_class)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "converter_in, element, ...");
    {
	const char *	element = (char *)SvPVutf8_nolen(ST(1));
#line 2393 "convert/ConvertXS.xs"
        CONVERTER *self;
        SV *classes_sv = 0;
        STRING_LIST *classes = 0;
#line 4083 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2397 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_attribute_class");
        if (items > 2 && SvOK(ST(2)))
          classes_sv = ST(2);

        if (self)
          {
            char *result;
            if (classes_sv)
              {
                classes = new_string_list ();
                add_svav_to_string_list (classes_sv, classes, svt_char);
              }
            result = html_attribute_class (self, element, classes);
            if (classes)
              destroy_strings_list (classes);
            RETVAL = newSVpv_utf8 (result, 0);
            non_perl_free (result);
          }
        else
          RETVAL = newSV (0);
#line 4109 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_css_elements_classes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_css_elements_classes)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "converter_in, ...");
    {
#line 2425 "convert/ConvertXS.xs"
        CONVERTER *self;
        SV *filename_sv = 0;
        AV *css_selector_av;
#line 4128 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2429 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_attribute_class");
        if (items > 1 && SvOK(ST(1)))
          filename_sv = ST(1);

        css_selector_av = newAV ();

        if (self)
          {
            STRING_LIST *result;
            const char *filename = 0;
            if (filename_sv)
              filename = SvPVutf8_nolen (filename_sv);
            result = html_get_css_elements_classes (self, filename);
            if (result)
              {
                if (result->number)
                  {
                    size_t i;
                    for (i = 0; i < result->number; i++)
                      {
                        SV *selector_sv
                           = newSVpv_utf8 (result->list[i], 0);
                        av_push (css_selector_av, selector_sv);
                      }
                  }
                destroy_strings_list (result);
              }
          }
        RETVAL = newRV_noinc ((SV *) css_selector_av);
#line 4163 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_add_info); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_add_info)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, spec, css_info");
    {
	const char *	css_info = (char *)SvPVutf8_nolen(ST(2));
#line 2466 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4181 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	char *	spec = (char *)SvPV_nolen(ST(1))
;
#line 2468 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_css_add_info");
        if (self)
          {
            enum css_info_type type = html_get_css_info_spec (spec);
            html_css_add_info (self, type, css_info);
          }
#line 4194 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_set_selector_style); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_set_selector_style)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, css_info, css_style_sv");
    {
	const char *	css_info = (char *)SvPVutf8_nolen(ST(1));
#line 2480 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4210 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	css_style_sv = ST(2)
;
#line 2482 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_css_set_selector_style");
        if (self)
          {
            const char *css_style = 0;
            if (SvOK (css_style_sv))
              css_style = (char *)SvPVutf8_nolen (css_style_sv);

            html_css_set_selector_style (&self->css_element_class_styles,
                                         css_info, css_style);
          }
#line 4227 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_get_info); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_get_info)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, spec");
    {
#line 2497 "convert/ConvertXS.xs"
        CONVERTER *self;
        AV *result_av = 0;
#line 4243 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	char *	spec = (char *)SvPV_nolen(ST(1))
;
#line 2500 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_css_add_info");
        if (self)
          {
            const STRING_LIST *result;
            enum css_info_type type = html_get_css_info_spec (spec);
            result = html_css_get_info (self, type);
            if (result)
              result_av = build_string_list (result, svt_char);
           }
        if (!result_av)
          result_av = newAV ();
        RETVAL = newRV_noinc ((SV *) result_av);
#line 4263 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_get_selector_style); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_css_get_selector_style)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, css_info");
    {
	const char *	css_info = (char *)SvPVutf8_nolen(ST(1));
#line 2520 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *css_style = 0;
#line 4282 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2523 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_css_get_selector_style");
        if (self)
          {
            css_style = html_css_get_selector_style (self, css_info);
          }
        if (css_style)
          RETVAL = newSVpv_utf8 (css_style, 0);
        else
          RETVAL = newSV (0);
#line 4297 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_footnote); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_footnote)
{
    dVAR; dXSARGS;
    if (items < 6)
       croak_xs_usage(cv,  "converter_in, command, footid, docid, number_in_doc, footnote_location_filename, ...");
    {
	const char *	footid = (char *)SvPVutf8_nolen(ST(2));
	const char *	docid = (char *)SvPVutf8_nolen(ST(3));
	const char *	footnote_location_filename = (char *)SvPVutf8_nolen(ST(5));
#line 2543 "convert/ConvertXS.xs"
        CONVERTER *self;
        ELEMENT *footnote = 0;
#line 4318 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	command = ST(1)
;
	int	number_in_doc = (int)SvIV(ST(4))
;
#line 2546 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_register_footnote");
        if (self && self->document)
          {
            /* This code is about the same as get_perl_info.c
               find_element_from_sv, but simpler as we already know
               which command we are searching for */
            /* find footnote in XS using index in global commands */
            ELEMENT_LIST *footnotes
               = &self->document->global_commands.footnotes;
            HV *command_hv = (HV *) SvRV (command);
            SV **extra_sv
                = hv_fetch (command_hv, "extra", strlen ("extra"), 0);
            if (extra_sv)
              {
                HV *extra_hv = (HV *) SvRV (*extra_sv);
                SV **global_command_number_sv
                   = hv_fetch (extra_hv, "global_command_number",
                               strlen ("global_command_number"), 0);
                if (global_command_number_sv)
                  {
                    size_t global_command_number
                      = (size_t) SvIV (*global_command_number_sv);
                    if (global_command_number > 0
                        && global_command_number - 1 < footnotes->number)
                      {
                        const char *multi_expanded_region = 0;

                        footnote = footnotes->list[global_command_number - 1];

                        if (items > 7 && SvOK(ST(7)))
                          multi_expanded_region = SvPVutf8_nolen (ST(7));

                        html_register_footnote (self, footnote, footid, docid,
                                   number_in_doc, footnote_location_filename,
                                                      multi_expanded_region);
                      }
                  }
              }
          }
        if (!footnote)
          fprintf (stderr, "BUG: footnote not found\n");
#line 4368 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_pending_footnotes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_pending_footnotes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 2592 "convert/ConvertXS.xs"
        CONVERTER *self;
        AV *pending_footnotes_av;
#line 4384 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2595 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_register_footnote");
        pending_footnotes_av = newAV ();
        if (self)
          {
            HTML_PENDING_FOOTNOTE_STACK *stack
             = html_get_pending_footnotes (self);

            build_pending_footnotes (pending_footnotes_av, stack);

            destroy_pending_footnotes (stack);
          }
        RETVAL = newRV_noinc ((SV *) pending_footnotes_av);
#line 4402 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_pending_formatted_inline_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_register_pending_formatted_inline_content)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "converter_in, category, ...");
    {
	const char *	category = (char *)SvPVutf8_nolen(ST(1));
#line 2616 "convert/ConvertXS.xs"
        CONVERTER *self;
        const char *inline_content = 0;
#line 4421 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 2619 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                      "html_register_pending_formatted_inline_content");
        if (self)
          {
            if (items > 2 && SvOK(ST(2)))
              inline_content = SvPVutf8_nolen (ST(2));

            html_register_pending_formatted_inline_content (self,
                                                category, inline_content);
          }
#line 4435 "convert/ConvertXS.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_cancel_pending_formatted_inline_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_cancel_pending_formatted_inline_content)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, category");
    {
	const char *	category = (char *)SvPVutf8_nolen(ST(1));
#line 2634 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *inline_content = 0;
#line 4452 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2637 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                         "html_cancel_pending_formatted_inline_content");
        if (self)
          {
            inline_content
             = html_cancel_pending_formatted_inline_content (self, category);
          }
        if (inline_content)
          {
            RETVAL = newSVpv_utf8 (inline_content, 0);
            non_perl_free (inline_content);
          }
        else
          RETVAL = newSV (0);
#line 4471 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_pending_formatted_inline_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_pending_formatted_inline_content)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 2657 "convert/ConvertXS.xs"
        CONVERTER *self;
        char *inline_content = 0;
#line 4489 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
#line 2660 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                               "html_get_pending_formatted_inline_content");
        if (self)
          {
            inline_content = html_get_pending_formatted_inline_content (self);
          }
        if (inline_content)
          {
            RETVAL = newSVpv_utf8 (inline_content, 0);
            non_perl_free (inline_content);
          }
        else
          RETVAL = newSV (0);
#line 4507 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_associate_pending_formatted_inline_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_associate_pending_formatted_inline_content)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, element_sv, inline_content");
    {
	const char *	inline_content = (char *)SvPVutf8_nolen(ST(2));
#line 2680 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4525 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 2682 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                      "html_associate_pending_formatted_inline_content");
        if (self)
          {
            html_associate_pending_formatted_inline_content (self,
                                 0, SvRV (element_sv), inline_content);
          }
#line 4538 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_associated_formatted_inline_content); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_get_associated_formatted_inline_content)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 2693 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4553 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 2695 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                      "html_get_associated_formatted_inline_content");
        if (self)
          {
            char *inline_content
             = html_get_associated_formatted_inline_content (self,
                                                  0, SvRV (element_sv));
            RETVAL = newSVpv_utf8 (inline_content, 0);
            non_perl_free (inline_content);
          }
        else
          RETVAL = newSV (0);
#line 4572 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_push_referred_command_stack_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_push_referred_command_stack_command)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 2716 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4589 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 2718 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_push_referred_command_stack_command");
        if (self)
          {
            const HV *element_hv = (HV *) SvRV (element_sv);
            push_element_reference_stack_element (
             &self->referred_command_stack, 0, (const void *)element_hv);
          }
#line 4603 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_pop_referred_command_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_pop_referred_command_stack)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "converter_in");
    {
#line 2730 "convert/ConvertXS.xs"
        CONVERTER *self;
#line 4618 "convert/ConvertXS.c"
	SV *	converter_in = ST(0)
;
#line 2732 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_pop_referred_command_stack");
        if (self)
          {
            pop_element_reference_stack (&self->referred_command_stack);
          }
#line 4628 "convert/ConvertXS.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_is_in_referred_command_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_command_is_in_referred_command_stack)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "converter_in, element_sv");
    {
#line 2742 "convert/ConvertXS.xs"
        CONVERTER *self;
        int found = 0;
#line 4644 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
	SV *	element_sv = ST(1)
;
#line 2745 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                              "html_command_is_in_referred_command_stack");
        if (self)
          {
            const HV *element_hv = (HV *) SvRV (element_sv);
            found = command_is_in_referred_command_stack (
                     &self->referred_command_stack, 0,
                     (const void *)element_hv);
          }
        RETVAL = found;
#line 4662 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_check_htmlxref_already_warned); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_check_htmlxref_already_warned)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, manual_name, source_info_sv");
    {
	const char *	manual_name = (char *)SvPVutf8_nolen(ST(1));
#line 2762 "convert/ConvertXS.xs"
        CONVERTER *self;
        SOURCE_INFO *source_info = 0;
#line 4681 "convert/ConvertXS.c"
	int	RETVAL;
	dXSTARG;
	SV *	converter_in = ST(0)
;
	SV *	source_info_sv = ST(2)
;
#line 2765 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in,
                                 "html_check_htmlxref_already_warned");
        if (SvOK (source_info_sv))
          source_info = get_source_info (source_info_sv);

        RETVAL = html_check_htmlxref_already_warned (self, manual_name,
                                                     source_info);
        if (source_info)
          {
            non_perl_free (source_info->macro);
            non_perl_free (source_info->file_name);
            non_perl_free (source_info);
          }
#line 4702 "convert/ConvertXS.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_tree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Texinfo__Convert__ConvertXS_html_convert_tree)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "converter_in, tree_in, explanation");
    {
	const char *	explanation = (char *)SvPVbyte_nolen(ST(2));
#line 2790 "convert/ConvertXS.xs"
        CONVERTER *self = 0;
        DOCUMENT *document = 0;
        SV *result_sv = 0;
#line 4722 "convert/ConvertXS.c"
	SV *	RETVAL;
	SV *	converter_in = ST(0)
;
	SV *	tree_in = ST(1)
;
#line 2794 "convert/ConvertXS.xs"
        self = get_sv_converter (converter_in, 0);
        if (self)
          {
            document = get_sv_tree_document (tree_in, 0);
            if (document)
              {
                char *result = html_convert_tree(self, document->tree,
                                                 explanation);
                result_sv = newSVpv_utf8 (result, 0);
                non_perl_free (result);
              }
          }
        if (result_sv)
          RETVAL = result_sv;
        else
          RETVAL = newSV (0);
#line 4745 "convert/ConvertXS.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Texinfo__Convert__ConvertXS); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Texinfo__Convert__ConvertXS)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::init", XS_Texinfo__Convert__ConvertXS_init, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_defaults", XS_Texinfo__Convert__ConvertXS_converter_defaults, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::generic_converter_init", XS_Texinfo__Convert__ConvertXS_generic_converter_init, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_set_document", XS_Texinfo__Convert__ConvertXS_converter_set_document, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::set_conf", XS_Texinfo__Convert__ConvertXS_set_conf, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::force_conf", XS_Texinfo__Convert__ConvertXS_force_conf, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::get_conf", XS_Texinfo__Convert__ConvertXS_get_conf, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_line_error", XS_Texinfo__Convert__ConvertXS_converter_line_error, file, "$$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_line_warn", XS_Texinfo__Convert__ConvertXS_converter_line_warn, file, "$$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_document_error", XS_Texinfo__Convert__ConvertXS_converter_document_error, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_document_warn", XS_Texinfo__Convert__ConvertXS_converter_document_warn, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::converter_set_global_document_commands", XS_Texinfo__Convert__ConvertXS_converter_set_global_document_commands, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::get_converter_indices_sorted_by_index", XS_Texinfo__Convert__ConvertXS_get_converter_indices_sorted_by_index, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::get_converter_indices_sorted_by_letter", XS_Texinfo__Convert__ConvertXS_get_converter_indices_sorted_by_letter, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::get_unclosed_stream", XS_Texinfo__Convert__ConvertXS_get_unclosed_stream, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::get_converter_errors", XS_Texinfo__Convert__ConvertXS_get_converter_errors, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::reset_converter", XS_Texinfo__Convert__ConvertXS_reset_converter, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::destroy", XS_Texinfo__Convert__ConvertXS_destroy, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::plain_texinfo_convert_tree", XS_Texinfo__Convert__ConvertXS_plain_texinfo_convert_tree, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::text_convert_tree", XS_Texinfo__Convert__ConvertXS_text_convert_tree, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_format_setup", XS_Texinfo__Convert__ConvertXS_html_format_setup, file, "");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_converter_initialize_beginning", XS_Texinfo__Convert__ConvertXS_html_converter_initialize_beginning, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_converter_get_customization_sv", XS_Texinfo__Convert__ConvertXS_html_converter_get_customization_sv, file, "$$$$$$$$$$$$$$$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_conversion_initialization", XS_Texinfo__Convert__ConvertXS_html_conversion_initialization, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_setup_output", XS_Texinfo__Convert__ConvertXS_html_setup_output, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_setup_convert", XS_Texinfo__Convert__ConvertXS_html_setup_convert, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_conversion_finalization", XS_Texinfo__Convert__ConvertXS_html_conversion_finalization, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_conversion_units", XS_Texinfo__Convert__ConvertXS_html_prepare_conversion_units, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_units_directions_files", XS_Texinfo__Convert__ConvertXS_html_prepare_units_directions_files, file, "$$$$$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_output_units_global_targets", XS_Texinfo__Convert__ConvertXS_html_prepare_output_units_global_targets, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_simpletitle", XS_Texinfo__Convert__ConvertXS_html_prepare_simpletitle, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_converted_output_info", XS_Texinfo__Convert__ConvertXS_html_prepare_converted_output_info, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_title_titlepage", XS_Texinfo__Convert__ConvertXS_html_prepare_title_titlepage, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_convert_convert", XS_Texinfo__Convert__ConvertXS_html_convert_convert, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_convert_output", XS_Texinfo__Convert__ConvertXS_html_convert_output, file, "$$$$$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_prepare_node_redirection_page", XS_Texinfo__Convert__ConvertXS_html_prepare_node_redirection_page, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_node_redirections", XS_Texinfo__Convert__ConvertXS_html_node_redirections, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_output", XS_Texinfo__Convert__ConvertXS_html_output, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_convert", XS_Texinfo__Convert__ConvertXS_html_convert, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_register_id", XS_Texinfo__Convert__ConvertXS_html_register_id, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_id_is_registered", XS_Texinfo__Convert__ConvertXS_html_id_is_registered, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_new_document_context", XS_Texinfo__Convert__ConvertXS_html_new_document_context, file, "$$;$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_pop_document_context", XS_Texinfo__Convert__ConvertXS_html_pop_document_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_open_command_update_context", XS_Texinfo__Convert__ConvertXS_html_open_command_update_context, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_convert_command_update_context", XS_Texinfo__Convert__ConvertXS_html_convert_command_update_context, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_open_type_update_context", XS_Texinfo__Convert__ConvertXS_html_open_type_update_context, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_convert_type_update_context", XS_Texinfo__Convert__ConvertXS_html_convert_type_update_context, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_set_code_context", XS_Texinfo__Convert__ConvertXS_html_set_code_context, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_pop_code_context", XS_Texinfo__Convert__ConvertXS_html_pop_code_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_set_string_context", XS_Texinfo__Convert__ConvertXS_html_set_string_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_unset_string_context", XS_Texinfo__Convert__ConvertXS_html_unset_string_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_set_raw_context", XS_Texinfo__Convert__ConvertXS_html_set_raw_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_unset_raw_context", XS_Texinfo__Convert__ConvertXS_html_unset_raw_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_set_multiple_conversions", XS_Texinfo__Convert__ConvertXS_html_set_multiple_conversions, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_unset_multiple_conversions", XS_Texinfo__Convert__ConvertXS_html_unset_multiple_conversions, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_multi_expanded", XS_Texinfo__Convert__ConvertXS_html_in_multi_expanded, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_debug_print_html_contexts", XS_Texinfo__Convert__ConvertXS_html_debug_print_html_contexts, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_info", XS_Texinfo__Convert__ConvertXS_html_get_info, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_math", XS_Texinfo__Convert__ConvertXS_html_in_math, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_preformatted_context", XS_Texinfo__Convert__ConvertXS_html_in_preformatted_context, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_inside_preformatted", XS_Texinfo__Convert__ConvertXS_html_inside_preformatted, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_upper_case", XS_Texinfo__Convert__ConvertXS_html_in_upper_case, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_non_breakable_space", XS_Texinfo__Convert__ConvertXS_html_in_non_breakable_space, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_space_protected", XS_Texinfo__Convert__ConvertXS_html_in_space_protected, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_code", XS_Texinfo__Convert__ConvertXS_html_in_code, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_string", XS_Texinfo__Convert__ConvertXS_html_in_string, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_verbatim", XS_Texinfo__Convert__ConvertXS_html_in_verbatim, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_raw", XS_Texinfo__Convert__ConvertXS_html_in_raw, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_multiple_conversions", XS_Texinfo__Convert__ConvertXS_html_in_multiple_conversions, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_paragraph_number", XS_Texinfo__Convert__ConvertXS_html_paragraph_number, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_preformatted_number", XS_Texinfo__Convert__ConvertXS_html_preformatted_number, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_top_block_command", XS_Texinfo__Convert__ConvertXS_html_top_block_command, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_preformatted_classes_stack", XS_Texinfo__Convert__ConvertXS_html_preformatted_classes_stack, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_in_align", XS_Texinfo__Convert__ConvertXS_html_in_align, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_current_filename", XS_Texinfo__Convert__ConvertXS_html_current_filename, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_current_output_unit", XS_Texinfo__Convert__ConvertXS_html_current_output_unit, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_count_elements_in_filename", XS_Texinfo__Convert__ConvertXS_html_count_elements_in_filename, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_is_format_expanded", XS_Texinfo__Convert__ConvertXS_html_is_format_expanded, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_register_file_information", XS_Texinfo__Convert__ConvertXS_html_register_file_information, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_file_information", XS_Texinfo__Convert__ConvertXS_html_get_file_information, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_target", XS_Texinfo__Convert__ConvertXS_html_get_target, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_id", XS_Texinfo__Convert__ConvertXS_html_command_id, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_contents_target", XS_Texinfo__Convert__ConvertXS_html_command_contents_target, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_footnote_location_target", XS_Texinfo__Convert__ConvertXS_html_footnote_location_target, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_filename", XS_Texinfo__Convert__ConvertXS_html_command_filename, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_root_element_command", XS_Texinfo__Convert__ConvertXS_html_command_root_element_command, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_node", XS_Texinfo__Convert__ConvertXS_html_command_node, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_internal_command_href", XS_Texinfo__Convert__ConvertXS_html_internal_command_href, file, "$$;$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_contents_href", XS_Texinfo__Convert__ConvertXS_html_command_contents_href, file, "$$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_footnote_location_href", XS_Texinfo__Convert__ConvertXS_html_footnote_location_href, file, "$$;$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_internal_command_tree", XS_Texinfo__Convert__ConvertXS_html_internal_command_tree, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_internal_command_text", XS_Texinfo__Convert__ConvertXS_html_internal_command_text, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_description", XS_Texinfo__Convert__ConvertXS_html_command_description, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_global_direction_unit", XS_Texinfo__Convert__ConvertXS_html_global_direction_unit, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_translate_names", XS_Texinfo__Convert__ConvertXS_html_translate_names, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_set_shared_conversion_state", XS_Texinfo__Convert__ConvertXS_html_set_shared_conversion_state, file, "$$$;@");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_shared_conversion_state", XS_Texinfo__Convert__ConvertXS_html_get_shared_conversion_state, file, "$$$;@");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_register_opened_section_level", XS_Texinfo__Convert__ConvertXS_html_register_opened_section_level, file, "$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_close_registered_sections_level", XS_Texinfo__Convert__ConvertXS_html_close_registered_sections_level, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_attribute_class", XS_Texinfo__Convert__ConvertXS_html_attribute_class, file, "$$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_css_elements_classes", XS_Texinfo__Convert__ConvertXS_html_get_css_elements_classes, file, "$;$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_css_add_info", XS_Texinfo__Convert__ConvertXS_html_css_add_info, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_css_set_selector_style", XS_Texinfo__Convert__ConvertXS_html_css_set_selector_style, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_css_get_info", XS_Texinfo__Convert__ConvertXS_html_css_get_info, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_css_get_selector_style", XS_Texinfo__Convert__ConvertXS_html_css_get_selector_style, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_register_footnote", XS_Texinfo__Convert__ConvertXS_html_register_footnote, file, "$$$$$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_pending_footnotes", XS_Texinfo__Convert__ConvertXS_html_get_pending_footnotes, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_register_pending_formatted_inline_content", XS_Texinfo__Convert__ConvertXS_html_register_pending_formatted_inline_content, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_cancel_pending_formatted_inline_content", XS_Texinfo__Convert__ConvertXS_html_cancel_pending_formatted_inline_content, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_pending_formatted_inline_content", XS_Texinfo__Convert__ConvertXS_html_get_pending_formatted_inline_content, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_associate_pending_formatted_inline_content", XS_Texinfo__Convert__ConvertXS_html_associate_pending_formatted_inline_content, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_get_associated_formatted_inline_content", XS_Texinfo__Convert__ConvertXS_html_get_associated_formatted_inline_content, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_push_referred_command_stack_command", XS_Texinfo__Convert__ConvertXS_html_push_referred_command_stack_command, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_pop_referred_command_stack", XS_Texinfo__Convert__ConvertXS_html_pop_referred_command_stack, file, "$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_command_is_in_referred_command_stack", XS_Texinfo__Convert__ConvertXS_html_command_is_in_referred_command_stack, file, "$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_check_htmlxref_already_warned", XS_Texinfo__Convert__ConvertXS_html_check_htmlxref_already_warned, file, "$$$");
        (void)newXSproto_portable("Texinfo::Convert::ConvertXS::html_convert_tree", XS_Texinfo__Convert__ConvertXS_html_convert_tree, file, "$$;$");
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
