
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Using replaceChild on an Element node attempt to replace a new Element child node with 
 *  new child nodes and vice versa and in each case verify the name of the replaced node.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-785887307">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-785887307</a>
*/
public final class nodereplacechild30 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public nodereplacechild30(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element parent;
      Element oldChild;
      Element newElement;
      Text newText;
      Comment newComment;
      ProcessingInstruction newPI;
      CDATASection newCdata;
      EntityReference newERef;
      Node replaced;
      String nodeName;
      Node appendedChild;
      doc = (Document) load("hc_staff", true);
      parent = doc.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:html");
      oldChild = doc.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:head");
      newElement = doc.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:body");
      appendedChild = parent.appendChild(oldChild);
      appendedChild = parent.appendChild(newElement);
      newText = doc.createTextNode("Text");
      appendedChild = parent.appendChild(newText);
      newComment = doc.createComment("Comment");
      appendedChild = parent.appendChild(newComment);
      newPI = doc.createProcessingInstruction("target", "data");
      appendedChild = parent.appendChild(newPI);
      newCdata = doc.createCDATASection("Cdata");
      appendedChild = parent.appendChild(newCdata);
      newERef = doc.createEntityReference("delta");
      appendedChild = parent.appendChild(newERef);
      replaced = parent.replaceChild(newElement, oldChild);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_1", "xhtml:head", nodeName);
      replaced = parent.replaceChild(oldChild, newElement);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_2", "xhtml:body", nodeName);
      replaced = parent.replaceChild(newText, oldChild);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_3", "xhtml:head", nodeName);
      replaced = parent.replaceChild(oldChild, newText);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_4", "#text", nodeName);
      replaced = parent.replaceChild(newComment, oldChild);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_5", "xhtml:head", nodeName);
      replaced = parent.replaceChild(oldChild, newComment);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_6", "#comment", nodeName);
      replaced = parent.replaceChild(oldChild, newPI);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_7", "target", nodeName);
      replaced = parent.replaceChild(oldChild, newCdata);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_8", "#cdata-section", nodeName);
      replaced = parent.replaceChild(oldChild, newERef);
      nodeName = replaced.getNodeName();
      assertEquals("nodereplacechild30_9", "delta", nodeName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/nodereplacechild30";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(nodereplacechild30.class, args);
   }
}

