
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Invoke setIdAttribute class attribute on the second, third, and the fifth acronym element. 
 *  Verify by calling isID on the attributes and getElementById with the unique value "No" on document.
 *  
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttr</a>
*/
public final class elementsetidattribute08 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattribute08(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element acronymElem1;
      Element acronymElem2;
      Element acronymElem3;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", true);
      elemList = doc.getElementsByTagName("acronym");
      acronymElem1 = (Element) elemList.item(1);
      acronymElem2 = (Element) elemList.item(2);
      acronymElem3 = (Element) elemList.item(4);
      acronymElem1.setIdAttribute("class", true);
      acronymElem2.setIdAttribute("class", true);
      acronymElem3.setIdAttribute("class", true);
      attributesMap = acronymElem1.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("class");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId1True08", id);
      attributesMap = acronymElem2.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("class");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId2True08", id);
      attributesMap = acronymElem3.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("class");
      id = attr.isId();
      assertTrue("elementsetidattributeIsId3True08", id);
      elem = doc.getElementById("No");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributeGetElementById08", "acronym", elemName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattribute08";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattribute08.class, args);
   }
}

