
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  Set the value of the version attribute of the XML declaration of this document to 
 *  various invalid characters and  verify if a NOT_SUPPORTED_ERR is thrown.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-version">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-version</a>
*/
public final class documentsetxmlversion01 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentsetxmlversion01(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      String versionValue;
      java.util.List illegalVersion = new java.util.ArrayList();
      illegalVersion.add("{");
      illegalVersion.add("}");
      illegalVersion.add("~");
      illegalVersion.add("'");
      illegalVersion.add("!");
      illegalVersion.add("@");
      illegalVersion.add("#");
      illegalVersion.add("$");
      illegalVersion.add("%");
      illegalVersion.add("^");
      illegalVersion.add("&");
      illegalVersion.add("*");
      illegalVersion.add("(");
      illegalVersion.add(")");
      illegalVersion.add("+");
      illegalVersion.add("=");
      illegalVersion.add("[");
      illegalVersion.add("]");
      illegalVersion.add("\\");
      illegalVersion.add("/");
      illegalVersion.add(";");
      illegalVersion.add("`");
      illegalVersion.add("<");
      illegalVersion.add(">");
      illegalVersion.add(",");
      illegalVersion.add("a ");
      illegalVersion.add("\"");
      illegalVersion.add("---");
      
      doc = (Document) load("hc_staff", true);
      for (int indexN10087 = 0; indexN10087 < illegalVersion.size(); indexN10087++) {
          versionValue = (String) illegalVersion.get(indexN10087);
    
      {
         boolean success = false;
         try {
            doc.setXmlVersion(versionValue);
          } catch (DOMException ex) {
            success = (ex.code == DOMException.NOT_SUPPORTED_ERR);
         }
         assertTrue("NOT_SUPPORTED_ERR_documentsetversion01", success);
      }
  }
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentsetxmlversion01";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentsetxmlversion01.class, args);
   }
}

