/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.iri.IRIHelper;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Category;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.DateTime;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Generator;
import org.apache.abdera.model.IRIElement;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Source;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.stax.FOMElement;
import org.apache.abdera.parser.stax.FOMExtensibleElement;
import org.apache.abdera.parser.stax.FOMFeed;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.abdera.util.Constants;
import org.apache.axiom.fom.AbderaLink;
import org.apache.axiom.fom.AbderaPerson;
import org.apache.axiom.fom.AbderaSource;
import org.apache.axiom.fom.CategorizableMixin;
import org.apache.axiom.fom.CategoryContainerMixin;
import org.apache.axiom.fom.LinkUtil;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMSource
extends FOMExtensibleElement
implements AbderaSource {
    public Person getAuthor() {
        return (Person)this._getFirstChildWithName(Constants.AUTHOR);
    }

    public List<Person> getAuthors() {
        return this._getChildrenAsSet(Constants.AUTHOR);
    }

    public <T extends Source> T addAuthor(Person person) {
        this._addChild((AbderaPerson)person);
        return (T)this;
    }

    public Person addAuthor(String name) {
        Person person = this.getFactory().newAuthor((Element)this);
        person.setName(name);
        return person;
    }

    public Person addAuthor(String name, String email, String uri) {
        Person person = this.getFactory().newAuthor((Element)this);
        person.setName(name);
        person.setEmail(email);
        person.setUri(uri);
        return person;
    }

    public <T extends Source> T addCategory(Category category) {
        CategorizableMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_CategorizableMixin$org_apache_axiom_fom_Categorizable$internalAddCategory(this, category);
        return (T)this;
    }

    public List<Person> getContributors() {
        return this._getChildrenAsSet(Constants.CONTRIBUTOR);
    }

    public <T extends Source> T addContributor(Person person) {
        this._addChild((AbderaPerson)person);
        return (T)this;
    }

    public Person addContributor(String name) {
        Person person = this.getFactory().newContributor((Element)this);
        person.setName(name);
        return person;
    }

    public Person addContributor(String name, String email, String uri) {
        Person person = this.getFactory().newContributor((Element)this);
        person.setName(name);
        person.setEmail(email);
        person.setUri(uri);
        return person;
    }

    public IRIElement getIdElement() {
        return (IRIElement)this._getFirstChildWithName(Constants.ID);
    }

    public <T extends Source> T setIdElement(IRIElement id) {
        this._setChild(Constants.ID, (Element)id);
        return (T)this;
    }

    public IRI getId() {
        IRIElement id = this.getIdElement();
        return id != null ? id.getValue() : null;
    }

    public IRIElement setId(String value) {
        return this.setId(value, false);
    }

    public IRIElement newId() {
        return this.setId(this.getFactory().newUuidUri(), false);
    }

    public IRIElement setId(String value, boolean normalize) {
        if (value == null) {
            this._removeChildren(Constants.ID, false);
            return null;
        }
        IRIElement id = this.getIdElement();
        if (id != null) {
            if (normalize) {
                id.setNormalizedValue(value);
            } else {
                id.setValue(value);
            }
            return id;
        }
        IRIElement iri = this.getFactory().newID((Element)this);
        iri.setValue(normalize ? IRI.normalizeString((String)value) : value);
        return iri;
    }

    public List<Link> getLinks() {
        return this._getChildrenAsSet(Constants.LINK);
    }

    public List<Link> getLinks(String rel) {
        return FOMHelper.getLinks((Element)this, rel);
    }

    public List<Link> getLinks(String ... rels) {
        return FOMHelper.getLinks((Element)this, rels);
    }

    public <T extends Source> T addLink(Link link) {
        this._addChild((AbderaLink)link);
        return (T)this;
    }

    public Link addLink(String href) {
        return this.addLink(href, null);
    }

    public Link addLink(String href, String rel) {
        Link link = this.getFactory().newLink((Element)this);
        link.setHref(href);
        if (rel != null) {
            link.setRel(rel);
        }
        return link;
    }

    public Link addLink(String href, String rel, String type, String title, String hreflang, long length) {
        Link link = this.getFactory().newLink((Element)this);
        link.setHref(href);
        link.setRel(rel);
        link.setMimeType(type);
        link.setTitle(title);
        link.setHrefLang(hreflang);
        link.setLength(length);
        return link;
    }

    public Text getRightsElement() {
        return this.getTextElement(Constants.RIGHTS);
    }

    public <T extends Source> T setRightsElement(Text text) {
        this.setTextElement(Constants.RIGHTS, text, false);
        return (T)this;
    }

    public Text setRights(String value) {
        Text text = this.getFactory().newRights();
        text.setValue(value);
        this.setRightsElement(text);
        return text;
    }

    public Text setRightsAsHtml(String value) {
        return this.setRights(value, Text.Type.HTML);
    }

    public Text setRightsAsXhtml(String value) {
        return this.setRights(value, Text.Type.XHTML);
    }

    public Text setRights(String value, Text.Type type) {
        Text text = this.getFactory().newRights(type);
        text.setValue(value);
        this.setRightsElement(text);
        return text;
    }

    public Text setRights(Div value) {
        Text text = this.getFactory().newRights(Text.Type.XHTML);
        text.setValueElement(value);
        this.setRightsElement(text);
        return text;
    }

    public String getRights() {
        return this.getText(Constants.RIGHTS);
    }

    public Text getSubtitleElement() {
        return this.getTextElement(Constants.SUBTITLE);
    }

    public <T extends Source> T setSubtitleElement(Text text) {
        this.setTextElement(Constants.SUBTITLE, text, false);
        return (T)this;
    }

    public Text setSubtitle(String value) {
        Text text = this.getFactory().newSubtitle();
        text.setValue(value);
        this.setSubtitleElement(text);
        return text;
    }

    public Text setSubtitleAsHtml(String value) {
        return this.setSubtitle(value, Text.Type.HTML);
    }

    public Text setSubtitleAsXhtml(String value) {
        return this.setSubtitle(value, Text.Type.XHTML);
    }

    public Text setSubtitle(String value, Text.Type type) {
        Text text = this.getFactory().newSubtitle(type);
        text.setValue(value);
        this.setSubtitleElement(text);
        return text;
    }

    public Text setSubtitle(Div value) {
        Text text = this.getFactory().newSubtitle(Text.Type.XHTML);
        text.setValueElement(value);
        this.setSubtitleElement(text);
        return text;
    }

    public String getSubtitle() {
        return this.getText(Constants.SUBTITLE);
    }

    public Text getTitleElement() {
        return this.getTextElement(Constants.TITLE);
    }

    public <T extends Source> T setTitleElement(Text text) {
        this.setTextElement(Constants.TITLE, text, false);
        return (T)this;
    }

    public Text setTitle(String value) {
        Text text = this.getFactory().newTitle();
        text.setValue(value);
        this.setTitleElement(text);
        return text;
    }

    public Text setTitleAsHtml(String value) {
        return this.setTitle(value, Text.Type.HTML);
    }

    public Text setTitleAsXhtml(String value) {
        return this.setTitle(value, Text.Type.XHTML);
    }

    public Text setTitle(String value, Text.Type type) {
        Text text = this.getFactory().newTitle(type);
        text.setValue(value);
        this.setTitleElement(text);
        return text;
    }

    public Text setTitle(Div value) {
        Text text = this.getFactory().newTitle(Text.Type.XHTML);
        text.setValueElement(value);
        this.setTitleElement(text);
        return text;
    }

    public String getTitle() {
        return this.getText(Constants.TITLE);
    }

    public DateTime getUpdatedElement() {
        return (DateTime)this._getFirstChildWithName(Constants.UPDATED);
    }

    public <T extends Source> T setUpdatedElement(DateTime updated) {
        this._setChild(Constants.UPDATED, (Element)updated);
        return (T)this;
    }

    public String getUpdatedString() {
        DateTime dte = this.getUpdatedElement();
        return dte != null ? dte.getString() : null;
    }

    public Date getUpdated() {
        DateTime dte = this.getUpdatedElement();
        return dte != null ? dte.getDate() : null;
    }

    private DateTime setUpdated(AtomDate value) {
        if (value == null) {
            this._removeChildren(Constants.UPDATED, false);
            return null;
        }
        DateTime dte = this.getUpdatedElement();
        if (dte != null) {
            dte.setValue(value);
            return dte;
        }
        DateTime dt = this.getFactory().newUpdated((Element)this);
        dt.setValue(value);
        return dt;
    }

    public DateTime setUpdated(Date value) {
        return this.setUpdated(value != null ? AtomDate.valueOf((Date)value) : null);
    }

    public DateTime setUpdated(String value) {
        return this.setUpdated(value != null ? AtomDate.valueOf((String)value) : null);
    }

    public Generator getGenerator() {
        return (Generator)this._getFirstChildWithName(Constants.GENERATOR);
    }

    public <T extends Source> T setGenerator(Generator generator) {
        this._setChild(Constants.GENERATOR, (Element)generator);
        return (T)this;
    }

    public Generator setGenerator(String uri, String version, String value) {
        Generator generator = this.getFactory().newGenerator((Element)this);
        if (uri != null) {
            generator.setUri(uri);
        }
        if (version != null) {
            generator.setVersion(version);
        }
        if (value != null) {
            generator.setText(value);
        }
        return generator;
    }

    public IRIElement getIconElement() {
        return (IRIElement)this._getFirstChildWithName(Constants.ICON);
    }

    public <T extends Source> T setIconElement(IRIElement iri) {
        this._setChild(Constants.ICON, (Element)iri);
        return (T)this;
    }

    public IRIElement setIcon(String value) {
        if (value == null) {
            this._removeChildren(Constants.ICON, false);
            return null;
        }
        IRIElement iri = this.getFactory().newIcon((Element)this);
        iri.setValue(value);
        return iri;
    }

    public IRI getIcon() {
        IRIElement iri = this.getIconElement();
        IRI uri = iri != null ? iri.getResolvedValue() : null;
        return IRIHelper.isJavascriptUri((IRI)uri) || IRIHelper.isMailtoUri((IRI)uri) ? null : uri;
    }

    public IRIElement getLogoElement() {
        return (IRIElement)this._getFirstChildWithName(Constants.LOGO);
    }

    public <T extends Source> T setLogoElement(IRIElement iri) {
        this._setChild(Constants.LOGO, (Element)iri);
        return (T)this;
    }

    public IRIElement setLogo(String value) {
        if (value == null) {
            this._removeChildren(Constants.LOGO, false);
            return null;
        }
        IRIElement iri = this.getFactory().newLogo((Element)this);
        iri.setValue(value);
        return iri;
    }

    public IRI getLogo() {
        IRIElement iri = this.getLogoElement();
        IRI uri = iri != null ? iri.getResolvedValue() : null;
        return IRIHelper.isJavascriptUri((IRI)uri) || IRIHelper.isMailtoUri((IRI)uri) ? null : uri;
    }

    public Link getLink(String rel) {
        List<Link> self = this.getLinks(rel);
        Link link = null;
        if (self.size() > 0) {
            link = self.get(0);
        }
        return link;
    }

    public Link getSelfLink() {
        return this.getLink("self");
    }

    public Link getAlternateLink() {
        return this.getLink("alternate");
    }

    public IRI getLinkResolvedHref(String rel) {
        Link link = this.getLink(rel);
        return link != null ? link.getResolvedHref() : null;
    }

    public IRI getSelfLinkResolvedHref() {
        Link link = this.getSelfLink();
        return link != null ? link.getResolvedHref() : null;
    }

    public IRI getAlternateLinkResolvedHref() {
        Link link = this.getAlternateLink();
        return link != null ? link.getResolvedHref() : null;
    }

    public Text.Type getRightsType() {
        Text text = this.getRightsElement();
        return text != null ? text.getTextType() : null;
    }

    public Text.Type getSubtitleType() {
        Text text = this.getSubtitleElement();
        return text != null ? text.getTextType() : null;
    }

    public Text.Type getTitleType() {
        Text text = this.getTitleElement();
        return text != null ? text.getTextType() : null;
    }

    public Collection getCollection() {
        Collection coll = (Collection)this.getFirstChild(Constants.COLLECTION);
        if (coll == null) {
            coll = (Collection)this.getFirstChild(Constants.PRE_RFC_COLLECTION);
        }
        return coll;
    }

    public <T extends Source> T setCollection(Collection collection) {
        this._removeChildren(Constants.PRE_RFC_COLLECTION, true);
        this._setChild(Constants.COLLECTION, (Element)collection);
        return (T)this;
    }

    public Link getAlternateLink(String type, String hreflang) {
        return LinkUtil.selectLink(this.getLinks("alternate"), type, hreflang);
    }

    public IRI getAlternateLinkResolvedHref(String type, String hreflang) {
        Link link = this.getAlternateLink(type, hreflang);
        return link != null ? link.getResolvedHref() : null;
    }

    public Feed getAsFeed() {
        FOMFeed feed = (FOMFeed)this.getFactory().newFeed();
        Iterator i = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getChildElements(this);
        while (i.hasNext()) {
            FOMElement child = (FOMElement)i.next();
            if (child.getQName().equals(Constants.ENTRY)) continue;
            AxiomContainerSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild(feed, (OMNode)child.clone());
        }
        try {
            if (this.getBaseUri() != null) {
                feed.setBaseUri(this.getBaseUri());
            }
        }
        catch (Exception exception) {}
        return feed;
    }

    @Override
    public final Category addCategory(String string) {
        return CategoryContainerMixin.ajc$interMethod$org_apache_axiom_fom_CategoryContainerMixin$org_apache_axiom_fom_CategoryContainer$addCategory(this, string);
    }

    @Override
    public final Category addCategory(String string, String string2, String string3) {
        return CategoryContainerMixin.ajc$interMethod$org_apache_axiom_fom_CategoryContainerMixin$org_apache_axiom_fom_CategoryContainer$addCategory(this, string, string2, string3);
    }

    @Override
    public final List<Category> getCategories() {
        return CategoryContainerMixin.ajc$interMethod$org_apache_axiom_fom_CategoryContainerMixin$org_apache_axiom_fom_CategoryContainer$getCategories(this);
    }

    @Override
    public final List<Category> getCategories(String string) {
        return CategoryContainerMixin.ajc$interMethod$org_apache_axiom_fom_CategoryContainerMixin$org_apache_axiom_fom_CategoryContainer$getCategories(this, string);
    }

    @Override
    public final void internalAddCategory(Category category) {
        CategorizableMixin.ajc$interMethod$org_apache_axiom_fom_CategorizableMixin$org_apache_axiom_fom_Categorizable$internalAddCategory(this, category);
    }
}

