/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload.resource;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import java.util.List;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.resource.AbstractFileUploadResource;
import org.apache.wicket.markup.html.form.upload.resource.IUploadsFileManager;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class FileUploadResourceReference
extends ResourceReference {
    private final IUploadsFileManager uploadFileManager;
    private static FileUploadResourceReference instance;

    public static FileUploadResourceReference getInstance() {
        if (instance == null) {
            throw new IllegalStateException("An instance should be created via the createNewInstance method");
        }
        return instance;
    }

    public static FileUploadResourceReference createNewInstance(IUploadsFileManager fileManager) {
        if (instance == null) {
            instance = new FileUploadResourceReference(fileManager);
        }
        return instance;
    }

    protected FileUploadResourceReference(IUploadsFileManager uploadFileManager) {
        super(FileUploadResourceReference.class, "file-uploads");
        Args.notNull(uploadFileManager, "uploadFileManager");
        this.uploadFileManager = uploadFileManager;
    }

    @Override
    public IResource getResource() {
        return new AbstractFileUploadResource(this.uploadFileManager){

            @Override
            protected String generateJsonResponse(AbstractResource.ResourceResponse resourceResponse, ServletWebRequest webRequest, List<FileUpload> files) {
                JSONArray json = new JSONArray();
                for (FileUpload fileItem : files) {
                    JSONObject fileJson = new JSONObject();
                    try {
                        FileUploadResourceReference.this.generateFileInfo(fileJson, fileItem);
                        json.put(fileJson);
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
                return json.toString();
            }
        };
    }

    public IUploadsFileManager getUploadFileManager() {
        return this.uploadFileManager;
    }

    protected void generateFileInfo(JSONObject fileJson, FileUpload fileItem) {
        fileJson.put("clientFileName", fileItem.getClientFileName());
        fileJson.put("size", fileItem.getSize());
        fileJson.put("contentType", fileItem.getContentType());
    }
}

