/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.Numeric;

public class NumberProperty
extends Property {
    private Number number;

    public NumberProperty(double num) {
        this.number = new Double(num);
    }

    public NumberProperty(int num) {
        this.number = new Integer(num);
    }

    public NumberProperty(Number num) {
        this.number = num;
    }

    public ColorType getColorType() {
        return new ColorType(0.0f, 0.0f, 0.0f);
    }

    public Number getNumber() {
        return this.number;
    }

    public Numeric getNumeric() {
        return new Numeric(this.number);
    }

    public Object getObject() {
        return this.number;
    }

    public static class Maker
    extends Property.Maker {
        public Maker(String propName) {
            super(propName);
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) {
            if (p instanceof NumberProperty) {
                return p;
            }
            Number val = p.getNumber();
            if (val != null) {
                return new NumberProperty(val);
            }
            return this.convertPropertyDatatype(p, propertyList, fo);
        }
    }
}

