/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.core.VerifyArgument;

public final class GenericParameterCollection
extends Collection<GenericParameter> {
    private final IGenericParameterProvider _owner;

    public GenericParameterCollection(IGenericParameterProvider owner) {
        this._owner = (IGenericParameterProvider)VerifyArgument.notNull((Object)owner, (String)"owner");
    }

    private void updateGenericParameter(int index, GenericParameter p) {
        p.setOwner(this._owner);
        p.setPosition(index);
    }

    @Override
    protected void afterAdd(int index, GenericParameter p, boolean appended) {
        this.updateGenericParameter(index, p);
        if (!appended) {
            for (int i = index + 1; i < this.size(); ++i) {
                ((GenericParameter)this.get(i)).setPosition(i + 1);
            }
        }
    }

    @Override
    protected void beforeSet(int index, GenericParameter p) {
        GenericParameter current = (GenericParameter)this.get(index);
        current.setOwner(null);
        current.setPosition(-1);
        this.updateGenericParameter(index, p);
    }

    @Override
    protected void afterRemove(int index, GenericParameter p) {
        p.setOwner(null);
        p.setPosition(-1);
        for (int i = index; i < this.size(); ++i) {
            ((GenericParameter)this.get(i)).setPosition(i);
        }
    }

    @Override
    protected void beforeClear() {
        super.beforeClear();
    }
}

