/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.context.VinciContext;

public class PooledVinciClient {
    private VinciContext context = VinciContext.getGlobalContext();
    private TransportableFactory factory = VinciFrame.getVinciFrameFactory();
    int connectTimeout = 30000;
    int socketTimeout = 120000;
    private String serviceName;
    private int maxPoolSize;
    private VinciClient[] availableClients;
    private int availableClientsStartIndex;
    boolean closed;

    public PooledVinciClient(String serviceName, int maxPoolSize) {
        this.serviceName = serviceName;
        this.maxPoolSize = maxPoolSize;
        this.availableClients = new VinciClient[maxPoolSize];
        this.availableClientsStartIndex = 0;
        this.closed = false;
    }

    public void setContext(VinciContext context) {
        this.context = context;
    }

    public void setConnectTimeout(int connectTimeoutMillis) {
        this.connectTimeout = connectTimeoutMillis;
    }

    public void setSocketTimeout(int socketTimeoutMillis) {
        this.socketTimeout = socketTimeoutMillis;
    }

    public void setTransportableFactory(TransportableFactory factory) {
        this.factory = factory;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in) throws IOException, ServiceException {
        VinciClient c = this.getClientFromPool();
        try {
            Transportable transportable = c.sendAndReceive(in);
            return transportable;
        }
        finally {
            this.releaseClient(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in, TransportableFactory f) throws IOException, ServiceException {
        VinciClient c = this.getClientFromPool();
        try {
            Transportable transportable = c.sendAndReceive(in, f);
            return transportable;
        }
        finally {
            this.releaseClient(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in, TransportableFactory f, int socketTimeout) throws IOException, ServiceException {
        VinciClient c = this.getClientFromPool();
        try {
            Transportable transportable = c.sendAndReceive(in, f, socketTimeout);
            return transportable;
        }
        finally {
            this.releaseClient(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable sendAndReceive(Transportable in, int socketTimeout) throws IOException, ServiceException {
        VinciClient c = this.getClientFromPool();
        try {
            Transportable transportable = c.sendAndReceive(in, socketTimeout);
            return transportable;
        }
        finally {
            this.releaseClient(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean wait) {
        ArrayList<VinciClient> closeUs = new ArrayList<VinciClient>();
        PooledVinciClient pooledVinciClient = this;
        synchronized (pooledVinciClient) {
            if (!this.closed) {
                this.closed = true;
                for (int i = this.availableClientsStartIndex; i < this.maxPoolSize; ++i) {
                    if (this.availableClients[this.availableClientsStartIndex] == null) continue;
                    closeUs.add(this.availableClients[this.availableClientsStartIndex]);
                    this.availableClients[this.availableClientsStartIndex] = null;
                }
                this.notifyAll();
            }
        }
        for (int i = 0; i < closeUs.size(); ++i) {
            ((VinciClient)closeUs.get(i)).close();
        }
        if (wait) {
            boolean wasInterrupted = false;
            PooledVinciClient pooledVinciClient2 = this;
            synchronized (pooledVinciClient2) {
                while (this.availableClientsStartIndex > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VinciClient getClientFromPool() throws IOException {
        VinciClient client;
        PooledVinciClient pooledVinciClient = this;
        synchronized (pooledVinciClient) {
            if (this.availableClientsStartIndex == this.maxPoolSize && !this.closed) {
                try {
                    this.wait(this.socketTimeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("interrupted while waiting for available client");
                }
                if (this.availableClientsStartIndex == this.maxPoolSize) {
                    throw new IOException("waited too long for available client");
                }
            }
            if (this.closed) {
                throw new IOException("client is closed");
            }
            if (this.availableClients[this.availableClientsStartIndex] == null) {
                Debug.p("Creating new client for pool: " + this.availableClientsStartIndex);
                VinciClient c = new VinciClient(this.factory);
                c.setConnectTimeout(this.connectTimeout);
                c.setSocketTimeout(this.socketTimeout);
                c.setContext(this.context);
                this.availableClients[this.availableClientsStartIndex] = c;
            }
            client = this.availableClients[this.availableClientsStartIndex];
            ++this.availableClientsStartIndex;
        }
        try {
            if (!client.isOpen()) {
                client.open(this.serviceName);
            }
            VinciClient returnMe = client;
            client = null;
            VinciClient vinciClient = returnMe;
            return vinciClient;
        }
        finally {
            if (client != null) {
                this.releaseClient(client);
            }
        }
    }

    private synchronized void releaseClient(VinciClient c) {
        if (this.closed) {
            --this.availableClientsStartIndex;
            this.notify();
            c.close();
        } else {
            this.availableClients[--this.availableClientsStartIndex] = c;
            this.notify();
        }
    }
}

