/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl.compatibility;

import java.util.Map;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.annotator.BaseAnnotator;
import org.apache.uima.analysis_engine.impl.compatibility.AnnotatorAdapter;
import org.apache.uima.analysis_engine.impl.compatibility.CasConsumerAdapter;
import org.apache.uima.analysis_engine.impl.compatibility.CollectionReaderAdapter;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.resource.ResourceInitializationException;

public class AnalysisComponentAdapterFactory {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";

    public static AnalysisComponent createAdapter(Object aAdaptee, AnalysisEngineMetaData aMetaData, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (aAdaptee instanceof BaseAnnotator) {
            BaseAnnotator baseAnnotator = (BaseAnnotator)aAdaptee;
            return new AnnotatorAdapter(baseAnnotator, aMetaData, aAdditionalParams);
        }
        if (aAdaptee instanceof CasConsumer) {
            CasConsumer casConsumer = (CasConsumer)aAdaptee;
            return new CasConsumerAdapter(casConsumer, aMetaData);
        }
        if (aAdaptee instanceof CollectionReader) {
            CollectionReader collectionReader = (CollectionReader)aAdaptee;
            return new CollectionReaderAdapter(collectionReader, aMetaData);
        }
        throw new ResourceInitializationException("not_an_analysis_component", new Object[]{aAdaptee.getClass().getName(), aMetaData.getSourceUrlString()});
    }

    public static boolean isAdaptable(Class<?> cls) {
        return BaseAnnotator.class.isAssignableFrom(cls) || CasConsumer.class.isAssignableFrom(cls) || CollectionReader.class.isAssignableFrom(cls);
    }
}

