/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.RutaBasic;

public class RutaLiteralMatcher
implements RutaMatcher {
    private final IStringExpression expression;

    public RutaLiteralMatcher(IStringExpression expression) {
        this.expression = expression;
    }

    public List<AnnotationFS> getMatchingAnnotations(RutaBlock parent, RutaStream stream) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        AnnotationFS windowAnnotation = stream.getDocumentAnnotation();
        MatchContext context = new MatchContext(parent);
        String text = windowAnnotation.getCoveredText();
        String literal = this.expression.getStringValue(context, stream);
        int indexOf = 0;
        while ((indexOf = text.indexOf(literal, indexOf)) >= 0) {
            int end;
            int begin = indexOf + windowAnnotation.getBegin();
            indexOf = end = begin + literal.length();
            AnnotationFS annotation = this.getAnnotation(begin, end, stream);
            if (!stream.isVisible(annotation)) continue;
            result.add(annotation);
        }
        return result;
    }

    private AnnotationFS getAnnotation(int begin, int end, RutaStream stream) {
        RutaBasic beginAnchor = stream.getBeginAnchor(begin);
        if (beginAnchor != null && beginAnchor.getEnd() == end) {
            return beginAnchor;
        }
        RutaBasic endAnchor = stream.getEndAnchor(end);
        if (beginAnchor == null || endAnchor == null) {
            return null;
        }
        CAS cas = stream.getCas();
        return cas.createAnnotation(cas.getAnnotationType(), begin, end);
    }

    public String toString() {
        return "\"" + this.expression.toString() + "\"";
    }

    @Override
    public IStringExpression getExpression() {
        return this.expression;
    }

    @Override
    public long estimateAnchors(RutaBlock parent, RutaStream stream) {
        return Integer.MAX_VALUE;
    }

    public Collection<AnnotationFS> getAnnotationsAfter(RutaRuleElement ruleElement, AnnotationFS annotation, RutaBlock parent, RutaStream stream) {
        AnnotationFS matchedAnnotation;
        RutaBasic basicNextTo = stream.getBasicNextTo(false, annotation);
        if (basicNextTo == null) {
            return Collections.emptyList();
        }
        MatchContext context = new MatchContext(parent);
        String literal = this.expression.getStringValue(context, stream);
        if (!StringUtils.startsWith((CharSequence)literal, (CharSequence)basicNextTo.getCoveredText())) {
            return Collections.emptyList();
        }
        AnnotationFS windowAnnotation = stream.getDocumentAnnotation();
        int begin = basicNextTo.getBegin();
        int end = begin + literal.length();
        if (begin < windowAnnotation.getBegin() || end > windowAnnotation.getEnd()) {
            return Collections.emptyList();
        }
        String substring = stream.getCas().getDocumentText().substring(begin, end);
        if (StringUtils.equals((CharSequence)literal, (CharSequence)substring) && stream.isVisible(matchedAnnotation = this.getAnnotation(begin, end, stream))) {
            return Arrays.asList(matchedAnnotation);
        }
        return Collections.emptyList();
    }

    public Collection<AnnotationFS> getAnnotationsBefore(RutaRuleElement ruleElement, AnnotationFS annotation, RutaBlock parent, RutaStream stream) {
        AnnotationFS matchedAnnotation;
        RutaBasic basicNextTo = stream.getBasicNextTo(true, annotation);
        if (basicNextTo == null) {
            return Collections.emptyList();
        }
        MatchContext context = new MatchContext(parent);
        String literal = this.expression.getStringValue(context, stream);
        if (!StringUtils.endsWith((CharSequence)literal, (CharSequence)basicNextTo.getCoveredText())) {
            return Collections.emptyList();
        }
        AnnotationFS windowAnnotation = stream.getDocumentAnnotation();
        int begin = basicNextTo.getEnd() - literal.length();
        int end = basicNextTo.getEnd();
        if (begin < windowAnnotation.getBegin() || end > windowAnnotation.getEnd()) {
            return Collections.emptyList();
        }
        String substring = stream.getCas().getDocumentText().substring(begin, end);
        if (StringUtils.equals((CharSequence)literal, (CharSequence)substring) && stream.isVisible(matchedAnnotation = this.getAnnotation(begin, end, stream))) {
            return Arrays.asList(matchedAnnotation);
        }
        return Collections.emptyList();
    }

    @Override
    public Type getType(RutaBlock parent, RutaStream stream) {
        return stream.getCas().getAnnotationType();
    }
}

