/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.ruta.testing.evaluator.ICasEvaluator;

public abstract class AbstractCasEvaluator
implements ICasEvaluator {
    protected List<AnnotationFS> getAnnotations(List<Type> types, CAS cas, boolean includeSubtypes) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        TypeSystem typeSystem = cas.getTypeSystem();
        AnnotationIndex annotationIndex = cas.getAnnotationIndex();
        block0: for (AnnotationFS each : annotationIndex) {
            Type type = each.getType();
            for (Type eachType : types) {
                if (includeSubtypes && typeSystem.subsumes(eachType, type)) {
                    result.add(each);
                    continue block0;
                }
                if (!eachType.getName().equals(type.getName())) continue;
                result.add(each);
                continue block0;
            }
        }
        return result;
    }

    protected boolean match(AnnotationFS a1, AnnotationFS a2) {
        return a1 != null && a2 != null && a1.getBegin() == a2.getBegin() && a1.getEnd() == a2.getEnd() && a1.getType().getName().equals(a2.getType().getName());
    }

    protected List<Type> getTypes(CAS test, Collection<String> excludedTypes, Type annotationType, boolean useAllTypes) {
        List allTypes = test.getTypeSystem().getProperlySubsumedTypes(annotationType);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type eachType : allTypes) {
            int size = test.getAnnotationIndex(eachType).size();
            if (excludedTypes.contains(eachType.getName()) || size <= 0 && !useAllTypes || eachType.equals((Object)test.getDocumentAnnotation().getType())) continue;
            types.add(eachType);
        }
        return types;
    }
}

