/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.ssh;

import io.churchkey.shade.util.PrintString;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;

public class KeyInput
extends DataInputStream {
    public KeyInput(byte[] bytes) {
        super(new ByteArrayInputStream(bytes));
    }

    public String readAuthMagic() throws IOException {
        PrintString string = new PrintString();
        int read = this.read();
        while (read != 0) {
            if (read == -1) {
                throw new EOFException();
            }
            string.write(read);
            read = this.read();
        }
        return string.toString();
    }

    public String readString() throws IOException {
        return new String(this.readBytes());
    }

    public byte[] readBytes() throws IOException {
        byte[] bytes = new byte[this.readInt()];
        int length = this.read(bytes);
        if (length != bytes.length) {
            throw new IOException(String.format("data truncated.  Expected %s bytes, read %n bytes", bytes.length, length));
        }
        return bytes;
    }

    public BigInteger readBigInteger() throws IOException {
        return new BigInteger(this.readBytes());
    }
}

