/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class DateAddStep<S>
extends ScalarMapStep<S, OffsetDateTime> {
    private DT dateToken;
    private Duration duration;
    private int value;

    public DateAddStep(Traversal.Admin traversal, DT dateToken, int value) {
        super(traversal);
        switch (dateToken) {
            case second: {
                this.duration = Duration.ofSeconds(value);
                break;
            }
            case minute: {
                this.duration = Duration.ofMinutes(value);
                break;
            }
            case hour: {
                this.duration = Duration.ofHours(value);
                break;
            }
            case day: {
                this.duration = Duration.ofDays(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("DT tokens should only be second, minute, hour, or day.");
            }
        }
        this.dateToken = dateToken;
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected OffsetDateTime map(Traverser.Admin<S> traverser) {
        OffsetDateTime date;
        Object object = traverser.get();
        if (!(object instanceof OffsetDateTime)) {
            if (!(object instanceof Date)) throw new IllegalArgumentException("dateAdd() accept only OffsetDateTime or Date (deprecated).");
            date = ((Date)object).toInstant().atOffset(ZoneOffset.UTC);
            return date.plus(this.duration);
        } else {
            date = (OffsetDateTime)object;
        }
        return date.plus(this.duration);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dateToken.hashCode();
        result = 31 * result + this.duration.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public DateAddStep<S> clone() {
        DateAddStep clone = (DateAddStep)super.clone();
        clone.value = this.value;
        clone.duration = this.duration;
        clone.dateToken = this.dateToken;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    public DT getDateToken() {
        return this.dateToken;
    }

    public int getValue() {
        return this.value;
    }
}

