/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sysds.runtime.io.hdf5.H5ObjectHeader;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.message.H5DataLayoutMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5DataSpaceMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5DataTypeMessage;

public class H5ContiguousDataset {
    private final H5RootObject rootObject;
    private final H5DataLayoutMessage dataLayoutMessage;
    private final H5DataTypeMessage dataTypeMessage;
    private final H5DataSpaceMessage dataSpaceMessage;

    public H5ContiguousDataset(H5RootObject rootObject, H5ObjectHeader objectHeader) {
        this.rootObject = rootObject;
        this.dataLayoutMessage = objectHeader.getMessageOfType(H5DataLayoutMessage.class);
        this.dataTypeMessage = objectHeader.getMessageOfType(H5DataTypeMessage.class);
        this.dataSpaceMessage = objectHeader.getMessageOfType(H5DataSpaceMessage.class);
    }

    public ByteBuffer getDataBuffer(int row) {
        try {
            long rowPos = (long)row * this.rootObject.getCol() * (long)this.dataTypeMessage.getDoubleDataType().getSize();
            ByteBuffer data = this.rootObject.readBufferFromAddressNoOrder(this.dataLayoutMessage.getAddress() + rowPos, (int)(this.rootObject.getCol() * (long)this.dataTypeMessage.getDoubleDataType().getSize()));
            data.order(ByteOrder.LITTLE_ENDIAN);
            return data;
        }
        catch (Exception e) {
            throw new H5RuntimeException("Failed to map data buffer for dataset", e);
        }
    }

    public H5DataTypeMessage getDataType() {
        return this.dataTypeMessage;
    }
}

