/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.common.Warnings;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockDRB;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DenseBlockBool
extends DenseBlockDRB {
    private static final long serialVersionUID = -2228057308997136969L;
    private BitSet _data;

    public DenseBlockBool(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._data = new BitSet(length);
    }

    public DenseBlockBool(int[] dims, BitSet data) {
        super(dims);
        this._data = data;
    }

    public DenseBlockBool(int[] dims, boolean[] data) {
        super(dims);
        this._data = new BitSet(data.length);
        for (int i = 0; i < data.length; ++i) {
            if (!data[i]) continue;
            this._data.set(i);
        }
    }

    public BitSet getData() {
        return this._data;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isNumeric(Types.ValueType vt) {
        return Types.ValueType.BOOLEAN == vt;
    }

    @Override
    public void reset(int rlen, int[] odims, double v) {
        boolean bv = v != 0.0;
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this._data = new BitSet(len);
            if (bv) {
                this._data.set(0, len);
            }
        } else {
            this._data.set(0, this._data.size(), bv);
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public void resetNoFill(int rlen, int[] odims) {
        int len = rlen * odims[0];
        if ((long)len > this.capacity()) {
            this._data = new BitSet(len);
        }
        this._rlen = rlen;
        this._odims = odims;
    }

    @Override
    public long capacity() {
        return this._data != null ? (long)this._data.size() : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return start == 0 && length == this._rlen * this._odims[0] ? (long)this._data.cardinality() : (long)UtilFunctions.computeNnz(this._data, start, length);
    }

    @Override
    public double[] values(int r) {
        double[] ret = this.getReuseRow(false);
        int ix = this.pos(r);
        int ncol = this._odims[0];
        for (int j = 0; j < ncol; ++j) {
            ret[j] = this._data.get(ix + j) ? 1.0 : 0.0;
        }
        return ret;
    }

    @Override
    public double[] valuesAt(int bix) {
        int len = this._rlen * this._odims[0];
        Warnings.warnFullFP64Conversion(len);
        return DataConverter.toDouble(this._data, len);
    }

    @Override
    public int index(int r) {
        return 0;
    }

    @Override
    public void incr(int r, int c) {
        Warnings.warnInvalidBooleanIncrement(1.0);
        this._data.set(this.pos(r, c));
    }

    @Override
    public void incr(int r, int c, double delta) {
        Warnings.warnInvalidBooleanIncrement(delta);
        this._data.set(this.pos(r, c));
    }

    @Override
    public void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        this._data.set(fromIndex, toIndex, v != 0.0);
    }

    @Override
    public void fillRow(int r, double v) {
        int start = this.pos(r);
        int end = start + this.getDim(1);
        this._data.set(start, end, v != 0.0);
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._data.set(ix, v != 0.0);
    }

    @Override
    public DenseBlock set(String s) {
        this._data.set(0, this.blockSize() * this._odims[0], Boolean.parseBoolean(s));
        return this;
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._data.set(this.pos(r, c), v != 0.0);
        return this;
    }

    @Override
    public DenseBlock set(DenseBlock db) {
        double[] data = db.valuesAt(0);
        for (int i = 0; i < this._rlen * this._odims[0]; ++i) {
            this._data.set(i, data[i] != 0.0);
        }
        return this;
    }

    @Override
    public DenseBlock set(int rl, int ru, int cl, int cu, DenseBlock db) {
        for (int r = rl; r < ru; ++r) {
            for (int c = cl; c < cu; ++c) {
                int i = r * this._odims[0] + c;
                this._data.set(i, db.get(r - rl, c - cl) != 0.0);
            }
        }
        return this;
    }

    @Override
    public DenseBlock set(int r, double[] v) {
        int ri;
        for (int i = ri = r * this._odims[0]; i < ri + v.length; ++i) {
            this._data.set(i, v[i - ri] != 0.0);
        }
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._data.set(this.pos(ix), v != 0.0);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._data.set(this.pos(ix), v != 0L);
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._data.set(this.pos(ix), Boolean.parseBoolean(v));
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._data.get(this.pos(r, c)) ? 1.0 : 0.0;
    }

    @Override
    public double get(int[] ix) {
        return this._data.get(this.pos(ix)) ? 1.0 : 0.0;
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._data.get(this.pos(ix)));
    }

    @Override
    public long getLong(int[] ix) {
        return this._data.get(this.pos(ix)) ? 1L : 0L;
    }
}

