/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import org.apache.sysds.runtime.compress.utils.ACount;
import org.apache.sysds.runtime.compress.utils.ACountHashMap;

public final class DoubleCountHashMap
extends ACountHashMap<Double> {
    public DoubleCountHashMap() {
    }

    public DoubleCountHashMap(int init_capacity) {
        super(init_capacity);
    }

    protected ACount.DCounts[] create(int size) {
        return new ACount.DCounts[size];
    }

    @Override
    protected int hash(Double key) {
        return ACount.DCounts.hashIndex(key);
    }

    protected final ACount.DCounts create(double key, int id) {
        return new ACount.DCounts(key, id);
    }

    protected final ACount.DCounts create(Double key, int id) {
        return new ACount.DCounts(key, id);
    }

    public double[] getDictionary() {
        return this.getDictionary(this.size);
    }

    public double[] getDictionary(int size) {
        double[] ret = new double[size];
        for (int i = 0; i < this.data.length; ++i) {
            for (ACount e = this.data[i]; e != null; e = e.next()) {
                if (e.id < 0) continue;
                ret[e.id] = (Double)e.key();
            }
        }
        return ret;
    }

    public void replaceWithUIDs(double v) {
        int i = 0;
        ACount[] aCountArray = this.data;
        int n = aCountArray.length;
        for (int j = 0; j < n; ++j) {
            for (ACount e = aCountArray[j]; e != null; e = e.next()) {
                e.id = !((Double)e.key()).equals(v) ? i++ : -1;
            }
        }
    }

    public void replaceWithUIDsNoZero() {
        int i = 0;
        Double z = 0.0;
        ACount[] aCountArray = this.data;
        int n = aCountArray.length;
        for (int j = 0; j < n; ++j) {
            for (ACount e = aCountArray[j]; e != null; e = e.next()) {
                e.id = !((Double)e.key()).equals(z) ? i++ : -1;
            }
        }
    }

    public DoubleCountHashMap clone() {
        DoubleCountHashMap ret = new DoubleCountHashMap(this.size);
        for (ACount e : this.data) {
            ret.appendValue(e);
        }
        ret.size = this.size;
        return ret;
    }
}

