/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowVector;

public final class SparseRowScalar
extends SparseRow {
    private static final long serialVersionUID = 722193514969067477L;
    private int index;
    private double value;

    public SparseRowScalar() {
        this.index = -1;
        this.value = 0.0;
    }

    public SparseRowScalar(int ix, double val) {
        this.index = ix;
        this.value = val;
    }

    @Override
    public int size() {
        return this.index < 0 ? 0 : 1;
    }

    @Override
    public final boolean isEmpty() {
        return this.index < 0;
    }

    @Override
    public double[] values() {
        return new double[]{this.value};
    }

    @Override
    public int[] indexes() {
        return new int[]{this.index};
    }

    @Override
    public void reset(int estnns, int maxnns) {
        this.index = -1;
    }

    @Override
    public boolean set(int col, double v) {
        boolean ret;
        boolean bl = ret = this.index == col && v == 0.0 || this.index < 0 && v != 0.0;
        if (this.index >= 0 && this.index != col) {
            throw new RuntimeException("Invalid set to sparse row scalar.");
        }
        this.index = v != 0.0 ? col : -1;
        this.value = v;
        return ret;
    }

    @Override
    public boolean add(int col, double v) {
        return this.set(col, v + this.get(col));
    }

    @Override
    public SparseRow append(int col, double v) {
        if (v == 0.0) {
            return this;
        }
        if (this.index >= 0) {
            SparseRowVector srv = new SparseRowVector();
            srv.append(this.index, this.value);
            srv.append(col, v);
            return srv;
        }
        this.index = col;
        this.value = v;
        return this;
    }

    @Override
    public double get(int col) {
        return this.index == col ? this.value : 0.0;
    }

    @Override
    public void sort() {
    }

    @Override
    public void compact() {
        this.index = this.value != 0.0 ? this.index : -1;
    }

    @Override
    public void compact(double eps) {
        this.index = Math.abs(this.value) < eps ? -1 : this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public int searchIndexesFirstGTE(int col) {
        return col <= this.index ? 0 : -1;
    }

    @Override
    public int searchIndexesFirstGT(int col) {
        return col < this.index ? 0 : -1;
    }

    @Override
    public SparseRow copy(boolean deep) {
        return new SparseRowScalar(this.index, this.value);
    }
}

