/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.csp;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.interceptor.csp.CspNonceReader;
import org.apache.struts2.interceptor.csp.CspNonceSource;
import org.apache.struts2.util.ValueStack;

public class StrutsCspNonceReader
implements CspNonceReader {
    private static final Logger LOG = LogManager.getLogger(StrutsCspNonceReader.class);
    private final CspNonceSource nonceSource;

    @Inject(value="struts.csp.nonce.source", required=false)
    public StrutsCspNonceReader(String source) {
        this.nonceSource = StringUtils.isBlank((CharSequence)source) ? CspNonceSource.SESSION : CspNonceSource.valueOf(source.toUpperCase());
    }

    @Override
    public CspNonceReader.NonceValue readNonceValue(ValueStack stack) {
        CspNonceReader.NonceValue nonceValue;
        HttpServletRequest request = stack.getActionContext().getServletRequest();
        if (this.nonceSource == CspNonceSource.SESSION) {
            LOG.debug("Reading nonce value from session");
            nonceValue = this.readNonceFromSession(request);
        } else if (this.nonceSource == CspNonceSource.REQUEST) {
            LOG.debug("Reading nonce value from request attribute");
            nonceValue = this.readNonceFromRequest(request);
        } else {
            LOG.warn("Unknown nonce source: {}, reading nonce value from session", (Object)this.nonceSource);
            nonceValue = this.readNonceFromSession(request);
        }
        return nonceValue;
    }

    private CspNonceReader.NonceValue readNonceFromSession(HttpServletRequest request) {
        Object nonceValue;
        HttpSession session = request.getSession(false);
        Object object = nonceValue = session != null ? session.getAttribute("nonce") : null;
        if (nonceValue == null) {
            LOG.debug("Session is not active, cannot obtain nonce value");
            return CspNonceReader.NonceValue.ofNullSession();
        }
        return CspNonceReader.NonceValue.ofSession(nonceValue.toString());
    }

    private CspNonceReader.NonceValue readNonceFromRequest(HttpServletRequest request) {
        Object nonceValue = request.getAttribute("nonce");
        if (nonceValue == null) {
            LOG.warn("Request attribute 'nonce' is not set, cannot obtain nonce value");
            return CspNonceReader.NonceValue.ofNullRequest();
        }
        return CspNonceReader.NonceValue.ofRequest(nonceValue.toString());
    }
}

