/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.part;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.part.PartEvaluationTime;
import net.sf.jasperreports.engine.type.PartEvaluationTimeType;

public class StandardPartEvaluationTime
implements PartEvaluationTime,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_EVALUATION_TYPE = "engine.part.invalid.evaluation.type";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_SIMPLE_EVALUATION_TYPE = "engine.part.invalid.simple.evaluation.type";
    public static final StandardPartEvaluationTime EVALUATION_NOW = new StandardPartEvaluationTime(PartEvaluationTimeType.NOW, null);
    public static final StandardPartEvaluationTime EVALUATION_REPORT = new StandardPartEvaluationTime(PartEvaluationTimeType.REPORT, null);
    private final PartEvaluationTimeType type;
    private final String groupName;

    public static StandardPartEvaluationTime forType(String typeName) {
        StandardPartEvaluationTime evaluationTime;
        PartEvaluationTimeType type = PartEvaluationTimeType.byName(typeName);
        if (type == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_EVALUATION_TYPE, typeName);
        }
        switch (type) {
            case NOW: {
                evaluationTime = EVALUATION_NOW;
                break;
            }
            case REPORT: {
                evaluationTime = EVALUATION_REPORT;
                break;
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_SIMPLE_EVALUATION_TYPE, typeName);
            }
        }
        return evaluationTime;
    }

    public static StandardPartEvaluationTime forGroup(String groupName) {
        return new StandardPartEvaluationTime(PartEvaluationTimeType.GROUP, groupName);
    }

    @JsonCreator
    protected StandardPartEvaluationTime(@JsonProperty(value="evaluationTime") PartEvaluationTimeType type, @JsonProperty(value="evaluationGroup") String groupName) {
        this.type = type;
        this.groupName = groupName;
    }

    @Override
    public PartEvaluationTimeType getEvaluationTimeType() {
        return this.type;
    }

    @Override
    public String getEvaluationGroup() {
        return this.groupName;
    }
}

