/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import java.util.regex.Pattern;

public class BooleanType
extends Type {
    public BooleanType(Node fromNode) {
        super(fromNode);
    }

    public BooleanType(SourcePosition sourcePosition, String displayName) {
        super(sourcePosition, displayName);
    }

    @Override
    public Expression getDefaultValue() {
        return new BooleanConstant((Node)this, false);
    }

    @Override
    public Pattern getPattern(String attrName) {
        return Pattern.compile(Pattern.quote(attrName));
    }

    @Override
    public boolean takesDefaultParam() {
        return false;
    }

    @Override
    public boolean onlyAllowedInParam() {
        return false;
    }

    @Override
    public Expression parseObjectConstant(String paramName, ObjectConstant objectConstant, AlertSink alertSink) {
        return new BooleanConstant((Node)objectConstant, true);
    }

    @Override
    public <T> T acceptTypeVisitor(TypeVisitor<T> visitor) {
        return visitor.visitBooleanType(this);
    }

    @Override
    public String toString() {
        return "BooleanType";
    }

    @Override
    public boolean matches(Type that) {
        return that instanceof BooleanType;
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof BooleanType && this.equals((BooleanType)that);
    }

    public boolean equals(BooleanType that) {
        return this.equalsType(that);
    }

    @Override
    public int hashCode() {
        return this.typeHashCode();
    }
}

