/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.cpp;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.MissingTypeError;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.NativeType;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.OutputLanguageUtil;
import java.util.Set;
import java.util.regex.Pattern;

public class CppUtil
extends OutputLanguageUtil {
    private static final Set<String> FORBIDDEN_OPS = ImmutableSet.of();
    private static final Pattern OPS_FINDER = CppUtil.compileUnionPattern(new String[0]);
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of();
    public static final CppUtil INSTANCE = new CppUtil();

    private CppUtil() {
        super(RESERVED_WORDS, FORBIDDEN_OPS, OPS_FINDER, CharEscapers.javaStringUnicodeEscaper(), CharEscapers.javaStringEscaper());
    }

    @Override
    public String validateExpression(AlertSink alertSink, NativeExpression expr, OutputLanguage outputLanguage) {
        String result = expr.getNativeCode(outputLanguage);
        if (result == null) {
            return "";
        }
        return CharEscapers.javaStringUnicodeEscaper().escape(result);
    }

    public static String validateType(AlertSink alertSink, NativeType type) {
        String ret = type.getNativeType(OutputLanguage.CPP);
        if (ret == null) {
            alertSink.add(new MissingTypeError(type, OutputLanguage.CPP));
            return ret;
        }
        ret = ret.replace("{", "< ").replace("}", " >").trim();
        return ret;
    }
}

