<!--
  ~ Licensed to the Apache Software Foundation (ASF) under one or more
  ~ contributor license agreements.  See the NOTICE file distributed with
  ~ this work for additional information regarding copyright ownership.
  ~ The ASF licenses this file to You under the Apache License, Version 2.0
  ~ (the "License"); you may not use this file except in compliance with
  ~ the License.  You may obtain a copy of the License at
  ~
  ~    http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing, software
  ~ distributed under the License is distributed on an "AS IS" BASIS,
  ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  ~ See the License for the specific language governing permissions and
  ~ limitations under the License.
  ~
  -->

<h1 align="center">
   <img src="https://streampark.apache.org/image/logo_name.png" 
   alt="StreamPark Logo" title="Apache StreamPark Logo" width="600"/>
  <br>
</h1>

<h3 align="center">A magical framework that makes stream processing easier!</h3>

<div align="center">

[![License](https://img.shields.io/badge/license-Apache%202-blue.svg?style=for-the-badge&label=license)](https://www.apache.org/licenses/LICENSE-2.0.html)
[![stars](https://img.shields.io/github/stars/apache/streampark?style=for-the-badge&label=stars)](https://github.com/apache/incubator-streampark/stargazers)
[![Latest release](https://img.shields.io/github/v/release/apache/streampark.svg?style=for-the-badge&label=release)](https://github.com/apache/incubator-streampark/releases)
[![total downloads](https://img.shields.io/github/downloads/apache/streampark/total.svg?style=for-the-badge&label=downloads)](https://streampark.apache.org/download)
[![Twitter](https://img.shields.io/twitter/follow/ASFStreamPark?label=follow&logo=twitter&style=for-the-badge)](https://twitter.com/ASFStreamPark)

**[Website](https://streampark.apache.org)**&nbsp;&nbsp;|&nbsp;&nbsp;
**[Document](https://streampark.apache.org/docs/intro)**&nbsp;&nbsp;|&nbsp;&nbsp;
**[FAQ](https://github.com/apache/incubator-streampark/issues/507)**

![](https://streampark.apache.org/image/dashboard-preview.png)

</div>


## 🚀 What is StreamPark?

<h4>StreamPark is a stream processing development framework and professional management platform. </h4>

> StreamPark is a streaming application development framework. Aimed at ease building and managing streaming applications, StreamPark provides development framework for writing stream processing application with Apache Flink and Apache Spark, More other engines will be supported in the future. Also, StreamPark is a professional management platform for streaming application
, including application development, debugging, interactive query, deployment, operation, maintenance, etc. It was initially known as StreamX and renamed to StreamPark in August 2022.

## 🎉 Features

* Apache Flink & Spark stream processing application development framework
* Out-of-the-box connectors
* Support multiple versions of Flink & Spark
* Scala 2.11 / 2.12 support
* One-stop stream processing management platform
* Support catalog、olap、streaming-warehouse etc.
* ...

![](https://streampark.apache.org/image/sqlide.png)

## 🔨 How to Build

```shell
git clone git@github.com:apache/incubator-streampark.git
cd incubator-streampark
./build.sh
```

## 🧑‍💻 Downloads

Download address for run-directly software package : [https://streampark.apache.org/download](https://streampark.apache.org/download)

## 🚀 Quick Start

click [Document](https://streampark.apache.org/docs/user-guide/quick-start) for more information

## 💋 Our users

Various companies and organizations use StreamPark for research, production and commercial products. Are you using this project ? [Welcome to add your company](https://github.com/apache/incubator-streampark/issues/163)!

![Our users](https://streampark.apache.org/image/users.png)

## 🤝 Contribution

[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/apache/incubator-streampark/pulls)

You can submit any ideas as [pull requests](https://github.com/apache/incubator-streampark/pulls) or as [GitHub issues](https://github.com/apache/incubator-streampark/issues/new/choose).

> If you're new to posting issues, we ask that you read [*How To Ask Questions The Smart Way*](http://www.catb.org/~esr/faqs/smart-questions.html) (**This guide does not provide actual support services for this project!**), [How to Report Bugs Effectively](http://www.chiark.greenend.org.uk/~sgtatham/bugs.html) prior to posting. Well written bug reports help us help you!

Thank you to all the people who already contributed to StreamPark!

[![contrib graph](https://contrib.rocks/image?repo=apache/streampark)](https://github.com/apache/incubator-streampark/graphs/contributors)

## ⏰ Contributor Over Time

[![Stargazers Over Time](https://contributor-overtime-api.git-contributor.com/contributors-svg?chart=contributorOverTime&repo=apache/incubator-streampark)](https://git-contributor.com?chart=contributorOverTime&repo=apache/incubator-streampark)

## 👍Stargazers Over Time

![Stargazers over time](https://api.star-history.com/svg?repos=apache/incubator-streampark&type=Date)

## 💬 Social Media

- [Twitter](https://twitter.com/ASFStreamPark)
- [Zhihu](https://www.zhihu.com/people/streampark) (in Chinese)
- [bilibili](https://space.bilibili.com/455330087) (in Chinese)
- WeChat Official Account (in Chinese, scan the QR code to follow)

<img src="https://streampark.apache.org/image/wx_qr.png" alt="Join the Group" height="350px"><br>
