/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.jackrabbit.vault.packaging.impl.PackagePropertiesImpl;
import org.jetbrains.annotations.NotNull;

public class DefaultPackageProperties
extends PackagePropertiesImpl {
    private final Properties properties;

    @NotNull
    public static DefaultPackageProperties fromFile(Path path) throws IOException {
        return new DefaultPackageProperties(path);
    }

    @NotNull
    public static DefaultPackageProperties fromInputStream(InputStream input) throws IOException {
        return new DefaultPackageProperties(input);
    }

    private DefaultPackageProperties(InputStream input) throws IOException {
        this.properties = DefaultPackageProperties.getPropertiesMap(input);
    }

    private DefaultPackageProperties(Path path) throws IOException {
        try (InputStream fileInput = Files.newInputStream(path, new OpenOption[0]);){
            this.properties = DefaultPackageProperties.getPropertiesMap(fileInput);
        }
    }

    @Override
    protected Properties getPropertiesMap() {
        return this.properties;
    }

    protected static Properties getPropertiesMap(InputStream input) throws InvalidPropertiesFormatException, IOException {
        Properties propertyMap = new Properties();
        propertyMap.loadFromXML(new CloseShieldInputStream(input));
        return propertyMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPackageProperties other = (DefaultPackageProperties)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "DefaultPackageProperties [properties=" + this.properties + "]";
    }
}

