/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.DependencyValidator;
import org.jetbrains.annotations.NotNull;

public final class DependencyValidatorFactory
implements ValidatorFactory {
    public static final String ID = "jackrabbit-dependencies";
    public static final String OPTION_SEVERITY_FOR_UNRESOLVED_DEPENDENCIES = "severityForUnresolvedDependencies";
    private static final ValidationMessageSeverity DEFAULT_SEVERITY_FOR_UNRESOLVED_DEPENDENCIES = ValidationMessageSeverity.WARN;

    @Override
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        ValidationMessageSeverity severityForUnresolvedDependencies;
        if (settings.getOptions().containsKey(OPTION_SEVERITY_FOR_UNRESOLVED_DEPENDENCIES)) {
            String optionValue = settings.getOptions().get(OPTION_SEVERITY_FOR_UNRESOLVED_DEPENDENCIES);
            severityForUnresolvedDependencies = ValidationMessageSeverity.valueOf(optionValue.toUpperCase());
        } else {
            severityForUnresolvedDependencies = DEFAULT_SEVERITY_FOR_UNRESOLVED_DEPENDENCIES;
        }
        return new DependencyValidator(settings.getDefaultSeverity(), severityForUnresolvedDependencies, context.getDependenciesPackageInfo());
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public int getServiceRanking() {
        return 0;
    }
}

