/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.MediaTypeResolver;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class AbstractBlockingHttpVfs
extends AbstractHttpVfs {
    private final boolean directoryListingSupported;

    protected AbstractBlockingHttpVfs(boolean directoryListingSupported) {
        this.directoryListingSupported = directoryListingSupported;
    }

    @Override
    @Deprecated
    public final HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders) {
        return this.get(fileReadExecutor, path, clock, contentEncoding, additionalHeaders, MediaTypeResolver.ofDefault());
    }

    @Override
    public final HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(clock, "clock");
        Objects.requireNonNull(additionalHeaders, "additionalHeaders");
        return HttpFile.from(CompletableFuture.supplyAsync(() -> this.blockingGet(fileReadExecutor, path, clock, contentEncoding, additionalHeaders, mediaTypeResolver), fileReadExecutor));
    }

    protected abstract HttpFile blockingGet(Executor var1, String var2, Clock var3, @Nullable String var4, HttpHeaders var5, MediaTypeResolver var6);

    @Override
    public final CompletableFuture<Boolean> canList(Executor fileReadExecutor, String path) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(path, "path");
        if (this.directoryListingSupported) {
            return CompletableFuture.supplyAsync(() -> this.blockingCanList(fileReadExecutor, path), fileReadExecutor);
        }
        return super.canList(fileReadExecutor, path);
    }

    protected boolean blockingCanList(Executor fileReadExecutor, String path) {
        return false;
    }

    @Override
    public final CompletableFuture<List<String>> list(Executor fileReadExecutor, String path) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        Objects.requireNonNull(path, "path");
        if (this.directoryListingSupported) {
            return CompletableFuture.supplyAsync(() -> this.blockingList(fileReadExecutor, path), fileReadExecutor);
        }
        return super.list(fileReadExecutor, path);
    }

    protected List<String> blockingList(Executor fileReadExecutor, String path) {
        return ImmutableList.of();
    }
}

