/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.Empty;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteMessage;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteServiceGrpc;
import org.apache.skywalking.oap.server.library.client.grpc.GRPCClient;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCRemoteClient
implements RemoteClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCRemoteClient.class);
    private final int channelSize;
    private final int bufferSize;
    private final Address address;
    private final AtomicInteger concurrentStreamObserverNumber = new AtomicInteger(0);
    private SslContext sslContext;
    private GRPCClient client;
    private DataCarrier<RemoteMessage> carrier;
    private boolean isConnect;
    private CounterMetrics remoteOutCounter;
    private CounterMetrics remoteOutErrorCounter;
    private int remoteTimeout;
    private long lastRemoteResourceExhaustedTime = 0L;

    public GRPCRemoteClient(ModuleDefineHolder moduleDefineHolder, Address address, int channelSize, int bufferSize, int remoteTimeout, SslContext sslContext) {
        this.address = address;
        this.channelSize = channelSize;
        this.bufferSize = bufferSize;
        this.remoteTimeout = remoteTimeout;
        this.sslContext = sslContext;
        this.remoteOutCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_out_count", "The number(client side) of inside remote inside aggregate rpc.", new MetricsTag.Keys(new String[]{"dest", "self"}), new MetricsTag.Values(new String[]{address.toString(), "N"}));
        this.remoteOutErrorCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_out_error_count", "The error number(client side) of inside remote inside aggregate rpc.", new MetricsTag.Keys(new String[]{"dest", "self"}), new MetricsTag.Values(new String[]{address.toString(), "N"}));
    }

    @Override
    public void connect() {
        if (!this.isConnect) {
            this.getClient().connect();
            this.getDataCarrier().consume((IConsumer)new RemoteMessageConsumer(), 1);
            this.isConnect = true;
        }
    }

    ManagedChannel getChannel() {
        return this.getClient().getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GRPCClient getClient() {
        if (!Objects.isNull(this.client)) return this.client;
        Class<GRPCRemoteClient> clazz = GRPCRemoteClient.class;
        synchronized (GRPCRemoteClient.class) {
            if (!Objects.isNull(this.client)) return this.client;
            this.client = new GRPCClient(this.address.getHost(), this.address.getPort(), this.sslContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.client;
        }
    }

    RemoteServiceGrpc.RemoteServiceStub getStub() {
        return RemoteServiceGrpc.newStub((Channel)this.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DataCarrier<RemoteMessage> getDataCarrier() {
        if (!Objects.isNull(this.carrier)) return this.carrier;
        Class<GRPCRemoteClient> clazz = GRPCRemoteClient.class;
        synchronized (GRPCRemoteClient.class) {
            if (!Objects.isNull(this.carrier)) return this.carrier;
            this.carrier = new DataCarrier("GRPCRemoteClient", this.channelSize, this.bufferSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.carrier;
        }
    }

    @Override
    public void push(String nextWorkerName, StreamData streamData) {
        RemoteMessage.Builder builder = RemoteMessage.newBuilder();
        builder.setNextWorkerName(nextWorkerName);
        builder.setRemoteData(streamData.serialize());
        this.getDataCarrier().produce((Object)builder.build());
    }

    private StreamObserver<RemoteMessage> createStreamObserver() {
        int sleepTotalMillis = 0;
        int sleepMillis = 10;
        while (this.concurrentStreamObserverNumber.get() > 10) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if ((sleepTotalMillis += sleepMillis) <= 60000) continue;
            log.warn("Remote client [{}] block times over 60 seconds. Current streaming number {}", (Object)this.address, (Object)this.concurrentStreamObserverNumber.get());
            sleepTotalMillis = 0;
        }
        StreamObserver<RemoteMessage> remoteMessageStreamObserver = ((RemoteServiceGrpc.RemoteServiceStub)this.getStub().withDeadlineAfter(this.remoteTimeout, TimeUnit.SECONDS)).call(new StreamObserver<Empty>(){

            public void onNext(Empty empty) {
            }

            public void onError(Throwable throwable) {
                GRPCRemoteClient.this.concurrentStreamObserverNumber.addAndGet(-1);
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (log.isDebugEnabled()) {
                        log.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                if (Status.RESOURCE_EXHAUSTED.getCode() == status.getCode()) {
                    if (System.currentTimeMillis() - GRPCRemoteClient.this.lastRemoteResourceExhaustedTime > 120000L) {
                        log.warn(throwable.getMessage(), throwable);
                        GRPCRemoteClient.this.lastRemoteResourceExhaustedTime = System.currentTimeMillis();
                    }
                    return;
                }
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                GRPCRemoteClient.this.concurrentStreamObserverNumber.addAndGet(-1);
            }
        });
        this.concurrentStreamObserverNumber.incrementAndGet();
        return remoteMessageStreamObserver;
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.carrier)) {
            this.carrier.shutdownConsumers();
        }
        if (Objects.nonNull(this.client)) {
            this.client.shutdown();
        }
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public int compareTo(RemoteClient o) {
        return this.address.compareTo(o.getAddress());
    }

    class RemoteMessageConsumer
    implements IConsumer<RemoteMessage> {
        RemoteMessageConsumer() {
        }

        public void consume(List<RemoteMessage> remoteMessages) {
            try {
                StreamObserver<RemoteMessage> streamObserver = GRPCRemoteClient.this.createStreamObserver();
                for (RemoteMessage remoteMessage : remoteMessages) {
                    GRPCRemoteClient.this.remoteOutCounter.inc();
                    streamObserver.onNext((Object)remoteMessage);
                }
                streamObserver.onCompleted();
            }
            catch (Throwable t) {
                GRPCRemoteClient.this.remoteOutErrorCounter.inc();
                log.error(t.getMessage(), t);
            }
        }

        public void onError(List<RemoteMessage> remoteMessages, Throwable t) {
            log.error(t.getMessage(), t);
        }
    }
}

